// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworkscm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeNodeAssociationStatusInput struct {
	_ struct{} `type:"structure"`

	// The token returned in either the AssociateNodeResponse or the DisassociateNodeResponse.
	//
	// NodeAssociationStatusToken is a required field
	NodeAssociationStatusToken *string `type:"string" required:"true"`

	// The name of the server from which to disassociate the node.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeNodeAssociationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNodeAssociationStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeNodeAssociationStatusInput"}

	if s.NodeAssociationStatusToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("NodeAssociationStatusToken"))
	}

	if s.ServerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeNodeAssociationStatusOutput struct {
	_ struct{} `type:"structure"`

	// Attributes specific to the node association. In Puppet, the attibute PUPPET_NODE_CERT
	// contains the signed certificate (the result of the CSR).
	EngineAttributes []EngineAttribute `type:"list"`

	// The status of the association or disassociation request.
	//
	// Possible values:
	//
	//    * SUCCESS: The association or disassociation succeeded.
	//
	//    * FAILED: The association or disassociation failed.
	//
	//    * IN_PROGRESS: The association or disassociation is still in progress.
	NodeAssociationStatus NodeAssociationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeNodeAssociationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeNodeAssociationStatus = "DescribeNodeAssociationStatus"

// DescribeNodeAssociationStatusRequest returns a request value for making API operation for
// AWS OpsWorks CM.
//
// Returns the current status of an existing association or disassociation request.
//
// A ResourceNotFoundException is thrown when no recent association or disassociation
// request with the specified token is found, or when the server does not exist.
// A ValidationException is raised when parameters of the request are not valid.
//
//    // Example sending a request using DescribeNodeAssociationStatusRequest.
//    req := client.DescribeNodeAssociationStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeNodeAssociationStatus
func (c *Client) DescribeNodeAssociationStatusRequest(input *DescribeNodeAssociationStatusInput) DescribeNodeAssociationStatusRequest {
	op := &aws.Operation{
		Name:       opDescribeNodeAssociationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNodeAssociationStatusInput{}
	}

	req := c.newRequest(op, input, &DescribeNodeAssociationStatusOutput{})
	return DescribeNodeAssociationStatusRequest{Request: req, Input: input, Copy: c.DescribeNodeAssociationStatusRequest}
}

// DescribeNodeAssociationStatusRequest is the request type for the
// DescribeNodeAssociationStatus API operation.
type DescribeNodeAssociationStatusRequest struct {
	*aws.Request
	Input *DescribeNodeAssociationStatusInput
	Copy  func(*DescribeNodeAssociationStatusInput) DescribeNodeAssociationStatusRequest
}

// Send marshals and sends the DescribeNodeAssociationStatus API request.
func (r DescribeNodeAssociationStatusRequest) Send(ctx context.Context) (*DescribeNodeAssociationStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeNodeAssociationStatusResponse{
		DescribeNodeAssociationStatusOutput: r.Request.Data.(*DescribeNodeAssociationStatusOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeNodeAssociationStatusResponse is the response type for the
// DescribeNodeAssociationStatus API operation.
type DescribeNodeAssociationStatusResponse struct {
	*DescribeNodeAssociationStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeNodeAssociationStatus request.
func (r *DescribeNodeAssociationStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
