// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteEventTrackerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the event tracker to delete.
	//
	// EventTrackerArn is a required field
	EventTrackerArn *string `locationName:"eventTrackerArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventTrackerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEventTrackerInput"}

	if s.EventTrackerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventTrackerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteEventTrackerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEventTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteEventTracker = "DeleteEventTracker"

// DeleteEventTrackerRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Deletes the event tracker. Does not delete the event-interactions dataset
// from the associated dataset group. For more information on event trackers,
// see CreateEventTracker.
//
//    // Example sending a request using DeleteEventTrackerRequest.
//    req := client.DeleteEventTrackerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteEventTracker
func (c *Client) DeleteEventTrackerRequest(input *DeleteEventTrackerInput) DeleteEventTrackerRequest {
	op := &aws.Operation{
		Name:       opDeleteEventTracker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventTrackerInput{}
	}

	req := c.newRequest(op, input, &DeleteEventTrackerOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteEventTrackerRequest{Request: req, Input: input, Copy: c.DeleteEventTrackerRequest}
}

// DeleteEventTrackerRequest is the request type for the
// DeleteEventTracker API operation.
type DeleteEventTrackerRequest struct {
	*aws.Request
	Input *DeleteEventTrackerInput
	Copy  func(*DeleteEventTrackerInput) DeleteEventTrackerRequest
}

// Send marshals and sends the DeleteEventTracker API request.
func (r DeleteEventTrackerRequest) Send(ctx context.Context) (*DeleteEventTrackerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteEventTrackerResponse{
		DeleteEventTrackerOutput: r.Request.Data.(*DeleteEventTrackerOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteEventTrackerResponse is the response type for the
// DeleteEventTracker API operation.
type DeleteEventTrackerResponse struct {
	*DeleteEventTrackerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteEventTracker request.
func (r *DeleteEventTrackerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
