// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetChannelsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetChannelsInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetChannelsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetChannelsOutput struct {
	_ struct{} `type:"structure" payload:"ChannelsResponse"`

	// Provides information about the general settings and status of all channels
	// for an application, including channels that aren't enabled for the application.
	//
	// ChannelsResponse is a required field
	ChannelsResponse *ChannelsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetChannelsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChannelsResponse != nil {
		v := s.ChannelsResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "ChannelsResponse", v, metadata)
	}
	return nil
}

const opGetChannels = "GetChannels"

// GetChannelsRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves information about the history and status of each channel for an
// application.
//
//    // Example sending a request using GetChannelsRequest.
//    req := client.GetChannelsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels
func (c *Client) GetChannelsRequest(input *GetChannelsInput) GetChannelsRequest {
	op := &aws.Operation{
		Name:       opGetChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels",
	}

	if input == nil {
		input = &GetChannelsInput{}
	}

	req := c.newRequest(op, input, &GetChannelsOutput{})
	return GetChannelsRequest{Request: req, Input: input, Copy: c.GetChannelsRequest}
}

// GetChannelsRequest is the request type for the
// GetChannels API operation.
type GetChannelsRequest struct {
	*aws.Request
	Input *GetChannelsInput
	Copy  func(*GetChannelsInput) GetChannelsRequest
}

// Send marshals and sends the GetChannels API request.
func (r GetChannelsRequest) Send(ctx context.Context) (*GetChannelsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetChannelsResponse{
		GetChannelsOutput: r.Request.Data.(*GetChannelsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetChannelsResponse is the response type for the
// GetChannels API operation.
type GetChannelsResponse struct {
	*GetChannelsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetChannels request.
func (r *GetChannelsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
