// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeTemplateInput struct {
	_ struct{} `type:"structure"`

	// The alias of the template that you want to describe. If you name a specific
	// alias, you describe the version that the alias points to. You can specify
	// the latest version of the template by providing the keyword $LATEST in the
	// AliasName parameter. The keyword $PUBLISHED doesn't apply to templates.
	AliasName *string `location:"querystring" locationName:"alias-name" min:"1" type:"string"`

	// The ID of the AWS account that contains the template that you're describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// (Optional) The number for the version to describe. If a VersionNumber parameter
	// value isn't provided, the latest version of the template is described.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation
func (s DescribeTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTemplateInput"}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AliasName", 1))
	}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.TemplateId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateId != nil {
		v := *s.TemplateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "TemplateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AliasName != nil {
		v := *s.AliasName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "alias-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version-number", protocol.Int64Value(v), metadata)
	}
	return nil
}

type DescribeTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The template structure for the object you want to describe.
	Template *Template `type:"structure"`
}

// String returns the string representation
func (s DescribeTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Template != nil {
		v := s.Template

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Template", v, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opDescribeTemplate = "DescribeTemplate"

// DescribeTemplateRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Describes a template's metadata.
//
//    // Example sending a request using DescribeTemplateRequest.
//    req := client.DescribeTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate
func (c *Client) DescribeTemplateRequest(input *DescribeTemplateInput) DescribeTemplateRequest {
	op := &aws.Operation{
		Name:       opDescribeTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &DescribeTemplateInput{}
	}

	req := c.newRequest(op, input, &DescribeTemplateOutput{})
	return DescribeTemplateRequest{Request: req, Input: input, Copy: c.DescribeTemplateRequest}
}

// DescribeTemplateRequest is the request type for the
// DescribeTemplate API operation.
type DescribeTemplateRequest struct {
	*aws.Request
	Input *DescribeTemplateInput
	Copy  func(*DescribeTemplateInput) DescribeTemplateRequest
}

// Send marshals and sends the DescribeTemplate API request.
func (r DescribeTemplateRequest) Send(ctx context.Context) (*DescribeTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTemplateResponse{
		DescribeTemplateOutput: r.Request.Data.(*DescribeTemplateOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTemplateResponse is the response type for the
// DescribeTemplate API operation.
type DescribeTemplateResponse struct {
	*DescribeTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTemplate request.
func (r *DescribeTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
