// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeTemplateAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the template alias that you want to describe. If you name a specific
	// alias, you describe the version that the alias points to. You can specify
	// the latest version of the template by providing the keyword $LATEST in the
	// AliasName parameter. The keyword $PUBLISHED doesn't apply to templates.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// The ID of the AWS account that contains the template alias that you're describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTemplateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTemplateAliasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTemplateAliasInput"}

	if s.AliasName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AliasName", 1))
	}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.TemplateId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeTemplateAliasInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AliasName != nil {
		v := *s.AliasName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AliasName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateId != nil {
		v := *s.TemplateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "TemplateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeTemplateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// Information about the template alias.
	TemplateAlias *TemplateAlias `type:"structure"`
}

// String returns the string representation
func (s DescribeTemplateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeTemplateAliasOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateAlias != nil {
		v := s.TemplateAlias

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TemplateAlias", v, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opDescribeTemplateAlias = "DescribeTemplateAlias"

// DescribeTemplateAliasRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Describes the template alias for a template.
//
//    // Example sending a request using DescribeTemplateAliasRequest.
//    req := client.DescribeTemplateAliasRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias
func (c *Client) DescribeTemplateAliasRequest(input *DescribeTemplateAliasInput) DescribeTemplateAliasRequest {
	op := &aws.Operation{
		Name:       opDescribeTemplateAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DescribeTemplateAliasInput{}
	}

	req := c.newRequest(op, input, &DescribeTemplateAliasOutput{})
	return DescribeTemplateAliasRequest{Request: req, Input: input, Copy: c.DescribeTemplateAliasRequest}
}

// DescribeTemplateAliasRequest is the request type for the
// DescribeTemplateAlias API operation.
type DescribeTemplateAliasRequest struct {
	*aws.Request
	Input *DescribeTemplateAliasInput
	Copy  func(*DescribeTemplateAliasInput) DescribeTemplateAliasRequest
}

// Send marshals and sends the DescribeTemplateAlias API request.
func (r DescribeTemplateAliasRequest) Send(ctx context.Context) (*DescribeTemplateAliasResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTemplateAliasResponse{
		DescribeTemplateAliasOutput: r.Request.Data.(*DescribeTemplateAliasOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTemplateAliasResponse is the response type for the
// DescribeTemplateAlias API operation.
type DescribeTemplateAliasResponse struct {
	*DescribeTemplateAliasOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTemplateAlias request.
func (r *DescribeTemplateAliasResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
