// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeStreamProcessorInput struct {
	_ struct{} `type:"structure"`

	// Name of the stream processor for which you want information.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStreamProcessorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStreamProcessorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeStreamProcessorInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeStreamProcessorOutput struct {
	_ struct{} `type:"structure"`

	// Date and time the stream processor was created
	CreationTimestamp *time.Time `type:"timestamp"`

	// Kinesis video stream that provides the source streaming video.
	Input *StreamProcessorInput `type:"structure"`

	// The time, in Unix format, the stream processor was last updated. For example,
	// when the stream processor moves from a running state to a failed state, or
	// when the user starts or stops the stream processor.
	LastUpdateTimestamp *time.Time `type:"timestamp"`

	// Name of the stream processor.
	Name *string `min:"1" type:"string"`

	// Kinesis data stream to which Amazon Rekognition Video puts the analysis results.
	Output *StreamProcessorOutput `type:"structure"`

	// ARN of the IAM role that allows access to the stream processor.
	RoleArn *string `type:"string"`

	// Face recognition input parameters that are being used by the stream processor.
	// Includes the collection to use for face recognition and the face attributes
	// to detect.
	Settings *StreamProcessorSettings `type:"structure"`

	// Current status of the stream processor.
	Status StreamProcessorStatus `type:"string" enum:"true"`

	// Detailed status message about the stream processor.
	StatusMessage *string `type:"string"`

	// ARN of the stream processor.
	StreamProcessorArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeStreamProcessorOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeStreamProcessor = "DescribeStreamProcessor"

// DescribeStreamProcessorRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Provides information about a stream processor created by CreateStreamProcessor.
// You can get information about the input and output streams, the input parameters
// for the face recognition being performed, and the current status of the stream
// processor.
//
//    // Example sending a request using DescribeStreamProcessorRequest.
//    req := client.DescribeStreamProcessorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeStreamProcessorRequest(input *DescribeStreamProcessorInput) DescribeStreamProcessorRequest {
	op := &aws.Operation{
		Name:       opDescribeStreamProcessor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStreamProcessorInput{}
	}

	req := c.newRequest(op, input, &DescribeStreamProcessorOutput{})
	return DescribeStreamProcessorRequest{Request: req, Input: input, Copy: c.DescribeStreamProcessorRequest}
}

// DescribeStreamProcessorRequest is the request type for the
// DescribeStreamProcessor API operation.
type DescribeStreamProcessorRequest struct {
	*aws.Request
	Input *DescribeStreamProcessorInput
	Copy  func(*DescribeStreamProcessorInput) DescribeStreamProcessorRequest
}

// Send marshals and sends the DescribeStreamProcessor API request.
func (r DescribeStreamProcessorRequest) Send(ctx context.Context) (*DescribeStreamProcessorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeStreamProcessorResponse{
		DescribeStreamProcessorOutput: r.Request.Data.(*DescribeStreamProcessorOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeStreamProcessorResponse is the response type for the
// DescribeStreamProcessor API operation.
type DescribeStreamProcessorResponse struct {
	*DescribeStreamProcessorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeStreamProcessor request.
func (r *DescribeStreamProcessorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
