// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package robomaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type BatchDescribeSimulationJobInput struct {
	_ struct{} `type:"structure"`

	// A list of Amazon Resource Names (ARNs) of simulation jobs to describe.
	//
	// Jobs is a required field
	Jobs []string `locationName:"jobs" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDescribeSimulationJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDescribeSimulationJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchDescribeSimulationJobInput"}

	if s.Jobs == nil {
		invalidParams.Add(aws.NewErrParamRequired("Jobs"))
	}
	if s.Jobs != nil && len(s.Jobs) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Jobs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDescribeSimulationJobInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Jobs != nil {
		v := s.Jobs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "jobs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

type BatchDescribeSimulationJobOutput struct {
	_ struct{} `type:"structure"`

	// A list of simulation jobs.
	Jobs []SimulationJob `locationName:"jobs" type:"list"`

	// A list of unprocessed simulation job Amazon Resource Names (ARNs).
	UnprocessedJobs []string `locationName:"unprocessedJobs" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchDescribeSimulationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchDescribeSimulationJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Jobs != nil {
		v := s.Jobs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "jobs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.UnprocessedJobs != nil {
		v := s.UnprocessedJobs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "unprocessedJobs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

const opBatchDescribeSimulationJob = "BatchDescribeSimulationJob"

// BatchDescribeSimulationJobRequest returns a request value for making API operation for
// AWS RoboMaker.
//
// Describes one or more simulation jobs.
//
//    // Example sending a request using BatchDescribeSimulationJobRequest.
//    req := client.BatchDescribeSimulationJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDescribeSimulationJob
func (c *Client) BatchDescribeSimulationJobRequest(input *BatchDescribeSimulationJobInput) BatchDescribeSimulationJobRequest {
	op := &aws.Operation{
		Name:       opBatchDescribeSimulationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/batchDescribeSimulationJob",
	}

	if input == nil {
		input = &BatchDescribeSimulationJobInput{}
	}

	req := c.newRequest(op, input, &BatchDescribeSimulationJobOutput{})
	return BatchDescribeSimulationJobRequest{Request: req, Input: input, Copy: c.BatchDescribeSimulationJobRequest}
}

// BatchDescribeSimulationJobRequest is the request type for the
// BatchDescribeSimulationJob API operation.
type BatchDescribeSimulationJobRequest struct {
	*aws.Request
	Input *BatchDescribeSimulationJobInput
	Copy  func(*BatchDescribeSimulationJobInput) BatchDescribeSimulationJobRequest
}

// Send marshals and sends the BatchDescribeSimulationJob API request.
func (r BatchDescribeSimulationJobRequest) Send(ctx context.Context) (*BatchDescribeSimulationJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchDescribeSimulationJobResponse{
		BatchDescribeSimulationJobOutput: r.Request.Data.(*BatchDescribeSimulationJobOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchDescribeSimulationJobResponse is the response type for the
// BatchDescribeSimulationJob API operation.
type BatchDescribeSimulationJobResponse struct {
	*BatchDescribeSimulationJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchDescribeSimulationJob request.
func (r *BatchDescribeSimulationJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
