// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request for the resource record sets that are associated with a specified
// hosted zone.
type ListResourceRecordSetsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone that contains the resource record sets that you
	// want to list.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// (Optional) The maximum number of resource records sets to include in the
	// response body for this request. If the response includes more than maxitems
	// resource record sets, the value of the IsTruncated element in the response
	// is true, and the values of the NextRecordName and NextRecordType elements
	// in the response identify the first resource record set in the next group
	// of maxitems resource record sets.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// Resource record sets that have a routing policy other than simple: If results
	// were truncated for a given DNS name and type, specify the value of NextRecordIdentifier
	// from the previous response to get the next resource record set that has the
	// current DNS name and type.
	StartRecordIdentifier *string `location:"querystring" locationName:"identifier" min:"1" type:"string"`

	// The first name in the lexicographic ordering of resource record sets that
	// you want to list.
	StartRecordName *string `location:"querystring" locationName:"name" type:"string"`

	// The type of resource record set to begin the record listing from.
	//
	// Valid values for basic resource record sets: A | AAAA | CAA | CNAME | MX
	// | NAPTR | NS | PTR | SOA | SPF | SRV | TXT
	//
	// Values for weighted, latency, geolocation, and failover resource record sets:
	// A | AAAA | CAA | CNAME | MX | NAPTR | PTR | SPF | SRV | TXT
	//
	// Values for alias resource record sets:
	//
	//    * API Gateway custom regional API or edge-optimized API: A
	//
	//    * CloudFront distribution: A or AAAA
	//
	//    * Elastic Beanstalk environment that has a regionalized subdomain: A
	//
	//    * Elastic Load Balancing load balancer: A | AAAA
	//
	//    * Amazon S3 bucket: A
	//
	//    * Amazon VPC interface VPC endpoint: A
	//
	//    * Another resource record set in this hosted zone: The type of the resource
	//    record set that the alias references.
	//
	// Constraint: Specifying type without specifying name returns an InvalidInput
	// error.
	StartRecordType RRType `location:"querystring" locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListResourceRecordSetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceRecordSetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListResourceRecordSetsInput"}

	if s.HostedZoneId == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostedZoneId"))
	}
	if s.StartRecordIdentifier != nil && len(*s.StartRecordIdentifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StartRecordIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListResourceRecordSetsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxitems", protocol.StringValue(v), metadata)
	}
	if s.StartRecordIdentifier != nil {
		v := *s.StartRecordIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "identifier", protocol.StringValue(v), metadata)
	}
	if s.StartRecordName != nil {
		v := *s.StartRecordName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "name", protocol.StringValue(v), metadata)
	}
	if len(s.StartRecordType) > 0 {
		v := s.StartRecordType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "type", v, metadata)
	}
	return nil
}

// A complex type that contains list information for the resource record set.
type ListResourceRecordSetsOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more resource record sets remain to be listed.
	// If your results were truncated, you can make a follow-up pagination request
	// by using the NextRecordName element.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The maximum number of records you requested.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// Resource record sets that have a routing policy other than simple: If results
	// were truncated for a given DNS name and type, the value of SetIdentifier
	// for the next resource record set that has the current DNS name and type.
	//
	// For information about routing policies, see Choosing a Routing Policy (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html)
	// in the Amazon Route 53 Developer Guide.
	NextRecordIdentifier *string `min:"1" type:"string"`

	// If the results were truncated, the name of the next record in the list.
	//
	// This element is present only if IsTruncated is true.
	NextRecordName *string `type:"string"`

	// If the results were truncated, the type of the next record in the list.
	//
	// This element is present only if IsTruncated is true.
	NextRecordType RRType `type:"string" enum:"true"`

	// Information about multiple resource record sets.
	//
	// ResourceRecordSets is a required field
	ResourceRecordSets []ResourceRecordSet `locationNameList:"ResourceRecordSet" type:"list" required:"true"`
}

// String returns the string representation
func (s ListResourceRecordSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListResourceRecordSetsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxItems", protocol.StringValue(v), metadata)
	}
	if s.NextRecordIdentifier != nil {
		v := *s.NextRecordIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextRecordIdentifier", protocol.StringValue(v), metadata)
	}
	if s.NextRecordName != nil {
		v := *s.NextRecordName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextRecordName", protocol.StringValue(v), metadata)
	}
	if len(s.NextRecordType) > 0 {
		v := s.NextRecordType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextRecordType", v, metadata)
	}
	if s.ResourceRecordSets != nil {
		v := s.ResourceRecordSets

		metadata := protocol.Metadata{ListLocationName: "ResourceRecordSet"}
		ls0 := e.List(protocol.BodyTarget, "ResourceRecordSets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListResourceRecordSets = "ListResourceRecordSets"

// ListResourceRecordSetsRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Lists the resource record sets in a specified hosted zone.
//
// ListResourceRecordSets returns up to 100 resource record sets at a time in
// ASCII order, beginning at a position specified by the name and type elements.
//
// Sort order
//
// ListResourceRecordSets sorts results first by DNS name with the labels reversed,
// for example:
//
// com.example.www.
//
// Note the trailing dot, which can change the sort order when the record name
// contains characters that appear before . (decimal 46) in the ASCII table.
// These characters include the following: ! " # $ % & ' ( ) * + , -
//
// When multiple records have the same DNS name, ListResourceRecordSets sorts
// results by the record type.
//
// Specifying where to start listing records
//
// You can use the name and type elements to specify the resource record set
// that the list begins with:
//
// If you do not specify Name or Type
//
// The results begin with the first resource record set that the hosted zone
// contains.
//
// If you specify Name but not Type
//
// The results begin with the first resource record set in the list whose name
// is greater than or equal to Name.
//
// If you specify Type but not Name
//
// Amazon Route 53 returns the InvalidInput error.
//
// If you specify both Name and Type
//
// The results begin with the first resource record set in the list whose name
// is greater than or equal to Name, and whose type is greater than or equal
// to Type.
//
// Resource record sets that are PENDING
//
// This action returns the most current version of the records. This includes
// records that are PENDING, and that are not yet available on all Route 53
// DNS servers.
//
// Changing resource record sets
//
// To ensure that you get an accurate listing of the resource record sets for
// a hosted zone at a point in time, do not submit a ChangeResourceRecordSets
// request while you're paging through the results of a ListResourceRecordSets
// request. If you do, some pages may display results without the latest changes
// while other pages display results with the latest changes.
//
// Displaying the next page of results
//
// If a ListResourceRecordSets command returns more than one page of results,
// the value of IsTruncated is true. To display the next page of results, get
// the values of NextRecordName, NextRecordType, and NextRecordIdentifier (if
// any) from the response. Then submit another ListResourceRecordSets request,
// and specify those values for StartRecordName, StartRecordType, and StartRecordIdentifier.
//
//    // Example sending a request using ListResourceRecordSetsRequest.
//    req := client.ListResourceRecordSetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListResourceRecordSets
func (c *Client) ListResourceRecordSetsRequest(input *ListResourceRecordSetsInput) ListResourceRecordSetsRequest {
	op := &aws.Operation{
		Name:       opListResourceRecordSets,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/rrset",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"StartRecordName", "StartRecordType", "StartRecordIdentifier"},
			OutputTokens:    []string{"NextRecordName", "NextRecordType", "NextRecordIdentifier"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListResourceRecordSetsInput{}
	}

	req := c.newRequest(op, input, &ListResourceRecordSetsOutput{})
	return ListResourceRecordSetsRequest{Request: req, Input: input, Copy: c.ListResourceRecordSetsRequest}
}

// ListResourceRecordSetsRequest is the request type for the
// ListResourceRecordSets API operation.
type ListResourceRecordSetsRequest struct {
	*aws.Request
	Input *ListResourceRecordSetsInput
	Copy  func(*ListResourceRecordSetsInput) ListResourceRecordSetsRequest
}

// Send marshals and sends the ListResourceRecordSets API request.
func (r ListResourceRecordSetsRequest) Send(ctx context.Context) (*ListResourceRecordSetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListResourceRecordSetsResponse{
		ListResourceRecordSetsOutput: r.Request.Data.(*ListResourceRecordSetsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListResourceRecordSetsRequestPaginator returns a paginator for ListResourceRecordSets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListResourceRecordSetsRequest(input)
//   p := route53.NewListResourceRecordSetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListResourceRecordSetsPaginator(req ListResourceRecordSetsRequest) ListResourceRecordSetsPaginator {
	return ListResourceRecordSetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListResourceRecordSetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListResourceRecordSetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListResourceRecordSetsPaginator struct {
	aws.Pager
}

func (p *ListResourceRecordSetsPaginator) CurrentPage() *ListResourceRecordSetsOutput {
	return p.Pager.CurrentPage().(*ListResourceRecordSetsOutput)
}

// ListResourceRecordSetsResponse is the response type for the
// ListResourceRecordSets API operation.
type ListResourceRecordSetsResponse struct {
	*ListResourceRecordSetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListResourceRecordSets request.
func (r *ListResourceRecordSetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
