// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53domains

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetContactReachabilityStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain for which you want to know whether the registrant
	// contact has confirmed that the email address is valid.
	DomainName *string `locationName:"domainName" type:"string"`
}

// String returns the string representation
func (s GetContactReachabilityStatusInput) String() string {
	return awsutil.Prettify(s)
}

type GetContactReachabilityStatusOutput struct {
	_ struct{} `type:"structure"`

	// The domain name for which you requested the reachability status.
	DomainName *string `locationName:"domainName" type:"string"`

	// Whether the registrant contact has responded. Values include the following:
	//
	// PENDING
	//
	// We sent the confirmation email and haven't received a response yet.
	//
	// DONE
	//
	// We sent the email and got confirmation from the registrant contact.
	//
	// EXPIRED
	//
	// The time limit expired before the registrant contact responded.
	Status ReachabilityStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s GetContactReachabilityStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetContactReachabilityStatus = "GetContactReachabilityStatus"

// GetContactReachabilityStatusRequest returns a request value for making API operation for
// Amazon Route 53 Domains.
//
// For operations that require confirmation that the email address for the registrant
// contact is valid, such as registering a new domain, this operation returns
// information about whether the registrant contact has responded.
//
// If you want us to resend the email, use the ResendContactReachabilityEmail
// operation.
//
//    // Example sending a request using GetContactReachabilityStatusRequest.
//    req := client.GetContactReachabilityStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetContactReachabilityStatus
func (c *Client) GetContactReachabilityStatusRequest(input *GetContactReachabilityStatusInput) GetContactReachabilityStatusRequest {
	op := &aws.Operation{
		Name:       opGetContactReachabilityStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContactReachabilityStatusInput{}
	}

	req := c.newRequest(op, input, &GetContactReachabilityStatusOutput{})
	return GetContactReachabilityStatusRequest{Request: req, Input: input, Copy: c.GetContactReachabilityStatusRequest}
}

// GetContactReachabilityStatusRequest is the request type for the
// GetContactReachabilityStatus API operation.
type GetContactReachabilityStatusRequest struct {
	*aws.Request
	Input *GetContactReachabilityStatusInput
	Copy  func(*GetContactReachabilityStatusInput) GetContactReachabilityStatusRequest
}

// Send marshals and sends the GetContactReachabilityStatus API request.
func (r GetContactReachabilityStatusRequest) Send(ctx context.Context) (*GetContactReachabilityStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetContactReachabilityStatusResponse{
		GetContactReachabilityStatusOutput: r.Request.Data.(*GetContactReachabilityStatusOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetContactReachabilityStatusResponse is the response type for the
// GetContactReachabilityStatus API operation.
type GetContactReachabilityStatusResponse struct {
	*GetContactReachabilityStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetContactReachabilityStatus request.
func (r *GetContactReachabilityStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
