// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteExperimentInput struct {
	_ struct{} `type:"structure"`

	// The name of the experiment to delete.
	//
	// ExperimentName is a required field
	ExperimentName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteExperimentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteExperimentInput"}

	if s.ExperimentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExperimentName"))
	}
	if s.ExperimentName != nil && len(*s.ExperimentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExperimentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteExperimentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the experiment that is being deleted.
	ExperimentArn *string `type:"string"`
}

// String returns the string representation
func (s DeleteExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteExperiment = "DeleteExperiment"

// DeleteExperimentRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Deletes an Amazon SageMaker experiment. All trials associated with the experiment
// must be deleted first. Use the ListTrials API to get a list of the trials
// associated with the experiment.
//
//    // Example sending a request using DeleteExperimentRequest.
//    req := client.DeleteExperimentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteExperiment
func (c *Client) DeleteExperimentRequest(input *DeleteExperimentInput) DeleteExperimentRequest {
	op := &aws.Operation{
		Name:       opDeleteExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteExperimentInput{}
	}

	req := c.newRequest(op, input, &DeleteExperimentOutput{})
	return DeleteExperimentRequest{Request: req, Input: input, Copy: c.DeleteExperimentRequest}
}

// DeleteExperimentRequest is the request type for the
// DeleteExperiment API operation.
type DeleteExperimentRequest struct {
	*aws.Request
	Input *DeleteExperimentInput
	Copy  func(*DeleteExperimentInput) DeleteExperimentRequest
}

// Send marshals and sends the DeleteExperiment API request.
func (r DeleteExperimentRequest) Send(ctx context.Context) (*DeleteExperimentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteExperimentResponse{
		DeleteExperimentOutput: r.Request.Data.(*DeleteExperimentOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteExperimentResponse is the response type for the
// DeleteExperiment API operation.
type DeleteExperimentResponse struct {
	*DeleteExperimentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteExperiment request.
func (r *DeleteExperimentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
