// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteTrialInput struct {
	_ struct{} `type:"structure"`

	// The name of the trial to delete.
	//
	// TrialName is a required field
	TrialName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrialInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrialInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTrialInput"}

	if s.TrialName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrialName"))
	}
	if s.TrialName != nil && len(*s.TrialName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrialName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTrialOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the trial that is being deleted.
	TrialArn *string `type:"string"`
}

// String returns the string representation
func (s DeleteTrialOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteTrial = "DeleteTrial"

// DeleteTrialRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Deletes the specified trial. All trial components that make up the trial
// must be deleted first. Use the DescribeTrialComponent API to get the list
// of trial components.
//
//    // Example sending a request using DeleteTrialRequest.
//    req := client.DeleteTrialRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrial
func (c *Client) DeleteTrialRequest(input *DeleteTrialInput) DeleteTrialRequest {
	op := &aws.Operation{
		Name:       opDeleteTrial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrialInput{}
	}

	req := c.newRequest(op, input, &DeleteTrialOutput{})
	return DeleteTrialRequest{Request: req, Input: input, Copy: c.DeleteTrialRequest}
}

// DeleteTrialRequest is the request type for the
// DeleteTrial API operation.
type DeleteTrialRequest struct {
	*aws.Request
	Input *DeleteTrialInput
	Copy  func(*DeleteTrialInput) DeleteTrialRequest
}

// Send marshals and sends the DeleteTrial API request.
func (r DeleteTrialRequest) Send(ctx context.Context) (*DeleteTrialResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTrialResponse{
		DeleteTrialOutput: r.Request.Data.(*DeleteTrialOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTrialResponse is the response type for the
// DeleteTrial API operation.
type DeleteTrialResponse struct {
	*DeleteTrialOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTrial request.
func (r *DeleteTrialResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
