// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListPortfolioAccessInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPortfolioAccessInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPortfolioAccessInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPortfolioAccessInput"}

	if s.PortfolioId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListPortfolioAccessOutput struct {
	_ struct{} `type:"structure"`

	// Information about the AWS accounts with access to the portfolio.
	AccountIds []string `type:"list"`

	// The page token to use to retrieve the next set of results. If there are no
	// additional results, this value is null.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s ListPortfolioAccessOutput) String() string {
	return awsutil.Prettify(s)
}

const opListPortfolioAccess = "ListPortfolioAccess"

// ListPortfolioAccessRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Lists the account IDs that have access to the specified portfolio.
//
//    // Example sending a request using ListPortfolioAccessRequest.
//    req := client.ListPortfolioAccessRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess
func (c *Client) ListPortfolioAccessRequest(input *ListPortfolioAccessInput) ListPortfolioAccessRequest {
	op := &aws.Operation{
		Name:       opListPortfolioAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPortfolioAccessInput{}
	}

	req := c.newRequest(op, input, &ListPortfolioAccessOutput{})
	return ListPortfolioAccessRequest{Request: req, Input: input, Copy: c.ListPortfolioAccessRequest}
}

// ListPortfolioAccessRequest is the request type for the
// ListPortfolioAccess API operation.
type ListPortfolioAccessRequest struct {
	*aws.Request
	Input *ListPortfolioAccessInput
	Copy  func(*ListPortfolioAccessInput) ListPortfolioAccessRequest
}

// Send marshals and sends the ListPortfolioAccess API request.
func (r ListPortfolioAccessRequest) Send(ctx context.Context) (*ListPortfolioAccessResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPortfolioAccessResponse{
		ListPortfolioAccessOutput: r.Request.Data.(*ListPortfolioAccessOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListPortfolioAccessResponse is the response type for the
// ListPortfolioAccess API operation.
type ListPortfolioAccessResponse struct {
	*ListPortfolioAccessOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPortfolioAccess request.
func (r *ListPortfolioAccessResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
