// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListProvisioningArtifactsInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListProvisioningArtifactsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProvisioningArtifactsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListProvisioningArtifactsInput"}

	if s.ProductId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListProvisioningArtifactsOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next set of results. If there are no
	// additional results, this value is null.
	NextPageToken *string `type:"string"`

	// Information about the provisioning artifacts.
	ProvisioningArtifactDetails []ProvisioningArtifactDetail `type:"list"`
}

// String returns the string representation
func (s ListProvisioningArtifactsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListProvisioningArtifacts = "ListProvisioningArtifacts"

// ListProvisioningArtifactsRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Lists all provisioning artifacts (also known as versions) for the specified
// product.
//
//    // Example sending a request using ListProvisioningArtifactsRequest.
//    req := client.ListProvisioningArtifactsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifacts
func (c *Client) ListProvisioningArtifactsRequest(input *ListProvisioningArtifactsInput) ListProvisioningArtifactsRequest {
	op := &aws.Operation{
		Name:       opListProvisioningArtifacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListProvisioningArtifactsInput{}
	}

	req := c.newRequest(op, input, &ListProvisioningArtifactsOutput{})
	return ListProvisioningArtifactsRequest{Request: req, Input: input, Copy: c.ListProvisioningArtifactsRequest}
}

// ListProvisioningArtifactsRequest is the request type for the
// ListProvisioningArtifacts API operation.
type ListProvisioningArtifactsRequest struct {
	*aws.Request
	Input *ListProvisioningArtifactsInput
	Copy  func(*ListProvisioningArtifactsInput) ListProvisioningArtifactsRequest
}

// Send marshals and sends the ListProvisioningArtifacts API request.
func (r ListProvisioningArtifactsRequest) Send(ctx context.Context) (*ListProvisioningArtifactsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListProvisioningArtifactsResponse{
		ListProvisioningArtifactsOutput: r.Request.Data.(*ListProvisioningArtifactsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListProvisioningArtifactsResponse is the response type for the
// ListProvisioningArtifacts API operation.
type ListProvisioningArtifactsResponse struct {
	*ListProvisioningArtifactsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListProvisioningArtifacts request.
func (r *ListProvisioningArtifactsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
