// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreatePrivateDnsNamespaceInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed CreatePrivateDnsNamespace
	// requests to be retried without the risk of executing the operation twice.
	// CreatorRequestId can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `type:"string" idempotencyToken:"true"`

	// A description for the namespace.
	Description *string `type:"string"`

	// The name that you want to assign to this namespace. When you create a private
	// DNS namespace, AWS Cloud Map automatically creates an Amazon Route 53 private
	// hosted zone that has the same name as the namespace.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The ID of the Amazon VPC that you want to associate the namespace with.
	//
	// Vpc is a required field
	Vpc *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePrivateDnsNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePrivateDnsNamespaceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreatePrivateDnsNamespaceInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Vpc == nil {
		invalidParams.Add(aws.NewErrParamRequired("Vpc"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreatePrivateDnsNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation.
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s CreatePrivateDnsNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreatePrivateDnsNamespace = "CreatePrivateDnsNamespace"

// CreatePrivateDnsNamespaceRequest returns a request value for making API operation for
// AWS Cloud Map.
//
// Creates a private namespace based on DNS, which will be visible only inside
// a specified Amazon VPC. The namespace defines your service naming scheme.
// For example, if you name your namespace example.com and name your service
// backend, the resulting DNS name for the service will be backend.example.com.
// For the current limit on the number of namespaces that you can create using
// the same AWS account, see AWS Cloud Map Limits (http://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
// in the AWS Cloud Map Developer Guide.
//
//    // Example sending a request using CreatePrivateDnsNamespaceRequest.
//    req := client.CreatePrivateDnsNamespaceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePrivateDnsNamespace
func (c *Client) CreatePrivateDnsNamespaceRequest(input *CreatePrivateDnsNamespaceInput) CreatePrivateDnsNamespaceRequest {
	op := &aws.Operation{
		Name:       opCreatePrivateDnsNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePrivateDnsNamespaceInput{}
	}

	req := c.newRequest(op, input, &CreatePrivateDnsNamespaceOutput{})
	return CreatePrivateDnsNamespaceRequest{Request: req, Input: input, Copy: c.CreatePrivateDnsNamespaceRequest}
}

// CreatePrivateDnsNamespaceRequest is the request type for the
// CreatePrivateDnsNamespace API operation.
type CreatePrivateDnsNamespaceRequest struct {
	*aws.Request
	Input *CreatePrivateDnsNamespaceInput
	Copy  func(*CreatePrivateDnsNamespaceInput) CreatePrivateDnsNamespaceRequest
}

// Send marshals and sends the CreatePrivateDnsNamespace API request.
func (r CreatePrivateDnsNamespaceRequest) Send(ctx context.Context) (*CreatePrivateDnsNamespaceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreatePrivateDnsNamespaceResponse{
		CreatePrivateDnsNamespaceOutput: r.Request.Data.(*CreatePrivateDnsNamespaceOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreatePrivateDnsNamespaceResponse is the response type for the
// CreatePrivateDnsNamespace API operation.
type CreatePrivateDnsNamespaceResponse struct {
	*CreatePrivateDnsNamespaceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreatePrivateDnsNamespace request.
func (r *CreatePrivateDnsNamespaceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
