// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to update a receipt rule. You use receipt rules to receive
// email with Amazon SES. For more information, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
type UpdateReceiptRuleInput struct {
	_ struct{} `type:"structure"`

	// A data structure that contains the updated receipt rule information.
	//
	// Rule is a required field
	Rule *ReceiptRule `type:"structure" required:"true"`

	// The name of the receipt rule set that the receipt rule belongs to.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReceiptRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateReceiptRuleInput"}

	if s.Rule == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rule"))
	}

	if s.RuleSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleSetName"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element returned on a successful request.
type UpdateReceiptRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateReceiptRule = "UpdateReceiptRule"

// UpdateReceiptRuleRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Updates a receipt rule.
//
// For information about managing receipt rules, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html).
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using UpdateReceiptRuleRequest.
//    req := client.UpdateReceiptRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateReceiptRule
func (c *Client) UpdateReceiptRuleRequest(input *UpdateReceiptRuleInput) UpdateReceiptRuleRequest {
	op := &aws.Operation{
		Name:       opUpdateReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateReceiptRuleInput{}
	}

	req := c.newRequest(op, input, &UpdateReceiptRuleOutput{})
	return UpdateReceiptRuleRequest{Request: req, Input: input, Copy: c.UpdateReceiptRuleRequest}
}

// UpdateReceiptRuleRequest is the request type for the
// UpdateReceiptRule API operation.
type UpdateReceiptRuleRequest struct {
	*aws.Request
	Input *UpdateReceiptRuleInput
	Copy  func(*UpdateReceiptRuleInput) UpdateReceiptRuleRequest
}

// Send marshals and sends the UpdateReceiptRule API request.
func (r UpdateReceiptRuleRequest) Send(ctx context.Context) (*UpdateReceiptRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateReceiptRuleResponse{
		UpdateReceiptRuleOutput: r.Request.Data.(*UpdateReceiptRuleOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateReceiptRuleResponse is the response type for the
// UpdateReceiptRule API operation.
type UpdateReceiptRuleResponse struct {
	*UpdateReceiptRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateReceiptRule request.
func (r *UpdateReceiptRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
