// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeletePatchBaselineInput struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline to delete.
	//
	// BaselineId is a required field
	BaselineId *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePatchBaselineInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePatchBaselineInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePatchBaselineInput"}

	if s.BaselineId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BaselineId"))
	}
	if s.BaselineId != nil && len(*s.BaselineId) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("BaselineId", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeletePatchBaselineOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the deleted patch baseline.
	BaselineId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s DeletePatchBaselineOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeletePatchBaseline = "DeletePatchBaseline"

// DeletePatchBaselineRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Deletes a patch baseline.
//
//    // Example sending a request using DeletePatchBaselineRequest.
//    req := client.DeletePatchBaselineRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline
func (c *Client) DeletePatchBaselineRequest(input *DeletePatchBaselineInput) DeletePatchBaselineRequest {
	op := &aws.Operation{
		Name:       opDeletePatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePatchBaselineInput{}
	}

	req := c.newRequest(op, input, &DeletePatchBaselineOutput{})
	return DeletePatchBaselineRequest{Request: req, Input: input, Copy: c.DeletePatchBaselineRequest}
}

// DeletePatchBaselineRequest is the request type for the
// DeletePatchBaseline API operation.
type DeletePatchBaselineRequest struct {
	*aws.Request
	Input *DeletePatchBaselineInput
	Copy  func(*DeletePatchBaselineInput) DeletePatchBaselineRequest
}

// Send marshals and sends the DeletePatchBaseline API request.
func (r DeletePatchBaselineRequest) Send(ctx context.Context) (*DeletePatchBaselineResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePatchBaselineResponse{
		DeletePatchBaselineOutput: r.Request.Data.(*DeletePatchBaselineOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePatchBaselineResponse is the response type for the
// DeletePatchBaseline API operation.
type DeletePatchBaselineResponse struct {
	*DeletePatchBaselineOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePatchBaseline request.
func (r *DeletePatchBaselineResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
