// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetOpsSummaryInput struct {
	_ struct{} `type:"structure"`

	// Optional aggregators that return counts of OpsItems based on one or more
	// expressions.
	Aggregators []OpsAggregator `min:"1" type:"list"`

	// Optional filters used to scope down the returned OpsItems.
	Filters []OpsFilter `min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`

	// The OpsItem data type to return.
	ResultAttributes []OpsResultAttribute `min:"1" type:"list"`

	// Specify the name of a resource data sync to get.
	SyncName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetOpsSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOpsSummaryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetOpsSummaryInput"}
	if s.Aggregators != nil && len(s.Aggregators) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Aggregators", 1))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResultAttributes != nil && len(s.ResultAttributes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResultAttributes", 1))
	}
	if s.SyncName != nil && len(*s.SyncName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SyncName", 1))
	}
	if s.Aggregators != nil {
		for i, v := range s.Aggregators {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Aggregators", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ResultAttributes != nil {
		for i, v := range s.ResultAttributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResultAttributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetOpsSummaryOutput struct {
	_ struct{} `type:"structure"`

	// The list of aggregated and filtered OpsItems.
	Entities []OpsEntity `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetOpsSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetOpsSummary = "GetOpsSummary"

// GetOpsSummaryRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// View a summary of OpsItems based on specified filters and aggregators.
//
//    // Example sending a request using GetOpsSummaryRequest.
//    req := client.GetOpsSummaryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary
func (c *Client) GetOpsSummaryRequest(input *GetOpsSummaryInput) GetOpsSummaryRequest {
	op := &aws.Operation{
		Name:       opGetOpsSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOpsSummaryInput{}
	}

	req := c.newRequest(op, input, &GetOpsSummaryOutput{})
	return GetOpsSummaryRequest{Request: req, Input: input, Copy: c.GetOpsSummaryRequest}
}

// GetOpsSummaryRequest is the request type for the
// GetOpsSummary API operation.
type GetOpsSummaryRequest struct {
	*aws.Request
	Input *GetOpsSummaryInput
	Copy  func(*GetOpsSummaryInput) GetOpsSummaryRequest
}

// Send marshals and sends the GetOpsSummary API request.
func (r GetOpsSummaryRequest) Send(ctx context.Context) (*GetOpsSummaryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetOpsSummaryResponse{
		GetOpsSummaryOutput: r.Request.Data.(*GetOpsSummaryOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetOpsSummaryResponse is the response type for the
// GetOpsSummary API operation.
type GetOpsSummaryResponse struct {
	*GetOpsSummaryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetOpsSummary request.
func (r *GetOpsSummaryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
