// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package support

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAttachmentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the attachment to return. Attachment IDs are returned by the DescribeCommunications
	// operation.
	//
	// AttachmentId is a required field
	AttachmentId *string `locationName:"attachmentId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAttachmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAttachmentInput"}

	if s.AttachmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttachmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The content and file name of the attachment returned by the DescribeAttachment
// operation.
type DescribeAttachmentOutput struct {
	_ struct{} `type:"structure"`

	// The attachment content and file name.
	Attachment *Attachment `locationName:"attachment" type:"structure"`
}

// String returns the string representation
func (s DescribeAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAttachment = "DescribeAttachment"

// DescribeAttachmentRequest returns a request value for making API operation for
// AWS Support.
//
// Returns the attachment that has the specified ID. Attachment IDs are generated
// by the case management system when you add an attachment to a case or case
// communication. Attachment IDs are returned in the AttachmentDetails objects
// that are returned by the DescribeCommunications operation.
//
//    // Example sending a request using DescribeAttachmentRequest.
//    req := client.DescribeAttachmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeAttachment
func (c *Client) DescribeAttachmentRequest(input *DescribeAttachmentInput) DescribeAttachmentRequest {
	op := &aws.Operation{
		Name:       opDescribeAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAttachmentInput{}
	}

	req := c.newRequest(op, input, &DescribeAttachmentOutput{})
	return DescribeAttachmentRequest{Request: req, Input: input, Copy: c.DescribeAttachmentRequest}
}

// DescribeAttachmentRequest is the request type for the
// DescribeAttachment API operation.
type DescribeAttachmentRequest struct {
	*aws.Request
	Input *DescribeAttachmentInput
	Copy  func(*DescribeAttachmentInput) DescribeAttachmentRequest
}

// Send marshals and sends the DescribeAttachment API request.
func (r DescribeAttachmentRequest) Send(ctx context.Context) (*DescribeAttachmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAttachmentResponse{
		DescribeAttachmentOutput: r.Request.Data.(*DescribeAttachmentOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAttachmentResponse is the response type for the
// DescribeAttachment API operation.
type DescribeAttachmentResponse struct {
	*DescribeAttachmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAttachment request.
func (r *DescribeAttachmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
