// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package support

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeCasesInput struct {
	_ struct{} `type:"structure"`

	// The start date for a filtered date search on support case communications.
	// Case communications are available for 12 months after creation.
	AfterTime *string `locationName:"afterTime" type:"string"`

	// The end date for a filtered date search on support case communications. Case
	// communications are available for 12 months after creation.
	BeforeTime *string `locationName:"beforeTime" type:"string"`

	// A list of ID numbers of the support cases you want returned. The maximum
	// number of cases is 100.
	CaseIdList []string `locationName:"caseIdList" type:"list"`

	// The ID displayed for a case in the AWS Support Center user interface.
	DisplayId *string `locationName:"displayId" type:"string"`

	// Specifies whether communications should be included in the DescribeCases
	// results. The default is true.
	IncludeCommunications *bool `locationName:"includeCommunications" type:"boolean"`

	// Specifies whether resolved support cases should be included in the DescribeCases
	// results. The default is false.
	IncludeResolvedCases *bool `locationName:"includeResolvedCases" type:"boolean"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// The maximum number of results to return before paginating.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeCasesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCasesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeCasesInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returns an array of CaseDetails objects and a nextToken that defines a point
// for pagination in the result set.
type DescribeCasesOutput struct {
	_ struct{} `type:"structure"`

	// The details for the cases that match the request.
	Cases []CaseDetails `locationName:"cases" type:"list"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeCasesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeCases = "DescribeCases"

// DescribeCasesRequest returns a request value for making API operation for
// AWS Support.
//
// Returns a list of cases that you specify by passing one or more case IDs.
// In addition, you can filter the cases by date by setting values for the afterTime
// and beforeTime request parameters. You can set values for the includeResolvedCases
// and includeCommunications request parameters to control how much information
// is returned.
//
// Case data is available for 12 months after creation. If a case was created
// more than 12 months ago, a request for data might cause an error.
//
// The response returns the following in JSON format:
//
//    * One or more CaseDetails data types.
//
//    * One or more nextToken values, which specify where to paginate the returned
//    records represented by the CaseDetails objects.
//
//    // Example sending a request using DescribeCasesRequest.
//    req := client.DescribeCasesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeCases
func (c *Client) DescribeCasesRequest(input *DescribeCasesInput) DescribeCasesRequest {
	op := &aws.Operation{
		Name:       opDescribeCases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCasesInput{}
	}

	req := c.newRequest(op, input, &DescribeCasesOutput{})
	return DescribeCasesRequest{Request: req, Input: input, Copy: c.DescribeCasesRequest}
}

// DescribeCasesRequest is the request type for the
// DescribeCases API operation.
type DescribeCasesRequest struct {
	*aws.Request
	Input *DescribeCasesInput
	Copy  func(*DescribeCasesInput) DescribeCasesRequest
}

// Send marshals and sends the DescribeCases API request.
func (r DescribeCasesRequest) Send(ctx context.Context) (*DescribeCasesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCasesResponse{
		DescribeCasesOutput: r.Request.Data.(*DescribeCasesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeCasesRequestPaginator returns a paginator for DescribeCases.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeCasesRequest(input)
//   p := support.NewDescribeCasesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeCasesPaginator(req DescribeCasesRequest) DescribeCasesPaginator {
	return DescribeCasesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeCasesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeCasesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeCasesPaginator struct {
	aws.Pager
}

func (p *DescribeCasesPaginator) CurrentPage() *DescribeCasesOutput {
	return p.Pager.CurrentPage().(*DescribeCasesOutput)
}

// DescribeCasesResponse is the response type for the
// DescribeCases API operation.
type DescribeCasesResponse struct {
	*DescribeCasesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCases request.
func (r *DescribeCasesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
