// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package swf

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Provides the details of the ActivityTaskCancelRequested event.
type ActivityTaskCancelRequestedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The unique ID of the task.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelActivityTask decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskCancelRequestedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ActivityTaskCanceled event.
type ActivityTaskCanceledEventAttributes struct {
	_ struct{} `type:"structure"`

	// Details of the cancellation.
	Details *string `locationName:"details" type:"string"`

	// If set, contains the ID of the last ActivityTaskCancelRequested event recorded
	// for this activity task. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	LatestCancelRequestedEventId *int64 `locationName:"latestCancelRequestedEventId" type:"long"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event recorded when this activity task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskCanceledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ActivityTaskCompleted event.
type ActivityTaskCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The results of the activity task.
	Result *string `locationName:"result" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event recorded when this activity task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ActivityTaskFailed event.
type ActivityTaskFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The details of the failure.
	Details *string `locationName:"details" type:"string"`

	// The reason provided for the failure.
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event recorded when this activity task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ActivityTaskScheduled event.
type ActivityTaskScheduledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The unique ID of the activity task.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The type of the activity task.
	//
	// ActivityType is a required field
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// Data attached to the event that can be used by the decider in subsequent
	// workflow tasks. This data isn't sent to the activity.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision that
	// resulted in the scheduling of this activity task. This information can be
	// useful for diagnosing problems by tracing back the chain of events leading
	// up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The maximum time before which the worker processing this task must report
	// progress by calling RecordActivityTaskHeartbeat. If the timeout is exceeded,
	// the activity task is automatically timed out. If the worker subsequently
	// attempts to record a heartbeat or return a result, it is ignored.
	HeartbeatTimeout *string `locationName:"heartbeatTimeout" type:"string"`

	// The input provided to the activity task.
	Input *string `locationName:"input" type:"string"`

	// The maximum amount of time for this activity task.
	ScheduleToCloseTimeout *string `locationName:"scheduleToCloseTimeout" type:"string"`

	// The maximum amount of time the activity task can wait to be assigned to a
	// worker.
	ScheduleToStartTimeout *string `locationName:"scheduleToStartTimeout" type:"string"`

	// The maximum amount of time a worker may take to process the activity task.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`

	// The task list in which the activity task has been scheduled.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// The priority to assign to the scheduled activity task. If set, this overrides
	// any default priority value that was assigned when the activity type was registered.
	//
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`
}

// String returns the string representation
func (s ActivityTaskScheduledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ActivityTaskStarted event.
type ActivityTaskStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Identity of the worker that was assigned this task. This aids diagnostics
	// when problems arise. The form of this identity is user defined.
	Identity *string `locationName:"identity" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ActivityTaskTimedOut event.
type ActivityTaskTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// Contains the content of the details parameter for the last call made by the
	// activity to RecordActivityTaskHeartbeat.
	Details *string `locationName:"details" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event recorded when this activity task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The type of the timeout that caused this event.
	//
	// TimeoutType is a required field
	TimeoutType ActivityTaskTimeoutType `locationName:"timeoutType" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ActivityTaskTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Represents an activity type.
type ActivityType struct {
	_ struct{} `type:"structure"`

	// The name of this activity.
	//
	// The combination of activity type name and version must be unique within a
	// domain.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The version of this activity.
	//
	// The combination of activity type name and version must be unique with in
	// a domain.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActivityType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivityType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ActivityType"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Version == nil {
		invalidParams.Add(aws.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configuration settings registered with the activity type.
type ActivityTypeConfiguration struct {
	_ struct{} `type:"structure"`

	// The default maximum time, in seconds, before which a worker processing a
	// task must report progress by calling RecordActivityTaskHeartbeat.
	//
	// You can specify this value only when registering an activity type. The registered
	// default value can be overridden when you schedule a task through the ScheduleActivityTask
	// Decision. If the activity worker subsequently attempts to record a heartbeat
	// or returns a result, the activity worker receives an UnknownResource fault.
	// In this case, Amazon SWF no longer considers the activity task to be valid;
	// the activity worker should clean up the activity task.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskHeartbeatTimeout *string `locationName:"defaultTaskHeartbeatTimeout" type:"string"`

	// The default task list specified for this activity type at registration. This
	// default is used if a task list isn't provided when a task is scheduled through
	// the ScheduleActivityTask Decision. You can override the default registered
	// task list when scheduling a task through the ScheduleActivityTask Decision.
	DefaultTaskList *TaskList `locationName:"defaultTaskList" type:"structure"`

	// The default task priority for tasks of this activity type, specified at registration.
	// If not set, then 0 is used as the default priority. This default can be overridden
	// when scheduling an activity task.
	//
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	DefaultTaskPriority *string `locationName:"defaultTaskPriority" type:"string"`

	// The default maximum duration, specified when registering the activity type,
	// for tasks of this activity type. You can override this default when scheduling
	// a task through the ScheduleActivityTask Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskScheduleToCloseTimeout *string `locationName:"defaultTaskScheduleToCloseTimeout" type:"string"`

	// The default maximum duration, specified when registering the activity type,
	// that a task of an activity type can wait before being assigned to a worker.
	// You can override this default when scheduling a task through the ScheduleActivityTask
	// Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskScheduleToStartTimeout *string `locationName:"defaultTaskScheduleToStartTimeout" type:"string"`

	// The default maximum duration for tasks of an activity type specified when
	// registering the activity type. You can override this default when scheduling
	// a task through the ScheduleActivityTask Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskStartToCloseTimeout *string `locationName:"defaultTaskStartToCloseTimeout" type:"string"`
}

// String returns the string representation
func (s ActivityTypeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Detailed information about an activity type.
type ActivityTypeInfo struct {
	_ struct{} `type:"structure"`

	// The ActivityType type structure representing the activity type.
	//
	// ActivityType is a required field
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The date and time this activity type was created through RegisterActivityType.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// If DEPRECATED, the date and time DeprecateActivityType was called.
	DeprecationDate *time.Time `locationName:"deprecationDate" type:"timestamp"`

	// The description of the activity type provided in RegisterActivityType.
	Description *string `locationName:"description" type:"string"`

	// The current status of the activity type.
	//
	// Status is a required field
	Status RegistrationStatus `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ActivityTypeInfo) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the CancelTimer decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type CancelTimerDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The unique ID of the timer to cancel.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelTimerDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelTimerDecisionAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelTimerDecisionAttributes"}

	if s.TimerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimerId"))
	}
	if s.TimerId != nil && len(*s.TimerId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TimerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the CancelTimerFailed event.
type CancelTimerFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause CancelTimerFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelTimer decision to cancel this timer. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The timerId provided in the CancelTimer decision that failed.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelTimerFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the CancelWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type CancelWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Details of the cancellation.
	Details *string `locationName:"details" type:"string"`
}

// String returns the string representation
func (s CancelWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the CancelWorkflowExecutionFailed event.
type CancelWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause CancelWorkflowExecutionFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelWorkflowExecution decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s CancelWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provide details of the ChildWorkflowExecutionCanceled event.
type ChildWorkflowExecutionCanceledEventAttributes struct {
	_ struct{} `type:"structure"`

	// Details of the cancellation (if provided).
	Details *string `locationName:"details" type:"string"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The child workflow execution that was canceled.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionCanceledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ChildWorkflowExecutionCompleted event.
type ChildWorkflowExecutionCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The result of the child workflow execution.
	Result *string `locationName:"result" type:"string"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The child workflow execution that was completed.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ChildWorkflowExecutionFailed event.
type ChildWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The details of the failure (if provided).
	Details *string `locationName:"details" type:"string"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The reason for the failure (if provided).
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The child workflow execution that failed.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ChildWorkflowExecutionStarted event.
type ChildWorkflowExecutionStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The child workflow execution that was started.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ChildWorkflowExecutionTerminated event.
type ChildWorkflowExecutionTerminatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The child workflow execution that was terminated.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionTerminatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ChildWorkflowExecutionTimedOut event.
type ChildWorkflowExecutionTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The type of the timeout that caused the child workflow execution to time
	// out.
	//
	// TimeoutType is a required field
	TimeoutType WorkflowExecutionTimeoutType `locationName:"timeoutType" type:"string" required:"true" enum:"true"`

	// The child workflow execution that timed out.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Used to filter the closed workflow executions in visibility APIs by their
// close status.
type CloseStatusFilter struct {
	_ struct{} `type:"structure"`

	// The close status that must match the close status of an execution for it
	// to meet the criteria of this filter.
	//
	// Status is a required field
	Status CloseStatus `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CloseStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloseStatusFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloseStatusFilter"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the CompleteWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type CompleteWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The result of the workflow execution. The form of the result is implementation
	// defined.
	Result *string `locationName:"result" type:"string"`
}

// String returns the string representation
func (s CompleteWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the CompleteWorkflowExecutionFailed event.
type CompleteWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause CompleteWorkflowExecutionFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CompleteWorkflowExecution decision to complete this
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s CompleteWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ContinueAsNewWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. tag – A tag used to identify the workflow execution
//    taskList – String constraint. The key is swf:taskList.name. workflowType.version
//    – String constraint. The key is swf:workflowType.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type ContinueAsNewWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// If set, specifies the policy to use for the child workflow executions of
	// the new execution if it is terminated by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This policy overrides the
	// default child policy specified when registering the workflow type using RegisterWorkflowType.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// A child policy for this workflow execution must be specified either as a
	// default for the workflow type or through this parameter. If neither this
	// parameter is set nor a default child policy was specified at registration
	// time then a fault is returned.
	ChildPolicy ChildPolicy `locationName:"childPolicy" type:"string" enum:"true"`

	// If set, specifies the total duration for this workflow execution. This overrides
	// the defaultExecutionStartToCloseTimeout specified when registering the workflow
	// type.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// An execution start-to-close timeout for this workflow execution must be specified
	// either as a default for the workflow type or through this field. If neither
	// this field is set nor a default execution start-to-close timeout was specified
	// at registration time then a fault is returned.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input provided to the new workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The IAM role to attach to the new (continued) execution.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The list of tags to associate with the new workflow execution. A maximum
	// of 5 tags can be specified. You can list workflow executions with a specific
	// tag by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions
	// and specifying a TagFilter.
	TagList []string `locationName:"tagList" type:"list"`

	// The task list to use for the decisions of the new (continued) workflow execution.
	TaskList *TaskList `locationName:"taskList" type:"structure"`

	// The task priority that, if set, specifies the priority for the decision tasks
	// for this workflow execution. This overrides the defaultTaskPriority specified
	// when registering the workflow type. Valid values are integers that range
	// from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647).
	// Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// Specifies the maximum duration of decision tasks for the new workflow execution.
	// This parameter overrides the defaultTaskStartToCloseTimout specified when
	// registering the workflow type using RegisterWorkflowType.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// A task start-to-close timeout for the new workflow execution must be specified
	// either as a default for the workflow type or through this parameter. If neither
	// this parameter is set nor a default task start-to-close timeout was specified
	// at registration time then a fault is returned.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The version of the workflow to start.
	WorkflowTypeVersion *string `locationName:"workflowTypeVersion" min:"1" type:"string"`
}

// String returns the string representation
func (s ContinueAsNewWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinueAsNewWorkflowExecutionDecisionAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContinueAsNewWorkflowExecutionDecisionAttributes"}
	if s.LambdaRole != nil && len(*s.LambdaRole) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LambdaRole", 1))
	}
	if s.WorkflowTypeVersion != nil && len(*s.WorkflowTypeVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkflowTypeVersion", 1))
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the ContinueAsNewWorkflowExecutionFailed event.
type ContinueAsNewWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause ContinueAsNewWorkflowExecutionFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the ContinueAsNewWorkflowExecution decision that started
	// this execution. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ContinueAsNewWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Specifies a decision made by the decider. A decision can be one of these
// types:
//
//    * CancelTimer – Cancels a previously started timer and records a TimerCanceled
//    event in the history.
//
//    * CancelWorkflowExecution – Closes the workflow execution and records
//    a WorkflowExecutionCanceled event in the history.
//
//    * CompleteWorkflowExecution – Closes the workflow execution and records
//    a WorkflowExecutionCompleted event in the history .
//
//    * ContinueAsNewWorkflowExecution – Closes the workflow execution and
//    starts a new workflow execution of the same type using the same workflow
//    ID and a unique run Id. A WorkflowExecutionContinuedAsNew event is recorded
//    in the history.
//
//    * FailWorkflowExecution – Closes the workflow execution and records
//    a WorkflowExecutionFailed event in the history.
//
//    * RecordMarker – Records a MarkerRecorded event in the history. Markers
//    can be used for adding custom information in the history for instance
//    to let deciders know that they don't need to look at the history beyond
//    the marker event.
//
//    * RequestCancelActivityTask – Attempts to cancel a previously scheduled
//    activity task. If the activity task was scheduled but has not been assigned
//    to a worker, then it is canceled. If the activity task was already assigned
//    to a worker, then the worker is informed that cancellation has been requested
//    in the response to RecordActivityTaskHeartbeat.
//
//    * RequestCancelExternalWorkflowExecution – Requests that a request be
//    made to cancel the specified external workflow execution and records a
//    RequestCancelExternalWorkflowExecutionInitiated event in the history.
//
//    * ScheduleActivityTask – Schedules an activity task.
//
//    * SignalExternalWorkflowExecution – Requests a signal to be delivered
//    to the specified external workflow execution and records a SignalExternalWorkflowExecutionInitiated
//    event in the history.
//
//    * StartChildWorkflowExecution – Requests that a child workflow execution
//    be started and records a StartChildWorkflowExecutionInitiated event in
//    the history. The child workflow execution is a separate workflow execution
//    with its own history.
//
//    * StartTimer – Starts a timer for this workflow execution and records
//    a TimerStarted event in the history. This timer fires after the specified
//    delay and record a TimerFired event.
//
// Access Control
//
// If you grant permission to use RespondDecisionTaskCompleted, you can use
// IAM policies to express permissions for the list of decisions returned by
// this action as if they were members of the API. Treating decisions as a pseudo
// API maintains a uniform conceptual model and helps keep policies readable.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Decision Failure
//
// Decisions can fail for several reasons
//
//    * The ordering of decisions should follow a logical flow. Some decisions
//    might not make sense in the current context of the workflow execution
//    and therefore fails.
//
//    * A limit on your account was reached.
//
//    * The decision lacks sufficient permissions.
//
// One of the following events might be added to the history to indicate an
// error. The event attribute's cause parameter indicates the cause. If cause
// is set to OPERATION_NOT_PERMITTED, the decision failed because it lacked
// sufficient permissions. For details and example IAM policies, see Using IAM
// to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
//    * ScheduleActivityTaskFailed – A ScheduleActivityTask decision failed.
//    This could happen if the activity type specified in the decision isn't
//    registered, is in a deprecated state, or the decision isn't properly configured.
//
//    * RequestCancelActivityTaskFailed – A RequestCancelActivityTask decision
//    failed. This could happen if there is no open activity task with the specified
//    activityId.
//
//    * StartTimerFailed – A StartTimer decision failed. This could happen
//    if there is another open timer with the same timerId.
//
//    * CancelTimerFailed – A CancelTimer decision failed. This could happen
//    if there is no open timer with the specified timerId.
//
//    * StartChildWorkflowExecutionFailed – A StartChildWorkflowExecution
//    decision failed. This could happen if the workflow type specified isn't
//    registered, is deprecated, or the decision isn't properly configured.
//
//    * SignalExternalWorkflowExecutionFailed – A SignalExternalWorkflowExecution
//    decision failed. This could happen if the workflowID specified in the
//    decision was incorrect.
//
//    * RequestCancelExternalWorkflowExecutionFailed – A RequestCancelExternalWorkflowExecution
//    decision failed. This could happen if the workflowID specified in the
//    decision was incorrect.
//
//    * CancelWorkflowExecutionFailed – A CancelWorkflowExecution decision
//    failed. This could happen if there is an unhandled decision task pending
//    in the workflow execution.
//
//    * CompleteWorkflowExecutionFailed – A CompleteWorkflowExecution decision
//    failed. This could happen if there is an unhandled decision task pending
//    in the workflow execution.
//
//    * ContinueAsNewWorkflowExecutionFailed – A ContinueAsNewWorkflowExecution
//    decision failed. This could happen if there is an unhandled decision task
//    pending in the workflow execution or the ContinueAsNewWorkflowExecution
//    decision was not configured correctly.
//
//    * FailWorkflowExecutionFailed – A FailWorkflowExecution decision failed.
//    This could happen if there is an unhandled decision task pending in the
//    workflow execution.
//
// The preceding error events might occur due to an error in the decider logic,
// which might put the workflow execution in an unstable state The cause field
// in the event structure for the error event indicates the cause of the error.
//
// A workflow execution may be closed by the decider by returning one of the
// following decisions when completing a decision task: CompleteWorkflowExecution,
// FailWorkflowExecution, CancelWorkflowExecution and ContinueAsNewWorkflowExecution.
// An UnhandledDecision fault is returned if a workflow closing decision is
// specified and a signal or activity event had been added to the history while
// the decision task was being performed by the decider. Unlike the above situations
// which are logic issues, this fault is always possible because of race conditions
// in a distributed system. The right action here is to call RespondDecisionTaskCompleted
// without any decisions. This would result in another decision task with these
// new events included in the history. The decider should handle the new events
// and may decide to close the workflow execution.
//
// How to Code a Decision
//
// You code a decision by first setting the decision type field to one of the
// above decision values, and then set the corresponding attributes field shown
// below:
//
//    * ScheduleActivityTaskDecisionAttributes
//
//    * RequestCancelActivityTaskDecisionAttributes
//
//    * CompleteWorkflowExecutionDecisionAttributes
//
//    * FailWorkflowExecutionDecisionAttributes
//
//    * CancelWorkflowExecutionDecisionAttributes
//
//    * ContinueAsNewWorkflowExecutionDecisionAttributes
//
//    * RecordMarkerDecisionAttributes
//
//    * StartTimerDecisionAttributes
//
//    * CancelTimerDecisionAttributes
//
//    * SignalExternalWorkflowExecutionDecisionAttributes
//
//    * RequestCancelExternalWorkflowExecutionDecisionAttributes
//
//    * StartChildWorkflowExecutionDecisionAttributes
type Decision struct {
	_ struct{} `type:"structure"`

	// Provides the details of the CancelTimer decision. It isn't set for other
	// decision types.
	CancelTimerDecisionAttributes *CancelTimerDecisionAttributes `locationName:"cancelTimerDecisionAttributes" type:"structure"`

	// Provides the details of the CancelWorkflowExecution decision. It isn't set
	// for other decision types.
	CancelWorkflowExecutionDecisionAttributes *CancelWorkflowExecutionDecisionAttributes `locationName:"cancelWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides the details of the CompleteWorkflowExecution decision. It isn't
	// set for other decision types.
	CompleteWorkflowExecutionDecisionAttributes *CompleteWorkflowExecutionDecisionAttributes `locationName:"completeWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides the details of the ContinueAsNewWorkflowExecution decision. It isn't
	// set for other decision types.
	ContinueAsNewWorkflowExecutionDecisionAttributes *ContinueAsNewWorkflowExecutionDecisionAttributes `locationName:"continueAsNewWorkflowExecutionDecisionAttributes" type:"structure"`

	// Specifies the type of the decision.
	//
	// DecisionType is a required field
	DecisionType DecisionType `locationName:"decisionType" type:"string" required:"true" enum:"true"`

	// Provides the details of the FailWorkflowExecution decision. It isn't set
	// for other decision types.
	FailWorkflowExecutionDecisionAttributes *FailWorkflowExecutionDecisionAttributes `locationName:"failWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides the details of the RecordMarker decision. It isn't set for other
	// decision types.
	RecordMarkerDecisionAttributes *RecordMarkerDecisionAttributes `locationName:"recordMarkerDecisionAttributes" type:"structure"`

	// Provides the details of the RequestCancelActivityTask decision. It isn't
	// set for other decision types.
	RequestCancelActivityTaskDecisionAttributes *RequestCancelActivityTaskDecisionAttributes `locationName:"requestCancelActivityTaskDecisionAttributes" type:"structure"`

	// Provides the details of the RequestCancelExternalWorkflowExecution decision.
	// It isn't set for other decision types.
	RequestCancelExternalWorkflowExecutionDecisionAttributes *RequestCancelExternalWorkflowExecutionDecisionAttributes `locationName:"requestCancelExternalWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides the details of the ScheduleActivityTask decision. It isn't set for
	// other decision types.
	ScheduleActivityTaskDecisionAttributes *ScheduleActivityTaskDecisionAttributes `locationName:"scheduleActivityTaskDecisionAttributes" type:"structure"`

	// Provides the details of the ScheduleLambdaFunction decision. It isn't set
	// for other decision types.
	ScheduleLambdaFunctionDecisionAttributes *ScheduleLambdaFunctionDecisionAttributes `locationName:"scheduleLambdaFunctionDecisionAttributes" type:"structure"`

	// Provides the details of the SignalExternalWorkflowExecution decision. It
	// isn't set for other decision types.
	SignalExternalWorkflowExecutionDecisionAttributes *SignalExternalWorkflowExecutionDecisionAttributes `locationName:"signalExternalWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides the details of the StartChildWorkflowExecution decision. It isn't
	// set for other decision types.
	StartChildWorkflowExecutionDecisionAttributes *StartChildWorkflowExecutionDecisionAttributes `locationName:"startChildWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides the details of the StartTimer decision. It isn't set for other decision
	// types.
	StartTimerDecisionAttributes *StartTimerDecisionAttributes `locationName:"startTimerDecisionAttributes" type:"structure"`
}

// String returns the string representation
func (s Decision) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Decision) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Decision"}
	if len(s.DecisionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("DecisionType"))
	}
	if s.CancelTimerDecisionAttributes != nil {
		if err := s.CancelTimerDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("CancelTimerDecisionAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.ContinueAsNewWorkflowExecutionDecisionAttributes != nil {
		if err := s.ContinueAsNewWorkflowExecutionDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("ContinueAsNewWorkflowExecutionDecisionAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.RecordMarkerDecisionAttributes != nil {
		if err := s.RecordMarkerDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("RecordMarkerDecisionAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.RequestCancelActivityTaskDecisionAttributes != nil {
		if err := s.RequestCancelActivityTaskDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("RequestCancelActivityTaskDecisionAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.RequestCancelExternalWorkflowExecutionDecisionAttributes != nil {
		if err := s.RequestCancelExternalWorkflowExecutionDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("RequestCancelExternalWorkflowExecutionDecisionAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.ScheduleActivityTaskDecisionAttributes != nil {
		if err := s.ScheduleActivityTaskDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("ScheduleActivityTaskDecisionAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.ScheduleLambdaFunctionDecisionAttributes != nil {
		if err := s.ScheduleLambdaFunctionDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("ScheduleLambdaFunctionDecisionAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.SignalExternalWorkflowExecutionDecisionAttributes != nil {
		if err := s.SignalExternalWorkflowExecutionDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("SignalExternalWorkflowExecutionDecisionAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.StartChildWorkflowExecutionDecisionAttributes != nil {
		if err := s.StartChildWorkflowExecutionDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("StartChildWorkflowExecutionDecisionAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.StartTimerDecisionAttributes != nil {
		if err := s.StartTimerDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("StartTimerDecisionAttributes", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the DecisionTaskCompleted event.
type DecisionTaskCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// User defined context for the workflow execution.
	ExecutionContext *string `locationName:"executionContext" type:"string"`

	// The ID of the DecisionTaskScheduled event that was recorded when this decision
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the DecisionTaskStarted event recorded when this decision task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s DecisionTaskCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides details about the DecisionTaskScheduled event.
type DecisionTaskScheduledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The maximum duration for this decision task. The task is considered timed
	// out if it doesn't completed within this duration.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`

	// The name of the task list in which the decision task was scheduled.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// A task priority that, if set, specifies the priority for this decision task.
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`
}

// String returns the string representation
func (s DecisionTaskScheduledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the DecisionTaskStarted event.
type DecisionTaskStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Identity of the decider making the request. This enables diagnostic tracing
	// when problems arise. The form of this identity is user defined.
	Identity *string `locationName:"identity" type:"string"`

	// The ID of the DecisionTaskScheduled event that was recorded when this decision
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s DecisionTaskStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the DecisionTaskTimedOut event.
type DecisionTaskTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskScheduled event that was recorded when this decision
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the DecisionTaskStarted event recorded when this decision task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The type of timeout that expired before the decision task could be completed.
	//
	// TimeoutType is a required field
	TimeoutType DecisionTaskTimeoutType `locationName:"timeoutType" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DecisionTaskTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Contains the configuration settings of a domain.
type DomainConfiguration struct {
	_ struct{} `type:"structure"`

	// The retention period for workflow executions in this domain.
	//
	// WorkflowExecutionRetentionPeriodInDays is a required field
	WorkflowExecutionRetentionPeriodInDays *string `locationName:"workflowExecutionRetentionPeriodInDays" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DomainConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Contains general information about a domain.
type DomainInfo struct {
	_ struct{} `type:"structure"`

	// The ARN of the domain.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The description of the domain provided through RegisterDomain.
	Description *string `locationName:"description" type:"string"`

	// The name of the domain. This name is unique within the account.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of the domain:
	//
	//    * REGISTERED – The domain is properly registered and available. You
	//    can use this domain for registering types and creating new workflow executions.
	//
	//    * DEPRECATED – The domain was deprecated using DeprecateDomain, but
	//    is still in use. You should not create new workflow executions in this
	//    domain.
	//
	// Status is a required field
	Status RegistrationStatus `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DomainInfo) String() string {
	return awsutil.Prettify(s)
}

// Used to filter the workflow executions in visibility APIs by various time-based
// rules. Each parameter, if specified, defines a rule that must be satisfied
// by each returned query result. The parameter values are in the Unix Time
// format (https://en.wikipedia.org/wiki/Unix_time). For example: "oldestDate":
// 1325376070.
type ExecutionTimeFilter struct {
	_ struct{} `type:"structure"`

	// Specifies the latest start or close date and time to return.
	LatestDate *time.Time `locationName:"latestDate" type:"timestamp"`

	// Specifies the oldest start or close date and time to return.
	//
	// OldestDate is a required field
	OldestDate *time.Time `locationName:"oldestDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s ExecutionTimeFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecutionTimeFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExecutionTimeFilter"}

	if s.OldestDate == nil {
		invalidParams.Add(aws.NewErrParamRequired("OldestDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the ExternalWorkflowExecutionCancelRequested event.
type ExternalWorkflowExecutionCancelRequestedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the RequestCancelExternalWorkflowExecutionInitiated event corresponding
	// to the RequestCancelExternalWorkflowExecution decision to cancel this external
	// workflow execution. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The external workflow execution to which the cancellation request was delivered.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExternalWorkflowExecutionCancelRequestedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the ExternalWorkflowExecutionSignaled event.
type ExternalWorkflowExecutionSignaledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the SignalExternalWorkflowExecutionInitiated event corresponding
	// to the SignalExternalWorkflowExecution decision to request this signal. This
	// information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The external workflow execution that the signal was delivered to.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExternalWorkflowExecutionSignaledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the FailWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type FailWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Details of the failure.
	Details *string `locationName:"details" type:"string"`

	// A descriptive reason for the failure that may help in diagnostics.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s FailWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the FailWorkflowExecutionFailed event.
type FailWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause FailWorkflowExecutionFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the FailWorkflowExecution decision to fail this execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s FailWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Event within a workflow execution. A history event can be one of these types:
//
//    * ActivityTaskCancelRequested – A RequestCancelActivityTask decision
//    was received by the system.
//
//    * ActivityTaskCanceled – The activity task was successfully canceled.
//
//    * ActivityTaskCompleted – An activity worker successfully completed
//    an activity task by calling RespondActivityTaskCompleted.
//
//    * ActivityTaskFailed – An activity worker failed an activity task by
//    calling RespondActivityTaskFailed.
//
//    * ActivityTaskScheduled – An activity task was scheduled for execution.
//
//    * ActivityTaskStarted – The scheduled activity task was dispatched to
//    a worker.
//
//    * ActivityTaskTimedOut – The activity task timed out.
//
//    * CancelTimerFailed – Failed to process CancelTimer decision. This happens
//    when the decision isn't configured properly, for example no timer exists
//    with the specified timer Id.
//
//    * CancelWorkflowExecutionFailed – A request to cancel a workflow execution
//    failed.
//
//    * ChildWorkflowExecutionCanceled – A child workflow execution, started
//    by this workflow execution, was canceled and closed.
//
//    * ChildWorkflowExecutionCompleted – A child workflow execution, started
//    by this workflow execution, completed successfully and was closed.
//
//    * ChildWorkflowExecutionFailed – A child workflow execution, started
//    by this workflow execution, failed to complete successfully and was closed.
//
//    * ChildWorkflowExecutionStarted – A child workflow execution was successfully
//    started.
//
//    * ChildWorkflowExecutionTerminated – A child workflow execution, started
//    by this workflow execution, was terminated.
//
//    * ChildWorkflowExecutionTimedOut – A child workflow execution, started
//    by this workflow execution, timed out and was closed.
//
//    * CompleteWorkflowExecutionFailed – The workflow execution failed to
//    complete.
//
//    * ContinueAsNewWorkflowExecutionFailed – The workflow execution failed
//    to complete after being continued as a new workflow execution.
//
//    * DecisionTaskCompleted – The decider successfully completed a decision
//    task by calling RespondDecisionTaskCompleted.
//
//    * DecisionTaskScheduled – A decision task was scheduled for the workflow
//    execution.
//
//    * DecisionTaskStarted – The decision task was dispatched to a decider.
//
//    * DecisionTaskTimedOut – The decision task timed out.
//
//    * ExternalWorkflowExecutionCancelRequested – Request to cancel an external
//    workflow execution was successfully delivered to the target execution.
//
//    * ExternalWorkflowExecutionSignaled – A signal, requested by this workflow
//    execution, was successfully delivered to the target external workflow
//    execution.
//
//    * FailWorkflowExecutionFailed – A request to mark a workflow execution
//    as failed, itself failed.
//
//    * MarkerRecorded – A marker was recorded in the workflow history as
//    the result of a RecordMarker decision.
//
//    * RecordMarkerFailed – A RecordMarker decision was returned as failed.
//
//    * RequestCancelActivityTaskFailed – Failed to process RequestCancelActivityTask
//    decision. This happens when the decision isn't configured properly.
//
//    * RequestCancelExternalWorkflowExecutionFailed – Request to cancel an
//    external workflow execution failed.
//
//    * RequestCancelExternalWorkflowExecutionInitiated – A request was made
//    to request the cancellation of an external workflow execution.
//
//    * ScheduleActivityTaskFailed – Failed to process ScheduleActivityTask
//    decision. This happens when the decision isn't configured properly, for
//    example the activity type specified isn't registered.
//
//    * SignalExternalWorkflowExecutionFailed – The request to signal an external
//    workflow execution failed.
//
//    * SignalExternalWorkflowExecutionInitiated – A request to signal an
//    external workflow was made.
//
//    * StartActivityTaskFailed – A scheduled activity task failed to start.
//
//    * StartChildWorkflowExecutionFailed – Failed to process StartChildWorkflowExecution
//    decision. This happens when the decision isn't configured properly, for
//    example the workflow type specified isn't registered.
//
//    * StartChildWorkflowExecutionInitiated – A request was made to start
//    a child workflow execution.
//
//    * StartTimerFailed – Failed to process StartTimer decision. This happens
//    when the decision isn't configured properly, for example a timer already
//    exists with the specified timer Id.
//
//    * TimerCanceled – A timer, previously started for this workflow execution,
//    was successfully canceled.
//
//    * TimerFired – A timer, previously started for this workflow execution,
//    fired.
//
//    * TimerStarted – A timer was started for the workflow execution due
//    to a StartTimer decision.
//
//    * WorkflowExecutionCancelRequested – A request to cancel this workflow
//    execution was made.
//
//    * WorkflowExecutionCanceled – The workflow execution was successfully
//    canceled and closed.
//
//    * WorkflowExecutionCompleted – The workflow execution was closed due
//    to successful completion.
//
//    * WorkflowExecutionContinuedAsNew – The workflow execution was closed
//    and a new execution of the same type was created with the same workflowId.
//
//    * WorkflowExecutionFailed – The workflow execution closed due to a failure.
//
//    * WorkflowExecutionSignaled – An external signal was received for the
//    workflow execution.
//
//    * WorkflowExecutionStarted – The workflow execution was started.
//
//    * WorkflowExecutionTerminated – The workflow execution was terminated.
//
//    * WorkflowExecutionTimedOut – The workflow execution was closed because
//    a time out was exceeded.
type HistoryEvent struct {
	_ struct{} `type:"structure"`

	// If the event is of type ActivityTaskcancelRequested then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	ActivityTaskCancelRequestedEventAttributes *ActivityTaskCancelRequestedEventAttributes `locationName:"activityTaskCancelRequestedEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskCanceled then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskCanceledEventAttributes *ActivityTaskCanceledEventAttributes `locationName:"activityTaskCanceledEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskCompleted then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskCompletedEventAttributes *ActivityTaskCompletedEventAttributes `locationName:"activityTaskCompletedEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskFailed then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	ActivityTaskFailedEventAttributes *ActivityTaskFailedEventAttributes `locationName:"activityTaskFailedEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskScheduled then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskScheduledEventAttributes *ActivityTaskScheduledEventAttributes `locationName:"activityTaskScheduledEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskStarted then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	ActivityTaskStartedEventAttributes *ActivityTaskStartedEventAttributes `locationName:"activityTaskStartedEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskTimedOut then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskTimedOutEventAttributes *ActivityTaskTimedOutEventAttributes `locationName:"activityTaskTimedOutEventAttributes" type:"structure"`

	// If the event is of type CancelTimerFailed then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	CancelTimerFailedEventAttributes *CancelTimerFailedEventAttributes `locationName:"cancelTimerFailedEventAttributes" type:"structure"`

	// If the event is of type CancelWorkflowExecutionFailed then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	CancelWorkflowExecutionFailedEventAttributes *CancelWorkflowExecutionFailedEventAttributes `locationName:"cancelWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionCanceled then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	ChildWorkflowExecutionCanceledEventAttributes *ChildWorkflowExecutionCanceledEventAttributes `locationName:"childWorkflowExecutionCanceledEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionCompleted then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	ChildWorkflowExecutionCompletedEventAttributes *ChildWorkflowExecutionCompletedEventAttributes `locationName:"childWorkflowExecutionCompletedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionFailed then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	ChildWorkflowExecutionFailedEventAttributes *ChildWorkflowExecutionFailedEventAttributes `locationName:"childWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionStarted then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	ChildWorkflowExecutionStartedEventAttributes *ChildWorkflowExecutionStartedEventAttributes `locationName:"childWorkflowExecutionStartedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionTerminated then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	ChildWorkflowExecutionTerminatedEventAttributes *ChildWorkflowExecutionTerminatedEventAttributes `locationName:"childWorkflowExecutionTerminatedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionTimedOut then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	ChildWorkflowExecutionTimedOutEventAttributes *ChildWorkflowExecutionTimedOutEventAttributes `locationName:"childWorkflowExecutionTimedOutEventAttributes" type:"structure"`

	// If the event is of type CompleteWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	CompleteWorkflowExecutionFailedEventAttributes *CompleteWorkflowExecutionFailedEventAttributes `locationName:"completeWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type ContinueAsNewWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	ContinueAsNewWorkflowExecutionFailedEventAttributes *ContinueAsNewWorkflowExecutionFailedEventAttributes `locationName:"continueAsNewWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskCompleted then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	DecisionTaskCompletedEventAttributes *DecisionTaskCompletedEventAttributes `locationName:"decisionTaskCompletedEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskScheduled then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	DecisionTaskScheduledEventAttributes *DecisionTaskScheduledEventAttributes `locationName:"decisionTaskScheduledEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskStarted then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	DecisionTaskStartedEventAttributes *DecisionTaskStartedEventAttributes `locationName:"decisionTaskStartedEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskTimedOut then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	DecisionTaskTimedOutEventAttributes *DecisionTaskTimedOutEventAttributes `locationName:"decisionTaskTimedOutEventAttributes" type:"structure"`

	// The system generated ID of the event. This ID uniquely identifies the event
	// with in the workflow execution history.
	//
	// EventId is a required field
	EventId *int64 `locationName:"eventId" type:"long" required:"true"`

	// The date and time when the event occurred.
	//
	// EventTimestamp is a required field
	EventTimestamp *time.Time `locationName:"eventTimestamp" type:"timestamp" required:"true"`

	// The type of the history event.
	//
	// EventType is a required field
	EventType EventType `locationName:"eventType" type:"string" required:"true" enum:"true"`

	// If the event is of type ExternalWorkflowExecutionCancelRequested then this
	// member is set and provides detailed information about the event. It isn't
	// set for other event types.
	ExternalWorkflowExecutionCancelRequestedEventAttributes *ExternalWorkflowExecutionCancelRequestedEventAttributes `locationName:"externalWorkflowExecutionCancelRequestedEventAttributes" type:"structure"`

	// If the event is of type ExternalWorkflowExecutionSignaled then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	ExternalWorkflowExecutionSignaledEventAttributes *ExternalWorkflowExecutionSignaledEventAttributes `locationName:"externalWorkflowExecutionSignaledEventAttributes" type:"structure"`

	// If the event is of type FailWorkflowExecutionFailed then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	FailWorkflowExecutionFailedEventAttributes *FailWorkflowExecutionFailedEventAttributes `locationName:"failWorkflowExecutionFailedEventAttributes" type:"structure"`

	// Provides the details of the LambdaFunctionCompleted event. It isn't set for
	// other event types.
	LambdaFunctionCompletedEventAttributes *LambdaFunctionCompletedEventAttributes `locationName:"lambdaFunctionCompletedEventAttributes" type:"structure"`

	// Provides the details of the LambdaFunctionFailed event. It isn't set for
	// other event types.
	LambdaFunctionFailedEventAttributes *LambdaFunctionFailedEventAttributes `locationName:"lambdaFunctionFailedEventAttributes" type:"structure"`

	// Provides the details of the LambdaFunctionScheduled event. It isn't set for
	// other event types.
	LambdaFunctionScheduledEventAttributes *LambdaFunctionScheduledEventAttributes `locationName:"lambdaFunctionScheduledEventAttributes" type:"structure"`

	// Provides the details of the LambdaFunctionStarted event. It isn't set for
	// other event types.
	LambdaFunctionStartedEventAttributes *LambdaFunctionStartedEventAttributes `locationName:"lambdaFunctionStartedEventAttributes" type:"structure"`

	// Provides the details of the LambdaFunctionTimedOut event. It isn't set for
	// other event types.
	LambdaFunctionTimedOutEventAttributes *LambdaFunctionTimedOutEventAttributes `locationName:"lambdaFunctionTimedOutEventAttributes" type:"structure"`

	// If the event is of type MarkerRecorded then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	MarkerRecordedEventAttributes *MarkerRecordedEventAttributes `locationName:"markerRecordedEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskFailed then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	RecordMarkerFailedEventAttributes *RecordMarkerFailedEventAttributes `locationName:"recordMarkerFailedEventAttributes" type:"structure"`

	// If the event is of type RequestCancelActivityTaskFailed then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	RequestCancelActivityTaskFailedEventAttributes *RequestCancelActivityTaskFailedEventAttributes `locationName:"requestCancelActivityTaskFailedEventAttributes" type:"structure"`

	// If the event is of type RequestCancelExternalWorkflowExecutionFailed then
	// this member is set and provides detailed information about the event. It
	// isn't set for other event types.
	RequestCancelExternalWorkflowExecutionFailedEventAttributes *RequestCancelExternalWorkflowExecutionFailedEventAttributes `locationName:"requestCancelExternalWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type RequestCancelExternalWorkflowExecutionInitiated then
	// this member is set and provides detailed information about the event. It
	// isn't set for other event types.
	RequestCancelExternalWorkflowExecutionInitiatedEventAttributes *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes `locationName:"requestCancelExternalWorkflowExecutionInitiatedEventAttributes" type:"structure"`

	// If the event is of type ScheduleActivityTaskFailed then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	ScheduleActivityTaskFailedEventAttributes *ScheduleActivityTaskFailedEventAttributes `locationName:"scheduleActivityTaskFailedEventAttributes" type:"structure"`

	// Provides the details of the ScheduleLambdaFunctionFailed event. It isn't
	// set for other event types.
	ScheduleLambdaFunctionFailedEventAttributes *ScheduleLambdaFunctionFailedEventAttributes `locationName:"scheduleLambdaFunctionFailedEventAttributes" type:"structure"`

	// If the event is of type SignalExternalWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	SignalExternalWorkflowExecutionFailedEventAttributes *SignalExternalWorkflowExecutionFailedEventAttributes `locationName:"signalExternalWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type SignalExternalWorkflowExecutionInitiated then this
	// member is set and provides detailed information about the event. It isn't
	// set for other event types.
	SignalExternalWorkflowExecutionInitiatedEventAttributes *SignalExternalWorkflowExecutionInitiatedEventAttributes `locationName:"signalExternalWorkflowExecutionInitiatedEventAttributes" type:"structure"`

	// If the event is of type StartChildWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	StartChildWorkflowExecutionFailedEventAttributes *StartChildWorkflowExecutionFailedEventAttributes `locationName:"startChildWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type StartChildWorkflowExecutionInitiated then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	StartChildWorkflowExecutionInitiatedEventAttributes *StartChildWorkflowExecutionInitiatedEventAttributes `locationName:"startChildWorkflowExecutionInitiatedEventAttributes" type:"structure"`

	// Provides the details of the StartLambdaFunctionFailed event. It isn't set
	// for other event types.
	StartLambdaFunctionFailedEventAttributes *StartLambdaFunctionFailedEventAttributes `locationName:"startLambdaFunctionFailedEventAttributes" type:"structure"`

	// If the event is of type StartTimerFailed then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	StartTimerFailedEventAttributes *StartTimerFailedEventAttributes `locationName:"startTimerFailedEventAttributes" type:"structure"`

	// If the event is of type TimerCanceled then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	TimerCanceledEventAttributes *TimerCanceledEventAttributes `locationName:"timerCanceledEventAttributes" type:"structure"`

	// If the event is of type TimerFired then this member is set and provides detailed
	// information about the event. It isn't set for other event types.
	TimerFiredEventAttributes *TimerFiredEventAttributes `locationName:"timerFiredEventAttributes" type:"structure"`

	// If the event is of type TimerStarted then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	TimerStartedEventAttributes *TimerStartedEventAttributes `locationName:"timerStartedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionCancelRequested then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	WorkflowExecutionCancelRequestedEventAttributes *WorkflowExecutionCancelRequestedEventAttributes `locationName:"workflowExecutionCancelRequestedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionCanceled then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	WorkflowExecutionCanceledEventAttributes *WorkflowExecutionCanceledEventAttributes `locationName:"workflowExecutionCanceledEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionCompleted then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	WorkflowExecutionCompletedEventAttributes *WorkflowExecutionCompletedEventAttributes `locationName:"workflowExecutionCompletedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionContinuedAsNew then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	WorkflowExecutionContinuedAsNewEventAttributes *WorkflowExecutionContinuedAsNewEventAttributes `locationName:"workflowExecutionContinuedAsNewEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionFailed then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	WorkflowExecutionFailedEventAttributes *WorkflowExecutionFailedEventAttributes `locationName:"workflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionSignaled then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	WorkflowExecutionSignaledEventAttributes *WorkflowExecutionSignaledEventAttributes `locationName:"workflowExecutionSignaledEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionStarted then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	WorkflowExecutionStartedEventAttributes *WorkflowExecutionStartedEventAttributes `locationName:"workflowExecutionStartedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionTerminated then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	WorkflowExecutionTerminatedEventAttributes *WorkflowExecutionTerminatedEventAttributes `locationName:"workflowExecutionTerminatedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionTimedOut then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	WorkflowExecutionTimedOutEventAttributes *WorkflowExecutionTimedOutEventAttributes `locationName:"workflowExecutionTimedOutEventAttributes" type:"structure"`
}

// String returns the string representation
func (s HistoryEvent) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the LambdaFunctionCompleted event. It isn't set for
// other event types.
type LambdaFunctionCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The results of the Lambda task.
	Result *string `locationName:"result" type:"string"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this Lambda
	// task was scheduled. To help diagnose issues, use this information to trace
	// back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the LambdaFunctionStarted event recorded when this activity task
	// started. To help diagnose issues, use this information to trace back the
	// chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the LambdaFunctionFailed event. It isn't set for
// other event types.
type LambdaFunctionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The details of the failure.
	Details *string `locationName:"details" type:"string"`

	// The reason provided for the failure.
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this activity
	// task was scheduled. To help diagnose issues, use this information to trace
	// back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the LambdaFunctionStarted event recorded when this activity task
	// started. To help diagnose issues, use this information to trace back the
	// chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the LambdaFunctionScheduled event. It isn't set for
// other event types.
type LambdaFunctionScheduledEventAttributes struct {
	_ struct{} `type:"structure"`

	// Data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the Lambda task.
	Control *string `locationName:"control" type:"string"`

	// The ID of the LambdaFunctionCompleted event corresponding to the decision
	// that resulted in scheduling this activity task. To help diagnose issues,
	// use this information to trace back the chain of events leading up to this
	// event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The unique ID of the Lambda task.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The input provided to the Lambda task.
	Input *string `locationName:"input" type:"string"`

	// The name of the Lambda function.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The maximum amount of time a worker can take to process the Lambda task.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`
}

// String returns the string representation
func (s LambdaFunctionScheduledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the LambdaFunctionStarted event. It isn't set for
// other event types.
type LambdaFunctionStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this activity
	// task was scheduled. To help diagnose issues, use this information to trace
	// back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides details of the LambdaFunctionTimedOut event.
type LambdaFunctionTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this activity
	// task was scheduled. To help diagnose issues, use this information to trace
	// back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event that was recorded when this activity
	// task started. To help diagnose issues, use this information to trace back
	// the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The type of the timeout that caused this event.
	TimeoutType LambdaFunctionTimeoutType `locationName:"timeoutType" type:"string" enum:"true"`
}

// String returns the string representation
func (s LambdaFunctionTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the MarkerRecorded event.
type MarkerRecordedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RecordMarker decision that requested this marker. This
	// information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The details of the marker.
	Details *string `locationName:"details" type:"string"`

	// The name of the marker.
	//
	// MarkerName is a required field
	MarkerName *string `locationName:"markerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MarkerRecordedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the RecordMarker decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type RecordMarkerDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The details of the marker.
	Details *string `locationName:"details" type:"string"`

	// The name of the marker.
	//
	// MarkerName is a required field
	MarkerName *string `locationName:"markerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordMarkerDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordMarkerDecisionAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RecordMarkerDecisionAttributes"}

	if s.MarkerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MarkerName"))
	}
	if s.MarkerName != nil && len(*s.MarkerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MarkerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the RecordMarkerFailed event.
type RecordMarkerFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause RecordMarkerFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RecordMarkerFailed decision for this cancellation request.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The marker's name.
	//
	// MarkerName is a required field
	MarkerName *string `locationName:"markerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordMarkerFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the RequestCancelActivityTask decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type RequestCancelActivityTaskDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The activityId of the activity task to be canceled.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelActivityTaskDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestCancelActivityTaskDecisionAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RequestCancelActivityTaskDecisionAttributes"}

	if s.ActivityId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ActivityId"))
	}
	if s.ActivityId != nil && len(*s.ActivityId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ActivityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the RequestCancelActivityTaskFailed event.
type RequestCancelActivityTaskFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The activityId provided in the RequestCancelActivityTask decision that failed.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause RequestCancelActivityTaskFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelActivityTask decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s RequestCancelActivityTaskFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the RequestCancelExternalWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type RequestCancelExternalWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string `locationName:"control" type:"string"`

	// The runId of the external workflow execution to cancel.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the external workflow execution to cancel.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelExternalWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestCancelExternalWorkflowExecutionDecisionAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RequestCancelExternalWorkflowExecutionDecisionAttributes"}

	if s.WorkflowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the RequestCancelExternalWorkflowExecutionFailed
// event.
type RequestCancelExternalWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause RequestCancelExternalWorkflowExecutionFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the workflow execution.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelExternalWorkflowExecution decision for
	// this cancellation request. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The ID of the RequestCancelExternalWorkflowExecutionInitiated event corresponding
	// to the RequestCancelExternalWorkflowExecution decision to cancel this external
	// workflow execution. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The runId of the external workflow execution.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the external workflow to which the cancel request was to
	// be delivered.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelExternalWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the RequestCancelExternalWorkflowExecutionInitiated
// event.
type RequestCancelExternalWorkflowExecutionInitiatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelExternalWorkflowExecution decision for
	// this cancellation request. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The runId of the external workflow execution to be canceled.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the external workflow execution to be canceled.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Tags are key-value pairs that can be associated with Amazon SWF state machines
// and activities.
//
// Tags may only contain unicode letters, digits, whitespace, or these symbols:
// _ . : / = + - @.
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The key of a tag.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of a tag.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceTag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceTag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the ScheduleActivityTask decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. activityType.name – String constraint. The key
//    is swf:activityType.name. activityType.version – String constraint.
//    The key is swf:activityType.version. taskList – String constraint. The
//    key is swf:taskList.name.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type ScheduleActivityTaskDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The activityId of the activity task.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not contain the literal string arn.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The type of the activity task to schedule.
	//
	// ActivityType is a required field
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// Data attached to the event that can be used by the decider in subsequent
	// workflow tasks. This data isn't sent to the activity.
	Control *string `locationName:"control" type:"string"`

	// If set, specifies the maximum time before which a worker processing a task
	// of this type must report progress by calling RecordActivityTaskHeartbeat.
	// If the timeout is exceeded, the activity task is automatically timed out.
	// If the worker subsequently attempts to record a heartbeat or returns a result,
	// it is ignored. This overrides the default heartbeat timeout specified when
	// registering the activity type using RegisterActivityType.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	HeartbeatTimeout *string `locationName:"heartbeatTimeout" type:"string"`

	// The input provided to the activity task.
	Input *string `locationName:"input" type:"string"`

	// The maximum duration for this activity task.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// A schedule-to-close timeout for this activity task must be specified either
	// as a default for the activity type or through this field. If neither this
	// field is set nor a default schedule-to-close timeout was specified at registration
	// time then a fault is returned.
	ScheduleToCloseTimeout *string `locationName:"scheduleToCloseTimeout" type:"string"`

	// If set, specifies the maximum duration the activity task can wait to be assigned
	// to a worker. This overrides the default schedule-to-start timeout specified
	// when registering the activity type using RegisterActivityType.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// A schedule-to-start timeout for this activity task must be specified either
	// as a default for the activity type or through this field. If neither this
	// field is set nor a default schedule-to-start timeout was specified at registration
	// time then a fault is returned.
	ScheduleToStartTimeout *string `locationName:"scheduleToStartTimeout" type:"string"`

	// If set, specifies the maximum duration a worker may take to process this
	// activity task. This overrides the default start-to-close timeout specified
	// when registering the activity type using RegisterActivityType.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// A start-to-close timeout for this activity task must be specified either
	// as a default for the activity type or through this field. If neither this
	// field is set nor a default start-to-close timeout was specified at registration
	// time then a fault is returned.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`

	// If set, specifies the name of the task list in which to schedule the activity
	// task. If not specified, the defaultTaskList registered with the activity
	// type is used.
	//
	// A task list for this activity task must be specified either as a default
	// for the activity type or through this field. If neither this field is set
	// nor a default task list was specified at registration time then a fault is
	// returned.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not contain the literal string arn.
	TaskList *TaskList `locationName:"taskList" type:"structure"`

	// If set, specifies the priority with which the activity task is to be assigned
	// to a worker. This overrides the defaultTaskPriority specified when registering
	// the activity type using RegisterActivityType. Valid values are integers that
	// range from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647).
	// Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`
}

// String returns the string representation
func (s ScheduleActivityTaskDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleActivityTaskDecisionAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduleActivityTaskDecisionAttributes"}

	if s.ActivityId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ActivityId"))
	}
	if s.ActivityId != nil && len(*s.ActivityId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ActivityId", 1))
	}

	if s.ActivityType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ActivityType"))
	}
	if s.ActivityType != nil {
		if err := s.ActivityType.Validate(); err != nil {
			invalidParams.AddNested("ActivityType", err.(aws.ErrInvalidParams))
		}
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the ScheduleActivityTaskFailed event.
type ScheduleActivityTaskFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The activityId provided in the ScheduleActivityTask decision that failed.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The activity type provided in the ScheduleActivityTask decision that failed.
	//
	// ActivityType is a required field
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause ScheduleActivityTaskFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision that
	// resulted in the scheduling of this activity task. This information can be
	// useful for diagnosing problems by tracing back the chain of events leading
	// up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ScheduleActivityTaskFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Decision attributes specified in scheduleLambdaFunctionDecisionAttributes
// within the list of decisions decisions passed to RespondDecisionTaskCompleted.
type ScheduleLambdaFunctionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the Lambda task.
	Control *string `locationName:"control" type:"string"`

	// A string that identifies the Lambda function execution in the event history.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The optional input data to be supplied to the Lambda function.
	Input *string `locationName:"input" type:"string"`

	// The name, or ARN, of the Lambda function to schedule.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The timeout value, in seconds, after which the Lambda function is considered
	// to be failed once it has started. This can be any integer from 1-300 (1s-5m).
	// If no value is supplied, than a default value of 300s is assumed.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`
}

// String returns the string representation
func (s ScheduleLambdaFunctionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleLambdaFunctionDecisionAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduleLambdaFunctionDecisionAttributes"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the ScheduleLambdaFunctionFailed event. It isn't
// set for other event types.
type ScheduleLambdaFunctionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. To help diagnose issues, use this information to
	// trace back the chain of events leading up to this event.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause ScheduleLambdaFunctionFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The ID of the LambdaFunctionCompleted event corresponding to the decision
	// that resulted in scheduling this Lambda task. To help diagnose issues, use
	// this information to trace back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The ID provided in the ScheduleLambdaFunction decision that failed.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The name of the Lambda function.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ScheduleLambdaFunctionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the SignalExternalWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type SignalExternalWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The data attached to the event that can be used by the decider in subsequent
	// decision tasks.
	Control *string `locationName:"control" type:"string"`

	// The input data to be provided with the signal. The target workflow execution
	// uses the signal name and input data to process the signal.
	Input *string `locationName:"input" type:"string"`

	// The runId of the workflow execution to be signaled.
	RunId *string `locationName:"runId" type:"string"`

	// The name of the signal.The target workflow execution uses the signal name
	// and input to process the signal.
	//
	// SignalName is a required field
	SignalName *string `locationName:"signalName" min:"1" type:"string" required:"true"`

	// The workflowId of the workflow execution to be signaled.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalExternalWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignalExternalWorkflowExecutionDecisionAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SignalExternalWorkflowExecutionDecisionAttributes"}

	if s.SignalName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SignalName"))
	}
	if s.SignalName != nil && len(*s.SignalName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SignalName", 1))
	}

	if s.WorkflowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the SignalExternalWorkflowExecutionFailed event.
type SignalExternalWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause SignalExternalWorkflowExecutionFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the workflow execution.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the SignalExternalWorkflowExecution decision for this signal.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The ID of the SignalExternalWorkflowExecutionInitiated event corresponding
	// to the SignalExternalWorkflowExecution decision to request this signal. This
	// information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The runId of the external workflow execution that the signal was being delivered
	// to.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the external workflow execution that the signal was being
	// delivered to.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalExternalWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the SignalExternalWorkflowExecutionInitiated event.
type SignalExternalWorkflowExecutionInitiatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Data attached to the event that can be used by the decider in subsequent
	// decision tasks.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the SignalExternalWorkflowExecution decision for this signal.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The input provided to the signal.
	Input *string `locationName:"input" type:"string"`

	// The runId of the external workflow execution to send the signal to.
	RunId *string `locationName:"runId" type:"string"`

	// The name of the signal.
	//
	// SignalName is a required field
	SignalName *string `locationName:"signalName" min:"1" type:"string" required:"true"`

	// The workflowId of the external workflow execution.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalExternalWorkflowExecutionInitiatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the StartChildWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. tagList.member.N – The key is "swf:tagList.N"
//    where N is the tag number from 0 to 4, inclusive. taskList – String
//    constraint. The key is swf:taskList.name. workflowType.name – String
//    constraint. The key is swf:workflowType.name. workflowType.version –
//    String constraint. The key is swf:workflowType.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type StartChildWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// If set, specifies the policy to use for the child workflow executions if
	// the workflow execution being started is terminated by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This policy overrides the
	// default child policy specified when registering the workflow type using RegisterWorkflowType.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// A child policy for this workflow execution must be specified either as a
	// default for the workflow type or through this parameter. If neither this
	// parameter is set nor a default child policy was specified at registration
	// time then a fault is returned.
	ChildPolicy ChildPolicy `locationName:"childPolicy" type:"string" enum:"true"`

	// The data attached to the event that can be used by the decider in subsequent
	// workflow tasks. This data isn't sent to the child workflow execution.
	Control *string `locationName:"control" type:"string"`

	// The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout
	// specified when registering the workflow type.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// An execution start-to-close timeout for this workflow execution must be specified
	// either as a default for the workflow type or through this parameter. If neither
	// this parameter is set nor a default execution start-to-close timeout was
	// specified at registration time then a fault is returned.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input to be provided to the workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The IAM role attached to the child workflow execution.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The list of tags to associate with the child workflow execution. A maximum
	// of 5 tags can be specified. You can list workflow executions with a specific
	// tag by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions
	// and specifying a TagFilter.
	TagList []string `locationName:"tagList" type:"list"`

	// The name of the task list to be used for decision tasks of the child workflow
	// execution.
	//
	// A task list for this workflow execution must be specified either as a default
	// for the workflow type or through this parameter. If neither this parameter
	// is set nor a default task list was specified at registration time then a
	// fault is returned.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not contain the literal string arn.
	TaskList *TaskList `locationName:"taskList" type:"structure"`

	// A task priority that, if set, specifies the priority for a decision task
	// of this workflow execution. This overrides the defaultTaskPriority specified
	// when registering the workflow type. Valid values are integers that range
	// from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647).
	// Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// Specifies the maximum duration of decision tasks for this workflow execution.
	// This parameter overrides the defaultTaskStartToCloseTimout specified when
	// registering the workflow type using RegisterWorkflowType.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// A task start-to-close timeout for this workflow execution must be specified
	// either as a default for the workflow type or through this parameter. If neither
	// this parameter is set nor a default task start-to-close timeout was specified
	// at registration time then a fault is returned.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The workflowId of the workflow execution.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not contain the literal string arn.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// The type of the workflow execution to be started.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartChildWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartChildWorkflowExecutionDecisionAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartChildWorkflowExecutionDecisionAttributes"}
	if s.LambdaRole != nil && len(*s.LambdaRole) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LambdaRole", 1))
	}

	if s.WorkflowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkflowId", 1))
	}

	if s.WorkflowType == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkflowType"))
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(aws.ErrInvalidParams))
		}
	}
	if s.WorkflowType != nil {
		if err := s.WorkflowType.Validate(); err != nil {
			invalidParams.AddNested("WorkflowType", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the StartChildWorkflowExecutionFailed event.
type StartChildWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// When cause is set to OPERATION_NOT_PERMITTED, the decision fails because
	// it lacks sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause StartChildWorkflowExecutionFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the child workflow execution.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartChildWorkflowExecution Decision to request this
	// child workflow execution. This information can be useful for diagnosing problems
	// by tracing back the chain of events.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// When the cause is WORKFLOW_ALREADY_RUNNING, initiatedEventId is the ID of
	// the StartChildWorkflowExecutionInitiated event that corresponds to the StartChildWorkflowExecution
	// Decision to start the workflow execution. You can use this information to
	// diagnose problems by tracing back the chain of events leading up to this
	// event.
	//
	// When the cause isn't WORKFLOW_ALREADY_RUNNING, initiatedEventId is set to
	// 0 because the StartChildWorkflowExecutionInitiated event doesn't exist.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The workflowId of the child workflow execution.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// The workflow type provided in the StartChildWorkflowExecution Decision that
	// failed.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartChildWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the StartChildWorkflowExecutionInitiated event.
type StartChildWorkflowExecutionInitiatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The policy to use for the child workflow executions if this execution gets
	// terminated by explicitly calling the TerminateWorkflowExecution action or
	// due to an expired timeout.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// ChildPolicy is a required field
	ChildPolicy ChildPolicy `locationName:"childPolicy" type:"string" required:"true" enum:"true"`

	// Data attached to the event that can be used by the decider in subsequent
	// decision tasks. This data isn't sent to the activity.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartChildWorkflowExecution Decision to request this
	// child workflow execution. This information can be useful for diagnosing problems
	// by tracing back the cause of events.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The maximum duration for the child workflow execution. If the workflow execution
	// isn't closed within this duration, it is timed out and force-terminated.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The inputs provided to the child workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The IAM role to attach to the child workflow execution.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The list of tags to associated with the child workflow execution.
	TagList []string `locationName:"tagList" type:"list"`

	// The name of the task list used for the decision tasks of the child workflow
	// execution.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// The priority assigned for the decision tasks for this workflow execution.
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// The maximum duration allowed for the decision tasks for this workflow execution.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The workflowId of the child workflow execution.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartChildWorkflowExecutionInitiatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the StartLambdaFunctionFailed event. It isn't set
// for other event types.
type StartLambdaFunctionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. To help diagnose issues, use this information to
	// trace back the chain of events leading up to this event.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because the
	// IAM role attached to the execution lacked sufficient permissions. For details
	// and example IAM policies, see Lambda Tasks (https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html)
	// in the Amazon SWF Developer Guide.
	Cause StartLambdaFunctionFailedCause `locationName:"cause" type:"string" enum:"true"`

	// A description that can help diagnose the cause of the fault.
	Message *string `locationName:"message" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. To help diagnose issues, use this information to trace
	// back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long"`
}

// String returns the string representation
func (s StartLambdaFunctionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the StartTimer decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type StartTimerDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string `locationName:"control" type:"string"`

	// The duration to wait before firing the timer.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0.
	//
	// StartToFireTimeout is a required field
	StartToFireTimeout *string `locationName:"startToFireTimeout" min:"1" type:"string" required:"true"`

	// The unique ID of the timer.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not contain the literal string arn.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartTimerDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTimerDecisionAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartTimerDecisionAttributes"}

	if s.StartToFireTimeout == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartToFireTimeout"))
	}
	if s.StartToFireTimeout != nil && len(*s.StartToFireTimeout) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StartToFireTimeout", 1))
	}

	if s.TimerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimerId"))
	}
	if s.TimerId != nil && len(*s.TimerId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TimerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the StartTimerFailed event.
type StartTimerFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause StartTimerFailedCause `locationName:"cause" type:"string" required:"true" enum:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartTimer decision for this activity task. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The timerId provided in the StartTimer decision that failed.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartTimerFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Used to filter the workflow executions in visibility APIs based on a tag.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// Specifies the tag that must be associated with the execution for it to meet
	// the filter criteria.
	//
	// Tags may only contain unicode letters, digits, whitespace, or these symbols:
	// _ . : / = + - @.
	//
	// Tag is a required field
	Tag *string `locationName:"tag" type:"string" required:"true"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TagFilter"}

	if s.Tag == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tag"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a task list.
type TaskList struct {
	_ struct{} `type:"structure"`

	// The name of the task list.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TaskList) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaskList) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TaskList"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the TimerCanceled event.
type TimerCanceledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelTimer decision to cancel this timer. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The ID of the TimerStarted event that was recorded when this timer was started.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The unique ID of the timer that was canceled.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TimerCanceledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the TimerFired event.
type TimerFiredEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the TimerStarted event that was recorded when this timer was started.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The unique ID of the timer that fired.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TimerFiredEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the TimerStarted event.
type TimerStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartTimer decision for this activity task. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The duration of time after which the timer fires.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0.
	//
	// StartToFireTimeout is a required field
	StartToFireTimeout *string `locationName:"startToFireTimeout" min:"1" type:"string" required:"true"`

	// The unique ID of the timer that was started.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TimerStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Represents a workflow execution.
type WorkflowExecution struct {
	_ struct{} `type:"structure"`

	// A system-generated unique identifier for the workflow execution.
	//
	// RunId is a required field
	RunId *string `locationName:"runId" min:"1" type:"string" required:"true"`

	// The user defined identifier associated with the workflow execution.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowExecution) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkflowExecution) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WorkflowExecution"}

	if s.RunId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RunId"))
	}
	if s.RunId != nil && len(*s.RunId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RunId", 1))
	}

	if s.WorkflowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the details of the WorkflowExecutionCancelRequested event.
type WorkflowExecutionCancelRequestedEventAttributes struct {
	_ struct{} `type:"structure"`

	// If set, indicates that the request to cancel the workflow execution was automatically
	// generated, and specifies the cause. This happens if the parent workflow execution
	// times out or is terminated, and the child policy is set to cancel child executions.
	Cause WorkflowExecutionCancelRequestedCause `locationName:"cause" type:"string" enum:"true"`

	// The ID of the RequestCancelExternalWorkflowExecutionInitiated event corresponding
	// to the RequestCancelExternalWorkflowExecution decision to cancel this workflow
	// execution.The source event with this ID can be found in the history of the
	// source workflow execution. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	ExternalInitiatedEventId *int64 `locationName:"externalInitiatedEventId" type:"long"`

	// The external workflow execution for which the cancellation was requested.
	ExternalWorkflowExecution *WorkflowExecution `locationName:"externalWorkflowExecution" type:"structure"`
}

// String returns the string representation
func (s WorkflowExecutionCancelRequestedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the WorkflowExecutionCanceled event.
type WorkflowExecutionCanceledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelWorkflowExecution decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The details of the cancellation.
	Details *string `locationName:"details" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionCanceledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the WorkflowExecutionCompleted event.
type WorkflowExecutionCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CompleteWorkflowExecution decision to complete this
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The result produced by the workflow execution upon successful completion.
	Result *string `locationName:"result" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// The configuration settings for a workflow execution including timeout values,
// tasklist etc. These configuration settings are determined from the defaults
// specified when registering the workflow type and those specified when starting
// the workflow execution.
type WorkflowExecutionConfiguration struct {
	_ struct{} `type:"structure"`

	// The policy to use for the child workflow executions if this workflow execution
	// is terminated, by calling the TerminateWorkflowExecution action explicitly
	// or due to an expired timeout.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// ChildPolicy is a required field
	ChildPolicy ChildPolicy `locationName:"childPolicy" type:"string" required:"true" enum:"true"`

	// The total duration for this workflow execution.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// ExecutionStartToCloseTimeout is a required field
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" min:"1" type:"string" required:"true"`

	// The IAM role attached to the child workflow execution.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The task list used for the decision tasks generated for this workflow execution.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// The priority assigned to decision tasks for this workflow execution. Valid
	// values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// The maximum duration allowed for decision tasks for this workflow execution.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// TaskStartToCloseTimeout is a required field
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the WorkflowExecutionContinuedAsNew event.
type WorkflowExecutionContinuedAsNewEventAttributes struct {
	_ struct{} `type:"structure"`

	// The policy to use for the child workflow executions of the new execution
	// if it is terminated by calling the TerminateWorkflowExecution action explicitly
	// or due to an expired timeout.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// ChildPolicy is a required field
	ChildPolicy ChildPolicy `locationName:"childPolicy" type:"string" required:"true" enum:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the ContinueAsNewWorkflowExecution decision that started
	// this execution. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The total duration allowed for the new workflow execution.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input provided to the new workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The IAM role to attach to the new (continued) workflow execution.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The runId of the new workflow execution.
	//
	// NewExecutionRunId is a required field
	NewExecutionRunId *string `locationName:"newExecutionRunId" min:"1" type:"string" required:"true"`

	// The list of tags associated with the new workflow execution.
	TagList []string `locationName:"tagList" type:"list"`

	// The task list to use for the decisions of the new (continued) workflow execution.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// The priority of the task to use for the decisions of the new (continued)
	// workflow execution.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// The maximum duration of decision tasks for the new workflow execution.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The workflow type of this execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionContinuedAsNewEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the WorkflowExecutionFailed event.
type WorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the FailWorkflowExecution decision to fail this execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The details of the failure.
	Details *string `locationName:"details" type:"string"`

	// The descriptive reason provided for the failure.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Used to filter the workflow executions in visibility APIs by their workflowId.
type WorkflowExecutionFilter struct {
	_ struct{} `type:"structure"`

	// The workflowId to pass of match the criteria of this filter.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkflowExecutionFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WorkflowExecutionFilter"}

	if s.WorkflowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about a workflow execution.
type WorkflowExecutionInfo struct {
	_ struct{} `type:"structure"`

	// Set to true if a cancellation is requested for this workflow execution.
	CancelRequested *bool `locationName:"cancelRequested" type:"boolean"`

	// If the execution status is closed then this specifies how the execution was
	// closed:
	//
	//    * COMPLETED – the execution was successfully completed.
	//
	//    * CANCELED – the execution was canceled.Cancellation allows the implementation
	//    to gracefully clean up before the execution is closed.
	//
	//    * TERMINATED – the execution was force terminated.
	//
	//    * FAILED – the execution failed to complete.
	//
	//    * TIMED_OUT – the execution did not complete in the alloted time and
	//    was automatically timed out.
	//
	//    * CONTINUED_AS_NEW – the execution is logically continued. This means
	//    the current execution was completed and a new execution was started to
	//    carry on the workflow.
	CloseStatus CloseStatus `locationName:"closeStatus" type:"string" enum:"true"`

	// The time when the workflow execution was closed. Set only if the execution
	// status is CLOSED.
	CloseTimestamp *time.Time `locationName:"closeTimestamp" type:"timestamp"`

	// The workflow execution this information is about.
	//
	// Execution is a required field
	Execution *WorkflowExecution `locationName:"execution" type:"structure" required:"true"`

	// The current status of the execution.
	//
	// ExecutionStatus is a required field
	ExecutionStatus ExecutionStatus `locationName:"executionStatus" type:"string" required:"true" enum:"true"`

	// If this workflow execution is a child of another execution then contains
	// the workflow execution that started this execution.
	Parent *WorkflowExecution `locationName:"parent" type:"structure"`

	// The time when the execution was started.
	//
	// StartTimestamp is a required field
	StartTimestamp *time.Time `locationName:"startTimestamp" type:"timestamp" required:"true"`

	// The list of tags associated with the workflow execution. Tags can be used
	// to identify and list workflow executions of interest through the visibility
	// APIs. A workflow execution can have a maximum of 5 tags.
	TagList []string `locationName:"tagList" type:"list"`

	// The type of the workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionInfo) String() string {
	return awsutil.Prettify(s)
}

// Contains the counts of open tasks, child workflow executions and timers for
// a workflow execution.
type WorkflowExecutionOpenCounts struct {
	_ struct{} `type:"structure"`

	// The count of activity tasks whose status is OPEN.
	//
	// OpenActivityTasks is a required field
	OpenActivityTasks *int64 `locationName:"openActivityTasks" type:"integer" required:"true"`

	// The count of child workflow executions whose status is OPEN.
	//
	// OpenChildWorkflowExecutions is a required field
	OpenChildWorkflowExecutions *int64 `locationName:"openChildWorkflowExecutions" type:"integer" required:"true"`

	// The count of decision tasks whose status is OPEN. A workflow execution can
	// have at most one open decision task.
	//
	// OpenDecisionTasks is a required field
	OpenDecisionTasks *int64 `locationName:"openDecisionTasks" type:"integer" required:"true"`

	// The count of Lambda tasks whose status is OPEN.
	OpenLambdaFunctions *int64 `locationName:"openLambdaFunctions" type:"integer"`

	// The count of timers started by this workflow execution that have not fired
	// yet.
	//
	// OpenTimers is a required field
	OpenTimers *int64 `locationName:"openTimers" type:"integer" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionOpenCounts) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the WorkflowExecutionSignaled event.
type WorkflowExecutionSignaledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the SignalExternalWorkflowExecutionInitiated event corresponding
	// to the SignalExternalWorkflow decision to signal this workflow execution.The
	// source event with this ID can be found in the history of the source workflow
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event. This field is set only
	// if the signal was initiated by another workflow execution.
	ExternalInitiatedEventId *int64 `locationName:"externalInitiatedEventId" type:"long"`

	// The workflow execution that sent the signal. This is set only of the signal
	// was sent by another workflow execution.
	ExternalWorkflowExecution *WorkflowExecution `locationName:"externalWorkflowExecution" type:"structure"`

	// The inputs provided with the signal. The decider can use the signal name
	// and inputs to determine how to process the signal.
	Input *string `locationName:"input" type:"string"`

	// The name of the signal received. The decider can use the signal name and
	// inputs to determine how to the process the signal.
	//
	// SignalName is a required field
	SignalName *string `locationName:"signalName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionSignaledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides details of WorkflowExecutionStarted event.
type WorkflowExecutionStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The policy to use for the child workflow executions if this workflow execution
	// is terminated, by calling the TerminateWorkflowExecution action explicitly
	// or due to an expired timeout.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// ChildPolicy is a required field
	ChildPolicy ChildPolicy `locationName:"childPolicy" type:"string" required:"true" enum:"true"`

	// If this workflow execution was started due to a ContinueAsNewWorkflowExecution
	// decision, then it contains the runId of the previous workflow execution that
	// was closed and continued as this execution.
	ContinuedExecutionRunId *string `locationName:"continuedExecutionRunId" type:"string"`

	// The maximum duration for this workflow execution.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input provided to the workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The IAM role attached to the workflow execution.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this workflow execution.
	// The source event with this ID can be found in the history of the source workflow
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	ParentInitiatedEventId *int64 `locationName:"parentInitiatedEventId" type:"long"`

	// The source workflow execution that started this workflow execution. The member
	// isn't set if the workflow execution was not started by a workflow.
	ParentWorkflowExecution *WorkflowExecution `locationName:"parentWorkflowExecution" type:"structure"`

	// The list of tags associated with this workflow execution. An execution can
	// have up to 5 tags.
	TagList []string `locationName:"tagList" type:"list"`

	// The name of the task list for scheduling the decision tasks for this workflow
	// execution.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// The priority of the decision tasks in the workflow execution.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// The maximum duration of decision tasks for this workflow type.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The workflow type of this execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the WorkflowExecutionTerminated event.
type WorkflowExecutionTerminatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// If set, indicates that the workflow execution was automatically terminated,
	// and specifies the cause. This happens if the parent workflow execution times
	// out or is terminated and the child policy is set to terminate child executions.
	Cause WorkflowExecutionTerminatedCause `locationName:"cause" type:"string" enum:"true"`

	// The policy used for the child workflow executions of this workflow execution.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// ChildPolicy is a required field
	ChildPolicy ChildPolicy `locationName:"childPolicy" type:"string" required:"true" enum:"true"`

	// The details provided for the termination.
	Details *string `locationName:"details" type:"string"`

	// The reason provided for the termination.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionTerminatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Provides the details of the WorkflowExecutionTimedOut event.
type WorkflowExecutionTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// The policy used for the child workflow executions of this workflow execution.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// ChildPolicy is a required field
	ChildPolicy ChildPolicy `locationName:"childPolicy" type:"string" required:"true" enum:"true"`

	// The type of timeout that caused this event.
	//
	// TimeoutType is a required field
	TimeoutType WorkflowExecutionTimeoutType `locationName:"timeoutType" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s WorkflowExecutionTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// Represents a workflow type.
type WorkflowType struct {
	_ struct{} `type:"structure"`

	// The name of the workflow type.
	//
	// The combination of workflow type name and version must be unique with in
	// a domain.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The version of the workflow type.
	//
	// The combination of workflow type name and version must be unique with in
	// a domain.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkflowType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WorkflowType"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Version == nil {
		invalidParams.Add(aws.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration settings of a workflow type.
type WorkflowTypeConfiguration struct {
	_ struct{} `type:"structure"`

	// The default policy to use for the child workflow executions when a workflow
	// execution of this type is terminated, by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This default can be overridden
	// when starting a workflow execution using the StartWorkflowExecution action
	// or the StartChildWorkflowExecution Decision.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	DefaultChildPolicy ChildPolicy `locationName:"defaultChildPolicy" type:"string" enum:"true"`

	// The default maximum duration, specified when registering the workflow type,
	// for executions of this workflow type. This default can be overridden when
	// starting a workflow execution using the StartWorkflowExecution action or
	// the StartChildWorkflowExecution Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultExecutionStartToCloseTimeout *string `locationName:"defaultExecutionStartToCloseTimeout" type:"string"`

	// The default IAM role attached to this workflow type.
	//
	// Executions of this workflow type need IAM roles to invoke Lambda functions.
	// If you don't specify an IAM role when starting this workflow type, the default
	// Lambda role is attached to the execution. For more information, see https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html)
	// in the Amazon SWF Developer Guide.
	DefaultLambdaRole *string `locationName:"defaultLambdaRole" min:"1" type:"string"`

	// The default task list, specified when registering the workflow type, for
	// decisions tasks scheduled for workflow executions of this type. This default
	// can be overridden when starting a workflow execution using the StartWorkflowExecution
	// action or the StartChildWorkflowExecution Decision.
	DefaultTaskList *TaskList `locationName:"defaultTaskList" type:"structure"`

	// The default task priority, specified when registering the workflow type,
	// for all decision tasks of this workflow type. This default can be overridden
	// when starting a workflow execution using the StartWorkflowExecution action
	// or the StartChildWorkflowExecution decision.
	//
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	DefaultTaskPriority *string `locationName:"defaultTaskPriority" type:"string"`

	// The default maximum duration, specified when registering the workflow type,
	// that a decision task for executions of this workflow type might take before
	// returning completion or failure. If the task doesn'tdo close in the specified
	// time then the task is automatically timed out and rescheduled. If the decider
	// eventually reports a completion or failure, it is ignored. This default can
	// be overridden when starting a workflow execution using the StartWorkflowExecution
	// action or the StartChildWorkflowExecution Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskStartToCloseTimeout *string `locationName:"defaultTaskStartToCloseTimeout" type:"string"`
}

// String returns the string representation
func (s WorkflowTypeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Used to filter workflow execution query results by type. Each parameter,
// if specified, defines a rule that must be satisfied by each returned result.
type WorkflowTypeFilter struct {
	_ struct{} `type:"structure"`

	// Name of the workflow type.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Version of the workflow type.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s WorkflowTypeFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkflowTypeFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WorkflowTypeFilter"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about a workflow type.
type WorkflowTypeInfo struct {
	_ struct{} `type:"structure"`

	// The date when this type was registered.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// If the type is in deprecated state, then it is set to the date when the type
	// was deprecated.
	DeprecationDate *time.Time `locationName:"deprecationDate" type:"timestamp"`

	// The description of the type registered through RegisterWorkflowType.
	Description *string `locationName:"description" type:"string"`

	// The current status of the workflow type.
	//
	// Status is a required field
	Status RegistrationStatus `locationName:"status" type:"string" required:"true" enum:"true"`

	// The workflow type this information is about.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s WorkflowTypeInfo) String() string {
	return awsutil.Prettify(s)
}
