// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

//line parser.rl:1
// Code generated by ragel DO NOT EDIT.
package syslog

//line parser.go:8
const syslog_start int = 0
const syslog_first_final int = 2
const syslog_error int = -1

const syslog_en_main int = 0
const syslog_en_catch_all int = 1

//line parser.rl:9

var (
	noDuplicates = []byte{'-', '.'}
)

// Parse parses Syslog events.
func Parse(data []byte, event *event) {
	var p, cs int
	pe := len(data)
	tok := 0
	eof := len(data)

//line parser.go:31
	{
		cs = syslog_start
	}

//line parser.go:36
	{
		if (p) == (pe) {
			goto _test_eof
		}
		switch cs {
		case 0:
			goto st_case_0
		case 2:
			goto st_case_2
		case 3:
			goto st_case_3
		case 4:
			goto st_case_4
		case 5:
			goto st_case_5
		case 6:
			goto st_case_6
		case 7:
			goto st_case_7
		case 8:
			goto st_case_8
		case 9:
			goto st_case_9
		case 10:
			goto st_case_10
		case 11:
			goto st_case_11
		case 12:
			goto st_case_12
		case 13:
			goto st_case_13
		case 14:
			goto st_case_14
		case 15:
			goto st_case_15
		case 16:
			goto st_case_16
		case 17:
			goto st_case_17
		case 18:
			goto st_case_18
		case 19:
			goto st_case_19
		case 20:
			goto st_case_20
		case 21:
			goto st_case_21
		case 22:
			goto st_case_22
		case 23:
			goto st_case_23
		case 24:
			goto st_case_24
		case 25:
			goto st_case_25
		case 26:
			goto st_case_26
		case 27:
			goto st_case_27
		case 28:
			goto st_case_28
		case 29:
			goto st_case_29
		case 30:
			goto st_case_30
		case 31:
			goto st_case_31
		case 32:
			goto st_case_32
		case 33:
			goto st_case_33
		case 34:
			goto st_case_34
		case 35:
			goto st_case_35
		case 36:
			goto st_case_36
		case 37:
			goto st_case_37
		case 38:
			goto st_case_38
		case 39:
			goto st_case_39
		case 40:
			goto st_case_40
		case 41:
			goto st_case_41
		case 42:
			goto st_case_42
		case 43:
			goto st_case_43
		case 44:
			goto st_case_44
		case 45:
			goto st_case_45
		case 46:
			goto st_case_46
		case 47:
			goto st_case_47
		case 48:
			goto st_case_48
		case 49:
			goto st_case_49
		case 50:
			goto st_case_50
		case 51:
			goto st_case_51
		case 52:
			goto st_case_52
		case 53:
			goto st_case_53
		case 54:
			goto st_case_54
		case 55:
			goto st_case_55
		case 56:
			goto st_case_56
		case 57:
			goto st_case_57
		case 58:
			goto st_case_58
		case 59:
			goto st_case_59
		case 60:
			goto st_case_60
		case 61:
			goto st_case_61
		case 62:
			goto st_case_62
		case 63:
			goto st_case_63
		case 64:
			goto st_case_64
		case 65:
			goto st_case_65
		case 66:
			goto st_case_66
		case 67:
			goto st_case_67
		case 68:
			goto st_case_68
		case 69:
			goto st_case_69
		case 70:
			goto st_case_70
		case 71:
			goto st_case_71
		case 72:
			goto st_case_72
		case 73:
			goto st_case_73
		case 74:
			goto st_case_74
		case 75:
			goto st_case_75
		case 76:
			goto st_case_76
		case 77:
			goto st_case_77
		case 78:
			goto st_case_78
		case 79:
			goto st_case_79
		case 80:
			goto st_case_80
		case 81:
			goto st_case_81
		case 82:
			goto st_case_82
		case 83:
			goto st_case_83
		case 84:
			goto st_case_84
		case 85:
			goto st_case_85
		case 86:
			goto st_case_86
		case 87:
			goto st_case_87
		case 88:
			goto st_case_88
		case 89:
			goto st_case_89
		case 90:
			goto st_case_90
		case 91:
			goto st_case_91
		case 92:
			goto st_case_92
		case 93:
			goto st_case_93
		case 94:
			goto st_case_94
		case 95:
			goto st_case_95
		case 96:
			goto st_case_96
		case 97:
			goto st_case_97
		case 98:
			goto st_case_98
		case 99:
			goto st_case_99
		case 100:
			goto st_case_100
		case 101:
			goto st_case_101
		case 102:
			goto st_case_102
		case 103:
			goto st_case_103
		case 104:
			goto st_case_104
		case 105:
			goto st_case_105
		case 106:
			goto st_case_106
		case 107:
			goto st_case_107
		case 108:
			goto st_case_108
		case 109:
			goto st_case_109
		case 110:
			goto st_case_110
		case 111:
			goto st_case_111
		case 112:
			goto st_case_112
		case 113:
			goto st_case_113
		case 114:
			goto st_case_114
		case 115:
			goto st_case_115
		case 116:
			goto st_case_116
		case 117:
			goto st_case_117
		case 118:
			goto st_case_118
		case 119:
			goto st_case_119
		case 120:
			goto st_case_120
		case 1:
			goto st_case_1
		case 121:
			goto st_case_121
		}
		goto st_out
	st_case_0:
		switch data[(p)] {
		case 32:
			goto tr1
		case 42:
			goto tr1
		case 46:
			goto tr1
		case 60:
			goto tr3
		case 65:
			goto tr4
		case 68:
			goto tr5
		case 70:
			goto tr6
		case 74:
			goto tr7
		case 77:
			goto tr8
		case 78:
			goto tr9
		case 79:
			goto tr10
		case 83:
			goto tr11
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto tr2
		}
		goto tr0
	tr0:
//line parser.rl:22

		tok = p

		goto st2
	tr133:
//line parser.rl:97

		event.SetSequence(data[tok:p])

//line parser.rl:22

		tok = p

		goto st2
	st2:
		if (p)++; (p) == (pe) {
			goto _test_eof2
		}
	st_case_2:
//line parser.go:340
		goto st2
	tr1:
//line parser.rl:22

		tok = p

		goto st3
	tr134:
//line parser.rl:97

		event.SetSequence(data[tok:p])

//line parser.rl:22

		tok = p

		goto st3
	st3:
		if (p)++; (p) == (pe) {
			goto _test_eof3
		}
	st_case_3:
//line parser.go:363
		switch data[(p)] {
		case 65:
			goto tr4
		case 68:
			goto tr5
		case 70:
			goto tr6
		case 74:
			goto tr7
		case 77:
			goto tr8
		case 78:
			goto tr9
		case 79:
			goto tr10
		case 83:
			goto tr11
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto tr14
		}
		goto st2
	tr14:
//line parser.rl:22

		tok = p

		goto st4
	tr135:
//line parser.rl:97

		event.SetSequence(data[tok:p])

//line parser.rl:22

		tok = p

		goto st4
	st4:
		if (p)++; (p) == (pe) {
			goto _test_eof4
		}
	st_case_4:
//line parser.go:407
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st5
		}
		goto st2
	st5:
		if (p)++; (p) == (pe) {
			goto _test_eof5
		}
	st_case_5:
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st6
		}
		goto st2
	st6:
		if (p)++; (p) == (pe) {
			goto _test_eof6
		}
	st_case_6:
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st7
		}
		goto st2
	st7:
		if (p)++; (p) == (pe) {
			goto _test_eof7
		}
	st_case_7:
		if data[(p)] == 45 {
			goto tr18
		}
		goto st2
	tr18:
//line parser.rl:38

		event.SetYear(data[tok:p])

		goto st8
	st8:
		if (p)++; (p) == (pe) {
			goto _test_eof8
		}
	st_case_8:
//line parser.go:450
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto tr19
		}
		goto st2
	tr19:
//line parser.rl:22

		tok = p

		goto st9
	st9:
		if (p)++; (p) == (pe) {
			goto _test_eof9
		}
	st_case_9:
//line parser.go:466
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st10
		}
		goto st2
	st10:
		if (p)++; (p) == (pe) {
			goto _test_eof10
		}
	st_case_10:
		if data[(p)] == 45 {
			goto tr21
		}
		goto st2
	tr21:
//line parser.rl:42

		event.SetMonthNumeric(data[tok:p])

		goto st11
	st11:
		if (p)++; (p) == (pe) {
			goto _test_eof11
		}
	st_case_11:
//line parser.go:491
		if 48 <= data[(p)] && data[(p)] <= 51 {
			goto tr22
		}
		goto st2
	tr22:
//line parser.rl:22

		tok = p

		goto st12
	st12:
		if (p)++; (p) == (pe) {
			goto _test_eof12
		}
	st_case_12:
//line parser.go:507
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st13
		}
		goto st2
	st13:
		if (p)++; (p) == (pe) {
			goto _test_eof13
		}
	st_case_13:
		switch data[(p)] {
		case 32:
			goto tr24
		case 84:
			goto tr24
		case 116:
			goto tr24
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr24
		}
		goto st2
	tr24:
//line parser.rl:46

		event.SetDay(data[tok:p])

		goto st14
	st14:
		if (p)++; (p) == (pe) {
			goto _test_eof14
		}
	st_case_14:
//line parser.go:540
		if data[(p)] == 50 {
			goto tr26
		}
		if 48 <= data[(p)] && data[(p)] <= 49 {
			goto tr25
		}
		goto st2
	tr25:
//line parser.rl:22

		tok = p

		goto st15
	st15:
		if (p)++; (p) == (pe) {
			goto _test_eof15
		}
	st_case_15:
//line parser.go:559
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st16
		}
		goto st2
	st16:
		if (p)++; (p) == (pe) {
			goto _test_eof16
		}
	st_case_16:
		if data[(p)] == 58 {
			goto tr28
		}
		goto st2
	tr28:
//line parser.rl:50

		event.SetHour(data[tok:p])

		goto st17
	st17:
		if (p)++; (p) == (pe) {
			goto _test_eof17
		}
	st_case_17:
//line parser.go:584
		if 48 <= data[(p)] && data[(p)] <= 53 {
			goto tr29
		}
		goto st2
	tr29:
//line parser.rl:22

		tok = p

		goto st18
	st18:
		if (p)++; (p) == (pe) {
			goto _test_eof18
		}
	st_case_18:
//line parser.go:600
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st19
		}
		goto st2
	st19:
		if (p)++; (p) == (pe) {
			goto _test_eof19
		}
	st_case_19:
		if data[(p)] == 58 {
			goto tr31
		}
		goto st2
	tr31:
//line parser.rl:54

		event.SetMinute(data[tok:p])

		goto st20
	st20:
		if (p)++; (p) == (pe) {
			goto _test_eof20
		}
	st_case_20:
//line parser.go:625
		if 48 <= data[(p)] && data[(p)] <= 53 {
			goto tr32
		}
		goto st2
	tr32:
//line parser.rl:22

		tok = p

		goto st21
	st21:
		if (p)++; (p) == (pe) {
			goto _test_eof21
		}
	st_case_21:
//line parser.go:641
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st22
		}
		goto st2
	st22:
		if (p)++; (p) == (pe) {
			goto _test_eof22
		}
	st_case_22:
		switch data[(p)] {
		case 32:
			goto tr34
		case 43:
			goto tr35
		case 45:
			goto tr35
		case 46:
			goto tr36
		case 58:
			goto tr37
		case 90:
			goto tr38
		case 122:
			goto tr38
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr34
		}
		goto st2
	tr34:
//line parser.rl:58

		event.SetSecond(data[tok:p])

		goto st23
	tr61:
//line parser.rl:93

		event.SetTimeZone(data[tok:p])

		goto st23
	tr68:
//line parser.rl:62

		event.SetNanosecond(data[tok:p])

		goto st23
	st23:
		if (p)++; (p) == (pe) {
			goto _test_eof23
		}
	st_case_23:
//line parser.go:694
		switch data[(p)] {
		case 58:
			goto tr41
		case 95:
			goto tr39
		}
		switch {
		case data[(p)] < 48:
			if 45 <= data[(p)] && data[(p)] <= 46 {
				goto tr39
			}
		case data[(p)] > 57:
			switch {
			case data[(p)] > 90:
				if 97 <= data[(p)] && data[(p)] <= 122 {
					goto tr40
				}
			case data[(p)] >= 65:
				goto tr40
			}
		default:
			goto tr40
		}
		goto tr0
	tr39:
//line parser.rl:22

		tok = p

//line parser.rl:70

		if p-1 > 0 {
			for _, b := range noDuplicates {
				if data[p] == b && data[p-1] == b {
					p = tok - 1
					{
						goto st1
					}
				}
			}
		}

		goto st24
	tr42:
//line parser.rl:70

		if p-1 > 0 {
			for _, b := range noDuplicates {
				if data[p] == b && data[p-1] == b {
					p = tok - 1
					{
						goto st1
					}
				}
			}
		}

		goto st24
	st24:
		if (p)++; (p) == (pe) {
			goto _test_eof24
		}
	st_case_24:
//line parser.go:754
		switch data[(p)] {
		case 58:
			goto tr44
		case 95:
			goto tr42
		}
		switch {
		case data[(p)] < 48:
			if 45 <= data[(p)] && data[(p)] <= 46 {
				goto tr42
			}
		case data[(p)] > 57:
			switch {
			case data[(p)] > 90:
				if 97 <= data[(p)] && data[(p)] <= 122 {
					goto tr43
				}
			case data[(p)] >= 65:
				goto tr43
			}
		default:
			goto tr43
		}
		goto st2
	tr40:
//line parser.rl:22

		tok = p

//line parser.rl:70

		if p-1 > 0 {
			for _, b := range noDuplicates {
				if data[p] == b && data[p-1] == b {
					p = tok - 1
					{
						goto st1
					}
				}
			}
		}

		goto st25
	tr43:
//line parser.rl:70

		if p-1 > 0 {
			for _, b := range noDuplicates {
				if data[p] == b && data[p-1] == b {
					p = tok - 1
					{
						goto st1
					}
				}
			}
		}

		goto st25
	st25:
		if (p)++; (p) == (pe) {
			goto _test_eof25
		}
	st_case_25:
//line parser.go:814
		switch data[(p)] {
		case 32:
			goto tr45
		case 58:
			goto tr46
		case 95:
			goto tr42
		}
		switch {
		case data[(p)] < 48:
			switch {
			case data[(p)] > 13:
				if 45 <= data[(p)] && data[(p)] <= 46 {
					goto tr42
				}
			case data[(p)] >= 9:
				goto tr45
			}
		case data[(p)] > 57:
			switch {
			case data[(p)] > 90:
				if 97 <= data[(p)] && data[(p)] <= 122 {
					goto tr43
				}
			case data[(p)] >= 65:
				goto tr43
			}
		default:
			goto tr43
		}
		goto st2
	tr45:
//line parser.rl:81

		event.SetHostname(data[tok:p])

		goto st26
	st26:
		if (p)++; (p) == (pe) {
			goto _test_eof26
		}
	st_case_26:
//line parser.go:857
		switch data[(p)] {
		case 32:
			goto tr0
		case 91:
			goto tr0
		case 93:
			goto tr0
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr0
		}
		goto tr47
	tr47:
//line parser.rl:22

		tok = p

		goto st27
	st27:
		if (p)++; (p) == (pe) {
			goto _test_eof27
		}
	st_case_27:
//line parser.go:881
		switch data[(p)] {
		case 32:
			goto st2
		case 58:
			goto tr49
		case 91:
			goto tr50
		case 93:
			goto st2
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto st2
		}
		goto st27
	tr49:
//line parser.rl:85

		event.SetProgram(data[tok:p])

		goto st28
	st28:
		if (p)++; (p) == (pe) {
			goto _test_eof28
		}
	st_case_28:
//line parser.go:907
		switch data[(p)] {
		case 32:
			goto st29
		case 58:
			goto tr49
		case 91:
			goto tr50
		case 93:
			goto st2
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto st29
		}
		goto st27
	st29:
		if (p)++; (p) == (pe) {
			goto _test_eof29
		}
	st_case_29:
		goto tr0
	tr50:
//line parser.rl:85

		event.SetProgram(data[tok:p])

		goto st30
	st30:
		if (p)++; (p) == (pe) {
			goto _test_eof30
		}
	st_case_30:
//line parser.go:939
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto tr52
		}
		goto st2
	tr52:
//line parser.rl:22

		tok = p

		goto st31
	st31:
		if (p)++; (p) == (pe) {
			goto _test_eof31
		}
	st_case_31:
//line parser.go:955
		if data[(p)] == 93 {
			goto tr54
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st31
		}
		goto st2
	tr54:
//line parser.rl:89

		event.SetPid(data[tok:p])

		goto st32
	st32:
		if (p)++; (p) == (pe) {
			goto _test_eof32
		}
	st_case_32:
//line parser.go:974
		if data[(p)] == 58 {
			goto st33
		}
		goto st2
	st33:
		if (p)++; (p) == (pe) {
			goto _test_eof33
		}
	st_case_33:
		if data[(p)] == 32 {
			goto st29
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto st29
		}
		goto st2
	tr46:
//line parser.rl:70

		if p-1 > 0 {
			for _, b := range noDuplicates {
				if data[p] == b && data[p-1] == b {
					p = tok - 1
					{
						goto st1
					}
				}
			}
		}

//line parser.rl:81

		event.SetHostname(data[tok:p])

		goto st34
	st34:
		if (p)++; (p) == (pe) {
			goto _test_eof34
		}
	st_case_34:
//line parser.go:1013
		switch data[(p)] {
		case 32:
			goto st26
		case 58:
			goto tr57
		case 95:
			goto tr42
		}
		switch {
		case data[(p)] < 48:
			switch {
			case data[(p)] > 13:
				if 45 <= data[(p)] && data[(p)] <= 46 {
					goto tr42
				}
			case data[(p)] >= 9:
				goto st26
			}
		case data[(p)] > 57:
			switch {
			case data[(p)] > 90:
				if 97 <= data[(p)] && data[(p)] <= 122 {
					goto tr43
				}
			case data[(p)] >= 65:
				goto tr43
			}
		default:
			goto tr43
		}
		goto st2
	tr57:
//line parser.rl:70

		if p-1 > 0 {
			for _, b := range noDuplicates {
				if data[p] == b && data[p-1] == b {
					p = tok - 1
					{
						goto st1
					}
				}
			}
		}

		goto st35
	tr58:
//line parser.rl:70

		if p-1 > 0 {
			for _, b := range noDuplicates {
				if data[p] == b && data[p-1] == b {
					p = tok - 1
					{
						goto st1
					}
				}
			}
		}

//line parser.rl:81

		event.SetHostname(data[tok:p])

		goto st35
	st35:
		if (p)++; (p) == (pe) {
			goto _test_eof35
		}
	st_case_35:
//line parser.go:1080
		switch data[(p)] {
		case 32:
			goto tr45
		case 58:
			goto tr58
		case 95:
			goto tr42
		}
		switch {
		case data[(p)] < 48:
			switch {
			case data[(p)] > 13:
				if 45 <= data[(p)] && data[(p)] <= 46 {
					goto tr42
				}
			case data[(p)] >= 9:
				goto tr45
			}
		case data[(p)] > 57:
			switch {
			case data[(p)] > 90:
				if 97 <= data[(p)] && data[(p)] <= 122 {
					goto tr43
				}
			case data[(p)] >= 65:
				goto tr43
			}
		default:
			goto tr43
		}
		goto st2
	tr41:
//line parser.rl:22

		tok = p

//line parser.rl:70

		if p-1 > 0 {
			for _, b := range noDuplicates {
				if data[p] == b && data[p-1] == b {
					p = tok - 1
					{
						goto st1
					}
				}
			}
		}

		goto st36
	tr44:
//line parser.rl:70

		if p-1 > 0 {
			for _, b := range noDuplicates {
				if data[p] == b && data[p-1] == b {
					p = tok - 1
					{
						goto st1
					}
				}
			}
		}

		goto st36
	st36:
		if (p)++; (p) == (pe) {
			goto _test_eof36
		}
	st_case_36:
//line parser.go:1147
		switch data[(p)] {
		case 58:
			goto tr57
		case 95:
			goto tr42
		}
		switch {
		case data[(p)] < 48:
			if 45 <= data[(p)] && data[(p)] <= 46 {
				goto tr42
			}
		case data[(p)] > 57:
			switch {
			case data[(p)] > 90:
				if 97 <= data[(p)] && data[(p)] <= 122 {
					goto tr43
				}
			case data[(p)] >= 65:
				goto tr43
			}
		default:
			goto tr43
		}
		goto st2
	tr35:
//line parser.rl:58

		event.SetSecond(data[tok:p])

//line parser.rl:22

		tok = p

		goto st37
	tr69:
//line parser.rl:62

		event.SetNanosecond(data[tok:p])

//line parser.rl:22

		tok = p

		goto st37
	st37:
		if (p)++; (p) == (pe) {
			goto _test_eof37
		}
	st_case_37:
//line parser.go:1197
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st38
		}
		goto st2
	st38:
		if (p)++; (p) == (pe) {
			goto _test_eof38
		}
	st_case_38:
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st39
		}
		goto st2
	st39:
		if (p)++; (p) == (pe) {
			goto _test_eof39
		}
	st_case_39:
		switch data[(p)] {
		case 32:
			goto tr61
		case 58:
			goto tr63
		}
		switch {
		case data[(p)] > 13:
			if 48 <= data[(p)] && data[(p)] <= 57 {
				goto st40
			}
		case data[(p)] >= 9:
			goto tr61
		}
		goto st2
	st40:
		if (p)++; (p) == (pe) {
			goto _test_eof40
		}
	st_case_40:
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st41
		}
		goto st2
	st41:
		if (p)++; (p) == (pe) {
			goto _test_eof41
		}
	st_case_41:
		switch data[(p)] {
		case 32:
			goto tr61
		case 58:
			goto tr65
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr61
		}
		goto st2
	tr37:
//line parser.rl:58

		event.SetSecond(data[tok:p])

		goto st42
	tr65:
//line parser.rl:93

		event.SetTimeZone(data[tok:p])

		goto st42
	tr71:
//line parser.rl:62

		event.SetNanosecond(data[tok:p])

		goto st42
	st42:
		if (p)++; (p) == (pe) {
			goto _test_eof42
		}
	st_case_42:
//line parser.go:1278
		if data[(p)] == 32 {
			goto st23
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto st23
		}
		goto st2
	tr63:
//line parser.rl:93

		event.SetTimeZone(data[tok:p])

		goto st43
	st43:
		if (p)++; (p) == (pe) {
			goto _test_eof43
		}
	st_case_43:
//line parser.go:1297
		if data[(p)] == 32 {
			goto st23
		}
		switch {
		case data[(p)] > 13:
			if 48 <= data[(p)] && data[(p)] <= 57 {
				goto st40
			}
		case data[(p)] >= 9:
			goto st23
		}
		goto st2
	tr36:
//line parser.rl:58

		event.SetSecond(data[tok:p])

		goto st44
	st44:
		if (p)++; (p) == (pe) {
			goto _test_eof44
		}
	st_case_44:
//line parser.go:1321
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto tr67
		}
		goto st2
	tr67:
//line parser.rl:22

		tok = p

		goto st45
	st45:
		if (p)++; (p) == (pe) {
			goto _test_eof45
		}
	st_case_45:
//line parser.go:1337
		switch data[(p)] {
		case 32:
			goto tr68
		case 43:
			goto tr69
		case 45:
			goto tr69
		case 58:
			goto tr71
		case 90:
			goto tr72
		case 122:
			goto tr72
		}
		switch {
		case data[(p)] > 13:
			if 48 <= data[(p)] && data[(p)] <= 57 {
				goto st45
			}
		case data[(p)] >= 9:
			goto tr68
		}
		goto st2
	tr38:
//line parser.rl:58

		event.SetSecond(data[tok:p])

//line parser.rl:22

		tok = p

		goto st46
	tr72:
//line parser.rl:62

		event.SetNanosecond(data[tok:p])

//line parser.rl:22

		tok = p

		goto st46
	st46:
		if (p)++; (p) == (pe) {
			goto _test_eof46
		}
	st_case_46:
//line parser.go:1386
		switch data[(p)] {
		case 32:
			goto tr61
		case 43:
			goto st37
		case 45:
			goto st37
		case 58:
			goto tr65
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr61
		}
		goto st2
	tr26:
//line parser.rl:22

		tok = p

		goto st47
	st47:
		if (p)++; (p) == (pe) {
			goto _test_eof47
		}
	st_case_47:
//line parser.go:1412
		if 48 <= data[(p)] && data[(p)] <= 51 {
			goto st16
		}
		goto st2
	tr4:
//line parser.rl:22

		tok = p

		goto st48
	tr136:
//line parser.rl:97

		event.SetSequence(data[tok:p])

//line parser.rl:22

		tok = p

		goto st48
	st48:
		if (p)++; (p) == (pe) {
			goto _test_eof48
		}
	st_case_48:
//line parser.go:1438
		switch data[(p)] {
		case 112:
			goto st49
		case 117:
			goto st70
		}
		goto st2
	st49:
		if (p)++; (p) == (pe) {
			goto _test_eof49
		}
	st_case_49:
		if data[(p)] == 114 {
			goto st50
		}
		goto st2
	st50:
		if (p)++; (p) == (pe) {
			goto _test_eof50
		}
	st_case_50:
		switch data[(p)] {
		case 32:
			goto tr77
		case 105:
			goto st68
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr77
		}
		goto st2
	tr77:
//line parser.rl:34

		event.SetMonth(data[tok:p])

		goto st51
	st51:
		if (p)++; (p) == (pe) {
			goto _test_eof51
		}
	st_case_51:
//line parser.go:1481
		switch data[(p)] {
		case 32:
			goto st52
		case 51:
			goto tr81
		}
		switch {
		case data[(p)] < 49:
			if 9 <= data[(p)] && data[(p)] <= 13 {
				goto st52
			}
		case data[(p)] > 50:
			if 52 <= data[(p)] && data[(p)] <= 57 {
				goto tr82
			}
		default:
			goto tr80
		}
		goto st2
	st52:
		if (p)++; (p) == (pe) {
			goto _test_eof52
		}
	st_case_52:
		if 49 <= data[(p)] && data[(p)] <= 57 {
			goto tr82
		}
		goto st2
	tr82:
//line parser.rl:22

		tok = p

		goto st53
	st53:
		if (p)++; (p) == (pe) {
			goto _test_eof53
		}
	st_case_53:
//line parser.go:1521
		if data[(p)] == 32 {
			goto tr83
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr83
		}
		goto st2
	tr83:
//line parser.rl:46

		event.SetDay(data[tok:p])

		goto st54
	st54:
		if (p)++; (p) == (pe) {
			goto _test_eof54
		}
	st_case_54:
//line parser.go:1540
		if data[(p)] == 50 {
			goto tr85
		}
		if 48 <= data[(p)] && data[(p)] <= 49 {
			goto tr84
		}
		goto st2
	tr84:
//line parser.rl:22

		tok = p

		goto st55
	st55:
		if (p)++; (p) == (pe) {
			goto _test_eof55
		}
	st_case_55:
//line parser.go:1559
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st56
		}
		goto st2
	st56:
		if (p)++; (p) == (pe) {
			goto _test_eof56
		}
	st_case_56:
		if data[(p)] == 58 {
			goto tr87
		}
		goto st2
	tr87:
//line parser.rl:50

		event.SetHour(data[tok:p])

		goto st57
	st57:
		if (p)++; (p) == (pe) {
			goto _test_eof57
		}
	st_case_57:
//line parser.go:1584
		if 48 <= data[(p)] && data[(p)] <= 53 {
			goto tr88
		}
		goto st2
	tr88:
//line parser.rl:22

		tok = p

		goto st58
	st58:
		if (p)++; (p) == (pe) {
			goto _test_eof58
		}
	st_case_58:
//line parser.go:1600
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st59
		}
		goto st2
	st59:
		if (p)++; (p) == (pe) {
			goto _test_eof59
		}
	st_case_59:
		if data[(p)] == 58 {
			goto tr90
		}
		goto st2
	tr90:
//line parser.rl:54

		event.SetMinute(data[tok:p])

		goto st60
	st60:
		if (p)++; (p) == (pe) {
			goto _test_eof60
		}
	st_case_60:
//line parser.go:1625
		if 48 <= data[(p)] && data[(p)] <= 53 {
			goto tr91
		}
		goto st2
	tr91:
//line parser.rl:22

		tok = p

		goto st61
	st61:
		if (p)++; (p) == (pe) {
			goto _test_eof61
		}
	st_case_61:
//line parser.go:1641
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st62
		}
		goto st2
	st62:
		if (p)++; (p) == (pe) {
			goto _test_eof62
		}
	st_case_62:
		switch data[(p)] {
		case 32:
			goto tr34
		case 46:
			goto tr93
		case 58:
			goto tr37
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr34
		}
		goto st2
	tr93:
//line parser.rl:58

		event.SetSecond(data[tok:p])

		goto st63
	st63:
		if (p)++; (p) == (pe) {
			goto _test_eof63
		}
	st_case_63:
//line parser.go:1674
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto tr94
		}
		goto st2
	tr94:
//line parser.rl:22

		tok = p

		goto st64
	st64:
		if (p)++; (p) == (pe) {
			goto _test_eof64
		}
	st_case_64:
//line parser.go:1690
		switch data[(p)] {
		case 32:
			goto tr68
		case 58:
			goto tr71
		}
		switch {
		case data[(p)] > 13:
			if 48 <= data[(p)] && data[(p)] <= 57 {
				goto st64
			}
		case data[(p)] >= 9:
			goto tr68
		}
		goto st2
	tr85:
//line parser.rl:22

		tok = p

		goto st65
	st65:
		if (p)++; (p) == (pe) {
			goto _test_eof65
		}
	st_case_65:
//line parser.go:1717
		if 48 <= data[(p)] && data[(p)] <= 51 {
			goto st56
		}
		goto st2
	tr80:
//line parser.rl:22

		tok = p

		goto st66
	st66:
		if (p)++; (p) == (pe) {
			goto _test_eof66
		}
	st_case_66:
//line parser.go:1733
		if data[(p)] == 32 {
			goto tr83
		}
		switch {
		case data[(p)] > 13:
			if 48 <= data[(p)] && data[(p)] <= 57 {
				goto st53
			}
		case data[(p)] >= 9:
			goto tr83
		}
		goto st2
	tr81:
//line parser.rl:22

		tok = p

		goto st67
	st67:
		if (p)++; (p) == (pe) {
			goto _test_eof67
		}
	st_case_67:
//line parser.go:1757
		if data[(p)] == 32 {
			goto tr83
		}
		switch {
		case data[(p)] > 13:
			if 48 <= data[(p)] && data[(p)] <= 49 {
				goto st53
			}
		case data[(p)] >= 9:
			goto tr83
		}
		goto st2
	st68:
		if (p)++; (p) == (pe) {
			goto _test_eof68
		}
	st_case_68:
		if data[(p)] == 108 {
			goto st69
		}
		goto st2
	st69:
		if (p)++; (p) == (pe) {
			goto _test_eof69
		}
	st_case_69:
		if data[(p)] == 32 {
			goto tr77
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr77
		}
		goto st2
	st70:
		if (p)++; (p) == (pe) {
			goto _test_eof70
		}
	st_case_70:
		if data[(p)] == 103 {
			goto st71
		}
		goto st2
	st71:
		if (p)++; (p) == (pe) {
			goto _test_eof71
		}
	st_case_71:
		switch data[(p)] {
		case 32:
			goto tr77
		case 117:
			goto st72
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr77
		}
		goto st2
	st72:
		if (p)++; (p) == (pe) {
			goto _test_eof72
		}
	st_case_72:
		if data[(p)] == 115 {
			goto st73
		}
		goto st2
	st73:
		if (p)++; (p) == (pe) {
			goto _test_eof73
		}
	st_case_73:
		if data[(p)] == 116 {
			goto st69
		}
		goto st2
	tr5:
//line parser.rl:22

		tok = p

		goto st74
	tr137:
//line parser.rl:97

		event.SetSequence(data[tok:p])

//line parser.rl:22

		tok = p

		goto st74
	st74:
		if (p)++; (p) == (pe) {
			goto _test_eof74
		}
	st_case_74:
//line parser.go:1854
		if data[(p)] == 101 {
			goto st75
		}
		goto st2
	st75:
		if (p)++; (p) == (pe) {
			goto _test_eof75
		}
	st_case_75:
		if data[(p)] == 99 {
			goto st76
		}
		goto st2
	st76:
		if (p)++; (p) == (pe) {
			goto _test_eof76
		}
	st_case_76:
		switch data[(p)] {
		case 32:
			goto tr77
		case 101:
			goto st77
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr77
		}
		goto st2
	st77:
		if (p)++; (p) == (pe) {
			goto _test_eof77
		}
	st_case_77:
		if data[(p)] == 109 {
			goto st78
		}
		goto st2
	st78:
		if (p)++; (p) == (pe) {
			goto _test_eof78
		}
	st_case_78:
		if data[(p)] == 98 {
			goto st79
		}
		goto st2
	st79:
		if (p)++; (p) == (pe) {
			goto _test_eof79
		}
	st_case_79:
		if data[(p)] == 101 {
			goto st80
		}
		goto st2
	st80:
		if (p)++; (p) == (pe) {
			goto _test_eof80
		}
	st_case_80:
		if data[(p)] == 114 {
			goto st69
		}
		goto st2
	tr6:
//line parser.rl:22

		tok = p

		goto st81
	tr138:
//line parser.rl:97

		event.SetSequence(data[tok:p])

//line parser.rl:22

		tok = p

		goto st81
	st81:
		if (p)++; (p) == (pe) {
			goto _test_eof81
		}
	st_case_81:
//line parser.go:1940
		if data[(p)] == 101 {
			goto st82
		}
		goto st2
	st82:
		if (p)++; (p) == (pe) {
			goto _test_eof82
		}
	st_case_82:
		if data[(p)] == 98 {
			goto st83
		}
		goto st2
	st83:
		if (p)++; (p) == (pe) {
			goto _test_eof83
		}
	st_case_83:
		switch data[(p)] {
		case 32:
			goto tr77
		case 114:
			goto st84
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr77
		}
		goto st2
	st84:
		if (p)++; (p) == (pe) {
			goto _test_eof84
		}
	st_case_84:
		if data[(p)] == 117 {
			goto st85
		}
		goto st2
	st85:
		if (p)++; (p) == (pe) {
			goto _test_eof85
		}
	st_case_85:
		if data[(p)] == 97 {
			goto st86
		}
		goto st2
	st86:
		if (p)++; (p) == (pe) {
			goto _test_eof86
		}
	st_case_86:
		if data[(p)] == 114 {
			goto st87
		}
		goto st2
	st87:
		if (p)++; (p) == (pe) {
			goto _test_eof87
		}
	st_case_87:
		if data[(p)] == 121 {
			goto st69
		}
		goto st2
	tr7:
//line parser.rl:22

		tok = p

		goto st88
	tr139:
//line parser.rl:97

		event.SetSequence(data[tok:p])

//line parser.rl:22

		tok = p

		goto st88
	st88:
		if (p)++; (p) == (pe) {
			goto _test_eof88
		}
	st_case_88:
//line parser.go:2026
		switch data[(p)] {
		case 97:
			goto st89
		case 117:
			goto st91
		}
		goto st2
	st89:
		if (p)++; (p) == (pe) {
			goto _test_eof89
		}
	st_case_89:
		if data[(p)] == 110 {
			goto st90
		}
		goto st2
	st90:
		if (p)++; (p) == (pe) {
			goto _test_eof90
		}
	st_case_90:
		switch data[(p)] {
		case 32:
			goto tr77
		case 117:
			goto st85
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr77
		}
		goto st2
	st91:
		if (p)++; (p) == (pe) {
			goto _test_eof91
		}
	st_case_91:
		switch data[(p)] {
		case 108:
			goto st92
		case 110:
			goto st93
		}
		goto st2
	st92:
		if (p)++; (p) == (pe) {
			goto _test_eof92
		}
	st_case_92:
		switch data[(p)] {
		case 32:
			goto tr77
		case 121:
			goto st69
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr77
		}
		goto st2
	st93:
		if (p)++; (p) == (pe) {
			goto _test_eof93
		}
	st_case_93:
		switch data[(p)] {
		case 32:
			goto tr77
		case 101:
			goto st69
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr77
		}
		goto st2
	tr8:
//line parser.rl:22

		tok = p

		goto st94
	tr140:
//line parser.rl:97

		event.SetSequence(data[tok:p])

//line parser.rl:22

		tok = p

		goto st94
	st94:
		if (p)++; (p) == (pe) {
			goto _test_eof94
		}
	st_case_94:
//line parser.go:2121
		if data[(p)] == 97 {
			goto st95
		}
		goto st2
	st95:
		if (p)++; (p) == (pe) {
			goto _test_eof95
		}
	st_case_95:
		switch data[(p)] {
		case 32:
			goto tr77
		case 114:
			goto st96
		case 121:
			goto st69
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr77
		}
		goto st2
	st96:
		if (p)++; (p) == (pe) {
			goto _test_eof96
		}
	st_case_96:
		switch data[(p)] {
		case 32:
			goto tr77
		case 99:
			goto st97
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr77
		}
		goto st2
	st97:
		if (p)++; (p) == (pe) {
			goto _test_eof97
		}
	st_case_97:
		if data[(p)] == 104 {
			goto st69
		}
		goto st2
	tr9:
//line parser.rl:22

		tok = p

		goto st98
	tr141:
//line parser.rl:97

		event.SetSequence(data[tok:p])

//line parser.rl:22

		tok = p

		goto st98
	st98:
		if (p)++; (p) == (pe) {
			goto _test_eof98
		}
	st_case_98:
//line parser.go:2188
		if data[(p)] == 111 {
			goto st99
		}
		goto st2
	st99:
		if (p)++; (p) == (pe) {
			goto _test_eof99
		}
	st_case_99:
		if data[(p)] == 118 {
			goto st76
		}
		goto st2
	tr10:
//line parser.rl:22

		tok = p

		goto st100
	tr142:
//line parser.rl:97

		event.SetSequence(data[tok:p])

//line parser.rl:22

		tok = p

		goto st100
	st100:
		if (p)++; (p) == (pe) {
			goto _test_eof100
		}
	st_case_100:
//line parser.go:2223
		if data[(p)] == 99 {
			goto st101
		}
		goto st2
	st101:
		if (p)++; (p) == (pe) {
			goto _test_eof101
		}
	st_case_101:
		if data[(p)] == 116 {
			goto st102
		}
		goto st2
	st102:
		if (p)++; (p) == (pe) {
			goto _test_eof102
		}
	st_case_102:
		switch data[(p)] {
		case 32:
			goto tr77
		case 111:
			goto st78
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr77
		}
		goto st2
	tr11:
//line parser.rl:22

		tok = p

		goto st103
	tr143:
//line parser.rl:97

		event.SetSequence(data[tok:p])

//line parser.rl:22

		tok = p

		goto st103
	st103:
		if (p)++; (p) == (pe) {
			goto _test_eof103
		}
	st_case_103:
//line parser.go:2273
		if data[(p)] == 101 {
			goto st104
		}
		goto st2
	st104:
		if (p)++; (p) == (pe) {
			goto _test_eof104
		}
	st_case_104:
		if data[(p)] == 112 {
			goto st105
		}
		goto st2
	st105:
		if (p)++; (p) == (pe) {
			goto _test_eof105
		}
	st_case_105:
		switch data[(p)] {
		case 32:
			goto tr77
		case 116:
			goto st106
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr77
		}
		goto st2
	st106:
		if (p)++; (p) == (pe) {
			goto _test_eof106
		}
	st_case_106:
		if data[(p)] == 101 {
			goto st77
		}
		goto st2
	tr2:
//line parser.rl:22

		tok = p

		goto st107
	st107:
		if (p)++; (p) == (pe) {
			goto _test_eof107
		}
	st_case_107:
//line parser.go:2322
		if data[(p)] == 58 {
			goto st112
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st108
		}
		goto st2
	st108:
		if (p)++; (p) == (pe) {
			goto _test_eof108
		}
	st_case_108:
		if data[(p)] == 58 {
			goto st112
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st109
		}
		goto st2
	st109:
		if (p)++; (p) == (pe) {
			goto _test_eof109
		}
	st_case_109:
		if data[(p)] == 58 {
			goto st112
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st110
		}
		goto st2
	st110:
		if (p)++; (p) == (pe) {
			goto _test_eof110
		}
	st_case_110:
		switch data[(p)] {
		case 45:
			goto tr18
		case 58:
			goto st112
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st111
		}
		goto st2
	st111:
		if (p)++; (p) == (pe) {
			goto _test_eof111
		}
	st_case_111:
		if data[(p)] == 58 {
			goto st112
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st111
		}
		goto st2
	st112:
		if (p)++; (p) == (pe) {
			goto _test_eof112
		}
	st_case_112:
		if data[(p)] == 32 {
			goto tr132
		}
		if 9 <= data[(p)] && data[(p)] <= 13 {
			goto tr132
		}
		goto st2
	tr132:
//line parser.rl:22

		tok = p

		goto st113
	st113:
		if (p)++; (p) == (pe) {
			goto _test_eof113
		}
	st_case_113:
//line parser.go:2404
		switch data[(p)] {
		case 32:
			goto tr134
		case 42:
			goto tr134
		case 46:
			goto tr134
		case 65:
			goto tr136
		case 68:
			goto tr137
		case 70:
			goto tr138
		case 74:
			goto tr139
		case 77:
			goto tr140
		case 78:
			goto tr141
		case 79:
			goto tr142
		case 83:
			goto tr143
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto tr135
		}
		goto tr133
	tr3:
//line parser.rl:22

		tok = p

		goto st114
	st114:
		if (p)++; (p) == (pe) {
			goto _test_eof114
		}
	st_case_114:
//line parser.go:2444
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto tr144
		}
		goto st2
	tr144:
//line parser.rl:22

		tok = p

		goto st115
	st115:
		if (p)++; (p) == (pe) {
			goto _test_eof115
		}
	st_case_115:
//line parser.go:2460
		if data[(p)] == 62 {
			goto tr146
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st116
		}
		goto st2
	st116:
		if (p)++; (p) == (pe) {
			goto _test_eof116
		}
	st_case_116:
		if data[(p)] == 62 {
			goto tr146
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st117
		}
		goto st2
	st117:
		if (p)++; (p) == (pe) {
			goto _test_eof117
		}
	st_case_117:
		if data[(p)] == 62 {
			goto tr146
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st118
		}
		goto st2
	st118:
		if (p)++; (p) == (pe) {
			goto _test_eof118
		}
	st_case_118:
		if data[(p)] == 62 {
			goto tr146
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto st119
		}
		goto st2
	st119:
		if (p)++; (p) == (pe) {
			goto _test_eof119
		}
	st_case_119:
		if data[(p)] == 62 {
			goto tr146
		}
		goto st2
	tr146:
//line parser.rl:26

		event.SetPriority(data[tok:p])

		goto st120
	st120:
		if (p)++; (p) == (pe) {
			goto _test_eof120
		}
	st_case_120:
//line parser.go:2524
		switch data[(p)] {
		case 32:
			goto tr1
		case 42:
			goto tr1
		case 46:
			goto tr1
		case 65:
			goto tr4
		case 68:
			goto tr5
		case 70:
			goto tr6
		case 74:
			goto tr7
		case 77:
			goto tr8
		case 78:
			goto tr9
		case 79:
			goto tr10
		case 83:
			goto tr11
		}
		if 48 <= data[(p)] && data[(p)] <= 57 {
			goto tr2
		}
		goto tr0
	st1:
		if (p)++; (p) == (pe) {
			goto _test_eof1
		}
	st_case_1:
		goto tr12
	tr12:
//line parser.rl:22

		tok = p

		goto st121
	st121:
		if (p)++; (p) == (pe) {
			goto _test_eof121
		}
	st_case_121:
//line parser.go:2570
		goto st121
	st_out:
	_test_eof2:
		cs = 2
		goto _test_eof
	_test_eof3:
		cs = 3
		goto _test_eof
	_test_eof4:
		cs = 4
		goto _test_eof
	_test_eof5:
		cs = 5
		goto _test_eof
	_test_eof6:
		cs = 6
		goto _test_eof
	_test_eof7:
		cs = 7
		goto _test_eof
	_test_eof8:
		cs = 8
		goto _test_eof
	_test_eof9:
		cs = 9
		goto _test_eof
	_test_eof10:
		cs = 10
		goto _test_eof
	_test_eof11:
		cs = 11
		goto _test_eof
	_test_eof12:
		cs = 12
		goto _test_eof
	_test_eof13:
		cs = 13
		goto _test_eof
	_test_eof14:
		cs = 14
		goto _test_eof
	_test_eof15:
		cs = 15
		goto _test_eof
	_test_eof16:
		cs = 16
		goto _test_eof
	_test_eof17:
		cs = 17
		goto _test_eof
	_test_eof18:
		cs = 18
		goto _test_eof
	_test_eof19:
		cs = 19
		goto _test_eof
	_test_eof20:
		cs = 20
		goto _test_eof
	_test_eof21:
		cs = 21
		goto _test_eof
	_test_eof22:
		cs = 22
		goto _test_eof
	_test_eof23:
		cs = 23
		goto _test_eof
	_test_eof24:
		cs = 24
		goto _test_eof
	_test_eof25:
		cs = 25
		goto _test_eof
	_test_eof26:
		cs = 26
		goto _test_eof
	_test_eof27:
		cs = 27
		goto _test_eof
	_test_eof28:
		cs = 28
		goto _test_eof
	_test_eof29:
		cs = 29
		goto _test_eof
	_test_eof30:
		cs = 30
		goto _test_eof
	_test_eof31:
		cs = 31
		goto _test_eof
	_test_eof32:
		cs = 32
		goto _test_eof
	_test_eof33:
		cs = 33
		goto _test_eof
	_test_eof34:
		cs = 34
		goto _test_eof
	_test_eof35:
		cs = 35
		goto _test_eof
	_test_eof36:
		cs = 36
		goto _test_eof
	_test_eof37:
		cs = 37
		goto _test_eof
	_test_eof38:
		cs = 38
		goto _test_eof
	_test_eof39:
		cs = 39
		goto _test_eof
	_test_eof40:
		cs = 40
		goto _test_eof
	_test_eof41:
		cs = 41
		goto _test_eof
	_test_eof42:
		cs = 42
		goto _test_eof
	_test_eof43:
		cs = 43
		goto _test_eof
	_test_eof44:
		cs = 44
		goto _test_eof
	_test_eof45:
		cs = 45
		goto _test_eof
	_test_eof46:
		cs = 46
		goto _test_eof
	_test_eof47:
		cs = 47
		goto _test_eof
	_test_eof48:
		cs = 48
		goto _test_eof
	_test_eof49:
		cs = 49
		goto _test_eof
	_test_eof50:
		cs = 50
		goto _test_eof
	_test_eof51:
		cs = 51
		goto _test_eof
	_test_eof52:
		cs = 52
		goto _test_eof
	_test_eof53:
		cs = 53
		goto _test_eof
	_test_eof54:
		cs = 54
		goto _test_eof
	_test_eof55:
		cs = 55
		goto _test_eof
	_test_eof56:
		cs = 56
		goto _test_eof
	_test_eof57:
		cs = 57
		goto _test_eof
	_test_eof58:
		cs = 58
		goto _test_eof
	_test_eof59:
		cs = 59
		goto _test_eof
	_test_eof60:
		cs = 60
		goto _test_eof
	_test_eof61:
		cs = 61
		goto _test_eof
	_test_eof62:
		cs = 62
		goto _test_eof
	_test_eof63:
		cs = 63
		goto _test_eof
	_test_eof64:
		cs = 64
		goto _test_eof
	_test_eof65:
		cs = 65
		goto _test_eof
	_test_eof66:
		cs = 66
		goto _test_eof
	_test_eof67:
		cs = 67
		goto _test_eof
	_test_eof68:
		cs = 68
		goto _test_eof
	_test_eof69:
		cs = 69
		goto _test_eof
	_test_eof70:
		cs = 70
		goto _test_eof
	_test_eof71:
		cs = 71
		goto _test_eof
	_test_eof72:
		cs = 72
		goto _test_eof
	_test_eof73:
		cs = 73
		goto _test_eof
	_test_eof74:
		cs = 74
		goto _test_eof
	_test_eof75:
		cs = 75
		goto _test_eof
	_test_eof76:
		cs = 76
		goto _test_eof
	_test_eof77:
		cs = 77
		goto _test_eof
	_test_eof78:
		cs = 78
		goto _test_eof
	_test_eof79:
		cs = 79
		goto _test_eof
	_test_eof80:
		cs = 80
		goto _test_eof
	_test_eof81:
		cs = 81
		goto _test_eof
	_test_eof82:
		cs = 82
		goto _test_eof
	_test_eof83:
		cs = 83
		goto _test_eof
	_test_eof84:
		cs = 84
		goto _test_eof
	_test_eof85:
		cs = 85
		goto _test_eof
	_test_eof86:
		cs = 86
		goto _test_eof
	_test_eof87:
		cs = 87
		goto _test_eof
	_test_eof88:
		cs = 88
		goto _test_eof
	_test_eof89:
		cs = 89
		goto _test_eof
	_test_eof90:
		cs = 90
		goto _test_eof
	_test_eof91:
		cs = 91
		goto _test_eof
	_test_eof92:
		cs = 92
		goto _test_eof
	_test_eof93:
		cs = 93
		goto _test_eof
	_test_eof94:
		cs = 94
		goto _test_eof
	_test_eof95:
		cs = 95
		goto _test_eof
	_test_eof96:
		cs = 96
		goto _test_eof
	_test_eof97:
		cs = 97
		goto _test_eof
	_test_eof98:
		cs = 98
		goto _test_eof
	_test_eof99:
		cs = 99
		goto _test_eof
	_test_eof100:
		cs = 100
		goto _test_eof
	_test_eof101:
		cs = 101
		goto _test_eof
	_test_eof102:
		cs = 102
		goto _test_eof
	_test_eof103:
		cs = 103
		goto _test_eof
	_test_eof104:
		cs = 104
		goto _test_eof
	_test_eof105:
		cs = 105
		goto _test_eof
	_test_eof106:
		cs = 106
		goto _test_eof
	_test_eof107:
		cs = 107
		goto _test_eof
	_test_eof108:
		cs = 108
		goto _test_eof
	_test_eof109:
		cs = 109
		goto _test_eof
	_test_eof110:
		cs = 110
		goto _test_eof
	_test_eof111:
		cs = 111
		goto _test_eof
	_test_eof112:
		cs = 112
		goto _test_eof
	_test_eof113:
		cs = 113
		goto _test_eof
	_test_eof114:
		cs = 114
		goto _test_eof
	_test_eof115:
		cs = 115
		goto _test_eof
	_test_eof116:
		cs = 116
		goto _test_eof
	_test_eof117:
		cs = 117
		goto _test_eof
	_test_eof118:
		cs = 118
		goto _test_eof
	_test_eof119:
		cs = 119
		goto _test_eof
	_test_eof120:
		cs = 120
		goto _test_eof
	_test_eof1:
		cs = 1
		goto _test_eof
	_test_eof121:
		cs = 121
		goto _test_eof

	_test_eof:
		{
		}
		if (p) == eof {
			switch cs {
			case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121:
//line parser.rl:30

				event.SetMessage(data[tok:p])

//line parser.go:2703
			}
		}

	}

//line parser.rl:105

}
