// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package keyspacesiface provides an interface to enable mocking the Amazon Keyspaces service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package keyspacesiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/keyspaces"
)

// KeyspacesAPI provides an interface to enable mocking the
// keyspaces.Keyspaces service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Keyspaces.
//    func myFunc(svc keyspacesiface.KeyspacesAPI) bool {
//        // Make svc.CreateKeyspace request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := keyspaces.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockKeyspacesClient struct {
//        keyspacesiface.KeyspacesAPI
//    }
//    func (m *mockKeyspacesClient) CreateKeyspace(input *keyspaces.CreateKeyspaceInput) (*keyspaces.CreateKeyspaceOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockKeyspacesClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type KeyspacesAPI interface {
	CreateKeyspace(*keyspaces.CreateKeyspaceInput) (*keyspaces.CreateKeyspaceOutput, error)
	CreateKeyspaceWithContext(aws.Context, *keyspaces.CreateKeyspaceInput, ...request.Option) (*keyspaces.CreateKeyspaceOutput, error)
	CreateKeyspaceRequest(*keyspaces.CreateKeyspaceInput) (*request.Request, *keyspaces.CreateKeyspaceOutput)

	CreateTable(*keyspaces.CreateTableInput) (*keyspaces.CreateTableOutput, error)
	CreateTableWithContext(aws.Context, *keyspaces.CreateTableInput, ...request.Option) (*keyspaces.CreateTableOutput, error)
	CreateTableRequest(*keyspaces.CreateTableInput) (*request.Request, *keyspaces.CreateTableOutput)

	DeleteKeyspace(*keyspaces.DeleteKeyspaceInput) (*keyspaces.DeleteKeyspaceOutput, error)
	DeleteKeyspaceWithContext(aws.Context, *keyspaces.DeleteKeyspaceInput, ...request.Option) (*keyspaces.DeleteKeyspaceOutput, error)
	DeleteKeyspaceRequest(*keyspaces.DeleteKeyspaceInput) (*request.Request, *keyspaces.DeleteKeyspaceOutput)

	DeleteTable(*keyspaces.DeleteTableInput) (*keyspaces.DeleteTableOutput, error)
	DeleteTableWithContext(aws.Context, *keyspaces.DeleteTableInput, ...request.Option) (*keyspaces.DeleteTableOutput, error)
	DeleteTableRequest(*keyspaces.DeleteTableInput) (*request.Request, *keyspaces.DeleteTableOutput)

	GetKeyspace(*keyspaces.GetKeyspaceInput) (*keyspaces.GetKeyspaceOutput, error)
	GetKeyspaceWithContext(aws.Context, *keyspaces.GetKeyspaceInput, ...request.Option) (*keyspaces.GetKeyspaceOutput, error)
	GetKeyspaceRequest(*keyspaces.GetKeyspaceInput) (*request.Request, *keyspaces.GetKeyspaceOutput)

	GetTable(*keyspaces.GetTableInput) (*keyspaces.GetTableOutput, error)
	GetTableWithContext(aws.Context, *keyspaces.GetTableInput, ...request.Option) (*keyspaces.GetTableOutput, error)
	GetTableRequest(*keyspaces.GetTableInput) (*request.Request, *keyspaces.GetTableOutput)

	ListKeyspaces(*keyspaces.ListKeyspacesInput) (*keyspaces.ListKeyspacesOutput, error)
	ListKeyspacesWithContext(aws.Context, *keyspaces.ListKeyspacesInput, ...request.Option) (*keyspaces.ListKeyspacesOutput, error)
	ListKeyspacesRequest(*keyspaces.ListKeyspacesInput) (*request.Request, *keyspaces.ListKeyspacesOutput)

	ListKeyspacesPages(*keyspaces.ListKeyspacesInput, func(*keyspaces.ListKeyspacesOutput, bool) bool) error
	ListKeyspacesPagesWithContext(aws.Context, *keyspaces.ListKeyspacesInput, func(*keyspaces.ListKeyspacesOutput, bool) bool, ...request.Option) error

	ListTables(*keyspaces.ListTablesInput) (*keyspaces.ListTablesOutput, error)
	ListTablesWithContext(aws.Context, *keyspaces.ListTablesInput, ...request.Option) (*keyspaces.ListTablesOutput, error)
	ListTablesRequest(*keyspaces.ListTablesInput) (*request.Request, *keyspaces.ListTablesOutput)

	ListTablesPages(*keyspaces.ListTablesInput, func(*keyspaces.ListTablesOutput, bool) bool) error
	ListTablesPagesWithContext(aws.Context, *keyspaces.ListTablesInput, func(*keyspaces.ListTablesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*keyspaces.ListTagsForResourceInput) (*keyspaces.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *keyspaces.ListTagsForResourceInput, ...request.Option) (*keyspaces.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*keyspaces.ListTagsForResourceInput) (*request.Request, *keyspaces.ListTagsForResourceOutput)

	ListTagsForResourcePages(*keyspaces.ListTagsForResourceInput, func(*keyspaces.ListTagsForResourceOutput, bool) bool) error
	ListTagsForResourcePagesWithContext(aws.Context, *keyspaces.ListTagsForResourceInput, func(*keyspaces.ListTagsForResourceOutput, bool) bool, ...request.Option) error

	RestoreTable(*keyspaces.RestoreTableInput) (*keyspaces.RestoreTableOutput, error)
	RestoreTableWithContext(aws.Context, *keyspaces.RestoreTableInput, ...request.Option) (*keyspaces.RestoreTableOutput, error)
	RestoreTableRequest(*keyspaces.RestoreTableInput) (*request.Request, *keyspaces.RestoreTableOutput)

	TagResource(*keyspaces.TagResourceInput) (*keyspaces.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *keyspaces.TagResourceInput, ...request.Option) (*keyspaces.TagResourceOutput, error)
	TagResourceRequest(*keyspaces.TagResourceInput) (*request.Request, *keyspaces.TagResourceOutput)

	UntagResource(*keyspaces.UntagResourceInput) (*keyspaces.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *keyspaces.UntagResourceInput, ...request.Option) (*keyspaces.UntagResourceOutput, error)
	UntagResourceRequest(*keyspaces.UntagResourceInput) (*request.Request, *keyspaces.UntagResourceOutput)

	UpdateTable(*keyspaces.UpdateTableInput) (*keyspaces.UpdateTableOutput, error)
	UpdateTableWithContext(aws.Context, *keyspaces.UpdateTableInput, ...request.Option) (*keyspaces.UpdateTableOutput, error)
	UpdateTableRequest(*keyspaces.UpdateTableInput) (*request.Request, *keyspaces.UpdateTableOutput)
}

var _ KeyspacesAPI = (*keyspaces.Keyspaces)(nil)
