// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribeservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateCallAnalyticsCategory = "CreateCallAnalyticsCategory"

// CreateCallAnalyticsCategoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateCallAnalyticsCategory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCallAnalyticsCategory for more information on using the CreateCallAnalyticsCategory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCallAnalyticsCategoryRequest method.
//    req, resp := client.CreateCallAnalyticsCategoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateCallAnalyticsCategory
func (c *TranscribeService) CreateCallAnalyticsCategoryRequest(input *CreateCallAnalyticsCategoryInput) (req *request.Request, output *CreateCallAnalyticsCategoryOutput) {
	op := &request.Operation{
		Name:       opCreateCallAnalyticsCategory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCallAnalyticsCategoryInput{}
	}

	output = &CreateCallAnalyticsCategoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCallAnalyticsCategory API operation for Amazon Transcribe Service.
//
// Creates a call analytics category. Amazon Transcribe applies the conditions
// specified by your call analytics categories to your call analytics jobs.
// For each analytics category, you must create between 1 and 20 rules. For
// example, you can create a 'greeting' category with a rule that flags calls
// in which your agent does not use a specified phrase (for example: "Please
// note this call may be recorded.") in the first 15 seconds of the call. When
// you start a call analytics job, Amazon Transcribe applies all your existing
// call analytics categories to that job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateCallAnalyticsCategory for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateCallAnalyticsCategory
func (c *TranscribeService) CreateCallAnalyticsCategory(input *CreateCallAnalyticsCategoryInput) (*CreateCallAnalyticsCategoryOutput, error) {
	req, out := c.CreateCallAnalyticsCategoryRequest(input)
	return out, req.Send()
}

// CreateCallAnalyticsCategoryWithContext is the same as CreateCallAnalyticsCategory with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCallAnalyticsCategory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateCallAnalyticsCategoryWithContext(ctx aws.Context, input *CreateCallAnalyticsCategoryInput, opts ...request.Option) (*CreateCallAnalyticsCategoryOutput, error) {
	req, out := c.CreateCallAnalyticsCategoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLanguageModel = "CreateLanguageModel"

// CreateLanguageModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateLanguageModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLanguageModel for more information on using the CreateLanguageModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLanguageModelRequest method.
//    req, resp := client.CreateLanguageModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateLanguageModel
func (c *TranscribeService) CreateLanguageModelRequest(input *CreateLanguageModelInput) (req *request.Request, output *CreateLanguageModelOutput) {
	op := &request.Operation{
		Name:       opCreateLanguageModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLanguageModelInput{}
	}

	output = &CreateLanguageModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLanguageModel API operation for Amazon Transcribe Service.
//
// Creates a new custom language model. When creating a new language model,
// you must specify if you want a Wideband (audio sample rates over 16,000 Hz)
// or Narrowband (audio sample rates under 16,000 Hz) base model. You then include
// the S3 URI location of your training and tuning files, the language for the
// model, a unique name, and any tags you want associated with your model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateLanguageModel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateLanguageModel
func (c *TranscribeService) CreateLanguageModel(input *CreateLanguageModelInput) (*CreateLanguageModelOutput, error) {
	req, out := c.CreateLanguageModelRequest(input)
	return out, req.Send()
}

// CreateLanguageModelWithContext is the same as CreateLanguageModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLanguageModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateLanguageModelWithContext(ctx aws.Context, input *CreateLanguageModelInput, opts ...request.Option) (*CreateLanguageModelOutput, error) {
	req, out := c.CreateLanguageModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMedicalVocabulary = "CreateMedicalVocabulary"

// CreateMedicalVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the CreateMedicalVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMedicalVocabulary for more information on using the CreateMedicalVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMedicalVocabularyRequest method.
//    req, resp := client.CreateMedicalVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary
func (c *TranscribeService) CreateMedicalVocabularyRequest(input *CreateMedicalVocabularyInput) (req *request.Request, output *CreateMedicalVocabularyOutput) {
	op := &request.Operation{
		Name:       opCreateMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMedicalVocabularyInput{}
	}

	output = &CreateMedicalVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMedicalVocabulary API operation for Amazon Transcribe Service.
//
// Creates a new custom medical vocabulary.
//
// When creating a new medical vocabulary, you must upload a text file that
// contains your new entries, phrases, and terms into an S3 bucket. Note that
// this differs from , where you can include a list of terms within your request
// using the Phrases flag, as CreateMedicalVocabulary does not support the Phrases
// flag.
//
// For more information on creating a custom vocabulary text file, see Creating
// a custom vocabulary (https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary-create.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateMedicalVocabulary for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary
func (c *TranscribeService) CreateMedicalVocabulary(input *CreateMedicalVocabularyInput) (*CreateMedicalVocabularyOutput, error) {
	req, out := c.CreateMedicalVocabularyRequest(input)
	return out, req.Send()
}

// CreateMedicalVocabularyWithContext is the same as CreateMedicalVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMedicalVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateMedicalVocabularyWithContext(ctx aws.Context, input *CreateMedicalVocabularyInput, opts ...request.Option) (*CreateMedicalVocabularyOutput, error) {
	req, out := c.CreateMedicalVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVocabulary = "CreateVocabulary"

// CreateVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the CreateVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVocabulary for more information on using the CreateVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVocabularyRequest method.
//    req, resp := client.CreateVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary
func (c *TranscribeService) CreateVocabularyRequest(input *CreateVocabularyInput) (req *request.Request, output *CreateVocabularyOutput) {
	op := &request.Operation{
		Name:       opCreateVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVocabularyInput{}
	}

	output = &CreateVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVocabulary API operation for Amazon Transcribe Service.
//
// Creates a new custom vocabulary.
//
// When creating a new medical vocabulary, you can either upload a text file
// that contains your new entries, phrases, and terms into an S3 bucket or include
// a list of terms directly in your request using the Phrases flag.
//
// For more information on creating a custom vocabulary, see Creating a custom
// vocabulary (https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary-create.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateVocabulary for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary
func (c *TranscribeService) CreateVocabulary(input *CreateVocabularyInput) (*CreateVocabularyOutput, error) {
	req, out := c.CreateVocabularyRequest(input)
	return out, req.Send()
}

// CreateVocabularyWithContext is the same as CreateVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateVocabularyWithContext(ctx aws.Context, input *CreateVocabularyInput, opts ...request.Option) (*CreateVocabularyOutput, error) {
	req, out := c.CreateVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVocabularyFilter = "CreateVocabularyFilter"

// CreateVocabularyFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateVocabularyFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVocabularyFilter for more information on using the CreateVocabularyFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVocabularyFilterRequest method.
//    req, resp := client.CreateVocabularyFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabularyFilter
func (c *TranscribeService) CreateVocabularyFilterRequest(input *CreateVocabularyFilterInput) (req *request.Request, output *CreateVocabularyFilterOutput) {
	op := &request.Operation{
		Name:       opCreateVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVocabularyFilterInput{}
	}

	output = &CreateVocabularyFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVocabularyFilter API operation for Amazon Transcribe Service.
//
// Creates a new vocabulary filter that you can use to filter words from your
// transcription output. For example, you can use this operation to remove profanity
// from your transcript.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateVocabularyFilter for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabularyFilter
func (c *TranscribeService) CreateVocabularyFilter(input *CreateVocabularyFilterInput) (*CreateVocabularyFilterOutput, error) {
	req, out := c.CreateVocabularyFilterRequest(input)
	return out, req.Send()
}

// CreateVocabularyFilterWithContext is the same as CreateVocabularyFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVocabularyFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateVocabularyFilterWithContext(ctx aws.Context, input *CreateVocabularyFilterInput, opts ...request.Option) (*CreateVocabularyFilterOutput, error) {
	req, out := c.CreateVocabularyFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCallAnalyticsCategory = "DeleteCallAnalyticsCategory"

// DeleteCallAnalyticsCategoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCallAnalyticsCategory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCallAnalyticsCategory for more information on using the DeleteCallAnalyticsCategory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCallAnalyticsCategoryRequest method.
//    req, resp := client.DeleteCallAnalyticsCategoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsCategory
func (c *TranscribeService) DeleteCallAnalyticsCategoryRequest(input *DeleteCallAnalyticsCategoryInput) (req *request.Request, output *DeleteCallAnalyticsCategoryOutput) {
	op := &request.Operation{
		Name:       opDeleteCallAnalyticsCategory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCallAnalyticsCategoryInput{}
	}

	output = &DeleteCallAnalyticsCategoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCallAnalyticsCategory API operation for Amazon Transcribe Service.
//
// Deletes a call analytics category. To use this operation, specify the name
// of the category you want to delete using CategoryName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteCallAnalyticsCategory for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsCategory
func (c *TranscribeService) DeleteCallAnalyticsCategory(input *DeleteCallAnalyticsCategoryInput) (*DeleteCallAnalyticsCategoryOutput, error) {
	req, out := c.DeleteCallAnalyticsCategoryRequest(input)
	return out, req.Send()
}

// DeleteCallAnalyticsCategoryWithContext is the same as DeleteCallAnalyticsCategory with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCallAnalyticsCategory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteCallAnalyticsCategoryWithContext(ctx aws.Context, input *DeleteCallAnalyticsCategoryInput, opts ...request.Option) (*DeleteCallAnalyticsCategoryOutput, error) {
	req, out := c.DeleteCallAnalyticsCategoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCallAnalyticsJob = "DeleteCallAnalyticsJob"

// DeleteCallAnalyticsJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCallAnalyticsJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCallAnalyticsJob for more information on using the DeleteCallAnalyticsJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCallAnalyticsJobRequest method.
//    req, resp := client.DeleteCallAnalyticsJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsJob
func (c *TranscribeService) DeleteCallAnalyticsJobRequest(input *DeleteCallAnalyticsJobInput) (req *request.Request, output *DeleteCallAnalyticsJobOutput) {
	op := &request.Operation{
		Name:       opDeleteCallAnalyticsJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCallAnalyticsJobInput{}
	}

	output = &DeleteCallAnalyticsJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCallAnalyticsJob API operation for Amazon Transcribe Service.
//
// Deletes a call analytics job. To use this operation, specify the name of
// the job you want to delete using CallAnalyticsJobName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteCallAnalyticsJob for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsJob
func (c *TranscribeService) DeleteCallAnalyticsJob(input *DeleteCallAnalyticsJobInput) (*DeleteCallAnalyticsJobOutput, error) {
	req, out := c.DeleteCallAnalyticsJobRequest(input)
	return out, req.Send()
}

// DeleteCallAnalyticsJobWithContext is the same as DeleteCallAnalyticsJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCallAnalyticsJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteCallAnalyticsJobWithContext(ctx aws.Context, input *DeleteCallAnalyticsJobInput, opts ...request.Option) (*DeleteCallAnalyticsJobOutput, error) {
	req, out := c.DeleteCallAnalyticsJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLanguageModel = "DeleteLanguageModel"

// DeleteLanguageModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLanguageModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLanguageModel for more information on using the DeleteLanguageModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLanguageModelRequest method.
//    req, resp := client.DeleteLanguageModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteLanguageModel
func (c *TranscribeService) DeleteLanguageModelRequest(input *DeleteLanguageModelInput) (req *request.Request, output *DeleteLanguageModelOutput) {
	op := &request.Operation{
		Name:       opDeleteLanguageModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLanguageModelInput{}
	}

	output = &DeleteLanguageModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLanguageModel API operation for Amazon Transcribe Service.
//
// Deletes a custom language model. To use this operation, specify the name
// of the language model you want to delete using ModelName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteLanguageModel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteLanguageModel
func (c *TranscribeService) DeleteLanguageModel(input *DeleteLanguageModelInput) (*DeleteLanguageModelOutput, error) {
	req, out := c.DeleteLanguageModelRequest(input)
	return out, req.Send()
}

// DeleteLanguageModelWithContext is the same as DeleteLanguageModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLanguageModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteLanguageModelWithContext(ctx aws.Context, input *DeleteLanguageModelInput, opts ...request.Option) (*DeleteLanguageModelOutput, error) {
	req, out := c.DeleteLanguageModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMedicalTranscriptionJob = "DeleteMedicalTranscriptionJob"

// DeleteMedicalTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMedicalTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMedicalTranscriptionJob for more information on using the DeleteMedicalTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMedicalTranscriptionJobRequest method.
//    req, resp := client.DeleteMedicalTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob
func (c *TranscribeService) DeleteMedicalTranscriptionJobRequest(input *DeleteMedicalTranscriptionJobInput) (req *request.Request, output *DeleteMedicalTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opDeleteMedicalTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMedicalTranscriptionJobInput{}
	}

	output = &DeleteMedicalTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMedicalTranscriptionJob API operation for Amazon Transcribe Service.
//
// Deletes a medical transcription job, along with any related information.
// To use this operation, specify the name of the job you want to delete using
// MedicalTranscriptionJobName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteMedicalTranscriptionJob for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob
func (c *TranscribeService) DeleteMedicalTranscriptionJob(input *DeleteMedicalTranscriptionJobInput) (*DeleteMedicalTranscriptionJobOutput, error) {
	req, out := c.DeleteMedicalTranscriptionJobRequest(input)
	return out, req.Send()
}

// DeleteMedicalTranscriptionJobWithContext is the same as DeleteMedicalTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMedicalTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteMedicalTranscriptionJobWithContext(ctx aws.Context, input *DeleteMedicalTranscriptionJobInput, opts ...request.Option) (*DeleteMedicalTranscriptionJobOutput, error) {
	req, out := c.DeleteMedicalTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMedicalVocabulary = "DeleteMedicalVocabulary"

// DeleteMedicalVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMedicalVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMedicalVocabulary for more information on using the DeleteMedicalVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMedicalVocabularyRequest method.
//    req, resp := client.DeleteMedicalVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalVocabulary
func (c *TranscribeService) DeleteMedicalVocabularyRequest(input *DeleteMedicalVocabularyInput) (req *request.Request, output *DeleteMedicalVocabularyOutput) {
	op := &request.Operation{
		Name:       opDeleteMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMedicalVocabularyInput{}
	}

	output = &DeleteMedicalVocabularyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMedicalVocabulary API operation for Amazon Transcribe Service.
//
// Deletes a custom medical vocabulary. To use this operation, specify the name
// of the vocabulary you want to delete using VocabularyName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteMedicalVocabulary for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalVocabulary
func (c *TranscribeService) DeleteMedicalVocabulary(input *DeleteMedicalVocabularyInput) (*DeleteMedicalVocabularyOutput, error) {
	req, out := c.DeleteMedicalVocabularyRequest(input)
	return out, req.Send()
}

// DeleteMedicalVocabularyWithContext is the same as DeleteMedicalVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMedicalVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteMedicalVocabularyWithContext(ctx aws.Context, input *DeleteMedicalVocabularyInput, opts ...request.Option) (*DeleteMedicalVocabularyOutput, error) {
	req, out := c.DeleteMedicalVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTranscriptionJob = "DeleteTranscriptionJob"

// DeleteTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTranscriptionJob for more information on using the DeleteTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTranscriptionJobRequest method.
//    req, resp := client.DeleteTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob
func (c *TranscribeService) DeleteTranscriptionJobRequest(input *DeleteTranscriptionJobInput) (req *request.Request, output *DeleteTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opDeleteTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTranscriptionJobInput{}
	}

	output = &DeleteTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTranscriptionJob API operation for Amazon Transcribe Service.
//
// Deletes a transcription job, along with any related information. To use this
// operation, specify the name of the job you want to delete using TranscriptionJobName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteTranscriptionJob for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob
func (c *TranscribeService) DeleteTranscriptionJob(input *DeleteTranscriptionJobInput) (*DeleteTranscriptionJobOutput, error) {
	req, out := c.DeleteTranscriptionJobRequest(input)
	return out, req.Send()
}

// DeleteTranscriptionJobWithContext is the same as DeleteTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteTranscriptionJobWithContext(ctx aws.Context, input *DeleteTranscriptionJobInput, opts ...request.Option) (*DeleteTranscriptionJobOutput, error) {
	req, out := c.DeleteTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVocabulary = "DeleteVocabulary"

// DeleteVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVocabulary for more information on using the DeleteVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVocabularyRequest method.
//    req, resp := client.DeleteVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary
func (c *TranscribeService) DeleteVocabularyRequest(input *DeleteVocabularyInput) (req *request.Request, output *DeleteVocabularyOutput) {
	op := &request.Operation{
		Name:       opDeleteVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVocabularyInput{}
	}

	output = &DeleteVocabularyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVocabulary API operation for Amazon Transcribe Service.
//
// Deletes a custom vocabulary. To use this operation, specify the name of the
// vocabulary you want to delete using VocabularyName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteVocabulary for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary
func (c *TranscribeService) DeleteVocabulary(input *DeleteVocabularyInput) (*DeleteVocabularyOutput, error) {
	req, out := c.DeleteVocabularyRequest(input)
	return out, req.Send()
}

// DeleteVocabularyWithContext is the same as DeleteVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteVocabularyWithContext(ctx aws.Context, input *DeleteVocabularyInput, opts ...request.Option) (*DeleteVocabularyOutput, error) {
	req, out := c.DeleteVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVocabularyFilter = "DeleteVocabularyFilter"

// DeleteVocabularyFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVocabularyFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVocabularyFilter for more information on using the DeleteVocabularyFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVocabularyFilterRequest method.
//    req, resp := client.DeleteVocabularyFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabularyFilter
func (c *TranscribeService) DeleteVocabularyFilterRequest(input *DeleteVocabularyFilterInput) (req *request.Request, output *DeleteVocabularyFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVocabularyFilterInput{}
	}

	output = &DeleteVocabularyFilterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVocabularyFilter API operation for Amazon Transcribe Service.
//
// Deletes a vocabulary filter. To use this operation, specify the name of the
// vocabulary filter you want to delete using VocabularyFilterName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteVocabularyFilter for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabularyFilter
func (c *TranscribeService) DeleteVocabularyFilter(input *DeleteVocabularyFilterInput) (*DeleteVocabularyFilterOutput, error) {
	req, out := c.DeleteVocabularyFilterRequest(input)
	return out, req.Send()
}

// DeleteVocabularyFilterWithContext is the same as DeleteVocabularyFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVocabularyFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteVocabularyFilterWithContext(ctx aws.Context, input *DeleteVocabularyFilterInput, opts ...request.Option) (*DeleteVocabularyFilterOutput, error) {
	req, out := c.DeleteVocabularyFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLanguageModel = "DescribeLanguageModel"

// DescribeLanguageModelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLanguageModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLanguageModel for more information on using the DescribeLanguageModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLanguageModelRequest method.
//    req, resp := client.DescribeLanguageModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DescribeLanguageModel
func (c *TranscribeService) DescribeLanguageModelRequest(input *DescribeLanguageModelInput) (req *request.Request, output *DescribeLanguageModelOutput) {
	op := &request.Operation{
		Name:       opDescribeLanguageModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLanguageModelInput{}
	}

	output = &DescribeLanguageModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLanguageModel API operation for Amazon Transcribe Service.
//
// Provides information about a specific custom language model in your Amazon
// Web Services account.
//
// This operation also shows if the base language model you used to create your
// custom language model has been updated. If Amazon Transcribe has updated
// the base model, you can create a new custom language model using the updated
// base model.
//
// If you tried to create a new custom language model and the request wasn't
// successful, you can use this operation to help identify the reason.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DescribeLanguageModel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DescribeLanguageModel
func (c *TranscribeService) DescribeLanguageModel(input *DescribeLanguageModelInput) (*DescribeLanguageModelOutput, error) {
	req, out := c.DescribeLanguageModelRequest(input)
	return out, req.Send()
}

// DescribeLanguageModelWithContext is the same as DescribeLanguageModel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLanguageModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DescribeLanguageModelWithContext(ctx aws.Context, input *DescribeLanguageModelInput, opts ...request.Option) (*DescribeLanguageModelOutput, error) {
	req, out := c.DescribeLanguageModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCallAnalyticsCategory = "GetCallAnalyticsCategory"

// GetCallAnalyticsCategoryRequest generates a "aws/request.Request" representing the
// client's request for the GetCallAnalyticsCategory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCallAnalyticsCategory for more information on using the GetCallAnalyticsCategory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCallAnalyticsCategoryRequest method.
//    req, resp := client.GetCallAnalyticsCategoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsCategory
func (c *TranscribeService) GetCallAnalyticsCategoryRequest(input *GetCallAnalyticsCategoryInput) (req *request.Request, output *GetCallAnalyticsCategoryOutput) {
	op := &request.Operation{
		Name:       opGetCallAnalyticsCategory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCallAnalyticsCategoryInput{}
	}

	output = &GetCallAnalyticsCategoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCallAnalyticsCategory API operation for Amazon Transcribe Service.
//
// Retrieves information about a call analytics category.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetCallAnalyticsCategory for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsCategory
func (c *TranscribeService) GetCallAnalyticsCategory(input *GetCallAnalyticsCategoryInput) (*GetCallAnalyticsCategoryOutput, error) {
	req, out := c.GetCallAnalyticsCategoryRequest(input)
	return out, req.Send()
}

// GetCallAnalyticsCategoryWithContext is the same as GetCallAnalyticsCategory with the addition of
// the ability to pass a context and additional request options.
//
// See GetCallAnalyticsCategory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetCallAnalyticsCategoryWithContext(ctx aws.Context, input *GetCallAnalyticsCategoryInput, opts ...request.Option) (*GetCallAnalyticsCategoryOutput, error) {
	req, out := c.GetCallAnalyticsCategoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCallAnalyticsJob = "GetCallAnalyticsJob"

// GetCallAnalyticsJobRequest generates a "aws/request.Request" representing the
// client's request for the GetCallAnalyticsJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCallAnalyticsJob for more information on using the GetCallAnalyticsJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCallAnalyticsJobRequest method.
//    req, resp := client.GetCallAnalyticsJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsJob
func (c *TranscribeService) GetCallAnalyticsJobRequest(input *GetCallAnalyticsJobInput) (req *request.Request, output *GetCallAnalyticsJobOutput) {
	op := &request.Operation{
		Name:       opGetCallAnalyticsJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCallAnalyticsJobInput{}
	}

	output = &GetCallAnalyticsJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCallAnalyticsJob API operation for Amazon Transcribe Service.
//
// Retrieves information about a call analytics job.
//
// To view the job's status, refer to the CallAnalyticsJobStatus field. If the
// status is COMPLETED, the job is finished. You can then find your transcript
// at the URI specified in the TranscriptFileUri field. If you enabled personally
// identifiable information (PII) redaction, the redacted transcript appears
// in the RedactedTranscriptFileUri field.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetCallAnalyticsJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsJob
func (c *TranscribeService) GetCallAnalyticsJob(input *GetCallAnalyticsJobInput) (*GetCallAnalyticsJobOutput, error) {
	req, out := c.GetCallAnalyticsJobRequest(input)
	return out, req.Send()
}

// GetCallAnalyticsJobWithContext is the same as GetCallAnalyticsJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetCallAnalyticsJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetCallAnalyticsJobWithContext(ctx aws.Context, input *GetCallAnalyticsJobInput, opts ...request.Option) (*GetCallAnalyticsJobOutput, error) {
	req, out := c.GetCallAnalyticsJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMedicalTranscriptionJob = "GetMedicalTranscriptionJob"

// GetMedicalTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the GetMedicalTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMedicalTranscriptionJob for more information on using the GetMedicalTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMedicalTranscriptionJobRequest method.
//    req, resp := client.GetMedicalTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob
func (c *TranscribeService) GetMedicalTranscriptionJobRequest(input *GetMedicalTranscriptionJobInput) (req *request.Request, output *GetMedicalTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opGetMedicalTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMedicalTranscriptionJobInput{}
	}

	output = &GetMedicalTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMedicalTranscriptionJob API operation for Amazon Transcribe Service.
//
// Retrieves information about a medical transcription job.
//
// To view the job's status, refer to the TranscriptionJobStatus field. If the
// status is COMPLETED, the job is finished. You can then find your transcript
// at the URI specified in the TranscriptFileUri field.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetMedicalTranscriptionJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob
func (c *TranscribeService) GetMedicalTranscriptionJob(input *GetMedicalTranscriptionJobInput) (*GetMedicalTranscriptionJobOutput, error) {
	req, out := c.GetMedicalTranscriptionJobRequest(input)
	return out, req.Send()
}

// GetMedicalTranscriptionJobWithContext is the same as GetMedicalTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetMedicalTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetMedicalTranscriptionJobWithContext(ctx aws.Context, input *GetMedicalTranscriptionJobInput, opts ...request.Option) (*GetMedicalTranscriptionJobOutput, error) {
	req, out := c.GetMedicalTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMedicalVocabulary = "GetMedicalVocabulary"

// GetMedicalVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the GetMedicalVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMedicalVocabulary for more information on using the GetMedicalVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMedicalVocabularyRequest method.
//    req, resp := client.GetMedicalVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary
func (c *TranscribeService) GetMedicalVocabularyRequest(input *GetMedicalVocabularyInput) (req *request.Request, output *GetMedicalVocabularyOutput) {
	op := &request.Operation{
		Name:       opGetMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMedicalVocabularyInput{}
	}

	output = &GetMedicalVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMedicalVocabulary API operation for Amazon Transcribe Service.
//
// Retrieves information about a medical vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetMedicalVocabulary for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary
func (c *TranscribeService) GetMedicalVocabulary(input *GetMedicalVocabularyInput) (*GetMedicalVocabularyOutput, error) {
	req, out := c.GetMedicalVocabularyRequest(input)
	return out, req.Send()
}

// GetMedicalVocabularyWithContext is the same as GetMedicalVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See GetMedicalVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetMedicalVocabularyWithContext(ctx aws.Context, input *GetMedicalVocabularyInput, opts ...request.Option) (*GetMedicalVocabularyOutput, error) {
	req, out := c.GetMedicalVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTranscriptionJob = "GetTranscriptionJob"

// GetTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the GetTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTranscriptionJob for more information on using the GetTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTranscriptionJobRequest method.
//    req, resp := client.GetTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob
func (c *TranscribeService) GetTranscriptionJobRequest(input *GetTranscriptionJobInput) (req *request.Request, output *GetTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opGetTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTranscriptionJobInput{}
	}

	output = &GetTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTranscriptionJob API operation for Amazon Transcribe Service.
//
// Returns information about a transcription job. To see the status of the job,
// check the TranscriptionJobStatus field. If the status is COMPLETED, the job
// is finished and you can find the results at the location specified in the
// TranscriptFileUri field. If you enable content redaction, the redacted transcript
// appears in RedactedTranscriptFileUri.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetTranscriptionJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob
func (c *TranscribeService) GetTranscriptionJob(input *GetTranscriptionJobInput) (*GetTranscriptionJobOutput, error) {
	req, out := c.GetTranscriptionJobRequest(input)
	return out, req.Send()
}

// GetTranscriptionJobWithContext is the same as GetTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetTranscriptionJobWithContext(ctx aws.Context, input *GetTranscriptionJobInput, opts ...request.Option) (*GetTranscriptionJobOutput, error) {
	req, out := c.GetTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVocabulary = "GetVocabulary"

// GetVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the GetVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVocabulary for more information on using the GetVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVocabularyRequest method.
//    req, resp := client.GetVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary
func (c *TranscribeService) GetVocabularyRequest(input *GetVocabularyInput) (req *request.Request, output *GetVocabularyOutput) {
	op := &request.Operation{
		Name:       opGetVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetVocabularyInput{}
	}

	output = &GetVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVocabulary API operation for Amazon Transcribe Service.
//
// Gets information about a vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetVocabulary for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary
func (c *TranscribeService) GetVocabulary(input *GetVocabularyInput) (*GetVocabularyOutput, error) {
	req, out := c.GetVocabularyRequest(input)
	return out, req.Send()
}

// GetVocabularyWithContext is the same as GetVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See GetVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetVocabularyWithContext(ctx aws.Context, input *GetVocabularyInput, opts ...request.Option) (*GetVocabularyOutput, error) {
	req, out := c.GetVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVocabularyFilter = "GetVocabularyFilter"

// GetVocabularyFilterRequest generates a "aws/request.Request" representing the
// client's request for the GetVocabularyFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVocabularyFilter for more information on using the GetVocabularyFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVocabularyFilterRequest method.
//    req, resp := client.GetVocabularyFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter
func (c *TranscribeService) GetVocabularyFilterRequest(input *GetVocabularyFilterInput) (req *request.Request, output *GetVocabularyFilterOutput) {
	op := &request.Operation{
		Name:       opGetVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetVocabularyFilterInput{}
	}

	output = &GetVocabularyFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVocabularyFilter API operation for Amazon Transcribe Service.
//
// Returns information about a vocabulary filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetVocabularyFilter for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter
func (c *TranscribeService) GetVocabularyFilter(input *GetVocabularyFilterInput) (*GetVocabularyFilterOutput, error) {
	req, out := c.GetVocabularyFilterRequest(input)
	return out, req.Send()
}

// GetVocabularyFilterWithContext is the same as GetVocabularyFilter with the addition of
// the ability to pass a context and additional request options.
//
// See GetVocabularyFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetVocabularyFilterWithContext(ctx aws.Context, input *GetVocabularyFilterInput, opts ...request.Option) (*GetVocabularyFilterOutput, error) {
	req, out := c.GetVocabularyFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCallAnalyticsCategories = "ListCallAnalyticsCategories"

// ListCallAnalyticsCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the ListCallAnalyticsCategories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCallAnalyticsCategories for more information on using the ListCallAnalyticsCategories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCallAnalyticsCategoriesRequest method.
//    req, resp := client.ListCallAnalyticsCategoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories
func (c *TranscribeService) ListCallAnalyticsCategoriesRequest(input *ListCallAnalyticsCategoriesInput) (req *request.Request, output *ListCallAnalyticsCategoriesOutput) {
	op := &request.Operation{
		Name:       opListCallAnalyticsCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCallAnalyticsCategoriesInput{}
	}

	output = &ListCallAnalyticsCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCallAnalyticsCategories API operation for Amazon Transcribe Service.
//
// Provides more information about the call analytics categories that you've
// created. You can use the information in this list to find a specific category.
// You can then use the operation to get more information about it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListCallAnalyticsCategories for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories
func (c *TranscribeService) ListCallAnalyticsCategories(input *ListCallAnalyticsCategoriesInput) (*ListCallAnalyticsCategoriesOutput, error) {
	req, out := c.ListCallAnalyticsCategoriesRequest(input)
	return out, req.Send()
}

// ListCallAnalyticsCategoriesWithContext is the same as ListCallAnalyticsCategories with the addition of
// the ability to pass a context and additional request options.
//
// See ListCallAnalyticsCategories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListCallAnalyticsCategoriesWithContext(ctx aws.Context, input *ListCallAnalyticsCategoriesInput, opts ...request.Option) (*ListCallAnalyticsCategoriesOutput, error) {
	req, out := c.ListCallAnalyticsCategoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCallAnalyticsCategoriesPages iterates over the pages of a ListCallAnalyticsCategories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCallAnalyticsCategories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCallAnalyticsCategories operation.
//    pageNum := 0
//    err := client.ListCallAnalyticsCategoriesPages(params,
//        func(page *transcribeservice.ListCallAnalyticsCategoriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListCallAnalyticsCategoriesPages(input *ListCallAnalyticsCategoriesInput, fn func(*ListCallAnalyticsCategoriesOutput, bool) bool) error {
	return c.ListCallAnalyticsCategoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCallAnalyticsCategoriesPagesWithContext same as ListCallAnalyticsCategoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListCallAnalyticsCategoriesPagesWithContext(ctx aws.Context, input *ListCallAnalyticsCategoriesInput, fn func(*ListCallAnalyticsCategoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCallAnalyticsCategoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCallAnalyticsCategoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCallAnalyticsCategoriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCallAnalyticsJobs = "ListCallAnalyticsJobs"

// ListCallAnalyticsJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListCallAnalyticsJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCallAnalyticsJobs for more information on using the ListCallAnalyticsJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCallAnalyticsJobsRequest method.
//    req, resp := client.ListCallAnalyticsJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs
func (c *TranscribeService) ListCallAnalyticsJobsRequest(input *ListCallAnalyticsJobsInput) (req *request.Request, output *ListCallAnalyticsJobsOutput) {
	op := &request.Operation{
		Name:       opListCallAnalyticsJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCallAnalyticsJobsInput{}
	}

	output = &ListCallAnalyticsJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCallAnalyticsJobs API operation for Amazon Transcribe Service.
//
// List call analytics jobs with a specified status or substring that matches
// their names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListCallAnalyticsJobs for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs
func (c *TranscribeService) ListCallAnalyticsJobs(input *ListCallAnalyticsJobsInput) (*ListCallAnalyticsJobsOutput, error) {
	req, out := c.ListCallAnalyticsJobsRequest(input)
	return out, req.Send()
}

// ListCallAnalyticsJobsWithContext is the same as ListCallAnalyticsJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListCallAnalyticsJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListCallAnalyticsJobsWithContext(ctx aws.Context, input *ListCallAnalyticsJobsInput, opts ...request.Option) (*ListCallAnalyticsJobsOutput, error) {
	req, out := c.ListCallAnalyticsJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCallAnalyticsJobsPages iterates over the pages of a ListCallAnalyticsJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCallAnalyticsJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCallAnalyticsJobs operation.
//    pageNum := 0
//    err := client.ListCallAnalyticsJobsPages(params,
//        func(page *transcribeservice.ListCallAnalyticsJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListCallAnalyticsJobsPages(input *ListCallAnalyticsJobsInput, fn func(*ListCallAnalyticsJobsOutput, bool) bool) error {
	return c.ListCallAnalyticsJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCallAnalyticsJobsPagesWithContext same as ListCallAnalyticsJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListCallAnalyticsJobsPagesWithContext(ctx aws.Context, input *ListCallAnalyticsJobsInput, fn func(*ListCallAnalyticsJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCallAnalyticsJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCallAnalyticsJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCallAnalyticsJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLanguageModels = "ListLanguageModels"

// ListLanguageModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListLanguageModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLanguageModels for more information on using the ListLanguageModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLanguageModelsRequest method.
//    req, resp := client.ListLanguageModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels
func (c *TranscribeService) ListLanguageModelsRequest(input *ListLanguageModelsInput) (req *request.Request, output *ListLanguageModelsOutput) {
	op := &request.Operation{
		Name:       opListLanguageModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLanguageModelsInput{}
	}

	output = &ListLanguageModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLanguageModels API operation for Amazon Transcribe Service.
//
// Provides more information about the custom language models you've created.
// You can use the information in this list to find a specific custom language
// model. You can then use the operation to get more information about it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListLanguageModels for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels
func (c *TranscribeService) ListLanguageModels(input *ListLanguageModelsInput) (*ListLanguageModelsOutput, error) {
	req, out := c.ListLanguageModelsRequest(input)
	return out, req.Send()
}

// ListLanguageModelsWithContext is the same as ListLanguageModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListLanguageModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListLanguageModelsWithContext(ctx aws.Context, input *ListLanguageModelsInput, opts ...request.Option) (*ListLanguageModelsOutput, error) {
	req, out := c.ListLanguageModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLanguageModelsPages iterates over the pages of a ListLanguageModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLanguageModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLanguageModels operation.
//    pageNum := 0
//    err := client.ListLanguageModelsPages(params,
//        func(page *transcribeservice.ListLanguageModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListLanguageModelsPages(input *ListLanguageModelsInput, fn func(*ListLanguageModelsOutput, bool) bool) error {
	return c.ListLanguageModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLanguageModelsPagesWithContext same as ListLanguageModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListLanguageModelsPagesWithContext(ctx aws.Context, input *ListLanguageModelsInput, fn func(*ListLanguageModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLanguageModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLanguageModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLanguageModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMedicalTranscriptionJobs = "ListMedicalTranscriptionJobs"

// ListMedicalTranscriptionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListMedicalTranscriptionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMedicalTranscriptionJobs for more information on using the ListMedicalTranscriptionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMedicalTranscriptionJobsRequest method.
//    req, resp := client.ListMedicalTranscriptionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs
func (c *TranscribeService) ListMedicalTranscriptionJobsRequest(input *ListMedicalTranscriptionJobsInput) (req *request.Request, output *ListMedicalTranscriptionJobsOutput) {
	op := &request.Operation{
		Name:       opListMedicalTranscriptionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMedicalTranscriptionJobsInput{}
	}

	output = &ListMedicalTranscriptionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMedicalTranscriptionJobs API operation for Amazon Transcribe Service.
//
// Lists medical transcription jobs with a specified status or substring that
// matches their names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListMedicalTranscriptionJobs for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs
func (c *TranscribeService) ListMedicalTranscriptionJobs(input *ListMedicalTranscriptionJobsInput) (*ListMedicalTranscriptionJobsOutput, error) {
	req, out := c.ListMedicalTranscriptionJobsRequest(input)
	return out, req.Send()
}

// ListMedicalTranscriptionJobsWithContext is the same as ListMedicalTranscriptionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListMedicalTranscriptionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListMedicalTranscriptionJobsWithContext(ctx aws.Context, input *ListMedicalTranscriptionJobsInput, opts ...request.Option) (*ListMedicalTranscriptionJobsOutput, error) {
	req, out := c.ListMedicalTranscriptionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMedicalTranscriptionJobsPages iterates over the pages of a ListMedicalTranscriptionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMedicalTranscriptionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMedicalTranscriptionJobs operation.
//    pageNum := 0
//    err := client.ListMedicalTranscriptionJobsPages(params,
//        func(page *transcribeservice.ListMedicalTranscriptionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListMedicalTranscriptionJobsPages(input *ListMedicalTranscriptionJobsInput, fn func(*ListMedicalTranscriptionJobsOutput, bool) bool) error {
	return c.ListMedicalTranscriptionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMedicalTranscriptionJobsPagesWithContext same as ListMedicalTranscriptionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListMedicalTranscriptionJobsPagesWithContext(ctx aws.Context, input *ListMedicalTranscriptionJobsInput, fn func(*ListMedicalTranscriptionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMedicalTranscriptionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMedicalTranscriptionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMedicalTranscriptionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMedicalVocabularies = "ListMedicalVocabularies"

// ListMedicalVocabulariesRequest generates a "aws/request.Request" representing the
// client's request for the ListMedicalVocabularies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMedicalVocabularies for more information on using the ListMedicalVocabularies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMedicalVocabulariesRequest method.
//    req, resp := client.ListMedicalVocabulariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies
func (c *TranscribeService) ListMedicalVocabulariesRequest(input *ListMedicalVocabulariesInput) (req *request.Request, output *ListMedicalVocabulariesOutput) {
	op := &request.Operation{
		Name:       opListMedicalVocabularies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMedicalVocabulariesInput{}
	}

	output = &ListMedicalVocabulariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMedicalVocabularies API operation for Amazon Transcribe Service.
//
// Returns a list of vocabularies that match the specified criteria. If you
// don't enter a value in any of the request parameters, returns the entire
// list of vocabularies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListMedicalVocabularies for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies
func (c *TranscribeService) ListMedicalVocabularies(input *ListMedicalVocabulariesInput) (*ListMedicalVocabulariesOutput, error) {
	req, out := c.ListMedicalVocabulariesRequest(input)
	return out, req.Send()
}

// ListMedicalVocabulariesWithContext is the same as ListMedicalVocabularies with the addition of
// the ability to pass a context and additional request options.
//
// See ListMedicalVocabularies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListMedicalVocabulariesWithContext(ctx aws.Context, input *ListMedicalVocabulariesInput, opts ...request.Option) (*ListMedicalVocabulariesOutput, error) {
	req, out := c.ListMedicalVocabulariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMedicalVocabulariesPages iterates over the pages of a ListMedicalVocabularies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMedicalVocabularies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMedicalVocabularies operation.
//    pageNum := 0
//    err := client.ListMedicalVocabulariesPages(params,
//        func(page *transcribeservice.ListMedicalVocabulariesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListMedicalVocabulariesPages(input *ListMedicalVocabulariesInput, fn func(*ListMedicalVocabulariesOutput, bool) bool) error {
	return c.ListMedicalVocabulariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMedicalVocabulariesPagesWithContext same as ListMedicalVocabulariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListMedicalVocabulariesPagesWithContext(ctx aws.Context, input *ListMedicalVocabulariesInput, fn func(*ListMedicalVocabulariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMedicalVocabulariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMedicalVocabulariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMedicalVocabulariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTagsForResource
func (c *TranscribeService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Transcribe Service.
//
// Lists all tags associated with a given transcription job, vocabulary, or
// resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTagsForResource
func (c *TranscribeService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTranscriptionJobs = "ListTranscriptionJobs"

// ListTranscriptionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTranscriptionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTranscriptionJobs for more information on using the ListTranscriptionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTranscriptionJobsRequest method.
//    req, resp := client.ListTranscriptionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs
func (c *TranscribeService) ListTranscriptionJobsRequest(input *ListTranscriptionJobsInput) (req *request.Request, output *ListTranscriptionJobsOutput) {
	op := &request.Operation{
		Name:       opListTranscriptionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTranscriptionJobsInput{}
	}

	output = &ListTranscriptionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTranscriptionJobs API operation for Amazon Transcribe Service.
//
// Lists transcription jobs with the specified status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListTranscriptionJobs for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs
func (c *TranscribeService) ListTranscriptionJobs(input *ListTranscriptionJobsInput) (*ListTranscriptionJobsOutput, error) {
	req, out := c.ListTranscriptionJobsRequest(input)
	return out, req.Send()
}

// ListTranscriptionJobsWithContext is the same as ListTranscriptionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTranscriptionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListTranscriptionJobsWithContext(ctx aws.Context, input *ListTranscriptionJobsInput, opts ...request.Option) (*ListTranscriptionJobsOutput, error) {
	req, out := c.ListTranscriptionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTranscriptionJobsPages iterates over the pages of a ListTranscriptionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTranscriptionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTranscriptionJobs operation.
//    pageNum := 0
//    err := client.ListTranscriptionJobsPages(params,
//        func(page *transcribeservice.ListTranscriptionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListTranscriptionJobsPages(input *ListTranscriptionJobsInput, fn func(*ListTranscriptionJobsOutput, bool) bool) error {
	return c.ListTranscriptionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTranscriptionJobsPagesWithContext same as ListTranscriptionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListTranscriptionJobsPagesWithContext(ctx aws.Context, input *ListTranscriptionJobsInput, fn func(*ListTranscriptionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTranscriptionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTranscriptionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTranscriptionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVocabularies = "ListVocabularies"

// ListVocabulariesRequest generates a "aws/request.Request" representing the
// client's request for the ListVocabularies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVocabularies for more information on using the ListVocabularies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVocabulariesRequest method.
//    req, resp := client.ListVocabulariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies
func (c *TranscribeService) ListVocabulariesRequest(input *ListVocabulariesInput) (req *request.Request, output *ListVocabulariesOutput) {
	op := &request.Operation{
		Name:       opListVocabularies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVocabulariesInput{}
	}

	output = &ListVocabulariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVocabularies API operation for Amazon Transcribe Service.
//
// Returns a list of vocabularies that match the specified criteria. If no criteria
// are specified, returns the entire list of vocabularies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListVocabularies for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies
func (c *TranscribeService) ListVocabularies(input *ListVocabulariesInput) (*ListVocabulariesOutput, error) {
	req, out := c.ListVocabulariesRequest(input)
	return out, req.Send()
}

// ListVocabulariesWithContext is the same as ListVocabularies with the addition of
// the ability to pass a context and additional request options.
//
// See ListVocabularies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabulariesWithContext(ctx aws.Context, input *ListVocabulariesInput, opts ...request.Option) (*ListVocabulariesOutput, error) {
	req, out := c.ListVocabulariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVocabulariesPages iterates over the pages of a ListVocabularies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVocabularies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVocabularies operation.
//    pageNum := 0
//    err := client.ListVocabulariesPages(params,
//        func(page *transcribeservice.ListVocabulariesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListVocabulariesPages(input *ListVocabulariesInput, fn func(*ListVocabulariesOutput, bool) bool) error {
	return c.ListVocabulariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVocabulariesPagesWithContext same as ListVocabulariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabulariesPagesWithContext(ctx aws.Context, input *ListVocabulariesInput, fn func(*ListVocabulariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVocabulariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVocabulariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVocabulariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVocabularyFilters = "ListVocabularyFilters"

// ListVocabularyFiltersRequest generates a "aws/request.Request" representing the
// client's request for the ListVocabularyFilters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVocabularyFilters for more information on using the ListVocabularyFilters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVocabularyFiltersRequest method.
//    req, resp := client.ListVocabularyFiltersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters
func (c *TranscribeService) ListVocabularyFiltersRequest(input *ListVocabularyFiltersInput) (req *request.Request, output *ListVocabularyFiltersOutput) {
	op := &request.Operation{
		Name:       opListVocabularyFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVocabularyFiltersInput{}
	}

	output = &ListVocabularyFiltersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVocabularyFilters API operation for Amazon Transcribe Service.
//
// Gets information about vocabulary filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListVocabularyFilters for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters
func (c *TranscribeService) ListVocabularyFilters(input *ListVocabularyFiltersInput) (*ListVocabularyFiltersOutput, error) {
	req, out := c.ListVocabularyFiltersRequest(input)
	return out, req.Send()
}

// ListVocabularyFiltersWithContext is the same as ListVocabularyFilters with the addition of
// the ability to pass a context and additional request options.
//
// See ListVocabularyFilters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabularyFiltersWithContext(ctx aws.Context, input *ListVocabularyFiltersInput, opts ...request.Option) (*ListVocabularyFiltersOutput, error) {
	req, out := c.ListVocabularyFiltersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVocabularyFiltersPages iterates over the pages of a ListVocabularyFilters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVocabularyFilters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVocabularyFilters operation.
//    pageNum := 0
//    err := client.ListVocabularyFiltersPages(params,
//        func(page *transcribeservice.ListVocabularyFiltersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListVocabularyFiltersPages(input *ListVocabularyFiltersInput, fn func(*ListVocabularyFiltersOutput, bool) bool) error {
	return c.ListVocabularyFiltersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVocabularyFiltersPagesWithContext same as ListVocabularyFiltersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabularyFiltersPagesWithContext(ctx aws.Context, input *ListVocabularyFiltersInput, fn func(*ListVocabularyFiltersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVocabularyFiltersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVocabularyFiltersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVocabularyFiltersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartCallAnalyticsJob = "StartCallAnalyticsJob"

// StartCallAnalyticsJobRequest generates a "aws/request.Request" representing the
// client's request for the StartCallAnalyticsJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCallAnalyticsJob for more information on using the StartCallAnalyticsJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartCallAnalyticsJobRequest method.
//    req, resp := client.StartCallAnalyticsJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartCallAnalyticsJob
func (c *TranscribeService) StartCallAnalyticsJobRequest(input *StartCallAnalyticsJobInput) (req *request.Request, output *StartCallAnalyticsJobOutput) {
	op := &request.Operation{
		Name:       opStartCallAnalyticsJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartCallAnalyticsJobInput{}
	}

	output = &StartCallAnalyticsJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartCallAnalyticsJob API operation for Amazon Transcribe Service.
//
// Starts an asynchronous analytics job that not only transcribes the audio
// recording of a caller and agent, but also returns additional insights. These
// insights include how quickly or loudly the caller or agent was speaking.
// To retrieve additional insights with your analytics jobs, create categories.
// A category is a way to classify analytics jobs based on attributes, such
// as a customer's sentiment or a particular phrase being used during the call.
// For more information, see the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation StartCallAnalyticsJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartCallAnalyticsJob
func (c *TranscribeService) StartCallAnalyticsJob(input *StartCallAnalyticsJobInput) (*StartCallAnalyticsJobOutput, error) {
	req, out := c.StartCallAnalyticsJobRequest(input)
	return out, req.Send()
}

// StartCallAnalyticsJobWithContext is the same as StartCallAnalyticsJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartCallAnalyticsJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) StartCallAnalyticsJobWithContext(ctx aws.Context, input *StartCallAnalyticsJobInput, opts ...request.Option) (*StartCallAnalyticsJobOutput, error) {
	req, out := c.StartCallAnalyticsJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMedicalTranscriptionJob = "StartMedicalTranscriptionJob"

// StartMedicalTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartMedicalTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMedicalTranscriptionJob for more information on using the StartMedicalTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMedicalTranscriptionJobRequest method.
//    req, resp := client.StartMedicalTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob
func (c *TranscribeService) StartMedicalTranscriptionJobRequest(input *StartMedicalTranscriptionJobInput) (req *request.Request, output *StartMedicalTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opStartMedicalTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMedicalTranscriptionJobInput{}
	}

	output = &StartMedicalTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMedicalTranscriptionJob API operation for Amazon Transcribe Service.
//
// Starts a batch job to transcribe medical speech to text.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation StartMedicalTranscriptionJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob
func (c *TranscribeService) StartMedicalTranscriptionJob(input *StartMedicalTranscriptionJobInput) (*StartMedicalTranscriptionJobOutput, error) {
	req, out := c.StartMedicalTranscriptionJobRequest(input)
	return out, req.Send()
}

// StartMedicalTranscriptionJobWithContext is the same as StartMedicalTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartMedicalTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) StartMedicalTranscriptionJobWithContext(ctx aws.Context, input *StartMedicalTranscriptionJobInput, opts ...request.Option) (*StartMedicalTranscriptionJobOutput, error) {
	req, out := c.StartMedicalTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTranscriptionJob = "StartTranscriptionJob"

// StartTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTranscriptionJob for more information on using the StartTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTranscriptionJobRequest method.
//    req, resp := client.StartTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob
func (c *TranscribeService) StartTranscriptionJobRequest(input *StartTranscriptionJobInput) (req *request.Request, output *StartTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opStartTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTranscriptionJobInput{}
	}

	output = &StartTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTranscriptionJob API operation for Amazon Transcribe Service.
//
// Starts an asynchronous job to transcribe speech to text.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation StartTranscriptionJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob
func (c *TranscribeService) StartTranscriptionJob(input *StartTranscriptionJobInput) (*StartTranscriptionJobOutput, error) {
	req, out := c.StartTranscriptionJobRequest(input)
	return out, req.Send()
}

// StartTranscriptionJobWithContext is the same as StartTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) StartTranscriptionJobWithContext(ctx aws.Context, input *StartTranscriptionJobInput, opts ...request.Option) (*StartTranscriptionJobOutput, error) {
	req, out := c.StartTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/TagResource
func (c *TranscribeService) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Transcribe Service.
//
// Tags an Amazon Transcribe resource with the given list of tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * ConflictException
//   There is already a resource with that name.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/TagResource
func (c *TranscribeService) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UntagResource
func (c *TranscribeService) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Transcribe Service.
//
// Removes specified tags from a specified Amazon Transcribe resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * ConflictException
//   There is already a resource with that name.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UntagResource
func (c *TranscribeService) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCallAnalyticsCategory = "UpdateCallAnalyticsCategory"

// UpdateCallAnalyticsCategoryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCallAnalyticsCategory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCallAnalyticsCategory for more information on using the UpdateCallAnalyticsCategory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCallAnalyticsCategoryRequest method.
//    req, resp := client.UpdateCallAnalyticsCategoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateCallAnalyticsCategory
func (c *TranscribeService) UpdateCallAnalyticsCategoryRequest(input *UpdateCallAnalyticsCategoryInput) (req *request.Request, output *UpdateCallAnalyticsCategoryOutput) {
	op := &request.Operation{
		Name:       opUpdateCallAnalyticsCategory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCallAnalyticsCategoryInput{}
	}

	output = &UpdateCallAnalyticsCategoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCallAnalyticsCategory API operation for Amazon Transcribe Service.
//
// Updates the call analytics category with new values. The UpdateCallAnalyticsCategory
// operation overwrites all of the existing information with the values that
// you provide in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UpdateCallAnalyticsCategory for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateCallAnalyticsCategory
func (c *TranscribeService) UpdateCallAnalyticsCategory(input *UpdateCallAnalyticsCategoryInput) (*UpdateCallAnalyticsCategoryOutput, error) {
	req, out := c.UpdateCallAnalyticsCategoryRequest(input)
	return out, req.Send()
}

// UpdateCallAnalyticsCategoryWithContext is the same as UpdateCallAnalyticsCategory with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCallAnalyticsCategory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UpdateCallAnalyticsCategoryWithContext(ctx aws.Context, input *UpdateCallAnalyticsCategoryInput, opts ...request.Option) (*UpdateCallAnalyticsCategoryOutput, error) {
	req, out := c.UpdateCallAnalyticsCategoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMedicalVocabulary = "UpdateMedicalVocabulary"

// UpdateMedicalVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMedicalVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMedicalVocabulary for more information on using the UpdateMedicalVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMedicalVocabularyRequest method.
//    req, resp := client.UpdateMedicalVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateMedicalVocabulary
func (c *TranscribeService) UpdateMedicalVocabularyRequest(input *UpdateMedicalVocabularyInput) (req *request.Request, output *UpdateMedicalVocabularyOutput) {
	op := &request.Operation{
		Name:       opUpdateMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMedicalVocabularyInput{}
	}

	output = &UpdateMedicalVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMedicalVocabulary API operation for Amazon Transcribe Service.
//
// Updates a vocabulary with new values that you provide in a different text
// file from the one you used to create the vocabulary. The UpdateMedicalVocabulary
// operation overwrites all of the existing information with the values that
// you provide in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UpdateMedicalVocabulary for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateMedicalVocabulary
func (c *TranscribeService) UpdateMedicalVocabulary(input *UpdateMedicalVocabularyInput) (*UpdateMedicalVocabularyOutput, error) {
	req, out := c.UpdateMedicalVocabularyRequest(input)
	return out, req.Send()
}

// UpdateMedicalVocabularyWithContext is the same as UpdateMedicalVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMedicalVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UpdateMedicalVocabularyWithContext(ctx aws.Context, input *UpdateMedicalVocabularyInput, opts ...request.Option) (*UpdateMedicalVocabularyOutput, error) {
	req, out := c.UpdateMedicalVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVocabulary = "UpdateVocabulary"

// UpdateVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVocabulary for more information on using the UpdateVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVocabularyRequest method.
//    req, resp := client.UpdateVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary
func (c *TranscribeService) UpdateVocabularyRequest(input *UpdateVocabularyInput) (req *request.Request, output *UpdateVocabularyOutput) {
	op := &request.Operation{
		Name:       opUpdateVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVocabularyInput{}
	}

	output = &UpdateVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVocabulary API operation for Amazon Transcribe Service.
//
// Updates an existing vocabulary with new values. The UpdateVocabulary operation
// overwrites all of the existing information with the values that you provide
// in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UpdateVocabulary for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary
func (c *TranscribeService) UpdateVocabulary(input *UpdateVocabularyInput) (*UpdateVocabularyOutput, error) {
	req, out := c.UpdateVocabularyRequest(input)
	return out, req.Send()
}

// UpdateVocabularyWithContext is the same as UpdateVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UpdateVocabularyWithContext(ctx aws.Context, input *UpdateVocabularyInput, opts ...request.Option) (*UpdateVocabularyOutput, error) {
	req, out := c.UpdateVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVocabularyFilter = "UpdateVocabularyFilter"

// UpdateVocabularyFilterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVocabularyFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVocabularyFilter for more information on using the UpdateVocabularyFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVocabularyFilterRequest method.
//    req, resp := client.UpdateVocabularyFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabularyFilter
func (c *TranscribeService) UpdateVocabularyFilterRequest(input *UpdateVocabularyFilterInput) (req *request.Request, output *UpdateVocabularyFilterOutput) {
	op := &request.Operation{
		Name:       opUpdateVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVocabularyFilterInput{}
	}

	output = &UpdateVocabularyFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVocabularyFilter API operation for Amazon Transcribe Service.
//
// Updates a vocabulary filter with a new list of filtered words.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UpdateVocabularyFilter for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabularyFilter
func (c *TranscribeService) UpdateVocabularyFilter(input *UpdateVocabularyFilterInput) (*UpdateVocabularyFilterOutput, error) {
	req, out := c.UpdateVocabularyFilterRequest(input)
	return out, req.Send()
}

// UpdateVocabularyFilterWithContext is the same as UpdateVocabularyFilter with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVocabularyFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UpdateVocabularyFilterWithContext(ctx aws.Context, input *UpdateVocabularyFilterInput, opts ...request.Option) (*UpdateVocabularyFilterOutput, error) {
	req, out := c.UpdateVocabularyFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A time range, set in seconds, between two points in the call.
type AbsoluteTimeRange struct {
	_ struct{} `type:"structure"`

	// A value that indicates the end of the time range in milliseconds. To set
	// absolute time range, you must specify a start time and an end time. For example,
	// if you specify the following values:
	//
	//    * StartTime - 10000
	//
	//    * Endtime - 50000
	//
	// The time range is set between 10,000 milliseconds and 50,000 milliseconds
	// into the call.
	EndTime *int64 `type:"long"`

	// A time range from the beginning of the call to the value that you've specified.
	// For example, if you specify 100000, the time range is set to the first 100,000
	// milliseconds of the call.
	First *int64 `type:"long"`

	// A time range from the value that you've specified to the end of the call.
	// For example, if you specify 100000, the time range is set to the last 100,000
	// milliseconds of the call.
	Last *int64 `type:"long"`

	// A value that indicates the beginning of the time range in seconds. To set
	// absolute time range, you must specify a start time and an end time. For example,
	// if you specify the following values:
	//
	//    * StartTime - 10000
	//
	//    * Endtime - 50000
	//
	// The time range is set between 10,000 milliseconds and 50,000 milliseconds
	// into the call.
	StartTime *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbsoluteTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbsoluteTimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *AbsoluteTimeRange) SetEndTime(v int64) *AbsoluteTimeRange {
	s.EndTime = &v
	return s
}

// SetFirst sets the First field's value.
func (s *AbsoluteTimeRange) SetFirst(v int64) *AbsoluteTimeRange {
	s.First = &v
	return s
}

// SetLast sets the Last field's value.
func (s *AbsoluteTimeRange) SetLast(v int64) *AbsoluteTimeRange {
	s.Last = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AbsoluteTimeRange) SetStartTime(v int64) *AbsoluteTimeRange {
	s.StartTime = &v
	return s
}

// Your request didn't pass one or more validation tests. For example, if the
// entity that you're trying to delete doesn't exist or if it is in a non-terminal
// state (for example, it's "in progress"). See the exception Message field
// for more information.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes an asynchronous analytics job that was created with the StartAnalyticsJob
// operation.
type CallAnalyticsJob struct {
	_ struct{} `type:"structure"`

	// The name of the call analytics job.
	CallAnalyticsJobName *string `min:"1" type:"string"`

	// The status of the analytics job.
	CallAnalyticsJobStatus *string `type:"string" enum:"CallAnalyticsJobStatus"`

	// Shows numeric values to indicate the channel assigned to the agent's audio
	// and the channel assigned to the customer's audio.
	ChannelDefinitions []*ChannelDefinition `min:"2" type:"list"`

	// A timestamp that shows when the analytics job was completed.
	CompletionTime *time.Time `type:"timestamp"`

	// A timestamp that shows when the analytics job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Number (ARN) that you use to access the analytics job.
	// ARNs have the format arn:partition:service:region:account-id:resource-type/resource-id.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// If the AnalyticsJobStatus is FAILED, this field contains information about
	// why the job failed.
	//
	// The FailureReason field can contain one of the following values:
	//
	//    * Unsupported media format: The media format specified in the MediaFormat
	//    field of the request isn't valid. See the description of the MediaFormat
	//    field for a list of valid values.
	//
	//    * The media format provided does not match the detected media format:
	//    The media format of the audio file doesn't match the format specified
	//    in the MediaFormat field in the request. Check the media format of your
	//    media file and make sure the two values match.
	//
	//    * Invalid sample rate for audio file: The sample rate specified in the
	//    MediaSampleRateHertz of the request isn't valid. The sample rate must
	//    be between 8,000 and 48,000 Hertz.
	//
	//    * The sample rate provided does not match the detected sample rate: The
	//    sample rate in the audio file doesn't match the sample rate specified
	//    in the MediaSampleRateHertz field in the request. Check the sample rate
	//    of your media file and make sure that the two values match.
	//
	//    * Invalid file size: file size too large: The size of your audio file
	//    is larger than what Amazon Transcribe Medical can process. For more information,
	//    see Guidelines and Quotas in the Amazon Transcribe Medical Guide.
	//
	//    * Invalid number of channels: number of channels too large: Your audio
	//    contains more channels than Amazon Transcribe Medical is configured to
	//    process. To request additional channels, see Amazon Transcribe Medical
	//    Endpoints and Quotas in the Amazon Web Services General Reference (https://docs.aws.amazon.com/general/latest/gr/Welcome.html).
	FailureReason *string `type:"string"`

	// A value between zero and one that Amazon Transcribe assigned to the language
	// that it identified in the source audio. This value appears only when you
	// don't provide a single language code. Larger values indicate that Amazon
	// Transcribe has higher confidence in the language that it identified.
	IdentifiedLanguageScore *float64 `type:"float"`

	// If you know the language spoken between the customer and the agent, specify
	// a language code for this field.
	//
	// If you don't know the language, you can leave this field blank, and Amazon
	// Transcribe will use machine learning to automatically identify the language.
	// To improve the accuracy of language identification, you can provide an array
	// containing the possible language codes for the language spoken in your audio.
	// Refer to Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// for additional information.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Describes the input media file in a transcription request.
	Media *Media `type:"structure"`

	// The format of the input audio file. Note: for call analytics jobs, only the
	// following media formats are supported: MP3, MP4, WAV, FLAC, OGG, and WebM.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in Hertz, of the audio.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// Provides information about the settings used to run a transcription job.
	Settings *CallAnalyticsJobSettings `type:"structure"`

	// A timestamp that shows when the analytics job started processing.
	StartTime *time.Time `type:"timestamp"`

	// Identifies the location of a transcription.
	Transcript *Transcript `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsJob) GoString() string {
	return s.String()
}

// SetCallAnalyticsJobName sets the CallAnalyticsJobName field's value.
func (s *CallAnalyticsJob) SetCallAnalyticsJobName(v string) *CallAnalyticsJob {
	s.CallAnalyticsJobName = &v
	return s
}

// SetCallAnalyticsJobStatus sets the CallAnalyticsJobStatus field's value.
func (s *CallAnalyticsJob) SetCallAnalyticsJobStatus(v string) *CallAnalyticsJob {
	s.CallAnalyticsJobStatus = &v
	return s
}

// SetChannelDefinitions sets the ChannelDefinitions field's value.
func (s *CallAnalyticsJob) SetChannelDefinitions(v []*ChannelDefinition) *CallAnalyticsJob {
	s.ChannelDefinitions = v
	return s
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *CallAnalyticsJob) SetCompletionTime(v time.Time) *CallAnalyticsJob {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CallAnalyticsJob) SetCreationTime(v time.Time) *CallAnalyticsJob {
	s.CreationTime = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *CallAnalyticsJob) SetDataAccessRoleArn(v string) *CallAnalyticsJob {
	s.DataAccessRoleArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CallAnalyticsJob) SetFailureReason(v string) *CallAnalyticsJob {
	s.FailureReason = &v
	return s
}

// SetIdentifiedLanguageScore sets the IdentifiedLanguageScore field's value.
func (s *CallAnalyticsJob) SetIdentifiedLanguageScore(v float64) *CallAnalyticsJob {
	s.IdentifiedLanguageScore = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CallAnalyticsJob) SetLanguageCode(v string) *CallAnalyticsJob {
	s.LanguageCode = &v
	return s
}

// SetMedia sets the Media field's value.
func (s *CallAnalyticsJob) SetMedia(v *Media) *CallAnalyticsJob {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *CallAnalyticsJob) SetMediaFormat(v string) *CallAnalyticsJob {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *CallAnalyticsJob) SetMediaSampleRateHertz(v int64) *CallAnalyticsJob {
	s.MediaSampleRateHertz = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *CallAnalyticsJob) SetSettings(v *CallAnalyticsJobSettings) *CallAnalyticsJob {
	s.Settings = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CallAnalyticsJob) SetStartTime(v time.Time) *CallAnalyticsJob {
	s.StartTime = &v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *CallAnalyticsJob) SetTranscript(v *Transcript) *CallAnalyticsJob {
	s.Transcript = v
	return s
}

// Provides optional settings for the CallAnalyticsJob operation.
type CallAnalyticsJobSettings struct {
	_ struct{} `type:"structure"`

	// Settings for content redaction within a transcription job.
	ContentRedaction *ContentRedaction `type:"structure"`

	// The language identification settings associated with your call analytics
	// job. These settings include VocabularyName, VocabularyFilterName, and LanguageModelName.
	LanguageIdSettings map[string]*LanguageIdSettings `min:"1" type:"map"`

	// The structure used to describe a custom language model.
	LanguageModelName *string `min:"1" type:"string"`

	// When you run a call analytics job, you can specify the language spoken in
	// the audio, or you can have Amazon Transcribe identify the language for you.
	//
	// To specify a language, specify an array with one language code. If you don't
	// know the language, you can leave this field blank and Amazon Transcribe will
	// use machine learning to identify the language for you. To improve the ability
	// of Amazon Transcribe to correctly identify the language, you can provide
	// an array of the languages that can be present in the audio. Refer to Supported
	// languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// for additional information.
	LanguageOptions []*string `min:"1" type:"list" enum:"LanguageCode"`

	// Set to mask to remove filtered text from the transcript and replace it with
	// three asterisks ("***") as placeholder text. Set to remove to remove filtered
	// text from the transcript without using placeholder text. Set to tag to mark
	// the word in the transcription output that matches the vocabulary filter.
	// When you set the filter method to tag, the words matching your vocabulary
	// filter are not masked or removed.
	VocabularyFilterMethod *string `type:"string" enum:"VocabularyFilterMethod"`

	// The name of the vocabulary filter to use when running a call analytics job.
	// The filter that you specify must have the same language code as the analytics
	// job.
	VocabularyFilterName *string `min:"1" type:"string"`

	// The name of a vocabulary to use when processing the call analytics job.
	VocabularyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsJobSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsJobSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CallAnalyticsJobSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CallAnalyticsJobSettings"}
	if s.LanguageIdSettings != nil && len(s.LanguageIdSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageIdSettings", 1))
	}
	if s.LanguageModelName != nil && len(*s.LanguageModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageModelName", 1))
	}
	if s.LanguageOptions != nil && len(s.LanguageOptions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageOptions", 1))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}
	if s.ContentRedaction != nil {
		if err := s.ContentRedaction.Validate(); err != nil {
			invalidParams.AddNested("ContentRedaction", err.(request.ErrInvalidParams))
		}
	}
	if s.LanguageIdSettings != nil {
		for i, v := range s.LanguageIdSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LanguageIdSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentRedaction sets the ContentRedaction field's value.
func (s *CallAnalyticsJobSettings) SetContentRedaction(v *ContentRedaction) *CallAnalyticsJobSettings {
	s.ContentRedaction = v
	return s
}

// SetLanguageIdSettings sets the LanguageIdSettings field's value.
func (s *CallAnalyticsJobSettings) SetLanguageIdSettings(v map[string]*LanguageIdSettings) *CallAnalyticsJobSettings {
	s.LanguageIdSettings = v
	return s
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *CallAnalyticsJobSettings) SetLanguageModelName(v string) *CallAnalyticsJobSettings {
	s.LanguageModelName = &v
	return s
}

// SetLanguageOptions sets the LanguageOptions field's value.
func (s *CallAnalyticsJobSettings) SetLanguageOptions(v []*string) *CallAnalyticsJobSettings {
	s.LanguageOptions = v
	return s
}

// SetVocabularyFilterMethod sets the VocabularyFilterMethod field's value.
func (s *CallAnalyticsJobSettings) SetVocabularyFilterMethod(v string) *CallAnalyticsJobSettings {
	s.VocabularyFilterMethod = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *CallAnalyticsJobSettings) SetVocabularyFilterName(v string) *CallAnalyticsJobSettings {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CallAnalyticsJobSettings) SetVocabularyName(v string) *CallAnalyticsJobSettings {
	s.VocabularyName = &v
	return s
}

// Provides summary information about a call analytics job.
type CallAnalyticsJobSummary struct {
	_ struct{} `type:"structure"`

	// The name of the call analytics job.
	CallAnalyticsJobName *string `min:"1" type:"string"`

	// The status of the call analytics job.
	CallAnalyticsJobStatus *string `type:"string" enum:"CallAnalyticsJobStatus"`

	// A timestamp that shows when the job was completed.
	CompletionTime *time.Time `type:"timestamp"`

	// A timestamp that shows when the call analytics job was created.
	CreationTime *time.Time `type:"timestamp"`

	// If the CallAnalyticsJobStatus is FAILED, a description of the error.
	FailureReason *string `type:"string"`

	// The language of the transcript in the source audio file.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A timestamp that shows when the job began processing.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsJobSummary) GoString() string {
	return s.String()
}

// SetCallAnalyticsJobName sets the CallAnalyticsJobName field's value.
func (s *CallAnalyticsJobSummary) SetCallAnalyticsJobName(v string) *CallAnalyticsJobSummary {
	s.CallAnalyticsJobName = &v
	return s
}

// SetCallAnalyticsJobStatus sets the CallAnalyticsJobStatus field's value.
func (s *CallAnalyticsJobSummary) SetCallAnalyticsJobStatus(v string) *CallAnalyticsJobSummary {
	s.CallAnalyticsJobStatus = &v
	return s
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *CallAnalyticsJobSummary) SetCompletionTime(v time.Time) *CallAnalyticsJobSummary {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CallAnalyticsJobSummary) SetCreationTime(v time.Time) *CallAnalyticsJobSummary {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CallAnalyticsJobSummary) SetFailureReason(v string) *CallAnalyticsJobSummary {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CallAnalyticsJobSummary) SetLanguageCode(v string) *CallAnalyticsJobSummary {
	s.LanguageCode = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CallAnalyticsJobSummary) SetStartTime(v time.Time) *CallAnalyticsJobSummary {
	s.StartTime = &v
	return s
}

// An object that contains the rules and additional information about a call
// analytics category.
type CategoryProperties struct {
	_ struct{} `type:"structure"`

	// The name of the call analytics category.
	CategoryName *string `min:"1" type:"string"`

	// A timestamp that shows when the call analytics category was created.
	CreateTime *time.Time `type:"timestamp"`

	// A timestamp that shows when the call analytics category was most recently
	// updated.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The rules used to create a call analytics category.
	Rules []*Rule `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryProperties) GoString() string {
	return s.String()
}

// SetCategoryName sets the CategoryName field's value.
func (s *CategoryProperties) SetCategoryName(v string) *CategoryProperties {
	s.CategoryName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CategoryProperties) SetCreateTime(v time.Time) *CategoryProperties {
	s.CreateTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *CategoryProperties) SetLastUpdateTime(v time.Time) *CategoryProperties {
	s.LastUpdateTime = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CategoryProperties) SetRules(v []*Rule) *CategoryProperties {
	s.Rules = v
	return s
}

// For a call analytics job, an object that indicates the audio channel that
// belongs to the agent and the audio channel that belongs to the customer.
type ChannelDefinition struct {
	_ struct{} `type:"structure"`

	// A value that indicates the audio channel.
	ChannelId *int64 `type:"integer"`

	// Indicates whether the person speaking on the audio channel is the agent or
	// customer.
	ParticipantRole *string `type:"string" enum:"ParticipantRole"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelDefinition) GoString() string {
	return s.String()
}

// SetChannelId sets the ChannelId field's value.
func (s *ChannelDefinition) SetChannelId(v int64) *ChannelDefinition {
	s.ChannelId = &v
	return s
}

// SetParticipantRole sets the ParticipantRole field's value.
func (s *ChannelDefinition) SetParticipantRole(v string) *ChannelDefinition {
	s.ParticipantRole = &v
	return s
}

// There is already a resource with that name.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Settings for content redaction within a transcription job.
type ContentRedaction struct {
	_ struct{} `type:"structure"`

	// The types of personally identifiable information (PII) you want to redact
	// in your transcript.
	PiiEntityTypes []*string `type:"list" enum:"PiiEntityType"`

	// The output transcript file stored in either the default S3 bucket or in a
	// bucket you specify.
	//
	// When you choose redacted Amazon Transcribe outputs only the redacted transcript.
	//
	// When you choose redacted_and_unredacted Amazon Transcribe outputs both the
	// redacted and unredacted transcripts.
	//
	// RedactionOutput is a required field
	RedactionOutput *string `type:"string" required:"true" enum:"RedactionOutput"`

	// Request parameter that defines the entities to be redacted. The only accepted
	// value is PII.
	//
	// RedactionType is a required field
	RedactionType *string `type:"string" required:"true" enum:"RedactionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentRedaction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentRedaction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentRedaction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentRedaction"}
	if s.RedactionOutput == nil {
		invalidParams.Add(request.NewErrParamRequired("RedactionOutput"))
	}
	if s.RedactionType == nil {
		invalidParams.Add(request.NewErrParamRequired("RedactionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPiiEntityTypes sets the PiiEntityTypes field's value.
func (s *ContentRedaction) SetPiiEntityTypes(v []*string) *ContentRedaction {
	s.PiiEntityTypes = v
	return s
}

// SetRedactionOutput sets the RedactionOutput field's value.
func (s *ContentRedaction) SetRedactionOutput(v string) *ContentRedaction {
	s.RedactionOutput = &v
	return s
}

// SetRedactionType sets the RedactionType field's value.
func (s *ContentRedaction) SetRedactionType(v string) *ContentRedaction {
	s.RedactionType = &v
	return s
}

type CreateCallAnalyticsCategoryInput struct {
	_ struct{} `type:"structure"`

	// A unique name, chosen by you, for your call analytics category. For example,
	// sentiment-positive-last30seconds.
	//
	// CategoryName is a required field
	CategoryName *string `min:"1" type:"string" required:"true"`

	// Rules make up a call analytics category. When creating a call analytics category,
	// you must create between 1 and 20 rules for your category. For each rule,
	// you specify a filter you want applied to the attributes of a call. For example,
	// you can choose a sentiment filter that detects if a customer's sentiment
	// was positive during the last 30 seconds of the call.
	//
	// Rules is a required field
	Rules []*Rule `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCallAnalyticsCategoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCallAnalyticsCategoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCallAnalyticsCategoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCallAnalyticsCategoryInput"}
	if s.CategoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("CategoryName"))
	}
	if s.CategoryName != nil && len(*s.CategoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CategoryName", 1))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryName sets the CategoryName field's value.
func (s *CreateCallAnalyticsCategoryInput) SetCategoryName(v string) *CreateCallAnalyticsCategoryInput {
	s.CategoryName = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateCallAnalyticsCategoryInput) SetRules(v []*Rule) *CreateCallAnalyticsCategoryInput {
	s.Rules = v
	return s
}

type CreateCallAnalyticsCategoryOutput struct {
	_ struct{} `type:"structure"`

	// If your audio matches one of your categories, this field contains data on
	// that category and its associated rules. This parameter shows which category
	// is flagged (CategoryName) along with metadata for the rules that match your
	// audio. Metadata includes the rule filter (such as InterruptionFilter, NonTalkTimeFilter,
	// SentimentFilter, and TranscriptFilter) and where in your audio (StartTime
	// and EndTime) the rule has a match.
	CategoryProperties *CategoryProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCallAnalyticsCategoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCallAnalyticsCategoryOutput) GoString() string {
	return s.String()
}

// SetCategoryProperties sets the CategoryProperties field's value.
func (s *CreateCallAnalyticsCategoryOutput) SetCategoryProperties(v *CategoryProperties) *CreateCallAnalyticsCategoryOutput {
	s.CategoryProperties = v
	return s
}

type CreateLanguageModelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Transcribe standard language model, or base model, used to create
	// your custom language model. Amazon Transcribe offers two options for base
	// models: Wideband and Narrowband.
	//
	// If the audio you want to transcribe has a sample rate of 16,000 Hz or greater,
	// choose WideBand. To transcribe audio with a sample rate less than 16,000
	// Hz, choose NarrowBand.
	//
	// BaseModelName is a required field
	BaseModelName *string `type:"string" required:"true" enum:"BaseModelName"`

	// Contains your data access role ARN (Amazon Resource Name) and the Amazon
	// S3 locations of your training (S3Uri) and tuning (TuningDataS3Uri) data.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The language of your custom language model; note that the language code you
	// select must match the language of your training and tuning data.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"CLMLanguageCode"`

	// The name of your new custom language model.
	//
	// This name is case sensitive, cannot contain spaces, and must be unique within
	// an Amazon Web Services account. If you try to create a language model with
	// the same name as a previous language model, you get a ConflictException error.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`

	// Optionally add tags, each in the form of a key:value pair, to your new language
	// model. See also: .
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLanguageModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLanguageModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLanguageModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLanguageModelInput"}
	if s.BaseModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("BaseModelName"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseModelName sets the BaseModelName field's value.
func (s *CreateLanguageModelInput) SetBaseModelName(v string) *CreateLanguageModelInput {
	s.BaseModelName = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateLanguageModelInput) SetInputDataConfig(v *InputDataConfig) *CreateLanguageModelInput {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateLanguageModelInput) SetLanguageCode(v string) *CreateLanguageModelInput {
	s.LanguageCode = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CreateLanguageModelInput) SetModelName(v string) *CreateLanguageModelInput {
	s.ModelName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLanguageModelInput) SetTags(v []*Tag) *CreateLanguageModelInput {
	s.Tags = v
	return s
}

type CreateLanguageModelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Transcribe standard language model, or base model, you used when
	// creating your custom language model.
	//
	// If your audio has a sample rate of 16,000 Hz or greater, this value should
	// be WideBand. If your audio has a sample rate of less than 16,000 Hz, this
	// value should be NarrowBand.
	BaseModelName *string `type:"string" enum:"BaseModelName"`

	// Lists your data access role ARN (Amazon Resource Name) and the Amazon S3
	// locations your provided for your training (S3Uri) and tuning (TuningDataS3Uri)
	// data.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The language code you selected for your custom language model.
	LanguageCode *string `type:"string" enum:"CLMLanguageCode"`

	// The unique name you chose for your custom language model.
	ModelName *string `min:"1" type:"string"`

	// The status of your custom language model. When the status shows as COMPLETED,
	// your model is ready to use.
	ModelStatus *string `type:"string" enum:"ModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLanguageModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLanguageModelOutput) GoString() string {
	return s.String()
}

// SetBaseModelName sets the BaseModelName field's value.
func (s *CreateLanguageModelOutput) SetBaseModelName(v string) *CreateLanguageModelOutput {
	s.BaseModelName = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateLanguageModelOutput) SetInputDataConfig(v *InputDataConfig) *CreateLanguageModelOutput {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateLanguageModelOutput) SetLanguageCode(v string) *CreateLanguageModelOutput {
	s.LanguageCode = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CreateLanguageModelOutput) SetModelName(v string) *CreateLanguageModelOutput {
	s.ModelName = &v
	return s
}

// SetModelStatus sets the ModelStatus field's value.
func (s *CreateLanguageModelOutput) SetModelStatus(v string) *CreateLanguageModelOutput {
	s.ModelStatus = &v
	return s
}

type CreateMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code that represents the language of the entries in your custom
	// vocabulary. Note that U.S. English (en-US) is the only language supported
	// with Amazon Transcribe Medical.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Adds one or more tags, each in the form of a key:value pair, to a new medical
	// vocabulary at the time you create the new vocabulary.
	//
	// To learn more about using tags with Amazon Transcribe, refer to Tagging resources
	// (https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
	Tags []*Tag `min:"1" type:"list"`

	// The Amazon S3 location (URI) of the text file that contains your custom vocabulary.
	// The URI must be in the same Amazon Web Services Region as the resource that
	// you're calling.
	//
	// Here's an example URI path:
	//
	// https://s3.us-east-1.amazonaws.com/my-s3-bucket/my-vocab-file.txt
	//
	// VocabularyFileUri is a required field
	VocabularyFileUri *string `min:"1" type:"string" required:"true"`

	// The name of your new vocabulary.
	//
	// This name is case sensitive, cannot contain spaces, and must be unique within
	// an Amazon Web Services account. If you try to create a vocabulary with the
	// same name as a previous vocabulary, you get a ConflictException error.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMedicalVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMedicalVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMedicalVocabularyInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VocabularyFileUri == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFileUri"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateMedicalVocabularyInput) SetLanguageCode(v string) *CreateMedicalVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMedicalVocabularyInput) SetTags(v []*Tag) *CreateMedicalVocabularyInput {
	s.Tags = v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *CreateMedicalVocabularyInput) SetVocabularyFileUri(v string) *CreateMedicalVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateMedicalVocabularyInput) SetVocabularyName(v string) *CreateMedicalVocabularyInput {
	s.VocabularyName = &v
	return s
}

type CreateMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// If the VocabularyState field is FAILED, FailureReason contains information
	// about why the job failed.
	FailureReason *string `type:"string"`

	// The language code you selected for your medical vocabulary. Note that U.S.
	// English (en-US) is the only language supported with Amazon Transcribe Medical.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time you created your custom medical vocabulary.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name you chose for your vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of your custom medical vocabulary. If the state is READY,
	// you can use the vocabulary in a StartMedicalTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMedicalVocabularyOutput) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateMedicalVocabularyOutput) SetFailureReason(v string) *CreateMedicalVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateMedicalVocabularyOutput) SetLanguageCode(v string) *CreateMedicalVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateMedicalVocabularyOutput) SetLastModifiedTime(v time.Time) *CreateMedicalVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateMedicalVocabularyOutput) SetVocabularyName(v string) *CreateMedicalVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *CreateMedicalVocabularyOutput) SetVocabularyState(v string) *CreateMedicalVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type CreateVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The language code of the words in the vocabulary filter. All words in the
	// filter must be in the same language. The vocabulary filter can only be used
	// with transcription jobs in the specified language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Adds one or more tags, each in the form of a key:value pair, to a new vocabulary
	// filter at the time you create this new vocabulary filter.
	Tags []*Tag `min:"1" type:"list"`

	// The Amazon S3 location of a text file used as input to create the vocabulary
	// filter. Only use characters from the character set defined for custom vocabularies.
	// For a list of character sets, see Character Sets for Custom Vocabularies
	// (https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html).
	//
	// Your vocabulary filter file must be less than 50 KB in size.
	//
	// Note that if you include VocabularyFilterFileUri in your request, you cannot
	// use Words; you must choose one or the other.
	VocabularyFilterFileUri *string `min:"1" type:"string"`

	// The name of your new vocabulary filter.
	//
	// This name is case sensitive, cannot contain spaces, and must be unique within
	// an Amazon Web Services account. If you try to create a vocabulary filter
	// with the same name as a previous vocabulary filter, you get a ConflictException
	// error.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`

	// The words you want in your vocabulary filter. Only use characters specified
	// in the Character sets (https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html)
	// for the language you're transcribing.
	//
	// Note that if you include Words in your request, you cannot use VocabularyFilterFileUri;
	// you must choose one or the other.
	Words []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVocabularyFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVocabularyFilterInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VocabularyFilterFileUri != nil && len(*s.VocabularyFilterFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterFileUri", 1))
	}
	if s.VocabularyFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.Words != nil && len(s.Words) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Words", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyFilterInput) SetLanguageCode(v string) *CreateVocabularyFilterInput {
	s.LanguageCode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVocabularyFilterInput) SetTags(v []*Tag) *CreateVocabularyFilterInput {
	s.Tags = v
	return s
}

// SetVocabularyFilterFileUri sets the VocabularyFilterFileUri field's value.
func (s *CreateVocabularyFilterInput) SetVocabularyFilterFileUri(v string) *CreateVocabularyFilterInput {
	s.VocabularyFilterFileUri = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *CreateVocabularyFilterInput) SetVocabularyFilterName(v string) *CreateVocabularyFilterInput {
	s.VocabularyFilterName = &v
	return s
}

// SetWords sets the Words field's value.
func (s *CreateVocabularyFilterInput) SetWords(v []*string) *CreateVocabularyFilterInput {
	s.Words = v
	return s
}

type CreateVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`

	// The language code associated with your vocabulary filter.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time the vocabulary filter was modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary filter.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyFilterOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyFilterOutput) SetLanguageCode(v string) *CreateVocabularyFilterOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateVocabularyFilterOutput) SetLastModifiedTime(v time.Time) *CreateVocabularyFilterOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *CreateVocabularyFilterOutput) SetVocabularyFilterName(v string) *CreateVocabularyFilterOutput {
	s.VocabularyFilterName = &v
	return s
}

type CreateVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code that represents the language of the entries in your custom
	// vocabulary. Each vocabulary must contain terms in only one language. For
	// a list of languages and their corresponding language codes, see Supported
	// languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html).
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Use this flag to include a list of terms within your request.
	//
	// Note that if you include Phrases in your request, you cannot use VocabularyFileUri;
	// you must choose one or the other.
	Phrases []*string `type:"list"`

	// Adds one or more tags, each in the form of a key:value pair, to a new custom
	// vocabulary at the time you create this new vocabulary.
	Tags []*Tag `min:"1" type:"list"`

	// The S3 location of the text file that contains your custom vocabulary. The
	// URI must be located in the same region as the API endpoint you're calling.
	//
	// Here's an example URI path:
	//
	// https://s3.us-east-1.amazonaws.com/my-s3-bucket/my-vocab-file.txt
	//
	// Note that if you include VocabularyFileUri in your request, you cannot use
	// the Phrases flag; you must choose one or the other.
	VocabularyFileUri *string `min:"1" type:"string"`

	// The name of your new vocabulary.
	//
	// This name is case sensitive, cannot contain spaces, and must be unique within
	// an Amazon Web Services account. If you try to create a vocabulary with the
	// same name as a previous vocabulary, you get a ConflictException error.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVocabularyInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyInput) SetLanguageCode(v string) *CreateVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetPhrases sets the Phrases field's value.
func (s *CreateVocabularyInput) SetPhrases(v []*string) *CreateVocabularyInput {
	s.Phrases = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVocabularyInput) SetTags(v []*Tag) *CreateVocabularyInput {
	s.Tags = v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *CreateVocabularyInput) SetVocabularyFileUri(v string) *CreateVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateVocabularyInput) SetVocabularyName(v string) *CreateVocabularyInput {
	s.VocabularyName = &v
	return s
}

type CreateVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// If the VocabularyState field is FAILED, FailureReason contains information
	// about why the job failed.
	FailureReason *string `type:"string"`

	// The language code you selected for your vocabulary.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time you created your custom vocabulary.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name you chose for your vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of your vocabulary. If the state is READY, you can use
	// the vocabulary in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyOutput) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateVocabularyOutput) SetFailureReason(v string) *CreateVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyOutput) SetLanguageCode(v string) *CreateVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateVocabularyOutput) SetLastModifiedTime(v time.Time) *CreateVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateVocabularyOutput) SetVocabularyName(v string) *CreateVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *CreateVocabularyOutput) SetVocabularyState(v string) *CreateVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type DeleteCallAnalyticsCategoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the call analytics category you want to delete. Category names
	// are case-sensitive.
	//
	// CategoryName is a required field
	CategoryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsCategoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsCategoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCallAnalyticsCategoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCallAnalyticsCategoryInput"}
	if s.CategoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("CategoryName"))
	}
	if s.CategoryName != nil && len(*s.CategoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CategoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryName sets the CategoryName field's value.
func (s *DeleteCallAnalyticsCategoryInput) SetCategoryName(v string) *DeleteCallAnalyticsCategoryInput {
	s.CategoryName = &v
	return s
}

type DeleteCallAnalyticsCategoryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsCategoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsCategoryOutput) GoString() string {
	return s.String()
}

type DeleteCallAnalyticsJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the call analytics job you want to delete. Job names are case-sensitive.
	//
	// CallAnalyticsJobName is a required field
	CallAnalyticsJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCallAnalyticsJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCallAnalyticsJobInput"}
	if s.CallAnalyticsJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("CallAnalyticsJobName"))
	}
	if s.CallAnalyticsJobName != nil && len(*s.CallAnalyticsJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallAnalyticsJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAnalyticsJobName sets the CallAnalyticsJobName field's value.
func (s *DeleteCallAnalyticsJobInput) SetCallAnalyticsJobName(v string) *DeleteCallAnalyticsJobInput {
	s.CallAnalyticsJobName = &v
	return s
}

type DeleteCallAnalyticsJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsJobOutput) GoString() string {
	return s.String()
}

type DeleteLanguageModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the model you want to delete. Model names are case-sensitive.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLanguageModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLanguageModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLanguageModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLanguageModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DeleteLanguageModelInput) SetModelName(v string) *DeleteLanguageModelInput {
	s.ModelName = &v
	return s
}

type DeleteLanguageModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLanguageModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLanguageModelOutput) GoString() string {
	return s.String()
}

type DeleteMedicalTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the medical transcription job you want to delete. Job names are
	// case-sensitive.
	//
	// MedicalTranscriptionJobName is a required field
	MedicalTranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMedicalTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMedicalTranscriptionJobInput"}
	if s.MedicalTranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("MedicalTranscriptionJobName"))
	}
	if s.MedicalTranscriptionJobName != nil && len(*s.MedicalTranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MedicalTranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *DeleteMedicalTranscriptionJobInput) SetMedicalTranscriptionJobName(v string) *DeleteMedicalTranscriptionJobInput {
	s.MedicalTranscriptionJobName = &v
	return s
}

type DeleteMedicalTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalTranscriptionJobOutput) GoString() string {
	return s.String()
}

type DeleteMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary that you want to delete. Vocabulary names are
	// case-sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMedicalVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMedicalVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *DeleteMedicalVocabularyInput) SetVocabularyName(v string) *DeleteMedicalVocabularyInput {
	s.VocabularyName = &v
	return s
}

type DeleteMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalVocabularyOutput) GoString() string {
	return s.String()
}

type DeleteTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the transcription job you want to delete. Job names are case-sensitive.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTranscriptionJobInput"}
	if s.TranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *DeleteTranscriptionJobInput) SetTranscriptionJobName(v string) *DeleteTranscriptionJobInput {
	s.TranscriptionJobName = &v
	return s
}

type DeleteTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTranscriptionJobOutput) GoString() string {
	return s.String()
}

type DeleteVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary filter you want to delete. Vocabulary filter names
	// are case-sensitive.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVocabularyFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVocabularyFilterInput"}
	if s.VocabularyFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *DeleteVocabularyFilterInput) SetVocabularyFilterName(v string) *DeleteVocabularyFilterInput {
	s.VocabularyFilterName = &v
	return s
}

type DeleteVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyFilterOutput) GoString() string {
	return s.String()
}

type DeleteVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary you want to delete. Vocabulary names are case-sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *DeleteVocabularyInput) SetVocabularyName(v string) *DeleteVocabularyInput {
	s.VocabularyName = &v
	return s
}

type DeleteVocabularyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyOutput) GoString() string {
	return s.String()
}

type DescribeLanguageModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom language model you want described. Model names are
	// case-sensitive.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLanguageModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLanguageModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLanguageModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLanguageModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DescribeLanguageModelInput) SetModelName(v string) *DescribeLanguageModelInput {
	s.ModelName = &v
	return s
}

type DescribeLanguageModelOutput struct {
	_ struct{} `type:"structure"`

	// The name of the custom language model you requested more information about.
	LanguageModel *LanguageModel `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLanguageModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLanguageModelOutput) GoString() string {
	return s.String()
}

// SetLanguageModel sets the LanguageModel field's value.
func (s *DescribeLanguageModelOutput) SetLanguageModel(v *LanguageModel) *DescribeLanguageModelOutput {
	s.LanguageModel = v
	return s
}

type GetCallAnalyticsCategoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the category you want information about. Category names are case
	// sensitive.
	//
	// CategoryName is a required field
	CategoryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsCategoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsCategoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCallAnalyticsCategoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCallAnalyticsCategoryInput"}
	if s.CategoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("CategoryName"))
	}
	if s.CategoryName != nil && len(*s.CategoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CategoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryName sets the CategoryName field's value.
func (s *GetCallAnalyticsCategoryInput) SetCategoryName(v string) *GetCallAnalyticsCategoryInput {
	s.CategoryName = &v
	return s
}

type GetCallAnalyticsCategoryOutput struct {
	_ struct{} `type:"structure"`

	// Provides you with the rules associated with the category you specified in
	// your GetCallAnalyticsCategory request.
	CategoryProperties *CategoryProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsCategoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsCategoryOutput) GoString() string {
	return s.String()
}

// SetCategoryProperties sets the CategoryProperties field's value.
func (s *GetCallAnalyticsCategoryOutput) SetCategoryProperties(v *CategoryProperties) *GetCallAnalyticsCategoryOutput {
	s.CategoryProperties = v
	return s
}

type GetCallAnalyticsJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the analytics job you want information about. This value is case
	// sensitive.
	//
	// CallAnalyticsJobName is a required field
	CallAnalyticsJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCallAnalyticsJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCallAnalyticsJobInput"}
	if s.CallAnalyticsJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("CallAnalyticsJobName"))
	}
	if s.CallAnalyticsJobName != nil && len(*s.CallAnalyticsJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallAnalyticsJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAnalyticsJobName sets the CallAnalyticsJobName field's value.
func (s *GetCallAnalyticsJobInput) SetCallAnalyticsJobName(v string) *GetCallAnalyticsJobInput {
	s.CallAnalyticsJobName = &v
	return s
}

type GetCallAnalyticsJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains detailed information about your call analytics job.
	// Returned fields include: CallAnalyticsJobName, CallAnalyticsJobStatus, ChannelDefinitions,
	// CompletionTime, CreationTime, DataAccessRoleArn, FailureReason, IdentifiedLanguageScore,
	// LanguageCode, Media, MediaFormat, MediaSampleRateHertz, Settings, StartTime,
	// and Transcript.
	CallAnalyticsJob *CallAnalyticsJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsJobOutput) GoString() string {
	return s.String()
}

// SetCallAnalyticsJob sets the CallAnalyticsJob field's value.
func (s *GetCallAnalyticsJobOutput) SetCallAnalyticsJob(v *CallAnalyticsJob) *GetCallAnalyticsJobOutput {
	s.CallAnalyticsJob = v
	return s
}

type GetMedicalTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the medical transcription job you want information about. This
	// value is case sensitive.
	//
	// MedicalTranscriptionJobName is a required field
	MedicalTranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMedicalTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMedicalTranscriptionJobInput"}
	if s.MedicalTranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("MedicalTranscriptionJobName"))
	}
	if s.MedicalTranscriptionJobName != nil && len(*s.MedicalTranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MedicalTranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *GetMedicalTranscriptionJobInput) SetMedicalTranscriptionJobName(v string) *GetMedicalTranscriptionJobInput {
	s.MedicalTranscriptionJobName = &v
	return s
}

type GetMedicalTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains detailed information about your medical transcription
	// job. Returned fields include: CompletionTime, ContentIdentificationType,
	// CreationTime, FailureReason, LanguageCode, Media, MediaFormat, MediaSampleRateHertz,
	// MedicalTranscriptionJobName, Settings, Specialty, StartTime, Tags, Transcript,
	// TranscriptionJobStatus, and Type.
	MedicalTranscriptionJob *MedicalTranscriptionJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetMedicalTranscriptionJob sets the MedicalTranscriptionJob field's value.
func (s *GetMedicalTranscriptionJobOutput) SetMedicalTranscriptionJob(v *MedicalTranscriptionJob) *GetMedicalTranscriptionJobOutput {
	s.MedicalTranscriptionJob = v
	return s
}

type GetMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the medical vocabulary you want information about. This value
	// is case sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMedicalVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMedicalVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetMedicalVocabularyInput) SetVocabularyName(v string) *GetMedicalVocabularyInput {
	s.VocabularyName = &v
	return s
}

type GetMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The S3 location where the vocabulary is stored; use this URI to view or download
	// the vocabulary.
	DownloadUri *string `min:"1" type:"string"`

	// If your request returns a VocabularyState that is FAILED, the FailureReason
	// field contains information about why the request failed.
	//
	// For more information, refer to the Common Errors (https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html)
	// section.
	FailureReason *string `type:"string"`

	// The valid language code for your vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was last modified with a text file
	// different from the one that was previously used.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary returned by Amazon Transcribe Medical.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary. If the VocabularyState is READY then
	// you can use it in the StartMedicalTranscriptionJob operation.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalVocabularyOutput) GoString() string {
	return s.String()
}

// SetDownloadUri sets the DownloadUri field's value.
func (s *GetMedicalVocabularyOutput) SetDownloadUri(v string) *GetMedicalVocabularyOutput {
	s.DownloadUri = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetMedicalVocabularyOutput) SetFailureReason(v string) *GetMedicalVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *GetMedicalVocabularyOutput) SetLanguageCode(v string) *GetMedicalVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetMedicalVocabularyOutput) SetLastModifiedTime(v time.Time) *GetMedicalVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetMedicalVocabularyOutput) SetVocabularyName(v string) *GetMedicalVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *GetMedicalVocabularyOutput) SetVocabularyState(v string) *GetMedicalVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type GetTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the job.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTranscriptionJobInput"}
	if s.TranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *GetTranscriptionJobInput) SetTranscriptionJobName(v string) *GetTranscriptionJobInput {
	s.TranscriptionJobName = &v
	return s
}

type GetTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the results of the transcription job.
	TranscriptionJob *TranscriptionJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetTranscriptionJob sets the TranscriptionJob field's value.
func (s *GetTranscriptionJobOutput) SetTranscriptionJob(v *TranscriptionJob) *GetTranscriptionJobOutput {
	s.TranscriptionJob = v
	return s
}

type GetVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary filter for which to return information.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVocabularyFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVocabularyFilterInput"}
	if s.VocabularyFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *GetVocabularyFilterInput) SetVocabularyFilterName(v string) *GetVocabularyFilterInput {
	s.VocabularyFilterName = &v
	return s
}

type GetVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`

	// The URI of the list of words in the vocabulary filter. You can use this URI
	// to get the list of words.
	DownloadUri *string `min:"1" type:"string"`

	// The language code of the words in the vocabulary filter.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the contents of the vocabulary filter were updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary filter.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyFilterOutput) GoString() string {
	return s.String()
}

// SetDownloadUri sets the DownloadUri field's value.
func (s *GetVocabularyFilterOutput) SetDownloadUri(v string) *GetVocabularyFilterOutput {
	s.DownloadUri = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *GetVocabularyFilterOutput) SetLanguageCode(v string) *GetVocabularyFilterOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetVocabularyFilterOutput) SetLastModifiedTime(v time.Time) *GetVocabularyFilterOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *GetVocabularyFilterOutput) SetVocabularyFilterName(v string) *GetVocabularyFilterOutput {
	s.VocabularyFilterName = &v
	return s
}

type GetVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary to return information about. The name is case
	// sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetVocabularyInput) SetVocabularyName(v string) *GetVocabularyInput {
	s.VocabularyName = &v
	return s
}

type GetVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The S3 location where the vocabulary is stored. Use this URI to get the contents
	// of the vocabulary. The URI is available for a limited time.
	DownloadUri *string `min:"1" type:"string"`

	// If the VocabularyState field is FAILED, this field contains information about
	// why the job failed.
	FailureReason *string `type:"string"`

	// The language code of the vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary to return.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyOutput) GoString() string {
	return s.String()
}

// SetDownloadUri sets the DownloadUri field's value.
func (s *GetVocabularyOutput) SetDownloadUri(v string) *GetVocabularyOutput {
	s.DownloadUri = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetVocabularyOutput) SetFailureReason(v string) *GetVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *GetVocabularyOutput) SetLanguageCode(v string) *GetVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetVocabularyOutput) SetLastModifiedTime(v time.Time) *GetVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetVocabularyOutput) SetVocabularyName(v string) *GetVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *GetVocabularyOutput) SetVocabularyState(v string) *GetVocabularyOutput {
	s.VocabularyState = &v
	return s
}

// The object that contains the Amazon S3 object location and access role required
// to train and tune your custom language model.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that uniquely identifies the permissions you've
	// given Amazon Transcribe to access your Amazon S3 buckets containing your
	// media files or text data. ARNs have the format arn:partition:service:region:account-id:resource-type/resource-id.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon S3 prefix you specify to access the plain text files that you
	// use to train your custom language model.
	//
	// S3Uri is a required field
	S3Uri *string `min:"1" type:"string" required:"true"`

	// The Amazon S3 prefix you specify to access the plain text files that you
	// use to tune your custom language model.
	TuningDataS3Uri *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.S3Uri != nil && len(*s.S3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Uri", 1))
	}
	if s.TuningDataS3Uri != nil && len(*s.TuningDataS3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TuningDataS3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *InputDataConfig) SetDataAccessRoleArn(v string) *InputDataConfig {
	s.DataAccessRoleArn = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *InputDataConfig) SetS3Uri(v string) *InputDataConfig {
	s.S3Uri = &v
	return s
}

// SetTuningDataS3Uri sets the TuningDataS3Uri field's value.
func (s *InputDataConfig) SetTuningDataS3Uri(v string) *InputDataConfig {
	s.TuningDataS3Uri = &v
	return s
}

// There was an internal error. Check the error message and try your request
// again.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that enables you to configure your category to be applied to call
// analytics jobs where either the customer or agent was interrupted.
type InterruptionFilter struct {
	_ struct{} `type:"structure"`

	// An object you can use to specify a time range (in milliseconds) for when
	// you'd want to find the interruption. For example, you could search for an
	// interruption between the 30,000 millisecond mark and the 45,000 millisecond
	// mark. You could also specify the time period as the first 15,000 milliseconds
	// or the last 15,000 milliseconds.
	AbsoluteTimeRange *AbsoluteTimeRange `type:"structure"`

	// Set to TRUE to look for a time period where there was no interruption.
	Negate *bool `type:"boolean"`

	// Indicates whether the caller or customer was interrupting.
	ParticipantRole *string `type:"string" enum:"ParticipantRole"`

	// An object that allows percentages to specify the proportion of the call where
	// there was a interruption. For example, you can specify the first half of
	// the call. You can also specify the period of time between halfway through
	// to three-quarters of the way through the call. Because the length of conversation
	// can vary between calls, you can apply relative time ranges across all calls.
	RelativeTimeRange *RelativeTimeRange `type:"structure"`

	// The duration of the interruption.
	Threshold *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InterruptionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InterruptionFilter) GoString() string {
	return s.String()
}

// SetAbsoluteTimeRange sets the AbsoluteTimeRange field's value.
func (s *InterruptionFilter) SetAbsoluteTimeRange(v *AbsoluteTimeRange) *InterruptionFilter {
	s.AbsoluteTimeRange = v
	return s
}

// SetNegate sets the Negate field's value.
func (s *InterruptionFilter) SetNegate(v bool) *InterruptionFilter {
	s.Negate = &v
	return s
}

// SetParticipantRole sets the ParticipantRole field's value.
func (s *InterruptionFilter) SetParticipantRole(v string) *InterruptionFilter {
	s.ParticipantRole = &v
	return s
}

// SetRelativeTimeRange sets the RelativeTimeRange field's value.
func (s *InterruptionFilter) SetRelativeTimeRange(v *RelativeTimeRange) *InterruptionFilter {
	s.RelativeTimeRange = v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *InterruptionFilter) SetThreshold(v int64) *InterruptionFilter {
	s.Threshold = &v
	return s
}

// Provides information about when a transcription job should be executed.
type JobExecutionSettings struct {
	_ struct{} `type:"structure"`

	// Indicates whether a job should be queued by Amazon Transcribe when the concurrent
	// execution limit is exceeded. When the AllowDeferredExecution field is true,
	// jobs are queued and executed when the number of executing jobs falls below
	// the concurrent execution limit. If the field is false, Amazon Transcribe
	// returns a LimitExceededException exception.
	//
	// Note that job queuing is enabled by default for call analytics jobs.
	//
	// If you specify the AllowDeferredExecution field, you must specify the DataAccessRoleArn
	// field.
	AllowDeferredExecution *bool `type:"boolean"`

	// The Amazon Resource Name (ARN), in the form arn:partition:service:region:account-id:resource-type/resource-id,
	// of a role that has access to the S3 bucket that contains the input files.
	// Amazon Transcribe assumes this role to read queued media files. If you have
	// specified an output S3 bucket for the transcription results, this role should
	// have access to the output bucket as well.
	//
	// If you specify the AllowDeferredExecution field, you must specify the DataAccessRoleArn
	// field.
	DataAccessRoleArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobExecutionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobExecutionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobExecutionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobExecutionSettings"}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowDeferredExecution sets the AllowDeferredExecution field's value.
func (s *JobExecutionSettings) SetAllowDeferredExecution(v bool) *JobExecutionSettings {
	s.AllowDeferredExecution = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *JobExecutionSettings) SetDataAccessRoleArn(v string) *JobExecutionSettings {
	s.DataAccessRoleArn = &v
	return s
}

// Language-specific settings that can be specified when language identification
// is enabled.
type LanguageIdSettings struct {
	_ struct{} `type:"structure"`

	// The name of the language model you want to use when transcribing your audio.
	// The model you specify must have the same language codes as the transcription
	// job; if the languages don't match, the language model isn't be applied.
	LanguageModelName *string `min:"1" type:"string"`

	// The name of the vocabulary filter you want to use when transcribing your
	// audio. The filter you specify must have the same language codes as the transcription
	// job; if the languages don't match, the vocabulary filter isn't be applied.
	VocabularyFilterName *string `min:"1" type:"string"`

	// The name of the vocabulary you want to use when processing your transcription
	// job. The vocabulary you specify must have the same language codes as the
	// transcription job; if the languages don't match, the vocabulary isn't applied.
	VocabularyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LanguageIdSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LanguageIdSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LanguageIdSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LanguageIdSettings"}
	if s.LanguageModelName != nil && len(*s.LanguageModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageModelName", 1))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *LanguageIdSettings) SetLanguageModelName(v string) *LanguageIdSettings {
	s.LanguageModelName = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *LanguageIdSettings) SetVocabularyFilterName(v string) *LanguageIdSettings {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *LanguageIdSettings) SetVocabularyName(v string) *LanguageIdSettings {
	s.VocabularyName = &v
	return s
}

// The structure used to describe a custom language model.
type LanguageModel struct {
	_ struct{} `type:"structure"`

	// The Amazon Transcribe standard language model, or base model used to create
	// the custom language model.
	BaseModelName *string `type:"string" enum:"BaseModelName"`

	// The time the custom language model was created.
	CreateTime *time.Time `type:"timestamp"`

	// The reason why the custom language model couldn't be created.
	FailureReason *string `type:"string"`

	// The data access role and Amazon S3 prefixes for the input files used to train
	// the custom language model.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The language code you used to create your custom language model.
	LanguageCode *string `type:"string" enum:"CLMLanguageCode"`

	// The most recent time the custom language model was modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the custom language model.
	ModelName *string `min:"1" type:"string"`

	// The creation status of a custom language model. When the status is COMPLETED
	// the model is ready for use.
	ModelStatus *string `type:"string" enum:"ModelStatus"`

	// Whether the base model used for the custom language model is up to date.
	// If this field is false then you are running the most up-to-date version of
	// the base model in your custom language model.
	UpgradeAvailability *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LanguageModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LanguageModel) GoString() string {
	return s.String()
}

// SetBaseModelName sets the BaseModelName field's value.
func (s *LanguageModel) SetBaseModelName(v string) *LanguageModel {
	s.BaseModelName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *LanguageModel) SetCreateTime(v time.Time) *LanguageModel {
	s.CreateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *LanguageModel) SetFailureReason(v string) *LanguageModel {
	s.FailureReason = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *LanguageModel) SetInputDataConfig(v *InputDataConfig) *LanguageModel {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *LanguageModel) SetLanguageCode(v string) *LanguageModel {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *LanguageModel) SetLastModifiedTime(v time.Time) *LanguageModel {
	s.LastModifiedTime = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *LanguageModel) SetModelName(v string) *LanguageModel {
	s.ModelName = &v
	return s
}

// SetModelStatus sets the ModelStatus field's value.
func (s *LanguageModel) SetModelStatus(v string) *LanguageModel {
	s.ModelStatus = &v
	return s
}

// SetUpgradeAvailability sets the UpgradeAvailability field's value.
func (s *LanguageModel) SetUpgradeAvailability(v bool) *LanguageModel {
	s.UpgradeAvailability = &v
	return s
}

// Either you have sent too many requests or your input file is too long. Wait
// before you resend your request, or use a smaller file and resend the request.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCallAnalyticsCategoriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of categories to return in each page of results. If there
	// are fewer results than the value you specify, only the actual results are
	// returned. If you do not specify a value, the default of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// When included, NextTokenfetches the next set of categories if the result
	// of the previous request was truncated.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsCategoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCallAnalyticsCategoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCallAnalyticsCategoriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCallAnalyticsCategoriesInput) SetMaxResults(v int64) *ListCallAnalyticsCategoriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCallAnalyticsCategoriesInput) SetNextToken(v string) *ListCallAnalyticsCategoriesInput {
	s.NextToken = &v
	return s
}

type ListCallAnalyticsCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing information about analytics categories.
	Categories []*CategoryProperties `type:"list"`

	// The operation returns a page of jobs at a time. The maximum size of the list
	// is set by the MaxResults parameter. If there are more categories in the list
	// than the page size, Amazon Transcribe returns the NextPage token. Include
	// the token in the next request to the operation to return the next page of
	// analytics categories.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsCategoriesOutput) GoString() string {
	return s.String()
}

// SetCategories sets the Categories field's value.
func (s *ListCallAnalyticsCategoriesOutput) SetCategories(v []*CategoryProperties) *ListCallAnalyticsCategoriesOutput {
	s.Categories = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCallAnalyticsCategoriesOutput) SetNextToken(v string) *ListCallAnalyticsCategoriesOutput {
	s.NextToken = &v
	return s
}

type ListCallAnalyticsJobsInput struct {
	_ struct{} `type:"structure"`

	// When specified, the jobs returned in the list are limited to jobs whose name
	// contains the specified string.
	JobNameContains *string `min:"1" type:"string"`

	// The maximum number of call analytics jobs to return in each page of results.
	// If there are fewer results than the value you specify, only the actual results
	// are returned. If you do not specify a value, the default of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you receive a truncated result in the previous request of , include NextToken
	// to fetch the next set of jobs.
	NextToken *string `type:"string"`

	// When specified, returns only call analytics jobs with the specified status.
	// Jobs are ordered by creation date, with the most recent jobs returned first.
	// If you don't specify a status, Amazon Transcribe returns all analytics jobs
	// ordered by creation date.
	Status *string `type:"string" enum:"CallAnalyticsJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCallAnalyticsJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCallAnalyticsJobsInput"}
	if s.JobNameContains != nil && len(*s.JobNameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobNameContains", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobNameContains sets the JobNameContains field's value.
func (s *ListCallAnalyticsJobsInput) SetJobNameContains(v string) *ListCallAnalyticsJobsInput {
	s.JobNameContains = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCallAnalyticsJobsInput) SetMaxResults(v int64) *ListCallAnalyticsJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCallAnalyticsJobsInput) SetNextToken(v string) *ListCallAnalyticsJobsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListCallAnalyticsJobsInput) SetStatus(v string) *ListCallAnalyticsJobsInput {
	s.Status = &v
	return s
}

type ListCallAnalyticsJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing summary information for a transcription job.
	CallAnalyticsJobSummaries []*CallAnalyticsJobSummary `type:"list"`

	// The operation returns a page of jobs at a time. The maximum size of the page
	// is set by the MaxResults parameter. If there are more jobs in the list than
	// the page size, Amazon Transcribe returns the NextPage token. Include the
	// token in your next request to the operation to return next page of jobs.
	NextToken *string `type:"string"`

	// When specified, returns only call analytics jobs with that status. Jobs are
	// ordered by creation date, with the most recent jobs returned first. If you
	// don't specify a status, Amazon Transcribe returns all transcription jobs
	// ordered by creation date.
	Status *string `type:"string" enum:"CallAnalyticsJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsJobsOutput) GoString() string {
	return s.String()
}

// SetCallAnalyticsJobSummaries sets the CallAnalyticsJobSummaries field's value.
func (s *ListCallAnalyticsJobsOutput) SetCallAnalyticsJobSummaries(v []*CallAnalyticsJobSummary) *ListCallAnalyticsJobsOutput {
	s.CallAnalyticsJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCallAnalyticsJobsOutput) SetNextToken(v string) *ListCallAnalyticsJobsOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListCallAnalyticsJobsOutput) SetStatus(v string) *ListCallAnalyticsJobsOutput {
	s.Status = &v
	return s
}

type ListLanguageModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of language models to return in each page of results.
	// If there are fewer results than the value you specify, only the actual results
	// are returned. If you do not specify a value, the default of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// When specified, the custom language model names returned contain the substring
	// you've specified.
	NameContains *string `min:"1" type:"string"`

	// When included, fetches the next set of jobs if the result of the previous
	// request was truncated.
	NextToken *string `type:"string"`

	// When specified, returns only custom language models with the specified status.
	// Language models are ordered by creation date, with the newest models first.
	// If you don't specify a status, Amazon Transcribe returns all custom language
	// models ordered by date.
	StatusEquals *string `type:"string" enum:"ModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLanguageModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLanguageModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLanguageModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLanguageModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLanguageModelsInput) SetMaxResults(v int64) *ListLanguageModelsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListLanguageModelsInput) SetNameContains(v string) *ListLanguageModelsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLanguageModelsInput) SetNextToken(v string) *ListLanguageModelsInput {
	s.NextToken = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListLanguageModelsInput) SetStatusEquals(v string) *ListLanguageModelsInput {
	s.StatusEquals = &v
	return s
}

type ListLanguageModelsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing information about custom language models.
	Models []*LanguageModel `type:"list"`

	// The operation returns a page of jobs at a time. The maximum size of the list
	// is set by the MaxResults parameter. If there are more language models in
	// the list than the page size, Amazon Transcribe returns the NextPage token.
	// Include the token in the next request to the operation to return the next
	// page of language models.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLanguageModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLanguageModelsOutput) GoString() string {
	return s.String()
}

// SetModels sets the Models field's value.
func (s *ListLanguageModelsOutput) SetModels(v []*LanguageModel) *ListLanguageModelsOutput {
	s.Models = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLanguageModelsOutput) SetNextToken(v string) *ListLanguageModelsOutput {
	s.NextToken = &v
	return s
}

type ListMedicalTranscriptionJobsInput struct {
	_ struct{} `type:"structure"`

	// When specified, the jobs returned in the list are limited to jobs whose name
	// contains the specified string.
	JobNameContains *string `min:"1" type:"string"`

	// The maximum number of medical transcription jobs to return in each page of
	// results. If there are fewer results than the value you specify, only the
	// actual results are returned. If you do not specify a value, the default of
	// 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you a receive a truncated result in the previous request of ListMedicalTranscriptionJobs,
	// include NextToken to fetch the next set of jobs.
	NextToken *string `type:"string"`

	// When specified, returns only medical transcription jobs with the specified
	// status. Jobs are ordered by creation date, with the newest jobs returned
	// first. If you don't specify a status, Amazon Transcribe Medical returns all
	// transcription jobs ordered by creation date.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalTranscriptionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalTranscriptionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMedicalTranscriptionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMedicalTranscriptionJobsInput"}
	if s.JobNameContains != nil && len(*s.JobNameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobNameContains", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobNameContains sets the JobNameContains field's value.
func (s *ListMedicalTranscriptionJobsInput) SetJobNameContains(v string) *ListMedicalTranscriptionJobsInput {
	s.JobNameContains = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMedicalTranscriptionJobsInput) SetMaxResults(v int64) *ListMedicalTranscriptionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMedicalTranscriptionJobsInput) SetNextToken(v string) *ListMedicalTranscriptionJobsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListMedicalTranscriptionJobsInput) SetStatus(v string) *ListMedicalTranscriptionJobsInput {
	s.Status = &v
	return s
}

type ListMedicalTranscriptionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing summary information for a transcription job.
	MedicalTranscriptionJobSummaries []*MedicalTranscriptionJobSummary `type:"list"`

	// The ListMedicalTranscriptionJobs operation returns a page of jobs at a time.
	// The maximum size of the page is set by the MaxResults parameter. If the number
	// of jobs exceeds what can fit on a page, Amazon Transcribe Medical returns
	// the NextPage token. Include the token in the next request to the ListMedicalTranscriptionJobs
	// operation to return in the next page of jobs.
	NextToken *string `type:"string"`

	// The requested status of the medical transcription jobs returned.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalTranscriptionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalTranscriptionJobsOutput) GoString() string {
	return s.String()
}

// SetMedicalTranscriptionJobSummaries sets the MedicalTranscriptionJobSummaries field's value.
func (s *ListMedicalTranscriptionJobsOutput) SetMedicalTranscriptionJobSummaries(v []*MedicalTranscriptionJobSummary) *ListMedicalTranscriptionJobsOutput {
	s.MedicalTranscriptionJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMedicalTranscriptionJobsOutput) SetNextToken(v string) *ListMedicalTranscriptionJobsOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListMedicalTranscriptionJobsOutput) SetStatus(v string) *ListMedicalTranscriptionJobsOutput {
	s.Status = &v
	return s
}

type ListMedicalVocabulariesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of vocabularies to return in each page of results. If
	// there are fewer results than the value you specify, only the actual results
	// are returned. If you do not specify a value, the default of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// Returns vocabularies whose names contain the specified string. The search
	// is not case sensitive. ListMedicalVocabularies returns both "vocabularyname"
	// and "VocabularyName".
	NameContains *string `min:"1" type:"string"`

	// If the result of your previous request to ListMedicalVocabularies was truncated,
	// include the NextToken to fetch the next set of vocabularies.
	NextToken *string `type:"string"`

	// When specified, returns only vocabularies with the VocabularyState equal
	// to the specified vocabulary state. Use this field to see which vocabularies
	// are ready for your medical transcription jobs.
	StateEquals *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalVocabulariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalVocabulariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMedicalVocabulariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMedicalVocabulariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMedicalVocabulariesInput) SetMaxResults(v int64) *ListMedicalVocabulariesInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListMedicalVocabulariesInput) SetNameContains(v string) *ListMedicalVocabulariesInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMedicalVocabulariesInput) SetNextToken(v string) *ListMedicalVocabulariesInput {
	s.NextToken = &v
	return s
}

// SetStateEquals sets the StateEquals field's value.
func (s *ListMedicalVocabulariesInput) SetStateEquals(v string) *ListMedicalVocabulariesInput {
	s.StateEquals = &v
	return s
}

type ListMedicalVocabulariesOutput struct {
	_ struct{} `type:"structure"`

	// The ListMedicalVocabularies operation returns a page of vocabularies at a
	// time. You set the maximum number of vocabularies to return on a page with
	// the MaxResults parameter. If there are more jobs in the list will fit on
	// a page, Amazon Transcribe Medical returns the NextPage token. To return the
	// next page of vocabularies, include the token in the next request to the ListMedicalVocabularies
	// operation.
	NextToken *string `type:"string"`

	// The requested vocabulary state.
	Status *string `type:"string" enum:"VocabularyState"`

	// A list of objects that describe the vocabularies that match your search criteria.
	Vocabularies []*VocabularyInfo `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalVocabulariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalVocabulariesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListMedicalVocabulariesOutput) SetNextToken(v string) *ListMedicalVocabulariesOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListMedicalVocabulariesOutput) SetStatus(v string) *ListMedicalVocabulariesOutput {
	s.Status = &v
	return s
}

// SetVocabularies sets the Vocabularies field's value.
func (s *ListMedicalVocabulariesOutput) SetVocabularies(v []*VocabularyInfo) *ListMedicalVocabulariesOutput {
	s.Vocabularies = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Lists all tags associated with a given Amazon Resource Name (ARN). ARNs have
	// the format arn:partition:service:region:account-id:resource-type/resource-id
	// (for example, arn:aws:transcribe:us-east-1:account-id:transcription-job/your-job-name).
	// Valid values for resource-type are: transcription-job, medical-transcription-job,
	// vocabulary, medical-vocabulary, vocabulary-filter, and language-model.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Lists all tags associated with the given Amazon Resource Name (ARN).
	ResourceArn *string `min:"1" type:"string"`

	// Lists all tags associated with the given transcription job, vocabulary, or
	// resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceOutput) SetResourceArn(v string) *ListTagsForResourceOutput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTranscriptionJobsInput struct {
	_ struct{} `type:"structure"`

	// When specified, the jobs returned in the list are limited to jobs whose name
	// contains the specified string.
	JobNameContains *string `min:"1" type:"string"`

	// The maximum number of jobs to return in each page of results. If there are
	// fewer results than the value you specify, only the actual results are returned.
	// If you do not specify a value, the default of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request to ListTranscriptionJobs is truncated,
	// include the NextToken to fetch the next set of jobs.
	NextToken *string `type:"string"`

	// When specified, returns only transcription jobs with the specified status.
	// Jobs are ordered by creation date, with the newest jobs returned first. If
	// you don’t specify a status, Amazon Transcribe returns all transcription
	// jobs ordered by creation date.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTranscriptionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTranscriptionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTranscriptionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTranscriptionJobsInput"}
	if s.JobNameContains != nil && len(*s.JobNameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobNameContains", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobNameContains sets the JobNameContains field's value.
func (s *ListTranscriptionJobsInput) SetJobNameContains(v string) *ListTranscriptionJobsInput {
	s.JobNameContains = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTranscriptionJobsInput) SetMaxResults(v int64) *ListTranscriptionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTranscriptionJobsInput) SetNextToken(v string) *ListTranscriptionJobsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTranscriptionJobsInput) SetStatus(v string) *ListTranscriptionJobsInput {
	s.Status = &v
	return s
}

type ListTranscriptionJobsOutput struct {
	_ struct{} `type:"structure"`

	// The ListTranscriptionJobs operation returns a page of jobs at a time. The
	// maximum size of the page is set by the MaxResults parameter. If there are
	// more jobs in the list than the page size, Amazon Transcribe returns the NextPage
	// token. Include the token in the next request to the ListTranscriptionJobs
	// operation to return in the next page of jobs.
	NextToken *string `type:"string"`

	// The requested status of the jobs returned.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`

	// A list of objects containing summary information for a transcription job.
	TranscriptionJobSummaries []*TranscriptionJobSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTranscriptionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTranscriptionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTranscriptionJobsOutput) SetNextToken(v string) *ListTranscriptionJobsOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTranscriptionJobsOutput) SetStatus(v string) *ListTranscriptionJobsOutput {
	s.Status = &v
	return s
}

// SetTranscriptionJobSummaries sets the TranscriptionJobSummaries field's value.
func (s *ListTranscriptionJobsOutput) SetTranscriptionJobSummaries(v []*TranscriptionJobSummary) *ListTranscriptionJobsOutput {
	s.TranscriptionJobSummaries = v
	return s
}

type ListVocabulariesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of vocabularies to return in each page of results. If
	// there are fewer results than the value you specify, only the actual results
	// are returned. If you do not specify a value, the default of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// When specified, the vocabularies returned in the list are limited to vocabularies
	// whose name contains the specified string. The search is not case sensitive,
	// ListVocabularies returns both "vocabularyname" and "VocabularyName" in the
	// response list.
	NameContains *string `min:"1" type:"string"`

	// If the result of the previous request to ListVocabularies was truncated,
	// include the NextToken to fetch the next set of jobs.
	NextToken *string `type:"string"`

	// When specified, only returns vocabularies with the VocabularyState field
	// equal to the specified state.
	StateEquals *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabulariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabulariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVocabulariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVocabulariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVocabulariesInput) SetMaxResults(v int64) *ListVocabulariesInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListVocabulariesInput) SetNameContains(v string) *ListVocabulariesInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabulariesInput) SetNextToken(v string) *ListVocabulariesInput {
	s.NextToken = &v
	return s
}

// SetStateEquals sets the StateEquals field's value.
func (s *ListVocabulariesInput) SetStateEquals(v string) *ListVocabulariesInput {
	s.StateEquals = &v
	return s
}

type ListVocabulariesOutput struct {
	_ struct{} `type:"structure"`

	// The ListVocabularies operation returns a page of vocabularies at a time.
	// The maximum size of the page is set in the MaxResults parameter. If there
	// are more jobs in the list than will fit on the page, Amazon Transcribe returns
	// the NextPage token. To return in the next page of jobs, include the token
	// in the next request to the ListVocabularies operation.
	NextToken *string `type:"string"`

	// The requested vocabulary state.
	Status *string `type:"string" enum:"VocabularyState"`

	// A list of objects that describe the vocabularies that match the search criteria
	// in the request.
	Vocabularies []*VocabularyInfo `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabulariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabulariesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabulariesOutput) SetNextToken(v string) *ListVocabulariesOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListVocabulariesOutput) SetStatus(v string) *ListVocabulariesOutput {
	s.Status = &v
	return s
}

// SetVocabularies sets the Vocabularies field's value.
func (s *ListVocabulariesOutput) SetVocabularies(v []*VocabularyInfo) *ListVocabulariesOutput {
	s.Vocabularies = v
	return s
}

type ListVocabularyFiltersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of filters to return in each page of results. If there
	// are fewer results than the value you specify, only the actual results are
	// returned. If you do not specify a value, the default of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// Filters the response so that it only contains vocabulary filters whose name
	// contains the specified string.
	NameContains *string `min:"1" type:"string"`

	// If the result of the previous request to ListVocabularyFilters was truncated,
	// include the NextToken to fetch the next set of collections.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabularyFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabularyFiltersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVocabularyFiltersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVocabularyFiltersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVocabularyFiltersInput) SetMaxResults(v int64) *ListVocabularyFiltersInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListVocabularyFiltersInput) SetNameContains(v string) *ListVocabularyFiltersInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabularyFiltersInput) SetNextToken(v string) *ListVocabularyFiltersInput {
	s.NextToken = &v
	return s
}

type ListVocabularyFiltersOutput struct {
	_ struct{} `type:"structure"`

	// The ListVocabularyFilters operation returns a page of collections at a time.
	// The maximum size of the page is set by the MaxResults parameter. If there
	// are more jobs in the list than the page size, Amazon Transcribe returns the
	// NextPage token. Include the token in the next request to the ListVocabularyFilters
	// operation to return in the next page of jobs.
	NextToken *string `type:"string"`

	// The list of vocabulary filters. It contains at most MaxResults number of
	// filters. If there are more filters, call the ListVocabularyFilters operation
	// again with the NextToken parameter in the request set to the value of the
	// NextToken field in the response.
	VocabularyFilters []*VocabularyFilterInfo `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabularyFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabularyFiltersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabularyFiltersOutput) SetNextToken(v string) *ListVocabularyFiltersOutput {
	s.NextToken = &v
	return s
}

// SetVocabularyFilters sets the VocabularyFilters field's value.
func (s *ListVocabularyFiltersOutput) SetVocabularyFilters(v []*VocabularyFilterInfo) *ListVocabularyFiltersOutput {
	s.VocabularyFilters = v
	return s
}

// Describes the input media file in a transcription request.
type Media struct {
	_ struct{} `type:"structure"`

	// The S3 object location of the input media file. The URI must be in the same
	// region as the API endpoint that you are calling. The general form is:
	//
	// s3://DOC-EXAMPLE-BUCKET/keyprefix/objectkey
	//
	// For example:
	//
	// s3://DOC-EXAMPLE-BUCKET/example.flac
	//
	// s3://DOC-EXAMPLE-BUCKET/mediafiles/example.flac
	//
	// For more information about S3 object names, see Object Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide.
	MediaFileUri *string `min:"1" type:"string"`

	// The S3 object location for your redacted output media file. This is only
	// supported for call analytics jobs.
	RedactedMediaFileUri *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Media) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Media) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Media) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Media"}
	if s.MediaFileUri != nil && len(*s.MediaFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MediaFileUri", 1))
	}
	if s.RedactedMediaFileUri != nil && len(*s.RedactedMediaFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RedactedMediaFileUri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMediaFileUri sets the MediaFileUri field's value.
func (s *Media) SetMediaFileUri(v string) *Media {
	s.MediaFileUri = &v
	return s
}

// SetRedactedMediaFileUri sets the RedactedMediaFileUri field's value.
func (s *Media) SetRedactedMediaFileUri(v string) *Media {
	s.RedactedMediaFileUri = &v
	return s
}

// Identifies the location of a medical transcript.
type MedicalTranscript struct {
	_ struct{} `type:"structure"`

	// The S3 object location of the medical transcript.
	//
	// Use this URI to access the medical transcript. This URI points to the S3
	// bucket you created to store the medical transcript.
	TranscriptFileUri *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscript) GoString() string {
	return s.String()
}

// SetTranscriptFileUri sets the TranscriptFileUri field's value.
func (s *MedicalTranscript) SetTranscriptFileUri(v string) *MedicalTranscript {
	s.TranscriptFileUri = &v
	return s
}

// The data structure that contains the information for a medical transcription
// job.
type MedicalTranscriptionJob struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the job was completed.
	CompletionTime *time.Time `type:"timestamp"`

	// Shows the type of content that you've configured Amazon Transcribe Medical
	// to identify in a transcription job. If the value is PHI, you've configured
	// the job to identify personal health information (PHI) in the transcription
	// output.
	ContentIdentificationType *string `type:"string" enum:"MedicalContentIdentificationType"`

	// A timestamp that shows when the job was created.
	CreationTime *time.Time `type:"timestamp"`

	// If the TranscriptionJobStatus field is FAILED, this field contains information
	// about why the job failed.
	//
	// The FailureReason field contains one of the following values:
	//
	//    * Unsupported media format- The media format specified in the MediaFormat
	//    field of the request isn't valid. See the description of the MediaFormat
	//    field for a list of valid values.
	//
	//    * The media format provided does not match the detected media format-
	//    The media format of the audio file doesn't match the format specified
	//    in the MediaFormat field in the request. Check the media format of your
	//    media file and make sure the two values match.
	//
	//    * Invalid sample rate for audio file- The sample rate specified in the
	//    MediaSampleRateHertz of the request isn't valid. The sample rate must
	//    be between 8,000 and 48,000 Hertz.
	//
	//    * The sample rate provided does not match the detected sample rate- The
	//    sample rate in the audio file doesn't match the sample rate specified
	//    in the MediaSampleRateHertz field in the request. Check the sample rate
	//    of your media file and make sure that the two values match.
	//
	//    * Invalid file size: file size too large- The size of your audio file
	//    is larger than what Amazon Transcribe Medical can process. For more information,
	//    see Guidelines and Quotas (https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits)
	//    in the Amazon Transcribe Medical Guide.
	//
	//    * Invalid number of channels: number of channels too large- Your audio
	//    contains more channels than Amazon Transcribe Medical is configured to
	//    process. To request additional channels, see Amazon Transcribe Medical
	//    Endpoints and Quotas (https://docs.aws.amazon.com/general/latest/gr/transcribe-medical.html)
	//    in the Amazon Web Services General Reference.
	FailureReason *string `type:"string"`

	// The language code for the language spoken in the source audio file. US English
	// (en-US) is the only supported language for medical transcriptions. Any other
	// value you enter for language code results in a BadRequestException error.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Describes the input media file in a transcription request.
	Media *Media `type:"structure"`

	// The format of the input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in Hertz, of the source audio containing medical information.
	//
	// If you don't specify the sample rate, Amazon Transcribe Medical determines
	// it for you. If you choose to specify the sample rate, it must match the rate
	// detected by Amazon Transcribe Medical.
	MediaSampleRateHertz *int64 `min:"16000" type:"integer"`

	// The name for a given medical transcription job.
	MedicalTranscriptionJobName *string `min:"1" type:"string"`

	// Object that contains object.
	Settings *MedicalTranscriptionSetting `type:"structure"`

	// The medical specialty of any clinicians providing a dictation or having a
	// conversation. Refer to Transcribing a medical conversation (https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-medical-conversation.html)for
	// a list of supported specialties.
	Specialty *string `type:"string" enum:"Specialty"`

	// A timestamp that shows when the job started processing.
	StartTime *time.Time `type:"timestamp"`

	// A key:value pair assigned to a given medical transcription job.
	Tags []*Tag `min:"1" type:"list"`

	// An object that contains the MedicalTranscript. The MedicalTranscript contains
	// the TranscriptFileUri.
	Transcript *MedicalTranscript `type:"structure"`

	// The completion status of a medical transcription job.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`

	// The type of speech in the transcription job. CONVERSATION is generally used
	// for patient-physician dialogues. DICTATION is the setting for physicians
	// speaking their notes after seeing a patient. For more information, see What
	// is Amazon Transcribe Medical? (https://docs.aws.amazon.com/transcribe/latest/dg/what-is-transcribe-med.html).
	Type *string `type:"string" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptionJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptionJob) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *MedicalTranscriptionJob) SetCompletionTime(v time.Time) *MedicalTranscriptionJob {
	s.CompletionTime = &v
	return s
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *MedicalTranscriptionJob) SetContentIdentificationType(v string) *MedicalTranscriptionJob {
	s.ContentIdentificationType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *MedicalTranscriptionJob) SetCreationTime(v time.Time) *MedicalTranscriptionJob {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *MedicalTranscriptionJob) SetFailureReason(v string) *MedicalTranscriptionJob {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *MedicalTranscriptionJob) SetLanguageCode(v string) *MedicalTranscriptionJob {
	s.LanguageCode = &v
	return s
}

// SetMedia sets the Media field's value.
func (s *MedicalTranscriptionJob) SetMedia(v *Media) *MedicalTranscriptionJob {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *MedicalTranscriptionJob) SetMediaFormat(v string) *MedicalTranscriptionJob {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *MedicalTranscriptionJob) SetMediaSampleRateHertz(v int64) *MedicalTranscriptionJob {
	s.MediaSampleRateHertz = &v
	return s
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *MedicalTranscriptionJob) SetMedicalTranscriptionJobName(v string) *MedicalTranscriptionJob {
	s.MedicalTranscriptionJobName = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *MedicalTranscriptionJob) SetSettings(v *MedicalTranscriptionSetting) *MedicalTranscriptionJob {
	s.Settings = v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *MedicalTranscriptionJob) SetSpecialty(v string) *MedicalTranscriptionJob {
	s.Specialty = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MedicalTranscriptionJob) SetStartTime(v time.Time) *MedicalTranscriptionJob {
	s.StartTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *MedicalTranscriptionJob) SetTags(v []*Tag) *MedicalTranscriptionJob {
	s.Tags = v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *MedicalTranscriptionJob) SetTranscript(v *MedicalTranscript) *MedicalTranscriptionJob {
	s.Transcript = v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *MedicalTranscriptionJob) SetTranscriptionJobStatus(v string) *MedicalTranscriptionJob {
	s.TranscriptionJobStatus = &v
	return s
}

// SetType sets the Type field's value.
func (s *MedicalTranscriptionJob) SetType(v string) *MedicalTranscriptionJob {
	s.Type = &v
	return s
}

// Provides summary information about a transcription job.
type MedicalTranscriptionJobSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the job was completed.
	CompletionTime *time.Time `type:"timestamp"`

	// Shows the type of information you've configured Amazon Transcribe Medical
	// to identify in a transcription job. If the value is PHI, you've configured
	// the transcription job to identify personal health information (PHI).
	ContentIdentificationType *string `type:"string" enum:"MedicalContentIdentificationType"`

	// A timestamp that shows when the medical transcription job was created.
	CreationTime *time.Time `type:"timestamp"`

	// If the TranscriptionJobStatus field is FAILED, a description of the error.
	FailureReason *string `type:"string"`

	// The language of the transcript in the source audio file.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The name of a medical transcription job.
	MedicalTranscriptionJobName *string `min:"1" type:"string"`

	// Indicates the location of the transcription job's output. This field must
	// be the path of an S3 bucket; if you don't already have an S3 bucket, one
	// is created based on the path you add.
	OutputLocationType *string `type:"string" enum:"OutputLocationType"`

	// The medical specialty of the transcription job. Refer to Transcribing a medical
	// conversation (https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-medical-conversation.html)for
	// a list of supported specialties.
	Specialty *string `type:"string" enum:"Specialty"`

	// A timestamp that shows when the job began processing.
	StartTime *time.Time `type:"timestamp"`

	// The status of the medical transcription job.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`

	// The speech of the clinician in the input audio.
	Type *string `type:"string" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptionJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptionJobSummary) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *MedicalTranscriptionJobSummary) SetCompletionTime(v time.Time) *MedicalTranscriptionJobSummary {
	s.CompletionTime = &v
	return s
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *MedicalTranscriptionJobSummary) SetContentIdentificationType(v string) *MedicalTranscriptionJobSummary {
	s.ContentIdentificationType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *MedicalTranscriptionJobSummary) SetCreationTime(v time.Time) *MedicalTranscriptionJobSummary {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *MedicalTranscriptionJobSummary) SetFailureReason(v string) *MedicalTranscriptionJobSummary {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *MedicalTranscriptionJobSummary) SetLanguageCode(v string) *MedicalTranscriptionJobSummary {
	s.LanguageCode = &v
	return s
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *MedicalTranscriptionJobSummary) SetMedicalTranscriptionJobName(v string) *MedicalTranscriptionJobSummary {
	s.MedicalTranscriptionJobName = &v
	return s
}

// SetOutputLocationType sets the OutputLocationType field's value.
func (s *MedicalTranscriptionJobSummary) SetOutputLocationType(v string) *MedicalTranscriptionJobSummary {
	s.OutputLocationType = &v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *MedicalTranscriptionJobSummary) SetSpecialty(v string) *MedicalTranscriptionJobSummary {
	s.Specialty = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MedicalTranscriptionJobSummary) SetStartTime(v time.Time) *MedicalTranscriptionJobSummary {
	s.StartTime = &v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *MedicalTranscriptionJobSummary) SetTranscriptionJobStatus(v string) *MedicalTranscriptionJobSummary {
	s.TranscriptionJobStatus = &v
	return s
}

// SetType sets the Type field's value.
func (s *MedicalTranscriptionJobSummary) SetType(v string) *MedicalTranscriptionJobSummary {
	s.Type = &v
	return s
}

// Optional settings for the StartMedicalTranscriptionJob operation.
type MedicalTranscriptionSetting struct {
	_ struct{} `type:"structure"`

	// Instructs Amazon Transcribe Medical to process each audio channel separately
	// and then merge the transcription output of each channel into a single transcription.
	//
	// Amazon Transcribe Medical also produces a transcription of each item detected
	// on an audio channel, including the start time and end time of the item and
	// alternative transcriptions of item. The alternative transcriptions also come
	// with confidence scores provided by Amazon Transcribe Medical.
	//
	// You can't set both ShowSpeakerLabels and ChannelIdentification in the same
	// request. If you set both, your request returns a BadRequestException.
	ChannelIdentification *bool `type:"boolean"`

	// The maximum number of alternatives that you tell the service to return. If
	// you specify the MaxAlternatives field, you must set the ShowAlternatives
	// field to true.
	MaxAlternatives *int64 `min:"2" type:"integer"`

	// The maximum number of speakers to identify in the input audio. If there are
	// more speakers in the audio than this number, multiple speakers are identified
	// as a single speaker. If you specify the MaxSpeakerLabels field, you must
	// set the ShowSpeakerLabels field to true.
	MaxSpeakerLabels *int64 `min:"2" type:"integer"`

	// Determines whether alternative transcripts are generated along with the transcript
	// that has the highest confidence. If you set ShowAlternatives field to true,
	// you must also set the maximum number of alternatives to return in the MaxAlternatives
	// field.
	ShowAlternatives *bool `type:"boolean"`

	// Determines whether the transcription job uses speaker recognition to identify
	// different speakers in the input audio. Speaker recognition labels individual
	// speakers in the audio file. If you set the ShowSpeakerLabels field to true,
	// you must also set the maximum number of speaker labels in the MaxSpeakerLabels
	// field.
	//
	// You can't set both ShowSpeakerLabels and ChannelIdentification in the same
	// request. If you set both, your request returns a BadRequestException.
	ShowSpeakerLabels *bool `type:"boolean"`

	// The name of the vocabulary to use when processing a medical transcription
	// job.
	VocabularyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptionSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MedicalTranscriptionSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MedicalTranscriptionSetting"}
	if s.MaxAlternatives != nil && *s.MaxAlternatives < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxAlternatives", 2))
	}
	if s.MaxSpeakerLabels != nil && *s.MaxSpeakerLabels < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSpeakerLabels", 2))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelIdentification sets the ChannelIdentification field's value.
func (s *MedicalTranscriptionSetting) SetChannelIdentification(v bool) *MedicalTranscriptionSetting {
	s.ChannelIdentification = &v
	return s
}

// SetMaxAlternatives sets the MaxAlternatives field's value.
func (s *MedicalTranscriptionSetting) SetMaxAlternatives(v int64) *MedicalTranscriptionSetting {
	s.MaxAlternatives = &v
	return s
}

// SetMaxSpeakerLabels sets the MaxSpeakerLabels field's value.
func (s *MedicalTranscriptionSetting) SetMaxSpeakerLabels(v int64) *MedicalTranscriptionSetting {
	s.MaxSpeakerLabels = &v
	return s
}

// SetShowAlternatives sets the ShowAlternatives field's value.
func (s *MedicalTranscriptionSetting) SetShowAlternatives(v bool) *MedicalTranscriptionSetting {
	s.ShowAlternatives = &v
	return s
}

// SetShowSpeakerLabels sets the ShowSpeakerLabels field's value.
func (s *MedicalTranscriptionSetting) SetShowSpeakerLabels(v bool) *MedicalTranscriptionSetting {
	s.ShowSpeakerLabels = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *MedicalTranscriptionSetting) SetVocabularyName(v string) *MedicalTranscriptionSetting {
	s.VocabularyName = &v
	return s
}

// The object used to call your custom language model to your transcription
// job.
type ModelSettings struct {
	_ struct{} `type:"structure"`

	// The name of your custom language model.
	LanguageModelName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelSettings"}
	if s.LanguageModelName != nil && len(*s.LanguageModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *ModelSettings) SetLanguageModelName(v string) *ModelSettings {
	s.LanguageModelName = &v
	return s
}

// An object that enables you to configure your category to be applied to call
// analytics jobs where either the customer or agent was interrupted.
type NonTalkTimeFilter struct {
	_ struct{} `type:"structure"`

	// An object you can use to specify a time range (in milliseconds) for when
	// no one is talking. For example, you could specify a time period between the
	// 30,000 millisecond mark and the 45,000 millisecond mark. You could also specify
	// the time period as the first 15,000 milliseconds or the last 15,000 milliseconds.
	AbsoluteTimeRange *AbsoluteTimeRange `type:"structure"`

	// Set to TRUE to look for a time period when people were talking.
	Negate *bool `type:"boolean"`

	// An object that allows percentages to specify the proportion of the call where
	// there was silence. For example, you can specify the first half of the call.
	// You can also specify the period of time between halfway through to three-quarters
	// of the way through the call. Because the length of conversation can vary
	// between calls, you can apply relative time ranges across all calls.
	RelativeTimeRange *RelativeTimeRange `type:"structure"`

	// The duration of the period when neither the customer nor agent was talking.
	Threshold *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NonTalkTimeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NonTalkTimeFilter) GoString() string {
	return s.String()
}

// SetAbsoluteTimeRange sets the AbsoluteTimeRange field's value.
func (s *NonTalkTimeFilter) SetAbsoluteTimeRange(v *AbsoluteTimeRange) *NonTalkTimeFilter {
	s.AbsoluteTimeRange = v
	return s
}

// SetNegate sets the Negate field's value.
func (s *NonTalkTimeFilter) SetNegate(v bool) *NonTalkTimeFilter {
	s.Negate = &v
	return s
}

// SetRelativeTimeRange sets the RelativeTimeRange field's value.
func (s *NonTalkTimeFilter) SetRelativeTimeRange(v *RelativeTimeRange) *NonTalkTimeFilter {
	s.RelativeTimeRange = v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *NonTalkTimeFilter) SetThreshold(v int64) *NonTalkTimeFilter {
	s.Threshold = &v
	return s
}

// We can't find the requested resource. Check the name and try your request
// again.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that allows percentages to specify the proportion of the call where
// you would like to apply a filter. For example, you can specify the first
// half of the call. You can also specify the period of time between halfway
// through to three-quarters of the way through the call. Because the length
// of conversation can vary between calls, you can apply relative time ranges
// across all calls.
type RelativeTimeRange struct {
	_ struct{} `type:"structure"`

	// A value that indicates the percentage of the end of the time range. To set
	// a relative time range, you must specify a start percentage and an end percentage.
	// For example, if you specify the following values:
	//
	//    * StartPercentage - 10
	//
	//    * EndPercentage - 50
	//
	// This looks at the time range starting from 10% of the way into the call to
	// 50% of the way through the call. For a call that lasts 100,000 milliseconds,
	// this example range would apply from the 10,000 millisecond mark to the 50,000
	// millisecond mark.
	EndPercentage *int64 `type:"integer"`

	// A range that takes the portion of the call up to the time in milliseconds
	// set by the value that you've specified. For example, if you specify 120000,
	// the time range is set for the first 120,000 milliseconds of the call.
	First *int64 `type:"integer"`

	// A range that takes the portion of the call from the time in milliseconds
	// set by the value that you've specified to the end of the call. For example,
	// if you specify 120000, the time range is set for the last 120,000 milliseconds
	// of the call.
	Last *int64 `type:"integer"`

	// A value that indicates the percentage of the beginning of the time range.
	// To set a relative time range, you must specify a start percentage and an
	// end percentage. For example, if you specify the following values:
	//
	//    * StartPercentage - 10
	//
	//    * EndPercentage - 50
	//
	// This looks at the time range starting from 10% of the way into the call to
	// 50% of the way through the call. For a call that lasts 100,000 milliseconds,
	// this example range would apply from the 10,000 millisecond mark to the 50,000
	// millisecond mark.
	StartPercentage *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelativeTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelativeTimeRange) GoString() string {
	return s.String()
}

// SetEndPercentage sets the EndPercentage field's value.
func (s *RelativeTimeRange) SetEndPercentage(v int64) *RelativeTimeRange {
	s.EndPercentage = &v
	return s
}

// SetFirst sets the First field's value.
func (s *RelativeTimeRange) SetFirst(v int64) *RelativeTimeRange {
	s.First = &v
	return s
}

// SetLast sets the Last field's value.
func (s *RelativeTimeRange) SetLast(v int64) *RelativeTimeRange {
	s.Last = &v
	return s
}

// SetStartPercentage sets the StartPercentage field's value.
func (s *RelativeTimeRange) SetStartPercentage(v int64) *RelativeTimeRange {
	s.StartPercentage = &v
	return s
}

// A condition in the call between the customer and the agent that you want
// to filter for.
type Rule struct {
	_ struct{} `type:"structure"`

	// A condition for a time period when either the customer or agent was interrupting
	// the other person.
	InterruptionFilter *InterruptionFilter `type:"structure"`

	// A condition for a time period when neither the customer nor the agent was
	// talking.
	NonTalkTimeFilter *NonTalkTimeFilter `type:"structure"`

	// A condition that is applied to a particular customer sentiment.
	SentimentFilter *SentimentFilter `type:"structure"`

	// A condition that catches particular words or phrases based on a exact match.
	// For example, if you set the phrase "I want to speak to the manager", only
	// that exact phrase will be returned.
	TranscriptFilter *TranscriptFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.SentimentFilter != nil {
		if err := s.SentimentFilter.Validate(); err != nil {
			invalidParams.AddNested("SentimentFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.TranscriptFilter != nil {
		if err := s.TranscriptFilter.Validate(); err != nil {
			invalidParams.AddNested("TranscriptFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterruptionFilter sets the InterruptionFilter field's value.
func (s *Rule) SetInterruptionFilter(v *InterruptionFilter) *Rule {
	s.InterruptionFilter = v
	return s
}

// SetNonTalkTimeFilter sets the NonTalkTimeFilter field's value.
func (s *Rule) SetNonTalkTimeFilter(v *NonTalkTimeFilter) *Rule {
	s.NonTalkTimeFilter = v
	return s
}

// SetSentimentFilter sets the SentimentFilter field's value.
func (s *Rule) SetSentimentFilter(v *SentimentFilter) *Rule {
	s.SentimentFilter = v
	return s
}

// SetTranscriptFilter sets the TranscriptFilter field's value.
func (s *Rule) SetTranscriptFilter(v *TranscriptFilter) *Rule {
	s.TranscriptFilter = v
	return s
}

// An object that enables you to specify a particular customer or agent sentiment.
// If at least 50 percent of the conversation turns (the back-and-forth between
// two speakers) in a specified time period match the specified sentiment, Amazon
// Transcribe will consider the sentiment a match.
type SentimentFilter struct {
	_ struct{} `type:"structure"`

	// The time range, measured in seconds, of the sentiment.
	AbsoluteTimeRange *AbsoluteTimeRange `type:"structure"`

	// Set to TRUE to look for sentiments that weren't specified in the request.
	Negate *bool `type:"boolean"`

	// A value that determines whether the sentiment belongs to the customer or
	// the agent.
	ParticipantRole *string `type:"string" enum:"ParticipantRole"`

	// The time range, set in percentages, that correspond to proportion of the
	// call.
	RelativeTimeRange *RelativeTimeRange `type:"structure"`

	// An array that enables you to specify sentiments for the customer or agent.
	// You can specify one or more values.
	//
	// Sentiments is a required field
	Sentiments []*string `min:"1" type:"list" required:"true" enum:"SentimentValue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SentimentFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SentimentFilter"}
	if s.Sentiments == nil {
		invalidParams.Add(request.NewErrParamRequired("Sentiments"))
	}
	if s.Sentiments != nil && len(s.Sentiments) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sentiments", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbsoluteTimeRange sets the AbsoluteTimeRange field's value.
func (s *SentimentFilter) SetAbsoluteTimeRange(v *AbsoluteTimeRange) *SentimentFilter {
	s.AbsoluteTimeRange = v
	return s
}

// SetNegate sets the Negate field's value.
func (s *SentimentFilter) SetNegate(v bool) *SentimentFilter {
	s.Negate = &v
	return s
}

// SetParticipantRole sets the ParticipantRole field's value.
func (s *SentimentFilter) SetParticipantRole(v string) *SentimentFilter {
	s.ParticipantRole = &v
	return s
}

// SetRelativeTimeRange sets the RelativeTimeRange field's value.
func (s *SentimentFilter) SetRelativeTimeRange(v *RelativeTimeRange) *SentimentFilter {
	s.RelativeTimeRange = v
	return s
}

// SetSentiments sets the Sentiments field's value.
func (s *SentimentFilter) SetSentiments(v []*string) *SentimentFilter {
	s.Sentiments = v
	return s
}

// Provides optional settings for the StartTranscriptionJob operation.
type Settings struct {
	_ struct{} `type:"structure"`

	// Instructs Amazon Transcribe to process each audio channel separately and
	// then merge the transcription output of each channel into a single transcription.
	//
	// Amazon Transcribe also produces a transcription of each item detected on
	// an audio channel, including the start time and end time of the item and alternative
	// transcriptions of the item including the confidence that Amazon Transcribe
	// has in the transcription.
	//
	// You can't set both ShowSpeakerLabels and ChannelIdentification in the same
	// request. If you set both, your request returns a BadRequestException.
	ChannelIdentification *bool `type:"boolean"`

	// The number of alternative transcriptions that the service should return.
	// If you specify the MaxAlternatives field, you must set the ShowAlternatives
	// field to true.
	MaxAlternatives *int64 `min:"2" type:"integer"`

	// The maximum number of speakers to identify in the input audio. If there are
	// more speakers in the audio than this number, multiple speakers are identified
	// as a single speaker. If you specify the MaxSpeakerLabels field, you must
	// set the ShowSpeakerLabels field to true.
	MaxSpeakerLabels *int64 `min:"2" type:"integer"`

	// Determines whether the transcription contains alternative transcriptions.
	// If you set the ShowAlternatives field to true, you must also set the maximum
	// number of alternatives to return in the MaxAlternatives field.
	ShowAlternatives *bool `type:"boolean"`

	// Determines whether the transcription job uses speaker recognition to identify
	// different speakers in the input audio. Speaker recognition labels individual
	// speakers in the audio file. If you set the ShowSpeakerLabels field to true,
	// you must also set the maximum number of speaker labels MaxSpeakerLabels field.
	//
	// You can't set both ShowSpeakerLabels and ChannelIdentification in the same
	// request. If you set both, your request returns a BadRequestException.
	ShowSpeakerLabels *bool `type:"boolean"`

	// Set to mask to remove filtered text from the transcript and replace it with
	// three asterisks ("***") as placeholder text. Set to remove to remove filtered
	// text from the transcript without using placeholder text. Set to tag to mark
	// the word in the transcription output that matches the vocabulary filter.
	// When you set the filter method to tag, the words matching your vocabulary
	// filter are not masked or removed.
	VocabularyFilterMethod *string `type:"string" enum:"VocabularyFilterMethod"`

	// The name of the vocabulary filter to use when transcribing the audio. The
	// filter that you specify must have the same language code as the transcription
	// job.
	VocabularyFilterName *string `min:"1" type:"string"`

	// The name of a vocabulary to use when processing the transcription job.
	VocabularyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Settings"}
	if s.MaxAlternatives != nil && *s.MaxAlternatives < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxAlternatives", 2))
	}
	if s.MaxSpeakerLabels != nil && *s.MaxSpeakerLabels < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSpeakerLabels", 2))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelIdentification sets the ChannelIdentification field's value.
func (s *Settings) SetChannelIdentification(v bool) *Settings {
	s.ChannelIdentification = &v
	return s
}

// SetMaxAlternatives sets the MaxAlternatives field's value.
func (s *Settings) SetMaxAlternatives(v int64) *Settings {
	s.MaxAlternatives = &v
	return s
}

// SetMaxSpeakerLabels sets the MaxSpeakerLabels field's value.
func (s *Settings) SetMaxSpeakerLabels(v int64) *Settings {
	s.MaxSpeakerLabels = &v
	return s
}

// SetShowAlternatives sets the ShowAlternatives field's value.
func (s *Settings) SetShowAlternatives(v bool) *Settings {
	s.ShowAlternatives = &v
	return s
}

// SetShowSpeakerLabels sets the ShowSpeakerLabels field's value.
func (s *Settings) SetShowSpeakerLabels(v bool) *Settings {
	s.ShowSpeakerLabels = &v
	return s
}

// SetVocabularyFilterMethod sets the VocabularyFilterMethod field's value.
func (s *Settings) SetVocabularyFilterMethod(v string) *Settings {
	s.VocabularyFilterMethod = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *Settings) SetVocabularyFilterName(v string) *Settings {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *Settings) SetVocabularyName(v string) *Settings {
	s.VocabularyName = &v
	return s
}

type StartCallAnalyticsJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the call analytics job. You can't use the string "." or ".."
	// by themselves as the job name. The name must also be unique within an Amazon
	// Web Services account. If you try to create a call analytics job with the
	// same name as a previous call analytics job, you get a ConflictException error.
	//
	// CallAnalyticsJobName is a required field
	CallAnalyticsJobName *string `min:"1" type:"string" required:"true"`

	// When you start a call analytics job, you must pass an array that maps the
	// agent and the customer to specific audio channels. The values you can assign
	// to a channel are 0 and 1. The agent and the customer must each have their
	// own channel. You can't assign more than one channel to an agent or customer.
	ChannelDefinitions []*ChannelDefinition `min:"2" type:"list"`

	// The Amazon Resource Name (ARN) of a role that has access to the S3 bucket
	// that contains your input files. Amazon Transcribe assumes this role to read
	// queued audio files. If you have specified an output S3 bucket for your transcription
	// results, this role should have access to the output bucket as well.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Describes the input media file in a transcription request.
	//
	// Media is a required field
	Media *Media `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services Key Management
	// Service key used to encrypt the output of the call analytics job. The user
	// calling the operation must have permission to use the specified KMS key.
	//
	// You use either of the following to identify an Amazon Web Services KMS key
	// in the current account:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * KMS Key Alias: "alias/ExampleAlias"
	//
	// You can use either of the following to identify a KMS key in the current
	// account or another account:
	//
	//    * Amazon Resource Name (ARN) of a KMS key in the current account or another
	//    account: "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef1234567890ab"
	//
	//    * ARN of a KMS Key Alias: "arn:aws:kms:region:accountID:alias/ExampleAlias"
	//
	// If you don't specify an encryption key, the output of the call analytics
	// job is encrypted with the default Amazon S3 key (SSE-S3).
	//
	// If you specify a KMS key to encrypt your output, you must also specify an
	// output location in the OutputLocation parameter.
	OutputEncryptionKMSKeyId *string `min:"1" type:"string"`

	// The Amazon S3 location where the output of the call analytics job is stored.
	// You can provide the following location types to store the output of call
	// analytics job:
	//
	//    * s3://DOC-EXAMPLE-BUCKET1 If you specify a bucket, Amazon Transcribe
	//    saves the output of the analytics job as a JSON file at the root level
	//    of the bucket.
	//
	//    * s3://DOC-EXAMPLE-BUCKET1/folder/ f you specify a path, Amazon Transcribe
	//    saves the output of the analytics job as s3://DOC-EXAMPLE-BUCKET1/folder/your-transcription-job-name.json.
	//    If you specify a folder, you must provide a trailing slash.
	//
	//    * s3://DOC-EXAMPLE-BUCKET1/folder/filename.json. If you provide a path
	//    that has the filename specified, Amazon Transcribe saves the output of
	//    the analytics job as s3://DOC-EXAMPLEBUCKET1/folder/filename.json.
	//
	// You can specify an Amazon Web Services Key Management Service (KMS) key to
	// encrypt the output of our analytics job using the OutputEncryptionKMSKeyId
	// parameter. If you don't specify a KMS key, Amazon Transcribe uses the default
	// Amazon S3 key for server-side encryption of the analytics job output that
	// is placed in your S3 bucket.
	OutputLocation *string `min:"1" type:"string"`

	// A Settings object that provides optional settings for a call analytics job.
	Settings *CallAnalyticsJobSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCallAnalyticsJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCallAnalyticsJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCallAnalyticsJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCallAnalyticsJobInput"}
	if s.CallAnalyticsJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("CallAnalyticsJobName"))
	}
	if s.CallAnalyticsJobName != nil && len(*s.CallAnalyticsJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallAnalyticsJobName", 1))
	}
	if s.ChannelDefinitions != nil && len(s.ChannelDefinitions) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelDefinitions", 2))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.Media == nil {
		invalidParams.Add(request.NewErrParamRequired("Media"))
	}
	if s.OutputEncryptionKMSKeyId != nil && len(*s.OutputEncryptionKMSKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputEncryptionKMSKeyId", 1))
	}
	if s.OutputLocation != nil && len(*s.OutputLocation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputLocation", 1))
	}
	if s.Media != nil {
		if err := s.Media.Validate(); err != nil {
			invalidParams.AddNested("Media", err.(request.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAnalyticsJobName sets the CallAnalyticsJobName field's value.
func (s *StartCallAnalyticsJobInput) SetCallAnalyticsJobName(v string) *StartCallAnalyticsJobInput {
	s.CallAnalyticsJobName = &v
	return s
}

// SetChannelDefinitions sets the ChannelDefinitions field's value.
func (s *StartCallAnalyticsJobInput) SetChannelDefinitions(v []*ChannelDefinition) *StartCallAnalyticsJobInput {
	s.ChannelDefinitions = v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartCallAnalyticsJobInput) SetDataAccessRoleArn(v string) *StartCallAnalyticsJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetMedia sets the Media field's value.
func (s *StartCallAnalyticsJobInput) SetMedia(v *Media) *StartCallAnalyticsJobInput {
	s.Media = v
	return s
}

// SetOutputEncryptionKMSKeyId sets the OutputEncryptionKMSKeyId field's value.
func (s *StartCallAnalyticsJobInput) SetOutputEncryptionKMSKeyId(v string) *StartCallAnalyticsJobInput {
	s.OutputEncryptionKMSKeyId = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *StartCallAnalyticsJobInput) SetOutputLocation(v string) *StartCallAnalyticsJobInput {
	s.OutputLocation = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *StartCallAnalyticsJobInput) SetSettings(v *CallAnalyticsJobSettings) *StartCallAnalyticsJobInput {
	s.Settings = v
	return s
}

type StartCallAnalyticsJobOutput struct {
	_ struct{} `type:"structure"`

	// An object containing the details of the asynchronous call analytics job.
	CallAnalyticsJob *CallAnalyticsJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCallAnalyticsJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCallAnalyticsJobOutput) GoString() string {
	return s.String()
}

// SetCallAnalyticsJob sets the CallAnalyticsJob field's value.
func (s *StartCallAnalyticsJobOutput) SetCallAnalyticsJob(v *CallAnalyticsJob) *StartCallAnalyticsJobOutput {
	s.CallAnalyticsJob = v
	return s
}

type StartMedicalTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// You can configure Amazon Transcribe Medical to label content in the transcription
	// output. If you specify PHI, Amazon Transcribe Medical labels the personal
	// health information (PHI) that it identifies in the transcription output.
	ContentIdentificationType *string `type:"string" enum:"MedicalContentIdentificationType"`

	// A map of plain text, non-secret key:value pairs, known as encryption context
	// pairs, that provide an added layer of security for your data.
	KMSEncryptionContext map[string]*string `min:"1" type:"map"`

	// The language code for the language spoken in the input media file. US English
	// (en-US) is the valid value for medical transcription jobs. Any other value
	// you enter for language code results in a BadRequestException error.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Describes the input media file in a transcription request.
	//
	// Media is a required field
	Media *Media `type:"structure" required:"true"`

	// The audio format of the input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in Hertz, of the audio track in the input media file.
	//
	// If you do not specify the media sample rate, Amazon Transcribe Medical determines
	// the sample rate. If you specify the sample rate, it must match the rate detected
	// by Amazon Transcribe Medical. In most cases, you should leave the MediaSampleRateHertz
	// field blank and let Amazon Transcribe Medical determine the sample rate.
	MediaSampleRateHertz *int64 `min:"16000" type:"integer"`

	// The name of the medical transcription job. You can't use the strings "."
	// or ".." by themselves as the job name. The name must also be unique within
	// an Amazon Web Services account. If you try to create a medical transcription
	// job with the same name as a previous medical transcription job, you get a
	// ConflictException error.
	//
	// MedicalTranscriptionJobName is a required field
	MedicalTranscriptionJobName *string `min:"1" type:"string" required:"true"`

	// The Amazon S3 location where the transcription is stored.
	//
	// You must set OutputBucketName for Amazon Transcribe Medical to store the
	// transcription results. Your transcript appears in the S3 location you specify.
	// When you call the GetMedicalTranscriptionJob, the operation returns this
	// location in the TranscriptFileUri field. The S3 bucket must have permissions
	// that allow Amazon Transcribe Medical to put files in the bucket. For more
	// information, see Permissions Required for IAM User Roles (https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
	//
	// You can specify an Amazon Web Services Key Management Service (KMS) key to
	// encrypt the output of your transcription using the OutputEncryptionKMSKeyId
	// parameter. If you don't specify a KMS key, Amazon Transcribe Medical uses
	// the default Amazon S3 key for server-side encryption of transcripts that
	// are placed in your S3 bucket.
	//
	// OutputBucketName is a required field
	OutputBucketName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services Key Management
	// Service (KMS) key used to encrypt the output of the transcription job. The
	// user calling the StartMedicalTranscriptionJob operation must have permission
	// to use the specified KMS key.
	//
	// You use either of the following to identify a KMS key in the current account:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * KMS Key Alias: "alias/ExampleAlias"
	//
	// You can use either of the following to identify a KMS key in the current
	// account or another account:
	//
	//    * Amazon Resource Name (ARN) of a KMS key in the current account or another
	//    account: "arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"
	//
	// If you don't specify an encryption key, the output of the medical transcription
	// job is encrypted with the default Amazon S3 key (SSE-S3).
	//
	// If you specify a KMS key to encrypt your output, you must also specify an
	// output location in the OutputBucketName parameter.
	OutputEncryptionKMSKeyId *string `min:"1" type:"string"`

	// You can specify a location in an Amazon S3 bucket to store the output of
	// your medical transcription job.
	//
	// If you don't specify an output key, Amazon Transcribe Medical stores the
	// output of your transcription job in the Amazon S3 bucket you specified. By
	// default, the object key is "your-transcription-job-name.json".
	//
	// You can use output keys to specify the Amazon S3 prefix and file name of
	// the transcription output. For example, specifying the Amazon S3 prefix, "folder1/folder2/",
	// as an output key would lead to the output being stored as "folder1/folder2/your-transcription-job-name.json".
	// If you specify "my-other-job-name.json" as the output key, the object key
	// is changed to "my-other-job-name.json". You can use an output key to change
	// both the prefix and the file name, for example "folder/my-other-job-name.json".
	//
	// If you specify an output key, you must also specify an S3 bucket in the OutputBucketName
	// parameter.
	OutputKey *string `min:"1" type:"string"`

	// Optional settings for the medical transcription job.
	Settings *MedicalTranscriptionSetting `type:"structure"`

	// The medical specialty of any clinician speaking in the input media.
	//
	// Specialty is a required field
	Specialty *string `type:"string" required:"true" enum:"Specialty"`

	// Add tags to an Amazon Transcribe Medical transcription job.
	Tags []*Tag `min:"1" type:"list"`

	// The type of speech in the input audio. CONVERSATION refers to conversations
	// between two or more speakers, e.g., a conversations between doctors and patients.
	// DICTATION refers to single-speaker dictated speech, such as clinical notes.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMedicalTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMedicalTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMedicalTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMedicalTranscriptionJobInput"}
	if s.KMSEncryptionContext != nil && len(s.KMSEncryptionContext) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSEncryptionContext", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Media == nil {
		invalidParams.Add(request.NewErrParamRequired("Media"))
	}
	if s.MediaSampleRateHertz != nil && *s.MediaSampleRateHertz < 16000 {
		invalidParams.Add(request.NewErrParamMinValue("MediaSampleRateHertz", 16000))
	}
	if s.MedicalTranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("MedicalTranscriptionJobName"))
	}
	if s.MedicalTranscriptionJobName != nil && len(*s.MedicalTranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MedicalTranscriptionJobName", 1))
	}
	if s.OutputBucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputBucketName"))
	}
	if s.OutputEncryptionKMSKeyId != nil && len(*s.OutputEncryptionKMSKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputEncryptionKMSKeyId", 1))
	}
	if s.OutputKey != nil && len(*s.OutputKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputKey", 1))
	}
	if s.Specialty == nil {
		invalidParams.Add(request.NewErrParamRequired("Specialty"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Media != nil {
		if err := s.Media.Validate(); err != nil {
			invalidParams.AddNested("Media", err.(request.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *StartMedicalTranscriptionJobInput) SetContentIdentificationType(v string) *StartMedicalTranscriptionJobInput {
	s.ContentIdentificationType = &v
	return s
}

// SetKMSEncryptionContext sets the KMSEncryptionContext field's value.
func (s *StartMedicalTranscriptionJobInput) SetKMSEncryptionContext(v map[string]*string) *StartMedicalTranscriptionJobInput {
	s.KMSEncryptionContext = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartMedicalTranscriptionJobInput) SetLanguageCode(v string) *StartMedicalTranscriptionJobInput {
	s.LanguageCode = &v
	return s
}

// SetMedia sets the Media field's value.
func (s *StartMedicalTranscriptionJobInput) SetMedia(v *Media) *StartMedicalTranscriptionJobInput {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *StartMedicalTranscriptionJobInput) SetMediaFormat(v string) *StartMedicalTranscriptionJobInput {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartMedicalTranscriptionJobInput) SetMediaSampleRateHertz(v int64) *StartMedicalTranscriptionJobInput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *StartMedicalTranscriptionJobInput) SetMedicalTranscriptionJobName(v string) *StartMedicalTranscriptionJobInput {
	s.MedicalTranscriptionJobName = &v
	return s
}

// SetOutputBucketName sets the OutputBucketName field's value.
func (s *StartMedicalTranscriptionJobInput) SetOutputBucketName(v string) *StartMedicalTranscriptionJobInput {
	s.OutputBucketName = &v
	return s
}

// SetOutputEncryptionKMSKeyId sets the OutputEncryptionKMSKeyId field's value.
func (s *StartMedicalTranscriptionJobInput) SetOutputEncryptionKMSKeyId(v string) *StartMedicalTranscriptionJobInput {
	s.OutputEncryptionKMSKeyId = &v
	return s
}

// SetOutputKey sets the OutputKey field's value.
func (s *StartMedicalTranscriptionJobInput) SetOutputKey(v string) *StartMedicalTranscriptionJobInput {
	s.OutputKey = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *StartMedicalTranscriptionJobInput) SetSettings(v *MedicalTranscriptionSetting) *StartMedicalTranscriptionJobInput {
	s.Settings = v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *StartMedicalTranscriptionJobInput) SetSpecialty(v string) *StartMedicalTranscriptionJobInput {
	s.Specialty = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartMedicalTranscriptionJobInput) SetTags(v []*Tag) *StartMedicalTranscriptionJobInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *StartMedicalTranscriptionJobInput) SetType(v string) *StartMedicalTranscriptionJobInput {
	s.Type = &v
	return s
}

type StartMedicalTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// A batch job submitted to transcribe medical speech to text.
	MedicalTranscriptionJob *MedicalTranscriptionJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMedicalTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMedicalTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetMedicalTranscriptionJob sets the MedicalTranscriptionJob field's value.
func (s *StartMedicalTranscriptionJobOutput) SetMedicalTranscriptionJob(v *MedicalTranscriptionJob) *StartMedicalTranscriptionJobOutput {
	s.MedicalTranscriptionJob = v
	return s
}

type StartTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// An object that contains the request parameters for content redaction.
	ContentRedaction *ContentRedaction `type:"structure"`

	// Set this field to true to enable automatic language identification. Automatic
	// language identification is disabled by default. You receive a BadRequestException
	// error if you enter a value for a LanguageCode.
	IdentifyLanguage *bool `type:"boolean"`

	// Provides information about how a transcription job is executed. Use this
	// field to indicate that the job can be queued for deferred execution if the
	// concurrency limit is reached and there are no slots available to immediately
	// run the job.
	JobExecutionSettings *JobExecutionSettings `type:"structure"`

	// A map of plain text, non-secret key:value pairs, known as encryption context
	// pairs, that provide an added layer of security for your data.
	KMSEncryptionContext map[string]*string `min:"1" type:"map"`

	// The language code for the language used in the input media file.
	//
	// To transcribe speech in Modern Standard Arabic (ar-SA), your audio or video
	// file must be encoded at a sample rate of 16,000 Hz or higher.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The language identification settings associated with your transcription job.
	// These settings include VocabularyName, VocabularyFilterName, and LanguageModelName.
	LanguageIdSettings map[string]*LanguageIdSettings `min:"1" type:"map"`

	// An object containing a list of languages that might be present in your collection
	// of audio files. Automatic language identification chooses a language that
	// best matches the source audio from that list.
	//
	// To transcribe speech in Modern Standard Arabic (ar-SA), your audio or video
	// file must be encoded at a sample rate of 16,000 Hz or higher.
	LanguageOptions []*string `min:"1" type:"list" enum:"LanguageCode"`

	// An object that describes the input media for a transcription job.
	//
	// Media is a required field
	Media *Media `type:"structure" required:"true"`

	// The format of the input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in Hertz, of the audio track in the input media file.
	//
	// If you do not specify the media sample rate, Amazon Transcribe determines
	// the sample rate. If you specify the sample rate, it must match the sample
	// rate detected by Amazon Transcribe. In most cases, you should leave the MediaSampleRateHertz
	// field blank and let Amazon Transcribe determine the sample rate.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// Choose the custom language model you use for your transcription job in this
	// parameter.
	ModelSettings *ModelSettings `type:"structure"`

	// The location where the transcription is stored.
	//
	// If you set the OutputBucketName, Amazon Transcribe puts the transcript in
	// the specified S3 bucket. When you call the GetTranscriptionJob operation,
	// the operation returns this location in the TranscriptFileUri field. If you
	// enable content redaction, the redacted transcript appears in RedactedTranscriptFileUri.
	// If you enable content redaction and choose to output an unredacted transcript,
	// that transcript's location still appears in the TranscriptFileUri. The S3
	// bucket must have permissions that allow Amazon Transcribe to put files in
	// the bucket. For more information, see Permissions Required for IAM User Roles
	// (https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
	//
	// You can specify an Amazon Web Services Key Management Service (KMS) key to
	// encrypt the output of your transcription using the OutputEncryptionKMSKeyId
	// parameter. If you don't specify a KMS key, Amazon Transcribe uses the default
	// Amazon S3 key for server-side encryption of transcripts that are placed in
	// your S3 bucket.
	//
	// If you don't set the OutputBucketName, Amazon Transcribe generates a pre-signed
	// URL, a shareable URL that provides secure access to your transcription, and
	// returns it in the TranscriptFileUri field. Use this URL to download the transcription.
	OutputBucketName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services Key Management
	// Service (KMS) key used to encrypt the output of the transcription job. The
	// user calling the StartTranscriptionJob operation must have permission to
	// use the specified KMS key.
	//
	// You can use either of the following to identify a KMS key in the current
	// account:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * KMS Key Alias: "alias/ExampleAlias"
	//
	// You can use either of the following to identify a KMS key in the current
	// account or another account:
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:region:account
	//    ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * ARN of a KMS Key Alias: "arn:aws:kms:region:account-ID:alias/ExampleAlias"
	//
	// If you don't specify an encryption key, the output of the transcription job
	// is encrypted with the default Amazon S3 key (SSE-S3).
	//
	// If you specify a KMS key to encrypt your output, you must also specify an
	// output location in the OutputBucketName parameter.
	OutputEncryptionKMSKeyId *string `min:"1" type:"string"`

	// You can specify a location in an Amazon S3 bucket to store the output of
	// your transcription job.
	//
	// If you don't specify an output key, Amazon Transcribe stores the output of
	// your transcription job in the Amazon S3 bucket you specified. By default,
	// the object key is "your-transcription-job-name.json".
	//
	// You can use output keys to specify the Amazon S3 prefix and file name of
	// the transcription output. For example, specifying the Amazon S3 prefix, "folder1/folder2/",
	// as an output key would lead to the output being stored as "folder1/folder2/your-transcription-job-name.json".
	// If you specify "my-other-job-name.json" as the output key, the object key
	// is changed to "my-other-job-name.json". You can use an output key to change
	// both the prefix and the file name, for example "folder/my-other-job-name.json".
	//
	// If you specify an output key, you must also specify an S3 bucket in the OutputBucketName
	// parameter.
	OutputKey *string `min:"1" type:"string"`

	// A Settings object that provides optional settings for a transcription job.
	Settings *Settings `type:"structure"`

	// Add subtitles to your batch transcription job.
	Subtitles *Subtitles `type:"structure"`

	// Add tags to an Amazon Transcribe transcription job.
	Tags []*Tag `min:"1" type:"list"`

	// The name of the job. You can't use the strings "." or ".." by themselves
	// as the job name. The name must also be unique within an Amazon Web Services
	// account. If you try to create a transcription job with the same name as a
	// previous transcription job, you get a ConflictException error.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTranscriptionJobInput"}
	if s.KMSEncryptionContext != nil && len(s.KMSEncryptionContext) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSEncryptionContext", 1))
	}
	if s.LanguageIdSettings != nil && len(s.LanguageIdSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageIdSettings", 1))
	}
	if s.LanguageOptions != nil && len(s.LanguageOptions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageOptions", 1))
	}
	if s.Media == nil {
		invalidParams.Add(request.NewErrParamRequired("Media"))
	}
	if s.MediaSampleRateHertz != nil && *s.MediaSampleRateHertz < 8000 {
		invalidParams.Add(request.NewErrParamMinValue("MediaSampleRateHertz", 8000))
	}
	if s.OutputEncryptionKMSKeyId != nil && len(*s.OutputEncryptionKMSKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputEncryptionKMSKeyId", 1))
	}
	if s.OutputKey != nil && len(*s.OutputKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputKey", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.TranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TranscriptionJobName", 1))
	}
	if s.ContentRedaction != nil {
		if err := s.ContentRedaction.Validate(); err != nil {
			invalidParams.AddNested("ContentRedaction", err.(request.ErrInvalidParams))
		}
	}
	if s.JobExecutionSettings != nil {
		if err := s.JobExecutionSettings.Validate(); err != nil {
			invalidParams.AddNested("JobExecutionSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.LanguageIdSettings != nil {
		for i, v := range s.LanguageIdSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LanguageIdSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Media != nil {
		if err := s.Media.Validate(); err != nil {
			invalidParams.AddNested("Media", err.(request.ErrInvalidParams))
		}
	}
	if s.ModelSettings != nil {
		if err := s.ModelSettings.Validate(); err != nil {
			invalidParams.AddNested("ModelSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentRedaction sets the ContentRedaction field's value.
func (s *StartTranscriptionJobInput) SetContentRedaction(v *ContentRedaction) *StartTranscriptionJobInput {
	s.ContentRedaction = v
	return s
}

// SetIdentifyLanguage sets the IdentifyLanguage field's value.
func (s *StartTranscriptionJobInput) SetIdentifyLanguage(v bool) *StartTranscriptionJobInput {
	s.IdentifyLanguage = &v
	return s
}

// SetJobExecutionSettings sets the JobExecutionSettings field's value.
func (s *StartTranscriptionJobInput) SetJobExecutionSettings(v *JobExecutionSettings) *StartTranscriptionJobInput {
	s.JobExecutionSettings = v
	return s
}

// SetKMSEncryptionContext sets the KMSEncryptionContext field's value.
func (s *StartTranscriptionJobInput) SetKMSEncryptionContext(v map[string]*string) *StartTranscriptionJobInput {
	s.KMSEncryptionContext = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartTranscriptionJobInput) SetLanguageCode(v string) *StartTranscriptionJobInput {
	s.LanguageCode = &v
	return s
}

// SetLanguageIdSettings sets the LanguageIdSettings field's value.
func (s *StartTranscriptionJobInput) SetLanguageIdSettings(v map[string]*LanguageIdSettings) *StartTranscriptionJobInput {
	s.LanguageIdSettings = v
	return s
}

// SetLanguageOptions sets the LanguageOptions field's value.
func (s *StartTranscriptionJobInput) SetLanguageOptions(v []*string) *StartTranscriptionJobInput {
	s.LanguageOptions = v
	return s
}

// SetMedia sets the Media field's value.
func (s *StartTranscriptionJobInput) SetMedia(v *Media) *StartTranscriptionJobInput {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *StartTranscriptionJobInput) SetMediaFormat(v string) *StartTranscriptionJobInput {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartTranscriptionJobInput) SetMediaSampleRateHertz(v int64) *StartTranscriptionJobInput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetModelSettings sets the ModelSettings field's value.
func (s *StartTranscriptionJobInput) SetModelSettings(v *ModelSettings) *StartTranscriptionJobInput {
	s.ModelSettings = v
	return s
}

// SetOutputBucketName sets the OutputBucketName field's value.
func (s *StartTranscriptionJobInput) SetOutputBucketName(v string) *StartTranscriptionJobInput {
	s.OutputBucketName = &v
	return s
}

// SetOutputEncryptionKMSKeyId sets the OutputEncryptionKMSKeyId field's value.
func (s *StartTranscriptionJobInput) SetOutputEncryptionKMSKeyId(v string) *StartTranscriptionJobInput {
	s.OutputEncryptionKMSKeyId = &v
	return s
}

// SetOutputKey sets the OutputKey field's value.
func (s *StartTranscriptionJobInput) SetOutputKey(v string) *StartTranscriptionJobInput {
	s.OutputKey = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *StartTranscriptionJobInput) SetSettings(v *Settings) *StartTranscriptionJobInput {
	s.Settings = v
	return s
}

// SetSubtitles sets the Subtitles field's value.
func (s *StartTranscriptionJobInput) SetSubtitles(v *Subtitles) *StartTranscriptionJobInput {
	s.Subtitles = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartTranscriptionJobInput) SetTags(v []*Tag) *StartTranscriptionJobInput {
	s.Tags = v
	return s
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *StartTranscriptionJobInput) SetTranscriptionJobName(v string) *StartTranscriptionJobInput {
	s.TranscriptionJobName = &v
	return s
}

type StartTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object containing details of the asynchronous transcription job.
	TranscriptionJob *TranscriptionJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetTranscriptionJob sets the TranscriptionJob field's value.
func (s *StartTranscriptionJobOutput) SetTranscriptionJob(v *TranscriptionJob) *StartTranscriptionJobOutput {
	s.TranscriptionJob = v
	return s
}

// Generate subtitles for your batch transcription job.
type Subtitles struct {
	_ struct{} `type:"structure"`

	// Specify the output format for your subtitle file.
	Formats []*string `type:"list" enum:"SubtitleFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Subtitles) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Subtitles) GoString() string {
	return s.String()
}

// SetFormats sets the Formats field's value.
func (s *Subtitles) SetFormats(v []*string) *Subtitles {
	s.Formats = v
	return s
}

// Choose the output format for your subtitle file and the S3 location where
// you want your file saved.
type SubtitlesOutput_ struct {
	_ struct{} `type:"structure"`

	// Specify the output format for your subtitle file; if you select both SRT
	// and VTT formats, two output files are generated.
	Formats []*string `type:"list" enum:"SubtitleFormat"`

	// Contains the output location for your subtitle file. This location must be
	// an S3 bucket.
	SubtitleFileUris []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubtitlesOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubtitlesOutput_) GoString() string {
	return s.String()
}

// SetFormats sets the Formats field's value.
func (s *SubtitlesOutput_) SetFormats(v []*string) *SubtitlesOutput_ {
	s.Formats = v
	return s
}

// SetSubtitleFileUris sets the SubtitleFileUris field's value.
func (s *SubtitlesOutput_) SetSubtitleFileUris(v []*string) *SubtitlesOutput_ {
	s.SubtitleFileUris = v
	return s
}

// A key:value pair that adds metadata to a resource used by Amazon Transcribe.
// For example, a tag with the key:value pair ‘Department’:’Sales’ might
// be added to a resource to indicate its use by your organization's sales department.
type Tag struct {
	_ struct{} `type:"structure"`

	// The first part of a key:value pair that forms a tag associated with a given
	// resource. For example, in the tag ‘Department’:’Sales’, the key is
	// 'Department'.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The second part of a key:value pair that forms a tag associated with a given
	// resource. For example, in the tag ‘Department’:’Sales’, the value
	// is 'Sales'.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Transcribe resource you want
	// to tag. ARNs have the format arn:partition:service:region:account-id:resource-type/resource-id
	// (for example, arn:aws:transcribe:us-east-1:account-id:transcription-job/your-job-name).
	// Valid values for resource-type are: transcription-job, medical-transcription-job,
	// vocabulary, medical-vocabulary, vocabulary-filter, and language-model.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags you are assigning to a given Amazon Transcribe resource.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Identifies the location of a transcription.
type Transcript struct {
	_ struct{} `type:"structure"`

	// The S3 object location of the redacted transcript.
	//
	// Use this URI to access the redacted transcript. If you specified an S3 bucket
	// in the OutputBucketName field when you created the job, this is the URI of
	// that bucket. If you chose to store the transcript in Amazon Transcribe, this
	// is a shareable URL that provides secure access to that location.
	RedactedTranscriptFileUri *string `min:"1" type:"string"`

	// The S3 object location of the transcript.
	//
	// Use this URI to access the transcript. If you specified an S3 bucket in the
	// OutputBucketName field when you created the job, this is the URI of that
	// bucket. If you chose to store the transcript in Amazon Transcribe, this is
	// a shareable URL that provides secure access to that location.
	TranscriptFileUri *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transcript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transcript) GoString() string {
	return s.String()
}

// SetRedactedTranscriptFileUri sets the RedactedTranscriptFileUri field's value.
func (s *Transcript) SetRedactedTranscriptFileUri(v string) *Transcript {
	s.RedactedTranscriptFileUri = &v
	return s
}

// SetTranscriptFileUri sets the TranscriptFileUri field's value.
func (s *Transcript) SetTranscriptFileUri(v string) *Transcript {
	s.TranscriptFileUri = &v
	return s
}

// Matches the output of the transcription to either the specific phrases that
// you specify, or the intent of the phrases that you specify.
type TranscriptFilter struct {
	_ struct{} `type:"structure"`

	// A time range, set in seconds, between two points in the call.
	AbsoluteTimeRange *AbsoluteTimeRange `type:"structure"`

	// If TRUE, the rule that you specify is applied to everything except for the
	// phrases that you specify.
	Negate *bool `type:"boolean"`

	// Determines whether the customer or the agent is speaking the phrases that
	// you've specified.
	ParticipantRole *string `type:"string" enum:"ParticipantRole"`

	// An object that allows percentages to specify the proportion of the call where
	// you would like to apply a filter. For example, you can specify the first
	// half of the call. You can also specify the period of time between halfway
	// through to three-quarters of the way through the call. Because the length
	// of conversation can vary between calls, you can apply relative time ranges
	// across all calls.
	RelativeTimeRange *RelativeTimeRange `type:"structure"`

	// The phrases that you're specifying for the transcript filter to match.
	//
	// Targets is a required field
	Targets []*string `min:"1" type:"list" required:"true"`

	// Matches the phrase to the transcription output in a word for word fashion.
	// For example, if you specify the phrase "I want to speak to the manager."
	// Amazon Transcribe attempts to match that specific phrase to the transcription.
	//
	// TranscriptFilterType is a required field
	TranscriptFilterType *string `type:"string" required:"true" enum:"TranscriptFilterType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TranscriptFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TranscriptFilter"}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}
	if s.TranscriptFilterType == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptFilterType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbsoluteTimeRange sets the AbsoluteTimeRange field's value.
func (s *TranscriptFilter) SetAbsoluteTimeRange(v *AbsoluteTimeRange) *TranscriptFilter {
	s.AbsoluteTimeRange = v
	return s
}

// SetNegate sets the Negate field's value.
func (s *TranscriptFilter) SetNegate(v bool) *TranscriptFilter {
	s.Negate = &v
	return s
}

// SetParticipantRole sets the ParticipantRole field's value.
func (s *TranscriptFilter) SetParticipantRole(v string) *TranscriptFilter {
	s.ParticipantRole = &v
	return s
}

// SetRelativeTimeRange sets the RelativeTimeRange field's value.
func (s *TranscriptFilter) SetRelativeTimeRange(v *RelativeTimeRange) *TranscriptFilter {
	s.RelativeTimeRange = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *TranscriptFilter) SetTargets(v []*string) *TranscriptFilter {
	s.Targets = v
	return s
}

// SetTranscriptFilterType sets the TranscriptFilterType field's value.
func (s *TranscriptFilter) SetTranscriptFilterType(v string) *TranscriptFilter {
	s.TranscriptFilterType = &v
	return s
}

// Describes an asynchronous transcription job that was created with the StartTranscriptionJob
// operation.
type TranscriptionJob struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the job completed.
	CompletionTime *time.Time `type:"timestamp"`

	// An object that describes content redaction settings for the transcription
	// job.
	ContentRedaction *ContentRedaction `type:"structure"`

	// A timestamp that shows when the job was created.
	CreationTime *time.Time `type:"timestamp"`

	// If the TranscriptionJobStatus field is FAILED, this field contains information
	// about why the job failed.
	//
	// The FailureReason field can contain one of the following values:
	//
	//    * Unsupported media format - The media format specified in the MediaFormat
	//    field of the request isn't valid. See the description of the MediaFormat
	//    field for a list of valid values.
	//
	//    * The media format provided does not match the detected media format -
	//    The media format of the audio file doesn't match the format specified
	//    in the MediaFormat field in the request. Check the media format of your
	//    media file and make sure that the two values match.
	//
	//    * Invalid sample rate for audio file - The sample rate specified in the
	//    MediaSampleRateHertz of the request isn't valid. The sample rate must
	//    be between 8,000 and 48,000 Hertz.
	//
	//    * The sample rate provided does not match the detected sample rate - The
	//    sample rate in the audio file doesn't match the sample rate specified
	//    in the MediaSampleRateHertz field in the request. Check the sample rate
	//    of your media file and make sure that the two values match.
	//
	//    * Invalid file size: file size too large - The size of your audio file
	//    is larger than Amazon Transcribe can process. For more information, see
	//    Limits (https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits)
	//    in the Amazon Transcribe Developer Guide.
	//
	//    * Invalid number of channels: number of channels too large - Your audio
	//    contains more channels than Amazon Transcribe is configured to process.
	//    To request additional channels, see Amazon Transcribe Limits (https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits-amazon-transcribe)
	//    in the Amazon Web Services General Reference.
	FailureReason *string `type:"string"`

	// A value between zero and one that Amazon Transcribe assigned to the language
	// that it identified in the source audio. Larger values indicate that Amazon
	// Transcribe has higher confidence in the language it identified.
	IdentifiedLanguageScore *float64 `type:"float"`

	// A value that shows if automatic language identification was enabled for a
	// transcription job.
	IdentifyLanguage *bool `type:"boolean"`

	// Provides information about how a transcription job is executed.
	JobExecutionSettings *JobExecutionSettings `type:"structure"`

	// The language code for the input speech.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Language-specific settings that can be specified when language identification
	// is enabled for your transcription job. These settings include VocabularyName,
	// VocabularyFilterName, and LanguageModelName.
	LanguageIdSettings map[string]*LanguageIdSettings `min:"1" type:"map"`

	// An object that shows the optional array of languages inputted for transcription
	// jobs with automatic language identification enabled.
	LanguageOptions []*string `min:"1" type:"list" enum:"LanguageCode"`

	// An object that describes the input media for the transcription job.
	Media *Media `type:"structure"`

	// The format of the input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in Hertz (Hz), of the audio track in the input media file.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// An object containing the details of your custom language model.
	ModelSettings *ModelSettings `type:"structure"`

	// Optional settings for the transcription job. Use these settings to turn on
	// speaker recognition, to set the maximum number of speakers that should be
	// identified and to specify a custom vocabulary to use when processing the
	// transcription job.
	Settings *Settings `type:"structure"`

	// A timestamp that shows when the job started processing.
	StartTime *time.Time `type:"timestamp"`

	// Generate subtitles for your batch transcription job.
	Subtitles *SubtitlesOutput_ `type:"structure"`

	// A key:value pair assigned to a given transcription job.
	Tags []*Tag `min:"1" type:"list"`

	// An object that describes the output of the transcription job.
	Transcript *Transcript `type:"structure"`

	// The name of the transcription job.
	TranscriptionJobName *string `min:"1" type:"string"`

	// The status of the transcription job.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionJob) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *TranscriptionJob) SetCompletionTime(v time.Time) *TranscriptionJob {
	s.CompletionTime = &v
	return s
}

// SetContentRedaction sets the ContentRedaction field's value.
func (s *TranscriptionJob) SetContentRedaction(v *ContentRedaction) *TranscriptionJob {
	s.ContentRedaction = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *TranscriptionJob) SetCreationTime(v time.Time) *TranscriptionJob {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *TranscriptionJob) SetFailureReason(v string) *TranscriptionJob {
	s.FailureReason = &v
	return s
}

// SetIdentifiedLanguageScore sets the IdentifiedLanguageScore field's value.
func (s *TranscriptionJob) SetIdentifiedLanguageScore(v float64) *TranscriptionJob {
	s.IdentifiedLanguageScore = &v
	return s
}

// SetIdentifyLanguage sets the IdentifyLanguage field's value.
func (s *TranscriptionJob) SetIdentifyLanguage(v bool) *TranscriptionJob {
	s.IdentifyLanguage = &v
	return s
}

// SetJobExecutionSettings sets the JobExecutionSettings field's value.
func (s *TranscriptionJob) SetJobExecutionSettings(v *JobExecutionSettings) *TranscriptionJob {
	s.JobExecutionSettings = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *TranscriptionJob) SetLanguageCode(v string) *TranscriptionJob {
	s.LanguageCode = &v
	return s
}

// SetLanguageIdSettings sets the LanguageIdSettings field's value.
func (s *TranscriptionJob) SetLanguageIdSettings(v map[string]*LanguageIdSettings) *TranscriptionJob {
	s.LanguageIdSettings = v
	return s
}

// SetLanguageOptions sets the LanguageOptions field's value.
func (s *TranscriptionJob) SetLanguageOptions(v []*string) *TranscriptionJob {
	s.LanguageOptions = v
	return s
}

// SetMedia sets the Media field's value.
func (s *TranscriptionJob) SetMedia(v *Media) *TranscriptionJob {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *TranscriptionJob) SetMediaFormat(v string) *TranscriptionJob {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *TranscriptionJob) SetMediaSampleRateHertz(v int64) *TranscriptionJob {
	s.MediaSampleRateHertz = &v
	return s
}

// SetModelSettings sets the ModelSettings field's value.
func (s *TranscriptionJob) SetModelSettings(v *ModelSettings) *TranscriptionJob {
	s.ModelSettings = v
	return s
}

// SetSettings sets the Settings field's value.
func (s *TranscriptionJob) SetSettings(v *Settings) *TranscriptionJob {
	s.Settings = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TranscriptionJob) SetStartTime(v time.Time) *TranscriptionJob {
	s.StartTime = &v
	return s
}

// SetSubtitles sets the Subtitles field's value.
func (s *TranscriptionJob) SetSubtitles(v *SubtitlesOutput_) *TranscriptionJob {
	s.Subtitles = v
	return s
}

// SetTags sets the Tags field's value.
func (s *TranscriptionJob) SetTags(v []*Tag) *TranscriptionJob {
	s.Tags = v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *TranscriptionJob) SetTranscript(v *Transcript) *TranscriptionJob {
	s.Transcript = v
	return s
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *TranscriptionJob) SetTranscriptionJobName(v string) *TranscriptionJob {
	s.TranscriptionJobName = &v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *TranscriptionJob) SetTranscriptionJobStatus(v string) *TranscriptionJob {
	s.TranscriptionJobStatus = &v
	return s
}

// Provides a summary of information about a transcription job.
type TranscriptionJobSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the job was completed.
	CompletionTime *time.Time `type:"timestamp"`

	// The content redaction settings of the transcription job.
	ContentRedaction *ContentRedaction `type:"structure"`

	// A timestamp that shows when the job was created.
	CreationTime *time.Time `type:"timestamp"`

	// If the TranscriptionJobStatus field is FAILED, a description of the error.
	FailureReason *string `type:"string"`

	// A value between zero and one that Amazon Transcribe assigned to the language
	// it identified in the source audio. A higher score indicates that Amazon Transcribe
	// is more confident in the language it identified.
	IdentifiedLanguageScore *float64 `type:"float"`

	// Whether automatic language identification was enabled for a transcription
	// job.
	IdentifyLanguage *bool `type:"boolean"`

	// The language code for the input speech.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The object used to call your custom language model to your transcription
	// job.
	ModelSettings *ModelSettings `type:"structure"`

	// Indicates the location of the output of the transcription job.
	//
	// If the value is CUSTOMER_BUCKET then the location is the S3 bucket specified
	// in the outputBucketName field when the transcription job was started with
	// the StartTranscriptionJob operation.
	//
	// If the value is SERVICE_BUCKET then the output is stored by Amazon Transcribe
	// and can be retrieved using the URI in the GetTranscriptionJob response's
	// TranscriptFileUri field.
	OutputLocationType *string `type:"string" enum:"OutputLocationType"`

	// A timestamp that shows when the job started processing.
	StartTime *time.Time `type:"timestamp"`

	// The name of the transcription job.
	TranscriptionJobName *string `min:"1" type:"string"`

	// The status of the transcription job. When the status is COMPLETED, use the
	// GetTranscriptionJob operation to get the results of the transcription.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionJobSummary) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *TranscriptionJobSummary) SetCompletionTime(v time.Time) *TranscriptionJobSummary {
	s.CompletionTime = &v
	return s
}

// SetContentRedaction sets the ContentRedaction field's value.
func (s *TranscriptionJobSummary) SetContentRedaction(v *ContentRedaction) *TranscriptionJobSummary {
	s.ContentRedaction = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *TranscriptionJobSummary) SetCreationTime(v time.Time) *TranscriptionJobSummary {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *TranscriptionJobSummary) SetFailureReason(v string) *TranscriptionJobSummary {
	s.FailureReason = &v
	return s
}

// SetIdentifiedLanguageScore sets the IdentifiedLanguageScore field's value.
func (s *TranscriptionJobSummary) SetIdentifiedLanguageScore(v float64) *TranscriptionJobSummary {
	s.IdentifiedLanguageScore = &v
	return s
}

// SetIdentifyLanguage sets the IdentifyLanguage field's value.
func (s *TranscriptionJobSummary) SetIdentifyLanguage(v bool) *TranscriptionJobSummary {
	s.IdentifyLanguage = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *TranscriptionJobSummary) SetLanguageCode(v string) *TranscriptionJobSummary {
	s.LanguageCode = &v
	return s
}

// SetModelSettings sets the ModelSettings field's value.
func (s *TranscriptionJobSummary) SetModelSettings(v *ModelSettings) *TranscriptionJobSummary {
	s.ModelSettings = v
	return s
}

// SetOutputLocationType sets the OutputLocationType field's value.
func (s *TranscriptionJobSummary) SetOutputLocationType(v string) *TranscriptionJobSummary {
	s.OutputLocationType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TranscriptionJobSummary) SetStartTime(v time.Time) *TranscriptionJobSummary {
	s.StartTime = &v
	return s
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *TranscriptionJobSummary) SetTranscriptionJobName(v string) *TranscriptionJobSummary {
	s.TranscriptionJobName = &v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *TranscriptionJobSummary) SetTranscriptionJobStatus(v string) *TranscriptionJobSummary {
	s.TranscriptionJobStatus = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Transcribe resource you want
	// to remove tags from. ARNs have the format arn:partition:service:region:account-id:resource-type/resource-id
	// (for example, arn:aws:transcribe:us-east-1:account-id:transcription-job/your-job-name).
	// Valid values for resource-type are: transcription-job, medical-transcription-job,
	// vocabulary, medical-vocabulary, vocabulary-filter, and language-model.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// A list of tag keys you want to remove from a specified Amazon Transcribe
	// resource.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCallAnalyticsCategoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the analytics category to update. The name is case sensitive.
	// If you try to update a call analytics category with the same name as a previous
	// category you will receive a ConflictException error.
	//
	// CategoryName is a required field
	CategoryName *string `min:"1" type:"string" required:"true"`

	// The rules used for the updated analytics category. The rules that you provide
	// in this field replace the ones that are currently being used.
	//
	// Rules is a required field
	Rules []*Rule `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCallAnalyticsCategoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCallAnalyticsCategoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCallAnalyticsCategoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCallAnalyticsCategoryInput"}
	if s.CategoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("CategoryName"))
	}
	if s.CategoryName != nil && len(*s.CategoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CategoryName", 1))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryName sets the CategoryName field's value.
func (s *UpdateCallAnalyticsCategoryInput) SetCategoryName(v string) *UpdateCallAnalyticsCategoryInput {
	s.CategoryName = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateCallAnalyticsCategoryInput) SetRules(v []*Rule) *UpdateCallAnalyticsCategoryInput {
	s.Rules = v
	return s
}

type UpdateCallAnalyticsCategoryOutput struct {
	_ struct{} `type:"structure"`

	// The attributes describing the analytics category. You can see information
	// such as the rules that you've used to update the category and when the category
	// was originally created.
	CategoryProperties *CategoryProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCallAnalyticsCategoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCallAnalyticsCategoryOutput) GoString() string {
	return s.String()
}

// SetCategoryProperties sets the CategoryProperties field's value.
func (s *UpdateCallAnalyticsCategoryOutput) SetCategoryProperties(v *CategoryProperties) *UpdateCallAnalyticsCategoryOutput {
	s.CategoryProperties = v
	return s
}

type UpdateMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code of the language used for the entries in the updated vocabulary.
	// U.S. English (en-US) is the only valid language code in Amazon Transcribe
	// Medical.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// The location in Amazon S3 of the text file that contains your custom vocabulary.
	// The URI must be in the same Amazon Web Services Region as the resource that
	// you are calling. The following is the format for a URI:
	//
	// https://s3.aws-region.amazonaws.com/bucket-name/keyprefix/objectkey
	//
	// For example:
	//
	// https://s3.us-east-1.amazonaws.com/DOC-EXAMPLE-BUCKET/vocab.txt
	//
	// For more information about Amazon S3 object names, see Object Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide.
	//
	// For more information about custom vocabularies in Amazon Transcribe Medical,
	// see Medical Custom Vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-med.html).
	VocabularyFileUri *string `min:"1" type:"string"`

	// The name of the vocabulary to update. The name is case sensitive. If you
	// try to update a vocabulary with the same name as a vocabulary you've already
	// made, you get a ConflictException error.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMedicalVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMedicalVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMedicalVocabularyInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateMedicalVocabularyInput) SetLanguageCode(v string) *UpdateMedicalVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *UpdateMedicalVocabularyInput) SetVocabularyFileUri(v string) *UpdateMedicalVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateMedicalVocabularyInput) SetVocabularyName(v string) *UpdateMedicalVocabularyInput {
	s.VocabularyName = &v
	return s
}

type UpdateMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The language code for the language of the text file used to update the custom
	// vocabulary. US English (en-US) is the only language supported in Amazon Transcribe
	// Medical.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the updated vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the update to the vocabulary. When the VocabularyState
	// field is READY, the vocabulary is ready to be used in a StartMedicalTranscriptionJob
	// request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMedicalVocabularyOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateMedicalVocabularyOutput) SetLanguageCode(v string) *UpdateMedicalVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateMedicalVocabularyOutput) SetLastModifiedTime(v time.Time) *UpdateMedicalVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateMedicalVocabularyOutput) SetVocabularyName(v string) *UpdateMedicalVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *UpdateMedicalVocabularyOutput) SetVocabularyState(v string) *UpdateMedicalVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type UpdateVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of a text file used as input to create the vocabulary
	// filter. Only use characters from the character set defined for custom vocabularies.
	// For a list of character sets, see Character Sets for Custom Vocabularies
	// (https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html).
	//
	// The specified file must be less than 50 KB of UTF-8 characters.
	//
	// If you provide the location of a list of words in the VocabularyFilterFileUri
	// parameter, you can't use the Words parameter.
	VocabularyFilterFileUri *string `min:"1" type:"string"`

	// The name of the vocabulary filter to update. If you try to update a vocabulary
	// filter with the same name as another vocabulary filter, you get a ConflictException
	// error.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`

	// The words to use in the vocabulary filter. Only use characters from the character
	// set defined for custom vocabularies. For a list of character sets, see Character
	// Sets for Custom Vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html).
	//
	// If you provide a list of words in the Words parameter, you can't use the
	// VocabularyFilterFileUri parameter.
	Words []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVocabularyFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVocabularyFilterInput"}
	if s.VocabularyFilterFileUri != nil && len(*s.VocabularyFilterFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterFileUri", 1))
	}
	if s.VocabularyFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.Words != nil && len(s.Words) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Words", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyFilterFileUri sets the VocabularyFilterFileUri field's value.
func (s *UpdateVocabularyFilterInput) SetVocabularyFilterFileUri(v string) *UpdateVocabularyFilterInput {
	s.VocabularyFilterFileUri = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *UpdateVocabularyFilterInput) SetVocabularyFilterName(v string) *UpdateVocabularyFilterInput {
	s.VocabularyFilterName = &v
	return s
}

// SetWords sets the Words field's value.
func (s *UpdateVocabularyFilterInput) SetWords(v []*string) *UpdateVocabularyFilterInput {
	s.Words = v
	return s
}

type UpdateVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`

	// The language code of the words in the vocabulary filter.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary filter was updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the updated vocabulary filter.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyFilterOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateVocabularyFilterOutput) SetLanguageCode(v string) *UpdateVocabularyFilterOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateVocabularyFilterOutput) SetLastModifiedTime(v time.Time) *UpdateVocabularyFilterOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *UpdateVocabularyFilterOutput) SetVocabularyFilterName(v string) *UpdateVocabularyFilterOutput {
	s.VocabularyFilterName = &v
	return s
}

type UpdateVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code of the vocabulary entries. For a list of languages and
	// their corresponding language codes, see Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html).
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// An array of strings containing the vocabulary entries.
	Phrases []*string `type:"list"`

	// The S3 location of the text file that contains the definition of the custom
	// vocabulary. The URI must be in the same region as the API endpoint that you
	// are calling. The general form is:
	//
	// https://s3.aws-region.amazonaws.com/bucket-name/keyprefix/objectkey
	//
	// For example:
	//
	// https://s3.us-east-1.amazonaws.com/DOC-EXAMPLE-BUCKET/vocab.txt
	//
	// For more information about S3 object names, see Object Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide.
	//
	// For more information about custom vocabularies, see Custom Vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
	VocabularyFileUri *string `min:"1" type:"string"`

	// The name of the vocabulary to update. The name is case sensitive. If you
	// try to update a vocabulary with the same name as a previous vocabulary you
	// will receive a ConflictException error.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVocabularyInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateVocabularyInput) SetLanguageCode(v string) *UpdateVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetPhrases sets the Phrases field's value.
func (s *UpdateVocabularyInput) SetPhrases(v []*string) *UpdateVocabularyInput {
	s.Phrases = v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *UpdateVocabularyInput) SetVocabularyFileUri(v string) *UpdateVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateVocabularyInput) SetVocabularyName(v string) *UpdateVocabularyInput {
	s.VocabularyName = &v
	return s
}

type UpdateVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The language code of the vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary that was updated.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary. When the VocabularyState field contains
	// READY the vocabulary is ready to be used in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateVocabularyOutput) SetLanguageCode(v string) *UpdateVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateVocabularyOutput) SetLastModifiedTime(v time.Time) *UpdateVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateVocabularyOutput) SetVocabularyName(v string) *UpdateVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *UpdateVocabularyOutput) SetVocabularyState(v string) *UpdateVocabularyOutput {
	s.VocabularyState = &v
	return s
}

// Provides information about a vocabulary filter.
type VocabularyFilterInfo struct {
	_ struct{} `type:"structure"`

	// The language code of the words in the vocabulary filter.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was last updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary filter. The name must be unique in the account
	// that holds the filter.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VocabularyFilterInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VocabularyFilterInfo) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *VocabularyFilterInfo) SetLanguageCode(v string) *VocabularyFilterInfo {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *VocabularyFilterInfo) SetLastModifiedTime(v time.Time) *VocabularyFilterInfo {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *VocabularyFilterInfo) SetVocabularyFilterName(v string) *VocabularyFilterInfo {
	s.VocabularyFilterName = &v
	return s
}

// Provides information about a custom vocabulary.
type VocabularyInfo struct {
	_ struct{} `type:"structure"`

	// The language code of the vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary. If the state is READY you can use
	// the vocabulary in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VocabularyInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VocabularyInfo) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *VocabularyInfo) SetLanguageCode(v string) *VocabularyInfo {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *VocabularyInfo) SetLastModifiedTime(v time.Time) *VocabularyInfo {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *VocabularyInfo) SetVocabularyName(v string) *VocabularyInfo {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *VocabularyInfo) SetVocabularyState(v string) *VocabularyInfo {
	s.VocabularyState = &v
	return s
}

const (
	// BaseModelNameNarrowBand is a BaseModelName enum value
	BaseModelNameNarrowBand = "NarrowBand"

	// BaseModelNameWideBand is a BaseModelName enum value
	BaseModelNameWideBand = "WideBand"
)

// BaseModelName_Values returns all elements of the BaseModelName enum
func BaseModelName_Values() []string {
	return []string{
		BaseModelNameNarrowBand,
		BaseModelNameWideBand,
	}
}

const (
	// CLMLanguageCodeEnUs is a CLMLanguageCode enum value
	CLMLanguageCodeEnUs = "en-US"

	// CLMLanguageCodeHiIn is a CLMLanguageCode enum value
	CLMLanguageCodeHiIn = "hi-IN"

	// CLMLanguageCodeEsUs is a CLMLanguageCode enum value
	CLMLanguageCodeEsUs = "es-US"

	// CLMLanguageCodeEnGb is a CLMLanguageCode enum value
	CLMLanguageCodeEnGb = "en-GB"

	// CLMLanguageCodeEnAu is a CLMLanguageCode enum value
	CLMLanguageCodeEnAu = "en-AU"
)

// CLMLanguageCode_Values returns all elements of the CLMLanguageCode enum
func CLMLanguageCode_Values() []string {
	return []string{
		CLMLanguageCodeEnUs,
		CLMLanguageCodeHiIn,
		CLMLanguageCodeEsUs,
		CLMLanguageCodeEnGb,
		CLMLanguageCodeEnAu,
	}
}

const (
	// CallAnalyticsJobStatusQueued is a CallAnalyticsJobStatus enum value
	CallAnalyticsJobStatusQueued = "QUEUED"

	// CallAnalyticsJobStatusInProgress is a CallAnalyticsJobStatus enum value
	CallAnalyticsJobStatusInProgress = "IN_PROGRESS"

	// CallAnalyticsJobStatusFailed is a CallAnalyticsJobStatus enum value
	CallAnalyticsJobStatusFailed = "FAILED"

	// CallAnalyticsJobStatusCompleted is a CallAnalyticsJobStatus enum value
	CallAnalyticsJobStatusCompleted = "COMPLETED"
)

// CallAnalyticsJobStatus_Values returns all elements of the CallAnalyticsJobStatus enum
func CallAnalyticsJobStatus_Values() []string {
	return []string{
		CallAnalyticsJobStatusQueued,
		CallAnalyticsJobStatusInProgress,
		CallAnalyticsJobStatusFailed,
		CallAnalyticsJobStatusCompleted,
	}
}

const (
	// LanguageCodeAfZa is a LanguageCode enum value
	LanguageCodeAfZa = "af-ZA"

	// LanguageCodeArAe is a LanguageCode enum value
	LanguageCodeArAe = "ar-AE"

	// LanguageCodeArSa is a LanguageCode enum value
	LanguageCodeArSa = "ar-SA"

	// LanguageCodeCyGb is a LanguageCode enum value
	LanguageCodeCyGb = "cy-GB"

	// LanguageCodeDaDk is a LanguageCode enum value
	LanguageCodeDaDk = "da-DK"

	// LanguageCodeDeCh is a LanguageCode enum value
	LanguageCodeDeCh = "de-CH"

	// LanguageCodeDeDe is a LanguageCode enum value
	LanguageCodeDeDe = "de-DE"

	// LanguageCodeEnAb is a LanguageCode enum value
	LanguageCodeEnAb = "en-AB"

	// LanguageCodeEnAu is a LanguageCode enum value
	LanguageCodeEnAu = "en-AU"

	// LanguageCodeEnGb is a LanguageCode enum value
	LanguageCodeEnGb = "en-GB"

	// LanguageCodeEnIe is a LanguageCode enum value
	LanguageCodeEnIe = "en-IE"

	// LanguageCodeEnIn is a LanguageCode enum value
	LanguageCodeEnIn = "en-IN"

	// LanguageCodeEnUs is a LanguageCode enum value
	LanguageCodeEnUs = "en-US"

	// LanguageCodeEnWl is a LanguageCode enum value
	LanguageCodeEnWl = "en-WL"

	// LanguageCodeEsEs is a LanguageCode enum value
	LanguageCodeEsEs = "es-ES"

	// LanguageCodeEsUs is a LanguageCode enum value
	LanguageCodeEsUs = "es-US"

	// LanguageCodeFaIr is a LanguageCode enum value
	LanguageCodeFaIr = "fa-IR"

	// LanguageCodeFrCa is a LanguageCode enum value
	LanguageCodeFrCa = "fr-CA"

	// LanguageCodeFrFr is a LanguageCode enum value
	LanguageCodeFrFr = "fr-FR"

	// LanguageCodeGaIe is a LanguageCode enum value
	LanguageCodeGaIe = "ga-IE"

	// LanguageCodeGdGb is a LanguageCode enum value
	LanguageCodeGdGb = "gd-GB"

	// LanguageCodeHeIl is a LanguageCode enum value
	LanguageCodeHeIl = "he-IL"

	// LanguageCodeHiIn is a LanguageCode enum value
	LanguageCodeHiIn = "hi-IN"

	// LanguageCodeIdId is a LanguageCode enum value
	LanguageCodeIdId = "id-ID"

	// LanguageCodeItIt is a LanguageCode enum value
	LanguageCodeItIt = "it-IT"

	// LanguageCodeJaJp is a LanguageCode enum value
	LanguageCodeJaJp = "ja-JP"

	// LanguageCodeKoKr is a LanguageCode enum value
	LanguageCodeKoKr = "ko-KR"

	// LanguageCodeMsMy is a LanguageCode enum value
	LanguageCodeMsMy = "ms-MY"

	// LanguageCodeNlNl is a LanguageCode enum value
	LanguageCodeNlNl = "nl-NL"

	// LanguageCodePtBr is a LanguageCode enum value
	LanguageCodePtBr = "pt-BR"

	// LanguageCodePtPt is a LanguageCode enum value
	LanguageCodePtPt = "pt-PT"

	// LanguageCodeRuRu is a LanguageCode enum value
	LanguageCodeRuRu = "ru-RU"

	// LanguageCodeTaIn is a LanguageCode enum value
	LanguageCodeTaIn = "ta-IN"

	// LanguageCodeTeIn is a LanguageCode enum value
	LanguageCodeTeIn = "te-IN"

	// LanguageCodeTrTr is a LanguageCode enum value
	LanguageCodeTrTr = "tr-TR"

	// LanguageCodeZhCn is a LanguageCode enum value
	LanguageCodeZhCn = "zh-CN"

	// LanguageCodeZhTw is a LanguageCode enum value
	LanguageCodeZhTw = "zh-TW"

	// LanguageCodeThTh is a LanguageCode enum value
	LanguageCodeThTh = "th-TH"

	// LanguageCodeEnZa is a LanguageCode enum value
	LanguageCodeEnZa = "en-ZA"

	// LanguageCodeEnNz is a LanguageCode enum value
	LanguageCodeEnNz = "en-NZ"
)

// LanguageCode_Values returns all elements of the LanguageCode enum
func LanguageCode_Values() []string {
	return []string{
		LanguageCodeAfZa,
		LanguageCodeArAe,
		LanguageCodeArSa,
		LanguageCodeCyGb,
		LanguageCodeDaDk,
		LanguageCodeDeCh,
		LanguageCodeDeDe,
		LanguageCodeEnAb,
		LanguageCodeEnAu,
		LanguageCodeEnGb,
		LanguageCodeEnIe,
		LanguageCodeEnIn,
		LanguageCodeEnUs,
		LanguageCodeEnWl,
		LanguageCodeEsEs,
		LanguageCodeEsUs,
		LanguageCodeFaIr,
		LanguageCodeFrCa,
		LanguageCodeFrFr,
		LanguageCodeGaIe,
		LanguageCodeGdGb,
		LanguageCodeHeIl,
		LanguageCodeHiIn,
		LanguageCodeIdId,
		LanguageCodeItIt,
		LanguageCodeJaJp,
		LanguageCodeKoKr,
		LanguageCodeMsMy,
		LanguageCodeNlNl,
		LanguageCodePtBr,
		LanguageCodePtPt,
		LanguageCodeRuRu,
		LanguageCodeTaIn,
		LanguageCodeTeIn,
		LanguageCodeTrTr,
		LanguageCodeZhCn,
		LanguageCodeZhTw,
		LanguageCodeThTh,
		LanguageCodeEnZa,
		LanguageCodeEnNz,
	}
}

const (
	// MediaFormatMp3 is a MediaFormat enum value
	MediaFormatMp3 = "mp3"

	// MediaFormatMp4 is a MediaFormat enum value
	MediaFormatMp4 = "mp4"

	// MediaFormatWav is a MediaFormat enum value
	MediaFormatWav = "wav"

	// MediaFormatFlac is a MediaFormat enum value
	MediaFormatFlac = "flac"

	// MediaFormatOgg is a MediaFormat enum value
	MediaFormatOgg = "ogg"

	// MediaFormatAmr is a MediaFormat enum value
	MediaFormatAmr = "amr"

	// MediaFormatWebm is a MediaFormat enum value
	MediaFormatWebm = "webm"
)

// MediaFormat_Values returns all elements of the MediaFormat enum
func MediaFormat_Values() []string {
	return []string{
		MediaFormatMp3,
		MediaFormatMp4,
		MediaFormatWav,
		MediaFormatFlac,
		MediaFormatOgg,
		MediaFormatAmr,
		MediaFormatWebm,
	}
}

const (
	// MedicalContentIdentificationTypePhi is a MedicalContentIdentificationType enum value
	MedicalContentIdentificationTypePhi = "PHI"
)

// MedicalContentIdentificationType_Values returns all elements of the MedicalContentIdentificationType enum
func MedicalContentIdentificationType_Values() []string {
	return []string{
		MedicalContentIdentificationTypePhi,
	}
}

const (
	// ModelStatusInProgress is a ModelStatus enum value
	ModelStatusInProgress = "IN_PROGRESS"

	// ModelStatusFailed is a ModelStatus enum value
	ModelStatusFailed = "FAILED"

	// ModelStatusCompleted is a ModelStatus enum value
	ModelStatusCompleted = "COMPLETED"
)

// ModelStatus_Values returns all elements of the ModelStatus enum
func ModelStatus_Values() []string {
	return []string{
		ModelStatusInProgress,
		ModelStatusFailed,
		ModelStatusCompleted,
	}
}

const (
	// OutputLocationTypeCustomerBucket is a OutputLocationType enum value
	OutputLocationTypeCustomerBucket = "CUSTOMER_BUCKET"

	// OutputLocationTypeServiceBucket is a OutputLocationType enum value
	OutputLocationTypeServiceBucket = "SERVICE_BUCKET"
)

// OutputLocationType_Values returns all elements of the OutputLocationType enum
func OutputLocationType_Values() []string {
	return []string{
		OutputLocationTypeCustomerBucket,
		OutputLocationTypeServiceBucket,
	}
}

const (
	// ParticipantRoleAgent is a ParticipantRole enum value
	ParticipantRoleAgent = "AGENT"

	// ParticipantRoleCustomer is a ParticipantRole enum value
	ParticipantRoleCustomer = "CUSTOMER"
)

// ParticipantRole_Values returns all elements of the ParticipantRole enum
func ParticipantRole_Values() []string {
	return []string{
		ParticipantRoleAgent,
		ParticipantRoleCustomer,
	}
}

const (
	// PiiEntityTypeBankAccountNumber is a PiiEntityType enum value
	PiiEntityTypeBankAccountNumber = "BANK_ACCOUNT_NUMBER"

	// PiiEntityTypeBankRouting is a PiiEntityType enum value
	PiiEntityTypeBankRouting = "BANK_ROUTING"

	// PiiEntityTypeCreditDebitNumber is a PiiEntityType enum value
	PiiEntityTypeCreditDebitNumber = "CREDIT_DEBIT_NUMBER"

	// PiiEntityTypeCreditDebitCvv is a PiiEntityType enum value
	PiiEntityTypeCreditDebitCvv = "CREDIT_DEBIT_CVV"

	// PiiEntityTypeCreditDebitExpiry is a PiiEntityType enum value
	PiiEntityTypeCreditDebitExpiry = "CREDIT_DEBIT_EXPIRY"

	// PiiEntityTypePin is a PiiEntityType enum value
	PiiEntityTypePin = "PIN"

	// PiiEntityTypeEmail is a PiiEntityType enum value
	PiiEntityTypeEmail = "EMAIL"

	// PiiEntityTypeAddress is a PiiEntityType enum value
	PiiEntityTypeAddress = "ADDRESS"

	// PiiEntityTypeName is a PiiEntityType enum value
	PiiEntityTypeName = "NAME"

	// PiiEntityTypePhone is a PiiEntityType enum value
	PiiEntityTypePhone = "PHONE"

	// PiiEntityTypeSsn is a PiiEntityType enum value
	PiiEntityTypeSsn = "SSN"

	// PiiEntityTypeAll is a PiiEntityType enum value
	PiiEntityTypeAll = "ALL"
)

// PiiEntityType_Values returns all elements of the PiiEntityType enum
func PiiEntityType_Values() []string {
	return []string{
		PiiEntityTypeBankAccountNumber,
		PiiEntityTypeBankRouting,
		PiiEntityTypeCreditDebitNumber,
		PiiEntityTypeCreditDebitCvv,
		PiiEntityTypeCreditDebitExpiry,
		PiiEntityTypePin,
		PiiEntityTypeEmail,
		PiiEntityTypeAddress,
		PiiEntityTypeName,
		PiiEntityTypePhone,
		PiiEntityTypeSsn,
		PiiEntityTypeAll,
	}
}

const (
	// RedactionOutputRedacted is a RedactionOutput enum value
	RedactionOutputRedacted = "redacted"

	// RedactionOutputRedactedAndUnredacted is a RedactionOutput enum value
	RedactionOutputRedactedAndUnredacted = "redacted_and_unredacted"
)

// RedactionOutput_Values returns all elements of the RedactionOutput enum
func RedactionOutput_Values() []string {
	return []string{
		RedactionOutputRedacted,
		RedactionOutputRedactedAndUnredacted,
	}
}

const (
	// RedactionTypePii is a RedactionType enum value
	RedactionTypePii = "PII"
)

// RedactionType_Values returns all elements of the RedactionType enum
func RedactionType_Values() []string {
	return []string{
		RedactionTypePii,
	}
}

const (
	// SentimentValuePositive is a SentimentValue enum value
	SentimentValuePositive = "POSITIVE"

	// SentimentValueNegative is a SentimentValue enum value
	SentimentValueNegative = "NEGATIVE"

	// SentimentValueNeutral is a SentimentValue enum value
	SentimentValueNeutral = "NEUTRAL"

	// SentimentValueMixed is a SentimentValue enum value
	SentimentValueMixed = "MIXED"
)

// SentimentValue_Values returns all elements of the SentimentValue enum
func SentimentValue_Values() []string {
	return []string{
		SentimentValuePositive,
		SentimentValueNegative,
		SentimentValueNeutral,
		SentimentValueMixed,
	}
}

const (
	// SpecialtyPrimarycare is a Specialty enum value
	SpecialtyPrimarycare = "PRIMARYCARE"
)

// Specialty_Values returns all elements of the Specialty enum
func Specialty_Values() []string {
	return []string{
		SpecialtyPrimarycare,
	}
}

const (
	// SubtitleFormatVtt is a SubtitleFormat enum value
	SubtitleFormatVtt = "vtt"

	// SubtitleFormatSrt is a SubtitleFormat enum value
	SubtitleFormatSrt = "srt"
)

// SubtitleFormat_Values returns all elements of the SubtitleFormat enum
func SubtitleFormat_Values() []string {
	return []string{
		SubtitleFormatVtt,
		SubtitleFormatSrt,
	}
}

const (
	// TranscriptFilterTypeExact is a TranscriptFilterType enum value
	TranscriptFilterTypeExact = "EXACT"
)

// TranscriptFilterType_Values returns all elements of the TranscriptFilterType enum
func TranscriptFilterType_Values() []string {
	return []string{
		TranscriptFilterTypeExact,
	}
}

const (
	// TranscriptionJobStatusQueued is a TranscriptionJobStatus enum value
	TranscriptionJobStatusQueued = "QUEUED"

	// TranscriptionJobStatusInProgress is a TranscriptionJobStatus enum value
	TranscriptionJobStatusInProgress = "IN_PROGRESS"

	// TranscriptionJobStatusFailed is a TranscriptionJobStatus enum value
	TranscriptionJobStatusFailed = "FAILED"

	// TranscriptionJobStatusCompleted is a TranscriptionJobStatus enum value
	TranscriptionJobStatusCompleted = "COMPLETED"
)

// TranscriptionJobStatus_Values returns all elements of the TranscriptionJobStatus enum
func TranscriptionJobStatus_Values() []string {
	return []string{
		TranscriptionJobStatusQueued,
		TranscriptionJobStatusInProgress,
		TranscriptionJobStatusFailed,
		TranscriptionJobStatusCompleted,
	}
}

const (
	// TypeConversation is a Type enum value
	TypeConversation = "CONVERSATION"

	// TypeDictation is a Type enum value
	TypeDictation = "DICTATION"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeConversation,
		TypeDictation,
	}
}

const (
	// VocabularyFilterMethodRemove is a VocabularyFilterMethod enum value
	VocabularyFilterMethodRemove = "remove"

	// VocabularyFilterMethodMask is a VocabularyFilterMethod enum value
	VocabularyFilterMethodMask = "mask"

	// VocabularyFilterMethodTag is a VocabularyFilterMethod enum value
	VocabularyFilterMethodTag = "tag"
)

// VocabularyFilterMethod_Values returns all elements of the VocabularyFilterMethod enum
func VocabularyFilterMethod_Values() []string {
	return []string{
		VocabularyFilterMethodRemove,
		VocabularyFilterMethodMask,
		VocabularyFilterMethodTag,
	}
}

const (
	// VocabularyStatePending is a VocabularyState enum value
	VocabularyStatePending = "PENDING"

	// VocabularyStateReady is a VocabularyState enum value
	VocabularyStateReady = "READY"

	// VocabularyStateFailed is a VocabularyState enum value
	VocabularyStateFailed = "FAILED"
)

// VocabularyState_Values returns all elements of the VocabularyState enum
func VocabularyState_Values() []string {
	return []string{
		VocabularyStatePending,
		VocabularyStateReady,
		VocabularyStateFailed,
	}
}
