// log1p.testdata
// copyright (C) 2006 Ch. Q. Lauter and V.Lefevre
// This file is part of crlibm and is distributed under the GNU Public Licence
// See file COPYING for details
// The following lines are either comments (beginning with a #)
// or give
//   1/ a rounding mode : RN|RU|RD|RZ (crlibm syntax) or  N|P|M|Z (libmcr syntax)
//   2/ The high and low hexadecimal halves of an input
//   3/ The high and low hexadecimal halves of the expected corresponding output
// Special cases  TODO: VERIFY THIS INDICATIONS
T(RN,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RN,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RU,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RU,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RD,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RD,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RZ,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // zero
T(RZ,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -zero
T(RN,               0x1p-1074,               0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RU,               0x1p-1074,               0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RD,               0x1p-1074,                  0x0p+0,         -0x1p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RZ,               0x1p-1074,                  0x0p+0,         -0x1p+0, INEXACT|UNDERFLOW) // smallest denorm positive
T(RN,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RU,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RD,              -0x1p-1074,              -0x1p-1073,         -0x1p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RZ,              -0x1p-1074,              -0x1p-1074,          0x0p+0, INEXACT|UNDERFLOW) // smallest denorm negative
T(RN,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RN,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RU,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RU,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RD,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RD,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RZ,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RZ,                    -inf,                     nan,          0x0p+0, INVALID) // -inf
T(RN,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RU,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RD,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RZ,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RN,                 -0x1p+0,                    -inf,          0x0p+0, DIVBYZERO) // -inf
T(RU,                 -0x1p+0,                    -inf,          0x0p+0, DIVBYZERO) // -inf
T(RD,                 -0x1p+0,                    -inf,          0x0p+0, DIVBYZERO) // -inf
T(RZ,                 -0x1p+0,                    -inf,          0x0p+0, DIVBYZERO) // -inf
// Very worst case
T(RN,   0x1.7fffffffffffdp-50,   0x1.7fffffffffff9p-50,          0x1p-1, INEXACT) // 1.332267629550187256862679085950e-15
// One in five of the very worst cases computed by Lefevre and Muller.
// Rounding these values requires evaluating the function to at least 2^(-100).
// These worst cases have been selected thanks to the filterlists 5 script
// If you want the full list please contact Jean-Michel Muller
T(RN,    0x1.73e3f48b0f2cep-1,    0x1.178e6d3ecaceap-1,          0x1p-1, INEXACT) // 7.263485355138870058766542570083e-01
T(RZ,    0x1.3ab369100b675p+0,    0x1.9a76ce83e31eap-1,         -0x1p+0, INEXACT) // 1.229300085465550695928982349869e+00
T(RN,    0x1.b4d4e1a763801p+0,    0x1.fdc08685df086p-1,         -0x1p-1, INEXACT) // 1.706373313299536897957864312048e+00
T(RZ,   0x1.1994f4a1185bep-10,   0x1.196e44ad93993p-10,         -0x1p+0, INEXACT) // 1.074149542795374123044238601210e-03
T(RN,   0x1.4959095a41cd6p-10,   0x1.49241df3a6406p-10,          0x1p-1, INEXACT) // 1.256362148127900587452066005767e-03
T(RZ,   0x1.4bb0c524bb556p-10,    0x1.4b7b1868ab96p-10,  -0x1.a63b8p-54, INEXACT) // 1.265298874553030025053024232307e-03
T(RN,   0x1.6b5778b4cd5cbp-10,     0x1.6b1711ca90ep-10,          0x1p-1, INEXACT) // 1.386038534474709092367272766921e-03
T(RZ,   0x1.a7d65289493fbp-10,   0x1.a77eb3f6d31c5p-10, -0x1.c1cc78p-52, INEXACT) // 1.616810596098304823528546414479e-03
T(RN,   0x1.d721b225e9934p-10,   0x1.d6b571b8869a4p-10,          0x1p-1, INEXACT) // 1.797224520012697009108126877663e-03
T(RN,   0x1.6292c4122129bp-11,   0x1.627415f8f4d2dp-11,         -0x1p-1, INEXACT) // 6.762949071946357379112035879132e-04
T(RN,   0x1.ae4e9394e43c3p-11,   0x1.ae216527f0e8ep-11,         -0x1p-1, INEXACT) // 8.207453525860209297623781843356e-04
T(RN,   0x1.b5c5c65de9416p-11,   0x1.b597033aba086p-11,         -0x1p-1, INEXACT) // 8.349848901515490289665377687811e-04
T(RZ,   0x1.77ee701963137p-12,   0x1.77dd30c435f76p-12,  -0x1.43ab8p-53, INEXACT) // 3.585161190009680093858379645866e-04
T(RZ,   0x1.0ce1cb7c44675p-13,   0x1.0cdd61eed6f47p-13, -0x1.33a1b8p-54, INEXACT) // 1.282129341082964351598155738898e-04
T(RN,   0x1.55ad481fbd893p-13,   0x1.55a6283616b93p-13,         -0x1p-1, INEXACT) // 1.629242333291465048752261202125e-04
T(RN,   0x1.a0f7bc7641421p-13,   0x1.a0ed203a1b5ebp-13,         -0x1p-1, INEXACT) // 1.988257024053983253609328984979e-04
T(RZ,   0x1.b6e306015fcb6p-13,   0x1.b6d744b65334dp-13,         -0x1p+0, INEXACT) // 2.092775394366468903577238602765e-04
T(RZ,   0x1.baeb17d0c6b9fp-13,   0x1.badf1efca64d6p-13, -0x1.6a3e2ap-51, INEXACT) // 2.111999188166542660693297817076e-04
T(RN,   0x1.a7b3b0bc59bbap-14,   0x1.a7ae364de707ep-14,          0x1p-1, INEXACT) // 1.010184086617090198998575312217e-04
T(RZ,   0x1.2469599d1274bp-15,   0x1.24680b9e8f55ap-15,         -0x1p+0, INEXACT) // 3.485816999011669999183546386767e-05
T(RN,   0x1.4368719b54798p-15,   0x1.4366d90d4b5bbp-15,          0x1p-1, INEXACT) // 3.855323594827083115085808451283e-05
T(RN,   0x1.5fbf56768b585p-15,   0x1.5fbd732bc2a2ap-15,         -0x1p-1, INEXACT) // 4.193155921359672995982550980365e-05
T(RZ,   0x1.75009effcf05ap-15,   0x1.74fe7f891f7b1p-15,         -0x1p+0, INEXACT) // 4.446535422039715669973586331665e-05
T(RN,   0x1.f90b8b0f92831p-15,   0x1.f907a6bb4420bp-15,          0x1p-1, INEXACT) // 6.020606644747994348450606527656e-05
T(RZ,    0x1.8bf01129f402p-16,   0x1.8beedefbd4a8ep-16,  -0x1.fc432p-51, INEXACT) // 2.359972965121370520186205865798e-05
T(RZ,   0x1.c1e8cd7e76f77p-16,   0x1.c1e742270be46p-16,  -0x1.64185p-54, INEXACT) // 2.681668910918486793313296467911e-05
T(RZ,   0x1.ed665d57e71b1p-16,   0x1.ed6481e093cdcp-16,  -0x1.15172p-56, INEXACT) // 2.940892349522086380978792841123e-05
T(RZ,   0x1.f1f604000a48fp-16,   0x1.f1f41fb3ea54bp-16,         -0x1p+0, INEXACT) // 2.968078842982953147329981680169e-05
T(RZ,    0x1.0b0ca89777a8p-17,   0x1.0b0c62f2b5cc5p-17,         -0x1p+0, INEXACT) // 7.958693727991685354372641825194e-06
T(RN,   0x1.09cf0d5b07098p-17,   0x1.09cec85b8aa3ap-17,         -0x1p-1, INEXACT) // 7.921719477770296983891451514381e-06
T(RZ,   0x1.b107cf25fe539p-17,   0x1.b10718078ad4bp-17,  -0x1.a493ap-54, INEXACT) // 1.290531470131643942977645728165e-05
T(RZ,   0x1.a4392776dc458p-18,   0x1.a438d13d81144p-18,         -0x1p+0, INEXACT) // 6.261814511230699307944153053640e-06
T(RZ,   0x1.35d29f8cc21d6p-19,   0x1.35d2881d62532p-19,         -0x1p+0, INEXACT) // 2.308359347561799491423389224520e-06
T(RN,   0x1.879b923ea7de9p-19,   0x1.879b6ccde3301p-19,          0x1p-1, INEXACT) // 2.917704733221055850229995812239e-06
T(RN,   0x1.d1b533c98d6f7p-19,   0x1.d1b4fed659102p-19,          0x1p-1, INEXACT) // 3.469793658418255000744313473748e-06
T(RZ,   0x1.ee81de74032fbp-19,   0x1.ee81a2c075455p-19,  -0x1.67ceap-53, INEXACT) // 3.684366499007139596379286836103e-06
T(RN,    0x1.02ded9344a6b9p-1,    0x1.a304377b5f242p-2,         -0x1p-1, INEXACT) // 5.056064487773347382315591858060e-01
T(RN,    0x1.03d29d5ad6388p-1,    0x1.a447d406be186p-2,          0x1p-1, INEXACT) // 5.074662373909726298393252363894e-01
T(RZ,    0x1.166ce703b05e9p-1,    0x1.bcab27d05abddp-2,         -0x1p+0, INEXACT) // 5.437996093752960335976354144805e-01
T(RZ,   0x1.3763b4ddcbd83p-20,   0x1.3763a907b12f7p-20,         -0x1p+0, INEXACT) // 1.160016203493323130193737129090e-06
T(RN,   0x1.4c02e413cd1c4p-20,   0x1.4c02d69f11d99p-20,          0x1p-1, INEXACT) // 1.236838447616064831267260887282e-06
T(RZ,   0x1.b069db2e45d5ep-20,   0x1.b069c45b1bf51p-20, -0x1.0d342ap-51, INEXACT) // 1.610865819017880334553969798317e-06
T(RZ,   0x1.e738736e5a541p-20,   0x1.e73856741e035p-20, -0x1.96bf88p-51, INEXACT) // 1.815037844100163598061296356401e-06
T(RN,   0x1.2fb79dff725fcp-21,   0x1.2fb7985e21d48p-21,         -0x1p-1, INEXACT) // 5.657174710290450746544548693562e-07
T(RN,   0x1.62222497541aep-21,   0x1.62221cefca8c5p-21,         -0x1p-1, INEXACT) // 6.596248053690229129437721730667e-07
T(RN,   0x1.87688e26a72d2p-21,   0x1.876884cce545bp-21,          0x1p-1, INEXACT) // 7.290549931152670363028673108929e-07
T(RZ,   0x1.d610bdfdeb506p-21,   0x1.d610b08165e98p-21,         -0x1p+0, INEXACT) // 8.755650353541527736357273289935e-07
T(RN,   0x1.c352796f70134p-22,   0x1.c352733818cbap-22,          0x1p-1, INEXACT) // 4.203265211132230911688896848877e-07
T(RZ,   0x1.8985f158edcfbp-22,   0x1.8985ec9f14d8dp-22,         -0x1p+0, INEXACT) // 3.664970527577610276278262651378e-07
T(RZ,   0x1.9fed4807d0d08p-22,   0x1.9fed42c04a907p-22,  -0x1.d322ep-53, INEXACT) // 3.873620930581012898618904066739e-07
T(RN,   0x1.916c3de290361p-22,   0x1.916c38f7a7bb5p-22,         -0x1p-1, INEXACT) // 3.738541335709014106371934297451e-07
T(RZ,   0x1.9c98b1c8d433bp-22,   0x1.9c98ac96dc9b5p-22,         -0x1p+0, INEXACT) // 3.842603999897838789412223264169e-07
T(RZ,   0x1.a76edd246deedp-22,   0x1.a76ed7abaee95p-22,  -0x1.da0f9p-54, INEXACT) // 3.943527693522588939180611045804e-07
T(RN,   0x1.f18cfc6dec867p-22,   0x1.f18cf4dfe33a1p-22,          0x1p-1, INEXACT) // 4.633802238542775927240596669371e-07
T(RZ,   0x1.1b8628167a965p-23,   0x1.1b8626dc78b53p-23, -0x1.850e8cp-51, INEXACT) // 1.320261737291732486368744112562e-07
T(RN,   0x1.6c3e9d8952207p-23,    0x1.6c3e9b831005p-23,          0x1p-1, INEXACT) // 1.696146052865501312736988505023e-07
T(RN,   0x1.132959861cbdbp-24,   0x1.132958f23bcf9p-24,         -0x1p-1, INEXACT) // 6.406603434028586843071846569295e-08
T(RN,   0x1.abab5e8ff5c0fp-24,   0x1.abab5d2abb326p-24,         -0x1p-1, INEXACT) // 9.957454438713729875396954557484e-08
T(RZ,   0x1.506864c99d2f2p-24,   0x1.506863ec94164p-24,         -0x1p+0, INEXACT) // 7.832604178600877543096295697184e-08
T(RN,   0x1.80ee29b6343f2p-24,   0x1.80ee2894ce92fp-24,          0x1p-1, INEXACT) // 8.962357509195839915055418079676e-08
T(RZ,   0x1.e911c1f0fcef7p-24,   0x1.e911c01dd285bp-24, -0x1.46ececp-53, INEXACT) // 1.138703351747931209234941988227e-07
T(RN,   0x1.ef545be2fee8fp-24,   0x1.ef545a03cb3fcp-24,         -0x1p-1, INEXACT) // 1.153278926107579017170840797978e-07
T(RZ,   0x1.848793d4cde66p-25,   0x1.848793416316bp-25,  -0x1.1e127p-55, INEXACT) // 4.523079836230220816491366274056e-08
T(RZ,   0x1.b84926570c134p-25,   0x1.b8492599bd318p-25,  -0x1.ecba6p-51, INEXACT) // 5.125600626603699591428040752833e-08
T(RZ,   0x1.90d64c0ba1254p-25,   0x1.90d64b6eb98d4p-25,         -0x1p+0, INEXACT) // 4.666357974767911420613654503026e-08
T(RN,   0x1.683f95a93506ep-26,   0x1.683f9569d6aa5p-26,         -0x1p-1, INEXACT) // 2.096921539604090831887124829307e-08
T(RZ,   0x1.3c9e3b2520a3ep-26,   0x1.3c9e3af42dc36p-26,         -0x1p+0, INEXACT) // 1.842959842071438721792248495272e-08
T(RN,   0x1.9b2c9afddd1c3p-26,   0x1.9b2c9aab50141p-26,         -0x1p-1, INEXACT) // 2.393349073739791997960067455441e-08
T(RZ,   0x1.1cdfc20b9c0bbp-27,    0x1.1cdfc1f7cbf8p-27,         -0x1p+0, INEXACT) // 8.290926187970367832418633281723e-09
T(RN,   0x1.465c8596bd0c8p-27,   0x1.465c857cbc102p-27,         -0x1p-1, INEXACT) // 9.498367243320052196008248471953e-09
T(RN,   0x1.3a10b25ed2576p-27,    0x1.3a10b246bd88p-27,          0x1p-1, INEXACT) // 9.140500965186616992391610450434e-09
T(RN,   0x1.efdf7d69d766ap-27,   0x1.efdf7d2dcf461p-27,          0x1p-1, INEXACT) // 1.443180393565191302900688728478e-08
T(RZ,   0x1.cfdf2a7e2d0e8p-28,   0x1.cfdf2a63e8c68p-28,         -0x1p+0, INEXACT) // 6.750222268453456248052223101844e-09
T(RN,   0x1.a2d79fb6d4a46p-28,   0x1.a2d79fa16a7d8p-28,         -0x1p-1, INEXACT) // 6.094957364184896596522856800689e-09
T(RZ,   0x1.b5b7b35f4e7fcp-28,   0x1.b5b7b347eb1a4p-28,         -0x1p+0, INEXACT) // 6.369629129097453832440990629214e-09
T(RZ,   0x1.d3ef28cad019fp-28,   0x1.d3ef28b015867p-28,         -0x1p+0, INEXACT) // 6.809339046451395676234655084244e-09
T(RN,   0x1.37005d07ff3e4p-29,   0x1.37005d0217f6cp-29,          0x1p-1, INEXACT) // 2.262833146553339291892600123202e-09
T(RZ,   0x1.668e898b5c905p-29,   0x1.668e898383c46p-29,         -0x1p+0, INEXACT) // 2.608843979110671039595053928247e-09
T(RN,    0x1.0f4d4b8dc6fcbp-2,    0x1.e155fd91586a3p-3,          0x1p-1, INEXACT) // 2.649432950290672716953110921168e-01
T(RN,   0x1.0685fb0fa7eb5p-30,   0x1.0685fb0d8d7e4p-30,         -0x1p-1, INEXACT) // 9.550544278289493089435074405749e-10
T(RZ,   0x1.3759329957db4p-30,   0x1.3759329662879p-30, -0x1.46fe68p-52, INEXACT) // 1.132678983883741051053279069423e-09
T(RZ,   0x1.b66d39b3c9595p-30,   0x1.b66d39adeba57p-30,  -0x1.e75f3p-51, INEXACT) // 1.594986903790734380581495370510e-09
T(RN,   0x1.c2a20192ee3eep-30,    0x1.c2a2018cbbc3p-30,          0x1p-1, INEXACT) // 1.639392709026790098054429816485e-09
T(RN,   0x1.a69ea31b605cfp-30,   0x1.a69ea315ecfe3p-30,          0x1p-1, INEXACT) // 1.537481425891669875964596507013e-09
T(RN,   0x1.2b4319dd1e166p-32,   0x1.2b4319dc6f2b7p-32,         -0x1p-1, INEXACT) // 2.721773065780856332957195110216e-10
T(RN,   0x1.4e9cabbc730f1p-32,   0x1.4e9cabbb98607p-32,         -0x1p-1, INEXACT) // 3.043278370436311238859870737140e-10
T(RZ,   0x1.671d523ca67dep-32,   0x1.671d523baa9c4p-32, -0x1.846af8p-51, INEXACT) // 3.266127678996291988510761491310e-10
T(RZ,   0x1.da2eb554f2652p-32,   0x1.da2eb5533b3cap-32, -0x1.9164c4p-51, INEXACT) // 4.312664299541642886185998009417e-10
T(RZ,   0x1.038000002bd76p-33,   0x1.037fffffea145p-33, -0x1.e083dcp-53, INEXACT) // 1.180069375596793179731824868496e-10
T(RZ,   0x1.0b0000002e698p-33,   0x1.0affffffe8cb4p-33, -0x1.0d42aep-52, INEXACT) // 1.214175426915999929856821140032e-10
T(RZ,   0x1.12800000310e6p-33,   0x1.127fffffe778dp-33,  -0x1.2cd03p-52, INEXACT) // 1.248281478235284228164244257913e-10
T(RZ,    0x1.1a00000033c6p-33,    0x1.19ffffffe61dp-33, -0x1.4f0fa4p-52, INEXACT) // 1.282387529554646074654094222139e-10
T(RZ,   0x1.308000003c5d6p-33,   0x1.307fffffe1d15p-33,  -0x1.c77cep-52, INEXACT) // 1.384705683513196903218205192882e-10
T(RZ,   0x1.4e80000048d86p-33,   0x1.4e7fffffdb93dp-33, -0x1.4ba6cep-51, INEXACT) // 1.521129888792350349190995669363e-10
T(RZ,   0x1.6c800000567f6p-33,   0x1.6c7fffffd4c05p-33, -0x1.d39d3ep-51, INEXACT) // 1.657554094072744566082615687357e-10
T(RZ,   0x1.29000000396d8p-33,   0x1.28ffffffe3494p-33, -0x1.9c3e3ap-52, INEXACT) // 1.350599632193602412181074689623e-10
T(RZ,   0x1.2180000036906p-33,   0x1.217fffffe4b7dp-33, -0x1.74273cp-52, INEXACT) // 1.316493580874085469326371032709e-10
T(RZ,   0x1.6500000052f98p-33,   0x1.64ffffffd6834p-33, -0x1.ae4c92p-51, INEXACT) // 1.623448042752529689586070413341e-10
T(RZ,   0x1.3f80000042756p-33,   0x1.3f7fffffdec55p-33, -0x1.140bb4p-51, INEXACT) // 1.452917786152618529839746738434e-10
T(RZ,   0x1.47000000459d8p-33,   0x1.46ffffffdd314p-33, -0x1.2ee47ep-51, INEXACT) // 1.487023837472445665424157780726e-10
T(RZ,     0x1.380000003f6p-33,     0x1.37ffffffe05p-33, -0x1.f60c7ep-52, INEXACT) // 1.418811734832868942437762542486e-10
T(RZ,    0x1.740000005a18p-33,    0x1.73ffffffd2f4p-33, -0x1.fb4e24p-51, INEXACT) // 1.691660145393036990761587807716e-10
T(RZ,    0x1.560000004c26p-33,    0x1.55ffffffd9edp-33, -0x1.6a695ap-51, INEXACT) // 1.555235940112332581140260404345e-10
T(RZ,   0x1.5d8000004f866p-33,   0x1.5d7fffffd83cdp-33, -0x1.8b435cp-51, INEXACT) // 1.589341991432392361271951985671e-10
T(RZ,   0x1.a12834167211ep-33,   0x1.a1283415c820dp-33,         -0x1p+0, INEXACT) // 1.897010610241033580918743058590e-10
T(RN,   0x1.a2d71846f1611p-33,   0x1.a2d7184646104p-33,         -0x1p-1, INEXACT) // 1.904664778473775628424014782529e-10
T(RN,   0x1.cef5524370418p-33,   0x1.cef552429ef2ep-33,         -0x1p-1, INEXACT) // 2.105290543524237950547882975284e-10
T(RZ,   0x1.c3bb9724cd70ep-33,   0x1.c3bb972406294p-33, -0x1.fa6038p-51, INEXACT) // 2.054242827492765129943874822860e-10
T(RN,   0x1.00800000156abp-34,   0x1.007ffffff54abp-34,          0x1p-1, INEXACT) // 5.832134775232281645747358686286e-11
T(RZ,     0x1.0800000016bp-34,    0x1.07fffffff4a8p-34,  -0x1.015c7p-55, INEXACT) // 6.002665031821432995181957430891e-11
T(RN,   0x1.1e8000001ab83p-34,   0x1.1e7ffffff2a3fp-34,          0x1p-1, INEXACT) // 6.514255801590050266222156359876e-11
T(RN,   0x1.0f80000017febp-34,   0x1.0f7ffffff400bp-34,          0x1p-1, INEXACT) // 6.173195288410778215072623291358e-11
T(RZ,   0x1.170000001956cp-34,   0x1.16fffffff354ap-34,  -0x1.41077p-55, INEXACT) // 6.343725545000317305419356267687e-11
T(RZ,   0x1.350000001f14cp-34,   0x1.34fffffff075ap-34,  -0x1.e3041p-55, INEXACT) // 7.025846571360412371366959331613e-11
T(RN,   0x1.4b80000023c5bp-34,   0x1.4b7fffffee1d3p-34,          0x1p-1, INEXACT) // 7.537437341132519310616366346102e-11
T(RZ,    0x1.260000001c23p-34,   0x1.25fffffff1ee8p-34,  -0x1.8bd66p-55, INEXACT) // 6.684786058179977097481023567927e-11
T(RN,   0x1.3c800000209bbp-34,   0x1.3c7fffffefb23p-34,          0x1p-1, INEXACT) // 7.196376827950920813994027887248e-11
T(RN,   0x1.2d8000001d973p-34,   0x1.2d7ffffff1347p-34,          0x1p-1, INEXACT) // 6.855316314770097799195957891840e-11
T(RN,   0x1.3e110127ea79cp-34,    0x1.3e110127b914p-34,          0x1p-1, INEXACT) // 7.231993183449124224698169250065e-11
T(RZ,   0x1.530000002568cp-34,   0x1.52ffffffed4bap-34,  -0x1.5ddc9p-54, INEXACT) // 7.707967597723609364611636249321e-11
T(RZ,    0x1.44000000222cp-34,    0x1.43ffffffeeeap-34,  -0x1.23edep-54, INEXACT) // 7.366907084541623127077163558744e-11
T(RN,   0x1.788000002e24bp-34,   0x1.787fffffe8edbp-34,          0x1p-1, INEXACT) // 8.560618880681967691428992503334e-11
T(RN,   0x1.f0800000503ebp-34,   0x1.f07fffffd7e0bp-34,          0x1p-1, INEXACT) // 1.128910298618128457386380798087e-10
T(RZ,    0x1.bc000000402cp-34,    0x1.bbffffffdfeap-34, -0x1.016078p-52, INEXACT) // 1.009539119001922651843246205982e-10
T(RZ,   0x1.710000002c52cp-34,   0x1.70ffffffe9d6ap-34, -0x1.eb2328p-54, INEXACT) // 8.390088624089908285153387020809e-11
T(RZ,   0x1.8f00000033d2cp-34,   0x1.8effffffe616ap-34, -0x1.4fb4bcp-53, INEXACT) // 9.072209650459309132992211646078e-11
T(RZ,    0x1.9e00000037cbp-34,   0x1.9dffffffe41a8p-34, -0x1.851b5cp-53, INEXACT) // 9.413270163645172779648026653880e-11
T(RN,   0x1.b48000003e05bp-34,   0x1.b47fffffe0fd3p-34,          0x1p-1, INEXACT) // 9.924860933425422278052252534543e-11
T(RN,   0x1.8780000031e4bp-34,   0x1.877fffffe70dbp-34,          0x1p-1, INEXACT) // 8.901679393866668115348404815968e-11
T(RN,   0x1.9680000035ca3p-34,   0x1.967fffffe51afp-34,          0x1p-1, INEXACT) // 9.242739907052144021092085592048e-11
T(RZ,   0x1.cb0000004494cp-34,   0x1.caffffffddb5ap-34, -0x1.25f5c6p-52, INEXACT) // 1.043645170320741661056108245796e-10
T(RN,   0x1.5a80000027153p-34,   0x1.5a7fffffec757p-34,          0x1p-1, INEXACT) // 7.878497854314893289062973268401e-11
T(RN,   0x1.d280000046d73p-34,   0x1.d27fffffdc947p-34,          0x1p-1, INEXACT) // 1.060698195980180246230949333082e-10
T(RN,   0x1.c3800000425bbp-34,   0x1.c37fffffded23p-34,          0x1p-1, INEXACT) // 1.026592144661322462926873870096e-10
T(RZ,       0x1.800000003p-34,      0x1.7fffffffe8p-34, -0x1.1ffffcp-53, INEXACT) // 8.731149137274220968160665101720e-11
T(RZ,   0x1.ad0000003be8cp-34,   0x1.acffffffe20bap-34,  -0x1.c0a38p-53, INEXACT) // 9.754330676831811908128110125127e-11
T(RN,   0x1.a580000039d53p-34,   0x1.a57fffffe3157p-34,          0x1p-1, INEXACT) // 9.583800420238395408660034831573e-11
T(RZ,    0x1.da0000004923p-34,   0x1.d9ffffffdb6e8p-34, -0x1.4e4facp-52, INEXACT) // 1.077751221639638218451397131954e-10
T(RZ,   0x1.ed84bbc382f28p-34,   0x1.ed84bbc30c056p-34,         -0x1p+0, INEXACT) // 1.122131129811689231340448854679e-10
T(RZ,   0x1.e90000004dd6cp-34,   0x1.e8ffffffd914ap-34, -0x1.7aae3ap-52, INEXACT) // 1.111857272958612324029112864457e-10
T(RN,   0x1.ff800000552abp-34,   0x1.ff7fffffd56abp-34,          0x1p-1, INEXACT) // 1.163016349937218885237736800107e-10
T(RN,   0x1.e18000004b783p-34,   0x1.e17fffffda43fp-34,          0x1p-1, INEXACT) // 1.094804247299115577717451642412e-10
T(RZ,    0x1.6200000028cbp-34,   0x1.61ffffffeb9a8p-34, -0x1.a00438p-54, INEXACT) // 8.049028110906371083970377403342e-11
T(RN,   0x1.698000002a8a3p-34,   0x1.697fffffeabafp-34,          0x1p-1, INEXACT) // 8.219558367498042749333848654145e-11
T(RZ,     0x1.f800000052bp-34,    0x1.f7ffffffd6a8p-34, -0x1.ab538ep-52, INEXACT) // 1.145963324277663977789255443304e-10
T(RZ,   0x1.0b0000000b9a6p-35,   0x1.0afffffffa32dp-35,  -0x1.0d428p-58, INEXACT) // 3.035438567197860951691595365841e-11
T(RZ,   0x1.1a0000000cf18p-35,   0x1.19fffffff9874p-35,  -0x1.4f0f8p-58, INEXACT) // 3.205968823783832825646693410321e-11
T(RZ,   0x1.170000000cab6p-35,   0x1.16fffffff9aa5p-35,   -0x1.4107p-58, INEXACT) // 3.171862772466622941219188432156e-11
T(RZ,    0x1.080000000b58p-35,    0x1.07fffffffa54p-35,   -0x1.015cp-58, INEXACT) // 3.001332515880689841355303810848e-11
T(RZ,   0x1.260000000e118p-35,   0x1.25fffffff8f74p-35,   -0x1.8bd6p-58, INEXACT) // 3.342393029052749911539140169326e-11
T(RZ,   0x1.290000000e5b6p-35,   0x1.28fffffff8d25p-35,   -0x1.9c3ep-58, INEXACT) // 3.376499080369998570057858570663e-11
T(RZ,    0x1.380000000fd8p-35,    0x1.37fffffff814p-35,   -0x1.f60cp-58, INEXACT) // 3.547029336956358184925090846866e-11
T(RZ,   0x1.350000000f8a6p-35,   0x1.34fffffff83adp-35,   -0x1.e304p-58, INEXACT) // 3.512923285639070752315159022356e-11
T(RZ,   0x1.5300000012b46p-35,   0x1.52fffffff6a5dp-35,  -0x1.5ddc8p-57, INEXACT) // 3.853983798812294045235398076002e-11
T(RZ,    0x1.440000001116p-35,    0x1.43fffffff775p-35,  -0x1.23edcp-57, INEXACT) // 3.683453542225585463547244991249e-11
T(RZ,    0x1.740000001686p-35,    0x1.73fffffff4bdp-35,   -0x1.fb4ep-57, INEXACT) // 4.229150363303735348954691110291e-11
T(RZ,   0x1.4700000011676p-35,   0x1.46fffffff74c5p-35,  -0x1.2ee44p-57, INEXACT) // 3.717559593542911670248390238930e-11
T(RZ,   0x1.6500000014be6p-35,   0x1.64fffffff5a0dp-35,  -0x1.ae4c8p-57, INEXACT) // 4.058620106716600252263190370643e-11
T(RZ,   0x1.6200000014658p-35,   0x1.61fffffff5cd4p-35,   -0x1.a004p-57, INEXACT) // 4.024514055399196497379618276617e-11
T(RZ,   0x1.5600000013098p-35,   0x1.55fffffff67b4p-35,  -0x1.6a694p-57, INEXACT) // 3.888089850129659026027756746856e-11
T(RZ,   0x1.7100000016296p-35,   0x1.70fffffff4eb5p-35,   -0x1.eb23p-57, INEXACT) // 4.195044311986292819979905593093e-11
T(RZ,   0x1.9e0000001be58p-35,   0x1.9dfffffff20d4p-35,  -0x1.851b4p-56, INEXACT) // 4.706635081748745010517170237689e-11
T(RZ,   0x1.8300000018606p-35,   0x1.82fffffff3cfdp-35,  -0x1.291b2p-56, INEXACT) // 4.399680619891064316102258965801e-11
T(RZ,   0x1.920000001a4d8p-35,   0x1.91fffffff2d94p-35,  -0x1.59eaap-56, INEXACT) // 4.570210876478587153705893937172e-11
T(RZ,   0x1.8f00000019e96p-35,   0x1.8efffffff30b5p-35,  -0x1.4fb4ap-56, INEXACT) // 4.536104825161067076548681573629e-11
T(RZ,      0x1.8000000018p-35,      0x1.7ffffffff4p-35,  -0x1.1fffep-56, INEXACT) // 4.365574568573583013036260025430e-11
T(RZ,     0x1.b00000001e6p-35,     0x1.affffffff0dp-35,  -0x1.cd51ep-56, INEXACT) // 4.911271389654214440281365227498e-11
T(RZ,   0x1.ad0000001df46p-35,   0x1.acfffffff105dp-35,  -0x1.c0a38p-56, INEXACT) // 4.877165338336616814941726017610e-11
T(RZ,   0x1.a10000001c4d6p-35,   0x1.a0fffffff1d95p-35,  -0x1.90822p-56, INEXACT) // 4.740741133066303861765596024404e-11
T(RZ,    0x1.bc0000002016p-35,    0x1.bbffffffeff5p-35,  -0x1.01607p-55, INEXACT) // 5.047695594924682489822348913392e-11
T(RZ,   0x1.bf00000020856p-35,   0x1.beffffffefbd5p-35,  -0x1.08675p-55, INEXACT) // 5.081801646242318889253201546452e-11
T(RZ,   0x1.dd00000025086p-35,   0x1.dcffffffed7bdp-35,   -0x1.56dbp-55, INEXACT) // 5.422862159419109398565075531946e-11
T(RZ,   0x1.cb000000224a6p-35,   0x1.caffffffeedadp-35,  -0x1.25f5cp-55, INEXACT) // 5.218225851512942035159038925036e-11
T(RZ,   0x1.ce00000022bd8p-35,   0x1.cdffffffeea14p-35,  -0x1.2db89p-55, INEXACT) // 5.252331902830617208681104981268e-11
T(RZ,   0x1.e900000026eb6p-35,   0x1.e8ffffffec8a5p-35,  -0x1.7aae3p-55, INEXACT) // 5.559286364690042737200620295908e-11
T(RZ,   0x1.fb00000029d66p-35,   0x1.faffffffeb14dp-35,  -0x1.b5979p-55, INEXACT) // 5.763922672596675389701217980884e-11
T(RZ,   0x1.da00000024918p-35,   0x1.d9ffffffedb74p-35,  -0x1.4e4fap-55, INEXACT) // 5.388756108101395450951796052541e-11
T(RZ,    0x1.ec0000002766p-35,    0x1.ebffffffec4dp-35,  -0x1.840f2p-55, INEXACT) // 5.593392416007795458905113198484e-11
T(RZ,    0x1.f80000002958p-35,    0x1.f7ffffffeb54p-35,  -0x1.ab538p-55, INEXACT) // 5.729816621278883893905511655135e-11
T(RN,   0x1.fb7bc67a4663ep-35,   0x1.fb7bc67a0783bp-35,          0x1p-1, INEXACT) // 5.769419400148649611273489145233e-11
T(RN,   0x1.232dbb4e97c2dp-36,   0x1.232dbb4e8d695p-36,          0x1p-1, INEXACT) // 1.655158935864458204086942046997e-11
T(RZ,   0x1.3e486bad9e68cp-36,    0x1.3e486bad920bp-36, -0x1.85c7c6p-51, INEXACT) // 1.809228780524084327850574940158e-11
T(RN,   0x1.479addad434dfp-36,    0x1.479addad3634p-36,         -0x1p-1, INEXACT) // 1.862218511062433751196219974027e-11
T(RN,   0x1.e1ec14d56278bp-36,   0x1.e1ec14d5461eep-36,         -0x1p-1, INEXACT) // 2.739410506902105196775793097626e-11
T(RZ,   0x1.ded1c2fabb6b4p-36,   0x1.ded1c2fa9f6e9p-36,         -0x1p+0, INEXACT) // 2.721773065558614874349217513776e-11
T(RZ,    0x1.0800000002d6p-37,    0x1.07fffffffe95p-37,    -0x1.014p-64, INEXACT) // 7.503331289645424622946369080999e-12
T(RZ,   0x1.2600000003846p-37,   0x1.25fffffffe3ddp-37,    -0x1.8bcp-64, INEXACT) // 8.355982572562052334095278645868e-12
T(RZ,   0x1.0e00000002f76p-37,   0x1.0dfffffffe845p-37,    -0x1.198p-64, INEXACT) // 7.673861546228711391084937570800e-12
T(RZ,   0x1.2c00000003a98p-37,   0x1.2bfffffffe2b4p-37,    -0x1.ad2p-64, INEXACT) // 8.526512829145436037461880693600e-12
T(RZ,   0x1.4400000004458p-37,   0x1.43fffffffddd4p-37,    -0x1.23ep-63, INEXACT) // 9.208633855479164721384356000390e-12
T(RZ,   0x1.3e486bad9a498p-37,   0x1.3e486bad941aap-37, -0x1.8561d2p-52, INEXACT) // 9.046143902593144066084231499106e-12
T(RZ,   0x1.8600000006306p-37,   0x1.85fffffffce7dp-37,   -0x1.3268p-62, INEXACT) // 1.108446667789851803343371679992e-11
T(RZ,   0x1.a4000000072d8p-37,   0x1.a3fffffffc694p-37,   -0x1.9c28p-62, INEXACT) // 1.193711796081718138437133108133e-11
T(RZ,   0x1.9e00000006f96p-37,   0x1.9dfffffffc835p-37,   -0x1.8518p-62, INEXACT) // 1.176658770423340994009259480188e-11
T(RZ,   0x1.6200000005196p-37,   0x1.61fffffffd735p-37,      -0x1.ap-63, INEXACT) // 1.006128513839676178481360114457e-11
T(RZ,   0x1.b1ba5fdf153eap-37,   0x1.b1ba5fdf09c34p-37, -0x1.8c0018p-52, INEXACT) // 1.232729190922279721674326443798e-11
T(RZ,      0x1.8000000006p-37,      0x1.7ffffffffdp-37,   -0x1.1ff8p-62, INEXACT) // 1.091393642131484352438301407839e-11
T(RZ,    0x1.680000000546p-37,    0x1.67fffffffd5dp-37,    -0x1.bcfp-63, INEXACT) // 1.023181539498033935863627030816e-11
T(RZ,   0x1.c2000000083d6p-37,   0x1.c1fffffffbe15p-37,    -0x1.0f9p-61, INEXACT) // 1.278976924373632941144911315240e-11
T(RZ,   0x1.bc00000008058p-37,   0x1.bbfffffffbfd4p-37,    -0x1.016p-61, INEXACT) // 1.261923898715246103194234331501e-11
T(RZ,   0x1.fe0000000a956p-37,   0x1.fdfffffffab55p-37,   -0x1.c008p-61, INEXACT) // 1.449507180957607949402518066349e-11
T(RZ,    0x1.f80000000a56p-37,    0x1.f7fffffffad5p-37,    -0x1.ab5p-61, INEXACT) // 1.432454155299201724406234371024e-11
T(RZ,   0x1.4a000000046e6p-37,   0x1.49fffffffdc8dp-37,    -0x1.3a2p-63, INEXACT) // 9.379164112062645359978991606053e-12
T(RZ,   0x1.da00000009246p-37,   0x1.d9fffffffb6ddp-37,   -0x1.4e4cp-61, INEXACT) // 1.347189027007199679993225961780e-11
T(RZ,     0x1.e0000000096p-37,     0x1.dffffffffb5p-37,   -0x1.5f8cp-61, INEXACT) // 1.364242052665596211466706301312e-11
T(RZ,   0x1.fffeffffcaaa8p-37,   0x1.fffeffffbaaa8p-37,         -0x1p+0, INEXACT) // 1.455180420571145458806493378187e-11
T(RZ,   0x1.126a6e21ed399p-38,   0x1.126a6e21eaed4p-38, -0x1.1d66bep-52, INEXACT) // 3.899682255180655487302893380281e-12
T(RZ,   0x1.031b2d07a6a98p-38,   0x1.031b2d07a49cfp-38,         -0x1p+0, INEXACT) // 3.682119936620784587350772834707e-12
T(RZ,   0x1.6b9d7c83e7113p-38,   0x1.6b9d7c83e3083p-38,         -0x1p+0, INEXACT) // 5.167282512301365588319903302497e-12
T(RZ,   0x1.54a57d5f4fd1dp-38,   0x1.54a57d5f4c473p-38,         -0x1p+0, INEXACT) // 4.840877128908381768722517906973e-12
T(RN,   0x1.c7c8f83032645p-38,   0x1.c7c8f8302c0d6p-38,          0x1p-1, INEXACT) // 6.477094942915232637243364568877e-12
T(RN,   0x1.f5732c80871c5p-38,   0x1.f5732c807f6fep-38,          0x1p-1, INEXACT) // 7.126031644554177094790025335173e-12
T(RZ,   0x1.0992327adfd26p-39,   0x1.0992327adebedp-39,         -0x1p+0, INEXACT) // 1.886996036854301593737337278072e-12
T(RZ,   0x1.2f50a5010aa6cp-39,   0x1.2f50a501093f5p-39,         -0x1p+0, INEXACT) // 2.155182825179337569590032025763e-12
T(RN,   0x1.3e486bad97321p-39,   0x1.3e486bad95a66p-39,          0x1p-1, INEXACT) // 2.261535975643171471551937274461e-12
T(RN,   0x1.6b9d7c83e5b8ep-39,   0x1.6b9d7c83e3b46p-39,         -0x1p-1, INEXACT) // 2.583641256148457726779798023582e-12
T(RZ,   0x1.8e5b4bb850455p-39,   0x1.8e5b4bb84dd96p-39,         -0x1p+0, INEXACT) // 2.830494055282342579116780757438e-12
T(RZ,     0x1.538ea18a4585p-4,    0x1.46370d915991ap-4,         -0x1p+0, INEXACT) // 8.289969541178376921664039400639e-02
T(RN,    0x1.60713aadd0422p-4,    0x1.5218b7618c50fp-4,         -0x1p-1, INEXACT) // 8.604548379391066537102972233697e-02
T(RZ,    0x1.ad5acd79cab54p-4,    0x1.984f5feb68f6cp-4, -0x1.202eb8p-51, INEXACT) // 1.048229242702921060192977620318e-01
T(RZ,    0x1.ae44c6d5f3942p-4,    0x1.992320e39c4d4p-4, -0x1.baed1cp-52, INEXACT) // 1.050460593243985052414046776903e-01
T(RN,    0x1.0c63f66eaddb6p-3,    0x1.f868667d334adp-4,          0x1p-1, INEXACT) // 1.310500385786618759986765780923e-01
T(RZ,   0x1.153e5af20e75bp-40,   0x1.153e5af20ddf9p-40,  -0x1.8a637p-54, INEXACT) // 9.849670420390535448028413380566e-13
T(RN,   0x1.1400000000633p-40,   0x1.13ffffffffce7p-40,          0x1p-1, INEXACT) // 9.805489753492587485998374401660e-13
T(RZ,    0x1.500000000093p-40,   0x1.4fffffffffb68p-40,      -0x1.4p-72, INEXACT) // 1.193711796077443294880853203391e-12
T(RZ,   0x1.47da8739b4b91p-40,   0x1.47da8739b3e72p-40, -0x1.521408p-51, INEXACT) // 1.164770061294241610448128947777e-12
T(RZ,   0x1.f4b82ffeb7c3fp-40,   0x1.f4b82ffeb5da4p-40, -0x1.127804p-51, INEXACT) // 1.778912954170592976609574709871e-12
T(RN,   0x1.8c00000000cc3p-40,   0x1.8bffffffff99fp-40,          0x1p-1, INEXACT) // 1.406874616805658133420629453470e-12
T(RZ,    0x1.a291a9605e38p-40,   0x1.a291a9605ce1cp-40,         -0x1p+0, INEXACT) // 1.487055778885826644654823628494e-12
T(RZ,   0x1.c8000000010ecp-40,   0x1.c7ffffffff78ap-40,     -0x1.18p-70, INEXACT) // 1.620037437533903264219166190402e-12
T(RN,   0x1.c4b518e3a0ad1p-40,   0x1.c4b518e39f1ccp-40,         -0x1p-1, INEXACT) // 1.608339811655675669133517377738e-12
T(RN,   0x1.10ff87f865558p-41,   0x1.10ff87f8650cbp-41,         -0x1p-1, INEXACT) // 4.849421637446287267233156688275e-13
T(RN,   0x1.1b59f38384b0ap-41,   0x1.1b59f38384623p-41,         -0x1p-1, INEXACT) // 5.033331475609602590640593246463e-13
T(RZ,   0x1.6ede29b026029p-41,   0x1.6ede29b0257f2p-41, -0x1.974598p-53, INEXACT) // 6.516881676248312835891069366082e-13
T(RN,   0x1.b4ada9be933cep-41,   0x1.b4ada9be9282bp-41,          0x1p-1, INEXACT) // 7.756966115559925255441484858489e-13
T(RZ,   0x1.e93e8b71a5c72p-41,   0x1.e93e8b71a4dd5p-41,         -0x1p+0, INEXACT) // 8.690724855242185968054251931834e-13
T(RN,   0x1.eda3b93204dc4p-41,   0x1.eda3b93203ee4p-41,         -0x1p-1, INEXACT) // 8.768799812616742174004475457850e-13
T(RZ,    0x1.20000000001bp-42,   0x1.1ffffffffff28p-42,          0x0p+0, INEXACT) // 2.557953848736578773399122868625e-13
T(RN,   0x1.42b04eefd91fcp-42,   0x1.42b04eefd8ecep-42,         -0x1p-1, INEXACT) // 2.866051436015571795650472841148e-13
T(RZ,   0x1.2ae79842f2a29p-42,   0x1.2ae79842f276fp-42, -0x1.b59b08p-53, INEXACT) // 2.654806748448529779982104964393e-13
T(RN,   0x1.466f6f4f6cc9ep-42,   0x1.466f6f4f6c95dp-42,         -0x1p-1, INEXACT) // 2.899327819691441274882117305455e-13
T(RN,   0x1.68000000002a3p-42,   0x1.67ffffffffeafp-42,          0x1p-1, INEXACT) // 3.197442310920791624331114681202e-13
T(RN,   0x1.987866b491005p-42,   0x1.987866b490aedp-42,         -0x1p-1, INEXACT) // 3.627945207887616537665013362992e-13
T(RZ,    0x1.e0000000004bp-42,   0x1.dfffffffffda8p-42,          0x0p+0, INEXACT) // 4.263256414561206960401955342535e-13
T(RN,   0x1.9800000000363p-42,   0x1.97ffffffffe4fp-42,          0x1p-1, INEXACT) // 3.623767952376948671081822799679e-13
T(RZ,   0x1.007fe00ff611bp-43,   0x1.007fe00ff601ap-43,  -0x1.97eb4p-51, INEXACT) // 1.139086659085962057323943740790e-13
T(RZ,   0x1.55aaa002a9df2p-44,   0x1.55aaa002a9d0dp-44,         -0x1p+0, INEXACT) // 7.586520391123188196882816167715e-14
T(RZ,   0x1.938130889792fp-45,   0x1.938130889788fp-45,         -0x1p+0, INEXACT) // 4.479801494354759888978379773847e-14
T(RN,    0x1.95674bf3eccep-45,   0x1.95674bf3ecc3fp-45,         -0x1p-1, INEXACT) // 4.500883029592769931990229655293e-14
T(RZ,   0x1.58a68a4a8da1ap-46,   0x1.58a68a4a8d9dfp-46,         -0x1p+0, INEXACT) // 1.913194867290193591587299055691e-14
T(RN,   0x1.b0e35269b3932p-46,   0x1.b0e35269b38d6p-46,         -0x1p-1, INEXACT) // 2.403010991697270398937161976167e-14
T(RN,   0x1.6cdb2bbb21301p-47,   0x1.6cdb2bbb212e1p-47,          0x1p-1, INEXACT) // 1.012679207245474289699550913039e-14
T(RZ,   0x1.a3ad12a1da17dp-47,   0x1.a3ad12a1da151p-47,         -0x1p+0, INEXACT) // 1.164835077159058961118798724996e-14
T(RN,   0x1.4c8dc2e423989p-48,   0x1.4c8dc2e42397bp-48,         -0x1p-1, INEXACT) // 4.615110447320560653516707391386e-15
T(RZ,   0x1.800000000000cp-48,   0x1.7fffffffffffap-48,          0x0p+0, INEXACT) // 5.329070518200760860364294658978e-15
T(RN,   0x1.0f876ccdf6cdcp-49,   0x1.0f876ccdf6cd8p-49,          0x1p-1, INEXACT) // 1.884110950420531087534796688797e-15
T(RN,    0x1.392d659ba6cfbp-5,    0x1.3356de185241ap-5,         -0x1p-1, INEXACT) // 3.822965474429370485998092021873e-02
T(RN,    0x1.92206419a8e93p-5,    0x1.88917e9ae7a45p-5,          0x1p-1, INEXACT) // 4.908771086527709964775212370114e-02
T(RN,    0x1.dc3f0bb921988p-5,     0x1.ceeac29095cfp-5,         -0x1p-1, INEXACT) // 5.813553132707044435179000174685e-02
T(RZ,    0x1.ed34eebd3f9fep-5,     0x1.deee168763efp-5,         -0x1p+0, INEXACT) // 6.020590428123638593316258038612e-02
T(RZ,   0x1.0000000000002p-50,   0x1.fffffffffffffp-51,         -0x1p+0, INEXACT) // 8.881784197001256267693579449786e-16
T(RN,   0x1.1e3779b97f4aap-50,   0x1.1e3779b97f4a7p-50,         -0x1p-1, INEXACT) // 9.930136612989096415082357094424e-16
T(RZ,    0x1.3988e1409213p-50,   0x1.3988e1409212dp-50, -0x1.323758p-51, INEXACT) // 1.087791964408414977289597287194e-15
T(RN,   0x1.52a7fa9d2f8ecp-50,   0x1.52a7fa9d2f8e9p-50,          0x1p-1, INEXACT) // 1.174949609190441714700943742296e-15
T(RN,   0x1.a887293fd6f38p-50,   0x1.a887293fd6f32p-50,         -0x1p-1, INEXACT) // 1.472877282518059865496701187112e-15
T(RZ,   0x1.deeea11683f4ep-50,   0x1.deeea11683f46p-50,         -0x1p+0, INEXACT) // 1.661629672422090719914417451770e-15
T(RN,   0x1.3988e14092131p-51,   0x1.3988e1409212fp-51,         -0x1p-1, INEXACT) // 5.438959822042075872524117962235e-16
T(RZ,   0x1.6a09e667f3bcep-51,   0x1.6a09e667f3bcbp-51,         -0x1p+0, INEXACT) // 6.280369834735101652963725910129e-16
T(RN,   0x1.94c583ada5b53p-51,   0x1.94c583ada5b51p-51,          0x1p-1, INEXACT) // 7.021666937153402449716262382570e-16
T(RZ,   0x1.bb67ae8584cacp-51,   0x1.bb67ae8584ca9p-51,  -0x1.90c8fp-52, INEXACT) // 7.691850745534257237715776038820e-16
T(RN,    0x1.1f8aada39e276p-6,    0x1.1d0c32c998afdp-6,          0x1p-1, INEXACT) // 1.755015332170947045531406160990e-02
T(RN,    0x1.8f8dd9f2c5482p-7,    0x1.8d234471cad4cp-7,         -0x1p-1, INEXACT) // 1.219342367179821265410488706493e-02
T(RN,    0x1.6020aedc92d72p-8,    0x1.5f2f5f1915187p-8,         -0x1p-1, INEXACT) // 5.373041811775324319566671249504e-03
T(RN,    0x1.87614309f34b9p-8,    0x1.8637457b2af97p-8,         -0x1p-1, INEXACT) // 5.971983782683648080136240565707e-03
T(RN,    0x1.5acc581d105a4p+1,    0x1.4f947f7955182p+0,         -0x1p-1, INEXACT) // 2.709361089888902895950195670594e+00
T(RN,    0x1.1b6e7e4e96f86p+2,    0x1.b11240cba290ep+0,          0x1p-1, INEXACT) // 4.428618981120854058985969459172e+00
T(RN,    0x1.87c3d679ec09ap+2,    0x1.f68d57d12d677p+0,          0x1p-1, INEXACT) // 6.121327990593409040798178466503e+00
T(RN,    0x1.0b1199e497739p+3,    0x1.1e126f5d95f39p+1,          0x1p-1, INEXACT) // 8.345898577182753186320951499511e+00
T(RZ,    0x1.6ede492d96072p+3,    0x1.42ee3c7dc4946p+1, -0x1.3a95f8p-54, INEXACT) // 1.146463450339817669032527192030e+01
T(RZ,    0x1.a44ff9a896f5ep+3,    0x1.53068b2bacac1p+1, -0x1.e4e334p-53, INEXACT) // 1.313476260116265947885949572083e+01
T(RN,    0x1.2d9d7d597a9ddp+4,    0x1.7e7f095703eeep+1,         -0x1p-1, INEXACT) // 1.885094962074969160426007874776e+01
T(RN,    0x1.222e0bc47b9cbp+5,    0x1.cf22fdb866f05p+1,         -0x1p-1, INEXACT) // 3.627248338224634238713406375609e+01
T(RZ,    0x1.097ad3a32b788p+6,    0x1.0d73e6af47f36p+2, -0x1.01de38p-54, INEXACT) // 6.636994795754264941933797672391e+01
T(RN,    0x1.14956b273c365p+8,    0x1.681263a2c6bbfp+2,         -0x1p-1, INEXACT) // 2.765836662790300692904565948993e+02
T(RZ,   0x1.212e23b068356p+14,    0x1.3a6e7ccf2b57ap+3,         -0x1p+0, INEXACT) // 1.850753485262704634806141257286e+04
T(RN,   0x1.72f13d0736e33p+15,    0x1.589442275e324p+3,          0x1p-1, INEXACT) // 4.748061919566653523361310362816e+04
T(RZ,   0x1.3230258bbd4efp+21,    0x1.d7860c4725c96p+3,         -0x1p+0, INEXACT) // 2.508292693232170771807432174683e+06
T(RZ,   0x1.daac439b157e5p+23,    0x1.08f51434652c2p+4,         -0x1p+0, INEXACT) // 1.555408180289835669100284576416e+07
T(RN,   0x1.295700a39d1cbp+30,    0x1.4f1b1703d1a64p+4,         -0x1p-1, INEXACT) // 1.247133736903429746627807617188e+09
T(RZ,   0x1.96bacabce3dbdp+42,    0x1.d933d37e637dfp+4,   -0x1.1c6ep-57, INEXACT) // 6.987562283919434570312500000000e+12
T(RZ,   0x1.181ea60203d29p+48,    0x1.0ae38aa7bf73dp+5,         -0x1p+0, INEXACT) // 3.079948899460665625000000000000e+14
T(RN,   0x1.51c8566b9c005p+62,    0x1.5a04d027e5548p+5,          0x1p-1, INEXACT) // 6.084949801575650304000000000000e+18
T(RN,   0x1.dd834130b60e6p+70,    0x1.892654903a23dp+5,         -0x1p-1, INEXACT) // 2.202138704352598556672000000000e+21
T(RN,   0x1.a19ad54b282dfp+79,    0x1.b9fbdfc3d1c4dp+5,         -0x1p-1, INEXACT) // 9.860414956831622110904320000000e+23
T(RN,   0x1.7bf16e6c5d5bep+82,    0x1.c9dd016897d29p+5,         -0x1p-1, INEXACT) // 7.176922076666601505030144000000e+24
T(RN,   0x1.0a1636f8aeb6ep+93,    0x1.02015d64b29b1p+6,         -0x1p-1, INEXACT) // 1.029373357196017643280138240000e+28
T(RN,   -0x1.cef0980108d65p-2,   -0x1.340aa256d2c83p-1,         -0x1p-1, INEXACT) // -4.520896673804684628983352467912e-01
T(RZ,   -0x1.d10db8c1f2d25p-2,   -0x1.35f9609b17476p-1,          0x1p+0, INEXACT) // -4.541539066674025737491149357083e-01
T(RN,  -0x1.621e85dcb9cb5p-10,  -0x1.625bcf0bf305fp-10,         -0x1p-1, INEXACT) // -1.350857658673193907941656455307e-03
T(RZ,  -0x1.ebbead4abec96p-10,  -0x1.ec34e5c4ab2e2p-10,  0x1.4f5b3cp-53, INEXACT) // -1.875857664969148626971096049942e-03
T(RZ,  -0x1.fa8f5faa4f7bep-10,  -0x1.fb0cd46eab9a3p-10,  0x1.c181d2p-51, INEXACT) // -1.932373250908877692494369782139e-03
T(RZ,  -0x1.b0419b7ebbc12p-10,  -0x1.b09cf0e341e4ap-10,    0x1.ed57p-55, INEXACT) // -1.648926845230884192378129071699e-03
T(RZ,  -0x1.b406beb4933cbp-10,  -0x1.b463adf6637d5p-10,    0x1.c56fp-52, INEXACT) // -1.663308515293271004284458847167e-03
T(RN,   -0x1.01471efff5e9p-11,  -0x1.015749588eef5p-11,         -0x1p-1, INEXACT) // -4.907184920694574598032389189939e-04
T(RN,  -0x1.11fb90c9b9c69p-11,  -0x1.120de61473628p-11,         -0x1p-1, INEXACT) // -5.225804863727814874099775188654e-04
T(RN,  -0x1.19d224f050b26p-11,  -0x1.19e58aa7fbabcp-11,          0x1p-1, INEXACT) // -5.375306628042405675954595878352e-04
T(RZ,  -0x1.aca2fc6810e46p-11,  -0x1.accfddc18541cp-11,  0x1.ace666p-52, INEXACT) // -8.175595548966594749290548449494e-04
T(RN,  -0x1.d8762f7fd5bdap-11,  -0x1.d8acb7234aa72p-11,          0x1p-1, INEXACT) // -9.011491056111168174852510404094e-04
T(RN,  -0x1.0064d18740427p-12,  -0x1.006cd82b54ae8p-12,         -0x1p-1, INEXACT) // -2.445162030682589463480292035769e-04
T(RZ,  -0x1.116e861dba212p-12,  -0x1.1177a6ed080c2p-12,          0x1p+0, INEXACT) // -2.607648219581658365420762102360e-04
T(RZ,   -0x1.10bccfcac31cp-12,  -0x1.10c5e4c01f2e9p-12,          0x1p+0, INEXACT) // -2.601027924107567057543377586626e-04
T(RN,  -0x1.6dd9a6a222eaep-12,  -0x1.6de9fe4e355aep-12,         -0x1p-1, INEXACT) // -3.489019383173624878555219019916e-04
T(RN,  -0x1.33fd669b9957ap-12,  -0x1.3408fb7e31ca5p-12,         -0x1p-1, INEXACT) // -2.937220067223616582277601061435e-04
T(RZ,  -0x1.84f0dcdc27564p-12,  -0x1.8503555f8030dp-12,          0x1p+0, INEXACT) // -3.709229183728927990021384530905e-04
T(RN,  -0x1.ae839f2b3112cp-12,  -0x1.ae9a40b49ca79p-12,         -0x1p-1, INEXACT) // -4.105702852934707807602832119187e-04
T(RN,  -0x1.5c3f1af326802p-13,  -0x1.5c4682175f806p-13,         -0x1p-1, INEXACT) // -1.660568737847368235051315199513e-04
T(RZ,  -0x1.c06edf4dc25d9p-14,  -0x1.c0750272e8b13p-14,  0x1.3fd1b6p-51, INEXACT) // -1.069147812950069486312779099002e-04
T(RZ,  -0x1.b7390d9206ea9p-14,  -0x1.b73ef0d66998ep-14,   0x1.c4a34p-51, INEXACT) // -1.047188909812322299289558125146e-04
T(RZ,   -0x1.ac62249e937ap-14,  -0x1.ac67be6831b3ep-14,  0x1.ea1928p-52, INEXACT) // -1.021345546885197609621176439987e-04
T(RZ,  -0x1.3bf39dcfa6791p-15,  -0x1.3bf523c3965e8p-15,          0x1p+0, INEXACT) // -3.766436895809224528726757985631e-05
T(RN,  -0x1.19a2c2534c596p-16,  -0x1.19a35d3f1903ap-16,          0x1p-1, INEXACT) // -1.678680048406362869525473846544e-05
T(RN,  -0x1.3fc5734e849a6p-16,  -0x1.3fc63b0601be7p-16,         -0x1p-1, INEXACT) // -1.905985419099202920123134474828e-05
T(RN,  -0x1.b24977a51f167p-16,  -0x1.b24ae80557154p-16,         -0x1p-1, INEXACT) // -2.588552128600495947480762681803e-05
T(RZ,  -0x1.12b2aec37a66cp-17,  -0x1.12b2f8745376dp-17,  0x1.a3db22p-52, INEXACT) // -8.186637734791678050385449472159e-06
T(RN,  -0x1.53dfcd4a3e6e9p-17,  -0x1.53e03e190fb13p-17,          0x1p-1, INEXACT) // -1.012904126128666346649560142668e-05
T(RN,  -0x1.1f2360fc8910ap-18,  -0x1.1f23893e9ba27p-18,          0x1p-1, INEXACT) // -4.278692582935592560893812985601e-06
T(RZ,  -0x1.6dc8e6810ad2ep-18,  -0x1.6dc927d5ea406p-18,  0x1.4dc4fep-51, INEXACT) // -5.450617778495008456068719737697e-06
T(RZ,  -0x1.42d8b87ee94f9p-19,  -0x1.42d8d1f14a759p-19,          0x1p+0, INEXACT) // -2.405394354326238061061353848413e-06
T(RZ,  -0x1.dc0236cbff167p-19,  -0x1.dc026e1d8b657p-19,          0x1p+0, INEXACT) // -3.546540801478508750523661527398e-06
T(RZ,  -0x1.8f62836df0cd7p-19,  -0x1.8f62aa5f39972p-19,  0x1.1b9616p-52, INEXACT) // -2.975648775356558463069068729001e-06
T(RN,  -0x1.c3ad34de86426p-19,  -0x1.c3ad66ad496cap-19,          0x1p-1, INEXACT) // -3.365252822417930246123429077754e-06
T(RZ,   -0x1.e033b6b48a1fbp-3,   -0x1.119aae6072d38p-2,          0x1p+0, INEXACT) // -2.344736360403344155312055363538e-01
T(RN,   -0x1.0a95ba7b93c2p-20,  -0x1.0a95c328701b3p-20,          0x1p-1, INEXACT) // -9.931060550754497906651707683778e-07
T(RN,   -0x1.1682b0105992p-20,  -0x1.1682b9885ac8bp-20,          0x1p-1, INEXACT) // -1.037532460024222843043145703135e-06
T(RZ,   -0x1.ea693d3b8534p-20,  -0x1.ea695a973fd94p-20,  0x1.692068p-54, INEXACT) // -1.826923678010033903935938059959e-06
T(RN,  -0x1.8ec53f6dcbf6ep-20,  -0x1.8ec552d71c831p-20,         -0x1p-1, INEXACT) // -1.485535871602991112261317116494e-06
T(RN,  -0x1.f5edf0cf62b24p-20,  -0x1.f5ee0f904ea31p-20,         -0x1p-1, INEXACT) // -1.869832931907907087409979191017e-06
T(RN,   -0x1.65299090576cp-21,  -0x1.652998598b75bp-21,          0x1p-1, INEXACT) // -6.652667412889159081167134157653e-07
T(RZ,  -0x1.c82991702176bp-21,  -0x1.c8299e237262ep-21,  0x1.480ff4p-51, INEXACT) // -8.496686359083757442175305861498e-07
T(RN,  -0x1.6827b7c641c05p-22,  -0x1.6827bbbba1454p-22,         -0x1p-1, INEXACT) // -3.354206196269271914518251848786e-07
T(RZ,   -0x1.8607fa9e36f3p-22,  -0x1.8607ff42afa59p-22,  0x1.0311a4p-53, INEXACT) // -3.632448314480421705931038889315e-07
T(RZ,  -0x1.cbc841339be21p-22,  -0x1.cbc847a72b6dep-22,  0x1.59fe56p-52, INEXACT) // -4.282055840803499319192871545164e-07
T(RZ,  -0x1.8a5decd86fa17p-23,  -0x1.8a5def37f4e5dp-23,   0x1.43bc3p-51, INEXACT) // -1.836413961019427745979614536795e-07
T(RZ,  -0x1.01068a49f606dp-24,  -0x1.01068acafd181p-24,   0x1.46bf2p-55, INEXACT) // -5.984342368815844596247733146524e-08
T(RN,  -0x1.0416d5d27fa39p-24,  -0x1.0416d6569ed62p-24,         -0x1p-1, INEXACT) // -6.055673588271345158648477574950e-08
T(RZ,  -0x1.08e89d57ea69fp-24,  -0x1.08e89de0fab63p-24,          0x1p+0, INEXACT) // -6.167885169155561089724277559418e-08
T(RZ,  -0x1.c1484163f379ap-24,  -0x1.c14842ee32c04p-24,          0x1p+0, INEXACT) // -1.046066749326040407094790896450e-07
T(RZ,  -0x1.b3f2a8b36f757p-24,  -0x1.b3f2aa26a0bebp-24,          0x1p+0, INEXACT) // -1.015020270533265837059684242281e-07
T(RN,  -0x1.6b07455c8aefbp-24,  -0x1.6b07465df1c02p-24,         -0x1p-1, INEXACT) // -8.452413653079915213666453667127e-08
T(RZ,  -0x1.401743554929fp-24,  -0x1.4017441d663fcp-24,          0x1p+0, INEXACT) // -7.452696356277372043789159741442e-08
T(RN,  -0x1.8bb8b605032c1p-24,  -0x1.8bb8b736dcf0dp-24,         -0x1p-1, INEXACT) // -9.213609793185516386716896750433e-08
T(RN,  -0x1.6245c9072e3d2p-25,  -0x1.6245c981bf821p-25,          0x1p-1, INEXACT) // -4.124275859149637147777926271877e-08
T(RZ,  -0x1.dfa0850d6bd19p-25,  -0x1.dfa085ee1257cp-25,   0x1.368cap-56, INEXACT) // -5.583593507983130047033569595856e-08
T(RZ,  -0x1.848793103f7c2p-25,  -0x1.848793a3aa4bcp-25,          0x1p+0, INEXACT) // -4.523079699841883563044263880451e-08
T(RN,  -0x1.9e9877da95977p-25,  -0x1.9e98788271f76p-25,          0x1p-1, INEXACT) // -4.826527773688320257275860786055e-08
T(RN,  -0x1.e75decb63d097p-25,  -0x1.e75ded9e32a95p-25,         -0x1p-1, INEXACT) // -5.673697371809689231918051133090e-08
T(RZ,   -0x1.b0e54bcc25aep-26,  -0x1.b0e54c27a683cp-26,   0x1.f3c27p-55, INEXACT) // -2.519784540795373075950129224121e-08
T(RN,  -0x1.b2f602382c0b3p-26,  -0x1.b2f602948ceccp-26,          0x1p-1, INEXACT) // -2.531806073184666198879837456081e-08
T(RN,  -0x1.465c857411116p-27,  -0x1.465c858e120dcp-27,         -0x1p-1, INEXACT) // -9.498367183174065717550448267707e-09
T(RZ,  -0x1.99dad1eddac6ep-28,  -0x1.99dad2025c2e5p-28,  0x1.92a262p-51, INEXACT) // -5.964171807342104589667532057572e-09
T(RN,  -0x1.a2d79f9a471b4p-28,  -0x1.a2d79fafb1422p-28,         -0x1p-1, INEXACT) // -6.094957339419226516332190744969e-09
T(RZ,  -0x1.d3ef28a72caabp-28,  -0x1.d3ef28c1e73e2p-28,    0x1.ee9bp-57, INEXACT) // -6.809339015539996983540382721701e-09
T(RN,  -0x1.81cc437910b41p-29,  -0x1.81cc438226543p-29,         -0x1p-1, INEXACT) // -2.807049201182368135126784378032e-09
T(RZ,  -0x1.8603983f1656dp-29,  -0x1.860398485f12ap-29,  0x1.63fe36p-51, INEXACT) // -2.837725637409540289945959878740e-09
T(RN,  -0x1.231e2987a6fe2p-29,  -0x1.231e298cd3348p-29,         -0x1p-1, INEXACT) // -2.118160927754503932122059477747e-09
T(RZ,  -0x1.0598e3e209bdfp-29,  -0x1.0598e3e637025p-29,          0x1p+0, INEXACT) // -1.903370337226334447631118180415e-09
T(RZ,    -0x1.1484b3cd038fp-3,   -0x1.290ea09e36478p-3,          0x1p+0, INEXACT) // -1.350187346401479082658170227660e-01
T(RZ,   -0x1.8c024d0aa27b3p-3,   -0x1.b8144d498cc5bp-3,  0x1.460f1cp-53, INEXACT) // -1.933637637014818666525428625391e-01
T(RN,   -0x1.8f2b059a42452p-3,   -0x1.bbffd89f45f67p-3,          0x1p-1, INEXACT) // -1.949062764836378414123885249865e-01
T(RZ,   -0x1.9d7ec7df33dbcp-3,   -0x1.cddf723d3e52ep-3,          0x1p+0, INEXACT) // -2.019019713393229720210797495383e-01
T(RZ,   -0x1.b3dbaf5230568p-3,   -0x1.ea16274b0109ap-3,          0x1p+0, INEXACT) // -2.128213593441998785493751711329e-01
T(RN,   -0x1.c2a2018aaaefp-30,  -0x1.c2a20190dd6aep-30,          0x1p-1, INEXACT) // -1.639392707235051130405873907013e-09
T(RN,  -0x1.e10bb00184e4bp-30,  -0x1.e10bb00894be8p-30,          0x1p-1, INEXACT) // -1.750033895905003300166983945172e-09
T(RN,  -0x1.12c7b37c2d50fp-31,  -0x1.12c7b37d54411p-31,         -0x1p-1, INEXACT) // -4.998220583270615513179770999705e-10
T(RN,  -0x1.5a0119264a29bp-31,  -0x1.5a0119281dd0ap-31,          0x1p-1, INEXACT) // -6.293781370949917730388010777187e-10
T(RN,  -0x1.bb2451b7c3d55p-31,   -0x1.bb2451bac2ecp-31,          0x1p-1, INEXACT) // -8.060703692811512855724884327928e-10
T(RN,  -0x1.f26ef6b649953p-31,  -0x1.f26ef6ba14091p-31,          0x1p-1, INEXACT) // -9.066451676104171317067939192232e-10
T(RZ,  -0x1.0f4e4d7bb37e8p-32,  -0x1.0f4e4d7c4341ep-32,          0x1p+0, INEXACT) // -2.467512511429239167836056494673e-10
T(RN,  -0x1.95f634d81865dp-32,  -0x1.95f634d95a485p-32,         -0x1p-1, INEXACT) // -3.692200551425367437890528229673e-10
T(RN,  -0x1.55c1c76fe4ebfp-32,  -0x1.55c1c770c90aep-32,         -0x1p-1, INEXACT) // -3.108261347901488790991072170498e-10
T(RZ,  -0x1.671d523b56a66p-32,  -0x1.671d523c5287fp-32,          0x1p+0, INEXACT) // -3.266127678285119320965233182701e-10
T(RZ,    -0x1.07ffffffd2ap-33,  -0x1.0800000016affp-33,          0x1p+0, INEXACT) // -1.200533006292222624070771715143e-10
T(RZ,  -0x1.0f7fffffd002ap-33,  -0x1.0f80000017feap-33,          0x1p+0, INEXACT) // -1.234639057605938962879947265488e-10
T(RZ,  -0x1.007fffffd52aap-33,  -0x1.00800000156aap-33,          0x1p+0, INEXACT) // -1.166426954978428737079169318455e-10
T(RZ,  -0x1.16ffffffcd528p-33,  -0x1.170000001956bp-33,          0x1p+0, INEXACT) // -1.268745108919577753506695969488e-10
T(RZ,  -0x1.037fffffd428ap-33,  -0x1.0380000015ebap-33,          0x1p+0, INEXACT) // -1.180069375503955597657701498691e-10
T(RZ,  -0x1.127fffffcef1ap-33,  -0x1.1280000018872p-33,          0x1p+0, INEXACT) // -1.248281478131403784912537968649e-10
T(RZ,  -0x1.0affffffd1968p-33,  -0x1.0b0000001734bp-33,          0x1p+0, INEXACT) // -1.214175426817718465376333156843e-10
T(RZ,  -0x1.307fffffc3a2ap-33,  -0x1.308000001e2eap-33,          0x1p+0, INEXACT) // -1.384705683385369581233088752430e-10
T(RZ,   -0x1.19ffffffcc3ap-33,  -0x1.1a00000019e2fp-33,          0x1p+0, INEXACT) // -1.282387529445011556266315934111e-10
T(RZ,  -0x1.217fffffc96fap-33,  -0x1.218000001b482p-33,          0x1p+0, INEXACT) // -1.316493580758541779437667053229e-10
T(RZ,   -0x1.25ffffffc7bap-33,  -0x1.260000001c22fp-33,          0x1p+0, INEXACT) // -1.336957211546622690212912838454e-10
T(RZ,  -0x1.2d7fffffc4d1ap-33,  -0x1.2d8000001d972p-33,          0x1p+0, INEXACT) // -1.371063262860028836292381003420e-10
T(RZ,  -0x1.28ffffffc6928p-33,  -0x1.290000001cb6bp-33,          0x1p+0, INEXACT) // -1.350599632071994454426591326002e-10
T(RZ,  -0x1.34ffffffc1d68p-33,  -0x1.350000001f14bp-33,          0x1p+0, INEXACT) // -1.405169314173357434189422322042e-10
T(RZ,  -0x1.5a7fffffb1d5ap-33,  -0x1.5a80000027152p-33,          0x1p+0, INEXACT) // -1.575699570738837200938226219983e-10
T(RZ,  -0x1.1e7fffffca8fap-33,  -0x1.1e8000001ab82p-33,          0x1p+0, INEXACT) // -1.302851160233138995951017827143e-10
T(RZ,  -0x1.46ffffffba628p-33,  -0x1.4700000022cebp-33,          0x1p+0, INEXACT) // -1.487023837325029672558019953649e-10
T(RZ,  -0x1.5d7fffffb079ap-33,  -0x1.5d80000027c32p-33,          0x1p+0, INEXACT) // -1.589341991263991830241109537767e-10
T(RZ,  -0x1.4b7fffffb874ap-33,  -0x1.4b80000023c5ap-33,          0x1p+0, INEXACT) // -1.507487468112877938785985199841e-10
T(RZ,  -0x1.64ffffffad068p-33,  -0x1.65000000297cbp-33,          0x1p+0, INEXACT) // -1.623448042576824119770619039784e-10
T(RZ,    -0x1.37ffffffc0ap-33,  -0x1.380000001faffp-33,          0x1p+0, INEXACT) // -1.418811734698667159857159332514e-10
T(RZ,  -0x1.3f7fffffbd8aap-33,  -0x1.3f800000213aap-33,          0x1p+0, INEXACT) // -1.452917786011887190298803066254e-10
T(RZ,  -0x1.3c7fffffbec8ap-33,  -0x1.3c800000209bap-33,          0x1p+0, INEXACT) // -1.439275365486608483904036794319e-10
T(RZ,   -0x1.43ffffffbba8p-33,  -0x1.44000000222bfp-33,          0x1p+0, INEXACT) // -1.473381416799781985436224420252e-10
T(RZ,  -0x1.70ffffffa75a8p-33,  -0x1.710000002c52bp-33,          0x1p+0, INEXACT) // -1.678017724677194482798386402614e-10
T(RZ,  -0x1.4e7fffffb727ap-33,  -0x1.4e800000246c2p-33,          0x1p+0, INEXACT) // -1.521129888638094606634809994699e-10
T(RZ,  -0x1.52ffffffb52e8p-33,  -0x1.530000002568bp-33,          0x1p+0, INEXACT) // -1.541593519425896343953319133084e-10
T(RZ,   -0x1.61ffffffae6ap-33,  -0x1.6200000028cafp-33,          0x1p+0, INEXACT) // -1.609805622051700509740706460538e-10
T(RZ,   -0x1.55ffffffb3dap-33,  -0x1.560000002612fp-33,          0x1p+0, INEXACT) // -1.555235939951081992529173189405e-10
T(RZ,   -0x1.73ffffffa5e8p-33,  -0x1.740000002d0bfp-33,          0x1p+0, INEXACT) // -1.691660145202256054282357504784e-10
T(RZ,  -0x1.697fffffaaebap-33,  -0x1.698000002a8a2p-33,          0x1p+0, INEXACT) // -1.643911673364486270360759854748e-10
T(RZ,  -0x1.6c7fffffa980ap-33,  -0x1.6c8000002b3fap-33,          0x1p+0, INEXACT) // -1.657554093889578861117701695456e-10
T(RN,  -0x1.7abbf730b6cd1p-33,  -0x1.7abbf73142e0fp-33,          0x1p-1, INEXACT) // -1.722283925912429672830678935305e-10
T(RN,  -0x1.695dd32fa8793p-34,  -0x1.695dd32fe83c7p-34,         -0x1p-1, INEXACT) // -8.216523012723343060005858646880e-11
T(RZ,  -0x1.b2b726095f90bp-34,  -0x1.b2b72609bbd6dp-34,          0x1p+0, INEXACT) // -9.884284375918393417130028190070e-11
T(RZ,  -0x1.0dfffffff4228p-35,  -0x1.0e00000005eebp-35,          0x1p+0, INEXACT) // -3.069544618452225789080384066407e-11
T(RZ,   -0x1.07fffffff4a8p-35,  -0x1.0800000005abfp-35,          0x1p+0, INEXACT) // -3.001332515820636528883954001652e-11
T(RZ,  -0x1.16fffffff354ap-35,  -0x1.170000000655ap-35,          0x1p+0, INEXACT) // -3.171862772399551518238209028781e-11
T(RZ,  -0x1.1cfffffff2c7ap-35,  -0x1.1d000000069c2p-35,          0x1p+0, INEXACT) // -3.240074875031063230252212247192e-11
T(RZ,   -0x1.2bfffffff15ap-35,  -0x1.2c0000000752fp-35,          0x1p+0, INEXACT) // -3.410605131609706800967973312115e-11
T(RZ,  -0x1.25fffffff1ee8p-35,  -0x1.260000000708bp-35,          0x1p+0, INEXACT) // -3.342393028978272637136396940049e-11
T(RZ,  -0x1.52ffffffed4bap-35,  -0x1.53000000095a2p-35,          0x1p+0, INEXACT) // -3.853983798713272771094557978685e-11
T(RZ,   -0x1.67ffffffeae8p-35,  -0x1.680000000a8bfp-35,          0x1p+0, INEXACT) // -4.092726157922342379270346413196e-11
T(RZ,   -0x1.bbffffffdfeap-35,  -0x1.bc000000100afp-35,          0x1p+0, INEXACT) // -5.047695594754820951034584680358e-11
T(RZ,  -0x1.76ffffffe91cap-35,  -0x1.770000000b71ap-35,          0x1p+0, INEXACT) // -4.263256414500016597705771898813e-11
T(RZ,  -0x1.9dffffffe41a8p-35,  -0x1.9e0000000df2bp-35,          0x1p+0, INEXACT) // -4.706635081601062251903484059186e-11
T(RZ,   -0x1.a3ffffffe34ap-35,  -0x1.a40000000e5afp-35,          0x1p+0, INEXACT) // -4.774847184231876030275645660496e-11
T(RZ,  -0x1.85ffffffe73e8p-35,  -0x1.860000000c60bp-35,          0x1p+0, INEXACT) // -4.433786671077496945685130268569e-11
T(RZ,  -0x1.8effffffe616ap-35,  -0x1.8f0000000cf4ap-35,          0x1p+0, INEXACT) // -4.536104825023892096653833074809e-11
T(RZ,  -0x1.b2ffffffe133ap-35,  -0x1.b30000000f662p-35,          0x1p+0, INEXACT) // -4.945377440808774766886802682668e-11
T(RZ,  -0x1.d9ffffffdb6e8p-35,  -0x1.da0000001248bp-35,          0x1p+0, INEXACT) // -5.388756107907804168341416838084e-11
T(RZ,  -0x1.61ffffffeb9a8p-35,  -0x1.620000000a32bp-35,          0x1p+0, INEXACT) // -4.024514055291218408168477426508e-11
T(RZ,  -0x1.58ffffffeca0ap-35,  -0x1.5900000009afap-35,          0x1p+0, INEXACT) // -3.922195901344474290378853811718e-11
T(RZ,     -0x1.7fffffffe8p-35,  -0x1.800000000bfffp-35,          0x1p+0, INEXACT) // -4.365574568446528070948114974570e-11
T(RZ,  -0x1.94ffffffe54dap-35,  -0x1.950000000d592p-35,          0x1p+0, INEXACT) // -4.604316927654783423208421522463e-11
T(RZ,  -0x1.acffffffe20bap-35,  -0x1.ad0000000efa2p-35,          0x1p+0, INEXACT) // -4.877165338178038536697067927703e-11
T(RZ,  -0x1.d0ffffffdcceap-35,  -0x1.d10000001198ap-35,          0x1p+0, INEXACT) // -5.286437953961990628740915379428e-11
T(RZ,  -0x1.c1ffffffdf0a8p-35,  -0x1.c2000000107abp-35,          0x1p+0, INEXACT) // -5.115907697385479633041892588978e-11
T(RZ,  -0x1.caffffffddb5ap-35,  -0x1.cb00000011252p-35,          0x1p+0, INEXACT) // -5.218225851331409494916034317151e-11
T(RZ,  -0x1.3affffffefd9ap-35,  -0x1.3b00000008132p-35,          0x1p+0, INEXACT) // -3.581135388188156501227667261178e-11
T(RZ,  -0x1.70ffffffe9d6ap-35,  -0x1.710000000b14ap-35,          0x1p+0, INEXACT) // -4.195044311868970174786329758470e-11
T(RZ,  -0x1.34fffffff075ap-35,  -0x1.3500000007c52p-35,          0x1p+0, INEXACT) // -3.512923285556799885578517735456e-11
T(RZ,   -0x1.43ffffffeeeap-35,  -0x1.44000000088afp-35,          0x1p+0, INEXACT) // -3.683453542135133263564571415001e-11
T(RZ,  -0x1.49ffffffee468p-35,  -0x1.4a00000008dcbp-35,          0x1p+0, INEXACT) // -3.751665644766412331031294094378e-11
T(RZ,  -0x1.eeffffffd81eap-35,  -0x1.ef00000013f0ap-35,          0x1p+0, INEXACT) // -5.627498467114431008770759612742e-11
T(RZ,  -0x1.e8ffffffd914ap-35,  -0x1.e90000001375ap-35,          0x1p+0, INEXACT) // -5.559286364484004971310732243155e-11
T(RZ,    -0x1.dfffffffda8p-35,  -0x1.e000000012bffp-35,          0x1p+0, INEXACT) // -5.456968210538307753983871054015e-11
T(RZ,   -0x1.f7ffffffd6a8p-35,  -0x1.f800000014abfp-35,          0x1p+0, INEXACT) // -5.729816621060011903823980532365e-11
T(RZ,  -0x1.fdffffffd5aa8p-35,  -0x1.fe000000152abp-35,          0x1p+0, INEXACT) // -5.798028723690360393101581055607e-11
T(RN,  -0x1.2f8050f99a322p-36,  -0x1.2f8050f9a570ap-36,          0x1p-1, INEXACT) // -1.725204785887985148161123537872e-11
T(RZ,  -0x1.424eaba81851cp-36,     -0x1.424eaba825p-36,          0x1p+0, INEXACT) // -1.832104924074953353312979561322e-11
T(RN,  -0x1.a7b12dce3423dp-36,  -0x1.a7b12dce4a0dap-36,          0x1p-1, INEXACT) // -2.408410780311694457961250541846e-11
T(RZ,  -0x1.88b9f33e2a9e4p-36,  -0x1.88b9f33e3d721p-36,  0x1.806372p-52, INEXACT) // -2.232390942487842142692425342760e-11
T(RZ,  -0x1.a1283415f29d2p-36,  -0x1.a128341607db4p-36,  0x1.f66d2cp-53, INEXACT) // -2.371263262632605292324431312322e-11
T(RN,  -0x1.b283c187b70bep-36,  -0x1.b283c187ce17fp-36,          0x1p-1, INEXACT) // -2.469929948947167959067747179987e-11
T(RZ,  -0x1.ad8bd87f6617fp-36,  -0x1.ad8bd87f7c9ddp-36,          0x1p+0, INEXACT) // -2.441687867315055673070263347984e-11
T(RZ,  -0x1.c8516009806f5p-36,  -0x1.c851600999da5p-36,          0x1p+0, INEXACT) // -2.593866791244723592030834632706e-11
T(RZ,  -0x1.031b2d07a2908p-37,  -0x1.031b2d07a6a98p-37,  0x1.910ee4p-51, INEXACT) // -7.364239873214453160246291730948e-12
T(RZ,   -0x1.3e486bad920bp-37,  -0x1.3e486bad9839dp-37,          0x1p+0, INEXACT) // -9.046143902538588919746945095737e-12
T(RZ,  -0x1.13fffffffe734p-38,  -0x1.1400000000c65p-38,          0x1p+0, INEXACT) // -3.922195901390625152445630742500e-12
T(RN,  -0x1.31fffffffe185p-38,  -0x1.3200000000f3dp-38,          0x1p-1, INEXACT) // -4.348521542845509924328398413138e-12
T(RN,  -0x1.e5fffffffb31dp-38,  -0x1.e600000002671p-38,          0x1p-1, INEXACT) // -6.906475391572274005889123541285e-12
T(RZ,   -0x1.c7fffffffbc5p-38,  -0x1.c8000000021d7p-38,          0x1p+0, INEXACT) // -6.480149750118116248216607555127e-12
T(RN,  -0x1.6dfffffffd465p-38,  -0x1.6e000000015cdp-38,          0x1p-1, INEXACT) // -5.201172825754915960988807912173e-12
T(RN,  -0x1.a9fffffffc4edp-38,  -0x1.aa00000001d89p-38,          0x1p-1, INEXACT) // -6.053824108663837321509049621556e-12
T(RN,  -0x1.d4844d928e7fbp-38,  -0x1.d4844d929532ap-38,         -0x1p-1, INEXACT) // -6.658024299528819259004043375385e-12
T(RZ,   -0x1.4ffffffffdb4p-38,  -0x1.500000000125fp-38,          0x1p+0, INEXACT) // -4.774847184300273527176124136362e-12
T(RZ,  -0x1.8bfffffffccf4p-38,  -0x1.8c00000001985p-38,          0x1p+0, INEXACT) // -5.627498467209437225766449740571e-12
T(RZ,   -0x1.031b2d07a49dp-39,  -0x1.031b2d07a5a34p-39,   0x1.9115ep-53, INEXACT) // -1.841059968307002791868479675045e-12
T(RZ,  -0x1.153e5af20d497p-39,  -0x1.153e5af20e75ap-39,          0x1p+0, INEXACT) // -1.969934084076166769457877624868e-12
T(RZ,  -0x1.6ede29b0244c7p-39,  -0x1.6ede29b0265a2p-39,          0x1p+0, INEXACT) // -2.606752670496493817904280908542e-12
T(RN,  -0x1.6b9d7c83e3084p-39,  -0x1.6b9d7c83e50ccp-39,         -0x1p-1, INEXACT) // -2.583641256144007592019490768249e-12
T(RN,  -0x1.9b5958146f7adp-39,  -0x1.9b595814720fcp-39,          0x1p-1, INEXACT) // -2.922810439837677835381082875854e-12
T(RZ,   -0x1.52f425d627f52p-4,   -0x1.61cdafa4a5fd1p-4,  0x1.643eecp-52, INEXACT) // -8.275236873532534898068036000041e-02
T(RZ,   -0x1.95f8998ae5a65p-4,   -0x1.ab86cb1743b74p-4,          0x1p+0, INEXACT) // -9.911403634610278789995874149099e-02
T(RZ,  -0x1.1b59f3838413dp-40,  -0x1.1b59f38384b0ap-40,  0x1.4ff52cp-53, INEXACT) // -1.006666295121413829613251572526e-12
T(RZ,   -0x1.1fffffffff94p-40,  -0x1.200000000035fp-40,          0x1p+0, INEXACT) // -1.023181539494195300833498136762e-12
T(RZ,  -0x1.10ff87f864c3fp-40,  -0x1.10ff87f865558p-40,  0x1.caa99cp-51, INEXACT) // -9.698843274887871156422768451124e-13
T(RN,  -0x1.84a8c38b772d1p-40,  -0x1.84a8c38b78542p-40,         -0x1p-1, INEXACT) // -1.380794976230463937764291427678e-12
T(RZ,  -0x1.67ffffffff574p-40,  -0x1.6800000000545p-40,          0x1p+0, INEXACT) // -1.278976924367635073910334918281e-12
T(RN,  -0x1.2bffffffff8adp-40,  -0x1.2c000000003a9p-40,          0x1p-1, INEXACT) // -1.065814103639771625572180315701e-12
T(RN,  -0x1.a3ffffffff1a5p-40,  -0x1.a40000000072dp-40,          0x1p-1, INEXACT) // -1.492139745095468229989729034008e-12
T(RN,  -0x1.5bffffffff625p-40,  -0x1.5c000000004edp-40,          0x1p-1, INEXACT) // -1.236344360222064807623404836713e-12
T(RZ,  -0x1.97ffffffff274p-40,  -0x1.98000000006c5p-40,          0x1p+0, INEXACT) // -1.449507180949904022154551049810e-12
T(RZ,   -0x1.dffffffffed4p-40,  -0x1.e00000000095fp-40,          0x1p+0, INEXACT) // -1.705302565823271093810362662881e-12
T(RN,  -0x1.d3fffffffee2dp-40,  -0x1.d4000000008e9p-40,          0x1p-1, INEXACT) // -1.662670001677712944426936776055e-12
T(RZ,  -0x1.153e5af20ddf9p-41,  -0x1.153e5af20e2a9p-41,          0x1p+0, INEXACT) // -4.924835210192842323829450376226e-13
T(RZ,  -0x1.70c8229f434b8p-41,  -0x1.70c8229f43d05p-41,  0x1.fff3c8p-52, INEXACT) // -6.550880341145325833840873319124e-13
T(RN,  -0x1.987866b49093bp-42,  -0x1.987866b490e53p-42,         -0x1p-1, INEXACT) // -3.627945207886739071902917927141e-13
T(RN,  -0x1.1a63ca08393b1p-43,  -0x1.1a63ca08394e8p-43,          0x1p-1, INEXACT) // -1.254062638247578784432696574410e-13
T(RZ,  -0x1.4cf03d20e59afp-43,   -0x1.4cf03d20e5b6p-43,  0x1.7a9b6cp-51, INEXACT) // -1.478543655273070534160027414254e-13
T(RN,  -0x1.007fe00ff601ap-44,  -0x1.007fe00ff609ap-44,          0x1p-1, INEXACT) // -5.695433295429485907015491823898e-14
T(RN,  -0x1.342e881f15c46p-44,    -0x1.342e881f15dp-44,         -0x1p-1, INEXACT) // -6.843009815418733178835648444988e-14
T(RN,  -0x1.4ffffffffff6dp-44,  -0x1.5000000000049p-44,          0x1p-1, INEXACT) // -7.460698725480866411561896827594e-14
T(RN,  -0x1.a04ebd789cf37p-44,  -0x1.a04ebd789d08ap-44,         -0x1p-1, INEXACT) // -9.243885181758519277680308453056e-14
T(RZ,  -0x1.988c745f884b9p-44,  -0x1.988c745f885fep-44,          0x1p+0, INEXACT) // -9.071602374037950220318790282486e-14
T(RN,  -0x1.affffffffff0dp-44,  -0x1.b000000000079p-44,          0x1p-1, INEXACT) // -9.592326932761045800140227682915e-14
T(RN,  -0x1.ed69a09011ddep-44,  -0x1.ed69a09011fb9p-44,          0x1p-1, INEXACT) // -1.095596072183632780328736205143e-13
T(RN,  -0x1.e93e8b71a517dp-44,  -0x1.e93e8b71a5351p-44,         -0x1p-1, INEXACT) // -1.086340606904919205232518301381e-13
T(RZ,  -0x1.dffffffffff6ap-45,  -0x1.e00000000004ap-45,          0x1p+0, INEXACT) // -5.329070518200656730724805485419e-14
T(RN,  -0x1.18cc821d6d3c9p-46,  -0x1.18cc821d6d3efp-46,          0x1p-1, INEXACT) // -1.558746800503754386765664849508e-14
T(RN,  -0x1.1ffffffffffe5p-46,  -0x1.200000000000dp-46,          0x1p-1, INEXACT) // -1.598721155460216898512253215123e-14
T(RN,  -0x1.09cfdcd8ecff2p-46,  -0x1.09cfdcd8ed015p-46,         -0x1p-1, INEXACT) // -1.475552811121977826572127249985e-14
T(RZ,   -0x1.7ffffffffffdp-46,  -0x1.8000000000017p-46,          0x1p+0, INEXACT) // -2.131628207280285411483992559308e-14
T(RN,  -0x1.d98e877b3e1bep-46,  -0x1.d98e877b3e22cp-46,         -0x1p-1, INEXACT) // -2.628768063130701975984575071526e-14
T(RZ,  -0x1.52a7fa9d2f8d7p-47,  -0x1.52a7fa9d2f8f2p-47,          0x1p+0, INEXACT) // -9.399596873523500585449530655875e-15
T(RZ,  -0x1.6fa6ea162d0dap-47,  -0x1.6fa6ea162d0fap-47,          0x1p+0, INEXACT) // -1.020439314654099596491958311240e-14
T(RN,  -0x1.aaeee979b481ap-47,  -0x1.aaeee979b4846p-47,          0x1p-1, INEXACT) // -1.184977810464563045630080534504e-14
T(RN,  -0x1.9c4a8969b705bp-47,  -0x1.9c4a8969b7085p-47,         -0x1p-1, INEXACT) // -1.144337844636307400957825621322e-14
T(RN,  -0x1.f1cd9cceef211p-47,  -0x1.f1cd9cceef24ep-47,         -0x1p-1, INEXACT) // -1.381681363641715697777370582679e-14
T(RN,  -0x1.32eee7577040fp-48,  -0x1.32eee7577041bp-48,         -0x1p-1, INEXACT) // -4.259554063523929642315542967237e-15
T(RN,  -0x1.4c8dc2e423977p-48,  -0x1.4c8dc2e423985p-48,         -0x1p-1, INEXACT) // -4.615110447320546454020413413174e-15
T(RN,  -0x1.645640568c1b9p-48,  -0x1.645640568c1c8p-48,          0x1p-1, INEXACT) // -4.945168153041035307466337578051e-15
T(RN,  -0x1.6fa6ea162d0e5p-48,  -0x1.6fa6ea162d0f5p-48,          0x1p-1, INEXACT) // -5.102196573270506659929748987328e-15
T(RZ,  -0x1.5e8add236a585p-48,  -0x1.5e8add236a594p-48,  0x1.53476ep-52, INEXACT) // -4.864753555590486217242057428848e-15
T(RN,  -0x1.465655f122ff2p-49,  -0x1.465655f122ff8p-49,          0x1p-1, INEXACT) // -2.264419546801468702887108549318e-15
T(RZ,   -0x1.deeea11683f4p-49,  -0x1.deeea11683f4ep-49,  0x1.8c9d68p-51, INEXACT) // -3.323259344844175917802498356457e-15
T(RN,   -0x1.468ecc6280511p-5,   -0x1.4d3eb275e2cd9p-5,          0x1p-1, INEXACT) // -3.986301344776611160769519415226e-02
T(RZ,   -0x1.ea41f805cd075p-5,   -0x1.f98a60832028ap-5,          0x1p+0, INEXACT) // -5.984590951848726275708045818646e-02
T(RZ,  -0x1.3988e1409212dp-50,   -0x1.3988e1409213p-50,  0x1.40da6cp-51, INEXACT) // -1.087791964408414385643918371435e-15
T(RZ,  -0x1.6a09e667f3bcap-50,  -0x1.6a09e667f3bcep-50,  0x1.278c34p-53, INEXACT) // -1.256073966947019541731839961014e-15
T(RN,   -0x1.a887293fd6f3p-50,  -0x1.a887293fd6f35p-50,          0x1p-1, INEXACT) // -1.472877282518058287774890745088e-15
T(RZ,  -0x1.94c583ada5b4fp-50,  -0x1.94c583ada5b53p-50,          0x1p+0, INEXACT) // -1.404333387430679701082347255502e-15
T(RN,  -0x1.efbdeb14f4ed5p-50,  -0x1.efbdeb14f4eddp-50,         -0x1p-1, INEXACT) // -1.719950113979702344543698455273e-15
T(RN,  -0x1.cd82b446159efp-50,  -0x1.cd82b446159f5p-50,          0x1p-1, INEXACT) // -1.601186416994687599536222207641e-15
T(RZ,                -0x1p-51,  -0x1.0000000000001p-51,  0x1.555554p-52, INEXACT) // -4.440892098500626161694526672363e-16
T(RN,  -0x1.3988e1409212ep-51,   -0x1.3988e1409213p-51,         -0x1p-1, INEXACT) // -5.438959822042072914295723383441e-16
T(RN,   -0x1.94c583ada5b5p-51,  -0x1.94c583ada5b52p-51,          0x1p-1, INEXACT) // -7.021666937153399491487867803776e-16
T(RZ,  -0x1.6a09e667f3bcbp-51,  -0x1.6a09e667f3bccp-51,          0x1p+0, INEXACT) // -6.280369834735098694735331331335e-16
T(RZ,  -0x1.bb67ae8584ca9p-51,  -0x1.bb67ae8584cacp-51,  0x1.e6066ap-52, INEXACT) // -7.691850745534254279487381460026e-16
T(RN,  -0x1.deeea11683f47p-51,  -0x1.deeea11683f4bp-51,         -0x1p-1, INEXACT) // -8.308148362110446697039166574995e-16
T(RZ,   -0x1.459d6ab2a6207p-6,   -0x1.48e4e0e842885p-6,  0x1.bd4794p-53, INEXACT) // -1.987395686828288474123915818836e-02
T(RZ,   -0x1.a27431e34134ep-6,   -0x1.a7e3f0c2acea6p-6,          0x1p+0, INEXACT) // -2.554039832922976732687558865109e-02
T(RZ,   -0x1.c7fe57175787fp-6,    -0x1.ce75940b84e4p-6,          0x1p+0, INEXACT) // -2.783163552282319139208333069746e-02
T(RN,   -0x1.c53a27c2a38bap-6,   -0x1.cb9d2eb5906fap-6,         -0x1p-1, INEXACT) // -2.766279108851030926752301297711e-02
T(RZ,   -0x1.1391dc3c7046ap-7,   -0x1.14bc2b628570cp-7,  0x1.5186c4p-51, INEXACT) // -8.409721886780203298217273299997e-03
T(RN,   -0x1.7b56499ce51d5p-7,   -0x1.7d8cc27deb122p-7,          0x1p-1, INEXACT) // -1.157644838694064405582029309016e-02
T(RN,   -0x1.b82c664fcd917p-7,   -0x1.bb2817c27b529p-7,          0x1p-1, INEXACT) // -1.343302722635235195436376187672e-02
T(RN,   -0x1.15c36db195029p-8,   -0x1.165a8b4ab2d84p-8,          0x1p-1, INEXACT) // -4.238333016093811557445381055231e-03
T(RZ,   -0x1.4c398ba0cb01bp-8,   -0x1.4d11d980608bdp-8,   0x1.19026p-55, INEXACT) // -5.069347943202041732735363410711e-03
T(RN,    -0x1.2d159cd16384p-8,   -0x1.2dc73609768dap-8,         -0x1p-1, INEXACT) // -4.594183717371136399520992199541e-03
T(RZ,   -0x1.6417bcb144966p-8,   -0x1.65104c4ebd4c7p-8,          0x1p+0, INEXACT) // -5.433543746465074528173566648093e-03
T(RN,   -0x1.6a8f62b09ae8dp-8,   -0x1.6b91130439c5ap-8,          0x1p-1, INEXACT) // -5.532228082852375279643286631881e-03
T(RN,   -0x1.bb0be01fd98ccp-8,   -0x1.bc8cfdc2b677ep-8,          0x1p-1, INEXACT) // -6.760351388811435685566308961825e-03
T(RZ,   -0x1.6def4811a9908p-9,   -0x1.6e724b8efce87p-9,          0x1p+0, INEXACT) // -2.791860148891992660091787570309e-03
T(RN,     -0x1.a8aa0c5e91ep-9,   -0x1.a95a8aeb6bbc4p-9,          0x1p-1, INEXACT) // -3.239931116045147163617912156042e-03
T(RN,   -0x1.6d3586c17768bp-9,   -0x1.6db8053e669efp-9,          0x1p-1, INEXACT) // -2.786324214624274261259406770819e-03
T(RN,   -0x1.9568234672056p-9,   -0x1.9608f8dcfe483p-9,          0x1p-1, INEXACT) // -3.093008333255690793517356240727e-03
T(RZ,   -0x1.534fe6a6c1e4bp-1,   -0x1.163b110306538p+0,  0x1.7561d8p-51, INEXACT) // -6.627189711152338125188521189557e-01
T(RN,   -0x1.a2989d182a49fp-1,   -0x1.b38e6d91130d9p+0,         -0x1p-1, INEXACT) // -8.175705997465633201315426958899e-01
T(RZ,   -0x1.534fe6a6c1e4bp-1,   -0x1.163b110306538p+0,  0x1.7561d8p-51, INEXACT) // -6.627189711152338125188521189557e-01
T(RN,   -0x1.be5d07645dfe8p-1,   -0x1.06efbb9e76c03p+1,          0x1p-1, INEXACT) // -8.718035039919387330087374721188e-01
