// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/v2/answer_record.proto

package dialogflowpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The correctness level of an answer.
type AnswerFeedback_CorrectnessLevel int32

const (
	// Correctness level unspecified.
	AnswerFeedback_CORRECTNESS_LEVEL_UNSPECIFIED AnswerFeedback_CorrectnessLevel = 0
	// Answer is totally wrong.
	AnswerFeedback_NOT_CORRECT AnswerFeedback_CorrectnessLevel = 1
	// Answer is partially correct.
	AnswerFeedback_PARTIALLY_CORRECT AnswerFeedback_CorrectnessLevel = 2
	// Answer is fully correct.
	AnswerFeedback_FULLY_CORRECT AnswerFeedback_CorrectnessLevel = 3
)

// Enum value maps for AnswerFeedback_CorrectnessLevel.
var (
	AnswerFeedback_CorrectnessLevel_name = map[int32]string{
		0: "CORRECTNESS_LEVEL_UNSPECIFIED",
		1: "NOT_CORRECT",
		2: "PARTIALLY_CORRECT",
		3: "FULLY_CORRECT",
	}
	AnswerFeedback_CorrectnessLevel_value = map[string]int32{
		"CORRECTNESS_LEVEL_UNSPECIFIED": 0,
		"NOT_CORRECT":                   1,
		"PARTIALLY_CORRECT":             2,
		"FULLY_CORRECT":                 3,
	}
)

func (x AnswerFeedback_CorrectnessLevel) Enum() *AnswerFeedback_CorrectnessLevel {
	p := new(AnswerFeedback_CorrectnessLevel)
	*p = x
	return p
}

func (x AnswerFeedback_CorrectnessLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnswerFeedback_CorrectnessLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_answer_record_proto_enumTypes[0].Descriptor()
}

func (AnswerFeedback_CorrectnessLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_answer_record_proto_enumTypes[0]
}

func (x AnswerFeedback_CorrectnessLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnswerFeedback_CorrectnessLevel.Descriptor instead.
func (AnswerFeedback_CorrectnessLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{4, 0}
}

// Relevance of an answer.
type AgentAssistantFeedback_AnswerRelevance int32

const (
	// Answer relevance unspecified.
	AgentAssistantFeedback_ANSWER_RELEVANCE_UNSPECIFIED AgentAssistantFeedback_AnswerRelevance = 0
	// Answer is irrelevant to query.
	AgentAssistantFeedback_IRRELEVANT AgentAssistantFeedback_AnswerRelevance = 1
	// Answer is relevant to query.
	AgentAssistantFeedback_RELEVANT AgentAssistantFeedback_AnswerRelevance = 2
)

// Enum value maps for AgentAssistantFeedback_AnswerRelevance.
var (
	AgentAssistantFeedback_AnswerRelevance_name = map[int32]string{
		0: "ANSWER_RELEVANCE_UNSPECIFIED",
		1: "IRRELEVANT",
		2: "RELEVANT",
	}
	AgentAssistantFeedback_AnswerRelevance_value = map[string]int32{
		"ANSWER_RELEVANCE_UNSPECIFIED": 0,
		"IRRELEVANT":                   1,
		"RELEVANT":                     2,
	}
)

func (x AgentAssistantFeedback_AnswerRelevance) Enum() *AgentAssistantFeedback_AnswerRelevance {
	p := new(AgentAssistantFeedback_AnswerRelevance)
	*p = x
	return p
}

func (x AgentAssistantFeedback_AnswerRelevance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AgentAssistantFeedback_AnswerRelevance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_answer_record_proto_enumTypes[1].Descriptor()
}

func (AgentAssistantFeedback_AnswerRelevance) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_answer_record_proto_enumTypes[1]
}

func (x AgentAssistantFeedback_AnswerRelevance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AgentAssistantFeedback_AnswerRelevance.Descriptor instead.
func (AgentAssistantFeedback_AnswerRelevance) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{5, 0}
}

// Correctness of document.
type AgentAssistantFeedback_DocumentCorrectness int32

const (
	// Document correctness unspecified.
	AgentAssistantFeedback_DOCUMENT_CORRECTNESS_UNSPECIFIED AgentAssistantFeedback_DocumentCorrectness = 0
	// Information in document is incorrect.
	AgentAssistantFeedback_INCORRECT AgentAssistantFeedback_DocumentCorrectness = 1
	// Information in document is correct.
	AgentAssistantFeedback_CORRECT AgentAssistantFeedback_DocumentCorrectness = 2
)

// Enum value maps for AgentAssistantFeedback_DocumentCorrectness.
var (
	AgentAssistantFeedback_DocumentCorrectness_name = map[int32]string{
		0: "DOCUMENT_CORRECTNESS_UNSPECIFIED",
		1: "INCORRECT",
		2: "CORRECT",
	}
	AgentAssistantFeedback_DocumentCorrectness_value = map[string]int32{
		"DOCUMENT_CORRECTNESS_UNSPECIFIED": 0,
		"INCORRECT":                        1,
		"CORRECT":                          2,
	}
)

func (x AgentAssistantFeedback_DocumentCorrectness) Enum() *AgentAssistantFeedback_DocumentCorrectness {
	p := new(AgentAssistantFeedback_DocumentCorrectness)
	*p = x
	return p
}

func (x AgentAssistantFeedback_DocumentCorrectness) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AgentAssistantFeedback_DocumentCorrectness) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_answer_record_proto_enumTypes[2].Descriptor()
}

func (AgentAssistantFeedback_DocumentCorrectness) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_answer_record_proto_enumTypes[2]
}

func (x AgentAssistantFeedback_DocumentCorrectness) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AgentAssistantFeedback_DocumentCorrectness.Descriptor instead.
func (AgentAssistantFeedback_DocumentCorrectness) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{5, 1}
}

// Efficiency of document.
type AgentAssistantFeedback_DocumentEfficiency int32

const (
	// Document efficiency unspecified.
	AgentAssistantFeedback_DOCUMENT_EFFICIENCY_UNSPECIFIED AgentAssistantFeedback_DocumentEfficiency = 0
	// Document is inefficient.
	AgentAssistantFeedback_INEFFICIENT AgentAssistantFeedback_DocumentEfficiency = 1
	// Document is efficient.
	AgentAssistantFeedback_EFFICIENT AgentAssistantFeedback_DocumentEfficiency = 2
)

// Enum value maps for AgentAssistantFeedback_DocumentEfficiency.
var (
	AgentAssistantFeedback_DocumentEfficiency_name = map[int32]string{
		0: "DOCUMENT_EFFICIENCY_UNSPECIFIED",
		1: "INEFFICIENT",
		2: "EFFICIENT",
	}
	AgentAssistantFeedback_DocumentEfficiency_value = map[string]int32{
		"DOCUMENT_EFFICIENCY_UNSPECIFIED": 0,
		"INEFFICIENT":                     1,
		"EFFICIENT":                       2,
	}
)

func (x AgentAssistantFeedback_DocumentEfficiency) Enum() *AgentAssistantFeedback_DocumentEfficiency {
	p := new(AgentAssistantFeedback_DocumentEfficiency)
	*p = x
	return p
}

func (x AgentAssistantFeedback_DocumentEfficiency) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AgentAssistantFeedback_DocumentEfficiency) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_answer_record_proto_enumTypes[3].Descriptor()
}

func (AgentAssistantFeedback_DocumentEfficiency) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_answer_record_proto_enumTypes[3]
}

func (x AgentAssistantFeedback_DocumentEfficiency) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AgentAssistantFeedback_DocumentEfficiency.Descriptor instead.
func (AgentAssistantFeedback_DocumentEfficiency) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{5, 2}
}

// Answer records are records to manage answer history and feedbacks for
// Dialogflow.
//
// Currently, answer record includes:
//
// - human agent assistant article suggestion
// - human agent assistant faq article
//
// It doesn't include:
//
// - `DetectIntent` intent matching
// - `DetectIntent` knowledge
//
// Answer records are not related to the conversation history in the
// Dialogflow Console. A Record is generated even when the end-user disables
// conversation history in the console. Records are created when there's a human
// agent assistant suggestion generated.
//
// A typical workflow for customers provide feedback to an answer is:
//
//  1. For human agent assistant, customers get suggestion via ListSuggestions
//     API. Together with the answers,
//     [AnswerRecord.name][google.cloud.dialogflow.v2.AnswerRecord.name] are
//     returned to the customers.
//  2. The customer uses the
//
// [AnswerRecord.name][google.cloud.dialogflow.v2.AnswerRecord.name] to call the
//
//	[AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2.AnswerRecords.UpdateAnswerRecord]
//	method to send feedback about a specific answer that they believe is
//	wrong.
type AnswerRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of this answer record.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/answerRecords/<Answer Record ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The AnswerFeedback for this record. You can set this with
	// [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2.AnswerRecords.UpdateAnswerRecord]
	// in order to give us feedback about this answer.
	AnswerFeedback *AnswerFeedback `protobuf:"bytes,2,opt,name=answer_feedback,json=answerFeedback,proto3" json:"answer_feedback,omitempty"`
	// The record for this answer.
	//
	// Types that are assignable to Record:
	//
	//	*AnswerRecord_AgentAssistantRecord
	Record isAnswerRecord_Record `protobuf_oneof:"record"`
}

func (x *AnswerRecord) Reset() {
	*x = AnswerRecord{}
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnswerRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnswerRecord) ProtoMessage() {}

func (x *AnswerRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnswerRecord.ProtoReflect.Descriptor instead.
func (*AnswerRecord) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{0}
}

func (x *AnswerRecord) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnswerRecord) GetAnswerFeedback() *AnswerFeedback {
	if x != nil {
		return x.AnswerFeedback
	}
	return nil
}

func (m *AnswerRecord) GetRecord() isAnswerRecord_Record {
	if m != nil {
		return m.Record
	}
	return nil
}

func (x *AnswerRecord) GetAgentAssistantRecord() *AgentAssistantRecord {
	if x, ok := x.GetRecord().(*AnswerRecord_AgentAssistantRecord); ok {
		return x.AgentAssistantRecord
	}
	return nil
}

type isAnswerRecord_Record interface {
	isAnswerRecord_Record()
}

type AnswerRecord_AgentAssistantRecord struct {
	// Output only. The record for human agent assistant.
	AgentAssistantRecord *AgentAssistantRecord `protobuf:"bytes,4,opt,name=agent_assistant_record,json=agentAssistantRecord,proto3,oneof"`
}

func (*AnswerRecord_AgentAssistantRecord) isAnswerRecord_Record() {}

// Request message for
// [AnswerRecords.ListAnswerRecords][google.cloud.dialogflow.v2.AnswerRecords.ListAnswerRecords].
type ListAnswerRecordsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to list all answer records for in reverse
	// chronological order. Format: `projects/<Project ID>/locations/<Location
	// ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filters to restrict results to specific answer records. The
	// expression has the following syntax:
	//
	//	<field> <operator> <value> [AND <field> <operator> <value>] ...
	//
	// The following fields and operators are supported:
	// * conversation_id with equals(=) operator
	//
	// Examples:
	//
	//   - `conversation_id=bar` matches answer records in the
	//     `projects/foo/locations/global/conversations/bar` conversation
	//     (assuming the parent is `projects/foo/locations/global`).
	//
	// For more information about filtering, see
	// [API Filtering](https://aip.dev/160).
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of records to return in a single page.
	// The server may return fewer records than this. If unspecified, we use 10.
	// The maximum is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The
	// [ListAnswerRecordsResponse.next_page_token][google.cloud.dialogflow.v2.ListAnswerRecordsResponse.next_page_token]
	// value returned from a previous list request used to continue listing on
	// the next page.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAnswerRecordsRequest) Reset() {
	*x = ListAnswerRecordsRequest{}
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAnswerRecordsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnswerRecordsRequest) ProtoMessage() {}

func (x *ListAnswerRecordsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnswerRecordsRequest.ProtoReflect.Descriptor instead.
func (*ListAnswerRecordsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{1}
}

func (x *ListAnswerRecordsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnswerRecordsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAnswerRecordsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnswerRecordsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [AnswerRecords.ListAnswerRecords][google.cloud.dialogflow.v2.AnswerRecords.ListAnswerRecords].
type ListAnswerRecordsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of answer records.
	AnswerRecords []*AnswerRecord `protobuf:"bytes,1,rep,name=answer_records,json=answerRecords,proto3" json:"answer_records,omitempty"`
	// A token to retrieve next page of results. Or empty if there are no more
	// results.
	// Pass this value in the
	// [ListAnswerRecordsRequest.page_token][google.cloud.dialogflow.v2.ListAnswerRecordsRequest.page_token]
	// field in the subsequent call to `ListAnswerRecords` method to retrieve the
	// next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnswerRecordsResponse) Reset() {
	*x = ListAnswerRecordsResponse{}
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAnswerRecordsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnswerRecordsResponse) ProtoMessage() {}

func (x *ListAnswerRecordsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnswerRecordsResponse.ProtoReflect.Descriptor instead.
func (*ListAnswerRecordsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{2}
}

func (x *ListAnswerRecordsResponse) GetAnswerRecords() []*AnswerRecord {
	if x != nil {
		return x.AnswerRecords
	}
	return nil
}

func (x *ListAnswerRecordsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2.AnswerRecords.UpdateAnswerRecord].
type UpdateAnswerRecordRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Answer record to update.
	AnswerRecord *AnswerRecord `protobuf:"bytes,1,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
	// Required. The mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAnswerRecordRequest) Reset() {
	*x = UpdateAnswerRecordRequest{}
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAnswerRecordRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAnswerRecordRequest) ProtoMessage() {}

func (x *UpdateAnswerRecordRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAnswerRecordRequest.ProtoReflect.Descriptor instead.
func (*UpdateAnswerRecordRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateAnswerRecordRequest) GetAnswerRecord() *AnswerRecord {
	if x != nil {
		return x.AnswerRecord
	}
	return nil
}

func (x *UpdateAnswerRecordRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Represents feedback the customer has about the quality & correctness of a
// certain answer in a conversation.
type AnswerFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The correctness level of the specific answer.
	CorrectnessLevel AnswerFeedback_CorrectnessLevel `protobuf:"varint,1,opt,name=correctness_level,json=correctnessLevel,proto3,enum=google.cloud.dialogflow.v2.AnswerFeedback_CorrectnessLevel" json:"correctness_level,omitempty"`
	// Normally, detail feedback is provided when answer is not fully correct.
	//
	// Types that are assignable to DetailFeedback:
	//
	//	*AnswerFeedback_AgentAssistantDetailFeedback
	DetailFeedback isAnswerFeedback_DetailFeedback `protobuf_oneof:"detail_feedback"`
	// Indicates whether the answer/item was clicked by the human agent
	// or not. Default to false.
	// For knowledge search and knowledge assist, the answer record is considered
	// to be clicked if the answer was copied or any URI was clicked.
	Clicked bool `protobuf:"varint,3,opt,name=clicked,proto3" json:"clicked,omitempty"`
	// Time when the answer/item was clicked.
	ClickTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=click_time,json=clickTime,proto3" json:"click_time,omitempty"`
	// Indicates whether the answer/item was displayed to the human
	// agent in the agent desktop UI. Default to false.
	Displayed bool `protobuf:"varint,4,opt,name=displayed,proto3" json:"displayed,omitempty"`
	// Time when the answer/item was displayed.
	DisplayTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=display_time,json=displayTime,proto3" json:"display_time,omitempty"`
}

func (x *AnswerFeedback) Reset() {
	*x = AnswerFeedback{}
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnswerFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnswerFeedback) ProtoMessage() {}

func (x *AnswerFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnswerFeedback.ProtoReflect.Descriptor instead.
func (*AnswerFeedback) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{4}
}

func (x *AnswerFeedback) GetCorrectnessLevel() AnswerFeedback_CorrectnessLevel {
	if x != nil {
		return x.CorrectnessLevel
	}
	return AnswerFeedback_CORRECTNESS_LEVEL_UNSPECIFIED
}

func (m *AnswerFeedback) GetDetailFeedback() isAnswerFeedback_DetailFeedback {
	if m != nil {
		return m.DetailFeedback
	}
	return nil
}

func (x *AnswerFeedback) GetAgentAssistantDetailFeedback() *AgentAssistantFeedback {
	if x, ok := x.GetDetailFeedback().(*AnswerFeedback_AgentAssistantDetailFeedback); ok {
		return x.AgentAssistantDetailFeedback
	}
	return nil
}

func (x *AnswerFeedback) GetClicked() bool {
	if x != nil {
		return x.Clicked
	}
	return false
}

func (x *AnswerFeedback) GetClickTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ClickTime
	}
	return nil
}

func (x *AnswerFeedback) GetDisplayed() bool {
	if x != nil {
		return x.Displayed
	}
	return false
}

func (x *AnswerFeedback) GetDisplayTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DisplayTime
	}
	return nil
}

type isAnswerFeedback_DetailFeedback interface {
	isAnswerFeedback_DetailFeedback()
}

type AnswerFeedback_AgentAssistantDetailFeedback struct {
	// Detail feedback of agent assist suggestions.
	AgentAssistantDetailFeedback *AgentAssistantFeedback `protobuf:"bytes,2,opt,name=agent_assistant_detail_feedback,json=agentAssistantDetailFeedback,proto3,oneof"`
}

func (*AnswerFeedback_AgentAssistantDetailFeedback) isAnswerFeedback_DetailFeedback() {}

// Detail feedback of Agent Assist result.
type AgentAssistantFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether or not the suggested answer is relevant.
	//
	// For example:
	//
	//   - Query: "Can I change my mailing address?"
	//   - Suggested document says: "Items must be returned/exchanged within 60
	//     days of the purchase date."
	//   - [answer_relevance][google.cloud.dialogflow.v2.AgentAssistantFeedback.answer_relevance]: [AnswerRelevance.IRRELEVANT][google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance.IRRELEVANT]
	AnswerRelevance AgentAssistantFeedback_AnswerRelevance `protobuf:"varint,1,opt,name=answer_relevance,json=answerRelevance,proto3,enum=google.cloud.dialogflow.v2.AgentAssistantFeedback_AnswerRelevance" json:"answer_relevance,omitempty"`
	// Optional. Whether or not the information in the document is correct.
	//
	// For example:
	//
	//   - Query: "Can I return the package in 2 days once received?"
	//   - Suggested document says: "Items must be returned/exchanged within 60
	//     days of the purchase date."
	//   - Ground truth: "No return or exchange is allowed."
	//   - [document_correctness][google.cloud.dialogflow.v2.AgentAssistantFeedback.document_correctness]: [INCORRECT][google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness.INCORRECT]
	DocumentCorrectness AgentAssistantFeedback_DocumentCorrectness `protobuf:"varint,2,opt,name=document_correctness,json=documentCorrectness,proto3,enum=google.cloud.dialogflow.v2.AgentAssistantFeedback_DocumentCorrectness" json:"document_correctness,omitempty"`
	// Optional. Whether or not the suggested document is efficient. For example,
	// if the document is poorly written, hard to understand, hard to use or
	// too long to find useful information,
	// [document_efficiency][google.cloud.dialogflow.v2.AgentAssistantFeedback.document_efficiency]
	// is
	// [DocumentEfficiency.INEFFICIENT][google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency.INEFFICIENT].
	DocumentEfficiency AgentAssistantFeedback_DocumentEfficiency `protobuf:"varint,3,opt,name=document_efficiency,json=documentEfficiency,proto3,enum=google.cloud.dialogflow.v2.AgentAssistantFeedback_DocumentEfficiency" json:"document_efficiency,omitempty"`
	// Optional. Feedback for conversation summarization.
	SummarizationFeedback *AgentAssistantFeedback_SummarizationFeedback `protobuf:"bytes,4,opt,name=summarization_feedback,json=summarizationFeedback,proto3" json:"summarization_feedback,omitempty"`
	// Optional. Feedback for knowledge search.
	KnowledgeSearchFeedback *AgentAssistantFeedback_KnowledgeSearchFeedback `protobuf:"bytes,5,opt,name=knowledge_search_feedback,json=knowledgeSearchFeedback,proto3" json:"knowledge_search_feedback,omitempty"`
	// Optional. Feedback for knowledge assist.
	KnowledgeAssistFeedback *AgentAssistantFeedback_KnowledgeAssistFeedback `protobuf:"bytes,6,opt,name=knowledge_assist_feedback,json=knowledgeAssistFeedback,proto3" json:"knowledge_assist_feedback,omitempty"`
}

func (x *AgentAssistantFeedback) Reset() {
	*x = AgentAssistantFeedback{}
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentAssistantFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentAssistantFeedback) ProtoMessage() {}

func (x *AgentAssistantFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentAssistantFeedback.ProtoReflect.Descriptor instead.
func (*AgentAssistantFeedback) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{5}
}

func (x *AgentAssistantFeedback) GetAnswerRelevance() AgentAssistantFeedback_AnswerRelevance {
	if x != nil {
		return x.AnswerRelevance
	}
	return AgentAssistantFeedback_ANSWER_RELEVANCE_UNSPECIFIED
}

func (x *AgentAssistantFeedback) GetDocumentCorrectness() AgentAssistantFeedback_DocumentCorrectness {
	if x != nil {
		return x.DocumentCorrectness
	}
	return AgentAssistantFeedback_DOCUMENT_CORRECTNESS_UNSPECIFIED
}

func (x *AgentAssistantFeedback) GetDocumentEfficiency() AgentAssistantFeedback_DocumentEfficiency {
	if x != nil {
		return x.DocumentEfficiency
	}
	return AgentAssistantFeedback_DOCUMENT_EFFICIENCY_UNSPECIFIED
}

func (x *AgentAssistantFeedback) GetSummarizationFeedback() *AgentAssistantFeedback_SummarizationFeedback {
	if x != nil {
		return x.SummarizationFeedback
	}
	return nil
}

func (x *AgentAssistantFeedback) GetKnowledgeSearchFeedback() *AgentAssistantFeedback_KnowledgeSearchFeedback {
	if x != nil {
		return x.KnowledgeSearchFeedback
	}
	return nil
}

func (x *AgentAssistantFeedback) GetKnowledgeAssistFeedback() *AgentAssistantFeedback_KnowledgeAssistFeedback {
	if x != nil {
		return x.KnowledgeAssistFeedback
	}
	return nil
}

// Represents a record of a human agent assist answer.
type AgentAssistantRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The agent assist answer.
	//
	// Types that are assignable to Answer:
	//
	//	*AgentAssistantRecord_ArticleSuggestionAnswer
	//	*AgentAssistantRecord_FaqAnswer
	//	*AgentAssistantRecord_DialogflowAssistAnswer
	//	*AgentAssistantRecord_GeneratorSuggestion
	Answer isAgentAssistantRecord_Answer `protobuf_oneof:"answer"`
}

func (x *AgentAssistantRecord) Reset() {
	*x = AgentAssistantRecord{}
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentAssistantRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentAssistantRecord) ProtoMessage() {}

func (x *AgentAssistantRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentAssistantRecord.ProtoReflect.Descriptor instead.
func (*AgentAssistantRecord) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{6}
}

func (m *AgentAssistantRecord) GetAnswer() isAgentAssistantRecord_Answer {
	if m != nil {
		return m.Answer
	}
	return nil
}

func (x *AgentAssistantRecord) GetArticleSuggestionAnswer() *ArticleAnswer {
	if x, ok := x.GetAnswer().(*AgentAssistantRecord_ArticleSuggestionAnswer); ok {
		return x.ArticleSuggestionAnswer
	}
	return nil
}

func (x *AgentAssistantRecord) GetFaqAnswer() *FaqAnswer {
	if x, ok := x.GetAnswer().(*AgentAssistantRecord_FaqAnswer); ok {
		return x.FaqAnswer
	}
	return nil
}

func (x *AgentAssistantRecord) GetDialogflowAssistAnswer() *DialogflowAssistAnswer {
	if x, ok := x.GetAnswer().(*AgentAssistantRecord_DialogflowAssistAnswer); ok {
		return x.DialogflowAssistAnswer
	}
	return nil
}

func (x *AgentAssistantRecord) GetGeneratorSuggestion() *GeneratorSuggestion {
	if x, ok := x.GetAnswer().(*AgentAssistantRecord_GeneratorSuggestion); ok {
		return x.GeneratorSuggestion
	}
	return nil
}

type isAgentAssistantRecord_Answer interface {
	isAgentAssistantRecord_Answer()
}

type AgentAssistantRecord_ArticleSuggestionAnswer struct {
	// Output only. The article suggestion answer.
	ArticleSuggestionAnswer *ArticleAnswer `protobuf:"bytes,5,opt,name=article_suggestion_answer,json=articleSuggestionAnswer,proto3,oneof"`
}

type AgentAssistantRecord_FaqAnswer struct {
	// Output only. The FAQ answer.
	FaqAnswer *FaqAnswer `protobuf:"bytes,6,opt,name=faq_answer,json=faqAnswer,proto3,oneof"`
}

type AgentAssistantRecord_DialogflowAssistAnswer struct {
	// Output only. Dialogflow assist answer.
	DialogflowAssistAnswer *DialogflowAssistAnswer `protobuf:"bytes,7,opt,name=dialogflow_assist_answer,json=dialogflowAssistAnswer,proto3,oneof"`
}

type AgentAssistantRecord_GeneratorSuggestion struct {
	// Output only. The generator suggestion.
	GeneratorSuggestion *GeneratorSuggestion `protobuf:"bytes,8,opt,name=generator_suggestion,json=generatorSuggestion,proto3,oneof"`
}

func (*AgentAssistantRecord_ArticleSuggestionAnswer) isAgentAssistantRecord_Answer() {}

func (*AgentAssistantRecord_FaqAnswer) isAgentAssistantRecord_Answer() {}

func (*AgentAssistantRecord_DialogflowAssistAnswer) isAgentAssistantRecord_Answer() {}

func (*AgentAssistantRecord_GeneratorSuggestion) isAgentAssistantRecord_Answer() {}

// Feedback for conversation summarization.
type AgentAssistantFeedback_SummarizationFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp when composing of the summary starts.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Timestamp when the summary was submitted.
	SubmitTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=submit_time,json=submitTime,proto3" json:"submit_time,omitempty"`
	// Text of actual submitted summary.
	SummaryText string `protobuf:"bytes,3,opt,name=summary_text,json=summaryText,proto3" json:"summary_text,omitempty"`
	// Optional. Actual text sections of submitted summary.
	TextSections map[string]string `protobuf:"bytes,4,rep,name=text_sections,json=textSections,proto3" json:"text_sections,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AgentAssistantFeedback_SummarizationFeedback) Reset() {
	*x = AgentAssistantFeedback_SummarizationFeedback{}
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentAssistantFeedback_SummarizationFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentAssistantFeedback_SummarizationFeedback) ProtoMessage() {}

func (x *AgentAssistantFeedback_SummarizationFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentAssistantFeedback_SummarizationFeedback.ProtoReflect.Descriptor instead.
func (*AgentAssistantFeedback_SummarizationFeedback) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{5, 0}
}

func (x *AgentAssistantFeedback_SummarizationFeedback) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *AgentAssistantFeedback_SummarizationFeedback) GetSubmitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmitTime
	}
	return nil
}

func (x *AgentAssistantFeedback_SummarizationFeedback) GetSummaryText() string {
	if x != nil {
		return x.SummaryText
	}
	return ""
}

func (x *AgentAssistantFeedback_SummarizationFeedback) GetTextSections() map[string]string {
	if x != nil {
		return x.TextSections
	}
	return nil
}

// Feedback for knowledge search.
type AgentAssistantFeedback_KnowledgeSearchFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the answer was copied by the human agent or not.
	// If the value is set to be true,
	// [AnswerFeedback.clicked][google.cloud.dialogflow.v2.AnswerFeedback.clicked]
	// will be updated to be true.
	AnswerCopied bool `protobuf:"varint,1,opt,name=answer_copied,json=answerCopied,proto3" json:"answer_copied,omitempty"`
	// The URIs clicked by the human agent. The value is appended for each
	// [UpdateAnswerRecordRequest][google.cloud.dialogflow.v2.UpdateAnswerRecordRequest].
	// If the value is not empty,
	// [AnswerFeedback.clicked][google.cloud.dialogflow.v2.AnswerFeedback.clicked]
	// will be updated to be true.
	ClickedUris []string `protobuf:"bytes,2,rep,name=clicked_uris,json=clickedUris,proto3" json:"clicked_uris,omitempty"`
}

func (x *AgentAssistantFeedback_KnowledgeSearchFeedback) Reset() {
	*x = AgentAssistantFeedback_KnowledgeSearchFeedback{}
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentAssistantFeedback_KnowledgeSearchFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentAssistantFeedback_KnowledgeSearchFeedback) ProtoMessage() {}

func (x *AgentAssistantFeedback_KnowledgeSearchFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentAssistantFeedback_KnowledgeSearchFeedback.ProtoReflect.Descriptor instead.
func (*AgentAssistantFeedback_KnowledgeSearchFeedback) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{5, 1}
}

func (x *AgentAssistantFeedback_KnowledgeSearchFeedback) GetAnswerCopied() bool {
	if x != nil {
		return x.AnswerCopied
	}
	return false
}

func (x *AgentAssistantFeedback_KnowledgeSearchFeedback) GetClickedUris() []string {
	if x != nil {
		return x.ClickedUris
	}
	return nil
}

// Feedback for knowledge assist.
type AgentAssistantFeedback_KnowledgeAssistFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the suggested answer was copied by the human agent.
	// If the value is set to be true,
	// [AnswerFeedback.clicked][google.cloud.dialogflow.v2.AnswerFeedback.clicked]
	// will be updated to be true.
	AnswerCopied bool `protobuf:"varint,1,opt,name=answer_copied,json=answerCopied,proto3" json:"answer_copied,omitempty"`
	// The URIs clicked by the human agent. The value is appended for each
	// UpdateAnswerRecordRequest.
	// If the value is not empty,
	// [AnswerFeedback.clicked][google.cloud.dialogflow.v2.AnswerFeedback.clicked]
	// will be updated to be true.
	ClickedUris []string `protobuf:"bytes,2,rep,name=clicked_uris,json=clickedUris,proto3" json:"clicked_uris,omitempty"`
}

func (x *AgentAssistantFeedback_KnowledgeAssistFeedback) Reset() {
	*x = AgentAssistantFeedback_KnowledgeAssistFeedback{}
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentAssistantFeedback_KnowledgeAssistFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentAssistantFeedback_KnowledgeAssistFeedback) ProtoMessage() {}

func (x *AgentAssistantFeedback_KnowledgeAssistFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentAssistantFeedback_KnowledgeAssistFeedback.ProtoReflect.Descriptor instead.
func (*AgentAssistantFeedback_KnowledgeAssistFeedback) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP(), []int{5, 2}
}

func (x *AgentAssistantFeedback_KnowledgeAssistFeedback) GetAnswerCopied() bool {
	if x != nil {
		return x.AnswerCopied
	}
	return false
}

func (x *AgentAssistantFeedback_KnowledgeAssistFeedback) GetClickedUris() []string {
	if x != nil {
		return x.ClickedUris
	}
	return nil
}

var File_google_cloud_dialogflow_v2_answer_record_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2_answer_record_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9d, 0x03, 0x0a,
	0x0c, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x58, 0x0a, 0x0f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x66, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46, 0x65,
	0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x6d, 0x0a, 0x16, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x5f, 0x72,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x14, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x3a, 0xa5, 0x01, 0xea, 0x41, 0xa1,
	0x01, 0x0a, 0x26, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x30, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x7d, 0x12, 0x45, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x7d, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x22, 0xc5, 0x01, 0x0a,
	0x18, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x12, 0x26, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x94, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0e, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x52, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb1, 0x01, 0x0a, 0x19,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x0d, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0xae, 0x04, 0x0a, 0x0e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x12, 0x68, 0x0a, 0x11, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73,
	0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x2e, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63,
	0x74, 0x6e, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x10, 0x63, 0x6f, 0x72, 0x72,
	0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x7b, 0x0a, 0x1f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x48, 0x00, 0x52, 0x1c, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6c, 0x69,
	0x63, 0x6b, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x63, 0x6c, 0x69, 0x63,
	0x6b, 0x65, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1c,
	0x0a, 0x09, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x09, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x65, 0x64, 0x12, 0x3d, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x70, 0x0a, 0x10, 0x43,
	0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12,
	0x21, 0x0a, 0x1d, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x4c,
	0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43,
	0x54, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x4c, 0x59,
	0x5f, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x46, 0x55,
	0x4c, 0x4c, 0x59, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54, 0x10, 0x03, 0x42, 0x11, 0x0a,
	0x0f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x22, 0xf6, 0x0c, 0x0a, 0x16, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x72, 0x0a, 0x10, 0x61,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x7e, 0x0a, 0x14, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x72, 0x72,
	0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63,
	0x74, 0x6e, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x12,
	0x7b, 0x0a, 0x13, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x66, 0x66, 0x69,
	0x63, 0x69, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41,
	0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65,
	0x6e, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x45, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x84, 0x01, 0x0a,
	0x16, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x73, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x12, 0x8b, 0x01, 0x0a, 0x19, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67,
	0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x2e, 0x4b, 0x6e, 0x6f, 0x77,
	0x6c, 0x65, 0x64, 0x67, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65,
	0x64, 0x67, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x12, 0x8b, 0x01, 0x0a, 0x19, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x5f,
	0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65,
	0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67,
	0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x1a,
	0xfa, 0x02, 0x0a, 0x15, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x54, 0x65, 0x78, 0x74, 0x12, 0x84, 0x01, 0x0a, 0x0d, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41,
	0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65,
	0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x74,
	0x65, 0x78, 0x74, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3f, 0x0a, 0x11, 0x54,
	0x65, 0x78, 0x74, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x61, 0x0a, 0x17,
	0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x5f, 0x63, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x43, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x65, 0x64, 0x55, 0x72, 0x69, 0x73, 0x1a,
	0x61, 0x0a, 0x17, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69,
	0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x43, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x12,
	0x21, 0x0a, 0x0c, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x65, 0x64, 0x55, 0x72,
	0x69, 0x73, 0x22, 0x51, 0x0a, 0x0f, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x6c, 0x65,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x41, 0x4e, 0x53, 0x57, 0x45, 0x52, 0x5f,
	0x52, 0x45, 0x4c, 0x45, 0x56, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x52, 0x52, 0x45, 0x4c,
	0x45, 0x56, 0x41, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x4c, 0x45, 0x56,
	0x41, 0x4e, 0x54, 0x10, 0x02, 0x22, 0x57, 0x0a, 0x13, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x12, 0x24, 0x0a, 0x20,
	0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54,
	0x4e, 0x45, 0x53, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54, 0x10, 0x02, 0x22, 0x59,
	0x0a, 0x12, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x66, 0x66, 0x69, 0x63, 0x69,
	0x65, 0x6e, 0x63, 0x79, 0x12, 0x23, 0x0a, 0x1f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x45, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x45,
	0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x46,
	0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x22, 0xbb, 0x03, 0x0a, 0x14, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x12, 0x6c, 0x0a, 0x19, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x73, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x17, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x12, 0x4b, 0x0a, 0x0a, 0x66, 0x61, 0x71, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x48, 0x00, 0x52, 0x09, 0x66, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x73, 0x0a,
	0x18, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x73, 0x73, 0x69,
	0x73, 0x74, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x16, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x12, 0x69, 0x0a, 0x14, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x13, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0x0a,
	0x06, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x32, 0xad, 0x05, 0x0a, 0x0d, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x12, 0xed, 0x01, 0x0a, 0x11, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6b, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x5a, 0x33, 0x12,
	0x31, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x73, 0x12, 0x25, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x12, 0xb1, 0x02, 0x0a, 0x12, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x22, 0xb9, 0x01, 0xda, 0x41, 0x19, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x96, 0x01, 0x3a, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f,
	0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5a, 0x50, 0x3a, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x32, 0x3f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x61,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x78, 0xca,
	0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0x98, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x42, 0x12, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62,
	0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2_answer_record_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2_answer_record_proto_rawDescData = file_google_cloud_dialogflow_v2_answer_record_proto_rawDesc
)

func file_google_cloud_dialogflow_v2_answer_record_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2_answer_record_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2_answer_record_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2_answer_record_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2_answer_record_proto_rawDescData
}

var file_google_cloud_dialogflow_v2_answer_record_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_dialogflow_v2_answer_record_proto_goTypes = []any{
	(AnswerFeedback_CorrectnessLevel)(0),                   // 0: google.cloud.dialogflow.v2.AnswerFeedback.CorrectnessLevel
	(AgentAssistantFeedback_AnswerRelevance)(0),            // 1: google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance
	(AgentAssistantFeedback_DocumentCorrectness)(0),        // 2: google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness
	(AgentAssistantFeedback_DocumentEfficiency)(0),         // 3: google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency
	(*AnswerRecord)(nil),                                   // 4: google.cloud.dialogflow.v2.AnswerRecord
	(*ListAnswerRecordsRequest)(nil),                       // 5: google.cloud.dialogflow.v2.ListAnswerRecordsRequest
	(*ListAnswerRecordsResponse)(nil),                      // 6: google.cloud.dialogflow.v2.ListAnswerRecordsResponse
	(*UpdateAnswerRecordRequest)(nil),                      // 7: google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
	(*AnswerFeedback)(nil),                                 // 8: google.cloud.dialogflow.v2.AnswerFeedback
	(*AgentAssistantFeedback)(nil),                         // 9: google.cloud.dialogflow.v2.AgentAssistantFeedback
	(*AgentAssistantRecord)(nil),                           // 10: google.cloud.dialogflow.v2.AgentAssistantRecord
	(*AgentAssistantFeedback_SummarizationFeedback)(nil),   // 11: google.cloud.dialogflow.v2.AgentAssistantFeedback.SummarizationFeedback
	(*AgentAssistantFeedback_KnowledgeSearchFeedback)(nil), // 12: google.cloud.dialogflow.v2.AgentAssistantFeedback.KnowledgeSearchFeedback
	(*AgentAssistantFeedback_KnowledgeAssistFeedback)(nil), // 13: google.cloud.dialogflow.v2.AgentAssistantFeedback.KnowledgeAssistFeedback
	nil,                            // 14: google.cloud.dialogflow.v2.AgentAssistantFeedback.SummarizationFeedback.TextSectionsEntry
	(*fieldmaskpb.FieldMask)(nil),  // 15: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),  // 16: google.protobuf.Timestamp
	(*ArticleAnswer)(nil),          // 17: google.cloud.dialogflow.v2.ArticleAnswer
	(*FaqAnswer)(nil),              // 18: google.cloud.dialogflow.v2.FaqAnswer
	(*DialogflowAssistAnswer)(nil), // 19: google.cloud.dialogflow.v2.DialogflowAssistAnswer
	(*GeneratorSuggestion)(nil),    // 20: google.cloud.dialogflow.v2.GeneratorSuggestion
}
var file_google_cloud_dialogflow_v2_answer_record_proto_depIdxs = []int32{
	8,  // 0: google.cloud.dialogflow.v2.AnswerRecord.answer_feedback:type_name -> google.cloud.dialogflow.v2.AnswerFeedback
	10, // 1: google.cloud.dialogflow.v2.AnswerRecord.agent_assistant_record:type_name -> google.cloud.dialogflow.v2.AgentAssistantRecord
	4,  // 2: google.cloud.dialogflow.v2.ListAnswerRecordsResponse.answer_records:type_name -> google.cloud.dialogflow.v2.AnswerRecord
	4,  // 3: google.cloud.dialogflow.v2.UpdateAnswerRecordRequest.answer_record:type_name -> google.cloud.dialogflow.v2.AnswerRecord
	15, // 4: google.cloud.dialogflow.v2.UpdateAnswerRecordRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 5: google.cloud.dialogflow.v2.AnswerFeedback.correctness_level:type_name -> google.cloud.dialogflow.v2.AnswerFeedback.CorrectnessLevel
	9,  // 6: google.cloud.dialogflow.v2.AnswerFeedback.agent_assistant_detail_feedback:type_name -> google.cloud.dialogflow.v2.AgentAssistantFeedback
	16, // 7: google.cloud.dialogflow.v2.AnswerFeedback.click_time:type_name -> google.protobuf.Timestamp
	16, // 8: google.cloud.dialogflow.v2.AnswerFeedback.display_time:type_name -> google.protobuf.Timestamp
	1,  // 9: google.cloud.dialogflow.v2.AgentAssistantFeedback.answer_relevance:type_name -> google.cloud.dialogflow.v2.AgentAssistantFeedback.AnswerRelevance
	2,  // 10: google.cloud.dialogflow.v2.AgentAssistantFeedback.document_correctness:type_name -> google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentCorrectness
	3,  // 11: google.cloud.dialogflow.v2.AgentAssistantFeedback.document_efficiency:type_name -> google.cloud.dialogflow.v2.AgentAssistantFeedback.DocumentEfficiency
	11, // 12: google.cloud.dialogflow.v2.AgentAssistantFeedback.summarization_feedback:type_name -> google.cloud.dialogflow.v2.AgentAssistantFeedback.SummarizationFeedback
	12, // 13: google.cloud.dialogflow.v2.AgentAssistantFeedback.knowledge_search_feedback:type_name -> google.cloud.dialogflow.v2.AgentAssistantFeedback.KnowledgeSearchFeedback
	13, // 14: google.cloud.dialogflow.v2.AgentAssistantFeedback.knowledge_assist_feedback:type_name -> google.cloud.dialogflow.v2.AgentAssistantFeedback.KnowledgeAssistFeedback
	17, // 15: google.cloud.dialogflow.v2.AgentAssistantRecord.article_suggestion_answer:type_name -> google.cloud.dialogflow.v2.ArticleAnswer
	18, // 16: google.cloud.dialogflow.v2.AgentAssistantRecord.faq_answer:type_name -> google.cloud.dialogflow.v2.FaqAnswer
	19, // 17: google.cloud.dialogflow.v2.AgentAssistantRecord.dialogflow_assist_answer:type_name -> google.cloud.dialogflow.v2.DialogflowAssistAnswer
	20, // 18: google.cloud.dialogflow.v2.AgentAssistantRecord.generator_suggestion:type_name -> google.cloud.dialogflow.v2.GeneratorSuggestion
	16, // 19: google.cloud.dialogflow.v2.AgentAssistantFeedback.SummarizationFeedback.start_time:type_name -> google.protobuf.Timestamp
	16, // 20: google.cloud.dialogflow.v2.AgentAssistantFeedback.SummarizationFeedback.submit_time:type_name -> google.protobuf.Timestamp
	14, // 21: google.cloud.dialogflow.v2.AgentAssistantFeedback.SummarizationFeedback.text_sections:type_name -> google.cloud.dialogflow.v2.AgentAssistantFeedback.SummarizationFeedback.TextSectionsEntry
	5,  // 22: google.cloud.dialogflow.v2.AnswerRecords.ListAnswerRecords:input_type -> google.cloud.dialogflow.v2.ListAnswerRecordsRequest
	7,  // 23: google.cloud.dialogflow.v2.AnswerRecords.UpdateAnswerRecord:input_type -> google.cloud.dialogflow.v2.UpdateAnswerRecordRequest
	6,  // 24: google.cloud.dialogflow.v2.AnswerRecords.ListAnswerRecords:output_type -> google.cloud.dialogflow.v2.ListAnswerRecordsResponse
	4,  // 25: google.cloud.dialogflow.v2.AnswerRecords.UpdateAnswerRecord:output_type -> google.cloud.dialogflow.v2.AnswerRecord
	24, // [24:26] is the sub-list for method output_type
	22, // [22:24] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2_answer_record_proto_init() }
func file_google_cloud_dialogflow_v2_answer_record_proto_init() {
	if File_google_cloud_dialogflow_v2_answer_record_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2_generator_proto_init()
	file_google_cloud_dialogflow_v2_participant_proto_init()
	file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[0].OneofWrappers = []any{
		(*AnswerRecord_AgentAssistantRecord)(nil),
	}
	file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[4].OneofWrappers = []any{
		(*AnswerFeedback_AgentAssistantDetailFeedback)(nil),
	}
	file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes[6].OneofWrappers = []any{
		(*AgentAssistantRecord_ArticleSuggestionAnswer)(nil),
		(*AgentAssistantRecord_FaqAnswer)(nil),
		(*AgentAssistantRecord_DialogflowAssistAnswer)(nil),
		(*AgentAssistantRecord_GeneratorSuggestion)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2_answer_record_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2_answer_record_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2_answer_record_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2_answer_record_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2_answer_record_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2_answer_record_proto = out.File
	file_google_cloud_dialogflow_v2_answer_record_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2_answer_record_proto_goTypes = nil
	file_google_cloud_dialogflow_v2_answer_record_proto_depIdxs = nil
}
