// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/cx/v3/tool.proto

package cxpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the type of the tool.
type Tool_ToolType int32

const (
	// Default value. This value is unused.
	Tool_TOOL_TYPE_UNSPECIFIED Tool_ToolType = 0
	// Customer provided tool.
	Tool_CUSTOMIZED_TOOL Tool_ToolType = 1
	// First party built-in tool created by Dialogflow which cannot be modified.
	Tool_BUILTIN_TOOL Tool_ToolType = 2
)

// Enum value maps for Tool_ToolType.
var (
	Tool_ToolType_name = map[int32]string{
		0: "TOOL_TYPE_UNSPECIFIED",
		1: "CUSTOMIZED_TOOL",
		2: "BUILTIN_TOOL",
	}
	Tool_ToolType_value = map[string]int32{
		"TOOL_TYPE_UNSPECIFIED": 0,
		"CUSTOMIZED_TOOL":       1,
		"BUILTIN_TOOL":          2,
	}
)

func (x Tool_ToolType) Enum() *Tool_ToolType {
	p := new(Tool_ToolType)
	*p = x
	return p
}

func (x Tool_ToolType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_ToolType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_enumTypes[0].Descriptor()
}

func (Tool_ToolType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_tool_proto_enumTypes[0]
}

func (x Tool_ToolType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_ToolType.Descriptor instead.
func (Tool_ToolType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 0}
}

// The location of the API key in the request.
type Tool_Authentication_RequestLocation int32

const (
	// Default value. This value is unused.
	Tool_Authentication_REQUEST_LOCATION_UNSPECIFIED Tool_Authentication_RequestLocation = 0
	// Represents the key in http header.
	Tool_Authentication_HEADER Tool_Authentication_RequestLocation = 1
	// Represents the key in query string.
	Tool_Authentication_QUERY_STRING Tool_Authentication_RequestLocation = 2
)

// Enum value maps for Tool_Authentication_RequestLocation.
var (
	Tool_Authentication_RequestLocation_name = map[int32]string{
		0: "REQUEST_LOCATION_UNSPECIFIED",
		1: "HEADER",
		2: "QUERY_STRING",
	}
	Tool_Authentication_RequestLocation_value = map[string]int32{
		"REQUEST_LOCATION_UNSPECIFIED": 0,
		"HEADER":                       1,
		"QUERY_STRING":                 2,
	}
)

func (x Tool_Authentication_RequestLocation) Enum() *Tool_Authentication_RequestLocation {
	p := new(Tool_Authentication_RequestLocation)
	*p = x
	return p
}

func (x Tool_Authentication_RequestLocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_Authentication_RequestLocation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_enumTypes[1].Descriptor()
}

func (Tool_Authentication_RequestLocation) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_tool_proto_enumTypes[1]
}

func (x Tool_Authentication_RequestLocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_Authentication_RequestLocation.Descriptor instead.
func (Tool_Authentication_RequestLocation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 3, 0}
}

// OAuth grant types. Only [client credential
// grant](https://oauth.net/2/grant-types/client-credentials) is
// supported.
type Tool_Authentication_OAuthConfig_OauthGrantType int32

const (
	// Default value. This value is unused.
	Tool_Authentication_OAuthConfig_OAUTH_GRANT_TYPE_UNSPECIFIED Tool_Authentication_OAuthConfig_OauthGrantType = 0
	// Represents the [client credential
	// flow](https://oauth.net/2/grant-types/client-credentials).
	Tool_Authentication_OAuthConfig_CLIENT_CREDENTIAL Tool_Authentication_OAuthConfig_OauthGrantType = 1
)

// Enum value maps for Tool_Authentication_OAuthConfig_OauthGrantType.
var (
	Tool_Authentication_OAuthConfig_OauthGrantType_name = map[int32]string{
		0: "OAUTH_GRANT_TYPE_UNSPECIFIED",
		1: "CLIENT_CREDENTIAL",
	}
	Tool_Authentication_OAuthConfig_OauthGrantType_value = map[string]int32{
		"OAUTH_GRANT_TYPE_UNSPECIFIED": 0,
		"CLIENT_CREDENTIAL":            1,
	}
)

func (x Tool_Authentication_OAuthConfig_OauthGrantType) Enum() *Tool_Authentication_OAuthConfig_OauthGrantType {
	p := new(Tool_Authentication_OAuthConfig_OauthGrantType)
	*p = x
	return p
}

func (x Tool_Authentication_OAuthConfig_OauthGrantType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_Authentication_OAuthConfig_OauthGrantType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_enumTypes[2].Descriptor()
}

func (Tool_Authentication_OAuthConfig_OauthGrantType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_tool_proto_enumTypes[2]
}

func (x Tool_Authentication_OAuthConfig_OauthGrantType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_Authentication_OAuthConfig_OauthGrantType.Descriptor instead.
func (Tool_Authentication_OAuthConfig_OauthGrantType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 3, 1, 0}
}

// Indicate the auth token type generated from the [Diglogflow service
// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
type Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth int32

const (
	// Service agent auth type unspecified. Default to ID_TOKEN.
	Tool_Authentication_ServiceAgentAuthConfig_SERVICE_AGENT_AUTH_UNSPECIFIED Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth = 0
	// Use [ID
	// token](https://cloud.google.com/docs/authentication/token-types#id)
	// generated from service agent. This can be used to access Cloud
	// Function and Cloud Run after you grant Invoker role to
	// `service-<PROJECT-NUMBER>@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	Tool_Authentication_ServiceAgentAuthConfig_ID_TOKEN Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth = 1
	// Use [access
	// token](https://cloud.google.com/docs/authentication/token-types#access)
	// generated from service agent. This can be used to access other Google
	// Cloud APIs after you grant required roles to
	// `service-<PROJECT-NUMBER>@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	Tool_Authentication_ServiceAgentAuthConfig_ACCESS_TOKEN Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth = 2
)

// Enum value maps for Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth.
var (
	Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth_name = map[int32]string{
		0: "SERVICE_AGENT_AUTH_UNSPECIFIED",
		1: "ID_TOKEN",
		2: "ACCESS_TOKEN",
	}
	Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth_value = map[string]int32{
		"SERVICE_AGENT_AUTH_UNSPECIFIED": 0,
		"ID_TOKEN":                       1,
		"ACCESS_TOKEN":                   2,
	}
)

func (x Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth) Enum() *Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth {
	p := new(Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth)
	*p = x
	return p
}

func (x Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_enumTypes[3].Descriptor()
}

func (Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_tool_proto_enumTypes[3]
}

func (x Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth.Descriptor instead.
func (Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 3, 2, 0}
}

// The request message for
// [Tools.CreateTool][google.cloud.dialogflow.cx.v3.Tools.CreateTool].
type CreateToolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to create a Tool for.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Tool to be created.
	Tool *Tool `protobuf:"bytes,2,opt,name=tool,proto3" json:"tool,omitempty"`
}

func (x *CreateToolRequest) Reset() {
	*x = CreateToolRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateToolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateToolRequest) ProtoMessage() {}

func (x *CreateToolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateToolRequest.ProtoReflect.Descriptor instead.
func (*CreateToolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{0}
}

func (x *CreateToolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateToolRequest) GetTool() *Tool {
	if x != nil {
		return x.Tool
	}
	return nil
}

// The request message for
// [Tools.ListTools][google.cloud.dialogflow.cx.v3.Tools.ListTools].
type ListToolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to list the Tools from.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListToolsRequest) Reset() {
	*x = ListToolsRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListToolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListToolsRequest) ProtoMessage() {}

func (x *ListToolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListToolsRequest.ProtoReflect.Descriptor instead.
func (*ListToolsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{1}
}

func (x *ListToolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListToolsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListToolsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Tools.ListTools][google.cloud.dialogflow.cx.v3.Tools.ListTools].
type ListToolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Tools. There will be a maximum number of items returned
	// based on the page_size field in the request.
	Tools []*Tool `protobuf:"bytes,1,rep,name=tools,proto3" json:"tools,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListToolsResponse) Reset() {
	*x = ListToolsResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListToolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListToolsResponse) ProtoMessage() {}

func (x *ListToolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListToolsResponse.ProtoReflect.Descriptor instead.
func (*ListToolsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{2}
}

func (x *ListToolsResponse) GetTools() []*Tool {
	if x != nil {
		return x.Tools
	}
	return nil
}

func (x *ListToolsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Tools.GetTool][google.cloud.dialogflow.cx.v3.Tools.GetTool].
type GetToolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Tool.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetToolRequest) Reset() {
	*x = GetToolRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetToolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetToolRequest) ProtoMessage() {}

func (x *GetToolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetToolRequest.ProtoReflect.Descriptor instead.
func (*GetToolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{3}
}

func (x *GetToolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Tools.UpdateTool][google.cloud.dialogflow.cx.v3.Tools.UpdateTool].
type UpdateToolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Tool to be updated.
	Tool *Tool `protobuf:"bytes,1,opt,name=tool,proto3" json:"tool,omitempty"`
	// The mask to control which fields get updated. If the mask is not present,
	// all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateToolRequest) Reset() {
	*x = UpdateToolRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateToolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateToolRequest) ProtoMessage() {}

func (x *UpdateToolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateToolRequest.ProtoReflect.Descriptor instead.
func (*UpdateToolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateToolRequest) GetTool() *Tool {
	if x != nil {
		return x.Tool
	}
	return nil
}

func (x *UpdateToolRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for
// [Tools.DeleteTool][google.cloud.dialogflow.cx.v3.Tools.DeleteTool].
type DeleteToolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Tool to be deleted.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This field has no effect for Tools not being used.
	// For Tools that are used:
	//
	//   - If `force` is set to false, an error will be returned with message
	//     indicating the referenced resources.
	//   - If `force` is set to true, Dialogflow will remove the tool, as well
	//     as any references to the tool.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteToolRequest) Reset() {
	*x = DeleteToolRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteToolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteToolRequest) ProtoMessage() {}

func (x *DeleteToolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteToolRequest.ProtoReflect.Descriptor instead.
func (*DeleteToolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteToolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteToolRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// A tool provides a list of actions which are available to the
// [Playbook][google.cloud.dialogflow.cx.v3.Playbook] to attain its goal. A Tool
// consists of a description of the tool's usage and a specification of the tool
// which contains the schema and authentication information.
type Tool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the Tool.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the Tool, unique within an agent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. High level description of the Tool and its usage.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Specification of the Tool.
	//
	// Types that are assignable to Specification:
	//
	//	*Tool_OpenApiSpec
	//	*Tool_DataStoreSpec
	//	*Tool_FunctionSpec
	Specification isTool_Specification `protobuf_oneof:"specification"`
	// Output only. The tool type.
	ToolType Tool_ToolType `protobuf:"varint,12,opt,name=tool_type,json=toolType,proto3,enum=google.cloud.dialogflow.cx.v3.Tool_ToolType" json:"tool_type,omitempty"`
}

func (x *Tool) Reset() {
	*x = Tool{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool) ProtoMessage() {}

func (x *Tool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool.ProtoReflect.Descriptor instead.
func (*Tool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6}
}

func (x *Tool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Tool) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Tool) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *Tool) GetSpecification() isTool_Specification {
	if m != nil {
		return m.Specification
	}
	return nil
}

func (x *Tool) GetOpenApiSpec() *Tool_OpenApiTool {
	if x, ok := x.GetSpecification().(*Tool_OpenApiSpec); ok {
		return x.OpenApiSpec
	}
	return nil
}

func (x *Tool) GetDataStoreSpec() *Tool_DataStoreTool {
	if x, ok := x.GetSpecification().(*Tool_DataStoreSpec); ok {
		return x.DataStoreSpec
	}
	return nil
}

func (x *Tool) GetFunctionSpec() *Tool_FunctionTool {
	if x, ok := x.GetSpecification().(*Tool_FunctionSpec); ok {
		return x.FunctionSpec
	}
	return nil
}

func (x *Tool) GetToolType() Tool_ToolType {
	if x != nil {
		return x.ToolType
	}
	return Tool_TOOL_TYPE_UNSPECIFIED
}

type isTool_Specification interface {
	isTool_Specification()
}

type Tool_OpenApiSpec struct {
	// OpenAPI specification of the Tool.
	OpenApiSpec *Tool_OpenApiTool `protobuf:"bytes,4,opt,name=open_api_spec,json=openApiSpec,proto3,oneof"`
}

type Tool_DataStoreSpec struct {
	// Data store search tool specification.
	DataStoreSpec *Tool_DataStoreTool `protobuf:"bytes,8,opt,name=data_store_spec,json=dataStoreSpec,proto3,oneof"`
}

type Tool_FunctionSpec struct {
	// Client side executed function specification.
	FunctionSpec *Tool_FunctionTool `protobuf:"bytes,13,opt,name=function_spec,json=functionSpec,proto3,oneof"`
}

func (*Tool_OpenApiSpec) isTool_Specification() {}

func (*Tool_DataStoreSpec) isTool_Specification() {}

func (*Tool_FunctionSpec) isTool_Specification() {}

// The request message for
// [Tools.ListToolVersions][google.cloud.dialogflow.cx.v3.Tools.ListToolVersions].
type ListToolVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent of the tool versions.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListToolVersionsRequest) Reset() {
	*x = ListToolVersionsRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListToolVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListToolVersionsRequest) ProtoMessage() {}

func (x *ListToolVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListToolVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListToolVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{7}
}

func (x *ListToolVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListToolVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListToolVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Tools.ListToolVersions][google.cloud.dialogflow.cx.v3.Tools.ListToolVersions].
type ListToolVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of tool versions. There will be a maximum number of items
	// returned based on the page_size field in the request.
	ToolVersions []*ToolVersion `protobuf:"bytes,1,rep,name=tool_versions,json=toolVersions,proto3" json:"tool_versions,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListToolVersionsResponse) Reset() {
	*x = ListToolVersionsResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListToolVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListToolVersionsResponse) ProtoMessage() {}

func (x *ListToolVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListToolVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListToolVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{8}
}

func (x *ListToolVersionsResponse) GetToolVersions() []*ToolVersion {
	if x != nil {
		return x.ToolVersions
	}
	return nil
}

func (x *ListToolVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Tools.CreateToolVersion][google.cloud.dialogflow.cx.v3.Tools.CreateToolVersion].
// The request message for
// [Tools.CreateToolVersion][google.cloud.dialogflow.cx.v3.Tools.CreateToolVersion].
type CreateToolVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The tool to create a version for.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The tool version to create.
	ToolVersion *ToolVersion `protobuf:"bytes,2,opt,name=tool_version,json=toolVersion,proto3" json:"tool_version,omitempty"`
}

func (x *CreateToolVersionRequest) Reset() {
	*x = CreateToolVersionRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateToolVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateToolVersionRequest) ProtoMessage() {}

func (x *CreateToolVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateToolVersionRequest.ProtoReflect.Descriptor instead.
func (*CreateToolVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{9}
}

func (x *CreateToolVersionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateToolVersionRequest) GetToolVersion() *ToolVersion {
	if x != nil {
		return x.ToolVersion
	}
	return nil
}

// The request message for
// [Tools.GetToolVersion][google.cloud.dialogflow.cx.v3.Tools.GetToolVersion].
type GetToolVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tool version.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>/versions/<VersionID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetToolVersionRequest) Reset() {
	*x = GetToolVersionRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetToolVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetToolVersionRequest) ProtoMessage() {}

func (x *GetToolVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetToolVersionRequest.ProtoReflect.Descriptor instead.
func (*GetToolVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{10}
}

func (x *GetToolVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Tools.DeleteToolVersion][google.cloud.dialogflow.cx.v3.Tools.DeleteToolVersion].
type DeleteToolVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tool version to delete.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>/versions/<VersionID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. This field has no effect for Tools not being used.
	// For Tools that are used:
	//
	//   - If `force` is set to false, an error will be returned with message
	//     indicating the referenced resources.
	//   - If `force` is set to true, Dialogflow will remove the tool, as well
	//     as any references to the tool.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteToolVersionRequest) Reset() {
	*x = DeleteToolVersionRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteToolVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteToolVersionRequest) ProtoMessage() {}

func (x *DeleteToolVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteToolVersionRequest.ProtoReflect.Descriptor instead.
func (*DeleteToolVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteToolVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteToolVersionRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The request message for
// [Tools.RestoreToolVersion][google.cloud.dialogflow.cx.v3.Tools.RestoreToolVersion].
type RestoreToolVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tool version.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>/versions/<VersionID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RestoreToolVersionRequest) Reset() {
	*x = RestoreToolVersionRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestoreToolVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreToolVersionRequest) ProtoMessage() {}

func (x *RestoreToolVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreToolVersionRequest.ProtoReflect.Descriptor instead.
func (*RestoreToolVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{12}
}

func (x *RestoreToolVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response message for
// [Tools.RestoreToolVersion][google.cloud.dialogflow.cx.v3.Tools.RestoreToolVersion].
type RestoreToolVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The updated tool.
	Tool *Tool `protobuf:"bytes,2,opt,name=tool,proto3" json:"tool,omitempty"`
}

func (x *RestoreToolVersionResponse) Reset() {
	*x = RestoreToolVersionResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestoreToolVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreToolVersionResponse) ProtoMessage() {}

func (x *RestoreToolVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreToolVersionResponse.ProtoReflect.Descriptor instead.
func (*RestoreToolVersionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{13}
}

func (x *RestoreToolVersionResponse) GetTool() *Tool {
	if x != nil {
		return x.Tool
	}
	return nil
}

// Tool version is a snapshot of the tool at certain timestamp.
type ToolVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The unique identifier of the tool version.
	//
	//	Format:
	//
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>/versions/<VersionID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the tool version.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Snapshot of the tool to be associated with this version.
	Tool *Tool `protobuf:"bytes,3,opt,name=tool,proto3" json:"tool,omitempty"`
	// Output only. Last time the tool version was created or modified.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last time the tool version was created or modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *ToolVersion) Reset() {
	*x = ToolVersion{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolVersion) ProtoMessage() {}

func (x *ToolVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolVersion.ProtoReflect.Descriptor instead.
func (*ToolVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{14}
}

func (x *ToolVersion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ToolVersion) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ToolVersion) GetTool() *Tool {
	if x != nil {
		return x.Tool
	}
	return nil
}

func (x *ToolVersion) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ToolVersion) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// An OpenAPI tool is a way to provide the Tool specifications in the Open API
// schema format.
type Tool_OpenApiTool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Schema representation.
	//
	// Types that are assignable to Schema:
	//
	//	*Tool_OpenApiTool_TextSchema
	Schema isTool_OpenApiTool_Schema `protobuf_oneof:"schema"`
	// Optional. Authentication information required by the API.
	Authentication *Tool_Authentication `protobuf:"bytes,2,opt,name=authentication,proto3" json:"authentication,omitempty"`
	// Optional. TLS configuration for the HTTPS verification.
	TlsConfig *Tool_TLSConfig `protobuf:"bytes,3,opt,name=tls_config,json=tlsConfig,proto3" json:"tls_config,omitempty"`
	// Optional. Service Directory configuration.
	ServiceDirectoryConfig *Tool_ServiceDirectoryConfig `protobuf:"bytes,4,opt,name=service_directory_config,json=serviceDirectoryConfig,proto3" json:"service_directory_config,omitempty"`
}

func (x *Tool_OpenApiTool) Reset() {
	*x = Tool_OpenApiTool{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_OpenApiTool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_OpenApiTool) ProtoMessage() {}

func (x *Tool_OpenApiTool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_OpenApiTool.ProtoReflect.Descriptor instead.
func (*Tool_OpenApiTool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 0}
}

func (m *Tool_OpenApiTool) GetSchema() isTool_OpenApiTool_Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (x *Tool_OpenApiTool) GetTextSchema() string {
	if x, ok := x.GetSchema().(*Tool_OpenApiTool_TextSchema); ok {
		return x.TextSchema
	}
	return ""
}

func (x *Tool_OpenApiTool) GetAuthentication() *Tool_Authentication {
	if x != nil {
		return x.Authentication
	}
	return nil
}

func (x *Tool_OpenApiTool) GetTlsConfig() *Tool_TLSConfig {
	if x != nil {
		return x.TlsConfig
	}
	return nil
}

func (x *Tool_OpenApiTool) GetServiceDirectoryConfig() *Tool_ServiceDirectoryConfig {
	if x != nil {
		return x.ServiceDirectoryConfig
	}
	return nil
}

type isTool_OpenApiTool_Schema interface {
	isTool_OpenApiTool_Schema()
}

type Tool_OpenApiTool_TextSchema struct {
	// Required. The OpenAPI schema specified as a text.
	TextSchema string `protobuf:"bytes,1,opt,name=text_schema,json=textSchema,proto3,oneof"`
}

func (*Tool_OpenApiTool_TextSchema) isTool_OpenApiTool_Schema() {}

// A DataStoreTool is a way to provide specifications needed to search a
// list of data stores.
type Tool_DataStoreTool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of data stores to search.
	DataStoreConnections []*DataStoreConnection `protobuf:"bytes,1,rep,name=data_store_connections,json=dataStoreConnections,proto3" json:"data_store_connections,omitempty"`
	// Required. Fallback prompt configurations to use.
	FallbackPrompt *Tool_DataStoreTool_FallbackPrompt `protobuf:"bytes,3,opt,name=fallback_prompt,json=fallbackPrompt,proto3" json:"fallback_prompt,omitempty"`
}

func (x *Tool_DataStoreTool) Reset() {
	*x = Tool_DataStoreTool{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_DataStoreTool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_DataStoreTool) ProtoMessage() {}

func (x *Tool_DataStoreTool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_DataStoreTool.ProtoReflect.Descriptor instead.
func (*Tool_DataStoreTool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Tool_DataStoreTool) GetDataStoreConnections() []*DataStoreConnection {
	if x != nil {
		return x.DataStoreConnections
	}
	return nil
}

func (x *Tool_DataStoreTool) GetFallbackPrompt() *Tool_DataStoreTool_FallbackPrompt {
	if x != nil {
		return x.FallbackPrompt
	}
	return nil
}

// A Function tool describes the functions to be invoked on the client side.
type Tool_FunctionTool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The JSON schema is encapsulated in a
	// [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
	// the function. This input is a JSON object that contains the function's
	// parameters as properties of the object.
	InputSchema *structpb.Struct `protobuf:"bytes,1,opt,name=input_schema,json=inputSchema,proto3" json:"input_schema,omitempty"`
	// Optional. The JSON schema is encapsulated in a
	// [google.protobuf.Struct][google.protobuf.Struct] to describe the output
	// of the function. This output is a JSON object that contains the
	// function's parameters as properties of the object.
	OutputSchema *structpb.Struct `protobuf:"bytes,2,opt,name=output_schema,json=outputSchema,proto3" json:"output_schema,omitempty"`
}

func (x *Tool_FunctionTool) Reset() {
	*x = Tool_FunctionTool{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_FunctionTool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_FunctionTool) ProtoMessage() {}

func (x *Tool_FunctionTool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_FunctionTool.ProtoReflect.Descriptor instead.
func (*Tool_FunctionTool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 2}
}

func (x *Tool_FunctionTool) GetInputSchema() *structpb.Struct {
	if x != nil {
		return x.InputSchema
	}
	return nil
}

func (x *Tool_FunctionTool) GetOutputSchema() *structpb.Struct {
	if x != nil {
		return x.OutputSchema
	}
	return nil
}

// Authentication information required for API calls
type Tool_Authentication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The auth configuration.
	//
	// Types that are assignable to AuthConfig:
	//
	//	*Tool_Authentication_ApiKeyConfig_
	//	*Tool_Authentication_OauthConfig
	//	*Tool_Authentication_ServiceAgentAuthConfig_
	//	*Tool_Authentication_BearerTokenConfig_
	//	*Tool_Authentication_ServiceAccountAuthConfig_
	AuthConfig isTool_Authentication_AuthConfig `protobuf_oneof:"auth_config"`
}

func (x *Tool_Authentication) Reset() {
	*x = Tool_Authentication{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_Authentication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication) ProtoMessage() {}

func (x *Tool_Authentication) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication.ProtoReflect.Descriptor instead.
func (*Tool_Authentication) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 3}
}

func (m *Tool_Authentication) GetAuthConfig() isTool_Authentication_AuthConfig {
	if m != nil {
		return m.AuthConfig
	}
	return nil
}

func (x *Tool_Authentication) GetApiKeyConfig() *Tool_Authentication_ApiKeyConfig {
	if x, ok := x.GetAuthConfig().(*Tool_Authentication_ApiKeyConfig_); ok {
		return x.ApiKeyConfig
	}
	return nil
}

func (x *Tool_Authentication) GetOauthConfig() *Tool_Authentication_OAuthConfig {
	if x, ok := x.GetAuthConfig().(*Tool_Authentication_OauthConfig); ok {
		return x.OauthConfig
	}
	return nil
}

func (x *Tool_Authentication) GetServiceAgentAuthConfig() *Tool_Authentication_ServiceAgentAuthConfig {
	if x, ok := x.GetAuthConfig().(*Tool_Authentication_ServiceAgentAuthConfig_); ok {
		return x.ServiceAgentAuthConfig
	}
	return nil
}

func (x *Tool_Authentication) GetBearerTokenConfig() *Tool_Authentication_BearerTokenConfig {
	if x, ok := x.GetAuthConfig().(*Tool_Authentication_BearerTokenConfig_); ok {
		return x.BearerTokenConfig
	}
	return nil
}

func (x *Tool_Authentication) GetServiceAccountAuthConfig() *Tool_Authentication_ServiceAccountAuthConfig {
	if x, ok := x.GetAuthConfig().(*Tool_Authentication_ServiceAccountAuthConfig_); ok {
		return x.ServiceAccountAuthConfig
	}
	return nil
}

type isTool_Authentication_AuthConfig interface {
	isTool_Authentication_AuthConfig()
}

type Tool_Authentication_ApiKeyConfig_ struct {
	// Config for API key auth.
	ApiKeyConfig *Tool_Authentication_ApiKeyConfig `protobuf:"bytes,1,opt,name=api_key_config,json=apiKeyConfig,proto3,oneof"`
}

type Tool_Authentication_OauthConfig struct {
	// Config for OAuth.
	OauthConfig *Tool_Authentication_OAuthConfig `protobuf:"bytes,2,opt,name=oauth_config,json=oauthConfig,proto3,oneof"`
}

type Tool_Authentication_ServiceAgentAuthConfig_ struct {
	// Config for [Diglogflow service
	// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
	// auth.
	ServiceAgentAuthConfig *Tool_Authentication_ServiceAgentAuthConfig `protobuf:"bytes,3,opt,name=service_agent_auth_config,json=serviceAgentAuthConfig,proto3,oneof"`
}

type Tool_Authentication_BearerTokenConfig_ struct {
	// Config for bearer token auth.
	BearerTokenConfig *Tool_Authentication_BearerTokenConfig `protobuf:"bytes,4,opt,name=bearer_token_config,json=bearerTokenConfig,proto3,oneof"`
}

type Tool_Authentication_ServiceAccountAuthConfig_ struct {
	// Configuration for service account authentication.
	ServiceAccountAuthConfig *Tool_Authentication_ServiceAccountAuthConfig `protobuf:"bytes,5,opt,name=service_account_auth_config,json=serviceAccountAuthConfig,proto3,oneof"`
}

func (*Tool_Authentication_ApiKeyConfig_) isTool_Authentication_AuthConfig() {}

func (*Tool_Authentication_OauthConfig) isTool_Authentication_AuthConfig() {}

func (*Tool_Authentication_ServiceAgentAuthConfig_) isTool_Authentication_AuthConfig() {}

func (*Tool_Authentication_BearerTokenConfig_) isTool_Authentication_AuthConfig() {}

func (*Tool_Authentication_ServiceAccountAuthConfig_) isTool_Authentication_AuthConfig() {}

// The TLS configuration.
type Tool_TLSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies a list of allowed custom CA certificates for HTTPS
	// verification.
	CaCerts []*Tool_TLSConfig_CACert `protobuf:"bytes,1,rep,name=ca_certs,json=caCerts,proto3" json:"ca_certs,omitempty"`
}

func (x *Tool_TLSConfig) Reset() {
	*x = Tool_TLSConfig{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_TLSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_TLSConfig) ProtoMessage() {}

func (x *Tool_TLSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_TLSConfig.ProtoReflect.Descriptor instead.
func (*Tool_TLSConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 4}
}

func (x *Tool_TLSConfig) GetCaCerts() []*Tool_TLSConfig_CACert {
	if x != nil {
		return x.CaCerts
	}
	return nil
}

// Configuration for tools using Service Directory.
type Tool_ServiceDirectoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of [Service
	// Directory](https://cloud.google.com/service-directory) service.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/namespaces/<NamespaceID>/services/<ServiceID>`.
	// `LocationID` of the service directory must be the same as the location
	// of the agent.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
}

func (x *Tool_ServiceDirectoryConfig) Reset() {
	*x = Tool_ServiceDirectoryConfig{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_ServiceDirectoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_ServiceDirectoryConfig) ProtoMessage() {}

func (x *Tool_ServiceDirectoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_ServiceDirectoryConfig.ProtoReflect.Descriptor instead.
func (*Tool_ServiceDirectoryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 5}
}

func (x *Tool_ServiceDirectoryConfig) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

// A FallbackPrompt is a way to provide specifications for the Data Store
// fallback prompt when generating responses.
type Tool_DataStoreTool_FallbackPrompt struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Tool_DataStoreTool_FallbackPrompt) Reset() {
	*x = Tool_DataStoreTool_FallbackPrompt{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_DataStoreTool_FallbackPrompt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_DataStoreTool_FallbackPrompt) ProtoMessage() {}

func (x *Tool_DataStoreTool_FallbackPrompt) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_DataStoreTool_FallbackPrompt.ProtoReflect.Descriptor instead.
func (*Tool_DataStoreTool_FallbackPrompt) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 1, 0}
}

// Config for authentication with API key.
type Tool_Authentication_ApiKeyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parameter name or the header name of the API key.
	// E.g., If the API request is "https://example.com/act?X-Api-Key=<API
	// KEY>", "X-Api-Key" would be the parameter name.
	KeyName string `protobuf:"bytes,1,opt,name=key_name,json=keyName,proto3" json:"key_name,omitempty"`
	// Optional. The API key. If the `secret_version_for_api_key` field is
	// set, this field will be ignored.
	ApiKey string `protobuf:"bytes,2,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
	// Optional. The name of the SecretManager secret version resource storing
	// the API key. If this field is set, the `api_key` field will be ignored.
	// Format: `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForApiKey string `protobuf:"bytes,4,opt,name=secret_version_for_api_key,json=secretVersionForApiKey,proto3" json:"secret_version_for_api_key,omitempty"`
	// Required. Key location in the request.
	RequestLocation Tool_Authentication_RequestLocation `protobuf:"varint,3,opt,name=request_location,json=requestLocation,proto3,enum=google.cloud.dialogflow.cx.v3.Tool_Authentication_RequestLocation" json:"request_location,omitempty"`
}

func (x *Tool_Authentication_ApiKeyConfig) Reset() {
	*x = Tool_Authentication_ApiKeyConfig{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_Authentication_ApiKeyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication_ApiKeyConfig) ProtoMessage() {}

func (x *Tool_Authentication_ApiKeyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication_ApiKeyConfig.ProtoReflect.Descriptor instead.
func (*Tool_Authentication_ApiKeyConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 3, 0}
}

func (x *Tool_Authentication_ApiKeyConfig) GetKeyName() string {
	if x != nil {
		return x.KeyName
	}
	return ""
}

func (x *Tool_Authentication_ApiKeyConfig) GetApiKey() string {
	if x != nil {
		return x.ApiKey
	}
	return ""
}

func (x *Tool_Authentication_ApiKeyConfig) GetSecretVersionForApiKey() string {
	if x != nil {
		return x.SecretVersionForApiKey
	}
	return ""
}

func (x *Tool_Authentication_ApiKeyConfig) GetRequestLocation() Tool_Authentication_RequestLocation {
	if x != nil {
		return x.RequestLocation
	}
	return Tool_Authentication_REQUEST_LOCATION_UNSPECIFIED
}

// Config for authentication with OAuth.
type Tool_Authentication_OAuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. OAuth grant types.
	OauthGrantType Tool_Authentication_OAuthConfig_OauthGrantType `protobuf:"varint,1,opt,name=oauth_grant_type,json=oauthGrantType,proto3,enum=google.cloud.dialogflow.cx.v3.Tool_Authentication_OAuthConfig_OauthGrantType" json:"oauth_grant_type,omitempty"`
	// Required. The client ID from the OAuth provider.
	ClientId string `protobuf:"bytes,2,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Optional. The client secret from the OAuth provider. If the
	// `secret_version_for_client_secret` field is set, this field will be
	// ignored.
	ClientSecret string `protobuf:"bytes,3,opt,name=client_secret,json=clientSecret,proto3" json:"client_secret,omitempty"`
	// Optional. The name of the SecretManager secret version resource storing
	// the client secret. If this field is set, the `client_secret` field will
	// be ignored. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForClientSecret string `protobuf:"bytes,6,opt,name=secret_version_for_client_secret,json=secretVersionForClientSecret,proto3" json:"secret_version_for_client_secret,omitempty"`
	// Required. The token endpoint in the OAuth provider to exchange for an
	// access token.
	TokenEndpoint string `protobuf:"bytes,4,opt,name=token_endpoint,json=tokenEndpoint,proto3" json:"token_endpoint,omitempty"`
	// Optional. The OAuth scopes to grant.
	Scopes []string `protobuf:"bytes,5,rep,name=scopes,proto3" json:"scopes,omitempty"`
}

func (x *Tool_Authentication_OAuthConfig) Reset() {
	*x = Tool_Authentication_OAuthConfig{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_Authentication_OAuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication_OAuthConfig) ProtoMessage() {}

func (x *Tool_Authentication_OAuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication_OAuthConfig.ProtoReflect.Descriptor instead.
func (*Tool_Authentication_OAuthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 3, 1}
}

func (x *Tool_Authentication_OAuthConfig) GetOauthGrantType() Tool_Authentication_OAuthConfig_OauthGrantType {
	if x != nil {
		return x.OauthGrantType
	}
	return Tool_Authentication_OAuthConfig_OAUTH_GRANT_TYPE_UNSPECIFIED
}

func (x *Tool_Authentication_OAuthConfig) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *Tool_Authentication_OAuthConfig) GetClientSecret() string {
	if x != nil {
		return x.ClientSecret
	}
	return ""
}

func (x *Tool_Authentication_OAuthConfig) GetSecretVersionForClientSecret() string {
	if x != nil {
		return x.SecretVersionForClientSecret
	}
	return ""
}

func (x *Tool_Authentication_OAuthConfig) GetTokenEndpoint() string {
	if x != nil {
		return x.TokenEndpoint
	}
	return ""
}

func (x *Tool_Authentication_OAuthConfig) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

// Config for auth using [Diglogflow service
// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
type Tool_Authentication_ServiceAgentAuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Indicate the auth token type generated from the [Diglogflow
	// service
	// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
	// The generated token is sent in the Authorization header.
	ServiceAgentAuth Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth `protobuf:"varint,1,opt,name=service_agent_auth,json=serviceAgentAuth,proto3,enum=google.cloud.dialogflow.cx.v3.Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth" json:"service_agent_auth,omitempty"`
}

func (x *Tool_Authentication_ServiceAgentAuthConfig) Reset() {
	*x = Tool_Authentication_ServiceAgentAuthConfig{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_Authentication_ServiceAgentAuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication_ServiceAgentAuthConfig) ProtoMessage() {}

func (x *Tool_Authentication_ServiceAgentAuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication_ServiceAgentAuthConfig.ProtoReflect.Descriptor instead.
func (*Tool_Authentication_ServiceAgentAuthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 3, 2}
}

func (x *Tool_Authentication_ServiceAgentAuthConfig) GetServiceAgentAuth() Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth {
	if x != nil {
		return x.ServiceAgentAuth
	}
	return Tool_Authentication_ServiceAgentAuthConfig_SERVICE_AGENT_AUTH_UNSPECIFIED
}

// Config for authentication using bearer token.
type Tool_Authentication_BearerTokenConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The text token appended to the text `Bearer` to the request
	// Authorization header.
	// [Session parameters
	// reference](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
	// can be used to pass the token dynamically, e.g.
	// `$session.params.parameter-id`.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Optional. The name of the SecretManager secret version resource storing
	// the Bearer token. If this field is set, the `token` field will be
	// ignored. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForToken string `protobuf:"bytes,2,opt,name=secret_version_for_token,json=secretVersionForToken,proto3" json:"secret_version_for_token,omitempty"`
}

func (x *Tool_Authentication_BearerTokenConfig) Reset() {
	*x = Tool_Authentication_BearerTokenConfig{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_Authentication_BearerTokenConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication_BearerTokenConfig) ProtoMessage() {}

func (x *Tool_Authentication_BearerTokenConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication_BearerTokenConfig.ProtoReflect.Descriptor instead.
func (*Tool_Authentication_BearerTokenConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 3, 3}
}

func (x *Tool_Authentication_BearerTokenConfig) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *Tool_Authentication_BearerTokenConfig) GetSecretVersionForToken() string {
	if x != nil {
		return x.SecretVersionForToken
	}
	return ""
}

// Configuration for authentication using a service account.
type Tool_Authentication_ServiceAccountAuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The email address of the service account used to authenticate
	// the tool call. Dialogflow uses this service account to exchange an
	// access token and the access token is then sent in the `Authorization`
	// header of the tool request.
	//
	// The service account must have the
	// `roles/iam.serviceAccountTokenCreator` role granted to the
	// [Dialogflow service
	// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
	ServiceAccount string `protobuf:"bytes,1,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
}

func (x *Tool_Authentication_ServiceAccountAuthConfig) Reset() {
	*x = Tool_Authentication_ServiceAccountAuthConfig{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_Authentication_ServiceAccountAuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication_ServiceAccountAuthConfig) ProtoMessage() {}

func (x *Tool_Authentication_ServiceAccountAuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication_ServiceAccountAuthConfig.ProtoReflect.Descriptor instead.
func (*Tool_Authentication_ServiceAccountAuthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 3, 4}
}

func (x *Tool_Authentication_ServiceAccountAuthConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

// The CA certificate.
type Tool_TLSConfig_CACert struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the allowed custom CA certificates. This
	// can be used to disambiguate the custom CA certificates.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The allowed custom CA certificates (in DER format) for
	// HTTPS verification. This overrides the default SSL trust store. If this
	// is empty or unspecified, Dialogflow will use Google's default trust
	// store to verify certificates. N.B. Make sure the HTTPS server
	// certificates are signed with "subject alt name". For instance a
	// certificate can be self-signed using the following command:
	//
	// ```
	//
	//	openssl x509 -req -days 200 -in example.com.csr \
	//	  -signkey example.com.key \
	//	  -out example.com.crt \
	//	  -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
	//
	// ```
	Cert []byte `protobuf:"bytes,2,opt,name=cert,proto3" json:"cert,omitempty"`
}

func (x *Tool_TLSConfig_CACert) Reset() {
	*x = Tool_TLSConfig_CACert{}
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_TLSConfig_CACert) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_TLSConfig_CACert) ProtoMessage() {}

func (x *Tool_TLSConfig_CACert) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_TLSConfig_CACert.ProtoReflect.Descriptor instead.
func (*Tool_TLSConfig_CACert) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP(), []int{6, 4, 0}
}

func (x *Tool_TLSConfig_CACert) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Tool_TLSConfig_CACert) GetCert() []byte {
	if x != nil {
		return x.Cert
	}
	return nil
}

var File_google_cloud_dialogflow_cx_v3_tool_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3_tool_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x91, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54,
	0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x74,
	0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x22, 0x8e, 0x01, 0x0a, 0x10, 0x4c, 0x69,
	0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x76, 0x0a, 0x11, 0x4c, 0x69,
	0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x39, 0x0a, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54,
	0x6f, 0x6f, 0x6c, 0x52, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x4c, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x8e, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x74, 0x6f, 0x6f, 0x6c, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0x65, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x87, 0x1d, 0x0a, 0x04, 0x54, 0x6f, 0x6f,
	0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x61, 0x70, 0x69,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c,
	0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x41, 0x70, 0x69, 0x54, 0x6f, 0x6f, 0x6c, 0x48, 0x00, 0x52, 0x0b,
	0x6f, 0x70, 0x65, 0x6e, 0x41, 0x70, 0x69, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5b, 0x0a, 0x0f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x57, 0x0a, 0x0d, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6f,
	0x6c, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x4e, 0x0a, 0x09, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x74, 0x6f, 0x6f, 0x6c, 0x54, 0x79, 0x70,
	0x65, 0x1a, 0xee, 0x02, 0x0a, 0x0b, 0x4f, 0x70, 0x65, 0x6e, 0x41, 0x70, 0x69, 0x54, 0x6f, 0x6f,
	0x6c, 0x12, 0x26, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x74,
	0x65, 0x78, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x5f, 0x0a, 0x0e, 0x61, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0a, 0x74, 0x6c,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54,
	0x6f, 0x6f, 0x6c, 0x2e, 0x54, 0x4c, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x74, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x79, 0x0a,
	0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x1a, 0x80, 0x02, 0x0a, 0x0d, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x6d, 0x0a, 0x16, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x6e, 0x0a, 0x0f, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f,
	0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f,
	0x6c, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x2e,
	0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0e, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x50, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x1a, 0x10, 0x0a, 0x0e, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x50,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x1a, 0x92, 0x01, 0x0a, 0x0c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x3f, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x41, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x1a, 0xd8, 0x0f, 0x0a, 0x0e, 0x41,
	0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a,
	0x0e, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x70, 0x69, 0x4b, 0x65, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x70, 0x69, 0x4b, 0x65, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x63, 0x0a, 0x0c, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f,
	0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b,
	0x6f, 0x61, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x86, 0x01, 0x0a, 0x19,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x75,
	0x74, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x16, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x76, 0x0a, 0x13, 0x62, 0x65, 0x61, 0x72, 0x65, 0x72, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x65, 0x61, 0x72, 0x65, 0x72, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x11, 0x62, 0x65, 0x61, 0x72, 0x65,
	0x72, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8c, 0x01, 0x0a,
	0x1b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x00, 0x52, 0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xb0, 0x02, 0x0a, 0x0c,
	0x41, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1e, 0x0a, 0x08,
	0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x07,
	0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x61, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x12, 0x6e, 0x0a, 0x1a, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x6f, 0x72,
	0x5f, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x16, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x46, 0x6f, 0x72, 0x41, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x12, 0x72, 0x0a, 0x10, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e,
	0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xe7,
	0x03, 0x0a, 0x0b, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7c,
	0x0a, 0x10, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x41, 0x75,
	0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4f, 0x61, 0x75, 0x74, 0x68, 0x47, 0x72,
	0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6f, 0x61,
	0x75, 0x74, 0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x09,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x28,
	0x0a, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x7a, 0x0a, 0x20, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x1c, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0d, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x22, 0x49, 0x0a,
	0x0e, 0x4f, 0x61, 0x75, 0x74, 0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x20, 0x0a, 0x1c, 0x4f, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x44,
	0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x10, 0x01, 0x1a, 0x80, 0x02, 0x0a, 0x16, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x8d, 0x01, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41,
	0x75, 0x74, 0x68, 0x22, 0x56, 0x0a, 0x10, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x45, 0x52, 0x56, 0x49,
	0x43, 0x45, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x49,
	0x44, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x43, 0x43,
	0x45, 0x53, 0x53, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x02, 0x1a, 0x9b, 0x01, 0x0a, 0x11,
	0x42, 0x65, 0x61, 0x72, 0x65, 0x72, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x6b, 0x0a, 0x18,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66,
	0x6f, 0x72, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x15, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x46, 0x6f, 0x72, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0x48, 0x0a, 0x18, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0x51, 0x0a, 0x0f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53,
	0x54, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x45, 0x41, 0x44,
	0x45, 0x52, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x53, 0x54,
	0x52, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xac, 0x01, 0x0a, 0x09, 0x54, 0x4c, 0x53, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x08, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x54, 0x4c, 0x53, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x41, 0x43, 0x65, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x73, 0x1a, 0x49, 0x0a, 0x06, 0x43, 0x41, 0x43,
	0x65, 0x72, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x63,
	0x65, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x63, 0x65, 0x72, 0x74, 0x1a, 0x63, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x49,
	0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x22, 0x4c, 0x0a, 0x08, 0x54, 0x6f, 0x6f,
	0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x4f, 0x4f, 0x4c, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x13, 0x0a, 0x0f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x54,
	0x4f, 0x4f, 0x4c, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x42, 0x55, 0x49, 0x4c, 0x54, 0x49, 0x4e,
	0x5f, 0x54, 0x4f, 0x4f, 0x4c, 0x10, 0x02, 0x3a, 0x68, 0xea, 0x41, 0x65, 0x0a, 0x1e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x43, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x74, 0x6f, 0x6f, 0x6c,
	0x7d, 0x42, 0x0f, 0x0a, 0x0d, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xa6, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x93, 0x01, 0x0a, 0x18,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0d, 0x74, 0x6f, 0x6f, 0x6c,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x74, 0x6f, 0x6f,
	0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xb5, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x52, 0x0a, 0x0c, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x6f,
	0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5a, 0x0a, 0x15, 0x47, 0x65, 0x74,
	0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x78, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22,
	0x5e, 0x0a, 0x19, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f,
	0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x55, 0x0a, 0x1a, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a,
	0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c,
	0x52, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x22, 0xb1, 0x03, 0x0a, 0x0b, 0x54, 0x6f, 0x6f, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x9e, 0x01, 0xea, 0x41, 0x9a, 0x01,
	0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x74, 0x6f, 0x6f, 0x6c, 0x7d, 0x2f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2a,
	0x0c, 0x74, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x0b, 0x74,
	0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0x85, 0x10, 0x0a, 0x05, 0x54,
	0x6f, 0x6f, 0x6c, 0x73, 0x12, 0xb3, 0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x6f, 0x6f, 0x6c, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x22, 0x4e, 0xda, 0x41, 0x0b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x6f, 0x6f, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a,
	0x3a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x22, 0x32, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0xb3, 0x01, 0x0a, 0x09, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f,
	0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f,
	0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76,
	0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x12, 0xa0, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74,
	0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c,
	0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12,
	0x32, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xbd, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x6f,
	0x6f, 0x6c, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x22, 0x58, 0xda, 0x41, 0x10, 0x74, 0x6f,
	0x6f, 0x6c, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x32, 0x37, 0x2f, 0x76, 0x33, 0x2f,
	0x7b, 0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x99, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x6f,
	0x6f, 0x6c, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x41, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f, 0x76, 0x33,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xd3, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe3, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x69, 0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x6f, 0x6f, 0x6c,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x0c,
	0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x3d, 0x2f, 0x76,
	0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xc0, 0x01, 0x0a, 0x0e,
	0x47, 0x65, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47,
	0x65, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x4c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12,
	0x3d, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb2,
	0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3f, 0x2a, 0x3d, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xe2, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x54,
	0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x6f, 0x6f, 0x6c,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x57, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x01,
	0x2a, 0x22, 0x45, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x42, 0x88, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x42, 0x09, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x31, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x63,
	0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1d,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescData = file_google_cloud_dialogflow_cx_v3_tool_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3_tool_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3_tool_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes = make([]protoimpl.MessageInfo, 28)
var file_google_cloud_dialogflow_cx_v3_tool_proto_goTypes = []any{
	(Tool_ToolType)(0),                                               // 0: google.cloud.dialogflow.cx.v3.Tool.ToolType
	(Tool_Authentication_RequestLocation)(0),                         // 1: google.cloud.dialogflow.cx.v3.Tool.Authentication.RequestLocation
	(Tool_Authentication_OAuthConfig_OauthGrantType)(0),              // 2: google.cloud.dialogflow.cx.v3.Tool.Authentication.OAuthConfig.OauthGrantType
	(Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth)(0), // 3: google.cloud.dialogflow.cx.v3.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth
	(*CreateToolRequest)(nil),                                        // 4: google.cloud.dialogflow.cx.v3.CreateToolRequest
	(*ListToolsRequest)(nil),                                         // 5: google.cloud.dialogflow.cx.v3.ListToolsRequest
	(*ListToolsResponse)(nil),                                        // 6: google.cloud.dialogflow.cx.v3.ListToolsResponse
	(*GetToolRequest)(nil),                                           // 7: google.cloud.dialogflow.cx.v3.GetToolRequest
	(*UpdateToolRequest)(nil),                                        // 8: google.cloud.dialogflow.cx.v3.UpdateToolRequest
	(*DeleteToolRequest)(nil),                                        // 9: google.cloud.dialogflow.cx.v3.DeleteToolRequest
	(*Tool)(nil),                                                     // 10: google.cloud.dialogflow.cx.v3.Tool
	(*ListToolVersionsRequest)(nil),                                  // 11: google.cloud.dialogflow.cx.v3.ListToolVersionsRequest
	(*ListToolVersionsResponse)(nil),                                 // 12: google.cloud.dialogflow.cx.v3.ListToolVersionsResponse
	(*CreateToolVersionRequest)(nil),                                 // 13: google.cloud.dialogflow.cx.v3.CreateToolVersionRequest
	(*GetToolVersionRequest)(nil),                                    // 14: google.cloud.dialogflow.cx.v3.GetToolVersionRequest
	(*DeleteToolVersionRequest)(nil),                                 // 15: google.cloud.dialogflow.cx.v3.DeleteToolVersionRequest
	(*RestoreToolVersionRequest)(nil),                                // 16: google.cloud.dialogflow.cx.v3.RestoreToolVersionRequest
	(*RestoreToolVersionResponse)(nil),                               // 17: google.cloud.dialogflow.cx.v3.RestoreToolVersionResponse
	(*ToolVersion)(nil),                                              // 18: google.cloud.dialogflow.cx.v3.ToolVersion
	(*Tool_OpenApiTool)(nil),                                         // 19: google.cloud.dialogflow.cx.v3.Tool.OpenApiTool
	(*Tool_DataStoreTool)(nil),                                       // 20: google.cloud.dialogflow.cx.v3.Tool.DataStoreTool
	(*Tool_FunctionTool)(nil),                                        // 21: google.cloud.dialogflow.cx.v3.Tool.FunctionTool
	(*Tool_Authentication)(nil),                                      // 22: google.cloud.dialogflow.cx.v3.Tool.Authentication
	(*Tool_TLSConfig)(nil),                                           // 23: google.cloud.dialogflow.cx.v3.Tool.TLSConfig
	(*Tool_ServiceDirectoryConfig)(nil),                              // 24: google.cloud.dialogflow.cx.v3.Tool.ServiceDirectoryConfig
	(*Tool_DataStoreTool_FallbackPrompt)(nil),                        // 25: google.cloud.dialogflow.cx.v3.Tool.DataStoreTool.FallbackPrompt
	(*Tool_Authentication_ApiKeyConfig)(nil),                         // 26: google.cloud.dialogflow.cx.v3.Tool.Authentication.ApiKeyConfig
	(*Tool_Authentication_OAuthConfig)(nil),                          // 27: google.cloud.dialogflow.cx.v3.Tool.Authentication.OAuthConfig
	(*Tool_Authentication_ServiceAgentAuthConfig)(nil),               // 28: google.cloud.dialogflow.cx.v3.Tool.Authentication.ServiceAgentAuthConfig
	(*Tool_Authentication_BearerTokenConfig)(nil),                    // 29: google.cloud.dialogflow.cx.v3.Tool.Authentication.BearerTokenConfig
	(*Tool_Authentication_ServiceAccountAuthConfig)(nil),             // 30: google.cloud.dialogflow.cx.v3.Tool.Authentication.ServiceAccountAuthConfig
	(*Tool_TLSConfig_CACert)(nil),                                    // 31: google.cloud.dialogflow.cx.v3.Tool.TLSConfig.CACert
	(*fieldmaskpb.FieldMask)(nil),                                    // 32: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                                    // 33: google.protobuf.Timestamp
	(*DataStoreConnection)(nil),                                      // 34: google.cloud.dialogflow.cx.v3.DataStoreConnection
	(*structpb.Struct)(nil),                                          // 35: google.protobuf.Struct
	(*emptypb.Empty)(nil),                                            // 36: google.protobuf.Empty
}
var file_google_cloud_dialogflow_cx_v3_tool_proto_depIdxs = []int32{
	10, // 0: google.cloud.dialogflow.cx.v3.CreateToolRequest.tool:type_name -> google.cloud.dialogflow.cx.v3.Tool
	10, // 1: google.cloud.dialogflow.cx.v3.ListToolsResponse.tools:type_name -> google.cloud.dialogflow.cx.v3.Tool
	10, // 2: google.cloud.dialogflow.cx.v3.UpdateToolRequest.tool:type_name -> google.cloud.dialogflow.cx.v3.Tool
	32, // 3: google.cloud.dialogflow.cx.v3.UpdateToolRequest.update_mask:type_name -> google.protobuf.FieldMask
	19, // 4: google.cloud.dialogflow.cx.v3.Tool.open_api_spec:type_name -> google.cloud.dialogflow.cx.v3.Tool.OpenApiTool
	20, // 5: google.cloud.dialogflow.cx.v3.Tool.data_store_spec:type_name -> google.cloud.dialogflow.cx.v3.Tool.DataStoreTool
	21, // 6: google.cloud.dialogflow.cx.v3.Tool.function_spec:type_name -> google.cloud.dialogflow.cx.v3.Tool.FunctionTool
	0,  // 7: google.cloud.dialogflow.cx.v3.Tool.tool_type:type_name -> google.cloud.dialogflow.cx.v3.Tool.ToolType
	18, // 8: google.cloud.dialogflow.cx.v3.ListToolVersionsResponse.tool_versions:type_name -> google.cloud.dialogflow.cx.v3.ToolVersion
	18, // 9: google.cloud.dialogflow.cx.v3.CreateToolVersionRequest.tool_version:type_name -> google.cloud.dialogflow.cx.v3.ToolVersion
	10, // 10: google.cloud.dialogflow.cx.v3.RestoreToolVersionResponse.tool:type_name -> google.cloud.dialogflow.cx.v3.Tool
	10, // 11: google.cloud.dialogflow.cx.v3.ToolVersion.tool:type_name -> google.cloud.dialogflow.cx.v3.Tool
	33, // 12: google.cloud.dialogflow.cx.v3.ToolVersion.create_time:type_name -> google.protobuf.Timestamp
	33, // 13: google.cloud.dialogflow.cx.v3.ToolVersion.update_time:type_name -> google.protobuf.Timestamp
	22, // 14: google.cloud.dialogflow.cx.v3.Tool.OpenApiTool.authentication:type_name -> google.cloud.dialogflow.cx.v3.Tool.Authentication
	23, // 15: google.cloud.dialogflow.cx.v3.Tool.OpenApiTool.tls_config:type_name -> google.cloud.dialogflow.cx.v3.Tool.TLSConfig
	24, // 16: google.cloud.dialogflow.cx.v3.Tool.OpenApiTool.service_directory_config:type_name -> google.cloud.dialogflow.cx.v3.Tool.ServiceDirectoryConfig
	34, // 17: google.cloud.dialogflow.cx.v3.Tool.DataStoreTool.data_store_connections:type_name -> google.cloud.dialogflow.cx.v3.DataStoreConnection
	25, // 18: google.cloud.dialogflow.cx.v3.Tool.DataStoreTool.fallback_prompt:type_name -> google.cloud.dialogflow.cx.v3.Tool.DataStoreTool.FallbackPrompt
	35, // 19: google.cloud.dialogflow.cx.v3.Tool.FunctionTool.input_schema:type_name -> google.protobuf.Struct
	35, // 20: google.cloud.dialogflow.cx.v3.Tool.FunctionTool.output_schema:type_name -> google.protobuf.Struct
	26, // 21: google.cloud.dialogflow.cx.v3.Tool.Authentication.api_key_config:type_name -> google.cloud.dialogflow.cx.v3.Tool.Authentication.ApiKeyConfig
	27, // 22: google.cloud.dialogflow.cx.v3.Tool.Authentication.oauth_config:type_name -> google.cloud.dialogflow.cx.v3.Tool.Authentication.OAuthConfig
	28, // 23: google.cloud.dialogflow.cx.v3.Tool.Authentication.service_agent_auth_config:type_name -> google.cloud.dialogflow.cx.v3.Tool.Authentication.ServiceAgentAuthConfig
	29, // 24: google.cloud.dialogflow.cx.v3.Tool.Authentication.bearer_token_config:type_name -> google.cloud.dialogflow.cx.v3.Tool.Authentication.BearerTokenConfig
	30, // 25: google.cloud.dialogflow.cx.v3.Tool.Authentication.service_account_auth_config:type_name -> google.cloud.dialogflow.cx.v3.Tool.Authentication.ServiceAccountAuthConfig
	31, // 26: google.cloud.dialogflow.cx.v3.Tool.TLSConfig.ca_certs:type_name -> google.cloud.dialogflow.cx.v3.Tool.TLSConfig.CACert
	1,  // 27: google.cloud.dialogflow.cx.v3.Tool.Authentication.ApiKeyConfig.request_location:type_name -> google.cloud.dialogflow.cx.v3.Tool.Authentication.RequestLocation
	2,  // 28: google.cloud.dialogflow.cx.v3.Tool.Authentication.OAuthConfig.oauth_grant_type:type_name -> google.cloud.dialogflow.cx.v3.Tool.Authentication.OAuthConfig.OauthGrantType
	3,  // 29: google.cloud.dialogflow.cx.v3.Tool.Authentication.ServiceAgentAuthConfig.service_agent_auth:type_name -> google.cloud.dialogflow.cx.v3.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth
	4,  // 30: google.cloud.dialogflow.cx.v3.Tools.CreateTool:input_type -> google.cloud.dialogflow.cx.v3.CreateToolRequest
	5,  // 31: google.cloud.dialogflow.cx.v3.Tools.ListTools:input_type -> google.cloud.dialogflow.cx.v3.ListToolsRequest
	7,  // 32: google.cloud.dialogflow.cx.v3.Tools.GetTool:input_type -> google.cloud.dialogflow.cx.v3.GetToolRequest
	8,  // 33: google.cloud.dialogflow.cx.v3.Tools.UpdateTool:input_type -> google.cloud.dialogflow.cx.v3.UpdateToolRequest
	9,  // 34: google.cloud.dialogflow.cx.v3.Tools.DeleteTool:input_type -> google.cloud.dialogflow.cx.v3.DeleteToolRequest
	11, // 35: google.cloud.dialogflow.cx.v3.Tools.ListToolVersions:input_type -> google.cloud.dialogflow.cx.v3.ListToolVersionsRequest
	13, // 36: google.cloud.dialogflow.cx.v3.Tools.CreateToolVersion:input_type -> google.cloud.dialogflow.cx.v3.CreateToolVersionRequest
	14, // 37: google.cloud.dialogflow.cx.v3.Tools.GetToolVersion:input_type -> google.cloud.dialogflow.cx.v3.GetToolVersionRequest
	15, // 38: google.cloud.dialogflow.cx.v3.Tools.DeleteToolVersion:input_type -> google.cloud.dialogflow.cx.v3.DeleteToolVersionRequest
	16, // 39: google.cloud.dialogflow.cx.v3.Tools.RestoreToolVersion:input_type -> google.cloud.dialogflow.cx.v3.RestoreToolVersionRequest
	10, // 40: google.cloud.dialogflow.cx.v3.Tools.CreateTool:output_type -> google.cloud.dialogflow.cx.v3.Tool
	6,  // 41: google.cloud.dialogflow.cx.v3.Tools.ListTools:output_type -> google.cloud.dialogflow.cx.v3.ListToolsResponse
	10, // 42: google.cloud.dialogflow.cx.v3.Tools.GetTool:output_type -> google.cloud.dialogflow.cx.v3.Tool
	10, // 43: google.cloud.dialogflow.cx.v3.Tools.UpdateTool:output_type -> google.cloud.dialogflow.cx.v3.Tool
	36, // 44: google.cloud.dialogflow.cx.v3.Tools.DeleteTool:output_type -> google.protobuf.Empty
	12, // 45: google.cloud.dialogflow.cx.v3.Tools.ListToolVersions:output_type -> google.cloud.dialogflow.cx.v3.ListToolVersionsResponse
	18, // 46: google.cloud.dialogflow.cx.v3.Tools.CreateToolVersion:output_type -> google.cloud.dialogflow.cx.v3.ToolVersion
	18, // 47: google.cloud.dialogflow.cx.v3.Tools.GetToolVersion:output_type -> google.cloud.dialogflow.cx.v3.ToolVersion
	36, // 48: google.cloud.dialogflow.cx.v3.Tools.DeleteToolVersion:output_type -> google.protobuf.Empty
	17, // 49: google.cloud.dialogflow.cx.v3.Tools.RestoreToolVersion:output_type -> google.cloud.dialogflow.cx.v3.RestoreToolVersionResponse
	40, // [40:50] is the sub-list for method output_type
	30, // [30:40] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3_tool_proto_init() }
func file_google_cloud_dialogflow_cx_v3_tool_proto_init() {
	if File_google_cloud_dialogflow_cx_v3_tool_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3_data_store_connection_proto_init()
	file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[6].OneofWrappers = []any{
		(*Tool_OpenApiSpec)(nil),
		(*Tool_DataStoreSpec)(nil),
		(*Tool_FunctionSpec)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[15].OneofWrappers = []any{
		(*Tool_OpenApiTool_TextSchema)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes[18].OneofWrappers = []any{
		(*Tool_Authentication_ApiKeyConfig_)(nil),
		(*Tool_Authentication_OauthConfig)(nil),
		(*Tool_Authentication_ServiceAgentAuthConfig_)(nil),
		(*Tool_Authentication_BearerTokenConfig_)(nil),
		(*Tool_Authentication_ServiceAccountAuthConfig_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3_tool_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   28,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3_tool_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3_tool_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3_tool_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3_tool_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3_tool_proto = out.File
	file_google_cloud_dialogflow_cx_v3_tool_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3_tool_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3_tool_proto_depIdxs = nil
}
