// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/securityhub"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To accept an invitation be a member account
// The following example demonstrates how an account can accept an invitation from the
// Security Hub administrator account to be a member account. This operation is applicable
// only to member accounts that are not added through AWS Organizations.
func ExampleSecurityHub_AcceptAdministratorInvitation_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.AcceptAdministratorInvitationInput{
		AdministratorId: aws.String("123456789012"),
		InvitationId:    aws.String("7ab938c5d52d7904ad09f9e7c20cc4eb"),
	}

	result, err := svc.AcceptAdministratorInvitation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable one or more security standards
// The following example disables a security standard in Security Hub.
func ExampleSecurityHub_BatchDisableStandards_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.BatchDisableStandardsInput{
		StandardsSubscriptionArns: []*string{
			aws.String("arn:aws:securityhub:us-west-1:123456789012:subscription/pci-dss/v/3.2.1"),
		},
	}

	result, err := svc.BatchDisableStandards(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To import security findings from a third party provider to Security Hub
// The following example imports findings from a third party provider to Security Hub.
func ExampleSecurityHub_BatchEnableStandards_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.BatchEnableStandardsInput{
		StandardsSubscriptionRequests: []*securityhub.StandardsSubscriptionRequest{
			{
				StandardsArn: aws.String("arn:aws:securityhub:us-west-1::standards/pci-dss/v/3.2.1"),
			},
		},
	}

	result, err := svc.BatchEnableStandards(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To import security findings from a third party provider to Security Hub
// The following example imports findings from a third party provider to Security Hub.
func ExampleSecurityHub_BatchImportFindings_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.BatchImportFindingsInput{
		Findings: []*securityhub.AwsSecurityFinding{
			{
				AwsAccountId: aws.String("123456789012"),
				CreatedAt:    aws.String("2020-05-27T17:05:54.832Z"),
				Description:  aws.String("Vulnerability in a CloudTrail trail"),
				FindingProviderFields: &securityhub.FindingProviderFields{
					Severity: &securityhub.FindingProviderSeverity{
						Label:    aws.String("LOW"),
						Original: aws.String("10"),
					},
					Types: []*string{
						aws.String("Software and Configuration Checks/Vulnerabilities/CVE"),
					},
				},
				GeneratorId: aws.String("TestGeneratorId"),
				Id:          aws.String("Id1"),
				ProductArn:  aws.String("arn:aws:securityhub:us-west-1:123456789012:product/123456789012/default"),
				Resources: []*securityhub.Resource{
					{
						Id:        aws.String("arn:aws:cloudtrail:us-west-1:123456789012:trail/TrailName"),
						Partition: aws.String("aws"),
						Region:    aws.String("us-west-1"),
						Type:      aws.String("AwsCloudTrailTrail"),
					},
				},
				SchemaVersion: aws.String("2018-10-08"),
				Title:         aws.String("CloudTrail trail vulnerability"),
				UpdatedAt:     aws.String("2020-06-02T16:05:54.832Z"),
			},
		},
	}

	result, err := svc.BatchImportFindings(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update Security Hub findings
// The following example updates Security Hub findings. The finding identifier parameter
// specifies which findings to update. Only specific finding fields can be updated with
// this operation.
func ExampleSecurityHub_BatchUpdateFindings_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.BatchUpdateFindingsInput{
		Confidence:  aws.Int64(80),
		Criticality: aws.Int64(80),
		FindingIdentifiers: []*securityhub.AwsSecurityFindingIdentifier{
			{
				Id:         aws.String("arn:aws:securityhub:us-west-1:123456789012:subscription/pci-dss/v/3.2.1/PCI.Lambda.2/finding/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111"),
				ProductArn: aws.String("arn:aws:securityhub:us-west-1::product/aws/securityhub"),
			},
			{
				Id:         aws.String("arn:aws:securityhub:us-west-1:123456789012:subscription/pci-dss/v/3.2.1/PCI.Lambda.2/finding/a1b2c3d4-5678-90ab-cdef-EXAMPLE22222"),
				ProductArn: aws.String("arn:aws:securityhub:us-west-1::product/aws/securityhub"),
			},
		},
		Note: &securityhub.NoteUpdate{
			Text:      aws.String("Known issue that is not a risk."),
			UpdatedBy: aws.String("user1"),
		},
		RelatedFindings: []*securityhub.RelatedFinding{
			{
				Id:         aws.String("arn:aws:securityhub:us-west-1:123456789012:subscription/pci-dss/v/3.2.1/PCI.Lambda.2/finding/a1b2c3d4-5678-90ab-cdef-EXAMPLE33333"),
				ProductArn: aws.String("arn:aws:securityhub:us-west-1::product/aws/securityhub"),
			},
		},
		Severity: &securityhub.SeverityUpdate{
			Label: aws.String("LOW"),
		},
		Types: []*string{
			aws.String("Software and Configuration Checks/Vulnerabilities/CVE"),
		},
		UserDefinedFields: map[string]*string{
			"reviewedByCio": aws.String("true"),
		},
		VerificationState: aws.String("TRUE_POSITIVE"),
		Workflow: &securityhub.WorkflowUpdate{
			Status: aws.String("RESOLVED"),
		},
	}

	result, err := svc.BatchUpdateFindings(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a custom action target
// The following example creates a custom action target in Security Hub. Custom actions
// on findings and insights automatically trigger actions in Amazon CloudWatch Events.
func ExampleSecurityHub_CreateActionTarget_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.CreateActionTargetInput{
		Description: aws.String("Action to send the finding for remediation tracking"),
		Id:          aws.String("Remediation"),
		Name:        aws.String("Send to remediation"),
	}

	result, err := svc.CreateActionTarget(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceConflictException:
				fmt.Println(securityhub.ErrCodeResourceConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable cross-Region aggregation
// The following example creates a finding aggregator. This is required to enable cross-Region
// aggregation.
func ExampleSecurityHub_CreateFindingAggregator_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.CreateFindingAggregatorInput{
		RegionLinkingMode: aws.String("SPECIFIED_REGIONS"),
		Regions: []*string{
			aws.String("us-west-1"),
			aws.String("us-west-2"),
		},
	}

	result, err := svc.CreateFindingAggregator(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeAccessDeniedException:
				fmt.Println(securityhub.ErrCodeAccessDeniedException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a custom insight
// The following example creates a custom insight in Security Hub. An insight is a collection
// of findings that relate to a security issue.
func ExampleSecurityHub_CreateInsight_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.CreateInsightInput{
		Filters: &securityhub.AwsSecurityFindingFilters{
			ResourceType: []*securityhub.StringFilter{
				{
					Comparison: aws.String("EQUALS"),
					Value:      aws.String("AwsIamRole"),
				},
			},
			SeverityLabel: []*securityhub.StringFilter{
				{
					Comparison: aws.String("EQUALS"),
					Value:      aws.String("CRITICAL"),
				},
			},
		},
		GroupByAttribute: aws.String("ResourceId"),
		Name:             aws.String("Critical role findings"),
	}

	result, err := svc.CreateInsight(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeResourceConflictException:
				fmt.Println(securityhub.ErrCodeResourceConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a member account
// The following example creates a member association between the specified accounts
// and the administrator account (the account that makes the request). This operation
// is used to add accounts that aren't part of an organization.
func ExampleSecurityHub_CreateMembers_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.CreateMembersInput{
		AccountDetails: []*securityhub.AccountDetails{
			{
				AccountId: aws.String("123456789012"),
			},
			{
				AccountId: aws.String("111122223333"),
			},
		},
	}

	result, err := svc.CreateMembers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeResourceConflictException:
				fmt.Println(securityhub.ErrCodeResourceConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To decline invitation to become a member account
// The following example declines an invitation from the Security Hub administrator
// account to become a member account. The invited account makes the request.
func ExampleSecurityHub_DeclineInvitations_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DeclineInvitationsInput{
		AccountIds: []*string{
			aws.String("123456789012"),
			aws.String("111122223333"),
		},
	}

	result, err := svc.DeclineInvitations(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a custom action target
// The following example deletes a custom action target that triggers target actions
// in Amazon CloudWatch Events. Deleting a custom action target doesn't affect findings
// or insights that were already sent to CloudWatch Events based on the custom action.
func ExampleSecurityHub_DeleteActionTarget_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DeleteActionTargetInput{
		ActionTargetArn: aws.String("arn:aws:securityhub:us-west-1:123456789012:action/custom/Remediation"),
	}

	result, err := svc.DeleteActionTarget(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a finding aggregator
// The following example deletes a finding aggregator in Security Hub. Deleting the
// finding aggregator stops cross-Region aggregation. This operation produces no output.
func ExampleSecurityHub_DeleteFindingAggregator_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DeleteFindingAggregatorInput{
		FindingAggregatorArn: aws.String("arn:aws:securityhub:us-east-1:123456789012:finding-aggregator/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111"),
	}

	result, err := svc.DeleteFindingAggregator(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeAccessDeniedException:
				fmt.Println(securityhub.ErrCodeAccessDeniedException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a custom insight
// The following example deletes a custom insight in Security Hub.
func ExampleSecurityHub_DeleteInsight_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DeleteInsightInput{
		InsightArn: aws.String("arn:aws:securityhub:us-west-1:123456789012:insight/123456789012/custom/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111"),
	}

	result, err := svc.DeleteInsight(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a custom insight
// The following example deletes an invitation sent by the Security Hub administrator
// account to a prospective member account. This operation is used only for invitations
// sent to accounts that aren't part of an organization. Organization accounts don't
// receive invitations.
func ExampleSecurityHub_DeleteInvitations_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DeleteInvitationsInput{
		AccountIds: []*string{
			aws.String("123456789012"),
		},
	}

	result, err := svc.DeleteInvitations(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a member account
// The following example deletes the specified member account from Security Hub. This
// operation can be used to delete member accounts that are part of an organization
// or that were invited manually.
func ExampleSecurityHub_DeleteMembers_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DeleteMembersInput{
		AccountIds: []*string{
			aws.String("123456789111"),
			aws.String("123456789222"),
		},
	}

	result, err := svc.DeleteMembers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To return custom action targets
// The following example returns a list of custom action targets. You use custom actions
// on findings and insights in Security Hub to trigger target actions in Amazon CloudWatch
// Events.
func ExampleSecurityHub_DescribeActionTargets_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DescribeActionTargetsInput{
		ActionTargetArns: []*string{
			aws.String("arn:aws:securityhub:us-west-1:123456789012:action/custom/Remediation"),
		},
	}

	result, err := svc.DescribeActionTargets(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To return details about Hub resource
// The following example returns details about the Hub resource in the calling account.
// The Hub resource represents the implementation of the AWS Security Hub service in
// the calling account.
func ExampleSecurityHub_DescribeHub_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DescribeHubInput{
		HubArn: aws.String("arn:aws:securityhub:us-west-1:123456789012:hub/default"),
	}

	result, err := svc.DescribeHub(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about Organizations configuration
// The following example returns details about the way in which AWS Organizations is
// configured for a Security Hub account that belongs to an organization. Only a Security
// Hub administrator account can call this operation.
func ExampleSecurityHub_DescribeOrganizationConfiguration_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DescribeOrganizationConfigurationInput{}

	result, err := svc.DescribeOrganizationConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about Security Hub integrations
// The following example returns details about AWS services and third-party products
// that Security Hub integrates with.
func ExampleSecurityHub_DescribeProducts_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DescribeProductsInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NULL"),
		ProductArn: aws.String("arn:aws:securityhub:us-east-1:517716713836:product/crowdstrike/crowdstrike-falcon"),
	}

	result, err := svc.DescribeProducts(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get available Security Hub standards
// The following example returns a list of available security standards in Security
// Hub.
func ExampleSecurityHub_DescribeStandards_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DescribeStandardsInput{}

	result, err := svc.DescribeStandards(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a list of controls for a security standard
// The following example returns a list of security controls and control details that
// apply to a specified security standard. The list includes controls that are enabled
// and disabled in the standard.
func ExampleSecurityHub_DescribeStandardsControls_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DescribeStandardsControlsInput{
		MaxResults:               aws.Int64(2),
		NextToken:                aws.String("NULL"),
		StandardsSubscriptionArn: aws.String("arn:aws:securityhub:us-west-1:123456789012:subscription/pci-dss/v/3.2.1"),
	}

	result, err := svc.DescribeStandardsControls(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To end a Security Hub integration
// The following example ends an integration between Security Hub and the specified
// product that sends findings to Security Hub. After the integration ends, the product
// no longer sends findings to Security Hub.
func ExampleSecurityHub_DisableImportFindingsForProduct_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DisableImportFindingsForProductInput{
		ProductSubscriptionArn: aws.String("arn:aws:securityhub:us-east-1:517716713836:product/crowdstrike/crowdstrike-falcon"),
	}

	result, err := svc.DisableImportFindingsForProduct(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove a Security Hub administrator account
// The following example removes the Security Hub administrator account in the Region
// from which the operation was executed. This operation doesn't remove the delegated
// administrator account in AWS Organizations.
func ExampleSecurityHub_DisableOrganizationAdminAccount_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DisableOrganizationAdminAccountInput{
		AdminAccountId: aws.String("123456789012"),
	}

	result, err := svc.DisableOrganizationAdminAccount(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To deactivate Security Hub
// The following example deactivates Security Hub for the current account and Region.
func ExampleSecurityHub_DisableSecurityHub_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DisableSecurityHubInput{}

	result, err := svc.DisableSecurityHub(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate requesting account from administrator account
// The following example dissociates the requesting account from its associated administrator
// account.
func ExampleSecurityHub_DisassociateFromAdministratorAccount_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DisassociateFromAdministratorAccountInput{}

	result, err := svc.DisassociateFromAdministratorAccount(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate member accounts from administrator account
// The following example dissociates the specified member accounts from the associated
// administrator account.
func ExampleSecurityHub_DisassociateMembers_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.DisassociateMembersInput{
		AccountIds: []*string{
			aws.String("123456789012"),
			aws.String("111122223333"),
		},
	}

	result, err := svc.DisassociateMembers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To activate an integration
// The following example activates an integration between Security Hub and a third party
// partner product that sends findings to Security Hub.
func ExampleSecurityHub_EnableImportFindingsForProduct_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.EnableImportFindingsForProductInput{
		ProductArn: aws.String("arn:aws:securityhub:us-east-1:517716713836:product/crowdstrike/crowdstrike-falcon"),
	}

	result, err := svc.EnableImportFindingsForProduct(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeResourceConflictException:
				fmt.Println(securityhub.ErrCodeResourceConflictException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To designate a Security Hub administrator
// The following example designates the specified account as the Security Hub administrator
// account. The requesting account must be the organization management account.
func ExampleSecurityHub_EnableOrganizationAdminAccount_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.EnableOrganizationAdminAccountInput{
		AdminAccountId: aws.String("123456789012"),
	}

	result, err := svc.EnableOrganizationAdminAccount(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To activate Security Hub
// The following example activates the Security Hub service in the requesting AWS account.
// The service is activated in the current AWS Region or the Region that you specify
// in the request. Some standards are automatically turned on in your account unless
// you opt out. To determine which standards are automatically turned on, see the Security
// Hub documentation.
func ExampleSecurityHub_EnableSecurityHub_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.EnableSecurityHubInput{
		EnableDefaultStandards: aws.Bool(true),
		Tags: map[string]*string{
			"Department": aws.String("Security"),
		},
	}

	result, err := svc.EnableSecurityHub(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeResourceConflictException:
				fmt.Println(securityhub.ErrCodeResourceConflictException, aerr.Error())
			case securityhub.ErrCodeAccessDeniedException:
				fmt.Println(securityhub.ErrCodeAccessDeniedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get details about the Security Hub administrator account
// The following example provides details about the Security Hub administrator account
// for the requesting member account.
func ExampleSecurityHub_GetAdministratorAccount_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.GetAdministratorAccountInput{}

	result, err := svc.GetAdministratorAccount(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To return a list of enabled standards
// The following example returns a list of Security Hub standards that are currently
// enabled in your account.
func ExampleSecurityHub_GetEnabledStandards_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.GetEnabledStandardsInput{
		StandardsSubscriptionArns: []*string{
			aws.String("arn:aws:securityhub:us-west-1:123456789012:subscription/pci-dss/v/3.2.1"),
		},
	}

	result, err := svc.GetEnabledStandards(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get cross-Region aggregation details
// The following example returns cross-Region aggregation details for the requesting
// account.
func ExampleSecurityHub_GetFindingAggregator_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.GetFindingAggregatorInput{
		FindingAggregatorArn: aws.String("arn:aws:securityhub:us-east-1:123456789012:finding-aggregator/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111"),
	}

	result, err := svc.GetFindingAggregator(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeAccessDeniedException:
				fmt.Println(securityhub.ErrCodeAccessDeniedException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a list of findings
// The following example returns a filtered and sorted list of Security Hub findings.
func ExampleSecurityHub_GetFindings_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.GetFindingsInput{
		Filters: &securityhub.AwsSecurityFindingFilters{
			AwsAccountId: []*securityhub.StringFilter{
				{
					Comparison: aws.String("PREFIX"),
					Value:      aws.String("123456789012"),
				},
			},
		},
		MaxResults: aws.Int64(1),
	}

	result, err := svc.GetFindings(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get the results of a Security Hub insight
// The following example returns the results of the Security Hub insight specified by
// the insight ARN.
func ExampleSecurityHub_GetInsightResults_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.GetInsightResultsInput{
		InsightArn: aws.String("arn:aws:securityhub:us-west-1:123456789012:insight/123456789012/custom/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111"),
	}

	result, err := svc.GetInsightResults(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get details of a Security Hub insight
// The following example returns details of the Security Hub insight with the specified
// ARN.
func ExampleSecurityHub_GetInsights_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.GetInsightsInput{
		InsightArns: []*string{
			aws.String("arn:aws:securityhub:us-west-1:123456789012:insight/123456789012/custom/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111"),
		},
	}

	result, err := svc.GetInsights(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a count of membership invitations
// The following example returns a count of invitations that the Security Hub administrator
// sent to the current member account, not including the currently accepted invitation.
func ExampleSecurityHub_GetInvitationsCount_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.GetInvitationsCountInput{}

	result, err := svc.GetInvitationsCount(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get member account details
// The following example returns details for the Security Hub member accounts with the
// specified AWS account IDs. An administrator account may be the delegated Security
// Hub administrator account for an organization or an administrator account that enabled
// Security Hub manually. The Security Hub administrator must call this operation.
func ExampleSecurityHub_GetMembers_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.GetMembersInput{
		AccountIds: []*string{
			aws.String("444455556666"),
			aws.String("777788889999"),
		},
	}

	result, err := svc.GetMembers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To invite accounts to become members
// The following example invites the specified AWS accounts to become member accounts
// associated with the calling Security Hub administrator account. You only use this
// operation to invite accounts that don't belong to an AWS Organizations organization.
func ExampleSecurityHub_InviteMembers_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.InviteMembersInput{
		AccountIds: []*string{
			aws.String("111122223333"),
			aws.String("444455556666"),
		},
	}

	result, err := svc.InviteMembers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list ARNs for enabled integrations
// The following example returns a list of subscription Amazon Resource Names (ARNs)
// for the product integrations that you have currently enabled in Security Hub.
func ExampleSecurityHub_ListEnabledProductsForImport_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.ListEnabledProductsForImportInput{}

	result, err := svc.ListEnabledProductsForImport(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the enablement status of a standard control
// The following example disables the specified control in the specified security standard.
func ExampleSecurityHub_ListFindingAggregators_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.ListFindingAggregatorsInput{}

	result, err := svc.ListFindingAggregators(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeAccessDeniedException:
				fmt.Println(securityhub.ErrCodeAccessDeniedException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list membership invitations to calling account
// The following example returns a list of Security Hub member invitations sent to the
// calling AWS account. Only accounts that are invited manually use this operation.
// It's not for use by accounts that are managed through AWS Organizations.
func ExampleSecurityHub_ListInvitations_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.ListInvitationsInput{}

	result, err := svc.ListInvitations(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list member account details
// The following example returns details about member accounts for the calling Security
// Hub administrator account. The response includes member accounts that are managed
// through AWS Organizations and those that were invited manually.
func ExampleSecurityHub_ListMembers_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.ListMembersInput{}

	result, err := svc.ListMembers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list administrator acccounts for an organization
// The following example lists the Security Hub administrator accounts for an organization.
// Only the organization management account can call this operation.
func ExampleSecurityHub_ListOrganizationAdminAccounts_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.ListOrganizationAdminAccountsInput{}

	result, err := svc.ListOrganizationAdminAccounts(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list security controls that apply to a standard
// The following example lists security controls that apply to a specified Security
// Hub standard.
func ExampleSecurityHub_ListSecurityControlDefinitions_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.ListSecurityControlDefinitionsInput{
		MaxResults:   aws.Int64(3),
		NextToken:    aws.String("NULL"),
		StandardsArn: aws.String("arn:aws:securityhub:::standards/aws-foundational-security-best-practices/v/1.0.0"),
	}

	result, err := svc.ListSecurityControlDefinitions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To say whether standard
// The following example specifies whether a control is currently enabled or disabled
// in each enabled standard in the calling account. The response also provides other
// details about the control.
func ExampleSecurityHub_ListStandardsControlAssociations_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.ListStandardsControlAssociationsInput{
		SecurityControlId: aws.String("S3.1"),
	}

	result, err := svc.ListStandardsControlAssociations(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a list of tags for a resource
// The following example returns a list of tags associated with the specified resource.
func ExampleSecurityHub_ListTagsForResource_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.ListTagsForResourceInput{
		ResourceArn: aws.String("arn:aws:securityhub:us-west-1:123456789012:hub/default"),
	}

	result, err := svc.ListTagsForResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To tag a resource
// The following example adds the 'Department' and 'Area' tags to the specified resource.
func ExampleSecurityHub_TagResource_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.TagResourceInput{
		ResourceArn: aws.String("arn:aws:securityhub:us-west-1:123456789012:hub/default"),
		Tags: map[string]*string{
			"Area":       aws.String("USMidwest"),
			"Department": aws.String("Operations"),
		},
	}

	result, err := svc.TagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove tags from a resource
// The following example removes the 'Department' tag from the specified resource.
func ExampleSecurityHub_UntagResource_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.UntagResourceInput{
		ResourceArn: aws.String("arn:aws:securityhub:us-west-1:123456789012:hub/default"),
		TagKeys: []*string{
			aws.String("Department"),
		},
	}

	result, err := svc.UntagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the name and description of a custom action target
// The following example updates the name and description of a custom action target
// in Security Hub. You can create custom actions to automatically respond to Security
// Hub findings using Amazon EventBridge.
func ExampleSecurityHub_UpdateActionTarget_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.UpdateActionTargetInput{
		ActionTargetArn: aws.String("arn:aws:securityhub:us-west-1:123456789012:action/custom/Remediation"),
		Description:     aws.String("Sends specified findings to customer service chat"),
		Name:            aws.String("Chat custom action"),
	}

	result, err := svc.UpdateActionTarget(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update cross-Region aggregation settings
// The following example updates the cross-Region aggregation configuration. You use
// this operation to change the list of linked Regions and the treatment of new Regions.
// However, you cannot use this operation to change the aggregation Region.
func ExampleSecurityHub_UpdateFindingAggregator_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.UpdateFindingAggregatorInput{
		FindingAggregatorArn: aws.String("arn:aws:securityhub:us-east-1:123456789012:finding-aggregator/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111"),
		RegionLinkingMode:    aws.String("SPECIFIED_REGIONS"),
		Regions: []*string{
			aws.String("us-west-1"),
			aws.String("us-west-2"),
		},
	}

	result, err := svc.UpdateFindingAggregator(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeAccessDeniedException:
				fmt.Println(securityhub.ErrCodeAccessDeniedException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update an insight
// The following example updates the specified Security Hub insight.
func ExampleSecurityHub_UpdateInsight_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.UpdateInsightInput{
		Filters: &securityhub.AwsSecurityFindingFilters{
			ResourceType: []*securityhub.StringFilter{
				{
					Comparison: aws.String("EQUALS"),
					Value:      aws.String("AwsIamRole"),
				},
			},
			SeverityLabel: []*securityhub.StringFilter{
				{
					Comparison: aws.String("EQUALS"),
					Value:      aws.String("HIGH"),
				},
			},
		},
		InsightArn: aws.String("arn:aws:securityhub:us-west-1:123456789012:insight/123456789012/custom/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111"),
		Name:       aws.String("High severity role findings"),
	}

	result, err := svc.UpdateInsight(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update organization configuration
// The following example updates the configuration for an organization so that Security
// Hub is automatically activated for new member accounts. Only the Security Hub administrator
// account can call this operation.
func ExampleSecurityHub_UpdateOrganizationConfiguration_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.UpdateOrganizationConfigurationInput{
		AutoEnable: aws.Bool(true),
	}

	result, err := svc.UpdateOrganizationConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update Security Hub settings
// The following example updates Security Hub settings to turn on consolidated control
// findings, and to automatically enable new controls in enabled standards.
func ExampleSecurityHub_UpdateSecurityHubConfiguration_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.UpdateSecurityHubConfigurationInput{
		AutoEnableControls:      aws.Bool(true),
		ControlFindingGenerator: aws.String("SECURITY_CONTROL"),
	}

	result, err := svc.UpdateSecurityHubConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeLimitExceededException:
				fmt.Println(securityhub.ErrCodeLimitExceededException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the enablement status of a standard control
// The following example disables the specified control in the specified security standard.
func ExampleSecurityHub_UpdateStandardsControl_shared00() {
	svc := securityhub.New(session.New())
	input := &securityhub.UpdateStandardsControlInput{
		ControlStatus:       aws.String("DISABLED"),
		DisabledReason:      aws.String("Not applicable to my service"),
		StandardsControlArn: aws.String("arn:aws:securityhub:us-west-1:123456789012:control/pci-dss/v/3.2.1/PCI.AutoScaling.1"),
	}

	result, err := svc.UpdateStandardsControl(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case securityhub.ErrCodeInternalException:
				fmt.Println(securityhub.ErrCodeInternalException, aerr.Error())
			case securityhub.ErrCodeInvalidInputException:
				fmt.Println(securityhub.ErrCodeInvalidInputException, aerr.Error())
			case securityhub.ErrCodeInvalidAccessException:
				fmt.Println(securityhub.ErrCodeInvalidAccessException, aerr.Error())
			case securityhub.ErrCodeResourceNotFoundException:
				fmt.Println(securityhub.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
