/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.misc;

public class StackTrace {
    public static String getStackTrace(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        do {
            if (bl) {
                stringBuffer.append(throwable.getClass().getName()).append(' ');
                bl = false;
            } else {
                stringBuffer.append("Caused by ").append(throwable.getClass().getName());
            }
            StackTraceElement[] stackTraceElementArray = throwable.getMessage();
            if (stackTraceElementArray != null) {
                stringBuffer.append(": ").append((String)stackTraceElementArray);
            } else {
                stringBuffer.append(" No message");
            }
            stringBuffer.append('\n');
            stackTraceElementArray = throwable.getStackTrace();
            for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i2];
                stringBuffer.append("      at ").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")");
                if (stackTraceElement.isNativeMethod()) {
                    stringBuffer.append(" -  Native method");
                }
                stringBuffer.append("\n");
            }
        } while ((throwable = throwable.getCause()) != null);
        return stringBuffer.toString();
    }

    public static String getStackTrace() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 1; i2 < stackTraceElementArray.length; ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringBuffer.append("      at ").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")");
            if (stackTraceElement.isNativeMethod()) {
                stringBuffer.append(" -  Native method");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static boolean isRecursing(String string) {
        String string2 = StackTrace.getStackTrace();
        int n2 = string2.indexOf(string);
        if (n2 < 0) {
            return false;
        }
        return string2.indexOf(string, n2 + string.length()) >= 0;
    }

    public String getFrom() {
        return this.getFrom(1);
    }

    public String getFrom(int n2) {
        Object object = new Throwable();
        int n3 = n2 + 2;
        object = ((Throwable)object).getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        object = object[n3];
        stringBuffer.append("From ").append(((StackTraceElement)object).getClassName()).append(".").append(((StackTraceElement)object).getMethodName()).append("(").append(((StackTraceElement)object).getFileName()).append(":").append(((StackTraceElement)object).getLineNumber()).append(")");
        if (((StackTraceElement)object).isNativeMethod()) {
            stringBuffer.append(" -  Native method");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return StackTrace.getStackTrace();
    }
}

