'use strict';
goog.provide('modules.shared.glsBuiltinPrecisionTestsUnitTests');
goog.require('framework.common.tcuInterval');
goog.require('framework.common.tcuMatrix');

goog.scope(function() {

    modules.shared.glsBuiltinPrecisionTestsUnitTests.cppreference = [];
    var tcuInterval = framework.common.tcuInterval;
    var glsBuiltinPrecisionTestsUnitTests = modules.shared.glsBuiltinPrecisionTestsUnitTests;
    var tcuMatrix = framework.common.tcuMatrix;

    var ref = modules.shared.glsBuiltinPrecisionTestsUnitTests.cppreference;
ref.push({testName: 'precision.add.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.390625, 0.40625]});
ref.push({testName: 'precision.add.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.695313, 0.703125]});
ref.push({testName: 'precision.add.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.390625, 0.40625, false, 0.390625, 0.40625]});
ref.push({testName: 'precision.add.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.695313, 0.703125, false, 0.695313, 0.703125]});
ref.push({testName: 'precision.add.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.390625, 0.40625, false, 0.390625, 0.40625, false, 0.390625, 0.40625]});
ref.push({testName: 'precision.add.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.695313, 0.703125, false, 0.695313, 0.703125, false, 0.695313, 0.703125]});
ref.push({testName: 'precision.add.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.390625, 0.40625, false, 0.390625, 0.40625, false, 0.390625, 0.40625, false, 0.390625, 0.40625]});
ref.push({testName: 'precision.add.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.695313, 0.703125, false, 0.695313, 0.703125, false, 0.695313, 0.703125, false, 0.695313, 0.703125]});
ref.push({testName: 'precision.add.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.390625, 0.40625]});
ref.push({testName: 'precision.add.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.695313, 0.703125]});
ref.push({testName: 'precision.add.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.390625, 0.40625, false, 0.390625, 0.40625]});
ref.push({testName: 'precision.add.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.695313, 0.703125, false, 0.695313, 0.703125]});
ref.push({testName: 'precision.add.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.390625, 0.40625, false, 0.390625, 0.40625, false, 0.390625, 0.40625]});
ref.push({testName: 'precision.add.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.695313, 0.703125, false, 0.695313, 0.703125, false, 0.695313, 0.703125]});
ref.push({testName: 'precision.add.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.390625, 0.40625, false, 0.390625, 0.40625, false, 0.390625, 0.40625, false, 0.390625, 0.40625]});
ref.push({testName: 'precision.add.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.695313, 0.703125, false, 0.695313, 0.703125, false, 0.695313, 0.703125, false, 0.695313, 0.703125]});
ref.push({testName: 'precision.add.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.399902, 0.400391]});
ref.push({testName: 'precision.add.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.699219, 0.700195]});
ref.push({testName: 'precision.add.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.399902, 0.400391, false, 0.399902, 0.400391]});
ref.push({testName: 'precision.add.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.699219, 0.700195, false, 0.699219, 0.700195]});
ref.push({testName: 'precision.add.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.399902, 0.400391, false, 0.399902, 0.400391, false, 0.399902, 0.400391]});
ref.push({testName: 'precision.add.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.699219, 0.700195, false, 0.699219, 0.700195, false, 0.699219, 0.700195]});
ref.push({testName: 'precision.add.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.399902, 0.400391, false, 0.399902, 0.400391, false, 0.399902, 0.400391, false, 0.399902, 0.400391]});
ref.push({testName: 'precision.add.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.699219, 0.700195, false, 0.699219, 0.700195, false, 0.699219, 0.700195, false, 0.699219, 0.700195]});
ref.push({testName: 'precision.add.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.399902, 0.400391]});
ref.push({testName: 'precision.add.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.699219, 0.700195]});
ref.push({testName: 'precision.add.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.399902, 0.400391, false, 0.399902, 0.400391]});
ref.push({testName: 'precision.add.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.699219, 0.700195, false, 0.699219, 0.700195]});
ref.push({testName: 'precision.add.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.399902, 0.400391, false, 0.399902, 0.400391, false, 0.399902, 0.400391]});
ref.push({testName: 'precision.add.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.699219, 0.700195, false, 0.699219, 0.700195, false, 0.699219, 0.700195]});
ref.push({testName: 'precision.add.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.399902, 0.400391, false, 0.399902, 0.400391, false, 0.399902, 0.400391, false, 0.399902, 0.400391]});
ref.push({testName: 'precision.add.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.699219, 0.700195, false, 0.699219, 0.700195, false, 0.699219, 0.700195, false, 0.699219, 0.700195]});
ref.push({testName: 'precision.add.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.4, 0.4]});
ref.push({testName: 'precision.add.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.7, 0.7]});
ref.push({testName: 'precision.add.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.4, 0.4, false, 0.4, 0.4]});
ref.push({testName: 'precision.add.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.7, 0.7, false, 0.7, 0.7]});
ref.push({testName: 'precision.add.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.4, 0.4, false, 0.4, 0.4, false, 0.4, 0.4]});
ref.push({testName: 'precision.add.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.7, 0.7, false, 0.7, 0.7, false, 0.7, 0.7]});
ref.push({testName: 'precision.add.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.4, 0.4, false, 0.4, 0.4, false, 0.4, 0.4, false, 0.4, 0.4]});
ref.push({testName: 'precision.add.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.7, 0.7, false, 0.7, 0.7, false, 0.7, 0.7, false, 0.7, 0.7]});
ref.push({testName: 'precision.add.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.4, 0.4]});
ref.push({testName: 'precision.add.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.7, 0.7]});
ref.push({testName: 'precision.add.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.4, 0.4, false, 0.4, 0.4]});
ref.push({testName: 'precision.add.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.7, 0.7, false, 0.7, 0.7]});
ref.push({testName: 'precision.add.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.4, 0.4, false, 0.4, 0.4, false, 0.4, 0.4]});
ref.push({testName: 'precision.add.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.7, 0.7, false, 0.7, 0.7, false, 0.7, 0.7]});
ref.push({testName: 'precision.add.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.4, 0.4, false, 0.4, 0.4, false, 0.4, 0.4, false, 0.4, 0.4]});
ref.push({testName: 'precision.add.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.7, 0.7, false, 0.7, 0.7, false, 0.7, 0.7, false, 0.7, 0.7]});
ref.push({testName: 'precision.sub.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, -0.0078125, 0.0078125]});
ref.push({testName: 'precision.sub.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, -0.304688, -0.296875]});
ref.push({testName: 'precision.sub.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125]});
ref.push({testName: 'precision.sub.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -0.304688, -0.296875, false, -0.304688, -0.296875]});
ref.push({testName: 'precision.sub.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125]});
ref.push({testName: 'precision.sub.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.304688, -0.296875, false, -0.304688, -0.296875, false, -0.304688, -0.296875]});
ref.push({testName: 'precision.sub.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125]});
ref.push({testName: 'precision.sub.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -0.304688, -0.296875, false, -0.304688, -0.296875, false, -0.304688, -0.296875, false, -0.304688, -0.296875]});
ref.push({testName: 'precision.sub.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, -0.0078125, 0.0078125]});
ref.push({testName: 'precision.sub.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, -0.304688, -0.296875]});
ref.push({testName: 'precision.sub.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125]});
ref.push({testName: 'precision.sub.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -0.304688, -0.296875, false, -0.304688, -0.296875]});
ref.push({testName: 'precision.sub.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125]});
ref.push({testName: 'precision.sub.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.304688, -0.296875, false, -0.304688, -0.296875, false, -0.304688, -0.296875]});
ref.push({testName: 'precision.sub.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125]});
ref.push({testName: 'precision.sub.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -0.304688, -0.296875, false, -0.304688, -0.296875, false, -0.304688, -0.296875, false, -0.304688, -0.296875]});
ref.push({testName: 'precision.sub.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, -0.000244141, 0.000244141]});
ref.push({testName: 'precision.sub.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, -0.300293, -0.299805]});
ref.push({testName: 'precision.sub.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141]});
ref.push({testName: 'precision.sub.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -0.300293, -0.299805, false, -0.300293, -0.299805]});
ref.push({testName: 'precision.sub.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141]});
ref.push({testName: 'precision.sub.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.300293, -0.299805, false, -0.300293, -0.299805, false, -0.300293, -0.299805]});
ref.push({testName: 'precision.sub.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141]});
ref.push({testName: 'precision.sub.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -0.300293, -0.299805, false, -0.300293, -0.299805, false, -0.300293, -0.299805, false, -0.300293, -0.299805]});
ref.push({testName: 'precision.sub.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, -0.000244141, 0.000244141]});
ref.push({testName: 'precision.sub.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, -0.300293, -0.299805]});
ref.push({testName: 'precision.sub.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141]});
ref.push({testName: 'precision.sub.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -0.300293, -0.299805, false, -0.300293, -0.299805]});
ref.push({testName: 'precision.sub.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141]});
ref.push({testName: 'precision.sub.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.300293, -0.299805, false, -0.300293, -0.299805, false, -0.300293, -0.299805]});
ref.push({testName: 'precision.sub.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141]});
ref.push({testName: 'precision.sub.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -0.300293, -0.299805, false, -0.300293, -0.299805, false, -0.300293, -0.299805, false, -0.300293, -0.299805]});
ref.push({testName: 'precision.sub.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.sub.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, -0.3, -0.3]});
ref.push({testName: 'precision.sub.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.sub.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -0.3, -0.3, false, -0.3, -0.3]});
ref.push({testName: 'precision.sub.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.sub.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.3, -0.3, false, -0.3, -0.3, false, -0.3, -0.3]});
ref.push({testName: 'precision.sub.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.sub.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -0.3, -0.3, false, -0.3, -0.3, false, -0.3, -0.3, false, -0.3, -0.3]});
ref.push({testName: 'precision.sub.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.sub.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, -0.3, -0.3]});
ref.push({testName: 'precision.sub.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.sub.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -0.3, -0.3, false, -0.3, -0.3]});
ref.push({testName: 'precision.sub.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.sub.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.3, -0.3, false, -0.3, -0.3, false, -0.3, -0.3]});
ref.push({testName: 'precision.sub.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.sub.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -0.3, -0.3, false, -0.3, -0.3, false, -0.3, -0.3, false, -0.3, -0.3]});
ref.push({testName: 'precision.mul.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.03125, 0.046875]});
ref.push({testName: 'precision.mul.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.09375, 0.101563]});
ref.push({testName: 'precision.mul.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.mul.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.mul.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.mul.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.mul.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.mul.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.mul.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.03125, 0.046875]});
ref.push({testName: 'precision.mul.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.09375, 0.101563]});
ref.push({testName: 'precision.mul.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.mul.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.mul.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.mul.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.mul.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.mul.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.mul.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.mul.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.mul.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.mul.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.mul.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.mul.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.mul.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.mul.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.mul.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.mul.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.mul.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.mul.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.mul.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.mul.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.mul.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.mul.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.mul.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.04, 0.04]});
ref.push({testName: 'precision.mul.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.1, 0.1]});
ref.push({testName: 'precision.mul.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.mul.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.mul.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.mul.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.mul.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.mul.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.mul.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.04, 0.04]});
ref.push({testName: 'precision.mul.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.1, 0.1]});
ref.push({testName: 'precision.mul.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.mul.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.mul.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.mul.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.mul.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.mul.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.div.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.div.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.996338, 1.0061]});
ref.push({testName: 'precision.div.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.398682, 0.401611]});
ref.push({testName: 'precision.div.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.996338, 1.0061, false, 0.996338, 1.0061]});
ref.push({testName: 'precision.div.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.398682, 0.401611, false, 0.398682, 0.401611]});
ref.push({testName: 'precision.div.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.996338, 1.0061, false, 0.996338, 1.0061, false, 0.996338, 1.0061]});
ref.push({testName: 'precision.div.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.398682, 0.401611, false, 0.398682, 0.401611, false, 0.398682, 0.401611]});
ref.push({testName: 'precision.div.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.996338, 1.0061, false, 0.996338, 1.0061, false, 0.996338, 1.0061, false, 0.996338, 1.0061]});
ref.push({testName: 'precision.div.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.398682, 0.401611, false, 0.398682, 0.401611, false, 0.398682, 0.401611, false, 0.398682, 0.401611]});
ref.push({testName: 'precision.div.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.996338, 1.0061]});
ref.push({testName: 'precision.div.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.398682, 0.401611]});
ref.push({testName: 'precision.div.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.996338, 1.0061, false, 0.996338, 1.0061]});
ref.push({testName: 'precision.div.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.398682, 0.401611, false, 0.398682, 0.401611]});
ref.push({testName: 'precision.div.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.996338, 1.0061, false, 0.996338, 1.0061, false, 0.996338, 1.0061]});
ref.push({testName: 'precision.div.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.398682, 0.401611, false, 0.398682, 0.401611, false, 0.398682, 0.401611]});
ref.push({testName: 'precision.div.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.996338, 1.0061, false, 0.996338, 1.0061, false, 0.996338, 1.0061, false, 0.996338, 1.0061]});
ref.push({testName: 'precision.div.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.398682, 0.401611, false, 0.398682, 0.401611, false, 0.398682, 0.401611, false, 0.398682, 0.401611]});
ref.push({testName: 'precision.div.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.div.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.4, 0.4]});
ref.push({testName: 'precision.div.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.div.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.4, 0.4, false, 0.4, 0.4]});
ref.push({testName: 'precision.div.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.div.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.4, 0.4, false, 0.4, 0.4, false, 0.4, 0.4]});
ref.push({testName: 'precision.div.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.div.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.4, 0.4, false, 0.4, 0.4, false, 0.4, 0.4, false, 0.4, 0.4]});
ref.push({testName: 'precision.div.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.div.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.4, 0.4]});
ref.push({testName: 'precision.div.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.div.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.4, 0.4, false, 0.4, 0.4]});
ref.push({testName: 'precision.div.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.div.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.4, 0.4, false, 0.4, 0.4, false, 0.4, 0.4]});
ref.push({testName: 'precision.div.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.div.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.4, 0.4, false, 0.4, 0.4, false, 0.4, 0.4, false, 0.4, 0.4]});
ref.push({testName: 'precision.radians.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.radians.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.00347137, 0.00350952]});
ref.push({testName: 'precision.radians.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.00868225, 0.0087738]});
ref.push({testName: 'precision.radians.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.00347137, 0.00350952, false, 0.00347137, 0.00350952]});
ref.push({testName: 'precision.radians.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.00868225, 0.0087738, false, 0.00868225, 0.0087738]});
ref.push({testName: 'precision.radians.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.00347137, 0.00350952, false, 0.00347137, 0.00350952, false, 0.00347137, 0.00350952]});
ref.push({testName: 'precision.radians.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.00868225, 0.0087738, false, 0.00868225, 0.0087738, false, 0.00868225, 0.0087738]});
ref.push({testName: 'precision.radians.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.00347137, 0.00350952, false, 0.00347137, 0.00350952, false, 0.00347137, 0.00350952, false, 0.00347137, 0.00350952]});
ref.push({testName: 'precision.radians.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.00868225, 0.0087738, false, 0.00868225, 0.0087738, false, 0.00868225, 0.0087738, false, 0.00868225, 0.0087738]});
ref.push({testName: 'precision.radians.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.00347137, 0.00350952]});
ref.push({testName: 'precision.radians.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.00868225, 0.0087738]});
ref.push({testName: 'precision.radians.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.00347137, 0.00350952, false, 0.00347137, 0.00350952]});
ref.push({testName: 'precision.radians.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.00868225, 0.0087738, false, 0.00868225, 0.0087738]});
ref.push({testName: 'precision.radians.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.00347137, 0.00350952, false, 0.00347137, 0.00350952, false, 0.00347137, 0.00350952]});
ref.push({testName: 'precision.radians.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.00868225, 0.0087738, false, 0.00868225, 0.0087738, false, 0.00868225, 0.0087738]});
ref.push({testName: 'precision.radians.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.00347137, 0.00350952, false, 0.00347137, 0.00350952, false, 0.00347137, 0.00350952, false, 0.00347137, 0.00350952]});
ref.push({testName: 'precision.radians.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.00868225, 0.0087738, false, 0.00868225, 0.0087738, false, 0.00868225, 0.0087738, false, 0.00868225, 0.0087738]});
ref.push({testName: 'precision.radians.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.00349066, 0.00349066]});
ref.push({testName: 'precision.radians.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.00872664, 0.00872665]});
ref.push({testName: 'precision.radians.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.00349066, 0.00349066, false, 0.00349066, 0.00349066]});
ref.push({testName: 'precision.radians.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.00872664, 0.00872665, false, 0.00872664, 0.00872665]});
ref.push({testName: 'precision.radians.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.00349066, 0.00349066, false, 0.00349066, 0.00349066, false, 0.00349066, 0.00349066]});
ref.push({testName: 'precision.radians.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.00872664, 0.00872665, false, 0.00872664, 0.00872665, false, 0.00872664, 0.00872665]});
ref.push({testName: 'precision.radians.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.00349066, 0.00349066, false, 0.00349066, 0.00349066, false, 0.00349066, 0.00349066, false, 0.00349066, 0.00349066]});
ref.push({testName: 'precision.radians.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.00872664, 0.00872665, false, 0.00872664, 0.00872665, false, 0.00872664, 0.00872665, false, 0.00872664, 0.00872665]});
ref.push({testName: 'precision.radians.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.00349066, 0.00349066]});
ref.push({testName: 'precision.radians.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.00872664, 0.00872665]});
ref.push({testName: 'precision.radians.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.00349066, 0.00349066, false, 0.00349066, 0.00349066]});
ref.push({testName: 'precision.radians.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.00872664, 0.00872665, false, 0.00872664, 0.00872665]});
ref.push({testName: 'precision.radians.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.00349066, 0.00349066, false, 0.00349066, 0.00349066, false, 0.00349066, 0.00349066]});
ref.push({testName: 'precision.radians.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.00872664, 0.00872665, false, 0.00872664, 0.00872665, false, 0.00872664, 0.00872665]});
ref.push({testName: 'precision.radians.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.00349066, 0.00349066, false, 0.00349066, 0.00349066, false, 0.00349066, 0.00349066, false, 0.00349066, 0.00349066]});
ref.push({testName: 'precision.radians.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.00872664, 0.00872665, false, 0.00872664, 0.00872665, false, 0.00872664, 0.00872665, false, 0.00872664, 0.00872665]});
ref.push({testName: 'precision.degrees.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.degrees.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 11.4219, 11.5156]});
ref.push({testName: 'precision.degrees.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 28.5625, 28.75]});
ref.push({testName: 'precision.degrees.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 11.4219, 11.5156, false, 11.4219, 11.5156]});
ref.push({testName: 'precision.degrees.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 28.5625, 28.75, false, 28.5625, 28.75]});
ref.push({testName: 'precision.degrees.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 11.4219, 11.5156, false, 11.4219, 11.5156, false, 11.4219, 11.5156]});
ref.push({testName: 'precision.degrees.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 28.5625, 28.75, false, 28.5625, 28.75, false, 28.5625, 28.75]});
ref.push({testName: 'precision.degrees.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 11.4219, 11.5156, false, 11.4219, 11.5156, false, 11.4219, 11.5156, false, 11.4219, 11.5156]});
ref.push({testName: 'precision.degrees.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 28.5625, 28.75, false, 28.5625, 28.75, false, 28.5625, 28.75, false, 28.5625, 28.75]});
ref.push({testName: 'precision.degrees.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 11.4219, 11.5156]});
ref.push({testName: 'precision.degrees.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 28.5625, 28.75]});
ref.push({testName: 'precision.degrees.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 11.4219, 11.5156, false, 11.4219, 11.5156]});
ref.push({testName: 'precision.degrees.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 28.5625, 28.75, false, 28.5625, 28.75]});
ref.push({testName: 'precision.degrees.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 11.4219, 11.5156, false, 11.4219, 11.5156, false, 11.4219, 11.5156]});
ref.push({testName: 'precision.degrees.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 28.5625, 28.75, false, 28.5625, 28.75, false, 28.5625, 28.75]});
ref.push({testName: 'precision.degrees.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 11.4219, 11.5156, false, 11.4219, 11.5156, false, 11.4219, 11.5156, false, 11.4219, 11.5156]});
ref.push({testName: 'precision.degrees.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 28.5625, 28.75, false, 28.5625, 28.75, false, 28.5625, 28.75, false, 28.5625, 28.75]});
ref.push({testName: 'precision.degrees.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 11.4592, 11.4592]});
ref.push({testName: 'precision.degrees.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 28.6479, 28.6479]});
ref.push({testName: 'precision.degrees.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 11.4592, 11.4592, false, 11.4592, 11.4592]});
ref.push({testName: 'precision.degrees.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 28.6479, 28.6479, false, 28.6479, 28.6479]});
ref.push({testName: 'precision.degrees.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 11.4592, 11.4592, false, 11.4592, 11.4592, false, 11.4592, 11.4592]});
ref.push({testName: 'precision.degrees.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 28.6479, 28.6479, false, 28.6479, 28.6479, false, 28.6479, 28.6479]});
ref.push({testName: 'precision.degrees.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 11.4592, 11.4592, false, 11.4592, 11.4592, false, 11.4592, 11.4592, false, 11.4592, 11.4592]});
ref.push({testName: 'precision.degrees.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 28.6479, 28.6479, false, 28.6479, 28.6479, false, 28.6479, 28.6479, false, 28.6479, 28.6479]});
ref.push({testName: 'precision.degrees.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 11.4592, 11.4592]});
ref.push({testName: 'precision.degrees.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 28.6479, 28.6479]});
ref.push({testName: 'precision.degrees.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 11.4592, 11.4592, false, 11.4592, 11.4592]});
ref.push({testName: 'precision.degrees.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 28.6479, 28.6479, false, 28.6479, 28.6479]});
ref.push({testName: 'precision.degrees.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 11.4592, 11.4592, false, 11.4592, 11.4592, false, 11.4592, 11.4592]});
ref.push({testName: 'precision.degrees.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 28.6479, 28.6479, false, 28.6479, 28.6479, false, 28.6479, 28.6479]});
ref.push({testName: 'precision.degrees.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 11.4592, 11.4592, false, 11.4592, 11.4592, false, 11.4592, 11.4592, false, 11.4592, 11.4592]});
ref.push({testName: 'precision.degrees.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 28.6479, 28.6479, false, 28.6479, 28.6479, false, 28.6479, 28.6479, false, 28.6479, 28.6479]});
ref.push({testName: 'precision.sin.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.178448, 0.217356]});
ref.push({testName: 'precision.sin.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.463801, 0.495051]});
ref.push({testName: 'precision.sin.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.178448, 0.217356, false, 0.178448, 0.217356]});
ref.push({testName: 'precision.sin.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.463801, 0.495051, false, 0.463801, 0.495051]});
ref.push({testName: 'precision.sin.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.178448, 0.217356, false, 0.178448, 0.217356, false, 0.178448, 0.217356]});
ref.push({testName: 'precision.sin.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.463801, 0.495051, false, 0.463801, 0.495051, false, 0.463801, 0.495051]});
ref.push({testName: 'precision.sin.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.178448, 0.217356, false, 0.178448, 0.217356, false, 0.178448, 0.217356, false, 0.178448, 0.217356]});
ref.push({testName: 'precision.sin.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.463801, 0.495051, false, 0.463801, 0.495051, false, 0.463801, 0.495051, false, 0.463801, 0.495051]});
ref.push({testName: 'precision.sin.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.178448, 0.217356]});
ref.push({testName: 'precision.sin.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.463801, 0.495051]});
ref.push({testName: 'precision.sin.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.178448, 0.217356, false, 0.178448, 0.217356]});
ref.push({testName: 'precision.sin.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.463801, 0.495051, false, 0.463801, 0.495051]});
ref.push({testName: 'precision.sin.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.178448, 0.217356, false, 0.178448, 0.217356, false, 0.178448, 0.217356]});
ref.push({testName: 'precision.sin.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.463801, 0.495051, false, 0.463801, 0.495051, false, 0.463801, 0.495051]});
ref.push({testName: 'precision.sin.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.178448, 0.217356, false, 0.178448, 0.217356, false, 0.178448, 0.217356, false, 0.178448, 0.217356]});
ref.push({testName: 'precision.sin.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.463801, 0.495051, false, 0.463801, 0.495051, false, 0.463801, 0.495051, false, 0.463801, 0.495051]});
ref.push({testName: 'precision.sin.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.198133, 0.199349]});
ref.push({testName: 'precision.sin.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.478449, 0.480402]});
ref.push({testName: 'precision.sin.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.198133, 0.199349, false, 0.198133, 0.199349]});
ref.push({testName: 'precision.sin.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.478449, 0.480402, false, 0.478449, 0.480402]});
ref.push({testName: 'precision.sin.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.198133, 0.199349, false, 0.198133, 0.199349, false, 0.198133, 0.199349]});
ref.push({testName: 'precision.sin.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.478449, 0.480402, false, 0.478449, 0.480402, false, 0.478449, 0.480402]});
ref.push({testName: 'precision.sin.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.198133, 0.199349, false, 0.198133, 0.199349, false, 0.198133, 0.199349, false, 0.198133, 0.199349]});
ref.push({testName: 'precision.sin.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.478449, 0.480402, false, 0.478449, 0.480402, false, 0.478449, 0.480402, false, 0.478449, 0.480402]});
ref.push({testName: 'precision.sin.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.198133, 0.199349]});
ref.push({testName: 'precision.sin.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.478449, 0.480402]});
ref.push({testName: 'precision.sin.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.198133, 0.199349, false, 0.198133, 0.199349]});
ref.push({testName: 'precision.sin.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.478449, 0.480402, false, 0.478449, 0.480402]});
ref.push({testName: 'precision.sin.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.198133, 0.199349, false, 0.198133, 0.199349, false, 0.198133, 0.199349]});
ref.push({testName: 'precision.sin.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.478449, 0.480402, false, 0.478449, 0.480402, false, 0.478449, 0.480402]});
ref.push({testName: 'precision.sin.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.198133, 0.199349, false, 0.198133, 0.199349, false, 0.198133, 0.199349, false, 0.198133, 0.199349]});
ref.push({testName: 'precision.sin.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.478449, 0.480402, false, 0.478449, 0.480402, false, 0.478449, 0.480402, false, 0.478449, 0.480402]});
ref.push({testName: 'precision.sin.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.198181, 0.199158]});
ref.push({testName: 'precision.sin.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.478937, 0.479914]});
ref.push({testName: 'precision.sin.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.198181, 0.199158, false, 0.198181, 0.199158]});
ref.push({testName: 'precision.sin.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.478937, 0.479914, false, 0.478937, 0.479914]});
ref.push({testName: 'precision.sin.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.198181, 0.199158, false, 0.198181, 0.199158, false, 0.198181, 0.199158]});
ref.push({testName: 'precision.sin.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.478937, 0.479914, false, 0.478937, 0.479914, false, 0.478937, 0.479914]});
ref.push({testName: 'precision.sin.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.198181, 0.199158, false, 0.198181, 0.199158, false, 0.198181, 0.199158, false, 0.198181, 0.199158]});
ref.push({testName: 'precision.sin.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.478937, 0.479914, false, 0.478937, 0.479914, false, 0.478937, 0.479914, false, 0.478937, 0.479914]});
ref.push({testName: 'precision.sin.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.198181, 0.199158]});
ref.push({testName: 'precision.sin.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.478937, 0.479914]});
ref.push({testName: 'precision.sin.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.198181, 0.199158, false, 0.198181, 0.199158]});
ref.push({testName: 'precision.sin.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.478937, 0.479914, false, 0.478937, 0.479914]});
ref.push({testName: 'precision.sin.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.198181, 0.199158, false, 0.198181, 0.199158, false, 0.198181, 0.199158]});
ref.push({testName: 'precision.sin.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.478937, 0.479914, false, 0.478937, 0.479914, false, 0.478937, 0.479914]});
ref.push({testName: 'precision.sin.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.198181, 0.199158, false, 0.198181, 0.199158, false, 0.198181, 0.199158, false, 0.198181, 0.199158]});
ref.push({testName: 'precision.sin.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.478937, 0.479914, false, 0.478937, 0.479914, false, 0.478937, 0.479914, false, 0.478937, 0.479914]});
ref.push({testName: 'precision.cos.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.963816, 0.996612]});
ref.push({testName: 'precision.cos.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.861958, 0.893208]});
ref.push({testName: 'precision.cos.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.963816, 0.996612, false, 0.963816, 0.996612]});
ref.push({testName: 'precision.cos.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.861958, 0.893208, false, 0.861958, 0.893208]});
ref.push({testName: 'precision.cos.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.963816, 0.996612, false, 0.963816, 0.996612, false, 0.963816, 0.996612]});
ref.push({testName: 'precision.cos.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.861958, 0.893208, false, 0.861958, 0.893208, false, 0.861958, 0.893208]});
ref.push({testName: 'precision.cos.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.963816, 0.996612, false, 0.963816, 0.996612, false, 0.963816, 0.996612, false, 0.963816, 0.996612]});
ref.push({testName: 'precision.cos.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.861958, 0.893208, false, 0.861958, 0.893208, false, 0.861958, 0.893208, false, 0.861958, 0.893208]});
ref.push({testName: 'precision.cos.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.963816, 0.996612]});
ref.push({testName: 'precision.cos.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.861958, 0.893208]});
ref.push({testName: 'precision.cos.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.963816, 0.996612, false, 0.963816, 0.996612]});
ref.push({testName: 'precision.cos.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.861958, 0.893208, false, 0.861958, 0.893208]});
ref.push({testName: 'precision.cos.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.963816, 0.996612, false, 0.963816, 0.996612, false, 0.963816, 0.996612]});
ref.push({testName: 'precision.cos.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.861958, 0.893208, false, 0.861958, 0.893208, false, 0.861958, 0.893208]});
ref.push({testName: 'precision.cos.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.963816, 0.996612, false, 0.963816, 0.996612, false, 0.963816, 0.996612, false, 0.963816, 0.996612]});
ref.push({testName: 'precision.cos.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.861958, 0.893208, false, 0.861958, 0.893208, false, 0.861958, 0.893208, false, 0.861958, 0.893208]});
ref.push({testName: 'precision.cos.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.978075, 0.982029]});
ref.push({testName: 'precision.cos.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.875629, 0.879536]});
ref.push({testName: 'precision.cos.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.978075, 0.982029, false, 0.978075, 0.982029]});
ref.push({testName: 'precision.cos.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.875629, 0.879536, false, 0.875629, 0.879536]});
ref.push({testName: 'precision.cos.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.978075, 0.982029, false, 0.978075, 0.982029, false, 0.978075, 0.982029]});
ref.push({testName: 'precision.cos.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.875629, 0.879536, false, 0.875629, 0.879536, false, 0.875629, 0.879536]});
ref.push({testName: 'precision.cos.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.978075, 0.982029, false, 0.978075, 0.982029, false, 0.978075, 0.982029, false, 0.978075, 0.982029]});
ref.push({testName: 'precision.cos.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.875629, 0.879536, false, 0.875629, 0.879536, false, 0.875629, 0.879536, false, 0.875629, 0.879536]});
ref.push({testName: 'precision.cos.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.978075, 0.982029]});
ref.push({testName: 'precision.cos.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.875629, 0.879536]});
ref.push({testName: 'precision.cos.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.978075, 0.982029, false, 0.978075, 0.982029]});
ref.push({testName: 'precision.cos.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.875629, 0.879536, false, 0.875629, 0.879536]});
ref.push({testName: 'precision.cos.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.978075, 0.982029, false, 0.978075, 0.982029, false, 0.978075, 0.982029]});
ref.push({testName: 'precision.cos.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.875629, 0.879536, false, 0.875629, 0.879536, false, 0.875629, 0.879536]});
ref.push({testName: 'precision.cos.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.978075, 0.982029, false, 0.978075, 0.982029, false, 0.978075, 0.982029, false, 0.978075, 0.982029]});
ref.push({testName: 'precision.cos.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.875629, 0.879536, false, 0.875629, 0.879536, false, 0.875629, 0.879536, false, 0.875629, 0.879536]});
ref.push({testName: 'precision.cos.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.979578, 0.980555]});
ref.push({testName: 'precision.cos.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.877094, 0.878071]});
ref.push({testName: 'precision.cos.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.979578, 0.980555, false, 0.979578, 0.980555]});
ref.push({testName: 'precision.cos.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.877094, 0.878071, false, 0.877094, 0.878071]});
ref.push({testName: 'precision.cos.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.979578, 0.980555, false, 0.979578, 0.980555, false, 0.979578, 0.980555]});
ref.push({testName: 'precision.cos.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.877094, 0.878071, false, 0.877094, 0.878071, false, 0.877094, 0.878071]});
ref.push({testName: 'precision.cos.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.979578, 0.980555, false, 0.979578, 0.980555, false, 0.979578, 0.980555, false, 0.979578, 0.980555]});
ref.push({testName: 'precision.cos.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.877094, 0.878071, false, 0.877094, 0.878071, false, 0.877094, 0.878071, false, 0.877094, 0.878071]});
ref.push({testName: 'precision.cos.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.979578, 0.980555]});
ref.push({testName: 'precision.cos.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.877094, 0.878071]});
ref.push({testName: 'precision.cos.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.979578, 0.980555, false, 0.979578, 0.980555]});
ref.push({testName: 'precision.cos.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.877094, 0.878071, false, 0.877094, 0.878071]});
ref.push({testName: 'precision.cos.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.979578, 0.980555, false, 0.979578, 0.980555, false, 0.979578, 0.980555]});
ref.push({testName: 'precision.cos.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.877094, 0.878071, false, 0.877094, 0.878071, false, 0.877094, 0.878071]});
ref.push({testName: 'precision.cos.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.979578, 0.980555, false, 0.979578, 0.980555, false, 0.979578, 0.980555, false, 0.979578, 0.980555]});
ref.push({testName: 'precision.cos.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.877094, 0.878071, false, 0.877094, 0.878071, false, 0.877094, 0.878071, false, 0.877094, 0.878071]});
ref.push({testName: 'precision.tan.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.tan.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.200684, 0.204834]});
ref.push({testName: 'precision.tan.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.541016, 0.551758]});
ref.push({testName: 'precision.tan.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.200684, 0.204834, false, 0.200684, 0.204834]});
ref.push({testName: 'precision.tan.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.541016, 0.551758, false, 0.541016, 0.551758]});
ref.push({testName: 'precision.tan.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.200684, 0.204834, false, 0.200684, 0.204834, false, 0.200684, 0.204834]});
ref.push({testName: 'precision.tan.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.541016, 0.551758, false, 0.541016, 0.551758, false, 0.541016, 0.551758]});
ref.push({testName: 'precision.tan.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.200684, 0.204834, false, 0.200684, 0.204834, false, 0.200684, 0.204834, false, 0.200684, 0.204834]});
ref.push({testName: 'precision.tan.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.541016, 0.551758, false, 0.541016, 0.551758, false, 0.541016, 0.551758, false, 0.541016, 0.551758]});
ref.push({testName: 'precision.tan.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.200684, 0.204834]});
ref.push({testName: 'precision.tan.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.541016, 0.551758]});
ref.push({testName: 'precision.tan.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.200684, 0.204834, false, 0.200684, 0.204834]});
ref.push({testName: 'precision.tan.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.541016, 0.551758, false, 0.541016, 0.551758]});
ref.push({testName: 'precision.tan.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.200684, 0.204834, false, 0.200684, 0.204834, false, 0.200684, 0.204834]});
ref.push({testName: 'precision.tan.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.541016, 0.551758, false, 0.541016, 0.551758, false, 0.541016, 0.551758]});
ref.push({testName: 'precision.tan.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.200684, 0.204834, false, 0.200684, 0.204834, false, 0.200684, 0.204834, false, 0.200684, 0.204834]});
ref.push({testName: 'precision.tan.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.541016, 0.551758, false, 0.541016, 0.551758, false, 0.541016, 0.551758, false, 0.541016, 0.551758]});
ref.push({testName: 'precision.tan.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.202111, 0.20331]});
ref.push({testName: 'precision.tan.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.545443, 0.547163]});
ref.push({testName: 'precision.tan.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.202111, 0.20331, false, 0.202111, 0.20331]});
ref.push({testName: 'precision.tan.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.545443, 0.547163, false, 0.545443, 0.547163]});
ref.push({testName: 'precision.tan.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.202111, 0.20331, false, 0.202111, 0.20331, false, 0.202111, 0.20331]});
ref.push({testName: 'precision.tan.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.545443, 0.547163, false, 0.545443, 0.547163, false, 0.545443, 0.547163]});
ref.push({testName: 'precision.tan.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.202111, 0.20331, false, 0.202111, 0.20331, false, 0.202111, 0.20331, false, 0.202111, 0.20331]});
ref.push({testName: 'precision.tan.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.545443, 0.547163, false, 0.545443, 0.547163, false, 0.545443, 0.547163, false, 0.545443, 0.547163]});
ref.push({testName: 'precision.tan.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.202111, 0.20331]});
ref.push({testName: 'precision.tan.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.545443, 0.547163]});
ref.push({testName: 'precision.tan.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.202111, 0.20331, false, 0.202111, 0.20331]});
ref.push({testName: 'precision.tan.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.545443, 0.547163, false, 0.545443, 0.547163]});
ref.push({testName: 'precision.tan.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.202111, 0.20331, false, 0.202111, 0.20331, false, 0.202111, 0.20331]});
ref.push({testName: 'precision.tan.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.545443, 0.547163, false, 0.545443, 0.547163, false, 0.545443, 0.547163]});
ref.push({testName: 'precision.tan.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.202111, 0.20331, false, 0.202111, 0.20331, false, 0.202111, 0.20331, false, 0.202111, 0.20331]});
ref.push({testName: 'precision.tan.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.545443, 0.547163, false, 0.545443, 0.547163, false, 0.545443, 0.547163, false, 0.545443, 0.547163]});
ref.push({testName: 'precision.asin.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.180951, 0.220173]});
ref.push({testName: 'precision.asin.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.507974, 0.539224]});
ref.push({testName: 'precision.asin.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.180951, 0.220173, false, 0.180951, 0.220173]});
ref.push({testName: 'precision.asin.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.507974, 0.539224, false, 0.507974, 0.539224]});
ref.push({testName: 'precision.asin.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.180951, 0.220173, false, 0.180951, 0.220173, false, 0.180951, 0.220173]});
ref.push({testName: 'precision.asin.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.507974, 0.539224, false, 0.507974, 0.539224, false, 0.507974, 0.539224]});
ref.push({testName: 'precision.asin.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.180951, 0.220173, false, 0.180951, 0.220173, false, 0.180951, 0.220173, false, 0.180951, 0.220173]});
ref.push({testName: 'precision.asin.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.507974, 0.539224, false, 0.507974, 0.539224, false, 0.507974, 0.539224, false, 0.507974, 0.539224]});
ref.push({testName: 'precision.asin.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.180951, 0.220173]});
ref.push({testName: 'precision.asin.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.507974, 0.539224]});
ref.push({testName: 'precision.asin.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.180951, 0.220173, false, 0.180951, 0.220173]});
ref.push({testName: 'precision.asin.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.507974, 0.539224, false, 0.507974, 0.539224]});
ref.push({testName: 'precision.asin.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.180951, 0.220173, false, 0.180951, 0.220173, false, 0.180951, 0.220173]});
ref.push({testName: 'precision.asin.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.507974, 0.539224, false, 0.507974, 0.539224, false, 0.507974, 0.539224]});
ref.push({testName: 'precision.asin.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.180951, 0.220173, false, 0.180951, 0.220173, false, 0.180951, 0.220173, false, 0.180951, 0.220173]});
ref.push({testName: 'precision.asin.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.507974, 0.539224, false, 0.507974, 0.539224, false, 0.507974, 0.539224, false, 0.507974, 0.539224]});
ref.push({testName: 'precision.asin.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.20082, 0.202046]});
ref.push({testName: 'precision.asin.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.521646, 0.525552]});
ref.push({testName: 'precision.asin.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.20082, 0.202046, false, 0.20082, 0.202046]});
ref.push({testName: 'precision.asin.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.521646, 0.525552, false, 0.521646, 0.525552]});
ref.push({testName: 'precision.asin.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.20082, 0.202046, false, 0.20082, 0.202046, false, 0.20082, 0.202046]});
ref.push({testName: 'precision.asin.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.521646, 0.525552, false, 0.521646, 0.525552, false, 0.521646, 0.525552]});
ref.push({testName: 'precision.asin.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.20082, 0.202046, false, 0.20082, 0.202046, false, 0.20082, 0.202046, false, 0.20082, 0.202046]});
ref.push({testName: 'precision.asin.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.521646, 0.525552, false, 0.521646, 0.525552, false, 0.521646, 0.525552, false, 0.521646, 0.525552]});
ref.push({testName: 'precision.asin.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.20082, 0.202046]});
ref.push({testName: 'precision.asin.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.521646, 0.525552]});
ref.push({testName: 'precision.asin.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.20082, 0.202046, false, 0.20082, 0.202046]});
ref.push({testName: 'precision.asin.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.521646, 0.525552, false, 0.521646, 0.525552]});
ref.push({testName: 'precision.asin.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.20082, 0.202046, false, 0.20082, 0.202046, false, 0.20082, 0.202046]});
ref.push({testName: 'precision.asin.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.521646, 0.525552, false, 0.521646, 0.525552, false, 0.521646, 0.525552]});
ref.push({testName: 'precision.asin.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.20082, 0.202046, false, 0.20082, 0.202046, false, 0.20082, 0.202046, false, 0.20082, 0.202046]});
ref.push({testName: 'precision.asin.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.521646, 0.525552, false, 0.521646, 0.525552, false, 0.521646, 0.525552, false, 0.521646, 0.525552]});
ref.push({testName: 'precision.asin.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.201358, 0.201358]});
ref.push({testName: 'precision.asin.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.523599, 0.523599]});
ref.push({testName: 'precision.asin.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.201358, 0.201358, false, 0.201358, 0.201358]});
ref.push({testName: 'precision.asin.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.523599, 0.523599, false, 0.523599, 0.523599]});
ref.push({testName: 'precision.asin.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.201358, 0.201358, false, 0.201358, 0.201358, false, 0.201358, 0.201358]});
ref.push({testName: 'precision.asin.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.523599, 0.523599, false, 0.523599, 0.523599, false, 0.523599, 0.523599]});
ref.push({testName: 'precision.asin.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.201358, 0.201358, false, 0.201358, 0.201358, false, 0.201358, 0.201358, false, 0.201358, 0.201358]});
ref.push({testName: 'precision.asin.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.523599, 0.523599, false, 0.523599, 0.523599, false, 0.523599, 0.523599, false, 0.523599, 0.523599]});
ref.push({testName: 'precision.asin.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.201358, 0.201358]});
ref.push({testName: 'precision.asin.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.523599, 0.523599]});
ref.push({testName: 'precision.asin.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.201358, 0.201358, false, 0.201358, 0.201358]});
ref.push({testName: 'precision.asin.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.523599, 0.523599, false, 0.523599, 0.523599]});
ref.push({testName: 'precision.asin.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.201358, 0.201358, false, 0.201358, 0.201358, false, 0.201358, 0.201358]});
ref.push({testName: 'precision.asin.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.523599, 0.523599, false, 0.523599, 0.523599, false, 0.523599, 0.523599]});
ref.push({testName: 'precision.asin.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.201358, 0.201358, false, 0.201358, 0.201358, false, 0.201358, 0.201358, false, 0.201358, 0.201358]});
ref.push({testName: 'precision.asin.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.523599, 0.523599, false, 0.523599, 0.523599, false, 0.523599, 0.523599, false, 0.523599, 0.523599]});
ref.push({testName: 'precision.acos.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1.35062, 1.38985]});
ref.push({testName: 'precision.acos.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.03157, 1.06282]});
ref.push({testName: 'precision.acos.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.35062, 1.38985, false, 1.35062, 1.38985]});
ref.push({testName: 'precision.acos.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.03157, 1.06282, false, 1.03157, 1.06282]});
ref.push({testName: 'precision.acos.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.35062, 1.38985, false, 1.35062, 1.38985, false, 1.35062, 1.38985]});
ref.push({testName: 'precision.acos.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.03157, 1.06282, false, 1.03157, 1.06282, false, 1.03157, 1.06282]});
ref.push({testName: 'precision.acos.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.35062, 1.38985, false, 1.35062, 1.38985, false, 1.35062, 1.38985, false, 1.35062, 1.38985]});
ref.push({testName: 'precision.acos.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.03157, 1.06282, false, 1.03157, 1.06282, false, 1.03157, 1.06282, false, 1.03157, 1.06282]});
ref.push({testName: 'precision.acos.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1.35062, 1.38985]});
ref.push({testName: 'precision.acos.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.03157, 1.06282]});
ref.push({testName: 'precision.acos.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.35062, 1.38985, false, 1.35062, 1.38985]});
ref.push({testName: 'precision.acos.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.03157, 1.06282, false, 1.03157, 1.06282]});
ref.push({testName: 'precision.acos.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.35062, 1.38985, false, 1.35062, 1.38985, false, 1.35062, 1.38985]});
ref.push({testName: 'precision.acos.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.03157, 1.06282, false, 1.03157, 1.06282, false, 1.03157, 1.06282]});
ref.push({testName: 'precision.acos.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.35062, 1.38985, false, 1.35062, 1.38985, false, 1.35062, 1.38985, false, 1.35062, 1.38985]});
ref.push({testName: 'precision.acos.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.03157, 1.06282, false, 1.03157, 1.06282, false, 1.03157, 1.06282, false, 1.03157, 1.06282]});
ref.push({testName: 'precision.acos.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1.36533, 1.37339]});
ref.push({testName: 'precision.acos.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.04329, 1.0511]});
ref.push({testName: 'precision.acos.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.36533, 1.37339, false, 1.36533, 1.37339]});
ref.push({testName: 'precision.acos.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.04329, 1.0511, false, 1.04329, 1.0511]});
ref.push({testName: 'precision.acos.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.36533, 1.37339, false, 1.36533, 1.37339, false, 1.36533, 1.37339]});
ref.push({testName: 'precision.acos.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.04329, 1.0511, false, 1.04329, 1.0511, false, 1.04329, 1.0511]});
ref.push({testName: 'precision.acos.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.36533, 1.37339, false, 1.36533, 1.37339, false, 1.36533, 1.37339, false, 1.36533, 1.37339]});
ref.push({testName: 'precision.acos.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.04329, 1.0511, false, 1.04329, 1.0511, false, 1.04329, 1.0511, false, 1.04329, 1.0511]});
ref.push({testName: 'precision.acos.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1.36533, 1.37339]});
ref.push({testName: 'precision.acos.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.04329, 1.0511]});
ref.push({testName: 'precision.acos.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.36533, 1.37339, false, 1.36533, 1.37339]});
ref.push({testName: 'precision.acos.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.04329, 1.0511, false, 1.04329, 1.0511]});
ref.push({testName: 'precision.acos.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.36533, 1.37339, false, 1.36533, 1.37339, false, 1.36533, 1.37339]});
ref.push({testName: 'precision.acos.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.04329, 1.0511, false, 1.04329, 1.0511, false, 1.04329, 1.0511]});
ref.push({testName: 'precision.acos.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.36533, 1.37339, false, 1.36533, 1.37339, false, 1.36533, 1.37339, false, 1.36533, 1.37339]});
ref.push({testName: 'precision.acos.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.04329, 1.0511, false, 1.04329, 1.0511, false, 1.04329, 1.0511, false, 1.04329, 1.0511]});
ref.push({testName: 'precision.acos.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1.36944, 1.36944]});
ref.push({testName: 'precision.acos.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.0472, 1.0472]});
ref.push({testName: 'precision.acos.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.36944, 1.36944, false, 1.36944, 1.36944]});
ref.push({testName: 'precision.acos.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.0472, 1.0472, false, 1.0472, 1.0472]});
ref.push({testName: 'precision.acos.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.36944, 1.36944, false, 1.36944, 1.36944, false, 1.36944, 1.36944]});
ref.push({testName: 'precision.acos.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.0472, 1.0472, false, 1.0472, 1.0472, false, 1.0472, 1.0472]});
ref.push({testName: 'precision.acos.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.36944, 1.36944, false, 1.36944, 1.36944, false, 1.36944, 1.36944, false, 1.36944, 1.36944]});
ref.push({testName: 'precision.acos.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.0472, 1.0472, false, 1.0472, 1.0472, false, 1.0472, 1.0472, false, 1.0472, 1.0472]});
ref.push({testName: 'precision.acos.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1.36944, 1.36944]});
ref.push({testName: 'precision.acos.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.0472, 1.0472]});
ref.push({testName: 'precision.acos.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.36944, 1.36944, false, 1.36944, 1.36944]});
ref.push({testName: 'precision.acos.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.0472, 1.0472, false, 1.0472, 1.0472]});
ref.push({testName: 'precision.acos.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.36944, 1.36944, false, 1.36944, 1.36944, false, 1.36944, 1.36944]});
ref.push({testName: 'precision.acos.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.0472, 1.0472, false, 1.0472, 1.0472, false, 1.0472, 1.0472]});
ref.push({testName: 'precision.acos.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.36944, 1.36944, false, 1.36944, 1.36944, false, 1.36944, 1.36944, false, 1.36944, 1.36944]});
ref.push({testName: 'precision.acos.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.0472, 1.0472, false, 1.0472, 1.0472, false, 1.0472, 1.0472, false, 1.0472, 1.0472]});
ref.push({testName: 'precision.atan2.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.750168, 0.820628]});
ref.push({testName: 'precision.atan2.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.356773, 0.401508]});
ref.push({testName: 'precision.atan2.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.750168, 0.820628, false, 0.750168, 0.820628]});
ref.push({testName: 'precision.atan2.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.356773, 0.401508, false, 0.356773, 0.401508]});
ref.push({testName: 'precision.atan2.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.750168, 0.820628, false, 0.750168, 0.820628, false, 0.750168, 0.820628]});
ref.push({testName: 'precision.atan2.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.356773, 0.401508, false, 0.356773, 0.401508, false, 0.356773, 0.401508]});
ref.push({testName: 'precision.atan2.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.750168, 0.820628, false, 0.750168, 0.820628, false, 0.750168, 0.820628, false, 0.750168, 0.820628]});
ref.push({testName: 'precision.atan2.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.356773, 0.401508, false, 0.356773, 0.401508, false, 0.356773, 0.401508, false, 0.356773, 0.401508]});
ref.push({testName: 'precision.atan2.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.750168, 0.820628]});
ref.push({testName: 'precision.atan2.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.356773, 0.401508]});
ref.push({testName: 'precision.atan2.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.750168, 0.820628, false, 0.750168, 0.820628]});
ref.push({testName: 'precision.atan2.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.356773, 0.401508, false, 0.356773, 0.401508]});
ref.push({testName: 'precision.atan2.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.750168, 0.820628, false, 0.750168, 0.820628, false, 0.750168, 0.820628]});
ref.push({testName: 'precision.atan2.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.356773, 0.401508, false, 0.356773, 0.401508, false, 0.356773, 0.401508]});
ref.push({testName: 'precision.atan2.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.750168, 0.820628, false, 0.750168, 0.820628, false, 0.750168, 0.820628, false, 0.750168, 0.820628]});
ref.push({testName: 'precision.atan2.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.356773, 0.401508, false, 0.356773, 0.401508, false, 0.356773, 0.401508, false, 0.356773, 0.401508]});
ref.push({testName: 'precision.atan2.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.782835, 0.787961]});
ref.push({testName: 'precision.atan2.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.379446, 0.38182]});
ref.push({testName: 'precision.atan2.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.782835, 0.787961, false, 0.782835, 0.787961]});
ref.push({testName: 'precision.atan2.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.379446, 0.38182, false, 0.379446, 0.38182]});
ref.push({testName: 'precision.atan2.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.782835, 0.787961, false, 0.782835, 0.787961, false, 0.782835, 0.787961]});
ref.push({testName: 'precision.atan2.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.379446, 0.38182, false, 0.379446, 0.38182, false, 0.379446, 0.38182]});
ref.push({testName: 'precision.atan2.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.782835, 0.787961, false, 0.782835, 0.787961, false, 0.782835, 0.787961, false, 0.782835, 0.787961]});
ref.push({testName: 'precision.atan2.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.379446, 0.38182, false, 0.379446, 0.38182, false, 0.379446, 0.38182, false, 0.379446, 0.38182]});
ref.push({testName: 'precision.atan2.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.782835, 0.787961]});
ref.push({testName: 'precision.atan2.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.379446, 0.38182]});
ref.push({testName: 'precision.atan2.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.782835, 0.787961, false, 0.782835, 0.787961]});
ref.push({testName: 'precision.atan2.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.379446, 0.38182, false, 0.379446, 0.38182]});
ref.push({testName: 'precision.atan2.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.782835, 0.787961, false, 0.782835, 0.787961, false, 0.782835, 0.787961]});
ref.push({testName: 'precision.atan2.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.379446, 0.38182, false, 0.379446, 0.38182, false, 0.379446, 0.38182]});
ref.push({testName: 'precision.atan2.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.782835, 0.787961, false, 0.782835, 0.787961, false, 0.782835, 0.787961, false, 0.782835, 0.787961]});
ref.push({testName: 'precision.atan2.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.379446, 0.38182, false, 0.379446, 0.38182, false, 0.379446, 0.38182, false, 0.379446, 0.38182]});
ref.push({testName: 'precision.atan2.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.785398, 0.785398]});
ref.push({testName: 'precision.atan2.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.380506, 0.380507]});
ref.push({testName: 'precision.atan2.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.785398, 0.785398, false, 0.785398, 0.785398]});
ref.push({testName: 'precision.atan2.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.380506, 0.380507, false, 0.380506, 0.380507]});
ref.push({testName: 'precision.atan2.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.785398, 0.785398, false, 0.785398, 0.785398, false, 0.785398, 0.785398]});
ref.push({testName: 'precision.atan2.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.380506, 0.380507, false, 0.380506, 0.380507, false, 0.380506, 0.380507]});
ref.push({testName: 'precision.atan2.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.785398, 0.785398, false, 0.785398, 0.785398, false, 0.785398, 0.785398, false, 0.785398, 0.785398]});
ref.push({testName: 'precision.atan2.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.380506, 0.380507, false, 0.380506, 0.380507, false, 0.380506, 0.380507, false, 0.380506, 0.380507]});
ref.push({testName: 'precision.atan2.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.785398, 0.785398]});
ref.push({testName: 'precision.atan2.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.380506, 0.380507]});
ref.push({testName: 'precision.atan2.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.785398, 0.785398, false, 0.785398, 0.785398]});
ref.push({testName: 'precision.atan2.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.380506, 0.380507, false, 0.380506, 0.380507]});
ref.push({testName: 'precision.atan2.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.785398, 0.785398, false, 0.785398, 0.785398, false, 0.785398, 0.785398]});
ref.push({testName: 'precision.atan2.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.380506, 0.380507, false, 0.380506, 0.380507, false, 0.380506, 0.380507]});
ref.push({testName: 'precision.atan2.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.785398, 0.785398, false, 0.785398, 0.785398, false, 0.785398, 0.785398, false, 0.785398, 0.785398]});
ref.push({testName: 'precision.atan2.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.380506, 0.380507, false, 0.380506, 0.380507, false, 0.380506, 0.380507, false, 0.380506, 0.380507]});
ref.push({testName: 'precision.atan.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.177259, 0.216024]});
ref.push({testName: 'precision.atan.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.448023, 0.479273]});
ref.push({testName: 'precision.atan.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.177259, 0.216024, false, 0.177259, 0.216024]});
ref.push({testName: 'precision.atan.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.448023, 0.479273, false, 0.448023, 0.479273]});
ref.push({testName: 'precision.atan.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.177259, 0.216024, false, 0.177259, 0.216024, false, 0.177259, 0.216024]});
ref.push({testName: 'precision.atan.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.448023, 0.479273, false, 0.448023, 0.479273, false, 0.448023, 0.479273]});
ref.push({testName: 'precision.atan.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.177259, 0.216024, false, 0.177259, 0.216024, false, 0.177259, 0.216024, false, 0.177259, 0.216024]});
ref.push({testName: 'precision.atan.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.448023, 0.479273, false, 0.448023, 0.479273, false, 0.448023, 0.479273, false, 0.448023, 0.479273]});
ref.push({testName: 'precision.atan.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.177259, 0.216024]});
ref.push({testName: 'precision.atan.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.448023, 0.479273]});
ref.push({testName: 'precision.atan.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.177259, 0.216024, false, 0.177259, 0.216024]});
ref.push({testName: 'precision.atan.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.448023, 0.479273, false, 0.448023, 0.479273]});
ref.push({testName: 'precision.atan.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.177259, 0.216024, false, 0.177259, 0.216024, false, 0.177259, 0.216024]});
ref.push({testName: 'precision.atan.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.448023, 0.479273, false, 0.448023, 0.479273, false, 0.448023, 0.479273]});
ref.push({testName: 'precision.atan.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.177259, 0.216024, false, 0.177259, 0.216024, false, 0.177259, 0.216024, false, 0.177259, 0.216024]});
ref.push({testName: 'precision.atan.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.448023, 0.479273, false, 0.448023, 0.479273, false, 0.448023, 0.479273, false, 0.448023, 0.479273]});
ref.push({testName: 'precision.atan.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.19686, 0.198072]});
ref.push({testName: 'precision.atan.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.462671, 0.464624]});
ref.push({testName: 'precision.atan.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.19686, 0.198072, false, 0.19686, 0.198072]});
ref.push({testName: 'precision.atan.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.462671, 0.464624, false, 0.462671, 0.464624]});
ref.push({testName: 'precision.atan.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.19686, 0.198072, false, 0.19686, 0.198072, false, 0.19686, 0.198072]});
ref.push({testName: 'precision.atan.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.462671, 0.464624, false, 0.462671, 0.464624, false, 0.462671, 0.464624]});
ref.push({testName: 'precision.atan.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.19686, 0.198072, false, 0.19686, 0.198072, false, 0.19686, 0.198072, false, 0.19686, 0.198072]});
ref.push({testName: 'precision.atan.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.462671, 0.464624, false, 0.462671, 0.464624, false, 0.462671, 0.464624, false, 0.462671, 0.464624]});
ref.push({testName: 'precision.atan.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.19686, 0.198072]});
ref.push({testName: 'precision.atan.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.462671, 0.464624]});
ref.push({testName: 'precision.atan.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.19686, 0.198072, false, 0.19686, 0.198072]});
ref.push({testName: 'precision.atan.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.462671, 0.464624, false, 0.462671, 0.464624]});
ref.push({testName: 'precision.atan.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.19686, 0.198072, false, 0.19686, 0.198072, false, 0.19686, 0.198072]});
ref.push({testName: 'precision.atan.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.462671, 0.464624, false, 0.462671, 0.464624, false, 0.462671, 0.464624]});
ref.push({testName: 'precision.atan.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.19686, 0.198072, false, 0.19686, 0.198072, false, 0.19686, 0.198072, false, 0.19686, 0.198072]});
ref.push({testName: 'precision.atan.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.462671, 0.464624, false, 0.462671, 0.464624, false, 0.462671, 0.464624, false, 0.462671, 0.464624]});
ref.push({testName: 'precision.atan.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.197395, 0.197396]});
ref.push({testName: 'precision.atan.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.463647, 0.463648]});
ref.push({testName: 'precision.atan.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.197395, 0.197396, false, 0.197395, 0.197396]});
ref.push({testName: 'precision.atan.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.463647, 0.463648, false, 0.463647, 0.463648]});
ref.push({testName: 'precision.atan.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.197395, 0.197396, false, 0.197395, 0.197396, false, 0.197395, 0.197396]});
ref.push({testName: 'precision.atan.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.463647, 0.463648, false, 0.463647, 0.463648, false, 0.463647, 0.463648]});
ref.push({testName: 'precision.atan.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.197395, 0.197396, false, 0.197395, 0.197396, false, 0.197395, 0.197396, false, 0.197395, 0.197396]});
ref.push({testName: 'precision.atan.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.463647, 0.463648, false, 0.463647, 0.463648, false, 0.463647, 0.463648, false, 0.463647, 0.463648]});
ref.push({testName: 'precision.atan.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.197395, 0.197396]});
ref.push({testName: 'precision.atan.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.463647, 0.463648]});
ref.push({testName: 'precision.atan.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.197395, 0.197396, false, 0.197395, 0.197396]});
ref.push({testName: 'precision.atan.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.463647, 0.463648, false, 0.463647, 0.463648]});
ref.push({testName: 'precision.atan.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.197395, 0.197396, false, 0.197395, 0.197396, false, 0.197395, 0.197396]});
ref.push({testName: 'precision.atan.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.463647, 0.463648, false, 0.463647, 0.463648, false, 0.463647, 0.463648]});
ref.push({testName: 'precision.atan.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.197395, 0.197396, false, 0.197395, 0.197396, false, 0.197395, 0.197396, false, 0.197395, 0.197396]});
ref.push({testName: 'precision.atan.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.463647, 0.463648, false, 0.463647, 0.463648, false, 0.463647, 0.463648, false, 0.463647, 0.463648]});
ref.push({testName: 'precision.sinh.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sinh.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.197144, 0.205688]});
ref.push({testName: 'precision.sinh.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.51416, 0.528809]});
ref.push({testName: 'precision.sinh.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.197144, 0.205688, false, 0.197144, 0.205688]});
ref.push({testName: 'precision.sinh.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.51416, 0.528809, false, 0.51416, 0.528809]});
ref.push({testName: 'precision.sinh.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.197144, 0.205688, false, 0.197144, 0.205688, false, 0.197144, 0.205688]});
ref.push({testName: 'precision.sinh.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.51416, 0.528809, false, 0.51416, 0.528809, false, 0.51416, 0.528809]});
ref.push({testName: 'precision.sinh.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.197144, 0.205688, false, 0.197144, 0.205688, false, 0.197144, 0.205688, false, 0.197144, 0.205688]});
ref.push({testName: 'precision.sinh.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.51416, 0.528809, false, 0.51416, 0.528809, false, 0.51416, 0.528809, false, 0.51416, 0.528809]});
ref.push({testName: 'precision.sinh.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.197144, 0.205688]});
ref.push({testName: 'precision.sinh.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.51416, 0.528809]});
ref.push({testName: 'precision.sinh.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.197144, 0.205688, false, 0.197144, 0.205688]});
ref.push({testName: 'precision.sinh.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.51416, 0.528809, false, 0.51416, 0.528809]});
ref.push({testName: 'precision.sinh.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.197144, 0.205688, false, 0.197144, 0.205688, false, 0.197144, 0.205688]});
ref.push({testName: 'precision.sinh.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.51416, 0.528809, false, 0.51416, 0.528809, false, 0.51416, 0.528809]});
ref.push({testName: 'precision.sinh.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.197144, 0.205688, false, 0.197144, 0.205688, false, 0.197144, 0.205688, false, 0.197144, 0.205688]});
ref.push({testName: 'precision.sinh.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.51416, 0.528809, false, 0.51416, 0.528809, false, 0.51416, 0.528809, false, 0.51416, 0.528809]});
ref.push({testName: 'precision.sinh.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.201336, 0.201336]});
ref.push({testName: 'precision.sinh.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.521095, 0.521096]});
ref.push({testName: 'precision.sinh.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.201336, 0.201336, false, 0.201336, 0.201336]});
ref.push({testName: 'precision.sinh.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.521095, 0.521096, false, 0.521095, 0.521096]});
ref.push({testName: 'precision.sinh.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.201336, 0.201336, false, 0.201336, 0.201336, false, 0.201336, 0.201336]});
ref.push({testName: 'precision.sinh.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.521095, 0.521096, false, 0.521095, 0.521096, false, 0.521095, 0.521096]});
ref.push({testName: 'precision.sinh.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.201336, 0.201336, false, 0.201336, 0.201336, false, 0.201336, 0.201336, false, 0.201336, 0.201336]});
ref.push({testName: 'precision.sinh.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.521095, 0.521096, false, 0.521095, 0.521096, false, 0.521095, 0.521096, false, 0.521095, 0.521096]});
ref.push({testName: 'precision.sinh.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.201336, 0.201336]});
ref.push({testName: 'precision.sinh.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.521095, 0.521096]});
ref.push({testName: 'precision.sinh.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.201336, 0.201336, false, 0.201336, 0.201336]});
ref.push({testName: 'precision.sinh.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.521095, 0.521096, false, 0.521095, 0.521096]});
ref.push({testName: 'precision.sinh.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.201336, 0.201336, false, 0.201336, 0.201336, false, 0.201336, 0.201336]});
ref.push({testName: 'precision.sinh.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.521095, 0.521096, false, 0.521095, 0.521096, false, 0.521095, 0.521096]});
ref.push({testName: 'precision.sinh.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.201336, 0.201336, false, 0.201336, 0.201336, false, 0.201336, 0.201336, false, 0.201336, 0.201336]});
ref.push({testName: 'precision.sinh.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.521095, 0.521096, false, 0.521095, 0.521096, false, 0.521095, 0.521096, false, 0.521095, 0.521096]});
ref.push({testName: 'precision.cosh.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.cosh.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1.01074, 1.03027]});
ref.push({testName: 'precision.cosh.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.11816, 1.1377]});
ref.push({testName: 'precision.cosh.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.01074, 1.03027, false, 1.01074, 1.03027]});
ref.push({testName: 'precision.cosh.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.11816, 1.1377, false, 1.11816, 1.1377]});
ref.push({testName: 'precision.cosh.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.01074, 1.03027, false, 1.01074, 1.03027, false, 1.01074, 1.03027]});
ref.push({testName: 'precision.cosh.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.11816, 1.1377, false, 1.11816, 1.1377, false, 1.11816, 1.1377]});
ref.push({testName: 'precision.cosh.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.01074, 1.03027, false, 1.01074, 1.03027, false, 1.01074, 1.03027, false, 1.01074, 1.03027]});
ref.push({testName: 'precision.cosh.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.11816, 1.1377, false, 1.11816, 1.1377, false, 1.11816, 1.1377, false, 1.11816, 1.1377]});
ref.push({testName: 'precision.cosh.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1.01074, 1.03027]});
ref.push({testName: 'precision.cosh.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.11816, 1.1377]});
ref.push({testName: 'precision.cosh.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.01074, 1.03027, false, 1.01074, 1.03027]});
ref.push({testName: 'precision.cosh.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.11816, 1.1377, false, 1.11816, 1.1377]});
ref.push({testName: 'precision.cosh.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.01074, 1.03027, false, 1.01074, 1.03027, false, 1.01074, 1.03027]});
ref.push({testName: 'precision.cosh.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.11816, 1.1377, false, 1.11816, 1.1377, false, 1.11816, 1.1377]});
ref.push({testName: 'precision.cosh.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.01074, 1.03027, false, 1.01074, 1.03027, false, 1.01074, 1.03027, false, 1.01074, 1.03027]});
ref.push({testName: 'precision.cosh.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.11816, 1.1377, false, 1.11816, 1.1377, false, 1.11816, 1.1377, false, 1.11816, 1.1377]});
ref.push({testName: 'precision.cosh.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1.02007, 1.02007]});
ref.push({testName: 'precision.cosh.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.12763, 1.12763]});
ref.push({testName: 'precision.cosh.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.02007, 1.02007, false, 1.02007, 1.02007]});
ref.push({testName: 'precision.cosh.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.12763, 1.12763, false, 1.12763, 1.12763]});
ref.push({testName: 'precision.cosh.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.02007, 1.02007, false, 1.02007, 1.02007, false, 1.02007, 1.02007]});
ref.push({testName: 'precision.cosh.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.12763, 1.12763, false, 1.12763, 1.12763, false, 1.12763, 1.12763]});
ref.push({testName: 'precision.cosh.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.02007, 1.02007, false, 1.02007, 1.02007, false, 1.02007, 1.02007, false, 1.02007, 1.02007]});
ref.push({testName: 'precision.cosh.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.12763, 1.12763, false, 1.12763, 1.12763, false, 1.12763, 1.12763, false, 1.12763, 1.12763]});
ref.push({testName: 'precision.cosh.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1.02007, 1.02007]});
ref.push({testName: 'precision.cosh.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.12763, 1.12763]});
ref.push({testName: 'precision.cosh.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.02007, 1.02007, false, 1.02007, 1.02007]});
ref.push({testName: 'precision.cosh.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.12763, 1.12763, false, 1.12763, 1.12763]});
ref.push({testName: 'precision.cosh.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.02007, 1.02007, false, 1.02007, 1.02007, false, 1.02007, 1.02007]});
ref.push({testName: 'precision.cosh.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.12763, 1.12763, false, 1.12763, 1.12763, false, 1.12763, 1.12763]});
ref.push({testName: 'precision.cosh.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.02007, 1.02007, false, 1.02007, 1.02007, false, 1.02007, 1.02007, false, 1.02007, 1.02007]});
ref.push({testName: 'precision.cosh.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.12763, 1.12763, false, 1.12763, 1.12763, false, 1.12763, 1.12763, false, 1.12763, 1.12763]});
ref.push({testName: 'precision.tanh.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.tanh.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.19074, 0.204113]});
ref.push({testName: 'precision.tanh.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.450711, 0.474146]});
ref.push({testName: 'precision.tanh.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.19074, 0.204113, false, 0.19074, 0.204113]});
ref.push({testName: 'precision.tanh.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.450711, 0.474146, false, 0.450711, 0.474146]});
ref.push({testName: 'precision.tanh.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.19074, 0.204113, false, 0.19074, 0.204113, false, 0.19074, 0.204113]});
ref.push({testName: 'precision.tanh.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.450711, 0.474146, false, 0.450711, 0.474146, false, 0.450711, 0.474146]});
ref.push({testName: 'precision.tanh.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.19074, 0.204113, false, 0.19074, 0.204113, false, 0.19074, 0.204113, false, 0.19074, 0.204113]});
ref.push({testName: 'precision.tanh.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.450711, 0.474146, false, 0.450711, 0.474146, false, 0.450711, 0.474146, false, 0.450711, 0.474146]});
ref.push({testName: 'precision.tanh.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.19074, 0.204113]});
ref.push({testName: 'precision.tanh.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.450711, 0.474146]});
ref.push({testName: 'precision.tanh.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.19074, 0.204113, false, 0.19074, 0.204113]});
ref.push({testName: 'precision.tanh.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.450711, 0.474146, false, 0.450711, 0.474146]});
ref.push({testName: 'precision.tanh.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.19074, 0.204113, false, 0.19074, 0.204113, false, 0.19074, 0.204113]});
ref.push({testName: 'precision.tanh.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.450711, 0.474146, false, 0.450711, 0.474146, false, 0.450711, 0.474146]});
ref.push({testName: 'precision.tanh.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.19074, 0.204113, false, 0.19074, 0.204113, false, 0.19074, 0.204113, false, 0.19074, 0.204113]});
ref.push({testName: 'precision.tanh.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.450711, 0.474146, false, 0.450711, 0.474146, false, 0.450711, 0.474146, false, 0.450711, 0.474146]});
ref.push({testName: 'precision.tanh.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.197375, 0.197376]});
ref.push({testName: 'precision.tanh.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.462116, 0.462118]});
ref.push({testName: 'precision.tanh.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.197375, 0.197376, false, 0.197375, 0.197376]});
ref.push({testName: 'precision.tanh.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.462116, 0.462118, false, 0.462116, 0.462118]});
ref.push({testName: 'precision.tanh.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.197375, 0.197376, false, 0.197375, 0.197376, false, 0.197375, 0.197376]});
ref.push({testName: 'precision.tanh.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.462116, 0.462118, false, 0.462116, 0.462118, false, 0.462116, 0.462118]});
ref.push({testName: 'precision.tanh.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.197375, 0.197376, false, 0.197375, 0.197376, false, 0.197375, 0.197376, false, 0.197375, 0.197376]});
ref.push({testName: 'precision.tanh.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.462116, 0.462118, false, 0.462116, 0.462118, false, 0.462116, 0.462118, false, 0.462116, 0.462118]});
ref.push({testName: 'precision.tanh.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.197375, 0.197376]});
ref.push({testName: 'precision.tanh.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.462116, 0.462118]});
ref.push({testName: 'precision.tanh.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.197375, 0.197376, false, 0.197375, 0.197376]});
ref.push({testName: 'precision.tanh.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.462116, 0.462118, false, 0.462116, 0.462118]});
ref.push({testName: 'precision.tanh.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.197375, 0.197376, false, 0.197375, 0.197376, false, 0.197375, 0.197376]});
ref.push({testName: 'precision.tanh.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.462116, 0.462118, false, 0.462116, 0.462118, false, 0.462116, 0.462118]});
ref.push({testName: 'precision.tanh.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.197375, 0.197376, false, 0.197375, 0.197376, false, 0.197375, 0.197376, false, 0.197375, 0.197376]});
ref.push({testName: 'precision.tanh.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.462116, 0.462118, false, 0.462116, 0.462118, false, 0.462116, 0.462118, false, 0.462116, 0.462118]});
ref.push({testName: 'precision.asinh.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.asinh.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.183582, 0.213619]});
ref.push({testName: 'precision.asinh.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.468033, 0.494521]});
ref.push({testName: 'precision.asinh.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.183582, 0.213619, false, 0.183582, 0.213619]});
ref.push({testName: 'precision.asinh.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.468033, 0.494521, false, 0.468033, 0.494521]});
ref.push({testName: 'precision.asinh.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.183582, 0.213619, false, 0.183582, 0.213619, false, 0.183582, 0.213619]});
ref.push({testName: 'precision.asinh.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.468033, 0.494521, false, 0.468033, 0.494521, false, 0.468033, 0.494521]});
ref.push({testName: 'precision.asinh.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.183582, 0.213619, false, 0.183582, 0.213619, false, 0.183582, 0.213619, false, 0.183582, 0.213619]});
ref.push({testName: 'precision.asinh.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.468033, 0.494521, false, 0.468033, 0.494521, false, 0.468033, 0.494521, false, 0.468033, 0.494521]});
ref.push({testName: 'precision.asinh.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.183582, 0.213619]});
ref.push({testName: 'precision.asinh.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.468033, 0.494521]});
ref.push({testName: 'precision.asinh.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.183582, 0.213619, false, 0.183582, 0.213619]});
ref.push({testName: 'precision.asinh.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.468033, 0.494521, false, 0.468033, 0.494521]});
ref.push({testName: 'precision.asinh.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.183582, 0.213619, false, 0.183582, 0.213619, false, 0.183582, 0.213619]});
ref.push({testName: 'precision.asinh.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.468033, 0.494521, false, 0.468033, 0.494521, false, 0.468033, 0.494521]});
ref.push({testName: 'precision.asinh.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.183582, 0.213619, false, 0.183582, 0.213619, false, 0.183582, 0.213619, false, 0.183582, 0.213619]});
ref.push({testName: 'precision.asinh.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.468033, 0.494521, false, 0.468033, 0.494521, false, 0.468033, 0.494521, false, 0.468033, 0.494521]});
ref.push({testName: 'precision.asinh.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.198689, 0.198691]});
ref.push({testName: 'precision.asinh.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.481211, 0.481213]});
ref.push({testName: 'precision.asinh.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.198689, 0.198691, false, 0.198689, 0.198691]});
ref.push({testName: 'precision.asinh.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.481211, 0.481213, false, 0.481211, 0.481213]});
ref.push({testName: 'precision.asinh.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.198689, 0.198691, false, 0.198689, 0.198691, false, 0.198689, 0.198691]});
ref.push({testName: 'precision.asinh.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.481211, 0.481213, false, 0.481211, 0.481213, false, 0.481211, 0.481213]});
ref.push({testName: 'precision.asinh.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.198689, 0.198691, false, 0.198689, 0.198691, false, 0.198689, 0.198691, false, 0.198689, 0.198691]});
ref.push({testName: 'precision.asinh.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.481211, 0.481213, false, 0.481211, 0.481213, false, 0.481211, 0.481213, false, 0.481211, 0.481213]});
ref.push({testName: 'precision.asinh.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.198689, 0.198691]});
ref.push({testName: 'precision.asinh.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.481211, 0.481213]});
ref.push({testName: 'precision.asinh.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.198689, 0.198691, false, 0.198689, 0.198691]});
ref.push({testName: 'precision.asinh.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.481211, 0.481213, false, 0.481211, 0.481213]});
ref.push({testName: 'precision.asinh.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.198689, 0.198691, false, 0.198689, 0.198691, false, 0.198689, 0.198691]});
ref.push({testName: 'precision.asinh.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.481211, 0.481213, false, 0.481211, 0.481213, false, 0.481211, 0.481213]});
ref.push({testName: 'precision.asinh.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.198689, 0.198691, false, 0.198689, 0.198691, false, 0.198689, 0.198691, false, 0.198689, 0.198691]});
ref.push({testName: 'precision.asinh.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.481211, 0.481213, false, 0.481211, 0.481213, false, 0.481211, 0.481213, false, 0.481211, 0.481213]});
ref.push({testName: 'precision.acosh.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.acosh.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.atanh.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.196289, 0.208984]});
ref.push({testName: 'precision.atanh.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.544922, 0.553711]});
ref.push({testName: 'precision.atanh.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.196289, 0.208984, false, 0.196289, 0.208984]});
ref.push({testName: 'precision.atanh.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.544922, 0.553711, false, 0.544922, 0.553711]});
ref.push({testName: 'precision.atanh.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.196289, 0.208984, false, 0.196289, 0.208984, false, 0.196289, 0.208984]});
ref.push({testName: 'precision.atanh.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.544922, 0.553711, false, 0.544922, 0.553711, false, 0.544922, 0.553711]});
ref.push({testName: 'precision.atanh.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.196289, 0.208984, false, 0.196289, 0.208984, false, 0.196289, 0.208984, false, 0.196289, 0.208984]});
ref.push({testName: 'precision.atanh.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.544922, 0.553711, false, 0.544922, 0.553711, false, 0.544922, 0.553711, false, 0.544922, 0.553711]});
ref.push({testName: 'precision.atanh.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.196289, 0.208984]});
ref.push({testName: 'precision.atanh.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.544922, 0.553711]});
ref.push({testName: 'precision.atanh.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.196289, 0.208984, false, 0.196289, 0.208984]});
ref.push({testName: 'precision.atanh.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.544922, 0.553711, false, 0.544922, 0.553711]});
ref.push({testName: 'precision.atanh.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.196289, 0.208984, false, 0.196289, 0.208984, false, 0.196289, 0.208984]});
ref.push({testName: 'precision.atanh.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.544922, 0.553711, false, 0.544922, 0.553711, false, 0.544922, 0.553711]});
ref.push({testName: 'precision.atanh.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.196289, 0.208984, false, 0.196289, 0.208984, false, 0.196289, 0.208984, false, 0.196289, 0.208984]});
ref.push({testName: 'precision.atanh.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.544922, 0.553711, false, 0.544922, 0.553711, false, 0.544922, 0.553711, false, 0.544922, 0.553711]});
ref.push({testName: 'precision.atanh.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.202732, 0.202733]});
ref.push({testName: 'precision.atanh.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.549306, 0.549306]});
ref.push({testName: 'precision.atanh.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.202732, 0.202733, false, 0.202732, 0.202733]});
ref.push({testName: 'precision.atanh.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.549306, 0.549306, false, 0.549306, 0.549306]});
ref.push({testName: 'precision.atanh.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.202732, 0.202733, false, 0.202732, 0.202733, false, 0.202732, 0.202733]});
ref.push({testName: 'precision.atanh.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.549306, 0.549306, false, 0.549306, 0.549306, false, 0.549306, 0.549306]});
ref.push({testName: 'precision.atanh.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.202732, 0.202733, false, 0.202732, 0.202733, false, 0.202732, 0.202733, false, 0.202732, 0.202733]});
ref.push({testName: 'precision.atanh.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.549306, 0.549306, false, 0.549306, 0.549306, false, 0.549306, 0.549306, false, 0.549306, 0.549306]});
ref.push({testName: 'precision.atanh.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.202732, 0.202733]});
ref.push({testName: 'precision.atanh.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.549306, 0.549306]});
ref.push({testName: 'precision.atanh.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.202732, 0.202733, false, 0.202732, 0.202733]});
ref.push({testName: 'precision.atanh.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.549306, 0.549306, false, 0.549306, 0.549306]});
ref.push({testName: 'precision.atanh.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.202732, 0.202733, false, 0.202732, 0.202733, false, 0.202732, 0.202733]});
ref.push({testName: 'precision.atanh.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.549306, 0.549306, false, 0.549306, 0.549306, false, 0.549306, 0.549306]});
ref.push({testName: 'precision.atanh.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.202732, 0.202733, false, 0.202732, 0.202733, false, 0.202732, 0.202733, false, 0.202732, 0.202733]});
ref.push({testName: 'precision.atanh.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.549306, 0.549306, false, 0.549306, 0.549306, false, 0.549306, 0.549306, false, 0.549306, 0.549306]});
ref.push({testName: 'precision.pow.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0, 0.782566]});
ref.push({testName: 'precision.pow.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0, 0.51834]});
ref.push({testName: 'precision.pow.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0, 0.782566, false, 0, 0.782566]});
ref.push({testName: 'precision.pow.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0, 0.51834, false, 0, 0.51834]});
ref.push({testName: 'precision.pow.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0, 0.782566, false, 0, 0.782566, false, 0, 0.782566]});
ref.push({testName: 'precision.pow.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0, 0.51834, false, 0, 0.51834, false, 0, 0.51834]});
ref.push({testName: 'precision.pow.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0, 0.782566, false, 0, 0.782566, false, 0, 0.782566, false, 0, 0.782566]});
ref.push({testName: 'precision.pow.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0, 0.51834, false, 0, 0.51834, false, 0, 0.51834, false, 0, 0.51834]});
ref.push({testName: 'precision.pow.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0, 0.782566]});
ref.push({testName: 'precision.pow.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0, 0.51834]});
ref.push({testName: 'precision.pow.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0, 0.782566, false, 0, 0.782566]});
ref.push({testName: 'precision.pow.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0, 0.51834, false, 0, 0.51834]});
ref.push({testName: 'precision.pow.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0, 0.782566, false, 0, 0.782566, false, 0, 0.782566]});
ref.push({testName: 'precision.pow.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0, 0.51834, false, 0, 0.51834, false, 0, 0.51834]});
ref.push({testName: 'precision.pow.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0, 0.782566, false, 0, 0.782566, false, 0, 0.782566, false, 0, 0.782566]});
ref.push({testName: 'precision.pow.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0, 0.51834, false, 0, 0.51834, false, 0, 0.51834, false, 0, 0.51834]});
ref.push({testName: 'precision.pow.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.720704, 0.728633]});
ref.push({testName: 'precision.pow.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.443535, 0.450783]});
ref.push({testName: 'precision.pow.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.720704, 0.728633, false, 0.720704, 0.728633]});
ref.push({testName: 'precision.pow.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.443535, 0.450783, false, 0.443535, 0.450783]});
ref.push({testName: 'precision.pow.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.720704, 0.728633, false, 0.720704, 0.728633, false, 0.720704, 0.728633]});
ref.push({testName: 'precision.pow.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.443535, 0.450783, false, 0.443535, 0.450783, false, 0.443535, 0.450783]});
ref.push({testName: 'precision.pow.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.720704, 0.728633, false, 0.720704, 0.728633, false, 0.720704, 0.728633, false, 0.720704, 0.728633]});
ref.push({testName: 'precision.pow.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.443535, 0.450783, false, 0.443535, 0.450783, false, 0.443535, 0.450783, false, 0.443535, 0.450783]});
ref.push({testName: 'precision.pow.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.720704, 0.728633]});
ref.push({testName: 'precision.pow.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.443535, 0.450783]});
ref.push({testName: 'precision.pow.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.720704, 0.728633, false, 0.720704, 0.728633]});
ref.push({testName: 'precision.pow.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.443535, 0.450783, false, 0.443535, 0.450783]});
ref.push({testName: 'precision.pow.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.720704, 0.728633, false, 0.720704, 0.728633, false, 0.720704, 0.728633]});
ref.push({testName: 'precision.pow.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.443535, 0.450783, false, 0.443535, 0.450783, false, 0.443535, 0.450783]});
ref.push({testName: 'precision.pow.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.720704, 0.728633, false, 0.720704, 0.728633, false, 0.720704, 0.728633, false, 0.720704, 0.728633]});
ref.push({testName: 'precision.pow.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.443535, 0.450783, false, 0.443535, 0.450783, false, 0.443535, 0.450783, false, 0.443535, 0.450783]});
ref.push({testName: 'precision.pow.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.724779, 0.72478]});
ref.push({testName: 'precision.pow.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.447213, 0.447214]});
ref.push({testName: 'precision.pow.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.724779, 0.72478, false, 0.724779, 0.72478]});
ref.push({testName: 'precision.pow.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.447213, 0.447214, false, 0.447213, 0.447214]});
ref.push({testName: 'precision.pow.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.724779, 0.72478, false, 0.724779, 0.72478, false, 0.724779, 0.72478]});
ref.push({testName: 'precision.pow.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.447213, 0.447214, false, 0.447213, 0.447214, false, 0.447213, 0.447214]});
ref.push({testName: 'precision.pow.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.724779, 0.72478, false, 0.724779, 0.72478, false, 0.724779, 0.72478, false, 0.724779, 0.72478]});
ref.push({testName: 'precision.pow.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.447213, 0.447214, false, 0.447213, 0.447214, false, 0.447213, 0.447214, false, 0.447213, 0.447214]});
ref.push({testName: 'precision.pow.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.724779, 0.72478]});
ref.push({testName: 'precision.pow.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.447213, 0.447214]});
ref.push({testName: 'precision.pow.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.724779, 0.72478, false, 0.724779, 0.72478]});
ref.push({testName: 'precision.pow.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.447213, 0.447214, false, 0.447213, 0.447214]});
ref.push({testName: 'precision.pow.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.724779, 0.72478, false, 0.724779, 0.72478, false, 0.724779, 0.72478]});
ref.push({testName: 'precision.pow.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.447213, 0.447214, false, 0.447213, 0.447214, false, 0.447213, 0.447214]});
ref.push({testName: 'precision.pow.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.724779, 0.72478, false, 0.724779, 0.72478, false, 0.724779, 0.72478, false, 0.724779, 0.72478]});
ref.push({testName: 'precision.pow.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.447213, 0.447214, false, 0.447213, 0.447214, false, 0.447213, 0.447214, false, 0.447213, 0.447214]});
ref.push({testName: 'precision.exp.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1.20007, 1.24085]});
ref.push({testName: 'precision.exp.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.6331, 1.66435]});
ref.push({testName: 'precision.exp.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.20007, 1.24085, false, 1.20007, 1.24085]});
ref.push({testName: 'precision.exp.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.6331, 1.66435, false, 1.6331, 1.66435]});
ref.push({testName: 'precision.exp.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.20007, 1.24085, false, 1.20007, 1.24085, false, 1.20007, 1.24085]});
ref.push({testName: 'precision.exp.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.6331, 1.66435, false, 1.6331, 1.66435, false, 1.6331, 1.66435]});
ref.push({testName: 'precision.exp.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.20007, 1.24085, false, 1.20007, 1.24085, false, 1.20007, 1.24085, false, 1.20007, 1.24085]});
ref.push({testName: 'precision.exp.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.6331, 1.66435, false, 1.6331, 1.66435, false, 1.6331, 1.66435, false, 1.6331, 1.66435]});
ref.push({testName: 'precision.exp.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1.20007, 1.24085]});
ref.push({testName: 'precision.exp.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.6331, 1.66435]});
ref.push({testName: 'precision.exp.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.20007, 1.24085, false, 1.20007, 1.24085]});
ref.push({testName: 'precision.exp.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.6331, 1.66435, false, 1.6331, 1.66435]});
ref.push({testName: 'precision.exp.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.20007, 1.24085, false, 1.20007, 1.24085, false, 1.20007, 1.24085]});
ref.push({testName: 'precision.exp.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.6331, 1.66435, false, 1.6331, 1.66435, false, 1.6331, 1.66435]});
ref.push({testName: 'precision.exp.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.20007, 1.24085, false, 1.20007, 1.24085, false, 1.20007, 1.24085, false, 1.20007, 1.24085]});
ref.push({testName: 'precision.exp.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.6331, 1.66435, false, 1.6331, 1.66435, false, 1.6331, 1.66435, false, 1.6331, 1.66435]});
ref.push({testName: 'precision.exp.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1.21666, 1.22633]});
ref.push({testName: 'precision.exp.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.64286, 1.65458]});
ref.push({testName: 'precision.exp.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.21666, 1.22633, false, 1.21666, 1.22633]});
ref.push({testName: 'precision.exp.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.64286, 1.65458, false, 1.64286, 1.65458]});
ref.push({testName: 'precision.exp.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.21666, 1.22633, false, 1.21666, 1.22633, false, 1.21666, 1.22633]});
ref.push({testName: 'precision.exp.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.64286, 1.65458, false, 1.64286, 1.65458, false, 1.64286, 1.65458]});
ref.push({testName: 'precision.exp.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.21666, 1.22633, false, 1.21666, 1.22633, false, 1.21666, 1.22633, false, 1.21666, 1.22633]});
ref.push({testName: 'precision.exp.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.64286, 1.65458, false, 1.64286, 1.65458, false, 1.64286, 1.65458, false, 1.64286, 1.65458]});
ref.push({testName: 'precision.exp.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1.21666, 1.22633]});
ref.push({testName: 'precision.exp.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.64286, 1.65458]});
ref.push({testName: 'precision.exp.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.21666, 1.22633, false, 1.21666, 1.22633]});
ref.push({testName: 'precision.exp.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.64286, 1.65458, false, 1.64286, 1.65458]});
ref.push({testName: 'precision.exp.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.21666, 1.22633, false, 1.21666, 1.22633, false, 1.21666, 1.22633]});
ref.push({testName: 'precision.exp.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.64286, 1.65458, false, 1.64286, 1.65458, false, 1.64286, 1.65458]});
ref.push({testName: 'precision.exp.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.21666, 1.22633, false, 1.21666, 1.22633, false, 1.21666, 1.22633, false, 1.21666, 1.22633]});
ref.push({testName: 'precision.exp.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.64286, 1.65458, false, 1.64286, 1.65458, false, 1.64286, 1.65458, false, 1.64286, 1.65458]});
ref.push({testName: 'precision.exp.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1.2214, 1.2214]});
ref.push({testName: 'precision.exp.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.64872, 1.64872]});
ref.push({testName: 'precision.exp.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.2214, 1.2214, false, 1.2214, 1.2214]});
ref.push({testName: 'precision.exp.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.64872, 1.64872, false, 1.64872, 1.64872]});
ref.push({testName: 'precision.exp.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.2214, 1.2214, false, 1.2214, 1.2214, false, 1.2214, 1.2214]});
ref.push({testName: 'precision.exp.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.64872, 1.64872, false, 1.64872, 1.64872, false, 1.64872, 1.64872]});
ref.push({testName: 'precision.exp.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.2214, 1.2214, false, 1.2214, 1.2214, false, 1.2214, 1.2214, false, 1.2214, 1.2214]});
ref.push({testName: 'precision.exp.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.64872, 1.64872, false, 1.64872, 1.64872, false, 1.64872, 1.64872, false, 1.64872, 1.64872]});
ref.push({testName: 'precision.exp.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1.2214, 1.2214]});
ref.push({testName: 'precision.exp.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.64872, 1.64872]});
ref.push({testName: 'precision.exp.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.2214, 1.2214, false, 1.2214, 1.2214]});
ref.push({testName: 'precision.exp.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.64872, 1.64872, false, 1.64872, 1.64872]});
ref.push({testName: 'precision.exp.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.2214, 1.2214, false, 1.2214, 1.2214, false, 1.2214, 1.2214]});
ref.push({testName: 'precision.exp.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.64872, 1.64872, false, 1.64872, 1.64872, false, 1.64872, 1.64872]});
ref.push({testName: 'precision.exp.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.2214, 1.2214, false, 1.2214, 1.2214, false, 1.2214, 1.2214, false, 1.2214, 1.2214]});
ref.push({testName: 'precision.exp.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.64872, 1.64872, false, 1.64872, 1.64872, false, 1.64872, 1.64872, false, 1.64872, 1.64872]});
ref.push({testName: 'precision.log.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -1.64878, -1.57831]});
ref.push({testName: 'precision.log.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -0.708772, -0.677522]});
ref.push({testName: 'precision.log.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -1.64878, -1.57831, false, -1.64878, -1.57831]});
ref.push({testName: 'precision.log.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -0.708772, -0.677522, false, -0.708772, -0.677522]});
ref.push({testName: 'precision.log.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -1.64878, -1.57831, false, -1.64878, -1.57831, false, -1.64878, -1.57831]});
ref.push({testName: 'precision.log.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -0.708772, -0.677522, false, -0.708772, -0.677522, false, -0.708772, -0.677522]});
ref.push({testName: 'precision.log.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -1.64878, -1.57831, false, -1.64878, -1.57831, false, -1.64878, -1.57831, false, -1.64878, -1.57831]});
ref.push({testName: 'precision.log.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -0.708772, -0.677522, false, -0.708772, -0.677522, false, -0.708772, -0.677522, false, -0.708772, -0.677522]});
ref.push({testName: 'precision.log.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -1.64878, -1.57831]});
ref.push({testName: 'precision.log.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -0.708772, -0.677522]});
ref.push({testName: 'precision.log.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -1.64878, -1.57831, false, -1.64878, -1.57831]});
ref.push({testName: 'precision.log.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -0.708772, -0.677522, false, -0.708772, -0.677522]});
ref.push({testName: 'precision.log.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -1.64878, -1.57831, false, -1.64878, -1.57831, false, -1.64878, -1.57831]});
ref.push({testName: 'precision.log.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -0.708772, -0.677522, false, -0.708772, -0.677522, false, -0.708772, -0.677522]});
ref.push({testName: 'precision.log.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -1.64878, -1.57831, false, -1.64878, -1.57831, false, -1.64878, -1.57831, false, -1.64878, -1.57831]});
ref.push({testName: 'precision.log.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -0.708772, -0.677522, false, -0.708772, -0.677522, false, -0.708772, -0.677522, false, -0.708772, -0.677522]});
ref.push({testName: 'precision.log.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -1.61359, -1.60456]});
ref.push({testName: 'precision.log.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -0.70096, -0.685335]});
ref.push({testName: 'precision.log.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -1.61359, -1.60456, false, -1.61359, -1.60456]});
ref.push({testName: 'precision.log.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -0.70096, -0.685335, false, -0.70096, -0.685335]});
ref.push({testName: 'precision.log.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -1.61359, -1.60456, false, -1.61359, -1.60456, false, -1.61359, -1.60456]});
ref.push({testName: 'precision.log.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -0.70096, -0.685335, false, -0.70096, -0.685335, false, -0.70096, -0.685335]});
ref.push({testName: 'precision.log.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -1.61359, -1.60456, false, -1.61359, -1.60456, false, -1.61359, -1.60456, false, -1.61359, -1.60456]});
ref.push({testName: 'precision.log.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -0.70096, -0.685335, false, -0.70096, -0.685335, false, -0.70096, -0.685335, false, -0.70096, -0.685335]});
ref.push({testName: 'precision.log.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -1.61359, -1.60456]});
ref.push({testName: 'precision.log.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -0.70096, -0.685335]});
ref.push({testName: 'precision.log.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -1.61359, -1.60456, false, -1.61359, -1.60456]});
ref.push({testName: 'precision.log.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -0.70096, -0.685335, false, -0.70096, -0.685335]});
ref.push({testName: 'precision.log.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -1.61359, -1.60456, false, -1.61359, -1.60456, false, -1.61359, -1.60456]});
ref.push({testName: 'precision.log.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -0.70096, -0.685335, false, -0.70096, -0.685335, false, -0.70096, -0.685335]});
ref.push({testName: 'precision.log.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -1.61359, -1.60456, false, -1.61359, -1.60456, false, -1.61359, -1.60456, false, -1.61359, -1.60456]});
ref.push({testName: 'precision.log.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -0.70096, -0.685335, false, -0.70096, -0.685335, false, -0.70096, -0.685335, false, -0.70096, -0.685335]});
ref.push({testName: 'precision.log.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -1.60944, -1.60944]});
ref.push({testName: 'precision.log.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -0.693148, -0.693147]});
ref.push({testName: 'precision.log.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -1.60944, -1.60944, false, -1.60944, -1.60944]});
ref.push({testName: 'precision.log.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -0.693148, -0.693147, false, -0.693148, -0.693147]});
ref.push({testName: 'precision.log.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -1.60944, -1.60944, false, -1.60944, -1.60944, false, -1.60944, -1.60944]});
ref.push({testName: 'precision.log.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -0.693148, -0.693147, false, -0.693148, -0.693147, false, -0.693148, -0.693147]});
ref.push({testName: 'precision.log.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -1.60944, -1.60944, false, -1.60944, -1.60944, false, -1.60944, -1.60944, false, -1.60944, -1.60944]});
ref.push({testName: 'precision.log.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -0.693148, -0.693147, false, -0.693148, -0.693147, false, -0.693148, -0.693147, false, -0.693148, -0.693147]});
ref.push({testName: 'precision.log.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -1.60944, -1.60944]});
ref.push({testName: 'precision.log.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -0.693148, -0.693147]});
ref.push({testName: 'precision.log.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -1.60944, -1.60944, false, -1.60944, -1.60944]});
ref.push({testName: 'precision.log.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -0.693148, -0.693147, false, -0.693148, -0.693147]});
ref.push({testName: 'precision.log.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -1.60944, -1.60944, false, -1.60944, -1.60944, false, -1.60944, -1.60944]});
ref.push({testName: 'precision.log.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -0.693148, -0.693147, false, -0.693148, -0.693147, false, -0.693148, -0.693147]});
ref.push({testName: 'precision.log.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -1.60944, -1.60944, false, -1.60944, -1.60944, false, -1.60944, -1.60944, false, -1.60944, -1.60944]});
ref.push({testName: 'precision.log.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -0.693148, -0.693147, false, -0.693148, -0.693147, false, -0.693148, -0.693147, false, -0.693148, -0.693147]});
ref.push({testName: 'precision.exp2.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1.12935, 1.16681]});
ref.push({testName: 'precision.exp2.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.39859, 1.42984]});
ref.push({testName: 'precision.exp2.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.12935, 1.16681, false, 1.12935, 1.16681]});
ref.push({testName: 'precision.exp2.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.39859, 1.42984, false, 1.39859, 1.42984]});
ref.push({testName: 'precision.exp2.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.12935, 1.16681, false, 1.12935, 1.16681, false, 1.12935, 1.16681]});
ref.push({testName: 'precision.exp2.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.39859, 1.42984, false, 1.39859, 1.42984, false, 1.39859, 1.42984]});
ref.push({testName: 'precision.exp2.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.12935, 1.16681, false, 1.12935, 1.16681, false, 1.12935, 1.16681, false, 1.12935, 1.16681]});
ref.push({testName: 'precision.exp2.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.39859, 1.42984, false, 1.39859, 1.42984, false, 1.39859, 1.42984, false, 1.39859, 1.42984]});
ref.push({testName: 'precision.exp2.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1.12935, 1.16681]});
ref.push({testName: 'precision.exp2.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.39859, 1.42984]});
ref.push({testName: 'precision.exp2.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.12935, 1.16681, false, 1.12935, 1.16681]});
ref.push({testName: 'precision.exp2.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.39859, 1.42984, false, 1.39859, 1.42984]});
ref.push({testName: 'precision.exp2.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.12935, 1.16681, false, 1.12935, 1.16681, false, 1.12935, 1.16681]});
ref.push({testName: 'precision.exp2.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.39859, 1.42984, false, 1.39859, 1.42984, false, 1.39859, 1.42984]});
ref.push({testName: 'precision.exp2.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.12935, 1.16681, false, 1.12935, 1.16681, false, 1.12935, 1.16681, false, 1.12935, 1.16681]});
ref.push({testName: 'precision.exp2.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.39859, 1.42984, false, 1.39859, 1.42984, false, 1.39859, 1.42984, false, 1.39859, 1.42984]});
ref.push({testName: 'precision.exp2.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1.14397, 1.15354]});
ref.push({testName: 'precision.exp2.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.40835, 1.42007]});
ref.push({testName: 'precision.exp2.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.14397, 1.15354, false, 1.14397, 1.15354]});
ref.push({testName: 'precision.exp2.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.40835, 1.42007, false, 1.40835, 1.42007]});
ref.push({testName: 'precision.exp2.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.14397, 1.15354, false, 1.14397, 1.15354, false, 1.14397, 1.15354]});
ref.push({testName: 'precision.exp2.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.40835, 1.42007, false, 1.40835, 1.42007, false, 1.40835, 1.42007]});
ref.push({testName: 'precision.exp2.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.14397, 1.15354, false, 1.14397, 1.15354, false, 1.14397, 1.15354, false, 1.14397, 1.15354]});
ref.push({testName: 'precision.exp2.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.40835, 1.42007, false, 1.40835, 1.42007, false, 1.40835, 1.42007, false, 1.40835, 1.42007]});
ref.push({testName: 'precision.exp2.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1.14397, 1.15354]});
ref.push({testName: 'precision.exp2.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.40835, 1.42007]});
ref.push({testName: 'precision.exp2.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.14397, 1.15354, false, 1.14397, 1.15354]});
ref.push({testName: 'precision.exp2.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.40835, 1.42007, false, 1.40835, 1.42007]});
ref.push({testName: 'precision.exp2.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.14397, 1.15354, false, 1.14397, 1.15354, false, 1.14397, 1.15354]});
ref.push({testName: 'precision.exp2.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.40835, 1.42007, false, 1.40835, 1.42007, false, 1.40835, 1.42007]});
ref.push({testName: 'precision.exp2.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.14397, 1.15354, false, 1.14397, 1.15354, false, 1.14397, 1.15354, false, 1.14397, 1.15354]});
ref.push({testName: 'precision.exp2.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.40835, 1.42007, false, 1.40835, 1.42007, false, 1.40835, 1.42007, false, 1.40835, 1.42007]});
ref.push({testName: 'precision.exp2.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1.1487, 1.1487]});
ref.push({testName: 'precision.exp2.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.41421, 1.41421]});
ref.push({testName: 'precision.exp2.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.1487, 1.1487, false, 1.1487, 1.1487]});
ref.push({testName: 'precision.exp2.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.41421, 1.41421, false, 1.41421, 1.41421]});
ref.push({testName: 'precision.exp2.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.1487, 1.1487, false, 1.1487, 1.1487, false, 1.1487, 1.1487]});
ref.push({testName: 'precision.exp2.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.41421, 1.41421, false, 1.41421, 1.41421, false, 1.41421, 1.41421]});
ref.push({testName: 'precision.exp2.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.1487, 1.1487, false, 1.1487, 1.1487, false, 1.1487, 1.1487, false, 1.1487, 1.1487]});
ref.push({testName: 'precision.exp2.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.41421, 1.41421, false, 1.41421, 1.41421, false, 1.41421, 1.41421, false, 1.41421, 1.41421]});
ref.push({testName: 'precision.exp2.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1.1487, 1.1487]});
ref.push({testName: 'precision.exp2.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.41421, 1.41421]});
ref.push({testName: 'precision.exp2.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.1487, 1.1487, false, 1.1487, 1.1487]});
ref.push({testName: 'precision.exp2.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.41421, 1.41421, false, 1.41421, 1.41421]});
ref.push({testName: 'precision.exp2.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.1487, 1.1487, false, 1.1487, 1.1487, false, 1.1487, 1.1487]});
ref.push({testName: 'precision.exp2.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.41421, 1.41421, false, 1.41421, 1.41421, false, 1.41421, 1.41421]});
ref.push({testName: 'precision.exp2.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.1487, 1.1487, false, 1.1487, 1.1487, false, 1.1487, 1.1487, false, 1.1487, 1.1487]});
ref.push({testName: 'precision.exp2.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.41421, 1.41421, false, 1.41421, 1.41421, false, 1.41421, 1.41421, false, 1.41421, 1.41421]});
ref.push({testName: 'precision.log2.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, -1.99219]});
ref.push({testName: 'precision.log2.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -1.01563, -0.984375]});
ref.push({testName: 'precision.log2.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, -1.99219, false, -Infinity, -1.99219]});
ref.push({testName: 'precision.log2.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -1.01563, -0.984375, false, -1.01563, -0.984375]});
ref.push({testName: 'precision.log2.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, -1.99219, false, -Infinity, -1.99219, false, -Infinity, -1.99219]});
ref.push({testName: 'precision.log2.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -1.01563, -0.984375, false, -1.01563, -0.984375, false, -1.01563, -0.984375]});
ref.push({testName: 'precision.log2.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, -1.99219, false, -Infinity, -1.99219, false, -Infinity, -1.99219, false, -Infinity, -1.99219]});
ref.push({testName: 'precision.log2.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -1.01563, -0.984375, false, -1.01563, -0.984375, false, -1.01563, -0.984375, false, -1.01563, -0.984375]});
ref.push({testName: 'precision.log2.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, -1.99219]});
ref.push({testName: 'precision.log2.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -1.01563, -0.984375]});
ref.push({testName: 'precision.log2.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, -1.99219, false, -Infinity, -1.99219]});
ref.push({testName: 'precision.log2.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -1.01563, -0.984375, false, -1.01563, -0.984375]});
ref.push({testName: 'precision.log2.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, -1.99219, false, -Infinity, -1.99219, false, -Infinity, -1.99219]});
ref.push({testName: 'precision.log2.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -1.01563, -0.984375, false, -1.01563, -0.984375, false, -1.01563, -0.984375]});
ref.push({testName: 'precision.log2.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, -1.99219, false, -Infinity, -1.99219, false, -Infinity, -1.99219, false, -Infinity, -1.99219]});
ref.push({testName: 'precision.log2.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -1.01563, -0.984375, false, -1.01563, -0.984375, false, -1.01563, -0.984375, false, -1.01563, -0.984375]});
ref.push({testName: 'precision.log2.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -2.33009, -2.31271]});
ref.push({testName: 'precision.log2.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -1.00781, -0.992188]});
ref.push({testName: 'precision.log2.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -2.33009, -2.31271, false, -2.33009, -2.31271]});
ref.push({testName: 'precision.log2.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -1.00781, -0.992188, false, -1.00781, -0.992188]});
ref.push({testName: 'precision.log2.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -2.33009, -2.31271, false, -2.33009, -2.31271, false, -2.33009, -2.31271]});
ref.push({testName: 'precision.log2.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -1.00781, -0.992188, false, -1.00781, -0.992188, false, -1.00781, -0.992188]});
ref.push({testName: 'precision.log2.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -2.33009, -2.31271, false, -2.33009, -2.31271, false, -2.33009, -2.31271, false, -2.33009, -2.31271]});
ref.push({testName: 'precision.log2.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -1.00781, -0.992188, false, -1.00781, -0.992188, false, -1.00781, -0.992188, false, -1.00781, -0.992188]});
ref.push({testName: 'precision.log2.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -2.33009, -2.31271]});
ref.push({testName: 'precision.log2.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -1.00781, -0.992188]});
ref.push({testName: 'precision.log2.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -2.33009, -2.31271, false, -2.33009, -2.31271]});
ref.push({testName: 'precision.log2.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -1.00781, -0.992188, false, -1.00781, -0.992188]});
ref.push({testName: 'precision.log2.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -2.33009, -2.31271, false, -2.33009, -2.31271, false, -2.33009, -2.31271]});
ref.push({testName: 'precision.log2.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -1.00781, -0.992188, false, -1.00781, -0.992188, false, -1.00781, -0.992188]});
ref.push({testName: 'precision.log2.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -2.33009, -2.31271, false, -2.33009, -2.31271, false, -2.33009, -2.31271, false, -2.33009, -2.31271]});
ref.push({testName: 'precision.log2.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -1.00781, -0.992188, false, -1.00781, -0.992188, false, -1.00781, -0.992188, false, -1.00781, -0.992188]});
ref.push({testName: 'precision.log2.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -2.32193, -2.32193]});
ref.push({testName: 'precision.log2.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -1, -1]});
ref.push({testName: 'precision.log2.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -2.32193, -2.32193, false, -2.32193, -2.32193]});
ref.push({testName: 'precision.log2.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -1, -1, false, -1, -1]});
ref.push({testName: 'precision.log2.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -2.32193, -2.32193, false, -2.32193, -2.32193, false, -2.32193, -2.32193]});
ref.push({testName: 'precision.log2.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -1, -1, false, -1, -1, false, -1, -1]});
ref.push({testName: 'precision.log2.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -2.32193, -2.32193, false, -2.32193, -2.32193, false, -2.32193, -2.32193, false, -2.32193, -2.32193]});
ref.push({testName: 'precision.log2.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -1, -1, false, -1, -1, false, -1, -1, false, -1, -1]});
ref.push({testName: 'precision.log2.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -2.32193, -2.32193]});
ref.push({testName: 'precision.log2.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -1, -1]});
ref.push({testName: 'precision.log2.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -2.32193, -2.32193, false, -2.32193, -2.32193]});
ref.push({testName: 'precision.log2.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -1, -1, false, -1, -1]});
ref.push({testName: 'precision.log2.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -2.32193, -2.32193, false, -2.32193, -2.32193, false, -2.32193, -2.32193]});
ref.push({testName: 'precision.log2.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -1, -1, false, -1, -1, false, -1, -1]});
ref.push({testName: 'precision.log2.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -2.32193, -2.32193, false, -2.32193, -2.32193, false, -2.32193, -2.32193, false, -2.32193, -2.32193]});
ref.push({testName: 'precision.log2.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -1, -1, false, -1, -1, false, -1, -1, false, -1, -1]});
ref.push({testName: 'precision.sqrt.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.sqrt.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.444382, 0.450222]});
ref.push({testName: 'precision.sqrt.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.702718, 0.711507]});
ref.push({testName: 'precision.sqrt.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.444382, 0.450222, false, 0.444382, 0.450222]});
ref.push({testName: 'precision.sqrt.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.702718, 0.711507, false, 0.702718, 0.711507]});
ref.push({testName: 'precision.sqrt.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.444382, 0.450222, false, 0.444382, 0.450222, false, 0.444382, 0.450222]});
ref.push({testName: 'precision.sqrt.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.702718, 0.711507, false, 0.702718, 0.711507, false, 0.702718, 0.711507]});
ref.push({testName: 'precision.sqrt.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.444382, 0.450222, false, 0.444382, 0.450222, false, 0.444382, 0.450222, false, 0.444382, 0.450222]});
ref.push({testName: 'precision.sqrt.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.702718, 0.711507, false, 0.702718, 0.711507, false, 0.702718, 0.711507, false, 0.702718, 0.711507]});
ref.push({testName: 'precision.sqrt.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.444382, 0.450222]});
ref.push({testName: 'precision.sqrt.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.702718, 0.711507]});
ref.push({testName: 'precision.sqrt.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.444382, 0.450222, false, 0.444382, 0.450222]});
ref.push({testName: 'precision.sqrt.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.702718, 0.711507, false, 0.702718, 0.711507]});
ref.push({testName: 'precision.sqrt.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.444382, 0.450222, false, 0.444382, 0.450222, false, 0.444382, 0.450222]});
ref.push({testName: 'precision.sqrt.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.702718, 0.711507, false, 0.702718, 0.711507, false, 0.702718, 0.711507]});
ref.push({testName: 'precision.sqrt.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.444382, 0.450222, false, 0.444382, 0.450222, false, 0.444382, 0.450222, false, 0.444382, 0.450222]});
ref.push({testName: 'precision.sqrt.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.702718, 0.711507, false, 0.702718, 0.711507, false, 0.702718, 0.711507, false, 0.702718, 0.711507]});
ref.push({testName: 'precision.sqrt.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.447213, 0.447214]});
ref.push({testName: 'precision.sqrt.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.707107, 0.707107]});
ref.push({testName: 'precision.sqrt.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.447213, 0.447214, false, 0.447213, 0.447214]});
ref.push({testName: 'precision.sqrt.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.707107, 0.707107, false, 0.707107, 0.707107]});
ref.push({testName: 'precision.sqrt.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.447213, 0.447214, false, 0.447213, 0.447214, false, 0.447213, 0.447214]});
ref.push({testName: 'precision.sqrt.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.707107, 0.707107, false, 0.707107, 0.707107, false, 0.707107, 0.707107]});
ref.push({testName: 'precision.sqrt.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.447213, 0.447214, false, 0.447213, 0.447214, false, 0.447213, 0.447214, false, 0.447213, 0.447214]});
ref.push({testName: 'precision.sqrt.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.707107, 0.707107, false, 0.707107, 0.707107, false, 0.707107, 0.707107, false, 0.707107, 0.707107]});
ref.push({testName: 'precision.sqrt.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.447213, 0.447214]});
ref.push({testName: 'precision.sqrt.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.707107, 0.707107]});
ref.push({testName: 'precision.sqrt.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.447213, 0.447214, false, 0.447213, 0.447214]});
ref.push({testName: 'precision.sqrt.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.707107, 0.707107, false, 0.707107, 0.707107]});
ref.push({testName: 'precision.sqrt.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.447213, 0.447214, false, 0.447213, 0.447214, false, 0.447213, 0.447214]});
ref.push({testName: 'precision.sqrt.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.707107, 0.707107, false, 0.707107, 0.707107, false, 0.707107, 0.707107]});
ref.push({testName: 'precision.sqrt.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.447213, 0.447214, false, 0.447213, 0.447214, false, 0.447213, 0.447214, false, 0.447213, 0.447214]});
ref.push({testName: 'precision.sqrt.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.707107, 0.707107, false, 0.707107, 0.707107, false, 0.707107, 0.707107, false, 0.707107, 0.707107]});
ref.push({testName: 'precision.inversesqrt.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1.99219, Infinity]});
ref.push({testName: 'precision.inversesqrt.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.39859, 1.42984]});
ref.push({testName: 'precision.inversesqrt.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.99219, Infinity, false, 1.99219, Infinity]});
ref.push({testName: 'precision.inversesqrt.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.39859, 1.42984, false, 1.39859, 1.42984]});
ref.push({testName: 'precision.inversesqrt.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.99219, Infinity, false, 1.99219, Infinity, false, 1.99219, Infinity]});
ref.push({testName: 'precision.inversesqrt.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.39859, 1.42984, false, 1.39859, 1.42984, false, 1.39859, 1.42984]});
ref.push({testName: 'precision.inversesqrt.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.99219, Infinity, false, 1.99219, Infinity, false, 1.99219, Infinity, false, 1.99219, Infinity]});
ref.push({testName: 'precision.inversesqrt.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.39859, 1.42984, false, 1.39859, 1.42984, false, 1.39859, 1.42984, false, 1.39859, 1.42984]});
ref.push({testName: 'precision.inversesqrt.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1.99219, Infinity]});
ref.push({testName: 'precision.inversesqrt.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.39859, 1.42984]});
ref.push({testName: 'precision.inversesqrt.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1.99219, Infinity, false, 1.99219, Infinity]});
ref.push({testName: 'precision.inversesqrt.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.39859, 1.42984, false, 1.39859, 1.42984]});
ref.push({testName: 'precision.inversesqrt.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.99219, Infinity, false, 1.99219, Infinity, false, 1.99219, Infinity]});
ref.push({testName: 'precision.inversesqrt.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.39859, 1.42984, false, 1.39859, 1.42984, false, 1.39859, 1.42984]});
ref.push({testName: 'precision.inversesqrt.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1.99219, Infinity, false, 1.99219, Infinity, false, 1.99219, Infinity, false, 1.99219, Infinity]});
ref.push({testName: 'precision.inversesqrt.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.39859, 1.42984, false, 1.39859, 1.42984, false, 1.39859, 1.42984, false, 1.39859, 1.42984]});
ref.push({testName: 'precision.inversesqrt.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 2.22716, 2.24415]});
ref.push({testName: 'precision.inversesqrt.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.41031, 1.41812]});
ref.push({testName: 'precision.inversesqrt.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 2.22716, 2.24415, false, 2.22716, 2.24415]});
ref.push({testName: 'precision.inversesqrt.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.41031, 1.41812, false, 1.41031, 1.41812]});
ref.push({testName: 'precision.inversesqrt.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 2.22716, 2.24415, false, 2.22716, 2.24415, false, 2.22716, 2.24415]});
ref.push({testName: 'precision.inversesqrt.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.41031, 1.41812, false, 1.41031, 1.41812, false, 1.41031, 1.41812]});
ref.push({testName: 'precision.inversesqrt.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 2.22716, 2.24415, false, 2.22716, 2.24415, false, 2.22716, 2.24415, false, 2.22716, 2.24415]});
ref.push({testName: 'precision.inversesqrt.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.41031, 1.41812, false, 1.41031, 1.41812, false, 1.41031, 1.41812, false, 1.41031, 1.41812]});
ref.push({testName: 'precision.inversesqrt.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 2.22716, 2.24415]});
ref.push({testName: 'precision.inversesqrt.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.41031, 1.41812]});
ref.push({testName: 'precision.inversesqrt.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 2.22716, 2.24415, false, 2.22716, 2.24415]});
ref.push({testName: 'precision.inversesqrt.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.41031, 1.41812, false, 1.41031, 1.41812]});
ref.push({testName: 'precision.inversesqrt.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 2.22716, 2.24415, false, 2.22716, 2.24415, false, 2.22716, 2.24415]});
ref.push({testName: 'precision.inversesqrt.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.41031, 1.41812, false, 1.41031, 1.41812, false, 1.41031, 1.41812]});
ref.push({testName: 'precision.inversesqrt.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 2.22716, 2.24415, false, 2.22716, 2.24415, false, 2.22716, 2.24415, false, 2.22716, 2.24415]});
ref.push({testName: 'precision.inversesqrt.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.41031, 1.41812, false, 1.41031, 1.41812, false, 1.41031, 1.41812, false, 1.41031, 1.41812]});
ref.push({testName: 'precision.inversesqrt.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 2.23607, 2.23607]});
ref.push({testName: 'precision.inversesqrt.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1.41421, 1.41421]});
ref.push({testName: 'precision.inversesqrt.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 2.23607, 2.23607, false, 2.23607, 2.23607]});
ref.push({testName: 'precision.inversesqrt.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.41421, 1.41421, false, 1.41421, 1.41421]});
ref.push({testName: 'precision.inversesqrt.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 2.23607, 2.23607, false, 2.23607, 2.23607, false, 2.23607, 2.23607]});
ref.push({testName: 'precision.inversesqrt.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.41421, 1.41421, false, 1.41421, 1.41421, false, 1.41421, 1.41421]});
ref.push({testName: 'precision.inversesqrt.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 2.23607, 2.23607, false, 2.23607, 2.23607, false, 2.23607, 2.23607, false, 2.23607, 2.23607]});
ref.push({testName: 'precision.inversesqrt.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.41421, 1.41421, false, 1.41421, 1.41421, false, 1.41421, 1.41421, false, 1.41421, 1.41421]});
ref.push({testName: 'precision.inversesqrt.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 2.23607, 2.23607]});
ref.push({testName: 'precision.inversesqrt.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1.41421, 1.41421]});
ref.push({testName: 'precision.inversesqrt.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 2.23607, 2.23607, false, 2.23607, 2.23607]});
ref.push({testName: 'precision.inversesqrt.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1.41421, 1.41421, false, 1.41421, 1.41421]});
ref.push({testName: 'precision.inversesqrt.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 2.23607, 2.23607, false, 2.23607, 2.23607, false, 2.23607, 2.23607]});
ref.push({testName: 'precision.inversesqrt.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.41421, 1.41421, false, 1.41421, 1.41421, false, 1.41421, 1.41421]});
ref.push({testName: 'precision.inversesqrt.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 2.23607, 2.23607, false, 2.23607, 2.23607, false, 2.23607, 2.23607, false, 2.23607, 2.23607]});
ref.push({testName: 'precision.inversesqrt.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1.41421, 1.41421, false, 1.41421, 1.41421, false, 1.41421, 1.41421, false, 1.41421, 1.41421]});
ref.push({testName: 'precision.abs.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.abs.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.abs.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.abs.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.abs.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.abs.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.abs.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.abs.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.abs.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.abs.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.abs.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.abs.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.abs.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.abs.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.abs.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.abs.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.abs.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.abs.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.abs.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.abs.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.abs.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.abs.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.abs.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.abs.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.abs.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.abs.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.sign.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.sign.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.sign.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.sign.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.sign.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.sign.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.floor.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.floor.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.floor.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.floor.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.floor.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.floor.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.trunc.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.round.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0, 1]});
ref.push({testName: 'precision.round.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.round.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0, 1]});
ref.push({testName: 'precision.round.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.round.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0, 1]});
ref.push({testName: 'precision.round.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.round.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0, 1]});
ref.push({testName: 'precision.round.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.round.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0, 1]});
ref.push({testName: 'precision.round.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.round.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0, 1]});
ref.push({testName: 'precision.round.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.round.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.round.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.roundeven.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.roundeven.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.ceil.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.ceil.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.fract.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.fract.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.fract.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.fract.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.fract.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.fract.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.fract.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.fract.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.fract.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.fract.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.fract.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.fract.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.fract.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.fract.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.fract.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.fract.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.fract.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.fract.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.fract.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.fract.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.fract.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.fract.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.fract.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.fract.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.fract.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.fract.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.mod.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.mod.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, -0.000244141, 0.200195]});
ref.push({testName: 'precision.mod.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mod.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, -0.000244141, 0.200195, false, -0.000244141, 0.200195]});
ref.push({testName: 'precision.mod.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mod.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -0.000244141, 0.200195, false, -0.000244141, 0.200195, false, -0.000244141, 0.200195]});
ref.push({testName: 'precision.mod.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mod.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, -0.000244141, 0.200195, false, -0.000244141, 0.200195, false, -0.000244141, 0.200195, false, -0.000244141, 0.200195]});
ref.push({testName: 'precision.mod.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mod.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, -0.000244141, 0.200195]});
ref.push({testName: 'precision.mod.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mod.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, -0.000244141, 0.200195, false, -0.000244141, 0.200195]});
ref.push({testName: 'precision.mod.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mod.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -0.000244141, 0.200195, false, -0.000244141, 0.200195, false, -0.000244141, 0.200195]});
ref.push({testName: 'precision.mod.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mod.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, -0.000244141, 0.200195, false, -0.000244141, 0.200195, false, -0.000244141, 0.200195, false, -0.000244141, 0.200195]});
ref.push({testName: 'precision.mod.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mod.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0, 0.2]});
ref.push({testName: 'precision.mod.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.mod.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0, 0.2, false, 0, 0.2]});
ref.push({testName: 'precision.mod.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mod.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0, 0.2, false, 0, 0.2, false, 0, 0.2]});
ref.push({testName: 'precision.mod.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mod.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0, 0.2, false, 0, 0.2, false, 0, 0.2, false, 0, 0.2]});
ref.push({testName: 'precision.mod.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mod.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0, 0.2]});
ref.push({testName: 'precision.mod.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.mod.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0, 0.2, false, 0, 0.2]});
ref.push({testName: 'precision.mod.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mod.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0, 0.2, false, 0, 0.2, false, 0, 0.2]});
ref.push({testName: 'precision.mod.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mod.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0, 0.2, false, 0, 0.2, false, 0, 0.2, false, 0, 0.2]});
ref.push({testName: 'precision.mod.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.modf.lowp_vertex', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.modf.lowp_vertex', input: '0.2, (), (), ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.modf.lowp_vertex', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.modf.lowp_vertex', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.modf.lowp_fragment', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.modf.lowp_fragment', input: '0.2, (), (), ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.modf.lowp_fragment', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.modf.lowp_fragment', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.modf.mediump_vertex', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.modf.mediump_vertex', input: '0.2, (), (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.modf.mediump_vertex', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.modf.mediump_vertex', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.modf.mediump_fragment', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.modf.mediump_fragment', input: '0.2, (), (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.modf.mediump_fragment', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.modf.mediump_fragment', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.modf.highp_vertex', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.modf.highp_vertex', input: '0.2, (), (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.modf.highp_vertex', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.modf.highp_vertex', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.modf.highp_fragment', input: '0.2, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.modf.highp_fragment', input: '0.2, (), (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.modf.highp_fragment', input: '0.5, (), (), ()', reference: [false, 0, 0]});
ref.push({testName: 'precision.modf.highp_fragment', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.min.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.min.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.min.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.min.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.max.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.max.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.max.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.max.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.max.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.max.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.max.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.max.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.max.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.max.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.max.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.max.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.max.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.max.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.max.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.max.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.max.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.max.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.max.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.max.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.max.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.max.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.max.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.max.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.max.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.max.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.max.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.max.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.max.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.max.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.max.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.max.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.clamp.lowp_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.lowp_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.clamp.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.clamp.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.clamp.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.clamp.lowp_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.lowp_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0.195313, 0.203125]});
ref.push({testName: 'precision.clamp.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.clamp.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.clamp.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.clamp.mediump_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.mediump_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.clamp.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.clamp.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.clamp.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.clamp.mediump_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.mediump_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.clamp.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.clamp.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.clamp.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.clamp.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.clamp.highp_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.clamp.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.lowp_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, 0.179688, 0.210938]});
ref.push({testName: 'precision.mix.lowp_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0.1875, 0.203125]});
ref.push({testName: 'precision.mix.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, 0.179688, 0.210938, false, 0.179688, 0.210938]});
ref.push({testName: 'precision.mix.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0.1875, 0.203125, false, 0.1875, 0.203125]});
ref.push({testName: 'precision.mix.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, 0.179688, 0.210938, false, 0.179688, 0.210938, false, 0.179688, 0.210938]});
ref.push({testName: 'precision.mix.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0.1875, 0.203125, false, 0.1875, 0.203125, false, 0.1875, 0.203125]});
ref.push({testName: 'precision.mix.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, 0.179688, 0.210938, false, 0.179688, 0.210938, false, 0.179688, 0.210938, false, 0.179688, 0.210938]});
ref.push({testName: 'precision.mix.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0.1875, 0.203125, false, 0.1875, 0.203125, false, 0.1875, 0.203125, false, 0.1875, 0.203125]});
ref.push({testName: 'precision.mix.lowp_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, 0.179688, 0.210938]});
ref.push({testName: 'precision.mix.lowp_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0.1875, 0.203125]});
ref.push({testName: 'precision.mix.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, 0.179688, 0.210938, false, 0.179688, 0.210938]});
ref.push({testName: 'precision.mix.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0.1875, 0.203125, false, 0.1875, 0.203125]});
ref.push({testName: 'precision.mix.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, 0.179688, 0.210938, false, 0.179688, 0.210938, false, 0.179688, 0.210938]});
ref.push({testName: 'precision.mix.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0.1875, 0.203125, false, 0.1875, 0.203125, false, 0.1875, 0.203125]});
ref.push({testName: 'precision.mix.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, 0.179688, 0.210938, false, 0.179688, 0.210938, false, 0.179688, 0.210938, false, 0.179688, 0.210938]});
ref.push({testName: 'precision.mix.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0.1875, 0.203125, false, 0.1875, 0.203125, false, 0.1875, 0.203125, false, 0.1875, 0.203125]});
ref.push({testName: 'precision.mix.mediump_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, 0.199707, 0.200684]});
ref.push({testName: 'precision.mix.mediump_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mix.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, 0.199707, 0.200684, false, 0.199707, 0.200684]});
ref.push({testName: 'precision.mix.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mix.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, 0.199707, 0.200684, false, 0.199707, 0.200684, false, 0.199707, 0.200684]});
ref.push({testName: 'precision.mix.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mix.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, 0.199707, 0.200684, false, 0.199707, 0.200684, false, 0.199707, 0.200684, false, 0.199707, 0.200684]});
ref.push({testName: 'precision.mix.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mix.mediump_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, 0.199707, 0.200684]});
ref.push({testName: 'precision.mix.mediump_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mix.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, 0.199707, 0.200684, false, 0.199707, 0.200684]});
ref.push({testName: 'precision.mix.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mix.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, 0.199707, 0.200684, false, 0.199707, 0.200684, false, 0.199707, 0.200684]});
ref.push({testName: 'precision.mix.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mix.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, 0.199707, 0.200684, false, 0.199707, 0.200684, false, 0.199707, 0.200684, false, 0.199707, 0.200684]});
ref.push({testName: 'precision.mix.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.mix.highp_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.mix.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2, false, 0.2, 0.2]});
ref.push({testName: 'precision.step.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0, 1]});
ref.push({testName: 'precision.step.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.step.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.step.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.step.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.step.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0, 1]});
ref.push({testName: 'precision.step.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.step.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.step.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.step.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.step.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0, 1]});
ref.push({testName: 'precision.step.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.step.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.step.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.step.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.step.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0, 1]});
ref.push({testName: 'precision.step.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.step.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.step.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.step.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0, 1, false, 0, 1, false, 0, 1, false, 0, 1]});
ref.push({testName: 'precision.step.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.step.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.step.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.step.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.step.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.step.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 1, 1, false, 1, 1, false, 1, 1, false, 1, 1]});
ref.push({testName: 'precision.smoothstep.lowp_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.mediump_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.mediump_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0, 3]});
ref.push({testName: 'precision.smoothstep.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0, 3, false, 0, 3]});
ref.push({testName: 'precision.smoothstep.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0, 3, false, 0, 3, false, 0, 3]});
ref.push({testName: 'precision.smoothstep.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0, 3, false, 0, 3, false, 0, 3, false, 0, 3]});
ref.push({testName: 'precision.smoothstep.mediump_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.mediump_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0, 3]});
ref.push({testName: 'precision.smoothstep.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0, 3, false, 0, 3]});
ref.push({testName: 'precision.smoothstep.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0, 3, false, 0, 3, false, 0, 3]});
ref.push({testName: 'precision.smoothstep.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0, 3, false, 0, 3, false, 0, 3, false, 0, 3]});
ref.push({testName: 'precision.smoothstep.highp_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.highp_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0, 3]});
ref.push({testName: 'precision.smoothstep.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0, 3, false, 0, 3]});
ref.push({testName: 'precision.smoothstep.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0, 3, false, 0, 3, false, 0, 3]});
ref.push({testName: 'precision.smoothstep.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0, 3, false, 0, 3, false, 0, 3, false, 0, 3]});
ref.push({testName: 'precision.smoothstep.highp_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.highp_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, 0, 3]});
ref.push({testName: 'precision.smoothstep.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, 0, 3, false, 0, 3]});
ref.push({testName: 'precision.smoothstep.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, 0, 3, false, 0, 3, false, 0, 3]});
ref.push({testName: 'precision.smoothstep.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity, true, -Infinity, Infinity]});
ref.push({testName: 'precision.smoothstep.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, 0, 3, false, 0, 3, false, 0, 3, false, 0, 3]});
ref.push({testName: 'precision.length.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.length.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.198712, 0.201489]});
ref.push({testName: 'precision.length.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.497805, 0.50342]});
ref.push({testName: 'precision.length.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.280921, 0.285045]});
ref.push({testName: 'precision.length.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.702718, 0.711507]});
ref.push({testName: 'precision.length.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.344072, 0.349095]});
ref.push({testName: 'precision.length.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.860664, 0.871406]});
ref.push({testName: 'precision.length.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.397121, 0.403285]});
ref.push({testName: 'precision.length.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.995609, 1.00684]});
ref.push({testName: 'precision.length.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.198712, 0.201489]});
ref.push({testName: 'precision.length.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.497805, 0.50342]});
ref.push({testName: 'precision.length.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.280921, 0.285045]});
ref.push({testName: 'precision.length.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.702718, 0.711507]});
ref.push({testName: 'precision.length.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.344072, 0.349095]});
ref.push({testName: 'precision.length.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.860664, 0.871406]});
ref.push({testName: 'precision.length.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.397121, 0.403285]});
ref.push({testName: 'precision.length.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.995609, 1.00684]});
ref.push({testName: 'precision.length.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.length.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.length.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.282843, 0.282843]});
ref.push({testName: 'precision.length.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.707107, 0.707107]});
ref.push({testName: 'precision.length.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.34641, 0.34641]});
ref.push({testName: 'precision.length.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.866025, 0.866026]});
ref.push({testName: 'precision.length.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.4, 0.4]});
ref.push({testName: 'precision.length.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.length.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.length.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.5, 0.5]});
ref.push({testName: 'precision.length.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.282843, 0.282843]});
ref.push({testName: 'precision.length.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.707107, 0.707107]});
ref.push({testName: 'precision.length.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.34641, 0.34641]});
ref.push({testName: 'precision.length.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.866025, 0.866026]});
ref.push({testName: 'precision.length.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.4, 0.4]});
ref.push({testName: 'precision.length.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.distance.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.297819, 0.302277]});
ref.push({testName: 'precision.distance.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.421276, 0.427394]});
ref.push({testName: 'precision.distance.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.515672, 0.524075]});
ref.push({testName: 'precision.distance.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.595637, 0.604962]});
ref.push({testName: 'precision.distance.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.297819, 0.302277]});
ref.push({testName: 'precision.distance.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.421276, 0.427394]});
ref.push({testName: 'precision.distance.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.515672, 0.524075]});
ref.push({testName: 'precision.distance.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.595637, 0.604962]});
ref.push({testName: 'precision.distance.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.3, 0.3]});
ref.push({testName: 'precision.distance.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.424264, 0.424264]});
ref.push({testName: 'precision.distance.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.519615, 0.519615]});
ref.push({testName: 'precision.distance.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.6, 0.6]});
ref.push({testName: 'precision.distance.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.3, 0.3]});
ref.push({testName: 'precision.distance.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.424264, 0.424264]});
ref.push({testName: 'precision.distance.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.519615, 0.519615]});
ref.push({testName: 'precision.distance.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [true, -Infinity, Infinity]});
ref.push({testName: 'precision.distance.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.6, 0.6]});
ref.push({testName: 'precision.dot.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.03125, 0.046875]});
ref.push({testName: 'precision.dot.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.09375, 0.101563]});
ref.push({testName: 'precision.dot.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.0625, 0.09375]});
ref.push({testName: 'precision.dot.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.1875, 0.203125]});
ref.push({testName: 'precision.dot.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.09375, 0.140625]});
ref.push({testName: 'precision.dot.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.28125, 0.304688]});
ref.push({testName: 'precision.dot.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.125, 0.1875]});
ref.push({testName: 'precision.dot.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.375, 0.40625]});
ref.push({testName: 'precision.dot.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.03125, 0.046875]});
ref.push({testName: 'precision.dot.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.09375, 0.101563]});
ref.push({testName: 'precision.dot.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.0625, 0.09375]});
ref.push({testName: 'precision.dot.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.1875, 0.203125]});
ref.push({testName: 'precision.dot.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.09375, 0.140625]});
ref.push({testName: 'precision.dot.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.28125, 0.304688]});
ref.push({testName: 'precision.dot.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.125, 0.1875]});
ref.push({testName: 'precision.dot.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.375, 0.40625]});
ref.push({testName: 'precision.dot.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.dot.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.dot.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.0799561, 0.0802002]});
ref.push({testName: 'precision.dot.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.dot.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.119873, 0.120361]});
ref.push({testName: 'precision.dot.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.299805, 0.300293]});
ref.push({testName: 'precision.dot.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.159668, 0.160645]});
ref.push({testName: 'precision.dot.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.399414, 0.400391]});
ref.push({testName: 'precision.dot.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.dot.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.dot.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.0799561, 0.0802002]});
ref.push({testName: 'precision.dot.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.199951, 0.200195]});
ref.push({testName: 'precision.dot.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.119873, 0.120361]});
ref.push({testName: 'precision.dot.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.299805, 0.300293]});
ref.push({testName: 'precision.dot.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.159668, 0.160645]});
ref.push({testName: 'precision.dot.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.399414, 0.400391]});
ref.push({testName: 'precision.dot.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.04, 0.04]});
ref.push({testName: 'precision.dot.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.1, 0.1]});
ref.push({testName: 'precision.dot.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.08, 0.08]});
ref.push({testName: 'precision.dot.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.dot.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.12, 0.12]});
ref.push({testName: 'precision.dot.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.3, 0.3]});
ref.push({testName: 'precision.dot.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.16, 0.16]});
ref.push({testName: 'precision.dot.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.4, 0.4]});
ref.push({testName: 'precision.dot.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.04, 0.04]});
ref.push({testName: 'precision.dot.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.1, 0.1]});
ref.push({testName: 'precision.dot.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.08, 0.08]});
ref.push({testName: 'precision.dot.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.2, 0.2]});
ref.push({testName: 'precision.dot.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.12, 0.12]});
ref.push({testName: 'precision.dot.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.3, 0.3]});
ref.push({testName: 'precision.dot.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.16, 0.16]});
ref.push({testName: 'precision.dot.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.4, 0.4]});
ref.push({testName: 'precision.cross.lowp_vertex', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -0.015625, 0.015625, false, -0.015625, 0.015625, false, -0.015625, 0.015625]});
ref.push({testName: 'precision.cross.lowp_vertex', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125]});
ref.push({testName: 'precision.cross.lowp_fragment', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -0.015625, 0.015625, false, -0.015625, 0.015625, false, -0.015625, 0.015625]});
ref.push({testName: 'precision.cross.lowp_fragment', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125, false, -0.0078125, 0.0078125]});
ref.push({testName: 'precision.cross.mediump_vertex', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -0.00012207, 0.00012207, false, -0.00012207, 0.00012207, false, -0.00012207, 0.00012207]});
ref.push({testName: 'precision.cross.mediump_vertex', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.00012207, 0.00012207, false, -0.00012207, 0.00012207, false, -0.00012207, 0.00012207]});
ref.push({testName: 'precision.cross.mediump_fragment', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -0.00012207, 0.00012207, false, -0.00012207, 0.00012207, false, -0.00012207, 0.00012207]});
ref.push({testName: 'precision.cross.mediump_fragment', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.00012207, 0.00012207, false, -0.00012207, 0.00012207, false, -0.00012207, 0.00012207]});
ref.push({testName: 'precision.cross.highp_vertex', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -3.72529e-009, 3.72529e-009, false, -3.72529e-009, 3.72529e-009, false, -3.72529e-009, 3.72529e-009]});
ref.push({testName: 'precision.cross.highp_vertex', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.cross.highp_fragment', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, -3.72529e-009, 3.72529e-009, false, -3.72529e-009, 3.72529e-009, false, -3.72529e-009, 3.72529e-009]});
ref.push({testName: 'precision.cross.highp_fragment', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.normalize.lowp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.lowp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.normalize.mediump_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 0.989926, 1.01235]});
ref.push({testName: 'precision.normalize.mediump_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 0.990765, 1.00929]});
ref.push({testName: 'precision.normalize.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.699031, 0.71508, false, 0.699031, 0.71508]});
ref.push({testName: 'precision.normalize.mediump_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.700293, 0.713965, false, 0.700293, 0.713965]});
ref.push({testName: 'precision.normalize.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.570329, 0.584282, false, 0.570329, 0.584282, false, 0.570329, 0.584282]});
ref.push({testName: 'precision.normalize.mediump_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.571344, 0.583388, false, 0.571344, 0.583388, false, 0.571344, 0.583388]});
ref.push({testName: 'precision.normalize.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.494586, 0.506559, false, 0.494586, 0.506559, false, 0.494586, 0.506559, false, 0.494586, 0.506559]});
ref.push({testName: 'precision.normalize.mediump_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.495383, 0.504646, false, 0.495383, 0.504646, false, 0.495383, 0.504646, false, 0.495383, 0.504646]});
ref.push({testName: 'precision.normalize.mediump_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 0.989926, 1.01235]});
ref.push({testName: 'precision.normalize.mediump_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 0.990765, 1.00929]});
ref.push({testName: 'precision.normalize.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.699031, 0.71508, false, 0.699031, 0.71508]});
ref.push({testName: 'precision.normalize.mediump_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.700293, 0.713965, false, 0.700293, 0.713965]});
ref.push({testName: 'precision.normalize.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.570329, 0.584282, false, 0.570329, 0.584282, false, 0.570329, 0.584282]});
ref.push({testName: 'precision.normalize.mediump_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.571344, 0.583388, false, 0.571344, 0.583388, false, 0.571344, 0.583388]});
ref.push({testName: 'precision.normalize.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.494586, 0.506559, false, 0.494586, 0.506559, false, 0.494586, 0.506559, false, 0.494586, 0.506559]});
ref.push({testName: 'precision.normalize.mediump_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.495383, 0.504646, false, 0.495383, 0.504646, false, 0.495383, 0.504646, false, 0.495383, 0.504646]});
ref.push({testName: 'precision.normalize.highp_vertex.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.normalize.highp_vertex.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.normalize.highp_vertex.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.707106, 0.707107, false, 0.707106, 0.707107]});
ref.push({testName: 'precision.normalize.highp_vertex.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.707106, 0.707107, false, 0.707106, 0.707107]});
ref.push({testName: 'precision.normalize.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.57735, 0.577351, false, 0.57735, 0.577351, false, 0.57735, 0.577351]});
ref.push({testName: 'precision.normalize.highp_vertex.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.57735, 0.577351, false, 0.57735, 0.577351, false, 0.57735, 0.577351]});
ref.push({testName: 'precision.normalize.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.normalize.highp_vertex.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.normalize.highp_fragment.scalar', input: '0.2, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.normalize.highp_fragment.scalar', input: '0.5, (), (), ()', reference: [false, 1, 1]});
ref.push({testName: 'precision.normalize.highp_fragment.vec2', input: 'vec2(0.2, 0.2), (), (), ()', reference: [false, 0.707106, 0.707107, false, 0.707106, 0.707107]});
ref.push({testName: 'precision.normalize.highp_fragment.vec2', input: 'vec2(0.5, 0.5), (), (), ()', reference: [false, 0.707106, 0.707107, false, 0.707106, 0.707107]});
ref.push({testName: 'precision.normalize.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.57735, 0.577351, false, 0.57735, 0.577351, false, 0.57735, 0.577351]});
ref.push({testName: 'precision.normalize.highp_fragment.vec3', input: 'vec3(0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.57735, 0.577351, false, 0.57735, 0.577351, false, 0.57735, 0.577351]});
ref.push({testName: 'precision.normalize.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.normalize.highp_fragment.vec4', input: 'vec4(0.5, 0.5, 0.5, 0.5), (), (), ()', reference: [false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5, false, 0.5, 0.5]});
ref.push({testName: 'precision.faceforward.lowp_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, -0.203125, -0.195313, false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, -0.203125, -0.195313, false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, -0.203125, -0.195313, false, -0.203125, -0.195313, false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, -0.203125, -0.195313, false, -0.203125, -0.195313, false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, -0.203125, -0.195313, false, -0.203125, -0.195313, false, -0.203125, -0.195313, false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, -0.203125, -0.195313, false, -0.203125, -0.195313, false, -0.203125, -0.195313, false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, -0.203125, -0.195313, false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, -0.203125, -0.195313, false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, -0.203125, -0.195313, false, -0.203125, -0.195313, false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, -0.203125, -0.195313, false, -0.203125, -0.195313, false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, -0.203125, -0.195313, false, -0.203125, -0.195313, false, -0.203125, -0.195313, false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, -0.203125, -0.195313, false, -0.203125, -0.195313, false, -0.203125, -0.195313, false, -0.203125, -0.195313]});
ref.push({testName: 'precision.faceforward.mediump_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, -0.200195, -0.199951, false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, -0.200195, -0.199951, false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, -0.200195, -0.199951, false, -0.200195, -0.199951, false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, -0.200195, -0.199951, false, -0.200195, -0.199951, false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, -0.200195, -0.199951, false, -0.200195, -0.199951, false, -0.200195, -0.199951, false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, -0.200195, -0.199951, false, -0.200195, -0.199951, false, -0.200195, -0.199951, false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, -0.200195, -0.199951, false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, -0.200195, -0.199951, false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, -0.200195, -0.199951, false, -0.200195, -0.199951, false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, -0.200195, -0.199951, false, -0.200195, -0.199951, false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, -0.200195, -0.199951, false, -0.200195, -0.199951, false, -0.200195, -0.199951, false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, -0.200195, -0.199951, false, -0.200195, -0.199951, false, -0.200195, -0.199951, false, -0.200195, -0.199951]});
ref.push({testName: 'precision.faceforward.highp_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.2, 0.2), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), vec2(0.5, 0.5), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.faceforward.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.reflect.lowp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.164063, 0.203125]});
ref.push({testName: 'precision.reflect.lowp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.0859375, 0.109375]});
ref.push({testName: 'precision.reflect.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.148438, 0.1875, false, 0.148438, 0.1875]});
ref.push({testName: 'precision.reflect.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -0.0078125, 0.015625, false, -0.0078125, 0.015625]});
ref.push({testName: 'precision.reflect.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.132813, 0.171875, false, 0.132813, 0.171875, false, 0.132813, 0.171875]});
ref.push({testName: 'precision.reflect.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.117188, -0.078125, false, -0.117188, -0.078125, false, -0.117188, -0.078125]});
ref.push({testName: 'precision.reflect.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.117188, 0.15625, false, 0.117188, 0.15625, false, 0.117188, 0.15625, false, 0.117188, 0.15625]});
ref.push({testName: 'precision.reflect.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -0.210938, -0.171875, false, -0.210938, -0.171875, false, -0.210938, -0.171875, false, -0.210938, -0.171875]});
ref.push({testName: 'precision.reflect.lowp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.164063, 0.203125]});
ref.push({testName: 'precision.reflect.lowp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.0859375, 0.109375]});
ref.push({testName: 'precision.reflect.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.148438, 0.1875, false, 0.148438, 0.1875]});
ref.push({testName: 'precision.reflect.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -0.0078125, 0.015625, false, -0.0078125, 0.015625]});
ref.push({testName: 'precision.reflect.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.132813, 0.171875, false, 0.132813, 0.171875, false, 0.132813, 0.171875]});
ref.push({testName: 'precision.reflect.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.117188, -0.078125, false, -0.117188, -0.078125, false, -0.117188, -0.078125]});
ref.push({testName: 'precision.reflect.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.117188, 0.15625, false, 0.117188, 0.15625, false, 0.117188, 0.15625, false, 0.117188, 0.15625]});
ref.push({testName: 'precision.reflect.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -0.210938, -0.171875, false, -0.210938, -0.171875, false, -0.210938, -0.171875, false, -0.210938, -0.171875]});
ref.push({testName: 'precision.reflect.mediump_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.183838, 0.184326]});
ref.push({testName: 'precision.reflect.mediump_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.0998535, 0.10022]});
ref.push({testName: 'precision.reflect.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.167725, 0.168457, false, 0.167725, 0.168457]});
ref.push({testName: 'precision.reflect.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141]});
ref.push({testName: 'precision.reflect.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.151611, 0.152344, false, 0.151611, 0.152344, false, 0.151611, 0.152344]});
ref.push({testName: 'precision.reflect.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.100342, -0.0996094, false, -0.100342, -0.0996094, false, -0.100342, -0.0996094]});
ref.push({testName: 'precision.reflect.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.135498, 0.136475, false, 0.135498, 0.136475, false, 0.135498, 0.136475, false, 0.135498, 0.136475]});
ref.push({testName: 'precision.reflect.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -0.200439, -0.199219, false, -0.200439, -0.199219, false, -0.200439, -0.199219, false, -0.200439, -0.199219]});
ref.push({testName: 'precision.reflect.mediump_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.183838, 0.184326]});
ref.push({testName: 'precision.reflect.mediump_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.0998535, 0.10022]});
ref.push({testName: 'precision.reflect.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.167725, 0.168457, false, 0.167725, 0.168457]});
ref.push({testName: 'precision.reflect.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, -0.000244141, 0.000244141, false, -0.000244141, 0.000244141]});
ref.push({testName: 'precision.reflect.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.151611, 0.152344, false, 0.151611, 0.152344, false, 0.151611, 0.152344]});
ref.push({testName: 'precision.reflect.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.100342, -0.0996094, false, -0.100342, -0.0996094, false, -0.100342, -0.0996094]});
ref.push({testName: 'precision.reflect.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.135498, 0.136475, false, 0.135498, 0.136475, false, 0.135498, 0.136475, false, 0.135498, 0.136475]});
ref.push({testName: 'precision.reflect.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -0.200439, -0.199219, false, -0.200439, -0.199219, false, -0.200439, -0.199219, false, -0.200439, -0.199219]});
ref.push({testName: 'precision.reflect.highp_vertex.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.184, 0.184]});
ref.push({testName: 'precision.reflect.highp_vertex.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.1, 0.1]});
ref.push({testName: 'precision.reflect.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.168, 0.168, false, 0.168, 0.168]});
ref.push({testName: 'precision.reflect.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.reflect.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.152, 0.152, false, 0.152, 0.152, false, 0.152, 0.152]});
ref.push({testName: 'precision.reflect.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.1, -0.1, false, -0.1, -0.1, false, -0.1, -0.1]});
ref.push({testName: 'precision.reflect.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.136, 0.136, false, 0.136, 0.136, false, 0.136, 0.136, false, 0.136, 0.136]});
ref.push({testName: 'precision.reflect.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.reflect.highp_fragment.scalar', input: '0.2, 0.2, (), ()', reference: [false, 0.184, 0.184]});
ref.push({testName: 'precision.reflect.highp_fragment.scalar', input: '0.2, 0.5, (), ()', reference: [false, 0.1, 0.1]});
ref.push({testName: 'precision.reflect.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.168, 0.168, false, 0.168, 0.168]});
ref.push({testName: 'precision.reflect.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.reflect.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.152, 0.152, false, 0.152, 0.152, false, 0.152, 0.152]});
ref.push({testName: 'precision.reflect.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, -0.1, -0.1, false, -0.1, -0.1, false, -0.1, -0.1]});
ref.push({testName: 'precision.reflect.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.136, 0.136, false, 0.136, 0.136, false, 0.136, 0.136, false, 0.136, 0.136]});
ref.push({testName: 'precision.reflect.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2, false, -0.2, -0.2]});
ref.push({testName: 'precision.refract.lowp_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), 0.2, ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), 0.5, ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), 0.2, ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), 0.5, ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), 0.2, ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), 0.5, ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), 0.2, ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), 0.5, ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), 0.2, ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), 0.5, ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), 0.2, ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.lowp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), 0.5, ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.refract.mediump_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, -0.159424, -0.155762]});
ref.push({testName: 'precision.refract.mediump_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, -0.0787354, -0.0756836]});
ref.push({testName: 'precision.refract.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), 0.2, ()', reference: [false, -0.161377, -0.157471, false, -0.161377, -0.157471]});
ref.push({testName: 'precision.refract.mediump_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), 0.5, ()', reference: [false, -0.0828857, -0.079834, false, -0.0828857, -0.079834]});
ref.push({testName: 'precision.refract.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), 0.2, ()', reference: [false, -0.162842, -0.158936, false, -0.162842, -0.158936, false, -0.162842, -0.158936]});
ref.push({testName: 'precision.refract.mediump_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), 0.5, ()', reference: [false, -0.0872803, -0.0842285, false, -0.0872803, -0.0842285, false, -0.0872803, -0.0842285]});
ref.push({testName: 'precision.refract.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), 0.2, ()', reference: [false, -0.164551, -0.1604, false, -0.164551, -0.1604, false, -0.164551, -0.1604, false, -0.164551, -0.1604]});
ref.push({testName: 'precision.refract.mediump_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), 0.5, ()', reference: [false, -0.0914307, -0.0883789, false, -0.0914307, -0.0883789, false, -0.0914307, -0.0883789, false, -0.0914307, -0.0883789]});
ref.push({testName: 'precision.refract.mediump_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, -0.159424, -0.155762]});
ref.push({testName: 'precision.refract.mediump_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, -0.0787354, -0.0756836]});
ref.push({testName: 'precision.refract.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), 0.2, ()', reference: [false, -0.161377, -0.157471, false, -0.161377, -0.157471]});
ref.push({testName: 'precision.refract.mediump_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), 0.5, ()', reference: [false, -0.0828857, -0.079834, false, -0.0828857, -0.079834]});
ref.push({testName: 'precision.refract.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), 0.2, ()', reference: [false, -0.162842, -0.158936, false, -0.162842, -0.158936, false, -0.162842, -0.158936]});
ref.push({testName: 'precision.refract.mediump_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), 0.5, ()', reference: [false, -0.0872803, -0.0842285, false, -0.0872803, -0.0842285, false, -0.0872803, -0.0842285]});
ref.push({testName: 'precision.refract.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), 0.2, ()', reference: [false, -0.164551, -0.1604, false, -0.164551, -0.1604, false, -0.164551, -0.1604, false, -0.164551, -0.1604]});
ref.push({testName: 'precision.refract.mediump_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), 0.5, ()', reference: [false, -0.0914307, -0.0883789, false, -0.0914307, -0.0883789, false, -0.0914307, -0.0883789, false, -0.0914307, -0.0883789]});
ref.push({testName: 'precision.refract.highp_vertex.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, -0.157566, -0.157566]});
ref.push({testName: 'precision.refract.highp_vertex.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, -0.0772513, -0.0772512]});
ref.push({testName: 'precision.refract.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), 0.2, ()', reference: [false, -0.159185, -0.159185, false, -0.159185, -0.159185]});
ref.push({testName: 'precision.refract.highp_vertex.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), 0.5, ()', reference: [false, -0.0813898, -0.0813897, false, -0.0813898, -0.0813897]});
ref.push({testName: 'precision.refract.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), 0.2, ()', reference: [false, -0.160818, -0.160818, false, -0.160818, -0.160818, false, -0.160818, -0.160818]});
ref.push({testName: 'precision.refract.highp_vertex.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), 0.5, ()', reference: [false, -0.0856203, -0.0856202, false, -0.0856203, -0.0856202, false, -0.0856203, -0.0856202]});
ref.push({testName: 'precision.refract.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), 0.2, ()', reference: [false, -0.162464, -0.162464, false, -0.162464, -0.162464, false, -0.162464, -0.162464, false, -0.162464, -0.162464]});
ref.push({testName: 'precision.refract.highp_vertex.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), 0.5, ()', reference: [false, -0.0899426, -0.0899425, false, -0.0899426, -0.0899425, false, -0.0899426, -0.0899425, false, -0.0899426, -0.0899425]});
ref.push({testName: 'precision.refract.highp_fragment.scalar', input: '0.2, 0.2, 0.2, ()', reference: [false, -0.157566, -0.157566]});
ref.push({testName: 'precision.refract.highp_fragment.scalar', input: '0.2, 0.2, 0.5, ()', reference: [false, -0.0772513, -0.0772512]});
ref.push({testName: 'precision.refract.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), 0.2, ()', reference: [false, -0.159185, -0.159185, false, -0.159185, -0.159185]});
ref.push({testName: 'precision.refract.highp_fragment.vec2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), 0.5, ()', reference: [false, -0.0813898, -0.0813897, false, -0.0813898, -0.0813897]});
ref.push({testName: 'precision.refract.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), 0.2, ()', reference: [false, -0.160818, -0.160818, false, -0.160818, -0.160818, false, -0.160818, -0.160818]});
ref.push({testName: 'precision.refract.highp_fragment.vec3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), 0.5, ()', reference: [false, -0.0856203, -0.0856202, false, -0.0856203, -0.0856202, false, -0.0856203, -0.0856202]});
ref.push({testName: 'precision.refract.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), 0.2, ()', reference: [false, -0.162464, -0.162464, false, -0.162464, -0.162464, false, -0.162464, -0.162464, false, -0.162464, -0.162464]});
ref.push({testName: 'precision.refract.highp_fragment.vec4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), 0.5, ()', reference: [false, -0.0899426, -0.0899425, false, -0.0899426, -0.0899425, false, -0.0899426, -0.0899425, false, -0.0899426, -0.0899425]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), mat2(vec2(0.2, 0), vec2(0, 0.2)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), mat2(vec2(0.5, 0), vec2(0, 0.5)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat2x3', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat2x3', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), mat2x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat2x4', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat2x4', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), mat2x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat3x2', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat3x2', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), mat3x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), mat3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat3x4', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat3x4', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), mat3x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat4x2', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat4x2', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), mat4x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0), vec2(0, 0)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat4x3', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat4x3', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), mat4x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5), vec3(0, 0, 0)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.matrixcompmult.lowp_vertex.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), mat4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0), vec4(0, 0, 0, 0.5)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), mat2(vec2(0.2, 0), vec2(0, 0.2)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), mat2(vec2(0.5, 0), vec2(0, 0.5)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat2x3', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat2x3', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), mat2x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat2x4', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat2x4', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), mat2x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat3x2', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat3x2', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), mat3x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), mat3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat3x4', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat3x4', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), mat3x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat4x2', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat4x2', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), mat4x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0), vec2(0, 0)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat4x3', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat4x3', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), mat4x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5), vec3(0, 0, 0)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), (), ()', reference: [false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.matrixcompmult.lowp_fragment.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), mat4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0), vec4(0, 0, 0, 0.5)), (), ()', reference: [false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), mat2(vec2(0.2, 0), vec2(0, 0.2)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), mat2(vec2(0.5, 0), vec2(0, 0.5)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat2x3', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat2x3', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), mat2x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat2x4', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat2x4', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), mat2x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat3x2', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat3x2', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), mat3x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), mat3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat3x4', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat3x4', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), mat3x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat4x2', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat4x2', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), mat4x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0), vec2(0, 0)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat4x3', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat4x3', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), mat4x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5), vec3(0, 0, 0)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.matrixcompmult.mediump_vertex.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), mat4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0), vec4(0, 0, 0, 0.5)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), mat2(vec2(0.2, 0), vec2(0, 0.2)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), mat2(vec2(0.5, 0), vec2(0, 0.5)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat2x3', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat2x3', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), mat2x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat2x4', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat2x4', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), mat2x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat3x2', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat3x2', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), mat3x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), mat3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat3x4', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat3x4', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), mat3x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat4x2', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat4x2', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), mat4x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0), vec2(0, 0)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat4x3', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat4x3', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), mat4x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5), vec3(0, 0, 0)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), (), ()', reference: [false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.matrixcompmult.mediump_fragment.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), mat4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0), vec4(0, 0, 0, 0.5)), (), ()', reference: [false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), mat2(vec2(0.2, 0), vec2(0, 0.2)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0.04, 0.04]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), mat2(vec2(0.5, 0), vec2(0, 0.5)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0.1, 0.1]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat2x3', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat2x3', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), mat2x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat2x4', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat2x4', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), mat2x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat3x2', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat3x2', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), mat3x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), mat3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat3x4', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat3x4', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), mat3x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat4x2', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat4x2', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), mat4x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0), vec2(0, 0)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat4x3', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat4x3', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), mat4x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5), vec3(0, 0, 0)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04]});
ref.push({testName: 'precision.matrixcompmult.highp_vertex.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), mat4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0), vec4(0, 0, 0, 0.5)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), mat2(vec2(0.2, 0), vec2(0, 0.2)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0.04, 0.04]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), mat2(vec2(0.5, 0), vec2(0, 0.5)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0.1, 0.1]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat2x3', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat2x3', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), mat2x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat2x4', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat2x4', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), mat2x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat3x2', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat3x2', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), mat3x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), mat3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat3x4', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat3x4', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), mat3x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat4x2', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat4x2', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), mat4x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0), vec2(0, 0)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat4x3', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat4x3', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), mat4x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5), vec3(0, 0, 0)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), (), ()', reference: [false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.04, 0.04]});
ref.push({testName: 'precision.matrixcompmult.highp_fragment.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), mat4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0), vec4(0, 0, 0, 0.5)), (), ()', reference: [false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat2x3', input: 'vec3(0.2, 0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat2x3', input: 'vec3(0.2, 0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat2x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat2x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat3x2', input: 'vec2(0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat3x2', input: 'vec2(0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat3x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat3x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat4x2', input: 'vec2(0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat4x2', input: 'vec2(0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat4x3', input: 'vec3(0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat4x3', input: 'vec3(0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_vertex.mat4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat2x3', input: 'vec3(0.2, 0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat2x3', input: 'vec3(0.2, 0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat2x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat2x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat3x2', input: 'vec2(0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat3x2', input: 'vec2(0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat3x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat3x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat4x2', input: 'vec2(0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat4x2', input: 'vec2(0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat4x3', input: 'vec3(0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat4x3', input: 'vec3(0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875, false, 0.03125, 0.046875]});
ref.push({testName: 'precision.outerproduct.lowp_fragment.mat4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563, false, 0.09375, 0.101563]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat2x3', input: 'vec3(0.2, 0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat2x3', input: 'vec3(0.2, 0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat2x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat2x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat3x2', input: 'vec2(0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat3x2', input: 'vec2(0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat3x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat3x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat4x2', input: 'vec2(0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat4x2', input: 'vec2(0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat4x3', input: 'vec3(0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat4x3', input: 'vec3(0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_vertex.mat4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat2x3', input: 'vec3(0.2, 0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat2x3', input: 'vec3(0.2, 0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat2x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat2x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat3x2', input: 'vec2(0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat3x2', input: 'vec2(0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat3x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat3x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat4x2', input: 'vec2(0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat4x2', input: 'vec2(0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat4x3', input: 'vec3(0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat4x3', input: 'vec3(0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001, false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.outerproduct.mediump_fragment.mat4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098, false, 0.0999756, 0.100098]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat2x3', input: 'vec3(0.2, 0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat2x3', input: 'vec3(0.2, 0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat2x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat2x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat3x2', input: 'vec2(0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat3x2', input: 'vec2(0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat3x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat3x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat4x2', input: 'vec2(0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat4x2', input: 'vec2(0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat4x3', input: 'vec3(0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat4x3', input: 'vec3(0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_vertex.mat4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat2', input: 'vec2(0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat2', input: 'vec2(0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat2x3', input: 'vec3(0.2, 0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat2x3', input: 'vec3(0.2, 0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat2x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec2(0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat2x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec2(0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat3x2', input: 'vec2(0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat3x2', input: 'vec2(0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat3', input: 'vec3(0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat3x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec3(0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat3x4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec3(0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat4x2', input: 'vec2(0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat4x2', input: 'vec2(0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat4x3', input: 'vec3(0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat4x3', input: 'vec3(0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.2, 0.2, 0.2, 0.2), (), ()', reference: [false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04, false, 0.04, 0.04]});
ref.push({testName: 'precision.outerproduct.highp_fragment.mat4', input: 'vec4(0.2, 0.2, 0.2, 0.2), vec4(0.5, 0.5, 0.5, 0.5), (), ()', reference: [false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1, false, 0.1, 0.1]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat2x3', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat2x3', input: 'mat3x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat2x4', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat2x4', input: 'mat4x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0), vec2(0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat3x2', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat3x2', input: 'mat2x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat3', input: 'mat3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat3x4', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat3x4', input: 'mat4x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5), vec3(0, 0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat4x2', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat4x2', input: 'mat2x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat4x3', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat4x3', input: 'mat3x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.transpose.lowp_vertex.mat4', input: 'mat4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0), vec4(0, 0, 0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat2x3', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat2x3', input: 'mat3x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat2x4', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat2x4', input: 'mat4x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0), vec2(0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat3x2', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat3x2', input: 'mat2x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat3', input: 'mat3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat3x4', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat3x4', input: 'mat4x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5), vec3(0, 0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat4x2', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat4x2', input: 'mat2x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat4x3', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat4x3', input: 'mat3x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), (), (), ()', reference: [false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.195313, 0.203125]});
ref.push({testName: 'precision.transpose.lowp_fragment.mat4', input: 'mat4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0), vec4(0, 0, 0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat2x3', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat2x3', input: 'mat3x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat2x4', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat2x4', input: 'mat4x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0), vec2(0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat3x2', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat3x2', input: 'mat2x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat3', input: 'mat3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat3x4', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat3x4', input: 'mat4x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5), vec3(0, 0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat4x2', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat4x2', input: 'mat2x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat4x3', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat4x3', input: 'mat3x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.transpose.mediump_vertex.mat4', input: 'mat4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0), vec4(0, 0, 0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat2x3', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat2x3', input: 'mat3x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat2x4', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat2x4', input: 'mat4x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0), vec2(0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat3x2', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat3x2', input: 'mat2x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat3', input: 'mat3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat3x4', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat3x4', input: 'mat4x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5), vec3(0, 0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat4x2', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat4x2', input: 'mat2x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat4x3', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat4x3', input: 'mat3x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), (), (), ()', reference: [false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.199951, 0.200195]});
ref.push({testName: 'precision.transpose.mediump_fragment.mat4', input: 'mat4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0), vec4(0, 0, 0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.highp_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0.2, 0.2]});
ref.push({testName: 'precision.transpose.highp_vertex.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.highp_vertex.mat2x3', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_vertex.mat2x3', input: 'mat3x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_vertex.mat2x4', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_vertex.mat2x4', input: 'mat4x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0), vec2(0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_vertex.mat3x2', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_vertex.mat3x2', input: 'mat2x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_vertex.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2]});
ref.push({testName: 'precision.transpose.highp_vertex.mat3', input: 'mat3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.highp_vertex.mat3x4', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_vertex.mat3x4', input: 'mat4x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5), vec3(0, 0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_vertex.mat4x2', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_vertex.mat4x2', input: 'mat2x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_vertex.mat4x3', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_vertex.mat4x3', input: 'mat3x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_vertex.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2]});
ref.push({testName: 'precision.transpose.highp_vertex.mat4', input: 'mat4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0), vec4(0, 0, 0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.highp_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0.2, 0.2]});
ref.push({testName: 'precision.transpose.highp_fragment.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.highp_fragment.mat2x3', input: 'mat3x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_fragment.mat2x3', input: 'mat3x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_fragment.mat2x4', input: 'mat4x2(vec2(0.2, 0), vec2(0, 0.2), vec2(0, 0), vec2(0, 0)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_fragment.mat2x4', input: 'mat4x2(vec2(0.5, 0), vec2(0, 0.5), vec2(0, 0), vec2(0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_fragment.mat3x2', input: 'mat2x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_fragment.mat3x2', input: 'mat2x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_fragment.mat3', input: 'mat3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2]});
ref.push({testName: 'precision.transpose.highp_fragment.mat3', input: 'mat3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.transpose.highp_fragment.mat3x4', input: 'mat4x3(vec3(0.2, 0, 0), vec3(0, 0.2, 0), vec3(0, 0, 0.2), vec3(0, 0, 0)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_fragment.mat3x4', input: 'mat4x3(vec3(0.5, 0, 0), vec3(0, 0.5, 0), vec3(0, 0, 0.5), vec3(0, 0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_fragment.mat4x2', input: 'mat2x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_fragment.mat4x2', input: 'mat2x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_fragment.mat4x3', input: 'mat3x4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_fragment.mat4x3', input: 'mat3x4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0]});
ref.push({testName: 'precision.transpose.highp_fragment.mat4', input: 'mat4(vec4(0.2, 0, 0, 0), vec4(0, 0.2, 0, 0), vec4(0, 0, 0.2, 0), vec4(0, 0, 0, 0.2)), (), (), ()', reference: [false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.2, 0.2]});
ref.push({testName: 'precision.transpose.highp_fragment.mat4', input: 'mat4(vec4(0.5, 0, 0, 0), vec4(0, 0.5, 0, 0), vec4(0, 0, 0.5, 0), vec4(0, 0, 0, 0.5)), (), (), ()', reference: [false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5, false, 0, 0, false, 0, 0, false, 0, 0, false, 0, 0, false, 0.5, 0.5]});
ref.push({testName: 'precision.determinant.lowp_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 0.03125, 0.046875]});
ref.push({testName: 'precision.determinant.lowp_vertex.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 0.25, 0.25]});
ref.push({testName: 'precision.determinant.lowp_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 0.03125, 0.046875]});
ref.push({testName: 'precision.determinant.lowp_fragment.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 0.25, 0.25]});
ref.push({testName: 'precision.determinant.mediump_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.determinant.mediump_vertex.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 0.25, 0.25]});
ref.push({testName: 'precision.determinant.mediump_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 0.039978, 0.0401001]});
ref.push({testName: 'precision.determinant.mediump_fragment.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 0.25, 0.25]});
ref.push({testName: 'precision.determinant.highp_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 0.04, 0.04]});
ref.push({testName: 'precision.determinant.highp_vertex.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 0.25, 0.25]});
ref.push({testName: 'precision.determinant.highp_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 0.04, 0.04]});
ref.push({testName: 'precision.determinant.highp_fragment.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 0.25, 0.25]});
ref.push({testName: 'precision.inverse.lowp_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.inverse.lowp_vertex.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.inverse.lowp_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.inverse.lowp_fragment.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity, false, -Infinity, Infinity]});
ref.push({testName: 'precision.inverse.mediump_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 4.96677, 5.02716, false, -5.96046e-007, 5.96046e-007, false, -5.96046e-007, 5.96046e-007, false, 4.96677, 5.02716]});
ref.push({testName: 'precision.inverse.mediump_vertex.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 1.99512, 2.00488, false, -5.96046e-007, 5.96046e-007, false, -5.96046e-007, 5.96046e-007, false, 1.99512, 2.00488]});
ref.push({testName: 'precision.inverse.mediump_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 4.96677, 5.02716, false, -5.96046e-007, 5.96046e-007, false, -5.96046e-007, 5.96046e-007, false, 4.96677, 5.02716]});
ref.push({testName: 'precision.inverse.mediump_fragment.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 1.99512, 2.00488, false, -5.96046e-007, 5.96046e-007, false, -5.96046e-007, 5.96046e-007, false, 1.99512, 2.00488]});
ref.push({testName: 'precision.inverse.highp_vertex.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 5, 5, false, -2.8026e-045, 2.8026e-045, false, -2.8026e-045, 2.8026e-045, false, 5, 5]});
ref.push({testName: 'precision.inverse.highp_vertex.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 2, 2, false, -2.8026e-045, 2.8026e-045, false, -2.8026e-045, 2.8026e-045, false, 2, 2]});
ref.push({testName: 'precision.inverse.highp_fragment.mat2', input: 'mat2(vec2(0.2, 0), vec2(0, 0.2)), (), (), ()', reference: [false, 5, 5, false, -2.8026e-045, 2.8026e-045, false, -2.8026e-045, 2.8026e-045, false, 5, 5]});
ref.push({testName: 'precision.inverse.highp_fragment.mat2', input: 'mat2(vec2(0.5, 0), vec2(0, 0.5)), (), (), ()', reference: [false, 2, 2, false, -2.8026e-045, 2.8026e-045, false, -2.8026e-045, 2.8026e-045, false, 2, 2]});

    glsBuiltinPrecisionTestsUnitTests.plainArray = function(input) {
        var ret = [];

        if (input instanceof tcuInterval.Interval) {
            var i = 0;
            ret[i] = input.m_hasNaN;
            i++;
            ret[i] = input.m_lo;
            i++;
            ret[i] = input.m_hi;
            return ret;
        }

        if (input instanceof tcuMatrix.Matrix) {
            for (var i = 0, l = 0; i < input.cols; i++)
                for (var j = 0; j < input.rows; j++, l++) {
                    ret[l] = input.matrix[i][j].m_hasNaN;
                    l++;
                    ret[l] = input.matrix[i][j].m_lo;
                    l++;
                    ret[l] = input.matrix[i][j].m_hi;
                }
            return ret;
        }

        if (input instanceof Array) {
            var size = input.length;
            for (var i = 0, j = 0; j < size; j++, i++) {
                ret[i] = input[j].m_hasNaN;
                i++;
                ret[i] = input[j].m_lo;
                i++;
                ret[i] = input[j].m_hi;
            }
            return ret;
        }
        return ret;
    };

    glsBuiltinPrecisionTestsUnitTests.Compare = function(num1, num2, diff) {
        if (isFinite(num1))
            if (Math.abs(Math.abs(num1) - Math.abs(num2)) <= diff)
                return true;
            else
                return false;
        else
            if (isFinite(num2))
                return false;
            else
                return true;
    };

    glsBuiltinPrecisionTestsUnitTests.referenceComparison = function(reference, index, precision) {
        if (index > 1)
            return true;

        var testName = _currentTestName;
        var message1 = '';
        var ref1 = glsBuiltinPrecisionTestsUnitTests.plainArray(reference);
        var a = ref.length;
        var len;
        var ref_len = ref1.length;
        var cpp_nan;
        var ref_nan;
        var ref_lo;
        var ref_hi;
        var cpp_lo;
        var cpp_hi;
        var str;
        var retVal1;
        var retVal2;
        var varfix = Math.max(0.0001, precision.ulp(0, 2));
        var error = false;

        for (var i = 0; i < a; i++) {
            str = ref[i].testName;

            if (testName == str) {
                len = ref[i].reference.length;

                if (len != ref_len)
                    return false;

                for (var j = 0; j < len; j++) {
                    cpp_nan = ref[i + index].reference[j];
                    ref_nan = ref1[j];
                    j++;
                    cpp_lo = ref[i + index].reference[j];
                    ref_lo = ref1[j];
                    j++;
                    cpp_hi = ref[i + index].reference[j];
                    ref_hi = ref1[j];

                    if (ref_nan == cpp_nan) {
                        retVal1 = glsBuiltinPrecisionTestsUnitTests.Compare(ref_lo, cpp_lo, varfix);
                        retVal2 = glsBuiltinPrecisionTestsUnitTests.Compare(ref_hi, ref_hi, varfix);

                        if ((retVal1 != true) || (retVal2 != true)) {
                            message1 = 'Error: ' + varfix;
                            bufferedLogToConsole(message1);
                            message1 = 'C++ Reference values: ' + cpp_nan + ', ' + cpp_lo + ', ' + cpp_hi;
                            bufferedLogToConsole(message1);
                            message1 = 'JS values: ' + ref_nan + ', ' + ref_lo + ', ' + ref_hi;
                            bufferedLogToConsole(message1);
                            error = true;
                        }
                    }
                }
                if (error)
                    return false;
                else
                    return true;
            }
        }
        return true;
    };
});
