// Copyright (C) 2015 André Bargull. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
es6id: 25.4.4.1.2
description: The [[Extensible]] slot of Promise.all Resolve Element functions
info: |
  17 ECMAScript Standard Built-in Objects:
    Unless specified otherwise, the [[Extensible]] internal slot
    of a built-in object initially has the value true.
---*/

var resolveElementFunction;
var thenable = {
  then: function(fulfill) {
    resolveElementFunction = fulfill;
  }
};
function NotPromise(executor) {
  executor(function(){}, function(){});
}
NotPromise.resolve = function(v) { return v; };
Promise.all.call(NotPromise, [thenable]);

assert(Object.isExtensible(resolveElementFunction));

reportCompare(0, 0);
