RabbitMQ `3.10.12` is a maintenance release in the `3.10.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release requires Erlang 24.2 and supports Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

Erlang 23 support has reached its [end of support](https://www.rabbitmq.com/which-erlang.html).

This release of RabbitMQ requires Erlang 24.2 or later versions. Nodes **will fail to start** on older Erlang releases.

Erlang 25 is recommended: it offers much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).

### Core Server

#### Enhancements

 * Quorum queues are now more resilient to WAL log growth with workloads that
   involve clients that register a consumer and then close the channel
   or connection without ever consuming any deliveries or cancelling
   the consumer.

   GitHub issue: [#6447](https://github.com/rabbitmq/rabbitmq-server/issues/6447)

#### Bug Fixes

 * When a node encouters an invalid `definitions.local.file` on boot,
   it will refuse to start instead of ignoring the file.

   GitHub issue: [#2610](https://github.com/rabbitmq/rabbitmq-server/issues/2610)

 * Fixed a type analyzer definition.

   Contributed by @illotum (AWS).

   GitHub issue: [#6401](https://github.com/rabbitmq/rabbitmq-server/pull/6401)


### CLI Tools

#### Enhancements

 * Queue info keys now support more inclusive property names related
   to (deprecated) classic mirrored queues. For example, `mirror_pids`
   can now be used instead of `slave_pids`.

   Contributed by @illotum (AWS).

   GitHub issue: [#2635](https://github.com/rabbitmq/rabbitmq-server/issues/2635)

 * `rabbitmq-diagnostics memory_breakdown` now executes significantly faster
   in environments with a large number (say, tens or hundreds of thousands) of
   quorum queues. Two orders of magnitude faster, in fact.

   GitHub issue: [#6388](https://github.com/rabbitmq/rabbitmq-server/issues/6388)

#### Bug Fixes

 * Definition export in JSON failed on nodes that used `definitions.skip_if_unchanged`.

   GitHub issue: [#6424](https://github.com/rabbitmq/rabbitmq-server/issues/6424)

 * Using quorum queue-specific commands on streams now results in clearer error messages.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#6488](https://github.com/rabbitmq/rabbitmq-server/pull/6488)


### LDAP Plugin

#### Bug Fixes

 * LDAP server password could end up in the logs in certain types of exceptions.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#4842](https://github.com/rabbitmq/rabbitmq-server/issues/4842)


### STOMP Plugin

#### Enhancements

  * `x-max-age` [stream setting](https://rabbitmq.com/streams.html) now can be set
    by STOMP clients via a header.

    GitHub issue: [#5003](https://github.com/rabbitmq/rabbitmq-server/issues/5003)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.12.tar.xz`
instead of the source tarball produced by GitHub.
