RabbitMQ `3.10.6` is a maintenance release in the `3.10.x` release series.

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release requires at least Erlang 23.2, and supports Erlang 24 and 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).


### Core Server

#### Enhancements

 * Stream metric collection is now more CPU efficient. It helps in environments that
   have many streams.

   GitHub issue: [#4950](https://github.com/rabbitmq/rabbitmq-server/pull/4950)

 * Optimization: internal message GUID is no longer generated for quorum queues and streams, as they
   are specific to classic queues.

   GitHub issue: [#4990](https://github.com/rabbitmq/rabbitmq-server/pull/4990)

 * Two more AMQP 1.0 connection lifecycle events are now logged.

   GitHub issue: [#4982](https://github.com/rabbitmq/rabbitmq-server/pull/4982)

 * CRC32 checksum verification now can be disabled for quorum queues:

   ```
   quorum_queue.compute_checksums = false
   ```

   This may be beneficial in environments that messages are large and CPU resources
   are limited. Note the CRC32 checksums are not the only data corruption detection
   mechanism used by quorum queues but they are good at catching certain types of corruption.

   Disabling checksums can provide quorum queue throughput boost of up to 15%.
   In environments where message size is small the gains will be smaller.

   GitHub issue: [#5166](https://github.com/rabbitmq/rabbitmq-server/pull/5166)

 * TLS configuration for inter-node stream replication connections now can
   use function references and definitions.

   GitHub issue: [#4991](https://github.com/rabbitmq/rabbitmq-server/pull/4991)

 * Stream protocol connection logging is now less verbose.

   GitHub issue: [#5037](https://github.com/rabbitmq/rabbitmq-server/pull/5037)

 * Max stream segment size is now limited to 3 GiB to avoid a potential stream position overflow.

   GitHub issue: [#5020](https://github.com/rabbitmq/rabbitmq-server/pull/5020)

 * Stream coordinator warnings now include operation name for clarify.

   GitHub issue: [#5036](https://github.com/rabbitmq/rabbitmq-server/pull/5036)

 * Logging messages that use microseconds now use "us" for the SI symbol to be compatible with more
   tools.

   GitHub issue: [#5125](https://github.com/rabbitmq/rabbitmq-server/pull/5125)

#### Bug Fixes

 * Channels on connections to mixed clusters that had 3.8 nodes in them could run into
   an exception.

   GitHub issue: [#5141](https://github.com/rabbitmq/rabbitmq-server/issues/5141)

 * Inter-node cluster link statistics did not have any data when TLS was enabled for them.

   GitHub issue: [#4981](https://github.com/rabbitmq/rabbitmq-server/issues/4981)

 * Quorum queues now correctly propagate errors when a `basic.get` (polling consumption) operation hits
   a timeout.

   Contributed by Ayanda @Ayanda-D Dube.

   GitHub issue: [#5107](https://github.com/rabbitmq/rabbitmq-server/pull/5107)

 * Stream consumer that used AMQP 0-9-1 instead of a stream protocol client, and disconnected,
   leaked a file handle.

   GitHub issue: [#5085](https://github.com/rabbitmq/rabbitmq-server/pull/5085)

 * Max frame size and client heartbeat parameters for [RabbitMQ stream]() clients were not correctly
   set when taken from `rabbitmq.conf`.

   GitHub issue: [#5131](https://github.com/rabbitmq/rabbitmq-server/pull/5131)

 * Removed a duplicate exchange decorator set operation.

   Contributed by Péter @gomoripeti Gömöri.

   GitHub issue: [#4962](https://github.com/rabbitmq/rabbitmq-server/pull/4962)


### Consistent Hashing Exchange Plugin

#### Bug Fixes

 * Node restarts could result in a hashing ring inconsistency.

   This required a **potentially breaking change**: this exchange type
   now only allows for **one binding between an exchange and a queue** (or another exchange).
   All subsequent binding operations between them will be ignored, so "first write wins".

   This is a natural topology for this plugin, and enforcing it helps avoid a set of
   potential issues with concurrent node restarts and client operations that affect
   consistent hash ring state.

   GitHub issue: [#3386](https://github.com/rabbitmq/rabbitmq-server/issues/3386)


### Consul Peer Discovery Plugin

#### Enhancements

 * Consul peer discovery now supports client-side TLS options, much like its Kubernetes and etcd peers.

   ``` ini
   cluster_formation.consul.scheme = https
   # this assumes that Consul uses port 8501 for HTTPS clients
   cluster_formation.consul.port = 8501

   cluster_formation.consul.ssl_options.cacertfile = /path/to/consul/generated/ca_certificate.pem
   cluster_formation.consul.ssl_options.certfile = /path/to/client/certificate.pem
   cluster_formation.consul.ssl_options.keyfile = /path/to/client/client_key.pem
   ```

   GitHub issue: [#5116](https://github.com/rabbitmq/rabbitmq-server/issues/5116)


## Dependency Upgrades

 *  `ra` upgraded from [`2.0.13` to `2.2.0`](https://github.com/rabbitmq/ra/compare/v2.0.13...v2.2.0)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.6.tar.xz`
instead of the source tarball produced by GitHub.
