RabbitMQ `3.12.14` is a maintenance release in the `3.12.x` [release series](https://www.rabbitmq.com/versions.html).

This release [goes out of community support](https://www.rabbitmq.com/release-information) on June 1st, 2024.

Please refer to the upgrade section from the [3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0)
if upgrading from a version prior to 3.12.0.

This release requires Erlang 25 and supports Erlang versions up to `26.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.12.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.11.x (or older releases) on Erlang 25 to 3.12.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.12.x/release-notes).

### Core Broker

#### Bug Fixes

 * Quorum queues are now more defensive when acquiring file handles.

   GitHub issue: [#10587](https://github.com/rabbitmq/rabbitmq-server/pull/10587)

#### Enhancements

 * There is now a way to configure default queue type globally (that is, not per virtual host)
   in `rabbitmq.conf`:

   ``` ini
   # Built-in type aliases are "quorum", "classic", "stream"
   default_queue_type = quorum
   ```

   Contributed by @SimonUnge.

   GitHub issue: [#11165](https://github.com/rabbitmq/rabbitmq-server/pull/11165)


 * `channel_max_per_node` is a new per-node limit that allows to put a cap on the number
   of AMQP 0-9-1 channels that can be concurrently open by all clients connected to a node:

   ``` ini
   # rabbitmq.conf
   channel_max_per_node = 5000
   ```

   This is a guardrail mean to protect nodes from [application-level channel leaks](https://www.rabbitmq.com/docs/channels#channel-leaks).

   Contributed by @illotum.

   GitHub issue: [#10754](https://github.com/rabbitmq/rabbitmq-server/pull/10754)

 * [Definition import](https://www.rabbitmq.com/docs/definitions) did not handle a scenario where some virtual hosts did not have
   the default queue type metadata key set.

   GitHub issue: [#10897](https://github.com/rabbitmq/rabbitmq-server/pull/10897)


### AMQP 1.0 Plugin

#### Bug Fixes

 * Safer AMQP 1.0 => AMQP 0-9-1 message durability property conversion.

   GitHub issue: [#10568](https://github.com/rabbitmq/rabbitmq-server/pull/10568)


### Management Plugin

#### Bug Fixes

 * When a tab (Connections, Queues and Streams, etc) is switched, a table configuration pane
   from the previously selected tab is now hidden.

   Contributed by @ackepenek.

   GitHub issue: [#10799](https://github.com/rabbitmq/rabbitmq-server/pull/10799)


### JMS Topic Exchange Plugin

#### Enhancements

  * The plugin now stores its state on multiple nodes.

    GitHub issue: [#11098](https://github.com/rabbitmq/rabbitmq-server/pull/11098)


### Dependency Changes

 * `cowboy` was updated to [`2.12.0`](https://ninenines.eu/docs/en/cowboy/2.12/guide/migrating_from_2.11/)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.12.14.tar.xz`
instead of the source tarball produced by GitHub.
