RabbitMQ `3.12.4` is a maintenance release in the `3.12.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from the [3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0)
if upgrading from a version prior to 3.12.0.

This release requires Erlang 25 and supports Erlang versions up to `26.0.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.12.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.11.x (or older releases) on Erlang 25 to 3.12.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.12.x/release-notes).

### Core Server

#### Bug Fixes

 * Consumer churn on quorum queues could result in some messages not being delivered
   to consumers in certain cases. This mostly affected queue federation links.
   
   GitHub issue: [#9151](https://github.com/rabbitmq/rabbitmq-server/issues/9151)


### Management Plugin

#### Bug Fixes

 * Quorum queue replica management operations over the HTTP API now can be
   disabled. This can be useful in environments where replica management
   is done by the platform team and tooling, and should not be exposed to
   cluster users.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#9151](https://github.com/rabbitmq/rabbitmq-server/pull/9151)


### Federation Plugin

#### Bug Fixes

 * Queue federation links that connected quorum queues could get stuck
   (stop transferring messages even when there were no other consumers on the upstream).

   GitHub issue: [#9158](https://github.com/rabbitmq/rabbitmq-server/pull/9158)


### LDAP AuthN/AuthZ Backend Plugin

#### Bug Fixes

 * LDAP plugin did not interpolate values with non-ASCII characters correctly.

   GitHub issue: [#9059](https://github.com/rabbitmq/rabbitmq-server/issues/9059)


## Dependency Upgrades

None in this release.

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.12.4.tar.xz`
instead of the source tarball produced by GitHub.
