RabbitMQ `3.12.6` is a maintenance release in the `3.12.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from the [3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0)
if upgrading from a version prior to 3.12.0.

This release requires Erlang 25 and supports Erlang versions up to `26.1.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.12.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.11.x (or older releases) on Erlang 25 to 3.12.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.12.x/release-notes).


### Core Server

#### Bug Fixes

 * `3.12.5` unintentionally shipped with a `seshat` version older than `0.6.1`. This can potentially
   result in an incompatibility with the stream subsystem.

   GitHub issue: [#9499](https://github.com/rabbitmq/rabbitmq-server/pull/9499)

#### Enhancements

 * Improved forward compatibility of classic queues with 3.13.

   GitHub issue: [#9508](https://github.com/rabbitmq/rabbitmq-server/pull/9508)


## Dependency Upgrades

 * `seshat` was upgraded to [`0.6.1`](https://github.com/rabbitmq/seshat/tags)


## Dependency Upgrades

None in this release.

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.12.6.tar.xz`
instead of the source tarball produced by GitHub.
