## RabbitMQ 3.7.27

RabbitMQ `3.7.27` is a maintenance release. It contains a couple of backports
from the `3.8.x` branch.

RabbitMQ `3.7.x` series are out of general support and covered by the [limited extended support policy](https://www.rabbitmq.com/versions.html) only.

Please consider [upgrading](https://www.rabbitmq.com/upgrade.html) to [RabbitMQ `3.8.x`](https://www.rabbitmq.com/changelog.html).

### Erlang/OTP Compatibility Notes

This release [**no longer supports Erlang/OTP 20.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Erlang `21.3+` is now a **hard requirement** checked on node startup.

Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.
[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Enhancements

 * More peer discovery errors are retried.

   GitHub issue: [rabbitmq/rabbitmq-server#1627](https://github.com/rabbitmq/rabbitmq-server/issues/1627)

 * Initial Erlang/OTP 24 compatibility.

   Erlang/OTP 24 is expected to ship in mid-2021. While RabbitMQ 3.7 will be [out of support](https://www.rabbitmq.com/versions.html) by then,
   some initial compatibility work was backported to this branch due to contious integration on Erlang/OTP master.

### Federation Plugin

#### Bug Fixes

 * One-off connections periodically used by exchange federation links now handle timeouts in certain
   operations gracefully. This avoids unnecessary link disruption and restarts in certain environments.
   The default interval has also been bumped from 30s to 90s.

   In environments with stable topologies the interval can be significantly increased to decrease connection
   churn, simplify monitoring and in general conserve some resources:

   ``` erlang
   %% advanced.config
   [
    {rabbitmq_federation, [
        %% 86400 seconds or 24 hours
        {internal_exchange_check_interval, 86400000}
    ]}
   ].
   ```

   GitHub issue: [rabbitmq/rabbitmq-federation#107](https://github.com/rabbitmq/rabbitmq-federation/pull/107)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.27.tar.xz`.
