## RabbitMQ 3.7.6

RabbitMQ `3.7.6` a maintenance release that primarily includes bug fixes.

### Upgrades and Compatibility

This release includes one **potential incompatibility** with earlier `3.7.x` releases. Only systems
that use a high number (hundreds) of [queue priorities](https://www.rabbitmq.com/priority.html) are affected.

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade and compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades.

See [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.


## Changes

### Core Server

#### Bug Fixes

 * Max priority cap for queues is now enforced and set to 255. Applications that rely on a higher number of priorities **will break**.
   Such applications must be updated to use no more than 255 priorities.

   GitHub issue: [rabbitmq-server#1590](https://github.com/rabbitmq/rabbitmq-server/issues/1590)

 * Bulk deletion of exclusive queues when their owning connection closes has been optimized.

   GitHub issues: [rabbitmq/rabbitmq-server#1566](https://github.com/rabbitmq/rabbitmq-server/issues/1566), [rabbitmq/rabbitmq-server#1513](https://github.com/rabbitmq/rabbitmq-server/issues/1513)


#### Enhancements

 * On Erlang 20.2.3 or later, more optimal memory allocators will be used. On some workloads that leads
   to [significant reduction in node's RAM consumption](https://groups.google.com/d/msg/rabbitmq-users/LSYaac9frYw/LNZDZUlrBAAJ). The change is workload-specific, however, on the workloads
   tested that do introduce a negative effect (more RAM used) the difference was very small (about 1%).
   

   It is possible to go back to the previous settings, `+MBas aoffcbf +MHas aoffcbf +MBlmbcs 5120 +MHlmbcs 5120 +MMmcs 10`,
   by specifying them in the `RABBITMQ_SERVER_ADDITIONAL_ERL_ARGS` [environment variable](https://www.rabbitmq.com/configure.html#customise-environment).

   On Erlang/OTP releases older than 20.2.3 there will be no default changes.

   GitHub issue: [rabbitmq/rabbitmq-server#1604](https://github.com/rabbitmq/rabbitmq-server/pull/1604)

 * [Logging to Syslog](https://www.rabbitmq.com/logging.html#logging-to-syslog) without 3rd party plugins.
 
   GitHub issue: [rabbitmq-server#1600](https://github.com/rabbitmq/rabbitmq-server/pull/1600)

 * `connection.closed` events now include client-provided connection name and more client details.
   That information is in turn available via the [rabbitmq_event_exchange](https://github.com/rabbitmq/rabbitmq-event-exchange).

   GitHub issue: [rabbitmq-server#1596](https://github.com/rabbitmq/rabbitmq-server/issues/1596)


### CLI Tools

#### Enhancements

 * `await_online_nodes <count> [--timeout <timeout>]` is a new command that will wait until the target
   node's cluster has at least `<count>` nodes. The command supports a timeout. It is meant to simplify
   cluster provisioning automation and can be used as the very first check performed after starting a node.

   Note that the command requires at least one node to be running and reachable.

   GitHub issue: [rabbitmq-cli#235](https://github.com/rabbitmq/rabbitmq-cli/issues/235)

 * `rabbitmq-diagnostics ping [--node <target> --timeout <timeout>]` is a new minimalistic health check command.
   It only verifies if the target node is up, registered with epmd and accepts/authenticates CLI tool connections.
   It fills the gap between `rabbitmq-diagnostics node_health_check`, which performs a lot of checks, take a lot more time
   and is fairly opinionated in what it does. `ping` is more suitable in environments where
   failing aliveness checks will result in node restarts, namely Kubernetes.

   GitHub issue: [rabbitmq-cli#253](https://github.com/rabbitmq/rabbitmq-cli/issues/253)


### Management and Management Agent Plugins

#### Bug Fixes

 * Queue metrics could be missing after a node restart or plugin [re-]enablement.

   GitHub issue: [rabbitmq/rabbitmq-management-agent#58](https://github.com/rabbitmq/rabbitmq-management-agent/issues/58)

 * `rabbitmqadmin` now correctly percent-encodes spaces in connection names.

   GitHub issue: [rabbitmq/rabbitmq-management#576](https://github.com/rabbitmq/rabbitmq-management/issues/576)

 * When creating a new vhost, user permissions will only be granted to the users that exist in the
   internal database. If an external authentication/authorisation service is used, the step is skipped.

   GitHub issue: [rabbitmq-management#531](https://github.com/rabbitmq/rabbitmq-management/issues/531)

 * Virtual host imported from definitions or created via HTTP API will explicitly await for the vhost to initialise
   on all cluster nodes.

   GitHub issue: [rabbitmq/rabbitmq-management#575](https://github.com/rabbitmq/rabbitmq-management/issues/575)


### LDAP Plugin

#### Bug Fixes

 * LDAP connection pool now correctly purges connections in more failure scenarios (e.g. LDAP server restart)

   GitHub issue: [rabbitmq-auth-backend-ldap#92](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/92)


### HTTP Authentication/authorisation Plugin

#### Enhancements

 * `201 Created` responses are now accepted from HTTP services that back the plugin.

   GitHub issue: [rabbitmq-auth-backend-http#68](https://github.com/rabbitmq/rabbitmq-auth-backend-http/pull/68)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.7.6.tar.gz`.
