// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/texttospeech/v1/cloud_tts_lrs.proto

package texttospeechpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	TextToSpeechLongAudioSynthesize_SynthesizeLongAudio_FullMethodName = "/google.cloud.texttospeech.v1.TextToSpeechLongAudioSynthesize/SynthesizeLongAudio"
)

// TextToSpeechLongAudioSynthesizeClient is the client API for TextToSpeechLongAudioSynthesize service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TextToSpeechLongAudioSynthesizeClient interface {
	// Synthesizes long form text asynchronously.
	SynthesizeLongAudio(ctx context.Context, in *SynthesizeLongAudioRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type textToSpeechLongAudioSynthesizeClient struct {
	cc grpc.ClientConnInterface
}

func NewTextToSpeechLongAudioSynthesizeClient(cc grpc.ClientConnInterface) TextToSpeechLongAudioSynthesizeClient {
	return &textToSpeechLongAudioSynthesizeClient{cc}
}

func (c *textToSpeechLongAudioSynthesizeClient) SynthesizeLongAudio(ctx context.Context, in *SynthesizeLongAudioRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TextToSpeechLongAudioSynthesize_SynthesizeLongAudio_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TextToSpeechLongAudioSynthesizeServer is the server API for TextToSpeechLongAudioSynthesize service.
// All implementations should embed UnimplementedTextToSpeechLongAudioSynthesizeServer
// for forward compatibility
type TextToSpeechLongAudioSynthesizeServer interface {
	// Synthesizes long form text asynchronously.
	SynthesizeLongAudio(context.Context, *SynthesizeLongAudioRequest) (*longrunningpb.Operation, error)
}

// UnimplementedTextToSpeechLongAudioSynthesizeServer should be embedded to have forward compatible implementations.
type UnimplementedTextToSpeechLongAudioSynthesizeServer struct {
}

func (UnimplementedTextToSpeechLongAudioSynthesizeServer) SynthesizeLongAudio(context.Context, *SynthesizeLongAudioRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SynthesizeLongAudio not implemented")
}

// UnsafeTextToSpeechLongAudioSynthesizeServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TextToSpeechLongAudioSynthesizeServer will
// result in compilation errors.
type UnsafeTextToSpeechLongAudioSynthesizeServer interface {
	mustEmbedUnimplementedTextToSpeechLongAudioSynthesizeServer()
}

func RegisterTextToSpeechLongAudioSynthesizeServer(s grpc.ServiceRegistrar, srv TextToSpeechLongAudioSynthesizeServer) {
	s.RegisterService(&TextToSpeechLongAudioSynthesize_ServiceDesc, srv)
}

func _TextToSpeechLongAudioSynthesize_SynthesizeLongAudio_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SynthesizeLongAudioRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TextToSpeechLongAudioSynthesizeServer).SynthesizeLongAudio(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TextToSpeechLongAudioSynthesize_SynthesizeLongAudio_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TextToSpeechLongAudioSynthesizeServer).SynthesizeLongAudio(ctx, req.(*SynthesizeLongAudioRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// TextToSpeechLongAudioSynthesize_ServiceDesc is the grpc.ServiceDesc for TextToSpeechLongAudioSynthesize service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TextToSpeechLongAudioSynthesize_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.texttospeech.v1.TextToSpeechLongAudioSynthesize",
	HandlerType: (*TextToSpeechLongAudioSynthesizeServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SynthesizeLongAudio",
			Handler:    _TextToSpeechLongAudioSynthesize_SynthesizeLongAudio_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/texttospeech/v1/cloud_tts_lrs.proto",
}
