// This file was AUTOMATICALLY GENERATED by kilt-import (smuggol) from github.com/robertkrimen/kilt

package kilt

import (
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
)

// WriteAtomicFile
func (self Kilt) WriteAtomicFile(filename string, data io.Reader, mode os.FileMode) error {
	return WriteAtomicFile(filename, data, mode)
}

func WriteAtomicFile(filename string, data io.Reader, mode os.FileMode) error {
	parent := filepath.Dir(filename)
	tmp, err := ioutil.TempDir(parent, ".tmp.")
	if err != nil {
		return err
	}
	if len(parent) >= len(tmp) { // Should never, ever happen
		return (fmt.Errorf("%s < %s", tmp, parent))
	}
	defer os.RemoveAll(tmp)

	tmpname := filepath.Join(tmp, filepath.Base(filename))
	file, err := os.OpenFile(tmpname, os.O_WRONLY|os.O_CREATE|os.O_TRUNC, mode)
	if err != nil {
		return err
	}
	defer file.Close()

	_, err = io.Copy(file, data)
	if err != nil {
		return err
	}

	return os.Rename(tmpname, filename)
}
