// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// AllocatableResourcesResponse allocatable resources response
//
// swagger:model allocatableResourcesResponse
type AllocatableResourcesResponse struct {

	// cpu priority
	CPUPriority *NodeMaxAllocatableResources `json:"cpu_priority,omitempty"`

	// mem priority
	MemPriority *NodeMaxAllocatableResources `json:"mem_priority,omitempty"`

	// min allocatable cpu
	MinAllocatableCPU int64 `json:"min_allocatable_cpu,omitempty"`

	// min allocatable mem
	MinAllocatableMem int64 `json:"min_allocatable_mem,omitempty"`
}

// Validate validates this allocatable resources response
func (m *AllocatableResourcesResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCPUPriority(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMemPriority(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AllocatableResourcesResponse) validateCPUPriority(formats strfmt.Registry) error {
	if swag.IsZero(m.CPUPriority) { // not required
		return nil
	}

	if m.CPUPriority != nil {
		if err := m.CPUPriority.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cpu_priority")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cpu_priority")
			}
			return err
		}
	}

	return nil
}

func (m *AllocatableResourcesResponse) validateMemPriority(formats strfmt.Registry) error {
	if swag.IsZero(m.MemPriority) { // not required
		return nil
	}

	if m.MemPriority != nil {
		if err := m.MemPriority.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mem_priority")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("mem_priority")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this allocatable resources response based on the context it is used
func (m *AllocatableResourcesResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCPUPriority(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMemPriority(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AllocatableResourcesResponse) contextValidateCPUPriority(ctx context.Context, formats strfmt.Registry) error {

	if m.CPUPriority != nil {
		if err := m.CPUPriority.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cpu_priority")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cpu_priority")
			}
			return err
		}
	}

	return nil
}

func (m *AllocatableResourcesResponse) contextValidateMemPriority(ctx context.Context, formats strfmt.Registry) error {

	if m.MemPriority != nil {
		if err := m.MemPriority.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mem_priority")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("mem_priority")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AllocatableResourcesResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AllocatableResourcesResponse) UnmarshalBinary(b []byte) error {
	var res AllocatableResourcesResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
