// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ListExternalBucketsParams list external buckets params
//
// swagger:model listExternalBucketsParams
type ListExternalBucketsParams struct {

	// access key
	// Required: true
	// Min Length: 3
	AccessKey *string `json:"accessKey"`

	// region
	Region string `json:"region,omitempty"`

	// secret key
	// Required: true
	// Min Length: 8
	SecretKey *string `json:"secretKey"`

	// target URL
	// Required: true
	TargetURL *string `json:"targetURL"`

	// use TLS
	// Required: true
	UseTLS *bool `json:"useTLS"`
}

// Validate validates this list external buckets params
func (m *ListExternalBucketsParams) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccessKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecretKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTargetURL(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUseTLS(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ListExternalBucketsParams) validateAccessKey(formats strfmt.Registry) error {

	if err := validate.Required("accessKey", "body", m.AccessKey); err != nil {
		return err
	}

	if err := validate.MinLength("accessKey", "body", *m.AccessKey, 3); err != nil {
		return err
	}

	return nil
}

func (m *ListExternalBucketsParams) validateSecretKey(formats strfmt.Registry) error {

	if err := validate.Required("secretKey", "body", m.SecretKey); err != nil {
		return err
	}

	if err := validate.MinLength("secretKey", "body", *m.SecretKey, 8); err != nil {
		return err
	}

	return nil
}

func (m *ListExternalBucketsParams) validateTargetURL(formats strfmt.Registry) error {

	if err := validate.Required("targetURL", "body", m.TargetURL); err != nil {
		return err
	}

	return nil
}

func (m *ListExternalBucketsParams) validateUseTLS(formats strfmt.Registry) error {

	if err := validate.Required("useTLS", "body", m.UseTLS); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this list external buckets params based on context it is used
func (m *ListExternalBucketsParams) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ListExternalBucketsParams) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ListExternalBucketsParams) UnmarshalBinary(b []byte) error {
	var res ListExternalBucketsParams
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
