// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package operatorapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http",
    "ws"
  ],
  "swagger": "2.0",
  "info": {
    "title": "MinIO Console Server",
    "version": "0.1.0"
  },
  "basePath": "/api/v1",
  "paths": {
    "/check-version": {
      "get": {
        "security": [],
        "tags": [
          "UserAPI"
        ],
        "summary": "Checks the current Operator version against the latest",
        "operationId": "CheckMinIOVersion”",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/checkOperatorVersionResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/cluster/allocatable-resources": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get allocatable cpu and memory for given number of nodes",
        "operationId": "GetAllocatableResources",
        "parameters": [
          {
            "minimum": 1,
            "type": "integer",
            "format": "int32",
            "name": "num_nodes",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/allocatableResourcesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/cluster/max-allocatable-memory": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get maximum allocatable memory for given number of nodes",
        "operationId": "GetMaxAllocatableMem",
        "parameters": [
          {
            "minimum": 1,
            "type": "integer",
            "format": "int32",
            "name": "num_nodes",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/maxAllocatableMemResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/directpv/drives": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get directpv drives list",
        "operationId": "GetDirectPVDriveList",
        "parameters": [
          {
            "type": "string",
            "name": "nodes",
            "in": "query"
          },
          {
            "type": "string",
            "name": "drives",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/getDirectPVDriveListResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/directpv/drives/format": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Format directpv drives from a list",
        "operationId": "DirectPVFormatDrive",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/formatConfiguration"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/formatDirectPVDrivesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/directpv/volumes": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get directpv volumes list",
        "operationId": "GetDirectPVVolumeList",
        "parameters": [
          {
            "type": "string",
            "name": "nodes",
            "in": "query"
          },
          {
            "type": "string",
            "name": "drives",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/getDirectPVVolumeListResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/get-parity/{nodes}/{disksPerNode}": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Gets parity by sending number of nodes \u0026 number of disks",
        "operationId": "GetParity",
        "parameters": [
          {
            "minimum": 2,
            "type": "integer",
            "name": "nodes",
            "in": "path",
            "required": true
          },
          {
            "minimum": 1,
            "type": "integer",
            "name": "disksPerNode",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/parityResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/list-pvcs": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "List all PVCs from namespaces that the user has access to",
        "operationId": "ListPVCs",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listPVCsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/login": {
      "get": {
        "security": [],
        "tags": [
          "Auth"
        ],
        "summary": "Returns login strategy, form or sso.",
        "operationId": "LoginDetail",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/loginDetails"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/login/oauth2/auth": {
      "post": {
        "security": [],
        "tags": [
          "Auth"
        ],
        "summary": "Identity Provider oauth2 callback endpoint.",
        "operationId": "LoginOauth2Auth",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/loginOauth2AuthRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful login."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/login/operator": {
      "post": {
        "security": [],
        "tags": [
          "Auth"
        ],
        "summary": "Login to Operator Console.",
        "operationId": "LoginOperator",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/loginOperatorRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful login."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/logout": {
      "post": {
        "tags": [
          "Auth"
        ],
        "summary": "Logout from Operator.",
        "operationId": "Logout",
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/mp-integration": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Returns email registered for marketplace integration",
        "operationId": "GetMPIntegration",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "object",
              "properties": {
                "isEmailSet": {
                  "type": "boolean"
                }
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Set email to register for marketplace integration",
        "operationId": "PostMPIntegration",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/mpIntegration"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespace": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Creates a new Namespace with given information",
        "operationId": "CreateNamespace",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/namespace"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/resourcequotas/{resource-quota-name}": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Resource Quota",
        "operationId": "GetResourceQuota",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "resource-quota-name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/resourceQuota"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "List Tenants by Namespace",
        "operationId": "ListTenants",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "sort_by",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int32",
            "name": "offset",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int32",
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listTenantsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Details",
        "operationId": "TenantDetails",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenant"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Update Tenant",
        "operationId": "UpdateTenant",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateTenantRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Delete tenant and underlying pvcs",
        "operationId": "DeleteTenant",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/deleteTenantRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/certificates": {
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Update Certificates",
        "operationId": "TenantUpdateCertificate",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tlsConfiguration"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/configuration": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Configuration",
        "operationId": "TenantConfiguration",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenantConfigurationResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Update Tenant Configuration",
        "operationId": "UpdateTenantConfiguration",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateTenantConfigurationRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/csr": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "List Tenant Certificate Signing Request",
        "operationId": "ListTenantCertificateSigningRequest",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/csrElements"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/disable-logging": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Disable Tenant Logging",
        "operationId": "DisableTenantLogging",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "boolean"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/domains": {
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Update Domains for a Tenant",
        "operationId": "UpdateTenantDomains",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateDomainsRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/enable-logging": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Enable Tenant Logging",
        "operationId": "EnableTenantLogging",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "boolean"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/encryption": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Encryption Info",
        "operationId": "TenantEncryptionInfo",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/encryptionConfigurationResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Update Encryption",
        "operationId": "TenantUpdateEncryption",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/encryptionConfiguration"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Delete Encryption",
        "operationId": "TenantDeleteEncryption",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/events": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Events for given Tenant",
        "operationId": "GetTenantEvents",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/eventListWrapper"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/identity-provider": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Identity Provider",
        "operationId": "TenantIdentityProvider",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/idpConfiguration"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Update Tenant Identity Provider",
        "operationId": "UpdateTenantIdentityProvider",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/idpConfiguration"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/log": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Tenant Logs",
        "operationId": "GetTenantLogs",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenantLogs"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Set Tenant Logs",
        "operationId": "SetTenantLogs",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tenantLogs"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "boolean"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/monitoring": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Prometheus Monitoring config info For The Tenant",
        "operationId": "GetTenantMonitoring",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenantMonitoringInfo"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Set Prometheus monitoring fields for tenant",
        "operationId": "SetTenantMonitoring",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tenantMonitoringInfo"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pods": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Pods For The Tenant",
        "operationId": "GetTenantPods",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/tenantPod"
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pods/{podName}": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Logs for Pod",
        "operationId": "GetPodLogs",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "podName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "string"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Delete pod",
        "operationId": "DeletePod",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "podName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pods/{podName}/describe": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Describe Pod",
        "operationId": "DescribePod",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "podName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/describePodWrapper"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pods/{podName}/events": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Events for Pod",
        "operationId": "GetPodEvents",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "podName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/eventListWrapper"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pools": {
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Update Pools",
        "operationId": "TenantUpdatePools",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/poolUpdateRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenant"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Add Pool",
        "operationId": "TenantAddPool",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/pool"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pvc/{PVCName}": {
      "delete": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Delete PVC",
        "operationId": "DeletePVC",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "PVCName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pvcs": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "List all PVCs from given Tenant",
        "operationId": "ListPVCsForTenant",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listPVCsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pvcs/{PVCName}/describe": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Describe output for PVC",
        "operationId": "GetPVCDescribe",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "PVCName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/describePVCWrapper"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pvcs/{PVCName}/events": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Events for PVC",
        "operationId": "GetPVCEvents",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "PVCName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/eventListWrapper"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/security": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Security",
        "operationId": "TenantSecurity",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenantSecurityResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Update Tenant Security",
        "operationId": "UpdateTenantSecurity",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateTenantSecurityRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/set-administrators": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Set the consoleAdmin policy to the specified users and groups",
        "operationId": "SetTenantAdministrators",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setAdministratorsRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/usage": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Usage For The Tenant",
        "operationId": "GetTenantUsage",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenantUsage"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/yaml": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get the Tenant YAML",
        "operationId": "GetTenantYAML",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenantYAML"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Put the Tenant YAML",
        "operationId": "PutTenantYAML",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tenantYAML"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/nodes/labels": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "List node labels",
        "operationId": "ListNodeLabels",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/nodeLabels"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/session": {
      "get": {
        "tags": [
          "Auth"
        ],
        "summary": "Endpoint to check if your session is still valid",
        "operationId": "SessionCheck",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/operatorSessionResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subnet/apikey": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Subnet api key",
        "operationId": "OperatorSubnetApiKey",
        "parameters": [
          {
            "type": "string",
            "name": "token",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/operatorSubnetAPIKey"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subnet/apikey/info": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Subnet API key info",
        "operationId": "OperatorSubnetAPIKeyInfo",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/operatorSubnetRegisterAPIKeyResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subnet/apikey/register": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Register Operator with Subnet",
        "operationId": "OperatorSubnetRegisterAPIKey",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/operatorSubnetAPIKey"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/operatorSubnetRegisterAPIKeyResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subnet/login": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Login to subnet",
        "operationId": "OperatorSubnetLogin",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/operatorSubnetLoginRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/operatorSubnetLoginResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subnet/login/mfa": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Login to subnet using mfa",
        "operationId": "OperatorSubnetLoginMFA",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/operatorSubnetLoginMFARequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/operatorSubnetLoginResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subscription/info": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Subscription info",
        "operationId": "SubscriptionInfo",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/license"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subscription/namespaces/{namespace}/tenants/{tenant}/activate": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Activate a particular tenant using the existing subscription license",
        "operationId": "SubscriptionActivate",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subscription/refresh": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Refresh existing subscription license",
        "operationId": "SubscriptionRefresh",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/license"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subscription/validate": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Validates subscription license",
        "operationId": "SubscriptionValidate",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/subscriptionValidateRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/license"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/tenants": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "List Tenant of All Namespaces",
        "operationId": "ListAllTenants",
        "parameters": [
          {
            "type": "string",
            "name": "sort_by",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int32",
            "name": "offset",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int32",
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listTenantsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Create Tenant",
        "operationId": "CreateTenant",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/createTenantRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/createTenantResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "allocatableResourcesResponse": {
      "type": "object",
      "properties": {
        "cpu_priority": {
          "$ref": "#/definitions/nodeMaxAllocatableResources"
        },
        "mem_priority": {
          "$ref": "#/definitions/nodeMaxAllocatableResources"
        },
        "min_allocatable_cpu": {
          "type": "integer",
          "format": "int64"
        },
        "min_allocatable_mem": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "annotation": {
      "type": "object",
      "properties": {
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "awsConfiguration": {
      "type": "object",
      "required": [
        "secretsmanager"
      ],
      "properties": {
        "secretsmanager": {
          "type": "object",
          "required": [
            "endpoint",
            "region",
            "credentials"
          ],
          "properties": {
            "credentials": {
              "type": "object",
              "required": [
                "accesskey",
                "secretkey"
              ],
              "properties": {
                "accesskey": {
                  "type": "string"
                },
                "secretkey": {
                  "type": "string"
                },
                "token": {
                  "type": "string"
                }
              }
            },
            "endpoint": {
              "type": "string"
            },
            "kmskey": {
              "type": "string"
            },
            "region": {
              "type": "string"
            }
          }
        }
      }
    },
    "azureConfiguration": {
      "type": "object",
      "required": [
        "keyvault"
      ],
      "properties": {
        "keyvault": {
          "type": "object",
          "required": [
            "endpoint"
          ],
          "properties": {
            "credentials": {
              "type": "object",
              "required": [
                "tenant_id",
                "client_id",
                "client_secret"
              ],
              "properties": {
                "client_id": {
                  "type": "string"
                },
                "client_secret": {
                  "type": "string"
                },
                "tenant_id": {
                  "type": "string"
                }
              }
            },
            "endpoint": {
              "type": "string"
            }
          }
        }
      }
    },
    "certificateInfo": {
      "type": "object",
      "properties": {
        "domains": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "expiry": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "serialNumber": {
          "type": "string"
        }
      }
    },
    "checkOperatorVersionResponse": {
      "type": "object",
      "properties": {
        "current_version": {
          "type": "string"
        },
        "latest_version": {
          "type": "string"
        }
      }
    },
    "condition": {
      "type": "object",
      "properties": {
        "status": {
          "type": "string"
        },
        "type": {
          "type": "string"
        }
      }
    },
    "configMap": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "optional": {
          "type": "boolean"
        }
      }
    },
    "configureTenantRequest": {
      "type": "object",
      "properties": {
        "prometheusEnabled": {
          "type": "boolean"
        }
      }
    },
    "container": {
      "type": "object",
      "properties": {
        "args": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "containerID": {
          "type": "string"
        },
        "environmentVariables": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/environmentVariable"
          }
        },
        "hostPorts": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "image": {
          "type": "string"
        },
        "imageID": {
          "type": "string"
        },
        "lastState": {
          "$ref": "#/definitions/state"
        },
        "mounts": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/mount"
          }
        },
        "name": {
          "type": "string"
        },
        "ports": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "ready": {
          "type": "boolean"
        },
        "restartCount": {
          "type": "integer"
        },
        "state": {
          "$ref": "#/definitions/state"
        }
      }
    },
    "createTenantRequest": {
      "type": "object",
      "required": [
        "name",
        "namespace",
        "pools"
      ],
      "properties": {
        "access_key": {
          "type": "string"
        },
        "annotations": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "domains": {
          "type": "object",
          "$ref": "#/definitions/domainsConfiguration"
        },
        "enable_console": {
          "type": "boolean",
          "default": true
        },
        "enable_prometheus": {
          "type": "boolean",
          "default": false
        },
        "enable_tls": {
          "type": "boolean",
          "default": true
        },
        "encryption": {
          "type": "object",
          "$ref": "#/definitions/encryptionConfiguration"
        },
        "environmentVariables": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/environmentVariable"
          }
        },
        "erasureCodingParity": {
          "type": "integer"
        },
        "expose_console": {
          "type": "boolean"
        },
        "expose_minio": {
          "type": "boolean"
        },
        "idp": {
          "type": "object",
          "$ref": "#/definitions/idpConfiguration"
        },
        "image": {
          "type": "string"
        },
        "image_pull_secret": {
          "type": "string"
        },
        "image_registry": {
          "$ref": "#/definitions/imageRegistry"
        },
        "labels": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "logSearchConfiguration": {
          "$ref": "#/definitions/logSearchConfiguration"
        },
        "mount_path": {
          "type": "string"
        },
        "name": {
          "type": "string",
          "pattern": "^[a-z0-9-]{3,63}$"
        },
        "namespace": {
          "type": "string"
        },
        "pools": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/pool"
          }
        },
        "prometheusConfiguration": {
          "$ref": "#/definitions/prometheusConfiguration"
        },
        "secret_key": {
          "type": "string"
        },
        "tls": {
          "type": "object",
          "$ref": "#/definitions/tlsConfiguration"
        }
      }
    },
    "createTenantResponse": {
      "type": "object",
      "properties": {
        "console": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/tenantResponseItem"
          }
        },
        "externalIDP": {
          "type": "boolean"
        }
      }
    },
    "csrElement": {
      "type": "object",
      "properties": {
        "annotations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/annotation"
          }
        },
        "deletion_grace_period_seconds": {
          "type": "integer",
          "format": "int64"
        },
        "generate_name": {
          "type": "string"
        },
        "generation": {
          "type": "integer",
          "format": "int64"
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "resource_version": {
          "type": "string"
        },
        "status": {
          "type": "string"
        }
      }
    },
    "csrElements": {
      "type": "object",
      "properties": {
        "csrElement": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/csrElement"
          }
        }
      }
    },
    "deleteTenantRequest": {
      "type": "object",
      "properties": {
        "delete_pvcs": {
          "type": "boolean"
        }
      }
    },
    "describePVCWrapper": {
      "type": "object",
      "properties": {
        "accessModes": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "annotations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/annotation"
          }
        },
        "capacity": {
          "type": "string"
        },
        "finalizers": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "labels": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/label"
          }
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "storageClass": {
          "type": "string"
        },
        "volume": {
          "type": "string"
        },
        "volumeMode": {
          "type": "string"
        }
      }
    },
    "describePodWrapper": {
      "type": "object",
      "properties": {
        "annotations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/annotation"
          }
        },
        "conditions": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/condition"
          }
        },
        "containers": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/container"
          }
        },
        "controllerRef": {
          "type": "string"
        },
        "deletionGracePeriodSeconds": {
          "type": "integer"
        },
        "deletionTimestamp": {
          "type": "string"
        },
        "labels": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/label"
          }
        },
        "message": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "nodeName": {
          "type": "string"
        },
        "nodeSelector": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/nodeSelector"
          }
        },
        "phase": {
          "type": "string"
        },
        "podIP": {
          "type": "string"
        },
        "priority": {
          "type": "integer"
        },
        "priorityClassName": {
          "type": "string"
        },
        "qosClass": {
          "type": "string"
        },
        "reason": {
          "type": "string"
        },
        "startTime": {
          "type": "string"
        },
        "tolerations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/toleration"
          }
        },
        "volumes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/volume"
          }
        }
      }
    },
    "directPVDriveInfo": {
      "type": "object",
      "properties": {
        "allocated": {
          "type": "number",
          "format": "int64"
        },
        "capacity": {
          "type": "number",
          "format": "int64"
        },
        "drive": {
          "type": "string"
        },
        "message": {
          "type": "string"
        },
        "node": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "volumes": {
          "type": "number",
          "format": "int64"
        }
      }
    },
    "directPVVolumeInfo": {
      "type": "object",
      "properties": {
        "capacity": {
          "type": "number",
          "format": "int64"
        },
        "drive": {
          "type": "string"
        },
        "node": {
          "type": "string"
        },
        "volume": {
          "type": "string"
        }
      }
    },
    "domainsConfiguration": {
      "type": "object",
      "properties": {
        "console": {
          "type": "string"
        },
        "minio": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "encryptionConfiguration": {
      "allOf": [
        {
          "$ref": "#/definitions/metadataFields"
        },
        {
          "type": "object",
          "properties": {
            "aws": {
              "type": "object",
              "$ref": "#/definitions/awsConfiguration"
            },
            "azure": {
              "type": "object",
              "$ref": "#/definitions/azureConfiguration"
            },
            "gcp": {
              "type": "object",
              "$ref": "#/definitions/gcpConfiguration"
            },
            "gemalto": {
              "type": "object",
              "$ref": "#/definitions/gemaltoConfiguration"
            },
            "image": {
              "type": "string"
            },
            "kms_mtls": {
              "type": "object",
              "properties": {
                "ca": {
                  "type": "string"
                },
                "crt": {
                  "type": "string"
                },
                "key": {
                  "type": "string"
                }
              }
            },
            "minio_mtls": {
              "type": "object",
              "$ref": "#/definitions/keyPairConfiguration"
            },
            "raw": {
              "type": "string"
            },
            "replicas": {
              "type": "string"
            },
            "secretsToBeDeleted": {
              "type": "array",
              "items": {
                "type": "string"
              }
            },
            "securityContext": {
              "type": "object",
              "$ref": "#/definitions/securityContext"
            },
            "server_tls": {
              "type": "object",
              "$ref": "#/definitions/keyPairConfiguration"
            },
            "vault": {
              "type": "object",
              "$ref": "#/definitions/vaultConfiguration"
            }
          }
        }
      ]
    },
    "encryptionConfigurationResponse": {
      "allOf": [
        {
          "$ref": "#/definitions/metadataFields"
        },
        {
          "type": "object",
          "properties": {
            "aws": {
              "type": "object",
              "$ref": "#/definitions/awsConfiguration"
            },
            "azure": {
              "type": "object",
              "$ref": "#/definitions/azureConfiguration"
            },
            "gcp": {
              "type": "object",
              "$ref": "#/definitions/gcpConfiguration"
            },
            "gemalto": {
              "type": "object",
              "$ref": "#/definitions/gemaltoConfigurationResponse"
            },
            "image": {
              "type": "string"
            },
            "kms_mtls": {
              "type": "object",
              "properties": {
                "ca": {
                  "type": "object",
                  "$ref": "#/definitions/certificateInfo"
                },
                "crt": {
                  "type": "object",
                  "$ref": "#/definitions/certificateInfo"
                }
              }
            },
            "minio_mtls": {
              "type": "object",
              "$ref": "#/definitions/certificateInfo"
            },
            "raw": {
              "type": "string"
            },
            "replicas": {
              "type": "string"
            },
            "securityContext": {
              "type": "object",
              "$ref": "#/definitions/securityContext"
            },
            "server_tls": {
              "type": "object",
              "$ref": "#/definitions/certificateInfo"
            },
            "vault": {
              "type": "object",
              "$ref": "#/definitions/vaultConfigurationResponse"
            }
          }
        }
      ]
    },
    "environmentVariable": {
      "type": "object",
      "properties": {
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "error": {
      "type": "object",
      "required": [
        "message",
        "detailedMessage"
      ],
      "properties": {
        "code": {
          "type": "integer",
          "format": "int32"
        },
        "detailedMessage": {
          "type": "string"
        },
        "message": {
          "type": "string"
        }
      }
    },
    "eventListElement": {
      "type": "object",
      "properties": {
        "event_type": {
          "type": "string"
        },
        "last_seen": {
          "type": "integer",
          "format": "int64"
        },
        "message": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "object": {
          "type": "string"
        },
        "reason": {
          "type": "string"
        }
      }
    },
    "eventListWrapper": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/eventListElement"
      }
    },
    "formatConfiguration": {
      "type": "object",
      "required": [
        "drives",
        "force"
      ],
      "properties": {
        "drives": {
          "type": "array",
          "minLength": 1,
          "items": {
            "type": "string"
          }
        },
        "force": {
          "type": "boolean"
        }
      }
    },
    "formatDirectPVDrivesResponse": {
      "type": "object",
      "properties": {
        "formatIssuesList": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/pvFormatErrorResponse"
          }
        }
      }
    },
    "gcpConfiguration": {
      "type": "object",
      "required": [
        "secretmanager"
      ],
      "properties": {
        "secretmanager": {
          "type": "object",
          "required": [
            "project_id"
          ],
          "properties": {
            "credentials": {
              "type": "object",
              "properties": {
                "client_email": {
                  "type": "string"
                },
                "client_id": {
                  "type": "string"
                },
                "private_key": {
                  "type": "string"
                },
                "private_key_id": {
                  "type": "string"
                }
              }
            },
            "endpoint": {
              "type": "string"
            },
            "project_id": {
              "type": "string"
            }
          }
        }
      }
    },
    "gemaltoConfiguration": {
      "type": "object",
      "required": [
        "keysecure"
      ],
      "properties": {
        "keysecure": {
          "type": "object",
          "required": [
            "endpoint",
            "credentials"
          ],
          "properties": {
            "credentials": {
              "type": "object",
              "required": [
                "token",
                "domain"
              ],
              "properties": {
                "domain": {
                  "type": "string"
                },
                "retry": {
                  "type": "integer",
                  "format": "int64"
                },
                "token": {
                  "type": "string"
                }
              }
            },
            "endpoint": {
              "type": "string"
            }
          }
        }
      }
    },
    "gemaltoConfigurationResponse": {
      "type": "object",
      "required": [
        "keysecure"
      ],
      "properties": {
        "keysecure": {
          "type": "object",
          "required": [
            "endpoint",
            "credentials"
          ],
          "properties": {
            "credentials": {
              "type": "object",
              "required": [
                "token",
                "domain"
              ],
              "properties": {
                "domain": {
                  "type": "string"
                },
                "retry": {
                  "type": "integer",
                  "format": "int64"
                },
                "token": {
                  "type": "string"
                }
              }
            },
            "endpoint": {
              "type": "string"
            }
          }
        }
      }
    },
    "getDirectPVDriveListResponse": {
      "type": "object",
      "properties": {
        "drives": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/directPVDriveInfo"
          }
        }
      }
    },
    "getDirectPVVolumeListResponse": {
      "type": "object",
      "properties": {
        "volumes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/directPVVolumeInfo"
          }
        }
      }
    },
    "idpConfiguration": {
      "type": "object",
      "properties": {
        "active_directory": {
          "type": "object",
          "required": [
            "url",
            "lookup_bind_dn"
          ],
          "properties": {
            "group_search_base_dn": {
              "type": "string"
            },
            "group_search_filter": {
              "type": "string"
            },
            "lookup_bind_dn": {
              "type": "string"
            },
            "lookup_bind_password": {
              "type": "string"
            },
            "server_insecure": {
              "type": "boolean"
            },
            "server_start_tls": {
              "type": "boolean"
            },
            "skip_tls_verification": {
              "type": "boolean"
            },
            "url": {
              "type": "string"
            },
            "user_dn_search_base_dn": {
              "type": "string"
            },
            "user_dn_search_filter": {
              "type": "string"
            },
            "user_dns": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          }
        },
        "keys": {
          "type": "array",
          "items": {
            "type": "object",
            "required": [
              "access_key",
              "secret_key"
            ],
            "properties": {
              "access_key": {
                "type": "string"
              },
              "secret_key": {
                "type": "string"
              }
            }
          }
        },
        "oidc": {
          "type": "object",
          "required": [
            "configuration_url",
            "client_id",
            "secret_id",
            "claim_name"
          ],
          "properties": {
            "callback_url": {
              "type": "string"
            },
            "claim_name": {
              "type": "string"
            },
            "client_id": {
              "type": "string"
            },
            "configuration_url": {
              "type": "string"
            },
            "scopes": {
              "type": "string"
            },
            "secret_id": {
              "type": "string"
            }
          }
        }
      }
    },
    "imageRegistry": {
      "type": "object",
      "required": [
        "registry",
        "username",
        "password"
      ],
      "properties": {
        "password": {
          "type": "string"
        },
        "registry": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "keyPairConfiguration": {
      "type": "object",
      "required": [
        "crt",
        "key"
      ],
      "properties": {
        "crt": {
          "type": "string"
        },
        "key": {
          "type": "string"
        }
      }
    },
    "label": {
      "type": "object",
      "properties": {
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "license": {
      "type": "object",
      "properties": {
        "account_id": {
          "type": "integer"
        },
        "email": {
          "type": "string"
        },
        "expires_at": {
          "type": "string"
        },
        "organization": {
          "type": "string"
        },
        "plan": {
          "type": "string"
        },
        "storage_capacity": {
          "type": "integer"
        }
      }
    },
    "listPVCsResponse": {
      "type": "object",
      "properties": {
        "pvcs": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/pvcsListResponse"
          }
        }
      }
    },
    "listTenantsResponse": {
      "type": "object",
      "properties": {
        "tenants": {
          "type": "array",
          "title": "list of resulting tenants",
          "items": {
            "$ref": "#/definitions/tenantList"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "number of tenants accessible to tenant user"
        }
      }
    },
    "logSearchConfiguration": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string"
        },
        "postgres_image": {
          "type": "string"
        },
        "postgres_init_image": {
          "type": "string"
        },
        "postgres_securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "storageClass": {
          "type": "string",
          "default": ""
        },
        "storageSize": {
          "type": "number",
          "default": 5
        }
      }
    },
    "loginDetails": {
      "type": "object",
      "properties": {
        "isDirectPV": {
          "type": "boolean"
        },
        "loginStrategy": {
          "type": "string",
          "enum": [
            "form",
            "redirect",
            "service-account",
            "redirect-service-account"
          ]
        },
        "redirectRules": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/redirectRule"
          }
        }
      }
    },
    "loginOauth2AuthRequest": {
      "type": "object",
      "required": [
        "state",
        "code"
      ],
      "properties": {
        "code": {
          "type": "string"
        },
        "state": {
          "type": "string"
        }
      }
    },
    "loginOperatorRequest": {
      "type": "object",
      "required": [
        "jwt"
      ],
      "properties": {
        "jwt": {
          "type": "string"
        }
      }
    },
    "loginRequest": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "features": {
          "type": "object",
          "properties": {
            "hide_menu": {
              "type": "boolean"
            }
          }
        },
        "secretKey": {
          "type": "string"
        },
        "sts": {
          "type": "string"
        }
      }
    },
    "maxAllocatableMemResponse": {
      "type": "object",
      "properties": {
        "max_memory": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "metadataFields": {
      "type": "object",
      "properties": {
        "annotations": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "labels": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "node_selector": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        }
      }
    },
    "mount": {
      "type": "object",
      "properties": {
        "mountPath": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "readOnly": {
          "type": "boolean"
        },
        "subPath": {
          "type": "string"
        }
      }
    },
    "mpIntegration": {
      "type": "object",
      "properties": {
        "email": {
          "type": "string"
        },
        "isInEU": {
          "type": "boolean"
        }
      }
    },
    "namespace": {
      "type": "object",
      "required": [
        "name"
      ],
      "properties": {
        "name": {
          "type": "string"
        }
      }
    },
    "nodeLabels": {
      "type": "object",
      "additionalProperties": {
        "type": "array",
        "items": {
          "type": "string"
        }
      }
    },
    "nodeMaxAllocatableResources": {
      "type": "object",
      "properties": {
        "max_allocatable_cpu": {
          "type": "integer",
          "format": "int64"
        },
        "max_allocatable_mem": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "nodeSelector": {
      "type": "object",
      "properties": {
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "nodeSelectorTerm": {
      "description": "A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.",
      "type": "object",
      "properties": {
        "matchExpressions": {
          "description": "A list of node selector requirements by node's labels.",
          "type": "array",
          "items": {
            "description": "A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
            "type": "object",
            "required": [
              "key",
              "operator"
            ],
            "properties": {
              "key": {
                "description": "The label key that the selector applies to.",
                "type": "string"
              },
              "operator": {
                "description": "Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.",
                "type": "string"
              },
              "values": {
                "description": "An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.",
                "type": "array",
                "items": {
                  "type": "string"
                }
              }
            }
          }
        },
        "matchFields": {
          "description": "A list of node selector requirements by node's fields.",
          "type": "array",
          "items": {
            "description": "A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
            "type": "object",
            "required": [
              "key",
              "operator"
            ],
            "properties": {
              "key": {
                "description": "The label key that the selector applies to.",
                "type": "string"
              },
              "operator": {
                "description": "Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.",
                "type": "string"
              },
              "values": {
                "description": "An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.",
                "type": "array",
                "items": {
                  "type": "string"
                }
              }
            }
          }
        }
      }
    },
    "operatorSessionResponse": {
      "type": "object",
      "properties": {
        "directPV": {
          "type": "boolean"
        },
        "features": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "operator": {
          "type": "boolean"
        },
        "permissions": {
          "type": "object",
          "additionalProperties": {
            "type": "array",
            "items": {
              "type": "string"
            }
          }
        },
        "status": {
          "type": "string",
          "enum": [
            "ok"
          ]
        }
      }
    },
    "operatorSubnetAPIKey": {
      "type": "object",
      "properties": {
        "apiKey": {
          "type": "string"
        }
      }
    },
    "operatorSubnetLoginMFARequest": {
      "type": "object",
      "required": [
        "username",
        "otp",
        "mfa_token"
      ],
      "properties": {
        "mfa_token": {
          "type": "string"
        },
        "otp": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "operatorSubnetLoginRequest": {
      "type": "object",
      "properties": {
        "password": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "operatorSubnetLoginResponse": {
      "type": "object",
      "properties": {
        "access_token": {
          "type": "string"
        },
        "mfa_token": {
          "type": "string"
        }
      }
    },
    "operatorSubnetRegisterAPIKeyResponse": {
      "type": "object",
      "properties": {
        "registered": {
          "type": "boolean"
        }
      }
    },
    "parityResponse": {
      "type": "array",
      "items": {
        "type": "string"
      }
    },
    "podAffinityTerm": {
      "description": "Required. A pod affinity term, associated with the corresponding weight.",
      "type": "object",
      "required": [
        "topologyKey"
      ],
      "properties": {
        "labelSelector": {
          "description": "A label query over a set of resources, in this case pods.",
          "type": "object",
          "properties": {
            "matchExpressions": {
              "description": "matchExpressions is a list of label selector requirements. The requirements are ANDed.",
              "type": "array",
              "items": {
                "description": "A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
                "type": "object",
                "required": [
                  "key",
                  "operator"
                ],
                "properties": {
                  "key": {
                    "description": "key is the label key that the selector applies to.",
                    "type": "string"
                  },
                  "operator": {
                    "description": "operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
                    "type": "string"
                  },
                  "values": {
                    "description": "values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.",
                    "type": "array",
                    "items": {
                      "type": "string"
                    }
                  }
                }
              }
            },
            "matchLabels": {
              "description": "matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \"key\", the operator is \"In\", and the values array contains only \"value\". The requirements are ANDed.",
              "type": "object",
              "additionalProperties": {
                "type": "string"
              }
            }
          }
        },
        "namespaces": {
          "description": "namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means \"this pod's namespace\"",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "topologyKey": {
          "description": "This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.",
          "type": "string"
        }
      }
    },
    "pool": {
      "type": "object",
      "required": [
        "servers",
        "volumes_per_server",
        "volume_configuration"
      ],
      "properties": {
        "affinity": {
          "$ref": "#/definitions/poolAffinity"
        },
        "name": {
          "type": "string"
        },
        "node_selector": {
          "description": "NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/",
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "resources": {
          "$ref": "#/definitions/poolResources"
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "servers": {
          "type": "integer"
        },
        "tolerations": {
          "$ref": "#/definitions/poolTolerations"
        },
        "volume_configuration": {
          "type": "object",
          "required": [
            "size"
          ],
          "properties": {
            "annotations": {
              "type": "object",
              "additionalProperties": {
                "type": "string"
              }
            },
            "labels": {
              "type": "object",
              "additionalProperties": {
                "type": "string"
              }
            },
            "size": {
              "type": "integer"
            },
            "storage_class_name": {
              "type": "string"
            }
          }
        },
        "volumes_per_server": {
          "type": "integer",
          "format": "int32"
        }
      }
    },
    "poolAffinity": {
      "description": "If specified, affinity will define the pod's scheduling constraints",
      "type": "object",
      "properties": {
        "nodeAffinity": {
          "description": "Describes node affinity scheduling rules for the pod.",
          "type": "object",
          "properties": {
            "preferredDuringSchedulingIgnoredDuringExecution": {
              "description": "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.",
              "type": "array",
              "items": {
                "description": "An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).",
                "type": "object",
                "required": [
                  "preference",
                  "weight"
                ],
                "properties": {
                  "preference": {
                    "description": "A node selector term, associated with the corresponding weight.",
                    "type": "object",
                    "$ref": "#/definitions/nodeSelectorTerm"
                  },
                  "weight": {
                    "description": "Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.",
                    "type": "integer",
                    "format": "int32"
                  }
                }
              }
            },
            "requiredDuringSchedulingIgnoredDuringExecution": {
              "description": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.",
              "type": "object",
              "required": [
                "nodeSelectorTerms"
              ],
              "properties": {
                "nodeSelectorTerms": {
                  "description": "Required. A list of node selector terms. The terms are ORed.",
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/nodeSelectorTerm"
                  }
                }
              }
            }
          }
        },
        "podAffinity": {
          "description": "Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, pool, etc. as some other pod(s)).",
          "type": "object",
          "properties": {
            "preferredDuringSchedulingIgnoredDuringExecution": {
              "description": "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.",
              "type": "array",
              "items": {
                "description": "The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s)",
                "type": "object",
                "required": [
                  "podAffinityTerm",
                  "weight"
                ],
                "properties": {
                  "podAffinityTerm": {
                    "$ref": "#/definitions/podAffinityTerm"
                  },
                  "weight": {
                    "description": "weight associated with matching the corresponding podAffinityTerm, in the range 1-100.",
                    "type": "integer",
                    "format": "int32"
                  }
                }
              }
            },
            "requiredDuringSchedulingIgnoredDuringExecution": {
              "description": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
              "type": "array",
              "items": {
                "$ref": "#/definitions/podAffinityTerm"
              }
            }
          }
        },
        "podAntiAffinity": {
          "description": "Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, pool, etc. as some other pod(s)).",
          "type": "object",
          "properties": {
            "preferredDuringSchedulingIgnoredDuringExecution": {
              "description": "The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.",
              "type": "array",
              "items": {
                "description": "The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s)",
                "type": "object",
                "required": [
                  "podAffinityTerm",
                  "weight"
                ],
                "properties": {
                  "podAffinityTerm": {
                    "$ref": "#/definitions/podAffinityTerm"
                  },
                  "weight": {
                    "description": "weight associated with matching the corresponding podAffinityTerm, in the range 1-100.",
                    "type": "integer",
                    "format": "int32"
                  }
                }
              }
            },
            "requiredDuringSchedulingIgnoredDuringExecution": {
              "description": "If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
              "type": "array",
              "items": {
                "$ref": "#/definitions/podAffinityTerm"
              }
            }
          }
        }
      }
    },
    "poolResources": {
      "description": "If provided, use these requests and limit for cpu/memory resource allocation",
      "type": "object",
      "properties": {
        "limits": {
          "description": "Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
          "type": "object",
          "additionalProperties": {
            "type": "integer",
            "format": "int64"
          }
        },
        "requests": {
          "description": "Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
          "type": "object",
          "additionalProperties": {
            "type": "integer",
            "format": "int64"
          }
        }
      }
    },
    "poolTolerationSeconds": {
      "description": "TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.",
      "type": "object",
      "required": [
        "seconds"
      ],
      "properties": {
        "seconds": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "poolTolerations": {
      "description": "Tolerations allows users to set entries like effect, key, operator, value.",
      "type": "array",
      "items": {
        "description": "The pod this Toleration is attached to tolerates any taint that matches the triple \u003ckey,value,effect\u003e using the matching operator \u003coperator\u003e.",
        "type": "object",
        "properties": {
          "effect": {
            "description": "Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.",
            "type": "string"
          },
          "key": {
            "description": "Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.",
            "type": "string"
          },
          "operator": {
            "description": "Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.",
            "type": "string"
          },
          "tolerationSeconds": {
            "$ref": "#/definitions/poolTolerationSeconds"
          },
          "value": {
            "description": "Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.",
            "type": "string"
          }
        }
      }
    },
    "poolUpdateRequest": {
      "type": "object",
      "required": [
        "pools"
      ],
      "properties": {
        "pools": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/pool"
          }
        }
      }
    },
    "projectedVolume": {
      "type": "object",
      "properties": {
        "sources": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/projectedVolumeSource"
          }
        }
      }
    },
    "projectedVolumeSource": {
      "type": "object",
      "properties": {
        "configMap": {
          "$ref": "#/definitions/configMap"
        },
        "downwardApi": {
          "type": "boolean"
        },
        "secret": {
          "$ref": "#/definitions/secret"
        },
        "serviceAccountToken": {
          "$ref": "#/definitions/serviceAccountToken"
        }
      }
    },
    "prometheusConfiguration": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string"
        },
        "init_image": {
          "type": "string"
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "sidecar_image": {
          "type": "string"
        },
        "storageClass": {
          "type": "string",
          "default": ""
        },
        "storageSize": {
          "type": "number",
          "default": 5
        }
      }
    },
    "pvFormatErrorResponse": {
      "type": "object",
      "properties": {
        "drive": {
          "type": "string"
        },
        "error": {
          "type": "string"
        },
        "node": {
          "type": "string"
        }
      }
    },
    "pvc": {
      "type": "object",
      "properties": {
        "claimName": {
          "type": "string"
        },
        "readOnly": {
          "type": "boolean"
        }
      }
    },
    "pvcsListResponse": {
      "type": "object",
      "properties": {
        "age": {
          "type": "string"
        },
        "capacity": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "storageClass": {
          "type": "string"
        },
        "tenant": {
          "type": "string"
        },
        "volume": {
          "type": "string"
        }
      }
    },
    "redirectRule": {
      "type": "object",
      "properties": {
        "displayName": {
          "type": "string"
        },
        "redirect": {
          "type": "string"
        }
      }
    },
    "resourceQuota": {
      "type": "object",
      "properties": {
        "elements": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/resourceQuotaElement"
          }
        },
        "name": {
          "type": "string"
        }
      }
    },
    "resourceQuotaElement": {
      "type": "object",
      "properties": {
        "hard": {
          "type": "integer",
          "format": "int64"
        },
        "name": {
          "type": "string"
        },
        "used": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "secret": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "optional": {
          "type": "boolean"
        }
      }
    },
    "securityContext": {
      "type": "object",
      "required": [
        "runAsUser",
        "runAsGroup",
        "runAsNonRoot"
      ],
      "properties": {
        "fsGroup": {
          "type": "string"
        },
        "fsGroupChangePolicy": {
          "type": "string"
        },
        "runAsGroup": {
          "type": "string"
        },
        "runAsNonRoot": {
          "type": "boolean"
        },
        "runAsUser": {
          "type": "string"
        }
      }
    },
    "serviceAccountToken": {
      "type": "object",
      "properties": {
        "expirationSeconds": {
          "type": "integer"
        }
      }
    },
    "setAdministratorsRequest": {
      "type": "object",
      "properties": {
        "group_dns": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "user_dns": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "state": {
      "type": "object",
      "properties": {
        "exitCode": {
          "type": "integer"
        },
        "finished": {
          "type": "string"
        },
        "message": {
          "type": "string"
        },
        "reason": {
          "type": "string"
        },
        "signal": {
          "type": "integer"
        },
        "started": {
          "type": "string"
        },
        "state": {
          "type": "string"
        }
      }
    },
    "subscriptionValidateRequest": {
      "type": "object",
      "properties": {
        "email": {
          "type": "string"
        },
        "license": {
          "type": "string"
        },
        "password": {
          "type": "string"
        }
      }
    },
    "tenant": {
      "type": "object",
      "properties": {
        "creation_date": {
          "type": "string"
        },
        "currentState": {
          "type": "string"
        },
        "deletion_date": {
          "type": "string"
        },
        "domains": {
          "$ref": "#/definitions/domainsConfiguration"
        },
        "enable_prometheus": {
          "type": "boolean"
        },
        "encryptionEnabled": {
          "type": "boolean"
        },
        "endpoints": {
          "type": "object",
          "properties": {
            "console": {
              "type": "string"
            },
            "minio": {
              "type": "string"
            }
          }
        },
        "idpAdEnabled": {
          "type": "boolean"
        },
        "idpOidcEnabled": {
          "type": "boolean"
        },
        "image": {
          "type": "string"
        },
        "logEnabled": {
          "type": "boolean"
        },
        "minioTLS": {
          "type": "boolean"
        },
        "monitoringEnabled": {
          "type": "boolean"
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "pools": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/pool"
          }
        },
        "status": {
          "$ref": "#/definitions/tenantStatus"
        },
        "subnet_license": {
          "$ref": "#/definitions/license"
        },
        "total_size": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "tenantConfigurationResponse": {
      "type": "object",
      "properties": {
        "environmentVariables": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/environmentVariable"
          }
        }
      }
    },
    "tenantList": {
      "type": "object",
      "properties": {
        "capacity": {
          "type": "integer",
          "format": "int64"
        },
        "capacity_raw": {
          "type": "integer",
          "format": "int64"
        },
        "capacity_raw_usage": {
          "type": "integer",
          "format": "int64"
        },
        "capacity_usage": {
          "type": "integer",
          "format": "int64"
        },
        "creation_date": {
          "type": "string"
        },
        "currentState": {
          "type": "string"
        },
        "deletion_date": {
          "type": "string"
        },
        "domains": {
          "type": "object",
          "$ref": "#/definitions/domainsConfiguration"
        },
        "health_status": {
          "type": "string"
        },
        "instance_count": {
          "type": "integer"
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "pool_count": {
          "type": "integer"
        },
        "tiers": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/tenantTierElement"
          }
        },
        "total_size": {
          "type": "integer"
        },
        "volume_count": {
          "type": "integer"
        }
      }
    },
    "tenantLogs": {
      "type": "object",
      "properties": {
        "annotations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/annotation"
          }
        },
        "dbAnnotations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/annotation"
          }
        },
        "dbImage": {
          "type": "string"
        },
        "dbInitImage": {
          "type": "string"
        },
        "dbLabels": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/label"
          }
        },
        "dbNodeSelector": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/nodeSelector"
          }
        },
        "dbSecurityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "dbServiceAccountName": {
          "type": "string"
        },
        "disabled": {
          "type": "boolean"
        },
        "diskCapacityGB": {
          "type": "string"
        },
        "image": {
          "type": "string"
        },
        "labels": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/label"
          }
        },
        "logCPURequest": {
          "type": "string"
        },
        "logDBCPURequest": {
          "type": "string"
        },
        "logDBMemRequest": {
          "type": "string"
        },
        "logMemRequest": {
          "type": "string"
        },
        "nodeSelector": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/nodeSelector"
          }
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "serviceAccountName": {
          "type": "string"
        }
      }
    },
    "tenantMonitoringInfo": {
      "type": "object",
      "properties": {
        "annotations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/annotation"
          }
        },
        "diskCapacityGB": {
          "type": "string"
        },
        "image": {
          "type": "string"
        },
        "initImage": {
          "type": "string"
        },
        "labels": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/label"
          }
        },
        "monitoringCPURequest": {
          "type": "string"
        },
        "monitoringMemRequest": {
          "type": "string"
        },
        "nodeSelector": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/nodeSelector"
          }
        },
        "prometheusEnabled": {
          "type": "boolean"
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "serviceAccountName": {
          "type": "string"
        },
        "sidecarImage": {
          "type": "string"
        },
        "storageClassName": {
          "type": "string"
        },
        "toggle": {
          "type": "boolean"
        }
      }
    },
    "tenantPod": {
      "type": "object",
      "required": [
        "name"
      ],
      "properties": {
        "name": {
          "type": "string"
        },
        "node": {
          "type": "string"
        },
        "podIP": {
          "type": "string"
        },
        "restarts": {
          "type": "integer"
        },
        "status": {
          "type": "string"
        },
        "timeCreated": {
          "type": "integer"
        }
      }
    },
    "tenantResponseItem": {
      "type": "object",
      "properties": {
        "access_key": {
          "type": "string"
        },
        "secret_key": {
          "type": "string"
        },
        "url": {
          "type": "string"
        }
      }
    },
    "tenantSecurityResponse": {
      "type": "object",
      "properties": {
        "autoCert": {
          "type": "boolean"
        },
        "customCertificates": {
          "type": "object",
          "properties": {
            "client": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/certificateInfo"
              }
            },
            "minio": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/certificateInfo"
              }
            },
            "minioCAs": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/certificateInfo"
              }
            }
          }
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        }
      }
    },
    "tenantStatus": {
      "type": "object",
      "properties": {
        "drives_healing": {
          "type": "integer",
          "format": "int32"
        },
        "drives_offline": {
          "type": "integer",
          "format": "int32"
        },
        "drives_online": {
          "type": "integer",
          "format": "int32"
        },
        "health_status": {
          "type": "string"
        },
        "usage": {
          "type": "object",
          "properties": {
            "capacity": {
              "type": "integer",
              "format": "int64"
            },
            "capacity_usage": {
              "type": "integer",
              "format": "int64"
            },
            "raw": {
              "type": "integer",
              "format": "int64"
            },
            "raw_usage": {
              "type": "integer",
              "format": "int64"
            }
          }
        },
        "write_quorum": {
          "type": "integer",
          "format": "int32"
        }
      }
    },
    "tenantTierElement": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "size": {
          "type": "integer",
          "format": "int64"
        },
        "type": {
          "type": "string"
        }
      }
    },
    "tenantUsage": {
      "type": "object",
      "properties": {
        "disk_used": {
          "type": "integer",
          "format": "int64"
        },
        "used": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "tenantYAML": {
      "type": "object",
      "properties": {
        "yaml": {
          "type": "string"
        }
      }
    },
    "tlsConfiguration": {
      "type": "object",
      "properties": {
        "minioCAsCertificates": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "minioClientCertificates": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/keyPairConfiguration"
          }
        },
        "minioServerCertificates": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/keyPairConfiguration"
          }
        }
      }
    },
    "toleration": {
      "type": "object",
      "properties": {
        "effect": {
          "type": "string"
        },
        "key": {
          "type": "string"
        },
        "operator": {
          "type": "string"
        },
        "tolerationSeconds": {
          "type": "integer"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "updateDomainsRequest": {
      "type": "object",
      "properties": {
        "domains": {
          "$ref": "#/definitions/domainsConfiguration"
        }
      }
    },
    "updateTenantConfigurationRequest": {
      "type": "object",
      "properties": {
        "environmentVariables": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/environmentVariable"
          }
        },
        "keysToBeDeleted": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "updateTenantRequest": {
      "type": "object",
      "properties": {
        "enable_prometheus": {
          "type": "boolean"
        },
        "image": {
          "type": "string",
          "pattern": "^((.*?)/(.*?):(.+))$"
        },
        "image_pull_secret": {
          "type": "string"
        },
        "image_registry": {
          "$ref": "#/definitions/imageRegistry"
        }
      }
    },
    "updateTenantSecurityRequest": {
      "type": "object",
      "properties": {
        "autoCert": {
          "type": "boolean"
        },
        "customCertificates": {
          "type": "object",
          "properties": {
            "minioCAsCertificates": {
              "type": "array",
              "items": {
                "type": "string"
              }
            },
            "minioClientCertificates": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/keyPairConfiguration"
              }
            },
            "minioServerCertificates": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/keyPairConfiguration"
              }
            },
            "secretsToBeDeleted": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          }
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        }
      }
    },
    "vaultConfiguration": {
      "type": "object",
      "required": [
        "endpoint",
        "approle"
      ],
      "properties": {
        "approle": {
          "type": "object",
          "required": [
            "id",
            "secret"
          ],
          "properties": {
            "engine": {
              "type": "string"
            },
            "id": {
              "type": "string"
            },
            "retry": {
              "type": "integer",
              "format": "int64"
            },
            "secret": {
              "type": "string"
            }
          }
        },
        "endpoint": {
          "type": "string"
        },
        "engine": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "status": {
          "type": "object",
          "properties": {
            "ping": {
              "type": "integer",
              "format": "int64"
            }
          }
        }
      }
    },
    "vaultConfigurationResponse": {
      "type": "object",
      "required": [
        "endpoint",
        "approle"
      ],
      "properties": {
        "approle": {
          "type": "object",
          "required": [
            "id",
            "secret"
          ],
          "properties": {
            "engine": {
              "type": "string"
            },
            "id": {
              "type": "string"
            },
            "retry": {
              "type": "integer",
              "format": "int64"
            },
            "secret": {
              "type": "string"
            }
          }
        },
        "endpoint": {
          "type": "string"
        },
        "engine": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "status": {
          "type": "object",
          "properties": {
            "ping": {
              "type": "integer",
              "format": "int64"
            }
          }
        }
      }
    },
    "volume": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "projected": {
          "$ref": "#/definitions/projectedVolume"
        },
        "pvc": {
          "$ref": "#/definitions/pvc"
        }
      }
    }
  },
  "securityDefinitions": {
    "key": {
      "type": "oauth2",
      "flow": "accessCode",
      "authorizationUrl": "http://min.io",
      "tokenUrl": "http://min.io"
    }
  },
  "security": [
    {
      "key": []
    }
  ]
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http",
    "ws"
  ],
  "swagger": "2.0",
  "info": {
    "title": "MinIO Console Server",
    "version": "0.1.0"
  },
  "basePath": "/api/v1",
  "paths": {
    "/check-version": {
      "get": {
        "security": [],
        "tags": [
          "UserAPI"
        ],
        "summary": "Checks the current Operator version against the latest",
        "operationId": "CheckMinIOVersion”",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/checkOperatorVersionResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/cluster/allocatable-resources": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get allocatable cpu and memory for given number of nodes",
        "operationId": "GetAllocatableResources",
        "parameters": [
          {
            "minimum": 1,
            "type": "integer",
            "format": "int32",
            "name": "num_nodes",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/allocatableResourcesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/cluster/max-allocatable-memory": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get maximum allocatable memory for given number of nodes",
        "operationId": "GetMaxAllocatableMem",
        "parameters": [
          {
            "minimum": 1,
            "type": "integer",
            "format": "int32",
            "name": "num_nodes",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/maxAllocatableMemResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/directpv/drives": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get directpv drives list",
        "operationId": "GetDirectPVDriveList",
        "parameters": [
          {
            "type": "string",
            "name": "nodes",
            "in": "query"
          },
          {
            "type": "string",
            "name": "drives",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/getDirectPVDriveListResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/directpv/drives/format": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Format directpv drives from a list",
        "operationId": "DirectPVFormatDrive",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/formatConfiguration"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/formatDirectPVDrivesResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/directpv/volumes": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get directpv volumes list",
        "operationId": "GetDirectPVVolumeList",
        "parameters": [
          {
            "type": "string",
            "name": "nodes",
            "in": "query"
          },
          {
            "type": "string",
            "name": "drives",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/getDirectPVVolumeListResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/get-parity/{nodes}/{disksPerNode}": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Gets parity by sending number of nodes \u0026 number of disks",
        "operationId": "GetParity",
        "parameters": [
          {
            "minimum": 2,
            "type": "integer",
            "name": "nodes",
            "in": "path",
            "required": true
          },
          {
            "minimum": 1,
            "type": "integer",
            "name": "disksPerNode",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/parityResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/list-pvcs": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "List all PVCs from namespaces that the user has access to",
        "operationId": "ListPVCs",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listPVCsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/login": {
      "get": {
        "security": [],
        "tags": [
          "Auth"
        ],
        "summary": "Returns login strategy, form or sso.",
        "operationId": "LoginDetail",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/loginDetails"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/login/oauth2/auth": {
      "post": {
        "security": [],
        "tags": [
          "Auth"
        ],
        "summary": "Identity Provider oauth2 callback endpoint.",
        "operationId": "LoginOauth2Auth",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/loginOauth2AuthRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful login."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/login/operator": {
      "post": {
        "security": [],
        "tags": [
          "Auth"
        ],
        "summary": "Login to Operator Console.",
        "operationId": "LoginOperator",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/loginOperatorRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful login."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/logout": {
      "post": {
        "tags": [
          "Auth"
        ],
        "summary": "Logout from Operator.",
        "operationId": "Logout",
        "responses": {
          "200": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/mp-integration": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Returns email registered for marketplace integration",
        "operationId": "GetMPIntegration",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "object",
              "properties": {
                "isEmailSet": {
                  "type": "boolean"
                }
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Set email to register for marketplace integration",
        "operationId": "PostMPIntegration",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/mpIntegration"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespace": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Creates a new Namespace with given information",
        "operationId": "CreateNamespace",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/namespace"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/resourcequotas/{resource-quota-name}": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Resource Quota",
        "operationId": "GetResourceQuota",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "resource-quota-name",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/resourceQuota"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "List Tenants by Namespace",
        "operationId": "ListTenants",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "sort_by",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int32",
            "name": "offset",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int32",
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listTenantsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Details",
        "operationId": "TenantDetails",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenant"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Update Tenant",
        "operationId": "UpdateTenant",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateTenantRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Delete tenant and underlying pvcs",
        "operationId": "DeleteTenant",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/deleteTenantRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/certificates": {
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Update Certificates",
        "operationId": "TenantUpdateCertificate",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tlsConfiguration"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/configuration": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Configuration",
        "operationId": "TenantConfiguration",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenantConfigurationResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Update Tenant Configuration",
        "operationId": "UpdateTenantConfiguration",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateTenantConfigurationRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/csr": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "List Tenant Certificate Signing Request",
        "operationId": "ListTenantCertificateSigningRequest",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/csrElements"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/disable-logging": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Disable Tenant Logging",
        "operationId": "DisableTenantLogging",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "boolean"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/domains": {
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Update Domains for a Tenant",
        "operationId": "UpdateTenantDomains",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateDomainsRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/enable-logging": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Enable Tenant Logging",
        "operationId": "EnableTenantLogging",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "boolean"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/encryption": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Encryption Info",
        "operationId": "TenantEncryptionInfo",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/encryptionConfigurationResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Update Encryption",
        "operationId": "TenantUpdateEncryption",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/encryptionConfiguration"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Delete Encryption",
        "operationId": "TenantDeleteEncryption",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/events": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Events for given Tenant",
        "operationId": "GetTenantEvents",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/eventListWrapper"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/identity-provider": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Identity Provider",
        "operationId": "TenantIdentityProvider",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/idpConfiguration"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Update Tenant Identity Provider",
        "operationId": "UpdateTenantIdentityProvider",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/idpConfiguration"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/log": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Tenant Logs",
        "operationId": "GetTenantLogs",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenantLogs"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Set Tenant Logs",
        "operationId": "SetTenantLogs",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tenantLogs"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "boolean"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/monitoring": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Prometheus Monitoring config info For The Tenant",
        "operationId": "GetTenantMonitoring",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenantMonitoringInfo"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Set Prometheus monitoring fields for tenant",
        "operationId": "SetTenantMonitoring",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "data",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tenantMonitoringInfo"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pods": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Pods For The Tenant",
        "operationId": "GetTenantPods",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/tenantPod"
              }
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pods/{podName}": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Logs for Pod",
        "operationId": "GetPodLogs",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "podName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "type": "string"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Delete pod",
        "operationId": "DeletePod",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "podName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pods/{podName}/describe": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Describe Pod",
        "operationId": "DescribePod",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "podName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/describePodWrapper"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pods/{podName}/events": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Events for Pod",
        "operationId": "GetPodEvents",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "podName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/eventListWrapper"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pools": {
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Update Pools",
        "operationId": "TenantUpdatePools",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/poolUpdateRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenant"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Add Pool",
        "operationId": "TenantAddPool",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/pool"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pvc/{PVCName}": {
      "delete": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Delete PVC",
        "operationId": "DeletePVC",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "PVCName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pvcs": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "List all PVCs from given Tenant",
        "operationId": "ListPVCsForTenant",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listPVCsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pvcs/{PVCName}/describe": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Describe output for PVC",
        "operationId": "GetPVCDescribe",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "PVCName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/describePVCWrapper"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/pvcs/{PVCName}/events": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Events for PVC",
        "operationId": "GetPVCEvents",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "PVCName",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/eventListWrapper"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/security": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Tenant Security",
        "operationId": "TenantSecurity",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenantSecurityResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Update Tenant Security",
        "operationId": "UpdateTenantSecurity",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/updateTenantSecurityRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/set-administrators": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Set the consoleAdmin policy to the specified users and groups",
        "operationId": "SetTenantAdministrators",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/setAdministratorsRequest"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/usage": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get Usage For The Tenant",
        "operationId": "GetTenantUsage",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenantUsage"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/namespaces/{namespace}/tenants/{tenant}/yaml": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Get the Tenant YAML",
        "operationId": "GetTenantYAML",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/tenantYAML"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "put": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Put the Tenant YAML",
        "operationId": "PutTenantYAML",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/tenantYAML"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/nodes/labels": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "List node labels",
        "operationId": "ListNodeLabels",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/nodeLabels"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/session": {
      "get": {
        "tags": [
          "Auth"
        ],
        "summary": "Endpoint to check if your session is still valid",
        "operationId": "SessionCheck",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/operatorSessionResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subnet/apikey": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Subnet api key",
        "operationId": "OperatorSubnetApiKey",
        "parameters": [
          {
            "type": "string",
            "name": "token",
            "in": "query",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/operatorSubnetAPIKey"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subnet/apikey/info": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Subnet API key info",
        "operationId": "OperatorSubnetAPIKeyInfo",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/operatorSubnetRegisterAPIKeyResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subnet/apikey/register": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Register Operator with Subnet",
        "operationId": "OperatorSubnetRegisterAPIKey",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/operatorSubnetAPIKey"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/operatorSubnetRegisterAPIKeyResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subnet/login": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Login to subnet",
        "operationId": "OperatorSubnetLogin",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/operatorSubnetLoginRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/operatorSubnetLoginResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subnet/login/mfa": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Login to subnet using mfa",
        "operationId": "OperatorSubnetLoginMFA",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/operatorSubnetLoginMFARequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/operatorSubnetLoginResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subscription/info": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Subscription info",
        "operationId": "SubscriptionInfo",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/license"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subscription/namespaces/{namespace}/tenants/{tenant}/activate": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Activate a particular tenant using the existing subscription license",
        "operationId": "SubscriptionActivate",
        "parameters": [
          {
            "type": "string",
            "name": "namespace",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "A successful response."
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subscription/refresh": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Refresh existing subscription license",
        "operationId": "SubscriptionRefresh",
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/license"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/subscription/validate": {
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Validates subscription license",
        "operationId": "SubscriptionValidate",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/subscriptionValidateRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/license"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/tenants": {
      "get": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "List Tenant of All Namespaces",
        "operationId": "ListAllTenants",
        "parameters": [
          {
            "type": "string",
            "name": "sort_by",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int32",
            "name": "offset",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int32",
            "name": "limit",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/listTenantsResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "OperatorAPI"
        ],
        "summary": "Create Tenant",
        "operationId": "CreateTenant",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/createTenantRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "A successful response.",
            "schema": {
              "$ref": "#/definitions/createTenantResponse"
            }
          },
          "default": {
            "description": "Generic error response.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "AwsConfigurationSecretsmanager": {
      "type": "object",
      "required": [
        "endpoint",
        "region",
        "credentials"
      ],
      "properties": {
        "credentials": {
          "type": "object",
          "required": [
            "accesskey",
            "secretkey"
          ],
          "properties": {
            "accesskey": {
              "type": "string"
            },
            "secretkey": {
              "type": "string"
            },
            "token": {
              "type": "string"
            }
          }
        },
        "endpoint": {
          "type": "string"
        },
        "kmskey": {
          "type": "string"
        },
        "region": {
          "type": "string"
        }
      }
    },
    "AwsConfigurationSecretsmanagerCredentials": {
      "type": "object",
      "required": [
        "accesskey",
        "secretkey"
      ],
      "properties": {
        "accesskey": {
          "type": "string"
        },
        "secretkey": {
          "type": "string"
        },
        "token": {
          "type": "string"
        }
      }
    },
    "AzureConfigurationKeyvault": {
      "type": "object",
      "required": [
        "endpoint"
      ],
      "properties": {
        "credentials": {
          "type": "object",
          "required": [
            "tenant_id",
            "client_id",
            "client_secret"
          ],
          "properties": {
            "client_id": {
              "type": "string"
            },
            "client_secret": {
              "type": "string"
            },
            "tenant_id": {
              "type": "string"
            }
          }
        },
        "endpoint": {
          "type": "string"
        }
      }
    },
    "AzureConfigurationKeyvaultCredentials": {
      "type": "object",
      "required": [
        "tenant_id",
        "client_id",
        "client_secret"
      ],
      "properties": {
        "client_id": {
          "type": "string"
        },
        "client_secret": {
          "type": "string"
        },
        "tenant_id": {
          "type": "string"
        }
      }
    },
    "EncryptionConfigurationAO1KmsMtls": {
      "type": "object",
      "properties": {
        "ca": {
          "type": "string"
        },
        "crt": {
          "type": "string"
        },
        "key": {
          "type": "string"
        }
      }
    },
    "EncryptionConfigurationResponseAO1KmsMtls": {
      "type": "object",
      "properties": {
        "ca": {
          "type": "object",
          "$ref": "#/definitions/certificateInfo"
        },
        "crt": {
          "type": "object",
          "$ref": "#/definitions/certificateInfo"
        }
      }
    },
    "GcpConfigurationSecretmanager": {
      "type": "object",
      "required": [
        "project_id"
      ],
      "properties": {
        "credentials": {
          "type": "object",
          "properties": {
            "client_email": {
              "type": "string"
            },
            "client_id": {
              "type": "string"
            },
            "private_key": {
              "type": "string"
            },
            "private_key_id": {
              "type": "string"
            }
          }
        },
        "endpoint": {
          "type": "string"
        },
        "project_id": {
          "type": "string"
        }
      }
    },
    "GcpConfigurationSecretmanagerCredentials": {
      "type": "object",
      "properties": {
        "client_email": {
          "type": "string"
        },
        "client_id": {
          "type": "string"
        },
        "private_key": {
          "type": "string"
        },
        "private_key_id": {
          "type": "string"
        }
      }
    },
    "GemaltoConfigurationKeysecure": {
      "type": "object",
      "required": [
        "endpoint",
        "credentials"
      ],
      "properties": {
        "credentials": {
          "type": "object",
          "required": [
            "token",
            "domain"
          ],
          "properties": {
            "domain": {
              "type": "string"
            },
            "retry": {
              "type": "integer",
              "format": "int64"
            },
            "token": {
              "type": "string"
            }
          }
        },
        "endpoint": {
          "type": "string"
        }
      }
    },
    "GemaltoConfigurationKeysecureCredentials": {
      "type": "object",
      "required": [
        "token",
        "domain"
      ],
      "properties": {
        "domain": {
          "type": "string"
        },
        "retry": {
          "type": "integer",
          "format": "int64"
        },
        "token": {
          "type": "string"
        }
      }
    },
    "GemaltoConfigurationResponseKeysecure": {
      "type": "object",
      "required": [
        "endpoint",
        "credentials"
      ],
      "properties": {
        "credentials": {
          "type": "object",
          "required": [
            "token",
            "domain"
          ],
          "properties": {
            "domain": {
              "type": "string"
            },
            "retry": {
              "type": "integer",
              "format": "int64"
            },
            "token": {
              "type": "string"
            }
          }
        },
        "endpoint": {
          "type": "string"
        }
      }
    },
    "GemaltoConfigurationResponseKeysecureCredentials": {
      "type": "object",
      "required": [
        "token",
        "domain"
      ],
      "properties": {
        "domain": {
          "type": "string"
        },
        "retry": {
          "type": "integer",
          "format": "int64"
        },
        "token": {
          "type": "string"
        }
      }
    },
    "IdpConfigurationActiveDirectory": {
      "type": "object",
      "required": [
        "url",
        "lookup_bind_dn"
      ],
      "properties": {
        "group_search_base_dn": {
          "type": "string"
        },
        "group_search_filter": {
          "type": "string"
        },
        "lookup_bind_dn": {
          "type": "string"
        },
        "lookup_bind_password": {
          "type": "string"
        },
        "server_insecure": {
          "type": "boolean"
        },
        "server_start_tls": {
          "type": "boolean"
        },
        "skip_tls_verification": {
          "type": "boolean"
        },
        "url": {
          "type": "string"
        },
        "user_dn_search_base_dn": {
          "type": "string"
        },
        "user_dn_search_filter": {
          "type": "string"
        },
        "user_dns": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "IdpConfigurationKeysItems0": {
      "type": "object",
      "required": [
        "access_key",
        "secret_key"
      ],
      "properties": {
        "access_key": {
          "type": "string"
        },
        "secret_key": {
          "type": "string"
        }
      }
    },
    "IdpConfigurationOidc": {
      "type": "object",
      "required": [
        "configuration_url",
        "client_id",
        "secret_id",
        "claim_name"
      ],
      "properties": {
        "callback_url": {
          "type": "string"
        },
        "claim_name": {
          "type": "string"
        },
        "client_id": {
          "type": "string"
        },
        "configuration_url": {
          "type": "string"
        },
        "scopes": {
          "type": "string"
        },
        "secret_id": {
          "type": "string"
        }
      }
    },
    "LoginRequestFeatures": {
      "type": "object",
      "properties": {
        "hide_menu": {
          "type": "boolean"
        }
      }
    },
    "NodeSelectorTermMatchExpressionsItems0": {
      "description": "A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
      "type": "object",
      "required": [
        "key",
        "operator"
      ],
      "properties": {
        "key": {
          "description": "The label key that the selector applies to.",
          "type": "string"
        },
        "operator": {
          "description": "Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.",
          "type": "string"
        },
        "values": {
          "description": "An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "NodeSelectorTermMatchFieldsItems0": {
      "description": "A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
      "type": "object",
      "required": [
        "key",
        "operator"
      ],
      "properties": {
        "key": {
          "description": "The label key that the selector applies to.",
          "type": "string"
        },
        "operator": {
          "description": "Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.",
          "type": "string"
        },
        "values": {
          "description": "An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "PodAffinityTermLabelSelector": {
      "description": "A label query over a set of resources, in this case pods.",
      "type": "object",
      "properties": {
        "matchExpressions": {
          "description": "matchExpressions is a list of label selector requirements. The requirements are ANDed.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/PodAffinityTermLabelSelectorMatchExpressionsItems0"
          }
        },
        "matchLabels": {
          "description": "matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \"key\", the operator is \"In\", and the values array contains only \"value\". The requirements are ANDed.",
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        }
      }
    },
    "PodAffinityTermLabelSelectorMatchExpressionsItems0": {
      "description": "A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
      "type": "object",
      "required": [
        "key",
        "operator"
      ],
      "properties": {
        "key": {
          "description": "key is the label key that the selector applies to.",
          "type": "string"
        },
        "operator": {
          "description": "operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
          "type": "string"
        },
        "values": {
          "description": "values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "PoolAffinityNodeAffinity": {
      "description": "Describes node affinity scheduling rules for the pod.",
      "type": "object",
      "properties": {
        "preferredDuringSchedulingIgnoredDuringExecution": {
          "description": "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/PoolAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionItems0"
          }
        },
        "requiredDuringSchedulingIgnoredDuringExecution": {
          "description": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.",
          "type": "object",
          "required": [
            "nodeSelectorTerms"
          ],
          "properties": {
            "nodeSelectorTerms": {
              "description": "Required. A list of node selector terms. The terms are ORed.",
              "type": "array",
              "items": {
                "$ref": "#/definitions/nodeSelectorTerm"
              }
            }
          }
        }
      }
    },
    "PoolAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionItems0": {
      "description": "An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).",
      "type": "object",
      "required": [
        "preference",
        "weight"
      ],
      "properties": {
        "preference": {
          "description": "A node selector term, associated with the corresponding weight.",
          "type": "object",
          "$ref": "#/definitions/nodeSelectorTerm"
        },
        "weight": {
          "description": "Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.",
          "type": "integer",
          "format": "int32"
        }
      }
    },
    "PoolAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution": {
      "description": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.",
      "type": "object",
      "required": [
        "nodeSelectorTerms"
      ],
      "properties": {
        "nodeSelectorTerms": {
          "description": "Required. A list of node selector terms. The terms are ORed.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/nodeSelectorTerm"
          }
        }
      }
    },
    "PoolAffinityPodAffinity": {
      "description": "Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, pool, etc. as some other pod(s)).",
      "type": "object",
      "properties": {
        "preferredDuringSchedulingIgnoredDuringExecution": {
          "description": "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/PoolAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionItems0"
          }
        },
        "requiredDuringSchedulingIgnoredDuringExecution": {
          "description": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/podAffinityTerm"
          }
        }
      }
    },
    "PoolAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionItems0": {
      "description": "The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s)",
      "type": "object",
      "required": [
        "podAffinityTerm",
        "weight"
      ],
      "properties": {
        "podAffinityTerm": {
          "$ref": "#/definitions/podAffinityTerm"
        },
        "weight": {
          "description": "weight associated with matching the corresponding podAffinityTerm, in the range 1-100.",
          "type": "integer",
          "format": "int32"
        }
      }
    },
    "PoolAffinityPodAntiAffinity": {
      "description": "Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, pool, etc. as some other pod(s)).",
      "type": "object",
      "properties": {
        "preferredDuringSchedulingIgnoredDuringExecution": {
          "description": "The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/PoolAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionItems0"
          }
        },
        "requiredDuringSchedulingIgnoredDuringExecution": {
          "description": "If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/podAffinityTerm"
          }
        }
      }
    },
    "PoolAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionItems0": {
      "description": "The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s)",
      "type": "object",
      "required": [
        "podAffinityTerm",
        "weight"
      ],
      "properties": {
        "podAffinityTerm": {
          "$ref": "#/definitions/podAffinityTerm"
        },
        "weight": {
          "description": "weight associated with matching the corresponding podAffinityTerm, in the range 1-100.",
          "type": "integer",
          "format": "int32"
        }
      }
    },
    "PoolTolerationsItems0": {
      "description": "The pod this Toleration is attached to tolerates any taint that matches the triple \u003ckey,value,effect\u003e using the matching operator \u003coperator\u003e.",
      "type": "object",
      "properties": {
        "effect": {
          "description": "Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.",
          "type": "string"
        },
        "key": {
          "description": "Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.",
          "type": "string"
        },
        "operator": {
          "description": "Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.",
          "type": "string"
        },
        "tolerationSeconds": {
          "$ref": "#/definitions/poolTolerationSeconds"
        },
        "value": {
          "description": "Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.",
          "type": "string"
        }
      }
    },
    "PoolVolumeConfiguration": {
      "type": "object",
      "required": [
        "size"
      ],
      "properties": {
        "annotations": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "labels": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "size": {
          "type": "integer"
        },
        "storage_class_name": {
          "type": "string"
        }
      }
    },
    "TenantEndpoints": {
      "type": "object",
      "properties": {
        "console": {
          "type": "string"
        },
        "minio": {
          "type": "string"
        }
      }
    },
    "TenantSecurityResponseCustomCertificates": {
      "type": "object",
      "properties": {
        "client": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/certificateInfo"
          }
        },
        "minio": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/certificateInfo"
          }
        },
        "minioCAs": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/certificateInfo"
          }
        }
      }
    },
    "TenantStatusUsage": {
      "type": "object",
      "properties": {
        "capacity": {
          "type": "integer",
          "format": "int64"
        },
        "capacity_usage": {
          "type": "integer",
          "format": "int64"
        },
        "raw": {
          "type": "integer",
          "format": "int64"
        },
        "raw_usage": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "UpdateTenantSecurityRequestCustomCertificates": {
      "type": "object",
      "properties": {
        "minioCAsCertificates": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "minioClientCertificates": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/keyPairConfiguration"
          }
        },
        "minioServerCertificates": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/keyPairConfiguration"
          }
        },
        "secretsToBeDeleted": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "VaultConfigurationApprole": {
      "type": "object",
      "required": [
        "id",
        "secret"
      ],
      "properties": {
        "engine": {
          "type": "string"
        },
        "id": {
          "type": "string"
        },
        "retry": {
          "type": "integer",
          "format": "int64"
        },
        "secret": {
          "type": "string"
        }
      }
    },
    "VaultConfigurationResponseApprole": {
      "type": "object",
      "required": [
        "id",
        "secret"
      ],
      "properties": {
        "engine": {
          "type": "string"
        },
        "id": {
          "type": "string"
        },
        "retry": {
          "type": "integer",
          "format": "int64"
        },
        "secret": {
          "type": "string"
        }
      }
    },
    "VaultConfigurationResponseStatus": {
      "type": "object",
      "properties": {
        "ping": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "VaultConfigurationStatus": {
      "type": "object",
      "properties": {
        "ping": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "allocatableResourcesResponse": {
      "type": "object",
      "properties": {
        "cpu_priority": {
          "$ref": "#/definitions/nodeMaxAllocatableResources"
        },
        "mem_priority": {
          "$ref": "#/definitions/nodeMaxAllocatableResources"
        },
        "min_allocatable_cpu": {
          "type": "integer",
          "format": "int64"
        },
        "min_allocatable_mem": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "annotation": {
      "type": "object",
      "properties": {
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "awsConfiguration": {
      "type": "object",
      "required": [
        "secretsmanager"
      ],
      "properties": {
        "secretsmanager": {
          "type": "object",
          "required": [
            "endpoint",
            "region",
            "credentials"
          ],
          "properties": {
            "credentials": {
              "type": "object",
              "required": [
                "accesskey",
                "secretkey"
              ],
              "properties": {
                "accesskey": {
                  "type": "string"
                },
                "secretkey": {
                  "type": "string"
                },
                "token": {
                  "type": "string"
                }
              }
            },
            "endpoint": {
              "type": "string"
            },
            "kmskey": {
              "type": "string"
            },
            "region": {
              "type": "string"
            }
          }
        }
      }
    },
    "azureConfiguration": {
      "type": "object",
      "required": [
        "keyvault"
      ],
      "properties": {
        "keyvault": {
          "type": "object",
          "required": [
            "endpoint"
          ],
          "properties": {
            "credentials": {
              "type": "object",
              "required": [
                "tenant_id",
                "client_id",
                "client_secret"
              ],
              "properties": {
                "client_id": {
                  "type": "string"
                },
                "client_secret": {
                  "type": "string"
                },
                "tenant_id": {
                  "type": "string"
                }
              }
            },
            "endpoint": {
              "type": "string"
            }
          }
        }
      }
    },
    "certificateInfo": {
      "type": "object",
      "properties": {
        "domains": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "expiry": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "serialNumber": {
          "type": "string"
        }
      }
    },
    "checkOperatorVersionResponse": {
      "type": "object",
      "properties": {
        "current_version": {
          "type": "string"
        },
        "latest_version": {
          "type": "string"
        }
      }
    },
    "condition": {
      "type": "object",
      "properties": {
        "status": {
          "type": "string"
        },
        "type": {
          "type": "string"
        }
      }
    },
    "configMap": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "optional": {
          "type": "boolean"
        }
      }
    },
    "configureTenantRequest": {
      "type": "object",
      "properties": {
        "prometheusEnabled": {
          "type": "boolean"
        }
      }
    },
    "container": {
      "type": "object",
      "properties": {
        "args": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "containerID": {
          "type": "string"
        },
        "environmentVariables": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/environmentVariable"
          }
        },
        "hostPorts": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "image": {
          "type": "string"
        },
        "imageID": {
          "type": "string"
        },
        "lastState": {
          "$ref": "#/definitions/state"
        },
        "mounts": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/mount"
          }
        },
        "name": {
          "type": "string"
        },
        "ports": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "ready": {
          "type": "boolean"
        },
        "restartCount": {
          "type": "integer"
        },
        "state": {
          "$ref": "#/definitions/state"
        }
      }
    },
    "createTenantRequest": {
      "type": "object",
      "required": [
        "name",
        "namespace",
        "pools"
      ],
      "properties": {
        "access_key": {
          "type": "string"
        },
        "annotations": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "domains": {
          "type": "object",
          "$ref": "#/definitions/domainsConfiguration"
        },
        "enable_console": {
          "type": "boolean",
          "default": true
        },
        "enable_prometheus": {
          "type": "boolean",
          "default": false
        },
        "enable_tls": {
          "type": "boolean",
          "default": true
        },
        "encryption": {
          "type": "object",
          "$ref": "#/definitions/encryptionConfiguration"
        },
        "environmentVariables": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/environmentVariable"
          }
        },
        "erasureCodingParity": {
          "type": "integer"
        },
        "expose_console": {
          "type": "boolean"
        },
        "expose_minio": {
          "type": "boolean"
        },
        "idp": {
          "type": "object",
          "$ref": "#/definitions/idpConfiguration"
        },
        "image": {
          "type": "string"
        },
        "image_pull_secret": {
          "type": "string"
        },
        "image_registry": {
          "$ref": "#/definitions/imageRegistry"
        },
        "labels": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "logSearchConfiguration": {
          "$ref": "#/definitions/logSearchConfiguration"
        },
        "mount_path": {
          "type": "string"
        },
        "name": {
          "type": "string",
          "pattern": "^[a-z0-9-]{3,63}$"
        },
        "namespace": {
          "type": "string"
        },
        "pools": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/pool"
          }
        },
        "prometheusConfiguration": {
          "$ref": "#/definitions/prometheusConfiguration"
        },
        "secret_key": {
          "type": "string"
        },
        "tls": {
          "type": "object",
          "$ref": "#/definitions/tlsConfiguration"
        }
      }
    },
    "createTenantResponse": {
      "type": "object",
      "properties": {
        "console": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/tenantResponseItem"
          }
        },
        "externalIDP": {
          "type": "boolean"
        }
      }
    },
    "csrElement": {
      "type": "object",
      "properties": {
        "annotations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/annotation"
          }
        },
        "deletion_grace_period_seconds": {
          "type": "integer",
          "format": "int64"
        },
        "generate_name": {
          "type": "string"
        },
        "generation": {
          "type": "integer",
          "format": "int64"
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "resource_version": {
          "type": "string"
        },
        "status": {
          "type": "string"
        }
      }
    },
    "csrElements": {
      "type": "object",
      "properties": {
        "csrElement": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/csrElement"
          }
        }
      }
    },
    "deleteTenantRequest": {
      "type": "object",
      "properties": {
        "delete_pvcs": {
          "type": "boolean"
        }
      }
    },
    "describePVCWrapper": {
      "type": "object",
      "properties": {
        "accessModes": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "annotations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/annotation"
          }
        },
        "capacity": {
          "type": "string"
        },
        "finalizers": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "labels": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/label"
          }
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "storageClass": {
          "type": "string"
        },
        "volume": {
          "type": "string"
        },
        "volumeMode": {
          "type": "string"
        }
      }
    },
    "describePodWrapper": {
      "type": "object",
      "properties": {
        "annotations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/annotation"
          }
        },
        "conditions": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/condition"
          }
        },
        "containers": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/container"
          }
        },
        "controllerRef": {
          "type": "string"
        },
        "deletionGracePeriodSeconds": {
          "type": "integer"
        },
        "deletionTimestamp": {
          "type": "string"
        },
        "labels": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/label"
          }
        },
        "message": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "nodeName": {
          "type": "string"
        },
        "nodeSelector": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/nodeSelector"
          }
        },
        "phase": {
          "type": "string"
        },
        "podIP": {
          "type": "string"
        },
        "priority": {
          "type": "integer"
        },
        "priorityClassName": {
          "type": "string"
        },
        "qosClass": {
          "type": "string"
        },
        "reason": {
          "type": "string"
        },
        "startTime": {
          "type": "string"
        },
        "tolerations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/toleration"
          }
        },
        "volumes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/volume"
          }
        }
      }
    },
    "directPVDriveInfo": {
      "type": "object",
      "properties": {
        "allocated": {
          "type": "number",
          "format": "int64"
        },
        "capacity": {
          "type": "number",
          "format": "int64"
        },
        "drive": {
          "type": "string"
        },
        "message": {
          "type": "string"
        },
        "node": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "volumes": {
          "type": "number",
          "format": "int64"
        }
      }
    },
    "directPVVolumeInfo": {
      "type": "object",
      "properties": {
        "capacity": {
          "type": "number",
          "format": "int64"
        },
        "drive": {
          "type": "string"
        },
        "node": {
          "type": "string"
        },
        "volume": {
          "type": "string"
        }
      }
    },
    "domainsConfiguration": {
      "type": "object",
      "properties": {
        "console": {
          "type": "string"
        },
        "minio": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "encryptionConfiguration": {
      "allOf": [
        {
          "$ref": "#/definitions/metadataFields"
        },
        {
          "type": "object",
          "properties": {
            "aws": {
              "type": "object",
              "$ref": "#/definitions/awsConfiguration"
            },
            "azure": {
              "type": "object",
              "$ref": "#/definitions/azureConfiguration"
            },
            "gcp": {
              "type": "object",
              "$ref": "#/definitions/gcpConfiguration"
            },
            "gemalto": {
              "type": "object",
              "$ref": "#/definitions/gemaltoConfiguration"
            },
            "image": {
              "type": "string"
            },
            "kms_mtls": {
              "type": "object",
              "properties": {
                "ca": {
                  "type": "string"
                },
                "crt": {
                  "type": "string"
                },
                "key": {
                  "type": "string"
                }
              }
            },
            "minio_mtls": {
              "type": "object",
              "$ref": "#/definitions/keyPairConfiguration"
            },
            "raw": {
              "type": "string"
            },
            "replicas": {
              "type": "string"
            },
            "secretsToBeDeleted": {
              "type": "array",
              "items": {
                "type": "string"
              }
            },
            "securityContext": {
              "type": "object",
              "$ref": "#/definitions/securityContext"
            },
            "server_tls": {
              "type": "object",
              "$ref": "#/definitions/keyPairConfiguration"
            },
            "vault": {
              "type": "object",
              "$ref": "#/definitions/vaultConfiguration"
            }
          }
        }
      ]
    },
    "encryptionConfigurationResponse": {
      "allOf": [
        {
          "$ref": "#/definitions/metadataFields"
        },
        {
          "type": "object",
          "properties": {
            "aws": {
              "type": "object",
              "$ref": "#/definitions/awsConfiguration"
            },
            "azure": {
              "type": "object",
              "$ref": "#/definitions/azureConfiguration"
            },
            "gcp": {
              "type": "object",
              "$ref": "#/definitions/gcpConfiguration"
            },
            "gemalto": {
              "type": "object",
              "$ref": "#/definitions/gemaltoConfigurationResponse"
            },
            "image": {
              "type": "string"
            },
            "kms_mtls": {
              "type": "object",
              "properties": {
                "ca": {
                  "type": "object",
                  "$ref": "#/definitions/certificateInfo"
                },
                "crt": {
                  "type": "object",
                  "$ref": "#/definitions/certificateInfo"
                }
              }
            },
            "minio_mtls": {
              "type": "object",
              "$ref": "#/definitions/certificateInfo"
            },
            "raw": {
              "type": "string"
            },
            "replicas": {
              "type": "string"
            },
            "securityContext": {
              "type": "object",
              "$ref": "#/definitions/securityContext"
            },
            "server_tls": {
              "type": "object",
              "$ref": "#/definitions/certificateInfo"
            },
            "vault": {
              "type": "object",
              "$ref": "#/definitions/vaultConfigurationResponse"
            }
          }
        }
      ]
    },
    "environmentVariable": {
      "type": "object",
      "properties": {
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "error": {
      "type": "object",
      "required": [
        "message",
        "detailedMessage"
      ],
      "properties": {
        "code": {
          "type": "integer",
          "format": "int32"
        },
        "detailedMessage": {
          "type": "string"
        },
        "message": {
          "type": "string"
        }
      }
    },
    "eventListElement": {
      "type": "object",
      "properties": {
        "event_type": {
          "type": "string"
        },
        "last_seen": {
          "type": "integer",
          "format": "int64"
        },
        "message": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "object": {
          "type": "string"
        },
        "reason": {
          "type": "string"
        }
      }
    },
    "eventListWrapper": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/eventListElement"
      }
    },
    "formatConfiguration": {
      "type": "object",
      "required": [
        "drives",
        "force"
      ],
      "properties": {
        "drives": {
          "type": "array",
          "minLength": 1,
          "items": {
            "type": "string"
          }
        },
        "force": {
          "type": "boolean"
        }
      }
    },
    "formatDirectPVDrivesResponse": {
      "type": "object",
      "properties": {
        "formatIssuesList": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/pvFormatErrorResponse"
          }
        }
      }
    },
    "gcpConfiguration": {
      "type": "object",
      "required": [
        "secretmanager"
      ],
      "properties": {
        "secretmanager": {
          "type": "object",
          "required": [
            "project_id"
          ],
          "properties": {
            "credentials": {
              "type": "object",
              "properties": {
                "client_email": {
                  "type": "string"
                },
                "client_id": {
                  "type": "string"
                },
                "private_key": {
                  "type": "string"
                },
                "private_key_id": {
                  "type": "string"
                }
              }
            },
            "endpoint": {
              "type": "string"
            },
            "project_id": {
              "type": "string"
            }
          }
        }
      }
    },
    "gemaltoConfiguration": {
      "type": "object",
      "required": [
        "keysecure"
      ],
      "properties": {
        "keysecure": {
          "type": "object",
          "required": [
            "endpoint",
            "credentials"
          ],
          "properties": {
            "credentials": {
              "type": "object",
              "required": [
                "token",
                "domain"
              ],
              "properties": {
                "domain": {
                  "type": "string"
                },
                "retry": {
                  "type": "integer",
                  "format": "int64"
                },
                "token": {
                  "type": "string"
                }
              }
            },
            "endpoint": {
              "type": "string"
            }
          }
        }
      }
    },
    "gemaltoConfigurationResponse": {
      "type": "object",
      "required": [
        "keysecure"
      ],
      "properties": {
        "keysecure": {
          "type": "object",
          "required": [
            "endpoint",
            "credentials"
          ],
          "properties": {
            "credentials": {
              "type": "object",
              "required": [
                "token",
                "domain"
              ],
              "properties": {
                "domain": {
                  "type": "string"
                },
                "retry": {
                  "type": "integer",
                  "format": "int64"
                },
                "token": {
                  "type": "string"
                }
              }
            },
            "endpoint": {
              "type": "string"
            }
          }
        }
      }
    },
    "getDirectPVDriveListResponse": {
      "type": "object",
      "properties": {
        "drives": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/directPVDriveInfo"
          }
        }
      }
    },
    "getDirectPVVolumeListResponse": {
      "type": "object",
      "properties": {
        "volumes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/directPVVolumeInfo"
          }
        }
      }
    },
    "idpConfiguration": {
      "type": "object",
      "properties": {
        "active_directory": {
          "type": "object",
          "required": [
            "url",
            "lookup_bind_dn"
          ],
          "properties": {
            "group_search_base_dn": {
              "type": "string"
            },
            "group_search_filter": {
              "type": "string"
            },
            "lookup_bind_dn": {
              "type": "string"
            },
            "lookup_bind_password": {
              "type": "string"
            },
            "server_insecure": {
              "type": "boolean"
            },
            "server_start_tls": {
              "type": "boolean"
            },
            "skip_tls_verification": {
              "type": "boolean"
            },
            "url": {
              "type": "string"
            },
            "user_dn_search_base_dn": {
              "type": "string"
            },
            "user_dn_search_filter": {
              "type": "string"
            },
            "user_dns": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          }
        },
        "keys": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/IdpConfigurationKeysItems0"
          }
        },
        "oidc": {
          "type": "object",
          "required": [
            "configuration_url",
            "client_id",
            "secret_id",
            "claim_name"
          ],
          "properties": {
            "callback_url": {
              "type": "string"
            },
            "claim_name": {
              "type": "string"
            },
            "client_id": {
              "type": "string"
            },
            "configuration_url": {
              "type": "string"
            },
            "scopes": {
              "type": "string"
            },
            "secret_id": {
              "type": "string"
            }
          }
        }
      }
    },
    "imageRegistry": {
      "type": "object",
      "required": [
        "registry",
        "username",
        "password"
      ],
      "properties": {
        "password": {
          "type": "string"
        },
        "registry": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "keyPairConfiguration": {
      "type": "object",
      "required": [
        "crt",
        "key"
      ],
      "properties": {
        "crt": {
          "type": "string"
        },
        "key": {
          "type": "string"
        }
      }
    },
    "label": {
      "type": "object",
      "properties": {
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "license": {
      "type": "object",
      "properties": {
        "account_id": {
          "type": "integer"
        },
        "email": {
          "type": "string"
        },
        "expires_at": {
          "type": "string"
        },
        "organization": {
          "type": "string"
        },
        "plan": {
          "type": "string"
        },
        "storage_capacity": {
          "type": "integer"
        }
      }
    },
    "listPVCsResponse": {
      "type": "object",
      "properties": {
        "pvcs": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/pvcsListResponse"
          }
        }
      }
    },
    "listTenantsResponse": {
      "type": "object",
      "properties": {
        "tenants": {
          "type": "array",
          "title": "list of resulting tenants",
          "items": {
            "$ref": "#/definitions/tenantList"
          }
        },
        "total": {
          "type": "integer",
          "format": "int64",
          "title": "number of tenants accessible to tenant user"
        }
      }
    },
    "logSearchConfiguration": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string"
        },
        "postgres_image": {
          "type": "string"
        },
        "postgres_init_image": {
          "type": "string"
        },
        "postgres_securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "storageClass": {
          "type": "string",
          "default": ""
        },
        "storageSize": {
          "type": "number",
          "default": 5
        }
      }
    },
    "loginDetails": {
      "type": "object",
      "properties": {
        "isDirectPV": {
          "type": "boolean"
        },
        "loginStrategy": {
          "type": "string",
          "enum": [
            "form",
            "redirect",
            "service-account",
            "redirect-service-account"
          ]
        },
        "redirectRules": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/redirectRule"
          }
        }
      }
    },
    "loginOauth2AuthRequest": {
      "type": "object",
      "required": [
        "state",
        "code"
      ],
      "properties": {
        "code": {
          "type": "string"
        },
        "state": {
          "type": "string"
        }
      }
    },
    "loginOperatorRequest": {
      "type": "object",
      "required": [
        "jwt"
      ],
      "properties": {
        "jwt": {
          "type": "string"
        }
      }
    },
    "loginRequest": {
      "type": "object",
      "properties": {
        "accessKey": {
          "type": "string"
        },
        "features": {
          "type": "object",
          "properties": {
            "hide_menu": {
              "type": "boolean"
            }
          }
        },
        "secretKey": {
          "type": "string"
        },
        "sts": {
          "type": "string"
        }
      }
    },
    "maxAllocatableMemResponse": {
      "type": "object",
      "properties": {
        "max_memory": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "metadataFields": {
      "type": "object",
      "properties": {
        "annotations": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "labels": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "node_selector": {
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        }
      }
    },
    "mount": {
      "type": "object",
      "properties": {
        "mountPath": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "readOnly": {
          "type": "boolean"
        },
        "subPath": {
          "type": "string"
        }
      }
    },
    "mpIntegration": {
      "type": "object",
      "properties": {
        "email": {
          "type": "string"
        },
        "isInEU": {
          "type": "boolean"
        }
      }
    },
    "namespace": {
      "type": "object",
      "required": [
        "name"
      ],
      "properties": {
        "name": {
          "type": "string"
        }
      }
    },
    "nodeLabels": {
      "type": "object",
      "additionalProperties": {
        "type": "array",
        "items": {
          "type": "string"
        }
      }
    },
    "nodeMaxAllocatableResources": {
      "type": "object",
      "properties": {
        "max_allocatable_cpu": {
          "type": "integer",
          "format": "int64"
        },
        "max_allocatable_mem": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "nodeSelector": {
      "type": "object",
      "properties": {
        "key": {
          "type": "string"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "nodeSelectorTerm": {
      "description": "A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.",
      "type": "object",
      "properties": {
        "matchExpressions": {
          "description": "A list of node selector requirements by node's labels.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NodeSelectorTermMatchExpressionsItems0"
          }
        },
        "matchFields": {
          "description": "A list of node selector requirements by node's fields.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NodeSelectorTermMatchFieldsItems0"
          }
        }
      }
    },
    "operatorSessionResponse": {
      "type": "object",
      "properties": {
        "directPV": {
          "type": "boolean"
        },
        "features": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "operator": {
          "type": "boolean"
        },
        "permissions": {
          "type": "object",
          "additionalProperties": {
            "type": "array",
            "items": {
              "type": "string"
            }
          }
        },
        "status": {
          "type": "string",
          "enum": [
            "ok"
          ]
        }
      }
    },
    "operatorSubnetAPIKey": {
      "type": "object",
      "properties": {
        "apiKey": {
          "type": "string"
        }
      }
    },
    "operatorSubnetLoginMFARequest": {
      "type": "object",
      "required": [
        "username",
        "otp",
        "mfa_token"
      ],
      "properties": {
        "mfa_token": {
          "type": "string"
        },
        "otp": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "operatorSubnetLoginRequest": {
      "type": "object",
      "properties": {
        "password": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "operatorSubnetLoginResponse": {
      "type": "object",
      "properties": {
        "access_token": {
          "type": "string"
        },
        "mfa_token": {
          "type": "string"
        }
      }
    },
    "operatorSubnetRegisterAPIKeyResponse": {
      "type": "object",
      "properties": {
        "registered": {
          "type": "boolean"
        }
      }
    },
    "parityResponse": {
      "type": "array",
      "items": {
        "type": "string"
      }
    },
    "podAffinityTerm": {
      "description": "Required. A pod affinity term, associated with the corresponding weight.",
      "type": "object",
      "required": [
        "topologyKey"
      ],
      "properties": {
        "labelSelector": {
          "description": "A label query over a set of resources, in this case pods.",
          "type": "object",
          "properties": {
            "matchExpressions": {
              "description": "matchExpressions is a list of label selector requirements. The requirements are ANDed.",
              "type": "array",
              "items": {
                "$ref": "#/definitions/PodAffinityTermLabelSelectorMatchExpressionsItems0"
              }
            },
            "matchLabels": {
              "description": "matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \"key\", the operator is \"In\", and the values array contains only \"value\". The requirements are ANDed.",
              "type": "object",
              "additionalProperties": {
                "type": "string"
              }
            }
          }
        },
        "namespaces": {
          "description": "namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means \"this pod's namespace\"",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "topologyKey": {
          "description": "This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.",
          "type": "string"
        }
      }
    },
    "pool": {
      "type": "object",
      "required": [
        "servers",
        "volumes_per_server",
        "volume_configuration"
      ],
      "properties": {
        "affinity": {
          "$ref": "#/definitions/poolAffinity"
        },
        "name": {
          "type": "string"
        },
        "node_selector": {
          "description": "NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/",
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        },
        "resources": {
          "$ref": "#/definitions/poolResources"
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "servers": {
          "type": "integer"
        },
        "tolerations": {
          "$ref": "#/definitions/poolTolerations"
        },
        "volume_configuration": {
          "type": "object",
          "required": [
            "size"
          ],
          "properties": {
            "annotations": {
              "type": "object",
              "additionalProperties": {
                "type": "string"
              }
            },
            "labels": {
              "type": "object",
              "additionalProperties": {
                "type": "string"
              }
            },
            "size": {
              "type": "integer"
            },
            "storage_class_name": {
              "type": "string"
            }
          }
        },
        "volumes_per_server": {
          "type": "integer",
          "format": "int32"
        }
      }
    },
    "poolAffinity": {
      "description": "If specified, affinity will define the pod's scheduling constraints",
      "type": "object",
      "properties": {
        "nodeAffinity": {
          "description": "Describes node affinity scheduling rules for the pod.",
          "type": "object",
          "properties": {
            "preferredDuringSchedulingIgnoredDuringExecution": {
              "description": "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.",
              "type": "array",
              "items": {
                "$ref": "#/definitions/PoolAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionItems0"
              }
            },
            "requiredDuringSchedulingIgnoredDuringExecution": {
              "description": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.",
              "type": "object",
              "required": [
                "nodeSelectorTerms"
              ],
              "properties": {
                "nodeSelectorTerms": {
                  "description": "Required. A list of node selector terms. The terms are ORed.",
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/nodeSelectorTerm"
                  }
                }
              }
            }
          }
        },
        "podAffinity": {
          "description": "Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, pool, etc. as some other pod(s)).",
          "type": "object",
          "properties": {
            "preferredDuringSchedulingIgnoredDuringExecution": {
              "description": "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.",
              "type": "array",
              "items": {
                "$ref": "#/definitions/PoolAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionItems0"
              }
            },
            "requiredDuringSchedulingIgnoredDuringExecution": {
              "description": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
              "type": "array",
              "items": {
                "$ref": "#/definitions/podAffinityTerm"
              }
            }
          }
        },
        "podAntiAffinity": {
          "description": "Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, pool, etc. as some other pod(s)).",
          "type": "object",
          "properties": {
            "preferredDuringSchedulingIgnoredDuringExecution": {
              "description": "The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.",
              "type": "array",
              "items": {
                "$ref": "#/definitions/PoolAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionItems0"
              }
            },
            "requiredDuringSchedulingIgnoredDuringExecution": {
              "description": "If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
              "type": "array",
              "items": {
                "$ref": "#/definitions/podAffinityTerm"
              }
            }
          }
        }
      }
    },
    "poolResources": {
      "description": "If provided, use these requests and limit for cpu/memory resource allocation",
      "type": "object",
      "properties": {
        "limits": {
          "description": "Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
          "type": "object",
          "additionalProperties": {
            "type": "integer",
            "format": "int64"
          }
        },
        "requests": {
          "description": "Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
          "type": "object",
          "additionalProperties": {
            "type": "integer",
            "format": "int64"
          }
        }
      }
    },
    "poolTolerationSeconds": {
      "description": "TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.",
      "type": "object",
      "required": [
        "seconds"
      ],
      "properties": {
        "seconds": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "poolTolerations": {
      "description": "Tolerations allows users to set entries like effect, key, operator, value.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/PoolTolerationsItems0"
      }
    },
    "poolUpdateRequest": {
      "type": "object",
      "required": [
        "pools"
      ],
      "properties": {
        "pools": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/pool"
          }
        }
      }
    },
    "projectedVolume": {
      "type": "object",
      "properties": {
        "sources": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/projectedVolumeSource"
          }
        }
      }
    },
    "projectedVolumeSource": {
      "type": "object",
      "properties": {
        "configMap": {
          "$ref": "#/definitions/configMap"
        },
        "downwardApi": {
          "type": "boolean"
        },
        "secret": {
          "$ref": "#/definitions/secret"
        },
        "serviceAccountToken": {
          "$ref": "#/definitions/serviceAccountToken"
        }
      }
    },
    "prometheusConfiguration": {
      "type": "object",
      "properties": {
        "image": {
          "type": "string"
        },
        "init_image": {
          "type": "string"
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "sidecar_image": {
          "type": "string"
        },
        "storageClass": {
          "type": "string",
          "default": ""
        },
        "storageSize": {
          "type": "number",
          "default": 5
        }
      }
    },
    "pvFormatErrorResponse": {
      "type": "object",
      "properties": {
        "drive": {
          "type": "string"
        },
        "error": {
          "type": "string"
        },
        "node": {
          "type": "string"
        }
      }
    },
    "pvc": {
      "type": "object",
      "properties": {
        "claimName": {
          "type": "string"
        },
        "readOnly": {
          "type": "boolean"
        }
      }
    },
    "pvcsListResponse": {
      "type": "object",
      "properties": {
        "age": {
          "type": "string"
        },
        "capacity": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "status": {
          "type": "string"
        },
        "storageClass": {
          "type": "string"
        },
        "tenant": {
          "type": "string"
        },
        "volume": {
          "type": "string"
        }
      }
    },
    "redirectRule": {
      "type": "object",
      "properties": {
        "displayName": {
          "type": "string"
        },
        "redirect": {
          "type": "string"
        }
      }
    },
    "resourceQuota": {
      "type": "object",
      "properties": {
        "elements": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/resourceQuotaElement"
          }
        },
        "name": {
          "type": "string"
        }
      }
    },
    "resourceQuotaElement": {
      "type": "object",
      "properties": {
        "hard": {
          "type": "integer",
          "format": "int64"
        },
        "name": {
          "type": "string"
        },
        "used": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "secret": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "optional": {
          "type": "boolean"
        }
      }
    },
    "securityContext": {
      "type": "object",
      "required": [
        "runAsUser",
        "runAsGroup",
        "runAsNonRoot"
      ],
      "properties": {
        "fsGroup": {
          "type": "string"
        },
        "fsGroupChangePolicy": {
          "type": "string"
        },
        "runAsGroup": {
          "type": "string"
        },
        "runAsNonRoot": {
          "type": "boolean"
        },
        "runAsUser": {
          "type": "string"
        }
      }
    },
    "serviceAccountToken": {
      "type": "object",
      "properties": {
        "expirationSeconds": {
          "type": "integer"
        }
      }
    },
    "setAdministratorsRequest": {
      "type": "object",
      "properties": {
        "group_dns": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "user_dns": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "state": {
      "type": "object",
      "properties": {
        "exitCode": {
          "type": "integer"
        },
        "finished": {
          "type": "string"
        },
        "message": {
          "type": "string"
        },
        "reason": {
          "type": "string"
        },
        "signal": {
          "type": "integer"
        },
        "started": {
          "type": "string"
        },
        "state": {
          "type": "string"
        }
      }
    },
    "subscriptionValidateRequest": {
      "type": "object",
      "properties": {
        "email": {
          "type": "string"
        },
        "license": {
          "type": "string"
        },
        "password": {
          "type": "string"
        }
      }
    },
    "tenant": {
      "type": "object",
      "properties": {
        "creation_date": {
          "type": "string"
        },
        "currentState": {
          "type": "string"
        },
        "deletion_date": {
          "type": "string"
        },
        "domains": {
          "$ref": "#/definitions/domainsConfiguration"
        },
        "enable_prometheus": {
          "type": "boolean"
        },
        "encryptionEnabled": {
          "type": "boolean"
        },
        "endpoints": {
          "type": "object",
          "properties": {
            "console": {
              "type": "string"
            },
            "minio": {
              "type": "string"
            }
          }
        },
        "idpAdEnabled": {
          "type": "boolean"
        },
        "idpOidcEnabled": {
          "type": "boolean"
        },
        "image": {
          "type": "string"
        },
        "logEnabled": {
          "type": "boolean"
        },
        "minioTLS": {
          "type": "boolean"
        },
        "monitoringEnabled": {
          "type": "boolean"
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "pools": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/pool"
          }
        },
        "status": {
          "$ref": "#/definitions/tenantStatus"
        },
        "subnet_license": {
          "$ref": "#/definitions/license"
        },
        "total_size": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "tenantConfigurationResponse": {
      "type": "object",
      "properties": {
        "environmentVariables": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/environmentVariable"
          }
        }
      }
    },
    "tenantList": {
      "type": "object",
      "properties": {
        "capacity": {
          "type": "integer",
          "format": "int64"
        },
        "capacity_raw": {
          "type": "integer",
          "format": "int64"
        },
        "capacity_raw_usage": {
          "type": "integer",
          "format": "int64"
        },
        "capacity_usage": {
          "type": "integer",
          "format": "int64"
        },
        "creation_date": {
          "type": "string"
        },
        "currentState": {
          "type": "string"
        },
        "deletion_date": {
          "type": "string"
        },
        "domains": {
          "type": "object",
          "$ref": "#/definitions/domainsConfiguration"
        },
        "health_status": {
          "type": "string"
        },
        "instance_count": {
          "type": "integer"
        },
        "name": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "pool_count": {
          "type": "integer"
        },
        "tiers": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/tenantTierElement"
          }
        },
        "total_size": {
          "type": "integer"
        },
        "volume_count": {
          "type": "integer"
        }
      }
    },
    "tenantLogs": {
      "type": "object",
      "properties": {
        "annotations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/annotation"
          }
        },
        "dbAnnotations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/annotation"
          }
        },
        "dbImage": {
          "type": "string"
        },
        "dbInitImage": {
          "type": "string"
        },
        "dbLabels": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/label"
          }
        },
        "dbNodeSelector": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/nodeSelector"
          }
        },
        "dbSecurityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "dbServiceAccountName": {
          "type": "string"
        },
        "disabled": {
          "type": "boolean"
        },
        "diskCapacityGB": {
          "type": "string"
        },
        "image": {
          "type": "string"
        },
        "labels": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/label"
          }
        },
        "logCPURequest": {
          "type": "string"
        },
        "logDBCPURequest": {
          "type": "string"
        },
        "logDBMemRequest": {
          "type": "string"
        },
        "logMemRequest": {
          "type": "string"
        },
        "nodeSelector": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/nodeSelector"
          }
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "serviceAccountName": {
          "type": "string"
        }
      }
    },
    "tenantMonitoringInfo": {
      "type": "object",
      "properties": {
        "annotations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/annotation"
          }
        },
        "diskCapacityGB": {
          "type": "string"
        },
        "image": {
          "type": "string"
        },
        "initImage": {
          "type": "string"
        },
        "labels": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/label"
          }
        },
        "monitoringCPURequest": {
          "type": "string"
        },
        "monitoringMemRequest": {
          "type": "string"
        },
        "nodeSelector": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/nodeSelector"
          }
        },
        "prometheusEnabled": {
          "type": "boolean"
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        },
        "serviceAccountName": {
          "type": "string"
        },
        "sidecarImage": {
          "type": "string"
        },
        "storageClassName": {
          "type": "string"
        },
        "toggle": {
          "type": "boolean"
        }
      }
    },
    "tenantPod": {
      "type": "object",
      "required": [
        "name"
      ],
      "properties": {
        "name": {
          "type": "string"
        },
        "node": {
          "type": "string"
        },
        "podIP": {
          "type": "string"
        },
        "restarts": {
          "type": "integer"
        },
        "status": {
          "type": "string"
        },
        "timeCreated": {
          "type": "integer"
        }
      }
    },
    "tenantResponseItem": {
      "type": "object",
      "properties": {
        "access_key": {
          "type": "string"
        },
        "secret_key": {
          "type": "string"
        },
        "url": {
          "type": "string"
        }
      }
    },
    "tenantSecurityResponse": {
      "type": "object",
      "properties": {
        "autoCert": {
          "type": "boolean"
        },
        "customCertificates": {
          "type": "object",
          "properties": {
            "client": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/certificateInfo"
              }
            },
            "minio": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/certificateInfo"
              }
            },
            "minioCAs": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/certificateInfo"
              }
            }
          }
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        }
      }
    },
    "tenantStatus": {
      "type": "object",
      "properties": {
        "drives_healing": {
          "type": "integer",
          "format": "int32"
        },
        "drives_offline": {
          "type": "integer",
          "format": "int32"
        },
        "drives_online": {
          "type": "integer",
          "format": "int32"
        },
        "health_status": {
          "type": "string"
        },
        "usage": {
          "type": "object",
          "properties": {
            "capacity": {
              "type": "integer",
              "format": "int64"
            },
            "capacity_usage": {
              "type": "integer",
              "format": "int64"
            },
            "raw": {
              "type": "integer",
              "format": "int64"
            },
            "raw_usage": {
              "type": "integer",
              "format": "int64"
            }
          }
        },
        "write_quorum": {
          "type": "integer",
          "format": "int32"
        }
      }
    },
    "tenantTierElement": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "size": {
          "type": "integer",
          "format": "int64"
        },
        "type": {
          "type": "string"
        }
      }
    },
    "tenantUsage": {
      "type": "object",
      "properties": {
        "disk_used": {
          "type": "integer",
          "format": "int64"
        },
        "used": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "tenantYAML": {
      "type": "object",
      "properties": {
        "yaml": {
          "type": "string"
        }
      }
    },
    "tlsConfiguration": {
      "type": "object",
      "properties": {
        "minioCAsCertificates": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "minioClientCertificates": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/keyPairConfiguration"
          }
        },
        "minioServerCertificates": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/keyPairConfiguration"
          }
        }
      }
    },
    "toleration": {
      "type": "object",
      "properties": {
        "effect": {
          "type": "string"
        },
        "key": {
          "type": "string"
        },
        "operator": {
          "type": "string"
        },
        "tolerationSeconds": {
          "type": "integer"
        },
        "value": {
          "type": "string"
        }
      }
    },
    "updateDomainsRequest": {
      "type": "object",
      "properties": {
        "domains": {
          "$ref": "#/definitions/domainsConfiguration"
        }
      }
    },
    "updateTenantConfigurationRequest": {
      "type": "object",
      "properties": {
        "environmentVariables": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/environmentVariable"
          }
        },
        "keysToBeDeleted": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "updateTenantRequest": {
      "type": "object",
      "properties": {
        "enable_prometheus": {
          "type": "boolean"
        },
        "image": {
          "type": "string",
          "pattern": "^((.*?)/(.*?):(.+))$"
        },
        "image_pull_secret": {
          "type": "string"
        },
        "image_registry": {
          "$ref": "#/definitions/imageRegistry"
        }
      }
    },
    "updateTenantSecurityRequest": {
      "type": "object",
      "properties": {
        "autoCert": {
          "type": "boolean"
        },
        "customCertificates": {
          "type": "object",
          "properties": {
            "minioCAsCertificates": {
              "type": "array",
              "items": {
                "type": "string"
              }
            },
            "minioClientCertificates": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/keyPairConfiguration"
              }
            },
            "minioServerCertificates": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/keyPairConfiguration"
              }
            },
            "secretsToBeDeleted": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          }
        },
        "securityContext": {
          "type": "object",
          "$ref": "#/definitions/securityContext"
        }
      }
    },
    "vaultConfiguration": {
      "type": "object",
      "required": [
        "endpoint",
        "approle"
      ],
      "properties": {
        "approle": {
          "type": "object",
          "required": [
            "id",
            "secret"
          ],
          "properties": {
            "engine": {
              "type": "string"
            },
            "id": {
              "type": "string"
            },
            "retry": {
              "type": "integer",
              "format": "int64"
            },
            "secret": {
              "type": "string"
            }
          }
        },
        "endpoint": {
          "type": "string"
        },
        "engine": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "status": {
          "type": "object",
          "properties": {
            "ping": {
              "type": "integer",
              "format": "int64"
            }
          }
        }
      }
    },
    "vaultConfigurationResponse": {
      "type": "object",
      "required": [
        "endpoint",
        "approle"
      ],
      "properties": {
        "approle": {
          "type": "object",
          "required": [
            "id",
            "secret"
          ],
          "properties": {
            "engine": {
              "type": "string"
            },
            "id": {
              "type": "string"
            },
            "retry": {
              "type": "integer",
              "format": "int64"
            },
            "secret": {
              "type": "string"
            }
          }
        },
        "endpoint": {
          "type": "string"
        },
        "engine": {
          "type": "string"
        },
        "namespace": {
          "type": "string"
        },
        "prefix": {
          "type": "string"
        },
        "status": {
          "type": "object",
          "properties": {
            "ping": {
              "type": "integer",
              "format": "int64"
            }
          }
        }
      }
    },
    "volume": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string"
        },
        "projected": {
          "$ref": "#/definitions/projectedVolume"
        },
        "pvc": {
          "$ref": "#/definitions/pvc"
        }
      }
    }
  },
  "securityDefinitions": {
    "key": {
      "type": "oauth2",
      "flow": "accessCode",
      "authorizationUrl": "http://min.io",
      "tokenUrl": "http://min.io"
    }
  },
  "security": [
    {
      "key": []
    }
  ]
}`))
}
