// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const FileFontIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Trazado 450"
        d="M235.991 77.198c.388-15.754.958-32.241-.5-47.941-1.094-11.755-6.193-21.736-17.831-25.914a42.421 42.421 0 0 0-5.017-1.448c-6.549-1.478-13.432-1.6-20.09-1.8-11.726-.343-23.448.365-35.175.314-23.493-.1-46.985.323-70.479.414q-4.228.016-8.456.017H36.237a17.26 17.26 0 0 0-17.24 17.241v220.678A17.259 17.259 0 0 0 36.237 256h182.541a17.259 17.259 0 0 0 17.241-17.241V128.816c-.007-17.183-.454-34.458-.028-51.618Zm-20.922 145.988a14.888 14.888 0 0 1-14.888 14.888H51.813a14.888 14.888 0 0 1-14.888-14.888V33.662a14.888 14.888 0 0 1 14.888-14.888h99.548v25.459a37.8 37.8 0 0 0 37.757 37.759h25.951Zm0-157.656h-25.951a21.321 21.321 0 0 1-21.3-21.3V18.771h32.359a14.888 14.888 0 0 1 14.888 14.888Z"
      />
      <path
        data-name="Trazado 451"
        d="M182.548 83.841a8.758 8.758 0 0 0-6.293 2.408 8.758 8.758 0 0 0-2.721 6.164c-.094 3.782-4.306 9.1-10.941 11.1-12.038 3.631-30.066 2.206-43.232 1.163-4.439-.351-8.273-.655-11.49-.746-10.771-.3-17.189 3.835-20.7 7.365-5.5 5.526-7.347 12.842-7.571 20.381-.1 3.232-.545 6.4 1.436 9.188a8.729 8.729 0 0 0 7.057 3.66h1.932c3.206 0 5.272-2.557 6.179-5.394.88-2.755.889-5.681 1.086-8.538.174-2.509.518-5.1 2.416-6.953 1.544-1.508 4.119-2.224 7.659-2.122 2.773.08 6.4.366 10.6.7 2.125.168 4.374.344 6.7.509a283.562 283.562 0 0 1-1.593 29.877h-25.08a8.8 8.8 0 0 0-8.8 8.8 8.8 8.8 0 0 0 8.8 8.8h22.449c-2.426 12.2-6.025 22.628-11.124 27.883-2.627 2.707-4.779 3.054-6.362 3.054-7.431 0-8.671-5.945-8.75-9.4a8.8 8.8 0 0 0-8.8-8.8 8.8 8.8 0 0 0-8.8 8.792 32.28 32.28 0 0 0 3.064 12.92c4.373 9.077 12.64 14.074 23.28 14.075a26.113 26.113 0 0 0 18.985-8.4c8.565-8.827 13.551-24.242 16.438-40.135h18.471a8.8 8.8 0 0 0 8.8-8.8 8.8 8.8 0 0 0-8.8-8.8h-16.049c1.153-11.616 1.425-22.208 1.444-29.165 8.812-.018 17.721-.757 25.42-3.079 13.5-4.074 23.143-15.385 23.447-27.508a8.8 8.8 0 0 0-8.557-8.999Z"
      />
      <path data-name="Rect\xE1ngulo 902" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default FileFontIcon;
