// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const FileMusicIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <g data-name="Grupo 1552">
        <path
          data-name="Trazado 470"
          d="M235.996 77.198c.387-15.753.958-32.242-.5-47.941-1.093-11.756-6.193-21.735-17.832-25.915a42.412 42.412 0 0 0-5.016-1.447c-6.549-1.479-13.431-1.6-20.09-1.8-11.726-.345-23.448.365-35.176.314-23.494-.1-46.986.322-70.479.414q-4.228.016-8.456.017H36.241A17.26 17.26 0 0 0 19 18.082v220.679a17.26 17.26 0 0 0 17.241 17.24h182.54a17.26 17.26 0 0 0 17.241-17.24V128.816c-.002-17.184-.448-34.459-.026-51.618Zm-20.921 145.986a14.889 14.889 0 0 1-14.888 14.889H51.818a14.89 14.89 0 0 1-14.889-14.888V33.662a14.888 14.888 0 0 1 14.889-14.888h99.548v25.458a37.8 37.8 0 0 0 37.756 37.759h25.952Zm0-157.657h-25.952a21.32 21.32 0 0 1-21.295-21.3V18.769h32.359a14.887 14.887 0 0 1 14.888 14.889Z"
        />
        <path
          data-name="Trazado 471"
          d="m170.219 93.84-67.656 9.02-.128.016a13.3 13.3 0 0 0-12.025 13.473v55.664a22.934 22.934 0 0 0-7.98-1.435 23.085 23.085 0 0 0-23.061 23.061 23.085 23.085 0 0 0 23.06 23.059 23.084 23.084 0 0 0 23.059-23.058v-43.227c.361-4.418 1.57-5.6 2.015-5.89l58.69-7.827a1.443 1.443 0 0 1 .764.238 1.855 1.855 0 0 1 .25 1.174v23.663a23 23 0 0 0-7.981-1.434 23.086 23.086 0 0 0-23.059 23.06 23.085 23.085 0 0 0 23.059 23.058 23.085 23.085 0 0 0 23.059-23.058v-77.608c0-4.089-1.2-7.245-3.565-9.382a11.106 11.106 0 0 0-8.5-2.568ZM82.43 201.614a7.989 7.989 0 0 1-7.979-7.979 7.989 7.989 0 0 1 7.979-7.98 7.99 7.99 0 0 1 7.98 7.98 7.988 7.988 0 0 1-7.984 7.98Zm84.776-82.429c-.23 1.876-1.1 2.3-1.539 2.369l-57.957 7.728-.134.018a6.169 6.169 0 0 1-2.088 0v-8.793c0-2.208.833-2.8 1.762-3.063l58.3-7.776a2.29 2.29 0 0 1 1.444.261 1.972 1.972 0 0 1 .215 1.139Zm-7.979 72.19a7.991 7.991 0 0 1-7.98-7.981 7.991 7.991 0 0 1 7.98-7.981 7.991 7.991 0 0 1 7.981 7.979 7.993 7.993 0 0 1-7.989 7.984Z"
        />
      </g>
      <path data-name="Rect\xE1ngulo 914" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default FileMusicIcon;
