// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const FileTxtIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Trazado 426"
        d="M235.995 77.197c.388-15.753.958-32.242-.5-47.941-1.094-11.756-6.193-21.735-17.831-25.914a42.4 42.4 0 0 0-5.017-1.448c-6.549-1.478-13.432-1.6-20.09-1.8-11.726-.343-23.448.366-35.175.314-23.493-.1-46.985.323-70.479.414q-4.228.018-8.455.017H36.241A17.26 17.26 0 0 0 19 18.08v220.679A17.261 17.261 0 0 0 36.241 256h182.542a17.26 17.26 0 0 0 17.24-17.241V128.815c.001-17.183-.45-34.459-.028-51.618Zm-20.922 145.988a14.888 14.888 0 0 1-14.888 14.888H51.816a14.888 14.888 0 0 1-14.892-14.884V33.661a14.888 14.888 0 0 1 14.888-14.888h99.548v25.459a37.8 37.8 0 0 0 37.764 37.757h25.951Zm0-157.656h-25.949a21.321 21.321 0 0 1-21.3-21.3V18.77h32.359a14.888 14.888 0 0 1 14.888 14.888Z"
      />
      <path
        data-name="Trazado 427"
        d="M130.985 69.292h-69.1a8.455 8.455 0 0 1-8.455-8.455 8.455 8.455 0 0 1 8.455-8.455h69.1a8.455 8.455 0 0 1 8.455 8.455 8.455 8.455 0 0 1-8.455 8.455Z"
      />
      <path
        data-name="Trazado 428"
        d="M130.985 102.607h-69.1a8.455 8.455 0 0 1-8.455-8.455 8.455 8.455 0 0 1 8.455-8.455h69.1a8.455 8.455 0 0 1 8.455 8.455 8.455 8.455 0 0 1-8.455 8.455Z"
      />
      <path
        data-name="Trazado 429"
        d="M183.891 136.458H61.876a8.455 8.455 0 0 1-8.455-8.455 8.455 8.455 0 0 1 8.455-8.455h122.011a8.455 8.455 0 0 1 8.455 8.455 8.456 8.456 0 0 1-8.451 8.455Z"
      />
      <path
        data-name="Trazado 430"
        d="M183.891 170.309H61.876a8.455 8.455 0 0 1-8.455-8.455 8.455 8.455 0 0 1 8.455-8.455h122.011a8.455 8.455 0 0 1 8.455 8.455 8.456 8.456 0 0 1-8.451 8.455Z"
      />
      <path
        data-name="Trazado 431"
        d="M183.891 204.164H61.876a8.455 8.455 0 0 1-8.455-8.455 8.455 8.455 0 0 1 8.455-8.455h122.011a8.455 8.455 0 0 1 8.455 8.455 8.456 8.456 0 0 1-8.451 8.455Z"
      />
      <path data-name="Rect\xE1ngulo 908" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default FileTxtIcon;
