// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import React, { SVGProps } from "react";

const FilterIcon = (props: SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      className={`min-icon`}
      fill={"currentcolor"}
      width="14"
      height="13.088"
      viewBox="0 0 14 13.088"
      {...props}
    >
      <g id="filter-icon.a949c200" transform="translate(-231.827 -340.123)">
        <line
          id="Línea_659"
          data-name="Línea 659"
          x2="14"
          transform="translate(231.827 346.667)"
          fill="none"
          stroke="#434343"
          strokeWidth="1"
        />
        <g
          id="Grupo_2472"
          data-name="Grupo 2472"
          transform="translate(240.693 344.614)"
        >
          <circle
            id="Elipse_611"
            data-name="Elipse 611"
            cx="2.053"
            cy="2.053"
            r="2.053"
            transform="translate(0 0)"
            fill="#fff"
          />
          <circle
            id="Elipse_612"
            data-name="Elipse 612"
            cx="1.597"
            cy="1.597"
            r="1.597"
            transform="translate(0.456 0.456)"
            fill="none"
            stroke="#414141"
            strokeWidth="1"
          />
        </g>
        <line
          id="Línea_660"
          data-name="Línea 660"
          x2="14"
          transform="translate(231.827 342.22)"
          fill="none"
          stroke="#434343"
          strokeWidth="1"
        />
        <g
          id="Grupo_2473"
          data-name="Grupo 2473"
          transform="translate(232.394 340.167)"
        >
          <circle
            id="Elipse_613"
            data-name="Elipse 613"
            cx="2.053"
            cy="2.053"
            r="2.053"
            transform="translate(0 0)"
            fill="#fff"
          />
          <circle
            id="Elipse_614"
            data-name="Elipse 614"
            cx="1.597"
            cy="1.597"
            r="1.597"
            transform="translate(0.456 0.456)"
            fill="none"
            stroke="#414141"
            strokeWidth="1"
          />
        </g>
        <line
          id="Línea_661"
          data-name="Línea 661"
          x2="14"
          transform="translate(231.827 351.114)"
          fill="none"
          stroke="#434343"
          strokeWidth="1"
        />
        <g
          id="Grupo_2474"
          data-name="Grupo 2474"
          transform="translate(235.161 349.061)"
        >
          <circle
            id="Elipse_615"
            data-name="Elipse 615"
            cx="2.053"
            cy="2.053"
            r="2.053"
            transform="translate(0 0)"
            fill="#fff"
          />
          <circle
            id="Elipse_616"
            data-name="Elipse 616"
            cx="1.597"
            cy="1.597"
            r="1.597"
            transform="translate(0.456 0.456)"
            fill="none"
            stroke="#414141"
            strokeWidth="1"
          />
        </g>
      </g>
    </svg>
  );
};

export default FilterIcon;
