// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const FormatDrivesIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="clip-path">
        <rect
          id="Rectángulo_1043"
          data-name="Rectángulo 1043"
          width="255.479"
          height="241.736"
          fill="none"
        />
      </clipPath>
      <clipPath id="clip-Format_Drives">
        <rect width="256" height="256" />
      </clipPath>
    </defs>
    <g
      id="Format_Drives"
      data-name="Format Drives"
      clipPath="url(#clip-Format_Drives)"
    >
      <rect width="256" height="256" fill="#fff" />
      <g id="Format_Drives_Icon" data-name="Format Drives Icon">
        <g
          id="Format_Drives_Icon-2"
          data-name="Format Drives Icon"
          transform="translate(0 -3)"
        >
          <g id="Grupo_2430" data-name="Grupo 2430" transform="translate(0 10)">
            <path
              id="Trazado_7192"
              data-name="Trazado 7192"
              d="M0,256.464v65.03c0,9.7,41.2,28.6,116.725,28.6s116.722-18.726,116.722-28.6v-65.13c-26.62,13.381-71.916,20.19-116.722,20.19S26.621,269.674,0,256.464M40.1,318.11A17.441,17.441,0,1,1,45.765,294.1,17.442,17.442,0,0,1,40.1,318.11"
              transform="translate(0 -108.359)"
            />
            <path
              id="Trazado_7193"
              data-name="Trazado 7193"
              d="M223.775,18.83C207.485,9.744,170.954,0,116.724,0,41.2,0,0,18.9,0,28.6S41.2,57.2,116.724,57.2l0,0a393.878,393.878,0,0,0,42.7-2.213,48.4,48.4,0,0,0,.4,20.494,428.272,428.272,0,0,1-43.1,2.145c-44.807,0-90.1-6.877-116.724-20.19v61.728c0,9.7,41.2,28.6,116.724,28.6s116.722-18.9,116.722-28.6V104.95a48.484,48.484,0,0,0-9.672-86.12M40.1,121.058a17.441,17.441,0,1,1,5.666-24.006A17.441,17.441,0,0,1,40.1,121.058m167.186-18.426a38.3,38.3,0,1,1,38.3-38.3,38.3,38.3,0,0,1-38.3,38.3"
              transform="translate(0)"
            />
            <path
              id="Trazado_7194"
              data-name="Trazado 7194"
              d="M352.322,69.425,344.043,77.7l-.913-.912a9.594,9.594,0,0,0-13.553,0L316.939,89.432a.185.185,0,0,0-.014.017.823.823,0,0,0-.054.065h0a1.109,1.109,0,0,0-.091.125c-.006.009-.013.016-.018.025l-4.4,7.751a1.091,1.091,0,0,0,.177,1.309l2.98,2.979v0l0,0,3.79,3.79,0,0,0,0,3.79,3.79v0h0l3.789,3.789,0,0,0,0,3.79,3.79v0h0l3.79,3.79,0,0,0,0,2.981,2.98a1.09,1.09,0,0,0,1.719-.233l4.327-7.623,12.534-12.534a9.6,9.6,0,0,0,0-13.553l-.912-.913,8.279-8.28a7.844,7.844,0,0,0-11.093-11.093M338,121.1l-1.383-1.385,2.27-4a1.091,1.091,0,0,0-1.9-1.077l-1.973,3.477-2.193-2.193,2.27-4a1.09,1.09,0,0,0-1.9-1.076l-1.973,3.477-2.194-2.195,2.27-4a1.09,1.09,0,0,0-1.9-1.077l-1.973,3.477-2.193-2.193,2.27-4a1.09,1.09,0,0,0-1.9-1.076l-1.973,3.477-2.194-2.194,2.27-4a1.09,1.09,0,0,0-1.9-1.077l-1.973,3.477-2.194-2.194,2.271-4a1.091,1.091,0,0,0-1.9-1.077l-1.973,3.477-1.382-1.382,3.283-5.784,23.33,23.33Z"
              transform="translate(-131.967 -28.375)"
            />
          </g>
        </g>
        <rect
          id="Rectángulo_1044"
          data-name="Rectángulo 1044"
          width="256"
          height="256"
          fill="none"
        />
      </g>
    </g>
  </svg>
);

export default FormatDrivesIcon;
