// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const GroupsIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <g data-name="groups-icn">
        <path
          data-name="Trazado 464"
          d="M80.48 229.312a27.075 27.075 0 0 1-24.56-14.615 29.94 29.94 0 0 1 2.269-30.668v-.007c.519-.729.982-1.367 1.418-1.952l.008-.006a84.019 84.019 0 0 1 28.115-23.5 87.373 87.373 0 0 1 35.739-9.917 83.994 83.994 0 0 1 4.172-.107 85.882 85.882 0 0 1 18.631 2.076 89.934 89.934 0 0 1 18.062 6.117 86.479 86.479 0 0 1 32.679 25.974 30.568 30.568 0 0 1 3.2 31.789 26.323 26.323 0 0 1-9.982 10.9 28.124 28.124 0 0 1-14.539 3.924Zm43.97-61.409a67.92 67.92 0 0 0-27.724 7.673 64.647 64.647 0 0 0-21.71 18.1c-.32.426-.626.852-.945 1.3l-.116.162a10.394 10.394 0 0 0-.91 10.676 7.736 7.736 0 0 0 2.277 2.691 8.546 8.546 0 0 0 5.158 1.516h95.217c3.461 0 5.9-1.382 7.255-4.114v-.007a10.376 10.376 0 0 0 .951-5.807 11.664 11.664 0 0 0-2.273-5.746 66.98 66.98 0 0 0-23.879-19.38 68.976 68.976 0 0 0-30.14-7.144 70.658 70.658 0 0 0-3.161.076Zm87.819 40.475.254-2.2a40.828 40.828 0 0 0-.3-11.552l-.392-2.3h21.988c2.574 0 4.378-1.014 5.361-3.014v-.014a7.766 7.766 0 0 0 .718-4.344 8.714 8.714 0 0 0-1.715-4.319 52.307 52.307 0 0 0-18.683-15.17 53.964 53.964 0 0 0-23.583-5.594c-.883 0-1.722.021-2.488.062h-.01c-1.158.055-2.323.21-3.557.372-.15.021-.306.041-.457.058l-.817.106-.649-.505a98.534 98.534 0 0 0-13.759-8.872l-3.959-2.151 4.269-1.443a67.359 67.359 0 0 1 18.122-3.6c1.1-.055 2.213-.083 3.315-.083a67.958 67.958 0 0 1 14.8 1.649 71.23 71.23 0 0 1 14.336 4.849 68.418 68.418 0 0 1 25.905 20.624 24.5 24.5 0 0 1 2.584 25.507 21.121 21.121 0 0 1-8.038 8.776 22.614 22.614 0 0 1-11.7 3.154Zm-189.943 0a22.751 22.751 0 0 1-11.626-3.113 21.723 21.723 0 0 1-8.137-8.636v-.006a24.022 24.022 0 0 1 1.831-24.617 42.21 42.21 0 0 1 1.138-1.567 66.738 66.738 0 0 1 22.314-18.666 69.372 69.372 0 0 1 28.369-7.873 68.088 68.088 0 0 1 3.265-.079 68.894 68.894 0 0 1 21.835 3.618l4.27 1.423-3.944 2.168a99.584 99.584 0 0 0-13.552 8.982l-.657.519-.827-.113a50.98 50.98 0 0 0-7.089-.55c-.908 0-1.719.021-2.488.062h-.007a53.11 53.11 0 0 0-21.686 6 50.7 50.7 0 0 0-16.979 14.13c-.214.309-.44.615-.657.91l-.2.275a7.817 7.817 0 0 0-.675 7.986l.008.01a5.536 5.536 0 0 0 1.663 1.966 6.355 6.355 0 0 0 3.832 1.12h21.83l-.389 2.295a40.514 40.514 0 0 0-.269 11.55l.262 2.2ZM70.893 84.196a57.261 57.261 0 0 1 57.2-57.2 57.257 57.257 0 0 1 57.188 57.2 57.26 57.26 0 0 1-57.188 57.2 57.264 57.264 0 0 1-57.2-57.197Zm19.29 0a37.952 37.952 0 0 0 37.909 37.909 37.952 37.952 0 0 0 37.911-37.909 37.952 37.952 0 0 0-37.911-37.908 37.952 37.952 0 0 0-37.909 37.911Zm95.572 53.568a45.7 45.7 0 0 1-9.626-3.508l-2.433-1.213 1.908-1.935a66.163 66.163 0 0 0 7.772-9.446l.876-1.3 1.464.563a29.378 29.378 0 0 0 10.546 2.041 29.531 29.531 0 0 0 29.507-29.49 29.532 29.532 0 0 0-29.507-29.493 12.65 12.65 0 0 0-1.656.154c-.381.052-.773.107-1.189.145l-1.553.141-.5-1.478a66.318 66.318 0 0 0-4.962-11.288l-1.325-2.381 2.676-.512a45.609 45.609 0 0 1 8.5-.828 45.6 45.6 0 0 1 45.548 45.54 45.594 45.594 0 0 1-45.548 45.537 44.9 44.9 0 0 1-10.496-1.249Zm-171.42-44.29a45.586 45.586 0 0 1 45.526-45.54 45.391 45.391 0 0 1 8.56.835l2.69.512-1.339 2.385a66.792 66.792 0 0 0-4.993 11.292l-.5 1.48-1.557-.154c-.395-.038-.77-.089-1.134-.141a12.977 12.977 0 0 0-1.726-.162 29.517 29.517 0 0 0-29.479 29.493 29.517 29.517 0 0 0 29.479 29.49 29.18 29.18 0 0 0 10.57-2.048l1.453-.561.884 1.285a68.636 68.636 0 0 0 7.794 9.46l1.913 1.941-2.439 1.206a46.366 46.366 0 0 1-9.652 3.512 44.893 44.893 0 0 1-10.522 1.25 45.583 45.583 0 0 1-45.527-45.535Z"
        />
      </g>
      <path data-name="Rect\xE1ngulo 886" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default GroupsIcon;
