// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const OfflineRegistrationIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    width="26.9"
    height="26.9"
    {...props}
  >
    <defs>
      <clipPath id="Offline-Registration_svg__a">
        <path
          data-name="Rect\xE1ngulo 1604"
          fill="none"
          d="M0 0h256v199.086H0z"
        />
      </clipPath>
    </defs>
    <path data-name="Rect\xE1ngulo 1602" fill="none" d="M0 0h256v256H0z" />
    <g data-name="Grupo 2526">
      <path
        data-name="Rect\xE1ngulo 1603"
        fill="#00142f"
        d="m19.235 39.602 10.497-10.49L218.26 217.77l-10.497 10.49z"
      />
      <g data-name="Grupo 2525">
        <g
          data-name="Grupo 2524"
          clipPath="url(#Offline-Registration_svg__a)"
          fill="#00142f"
          transform="translate(0 29.146)"
        >
          <path
            data-name="Trazado 7273"
            d="m17.968 79.492.007.015a55.559 55.559 0 0 0-17.96 42.3 57.238 57.238 0 0 0 18.783 42.92 65.482 65.482 0 0 0 44.3 16.431h105.817L51.268 63.545a68.63 68.63 0 0 0-33.3 15.947"
          />
          <path
            data-name="Trazado 7274"
            d="m222.825 99.169-.074.015h-.333l-.326-.03a22.226 22.226 0 0 1-9.028-2.8 4.017 4.017 0 0 0-.651-.3 3.823 3.823 0 0 0-.533.244 18.331 18.331 0 0 1-9.665 2.745 18.542 18.542 0 0 1-3.559-.348l-.955-.185-.866-.429a19.149 19.149 0 0 1-9.332-10 5.281 5.281 0 0 0-.3-.525 4.064 4.064 0 0 0-.474-.1 18.625 18.625 0 0 1-12.12-6.21l-.585-.666-.422-.792a19.8 19.8 0 0 1-1.843-13.35 6.256 6.256 0 0 0 .067-.9 4.811 4.811 0 0 0-.437-.511 19.647 19.647 0 0 1-6.209-12.306l-.089-.807.089-.8a19.526 19.526 0 0 1 5.21-11.211c-.644-.688-1.251-1.413-1.924-2.079a71.234 71.234 0 0 0-49.687-19.901 68.071 68.071 0 0 0-38.525 11.6l140.41 140.462c.118-.1.266-.192.392-.289v-.007a45.043 45.043 0 0 0 16.428-36.742c0-14.652-5.876-25.849-14.66-33.774"
          />
          <path
            data-name="Trazado 7275"
            d="M255.963 51.509a15.953 15.953 0 0 0-5.121-10.049 8.872 8.872 0 0 1-1.48-1.991 9.8 9.8 0 0 1 .059-2.753 16.071 16.071 0 0 0-1.487-10.967l-.207-.385-.3-.333a14.943 14.943 0 0 0-9.82-5 8.149 8.149 0 0 1-2.316-.7 8.935 8.935 0 0 1-1.359-2.096 15.448 15.448 0 0 0-7.563-8.192l-.437-.215-.481-.1a14.62 14.62 0 0 0-10.633 1.965 8.262 8.262 0 0 1-2.405.888 8.3 8.3 0 0 1-2.401-.888 14.639 14.639 0 0 0-10.638-1.961l-.474.1-.444.215a15.505 15.505 0 0 0-7.563 8.192 8.821 8.821 0 0 1-1.369 2.109 8.149 8.149 0 0 1-2.316.7 14.96 14.96 0 0 0-9.82 5l-.3.333-.207.392a16.144 16.144 0 0 0-1.48 10.9 9.96 9.96 0 0 1 .059 2.775 9.2 9.2 0 0 1-1.487 2.013 15.9 15.9 0 0 0-5.103 10.048l-.044.4.044.4a15.934 15.934 0 0 0 5.106 10.057 9.031 9.031 0 0 1 1.487 1.983 9.861 9.861 0 0 1-.059 2.76 16.112 16.112 0 0 0 1.48 10.952l.207.392.3.333a14.96 14.96 0 0 0 9.82 5 8.149 8.149 0 0 1 2.316.7 9.082 9.082 0 0 1 1.376 2.109 15.446 15.446 0 0 0 7.563 8.162l.437.215.474.089a14.639 14.639 0 0 0 10.635-1.96 8.262 8.262 0 0 1 2.405-.888 8.533 8.533 0 0 1 2.472.925 18.627 18.627 0 0 0 7.526 2.331l.155.015h.185a9.794 9.794 0 0 0 3.16-.525l.229-.074.215-.111a15.421 15.421 0 0 0 7.57-8.185 9.2 9.2 0 0 1 1.376-2.1 8.03 8.03 0 0 1 2.309-.7 14.943 14.943 0 0 0 9.82-5l.3-.326.2-.392a15.981 15.981 0 0 0 1.487-10.982 10.04 10.04 0 0 1-.059-2.745 8.957 8.957 0 0 1 1.48-1.976 15.953 15.953 0 0 0 5.121-10.049l.044-.407Zm-47.751 15.655-15.387-16.081 5.454-5.683 9.933 10.353 18.342-19.108 5.458 5.706Z"
          />
        </g>
      </g>
    </g>
  </svg>
);

export default OfflineRegistrationIcon;
