// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const SelectAllIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <path
      d="M99.18,223A7.66,7.66,0,0,1,92.42,219L77.91,191.41c-6.34-12-13-24.57-15.72-29.84h0l-1-2,0,0-.31-.58h0c-3.09-6.75,3.06-10.09,3.12-10.12A7.48,7.48,0,0,1,74.09,152l0,0,.37.7,0,0L100.43,202c22-31.37,93.39-144.89,121-189.3h0a.61.61,0,0,0,.07-.1l.24-.4h0A7.61,7.61,0,0,1,230.32,9a19.44,19.44,0,0,1,3,1.21s.69.74,1.37,1.5a6.63,6.63,0,0,1,.93,2.73s.61,3.62-1.21,5.67l.07,0-.31.49,0,0c-.93,1.6-2.46,4-5,8.05-3.39,5.43-8.24,13.18-14.07,22.48-10.65,17-26.76,42.59-43.08,68.29-18.35,28.88-33.19,52-44.13,68.58-22.22,33.77-23.42,34-27,34.86A7.64,7.64,0,0,1,99.18,223Zm-30.35-64L71,163.15Z"
      transform="translate(-18.77 -7.2)"
    />
    <path
      d="M99.18,224.54a9.09,9.09,0,0,1-8.08-4.86L58.81,158.4l.17-.09c-2.34-7.14,4.23-10.72,4.3-10.76a8.91,8.91,0,0,1,11.29,2.54l.15-.08,1.09,2,24.8,47.08C123.8,165.54,192,57.25,220.17,11.9l1.08-1.73.14.08a9.06,9.06,0,0,1,9.29-2.73A21.56,21.56,0,0,1,234,8.85l.24.12.18.2s.7.75,1.4,1.52a7.38,7.38,0,0,1,1.3,3.55c.06.35.57,3.76-1.12,6.26l-.54.91-.79,1.28,0,0c-.94,1.57-2.28,3.71-4.19,6.77-3.39,5.42-8.24,13.17-14.08,22.48-10.68,17-26.82,42.68-43.08,68.29-18.37,28.93-33.23,52-44.15,68.61-22.55,34.27-23.79,34.55-27.92,35.49A8.66,8.66,0,0,1,99.18,224.54ZM62.35,158.65l.12.24,31.28,59.39a6.17,6.17,0,0,0,6.79,3.11c3-.68,4.2-1,26.09-34.22,10.91-16.59,25.75-39.66,44.11-68.57C187,93,203.14,67.34,213.82,50.32c5.83-9.3,10.68-17,14.07-22.47,2.14-3.42,3.55-5.68,4.5-7.26l-.21-.13,1-1.24.41-.72.07,0a7.12,7.12,0,0,0,.47-3.87,5.71,5.71,0,0,0-.57-2l-1.16-1.27a17.3,17.3,0,0,0-2.46-1A6.11,6.11,0,0,0,223,13.06l-.3.44c-28.8,46.29-99.28,158.28-121,189.35l-1.41,2L72.81,152.82c-3.09-5.07-7.63-2.88-8.13-2.62a6,6,0,0,0-2.46,8.18Zm7.29,5.2-2.14-4.07,2.66-1.4,2.14,4.07Z"
      transform="translate(-18.77 -7.2)"
    />
    <path
      d="M226.15,50.25,223.65,54a12,12,0,0,1,5.09,9.78v165a12,12,0,0,1-12,12h-178a12,12,0,0,1-12-12v-165a12,12,0,0,1,12-12H187l3-4.5H38.77a16.52,16.52,0,0,0-16.5,16.5v165a16.52,16.52,0,0,0,16.5,16.5h178a16.52,16.52,0,0,0,16.5-16.5v-165A16.5,16.5,0,0,0,226.15,50.25Z"
      transform="translate(-18.77 -7.2)"
    />
    <path
      d="M216.74,248.8h-178a20,20,0,0,1-20-20v-165a20,20,0,0,1,20-20H196.53l-7.64,11.5H38.77a8.51,8.51,0,0,0-8.5,8.5v165a8.51,8.51,0,0,0,8.5,8.5h178a8.51,8.51,0,0,0,8.5-8.5v-165a8.54,8.54,0,0,0-3.61-6.93l-2.77-2,6.36-9.56,2.93,2a20,20,0,0,1,8.59,16.41v165A20,20,0,0,1,216.74,248.8Z"
      transform="translate(-18.77 -7.2)"
    />
    <path
      d="M224.24,63.79v165a7.5,7.5,0,0,1-7.5,7.5h-178a7.51,7.51,0,0,1-7.5-7.5v-165a7.51,7.51,0,0,1,7.5-7.5H184l3-4.5H38.77a12,12,0,0,0-12,12v165a12,12,0,0,0,12,12h178a12,12,0,0,0,12-12v-165A12,12,0,0,0,223.65,54l-2.48,3.74A7.48,7.48,0,0,1,224.24,63.79Z"
      transform="translate(-18.77 -7.2)"
    />
    <path
      d="M216.74,244.3h-178a15.52,15.52,0,0,1-15.5-15.5v-165a15.52,15.52,0,0,1,15.5-15.5H193.54l-7.65,11.5H38.77a4,4,0,0,0-4,4v165a4,4,0,0,0,4,4h178a4,4,0,0,0,4-4v-165a4,4,0,0,0-1.65-3.22l-2.69-2,6.34-9.52,2.94,2.09a15.52,15.52,0,0,1,6.56,12.63v165A15.51,15.51,0,0,1,216.74,244.3Z"
      transform="translate(-18.77 -7.2)"
    />
  </svg>
);

export default SelectAllIcon;
